# -*- coding: utf-8 -*-
# To-Do: Implementieren von:
#           Entpacken der AutoCAD-Containern vor dem Konvertieren von DXF usw. 

import re
import os
from os import chdir, getcwd, listdir, path
from os import walk
import comtypes.client 
import xlsx2csv
import logging
from PIL import Image
import fileinput

##########################
#### PFADE DEFINIEREN ####
##########################

#### FIX in Python definiert: ####

#path = r'C:\Users\Brigit\Documents\00_Gery\87007.15.01_Bergbaurevier_Schwaz-Brixlegg'
#acmecadconvert = r"C:\Software\AcmeCADConverter\AcmeCADConverter.exe"
#pdf24path = r"C:\Software\pdf24-DocTool.exe.lnk"
#profile = r"user/pdfa"
#iconv = r"C:\Software\iconv\bin\iconv.exe"
#Ordnername = "87007.15.01_Bergbaurevier_Schwaz-Brixlegg"
#DOI = "DOI"

#### Definiert durch Eingabe in Kommandozeile: ####
path = input("Massnameordner angeben: ")
acmecadconvert = input("AcmeCADConverter.exe hierherziehen: ")
pdf24path = input("pdf24-DocTool.exe hierherziehen. ACHTUNG: DARF KEINE LEERZEICHEN BEINHALTEN!! ")
profile = r"user/" + input("Name des Profiles für PDF-As eingeben: ")
iconv = input("Hier iconv.exe herziehen: ")
Ordnername = input("Hier der Name des übergeordneten Massnahmeordners eingeben: ")
DOI = input("Hier die DOI eingeben: ")

## Logging:
log = input("Hier leeres Textfile als Logfile angeben: ")
logging.basicConfig(filename=log, level=logging.INFO, format='%(asctime)s %(message)s', datefmt='%d/%m/%Y %H:%M:%S')


###############################################################
#### ERSETZEN VON ALLEN LEERZEICHEN (braucht es für PDF24) ####
###############################################################

#### Alle Dateien:
for dirpath, dirnames, filenames in os.walk(path):
    for f in filenames:
        if ' ' in f:
            newfilename = f.replace(" ", r"_")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + newfilename)
            print("Umbenennung von", f, "nach", newfilename)
            logging.info("Umbenennung Datei: " + f + "->" + newfilename)
            os.rename(in_file, new_file)

#### Alle Ordner:
for dirpath, dirnames, filenames in os.walk(path, topdown = False):
    for d in dirnames:
        if ' ' in d:
            newdirname = d.replace(" ", r"_")
            in_folder = os.path.join(dirpath, d)
            new_folder = os.path.join(dirpath, newdirname)
            print("Umbenennung von", d, "nach", newdirname)
            logging.info("Umbenennung Ordner " + d + " -> " + newdirname)
            os.rename(in_folder, new_folder)

#################################################
#### ENTPACKEN DER AUTOCAD CONTAINERN (.EXE) ####
#################################################


###################################################
#### ABSPEICHERN ALLER DXFs ALS SVGs UND PDFs: ####
###################################################
            
for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        ## dxf zu svg
        if f.lower().endswith("dxf"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 101 /a -2 " + in_file
            os.system(cmd)
            logging.info("dxf zu svg " + f + "->" + f.replace(".dxf", r".svg"))
        ## dxf zu pdf
        if f.lower().endswith("dxf"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 104 /a -2 /layer /pdf tshe " + in_file
            os.system(cmd)
            logging.info("dxf zu pdf " + f + "->" + f.replace(".dwg", r".pdf"))

########################################################
#### ABSPEICHERN ALLER DWGs ALS DXFs, SVGs UND PDF: ####
########################################################
            
for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        ## dwg zu dxf:
        if f.lower().endswith("dwg"):
            new_name = f.replace(".dwg", r".dxf")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = acmecadconvert + " /r /x14 " + in_file + " " + new_file
            os.system(cmd)
            logging.info("dwg zu dxf " + f + "->" + new_name)
        ## dwg zu svg:
        if f.lower().endswith("dwg"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 101 /a -2 " + in_file
            os.system(cmd)
            logging.info("dwg zu svg " + f + "->" + f.replace(".dwg", r".svg"))
        ## dwg zu pdf:
        if f.lower().endswith("dwg"):
            in_file = os.path.abspath(dirpath + "\\" + f)
            cmd = acmecadconvert + " /r /ls /f 104 /a -2 /layer /pdf tshe " + in_file
            os.system(cmd)
            logging.info("dwg zu pdf " + f + "->" + f.replace(".dwg", r".pdf"))

######################################################################################
#### ERSETZEN ALLER PDFs ZU PDF-A, Achtung: Alle originalen PDFs werden gelöscht! ####
######################################################################################      

for dirpath, dirnames, filenames in os.walk(path):
        print (dirpath)
        for f in filenames:
            if f.lower().endswith("pdf"):
                new_name = f.replace(".pdf", r"_pdfa.pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                cmd = pdf24path + " -convertToPDF " + "-outputFile " + new_file + " -profile " + profile + " " + in_file
                os.system(cmd)
                logging.info("pdf zu pdf-a " + f + "->" + new_name)
                os.remove(in_file) ## Falls die originalen PDFs NICHT gelöscht werden sollen: Zeile inaktiv schalten durch "#"
                logging.info("pdf gelöscht " + f)

##########################################################################################
#### NEU ABSPEICHERN ALLER WORD-FILES ALS PDF-A, Achtung: braucht installiertes Word! ####
##########################################################################################
   
try:
    word = comtypes.client.CreateObject('Word.Application')
    for dirpath, dirnames, filenames in os.walk(path):
        print (dirpath)
        for f in filenames:
            if f.lower().endswith(".docx"):
                new_name = f.replace(".docx", r".pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                doc = word.Documents.Open(in_file)
                doc.ExportAsFixedFormat(
                    OutputFileName=new_file,
                    ExportFormat=17, #17 = PDF output, 18=XPS output
                    OpenAfterExport=False,
                    OptimizeFor=0,  #0=Print (higher res), 1=Screen (lower res)
                    CreateBookmarks=1, #0=No bookmarks, 1=Heading bookmarks only, 2=bookmarks match word bookmarks
                    DocStructureTags=True,
                    UseISO19005_1 = True #Wenn True dann PDF-A
                    );
                doc.Close()
                logging.info("docx zu pdf-a " + f + " " + new_name)
                os.remove(in_file)
                logging.info("docx gelöscht " + f)
            if f.lower().endswith(".doc"):
                new_name = f.replace(".doc", r".pdf")
                in_file = os.path.abspath(dirpath + "\\" + f)
                new_file = os.path.abspath(dirpath + "\\" + new_name)
                doc = word.Documents.Open(in_file)
                doc.ExportAsFixedFormat(
                    OutputFileName=new_file,
                    ExportFormat=17, #17 = PDF output, 18=XPS output
                    OpenAfterExport=False,
                    OptimizeFor=0,  #0=Print (higher res), 1=Screen (lower res)
                    CreateBookmarks=1, #0=No bookmarks, 1=Heading bookmarks only, 2=bookmarks match word bookmarks
                    DocStructureTags=True,
                    UseISO19005_1 = True #Wenn True dann PDF-A
                    );
                doc.Close()
                logging.info("doc zu pdf-a " + f + "->" + new_name)
                os.remove(in_file)
                logging.info("doc gelöscht " + f)
finally:
    word.Quit()


#########################################
#### ABSPEICHERN DER EXCELs ALS CSVs ####
#########################################
    
for dirpath, dirnames, filenames in os.walk(path):
    print (dirpath)
    for f in filenames:
        if f.lower().endswith(".xlsx"):
            new_name = f.replace(".xlsx", r".csv")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            #Xlsx2csv(all, in_file, outputencoding="utf-8", delimiter="tab").convert(new_file)
            cmd = "xlsx2csv.py -d tab -a " + in_file + " " + new_file
            os.system(cmd)
            logging.info("xlsx zu csv " + f + "->" + new_name)
for dirpath, dirnames, files in os.walk(path):  
    for name in files:  
        filename = os.path.join(dirpath,name)   
        if os.stat(filename).st_size == 0:  
            print(filename + " wird gelöscht, da leer")  
            os.remove(filename)
            logging.info("leeres csv gelöscht " + filename)

#######################
#### TXT ALS UTF-8 ####
#######################

for dirpath, dirnames, files in os.walk(path):
    for f in files:
        if f.endswith("TXT"):
            new_name = f.replace(".TXT", r"_utf8.txt")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = iconv + " -f cp1252 -t utf-8 " + in_file + " > " + new_file
            os.system(cmd)
            os.remove(in_file) ##ACHTUNG: Alle Ausgangsfiles werden gelöscht!
            logging.info("txt in utf-8 konvertiert " + f)
        if f.endswith("txt"):
            new_name = f.replace(".txt", r"_utf8.txt")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            cmd = iconv + " -f cp1252 -t utf-8 " + in_file + " > " + new_file
            os.system(cmd)
            os.remove(in_file) ##ACHTUNG: Alle Ausgangsfiles werden gelöscht!
            logging.info("txt in utf-8 konvertiert " + f)

###################################
#### PNGs zu TIFs konvertieren ####
###################################

for dirpath, dirnames, filenames in os.walk(path):
    print(dirpath)
    for f in filenames:
        if f.lower().endswith("png"):
            new_name = f.replace(".png", r".tif")
            in_file = os.path.abspath(dirpath + "\\" + f)
            new_file = os.path.abspath(dirpath + "\\" + new_name)
            img = Image.open(in_file)
            img.save(new_file)
            logging.info("png zu tif konvertiert " + f + "->" + new_name)
            

#################################
#### METADATENFILE ERSTELLEN ####
#################################

os.chdir(path)

metadata = open(path + "\\metadaten.txt", "w")
lineno = 0

for subdir, dirs, files in os.walk('.'):
    lineno +=1
    rel_dir = os.path.relpath(subdir)
    #print(lineno, "+", rel_dir)
    metadata.write(Ordnername + "/" + rel_dir + "\t" + DOI + "_" + str(lineno) + "\n")
    for file in files:
        lineno +=1
        rel_file = os.path.join(rel_dir, file)
        #print(lineno, "+", rel_file)
        metadata.write(Ordnername + "/" + rel_file + "\t" + DOI + "_" + str(lineno) + "\n")
        
        
metadata.close()

for line in fileinput.FileInput(path + "\\metadaten.txt", "w"):
    line = line.replace("\\", "/")
    print(line)
