#pragma rtGlobals=1		 // Use modern global access method.
#pragma version=20180526 // YYYYMMDD

// Modifications by Martin Gysel are tagged 'martin.gysel@psi.ch'
// Modifications by Marie Laborde are tagged 'marie.laborde@psi.ch'
// Modifications by Joel C. Corbin [>v4111] are tagged 'jcc' or joel.c.corbin+sci@gmail.com

//*************************************************************************************************************************************************
Function TopOfSP2_toolit_Procs() 
	//The only purpose of this function is to be the reference point for opening this procedure window from the menu bar.
	//=> leave this function at the top of the procedure window
End
//*************************************************************************************************************************************************

//////////////// Note: As of v4.110, there is a Changelog notebook in the Igor file!///////////////////////////////////////

// v4.115: NOTE THAT THESE FUNCTION LISTS MAY NOT BE COMPLETE. USE THE PROCEDURE BROWSER TO SEE ALL. (SP2 MENU, JTOOLS)

////////////////FUNCTIONS WHICH ARE NOT YET QUITE READY OR NOT ON THE TOOLKIT PANEL///////////////////////////////////////
	//preparing calibration curves for purely scattering particles
		//SP2_SIGvsDp_to_DpVsLogSIG()
	//analyse calibration measurement:
		//various
			//SP2_CalibrationAnalyzer090113()
			//MatSlider090113()
			//SD_Mass_Table()
			//SD_numb_Table()
		//converting calibration curves between different calibration materials
			//SP2_calibAquadag2Fullerene
		//bandratio curve from broadband and narrowband curves
			//SP2_calibBroadAndNarr2Bandratio
	//LEO-fit and similar
		//getting SPHG beam shape:
			//SP2_LEOgetSPHGBeamShape
		//time-resolved sizing
			//SP2_TimeResolvedSizing()
			//SP2_TimeResSlider()
	//graphs under construction
		// CoincidenceGraph
		// LEOfitLastPtVsBroadPkPosGraph
		// plotParticleBeamAlignment -- for detector block alignment

	
////////////////////// SP2 toolkit CODE STRUCTURE ///////////////////////////
//	//accessing waves
//	SP2_accessAllWaves.
//
//	channel definitions
//	SP2_ChanListAllDAQ
//	SP2_ChanListAllEnabledDAQ
//	SP2_ChanListScattOnly
//	SP2_ChanListIncandOnly
//	SP2_ChanListSplitOnly
//	SP2_ChanListCombIncandOnly
//	SP2_ChanListCombIncandLowMass
//	SP2_ChanListCombIncandHighMass
//	SP2_ChanListCombScattOnly
//	SP2_ChanListCombScattLowDiam
//	SP2_ChanListCombScattHighDiam
//	SP2_ChanListCombPSDonly
//	SP2_ChanListCombPSDlowGain
//	SP2_ChanListCombPSDhighGain
//	SP2_ChanListIceCoreSummary()
//	SP2_ChanListToDescrShortList
//	SP2_ChanListToDescrLongList
//	SP2_ChanListToColourList
//	SP2_ChanListToChanBitList
//	SP2_ChanListToAbbrevList
//	SP2chanPrefix2chanProperty
//	SP2chanBit2chanPrefix
//	
//	//Loading, analysing and postprocessing of data
//	SP2_LoadRawData
//		SP2_load_multiple_days
//		SP2_Load_BinaryFile_MT
//			SP2_Load_ParseAuxData_TS
//			SP2_Load_ParseResData_TS
//			SP2_Load_ParseSpareData_TS
//			SP2_Load_ParseTrace1Chan_TS
//			SP2chanConfig2chanOrder
//			SP2_LoadConfigFile
//				SP2_ParseConfigFile
//				SP2_CreateConfigDataWaves
//			SP2_LoadHouseKeepingFileFast
//		SP2sampleFlowGetData
//		SP2_YAGpowerGetHKdata
//		SP2_AnalyseRawTraces
//			SP2_TA_Scattering_MT
//				SP2_TA_GetBaseline_TS
//				SP2_TA_FitGaussian_TS
//				SP2_TA_FitPeakScatt_TS
//			SP2_TA_Incand_MT
//				SP2_TA_FitPeakIncand_TS
//			SP2IncandGaussianBaselineFit
//			SP2_TA_PSD_MT
//			SP2_traceAnalysisMatrices
//			SP2_BandRatioFromTraceArea
//			SP2_LEOfitTraceAnalysisButt
//				SP2_LEO_TA_FitMain_MT
//					SP2_LEO_fit_BeamShapePrep_MT
//					SP2_LEO_FitWorker_ShapeSlow_TS
//						SP2_LEO_Fit_Shape_MT_aaoFfkt
//					SP2_LEO_FitWorker_Gaussian_TS
//					SP2_LEO_FitWorker_ShapeFast_TS
//				SP2_LEOverificationAndSizing
//					SP2_LEO_GetRefChanPrefix
//					SP2_LEOclassificationWaveCalc
//						SP2_LEOclassificationWaveName
//					SP2_LEOPeakHt2DoptCoatedBC
//					SP2_LEOpostProcButt
//					SP2_LEOperformanceStats
//						SP2_LEOperformanceStats1Chan
//						SP2_LEO_RetrieveRefChanPrefix
//			SP2_DeleteRawTraces
//			SP2_PBPpostprocessing
//				SP2sampleVolumeWaveCalc
//				SP2_ClassificationWaveCreator
//					SP2rawDataMainMaskPrep
//				SP2scattPeakHt2OptDiamNoCore
//				SP2_calibCurveSplineCheck
//				SP2peakHt2BCmass
//				SP2bcMass2diam
//				SP2_LogNormFitButt
//					SP2_LogNormSizeDistrFit
//				SP2_ConcTimeSeriesExtractor
//					SP2_ClassificationWaveCreator
//					SP2sampleVolumeWaveCalc
//					SP2_Conc_Time_Series_graph
//				SP2_SizeDistTimeSeriesExtractor
//					SP2_ClassificationWaveCreator
//					SP2sampleVolumeWaveCalc
//					SP2_LogNormFitSDtimeSeries
//						SP2_LogNormSizeDistrFit
//					SD_LogNormFitMassSlider
//					SD_LogNormFitNumbSlider
//				SP2_LEOfitPreparation
//					SP2_LEOgetBeamShape
//				SP2_LEOverificationAndSizing		//see above for sub-procedures of SP2_LEOpostProcessing	
//		SP2_ConcatenateRawDataFldrs
//		SP2_ConcatenateHKfldrs
//
//	//loading housekeeping data
//		//SP2_LoadHKfiles
//			//SP2_LoadHouseKeepingFileV3
//			//SP2_ConcatenateHKfldrs
//
//	//further post processing
//		//LEO fit
//			//preparation
//			SP2_LEOfitPreparation
//				SP2_LEOgetBeamShape
//		//scattering signal at incandescence peak
//			SP2_ScattAtIncNormalize
//			SP2_ScattAtIncOptSizing
//		//band ratio statistics
//			SP2_PBPbandratioStats
//		//delay time statistics
//			SP2_PBPscatt2broadDelayNumbFr
//			SP2_PBPscatt2broadDelayHisto
//	
//		//Classisfication
//			SP2_ClassificationNote2CutOff	
//		//delete data
//			SP2_DeleteDataTimeRange
//				SP2_DeleteDataIndexRange
//		//check folders
//			SP2_check_IsRawFldr
//			SP2_check_IsPBPfldr
//			
//	
//	//analysing calibration
//		//all channels:
//			//creating dummy waves for calibration coefficients (all channels)
//				SP2_Calib_DummyCalibCoeffButt
//			//calculating calibration curves from calibration coefficients
//				SP2_Calib_AddCalibCurveWavesBtt
//		//incandescence channels
//				SP2_CalibBCinfoWavesPrepButt
//				SP2_CalibAnalyzerIncandMono
//					SP2_CalibInfogetTimesButt
//					FullereneSoot_Diam2Mass
//					GlassyCarbonAlpha_Diam2Mass
//					AquaDag_Diam2Mass
//					AquaBlack162Tokai_Diam2Mass
//					SP2_PBPbandratioStats
//					SP2_CalibrationAnalyzerSlider
//					SP2_CalibBCSizeDistSlider
//				SP2calib_FitCalCurve
//				SP2_calibCurveSpline					//no button
//				SP2calibHighMass2LowMassCoef		//not anymore used
//		//scattering channels
//			SP2_CalibScattInfoWavesPrepButt
//			SP2_CalibAnalyzerScatt
//				SP2_CalibInfogetTimesButt
//				SP2_CalibAnalyzerScattpostproc
//				SP2_CalibrationAnalyzerSlider
//			SP2_calibCurveScattChanCalc		//not included in any function of the toolkit panel
//		//loading DMA data
//			//loading CPC-DMA-logger data
//				LoadRawDataCPCDMAOneFile		//this procedure is not SP2_toolkit specific
//				SP2_calib_CPCDMAdataPrepButt
//			//loading DMPS data
//				//load from file
//					SP2_DMPSdataLoaderButt
//						SP2_calib_DMPSdataPrepButt
//				//prepare empty dummy matrices
//					SP2_calib_DMPSdataDummyWavsButt
//
//	//ice core analysis
//		//preparing waves for batch load
//			SP2batchLoadWavesPrepButt
//		//batch load
//			SP2batchLoadBtt
//				SP2_LoadRawData
//				SP2batchLoadExtractSummaryBtt
//					SP2_PBPpostprocessing
//					SP2_CETAC_calc_LiquidConcBtt
//		//not accessible through toolkit panel:
//			SP2_CETAC_NumbConcCalc_Forward(LiqNumbConc, LiqSupplyRate, NebulizingEff, DryerEff, PurgeAirFlowRate)
//	
//	//graph procedures
//		SP2_graphbutt
//			//various
//				ShowSP2traceCorresp2CursorA
//			//raw data
//				SP2graph_RawTracePlusFitSlider
//				SP2_Graph_HK_vs_time
//			//PBP
//				//general
//					SP2graph_NumbSizeDistrBC
//					SP2graph_MassSizeDistrBC
//					SP2graph_NumbSizeDistrScatt
//					SP2graph_BCmass_NarrVsBroad
//					SP2graph_BandratioVsBroadpkht
//					SP2graph_NumbFractThinVsBroadPH
//					SP2graph_DelaytimeVsBroadPH
//					SP2graph_DelaytimeHistogram
//				//time series graphs
//					SP2_Conc_Time_Series_graph
//					SD_LogNormFitMassSlider
//					SD_LogNormFitNumbSlider
//					SD_NumbSizeDistScattSlider
//			//ice core analysis
//				SP2graph_IceCoreSummary
//				SP2graph_IceCoreSummarySlider
//			//calibration
//				SP2graph_IncandCalibResults
//				SP2graph_BandRatioCalibResults
//				SP2graph_CountEffCalibResults
//				SP2_CalibrationAnalyzerSlider
//					SP2_CalibBCanalyzerSlider
//						SP2_CalibBCgraphOptProc
//						SP2_CalibGraphGetPeakButt
//					SP2_CalibScattAnalyzerSlider
//						SP2_CalibScattGraphOptProc
//						SP2_CalibGraphGetPeakButt
//				SP2_CalibBCSizeDistSlider
//				SP2graph_ScattCalibFact
//			//LEO-fit
//				//diagnosis
//					SP2_LEOgr_BeamShapeStats
//					SP2_LEOgr_FWHMandSplitPt
//					SP2_LEOgr_Split2CentrePosVsTime
//					SP2_LEOgr_SplitDeltaVsSCHGpkht
//					SP2_LEOgr_SplitVsSCHGbeamPos
//					SP2_LEOgr_IncandDelayVsBBHGpkHt
//					SP2_LEOgr_IncandDelayVsSplitNeg
//				//verification
//					SP2_LEOgr_VerificationAllChan
//						SP2_LEOgr_Verification1Chan
//				//main results
//					SP2_LEOgr_BCvolFractHistogram
//					SP2_LEOgr_BCcoatThicknHistogram
//					SP2_LEOgr_DelayTimeHistogram
//					SP2_LEOgr_OptSizeDistr
//					SP2_LEOgr_OptSizeDistrButt	
//					SP2_LEOgr_OptNumbFractSizeDistr
//					SP2_LEOgr_OptNumbFracSizeDiBtt
//			//SAI (scattering at incandescence)
//					SP2_SAIgr_ScattAmpVsIncPkHt
//					SP2_SAIgr_BCdiamScatterPlot
//	//table procedures
//		SP2_tabletypelistcreator
//		SP2_tablebutt
//			SP2table_IceCoreSummary
//			SP2table_CalibInfoMonodispBC
//			SP2table_CalibIncandFitPkHt
//			SP2table_CalibCoef
//			SP2_LEOtbl_NumbConcByType
//			SP2_LEOtbl_NumbConcByTypeBtt
//
//
//	//panel procedures
//		//creating the main panel
//			SP2_panel_PSI()
//				SP2panelPSIMainTabProc
//					SP2panelPSISubTabTAProc
//					SP2_SelectCalibFldrPMproc
//		//button procedures
//			SP2sampleFlowGetDataBtt
//		//checkbox procedures
//			SP2_CheckboxEnabDisabControls
//			SP2_SampleFlowModeCBproc
//			SP2_YAGpowerModeCBproc
//			SP2_PretriggerAvgCBproc
//			SP2_LEOdiamLimitModeCBproc
//			SP2_LEOfitFastFitCBproc
//		//pop-menu procedures
//			SP2_SelectCalibFldrPMproc
//				SP2_CalibListUpdate
//			SP2_SAIselectIncPrefixPMproc
//			SP2_SelectScattRefractPMproc
//				SP2_MiePureScattDataFldrList
//			SP2_SelectLEOsplitPosPrefixPM
//			SP2_PanelLEOcalibRefScattChanPM
//			SP2_SelectLEORefractpairPMproc
//				SP2_MieCoatedBCdataFldrList
//			SP2_SelectLEOincandPrefixPMproc
//			SP2_SAIselectPSDchanPrefixPM
//			SP2_graphtypePMlistrawdata
//			SP2_graphtypePMlistanalyseddata
//			SP2_graphtypePMlistcalibdata
//			SP2_graphtypePMlistTserData
//			SP2_graphtypePMlistLEOdata
//			SP2_graphtypePMlistSAIdata
//			SP2_graphtypePMlistIcecoreData
//			SP2panelPSItabletypeProc
//			SP2panelPSIChanConfigProc
//
//
//	//data folders
//		//SP2_RawFldrFP2CalibSummfldrFP
//		//SP2_RawFldrFP2HKfldrFP
//		//SP2_RawFldrFP2iniFldrFP
//		//SP2_RawFldrFP2PBPfldrFP
//		//SP2_PBPfldrFP2RawFldrFP
//		//SP2_PBPfldrfp2LEOfldrfp
//		//SP2_LEOfldrfp2PBPfldrfp



/////////////////SOME USEFUL COMMAND LINES////////////////////////////////////////
//	//optional filtering of time windows
//		setdatafolder root:'YYYYMMDDxnnn_SP2'
//		Mask_BadDataMain=0	//reset all previous filtering
//		make /o/n=(numpnts(TimeDate)) Mask_PeriodToBeFiltered=0
//		MaskTimeIntervalTStr(TimeDate, Mask_PeriodToBeFiltered, "11.01.2011 00:00:00", "11.01.2011 00:00:01", BadVal=1)	//filter time period
//		Mask_BadDataMain = Mask_BadDataMain || Mask_PeriodToBeFiltered		//combine the two masks with logical OR
//	//removing time jumps of 24h from time waves of SP2-.HK and SP2-.SP2 files
//		SP2_TimeStampCleaner()
//	//applying time shift to CPC-DMA data:
//		make /o/n=1 TimeShift=5; TimeCentre+=TimeShift; TimeEnd+=TimeShift; TimeStart+=TimeShift
//	//remapping CPC-concentration to Calib-Info-Folder:
//		RemapTimeSeriesSimpleVar(root:CPCDMA20100607:CPCconc, root:CPCDMA20100607:TimeCentre, TimeStartList, TimeEndList, ConcList)
//	//remapping YAG-power to Calib-Info-Folder:
//		RemapTimeSeriesSimpleVar(root:'20100616x063_SP2_HK':YAGPower_V, root:'20100616x063_SP2_HK':TimeStamp, TimeStartList, TimeEndList, LaserPowerList)
//	//calculating diameter from measured peak height
//		Dp = DpVsLogSIG_PSL(log(peakheight/laserpower/calibrationfactor))


////////BEGIN OF MAIN CODE////////////////////
Function SP2_accessAllWaves()
	variable ChanID
	string ChanPrefix=ksSP2SPHGprefix
	//panel
	setdatafolder $ksSP2PathToToolkitPanelFldr
		//multiple tabs
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		Svar CalibFldr=$ksSP2calibFldr	
		//load tab
		Nvar SampleFlowPanel=$ksSP2sampleFlowPanel
		Nvar SampleFlowMode=$ksSP2sampleFlowMode
		Nvar YAGpowerPanel=$ksSP2YAGpowerpanel
		Nvar YAGpowerMode=$ksSP2YAGpowerMode
		Nvar YAGpowerModeInv=$ksSP2YAGpowerModeInv
		Nvar LoadType=$ksSP2LoadType
		Nvar LoadFractMode=$ksSP2LoadFractMode
		Nvar LoadFractModeInv=$ksSP2LoadFractModeInv
		Nvar LoadMaxDataRate=$ksSP2LoadMaxDataRate
		Nvar LoadOneOutOf=$ksSP2LoadOneOutOf
		Nvar LoadConcatMode=$ksSP2loadConcatMode
		Nvar LoadHKmode=$ksSP2loadHKmode
		Nvar analyseTraces=$ksSP2analyseTraces
		Nvar performLEOfit=$ksSP2performLEOfit
		Nvar rawdatadelmode=$ksSP2rawdatadelmode
		Nvar postprocessing=$ksSP2postProcessing
		Nvar lognormfit=$ksSP2lognormfit
		Nvar ExtractConcTimeSer=$ksSP2extractConcTimeSer
		Nvar ExtractSizeDistTimeSer=$ksSP2extractSDTimeSer
		Nvar LoadHKtype=$ksSP2LoadHKtype
		Nvar LoadHKconcatMode=$ksSP2loadHKconcatMode
		Nvar LoadHKremapMode=$ksSP2loadHKremapMode
		Nvar LoadHKremapInt=$ksSP2loadHKremapInt
		//calib tab
		Nvar CalibBetaDMA=$ksSP2calibBetaDMA
		Nvar CalibMatBCdensity=$ksSP2calibMatBCdensity
		Svar CalibMatBCtype=$ksSP2calibMatBCtype
		//trace analysis tab
		Nvar fitscatt=$ksSP2fitSCHGchan
		Nvar fitbroad=$ksSP2fitBBHGchan
		Nvar fitnarr=$ksSP2fitNBHGchan
		Nvar fitsplit=$ksSP2fitSPHGchan
		Nvar fitscattLG=$ksSP2fitSCLGchan
		Nvar fitbroadLG=$ksSP2fitBBLGchan
		Nvar fitnarrLG=$ksSP2fitNBLGchan
		Nvar fitsplitLG=$ksSP2fitSPLGchan
		Nvar SubTabTAval=$ksSP2subTabTAval	
		Nvar scattfittype=$ksSP2scattfittype
		Nvar scattFitnPts4Peak=$ksSP2scattFitnPts4Peak
		Nvar incfittype=$ksSP2incfittype
		Nvar incFitnPts4Peak=$ksSP2incFitnPts4Peak
		Nvar incFitMatchNarr2Broad=$ksSP2incFitMatchNarr2Broad
		Nvar BaselineFilterModeSCHG=$ksSP2baselineFiltermodeSCHG
		Nvar BaselineFilterModeBBHG=$ksSP2baselineFiltermodeBBHG
		Nvar BaselineFilterModeNBHG=$ksSP2baselineFiltermodeNBHG
		Nvar BaselineFilterModeSPHG=$ksSP2baselineFiltermodeSPHG
		Nvar BaselineFilterModeSCLG=$ksSP2baselineFiltermodeSCLG
		Nvar BaselineFilterModeBBLG=$ksSP2baselineFiltermodeBBLG
		Nvar BaselineFilterModeNBLG=$ksSP2baselineFiltermodeNBLG
		Nvar BaselineFilterModeSPLG=$ksSP2baselineFiltermodeSPLG
		Nvar BaselineNoiseAmpSCHG=$ksSP2baselineNoiseAmpSCHG
		Nvar BaselineNoiseAmpBBHG=$ksSP2baselineNoiseAmpBBHG
		Nvar BaselineNoiseAmpNBHG=$ksSP2baselineNoiseAmpNBHG
		Nvar BaselineNoiseAmpSPHG=$ksSP2baselineNoiseAmpSPHG
		Nvar BaselineNoiseAmpSCLG=$ksSP2baselineNoiseAmpSCLG
		Nvar BaselineNoiseAmpBBLG=$ksSP2baselineNoiseAmpBBLG
		Nvar BaselineNoiseAmpNBLG=$ksSP2baselineNoiseAmpNBLG
		Nvar BaselineNoiseAmpSPLG=$ksSP2baselineNoiseAmpSPLG
		Nvar SAIgetIt=$ksSP2SAIgetIt
		Nvar SAItimeLagStart=$ksSP2SAItimeLagStart
		Nvar SAItimeLagEnd=$ksSP2SAItimeLagEnd
		Svar SAIchanPrefixInc=$ksSP2SAIchanPrefixInc
		Nvar PretriggerAvgMode=$ksSP2pretriggeravgmode
		Nvar PretriggerAvgModeInv=$ksSP2pretriggeravgmodeInv
		Nvar PretriggerNumb=$ksSP2pretriggernumb
		//post processing tab
		Nvar BCdensity=$ksSP2BCdensity
		Nvar nHistoBins=$ksSP2nHistobins
		Nvar SCHGminCut=$ksSP2SCHGMinCut
		Nvar BBHGminCut=$ksSP2BBHGMinCut
		Nvar NBHGminCut=$ksSP2NBHGMinCut
		Nvar SPHGminCut=$ksSP2SPHGMinCut
		Nvar SCLGminCut=$ksSP2SCLGMinCut
		Nvar BBLGminCut=$ksSP2BBLGMinCut
		Nvar NBLGminCut=$ksSP2NBLGMinCut
		Nvar SPLGminCut=$ksSP2SPLGMinCut
		Nvar SCHGdetectCut=$ksSP2SCHGdetectCut
		Nvar BBHGdetectCut=$ksSP2BBHGdetectCut
		Nvar NBHGdetectCut=$ksSP2NBHGdetectCut
		Nvar SPHGdetectCut=$ksSP2SPHGdetectCut
		Nvar SCLGdetectCut=$ksSP2SCLGdetectCut
		Nvar BBLGdetectCut=$ksSP2BBLGdetectCut
		Nvar NBLGdetectCut=$ksSP2NBLGdetectCut
		Nvar SPLGdetectCut=$ksSP2SPLGdetectCut
		Nvar calcBHNH=$ksSP2calcBHNH
		Nvar calcBHNL=$ksSP2calcBHNL
		Nvar calcBHBL=$ksSP2calcBHBL
		Nvar calcBLNL=$ksSP2calcBLNL
		Nvar calcSHSL=$ksSP2calcSHSL
		Nvar calcPHPL=$ksSP2calcPHPL
		Svar ScattRefractIndex=$ksSP2scattRefractIndex
		Nvar LogNormFitDmeasMin=$ksSP2LogNormFitDmeasMin
		Nvar LogNormFitDmeasMax=$ksSP2LogNormFitDmeasMax
		Nvar LogNormFitDfitMin=$ksSP2LogNormFitDfitMin
		Nvar LogNormFitDfitMax=$ksSP2LogNormFitDfitMax
		Nvar LogNormFitnPts=$ksSP2LogNormFitnPts
		Nvar ConcInterval=$ksSP2concInterval
		Nvar SDinterval=$ksSP2SDinterval
		Nvar SDnbins=$ksSP2SDnbins
		//LEO fit tab
			//without channel prefix
			Nvar LEOfitRange=$ksSP2LEOfitRange
			Nvar LEOfitMinNumPnts=$ksSP2LEOfitMinNumPts	
			Nvar LEOfitFastFit=$ksSP2LEOfitFastFit
			Nvar LEOfitFastNumPts=$ksSP2LEOfitFastNumPts
			Nvar LEOfitSkipGaussCB=$ksSP2leoFitSkipGaussCB
			Nvar LEOfitSkipBeamShapeCB=$ksSP2leoFitSkipBeamShapeCB
			Nvar LEOfitPostProcModeCB=$ksSP2leoFitPostProcModeCB
			Nvar LEOfitSCHGcb=$ksSP2leoFitSCHGcb
			Nvar LEOfitSCLGcb=$ksSP2leoFitSCLGcb
			Nvar LEOfitSPHGcb=$ksSP2leoFitSPHGcb
			Nvar LEOfitSPLGcb=$ksSP2leoFitSPLGcb
			Svar LEOsplitChanPrefix=$ksSP2leoSplitChanPrefix
			Svar LEOincandPrefix=$ksSP2leoIncandPrefix
			Svar LEOrefractIndexPair=$ksSP2leoRefractIndexPair
			Nvar LEOfitStatsRunCB=$ksSP2leoFitStatsRunCB
			Nvar LEOfitStatsMedianCB=$ksSP2leoFitStatsMedianCB
			Nvar LEOlimitBCdiamCB=$ksSP2leoLimitBCdiamCB
			Nvar  LEOlimitOptdiamCB=$ksSP2leoLimitOptDiamCB
			Nvar  LEOdiamRangeMinSV=$ksSP2diamRangeMinSV
			Nvar  LEOdiamRangeMaxSV=$ksSP2diamRangeMaxSV
			Nvar LEOnumbSizeBinsSV=$ksSP2leoNumbSizeBinsSV
			Nvar LEOnBinsBCvolFracHistSV=$ksSP2nBinsBCVolFracHistSV
			Nvar LEOnBinsCoatThicknHistSV=$ksSP2nBinsBCCoatThicknHistSV
			Nvar LEOnBinsDelayHistSV=$ksSP2nBinsDelayHistSV
			Svar SAIchanPrefixPSD=$ksSP2SAIchanPrefixPSD
			//with channel prefix
			Nvar LEOfitSlopeFudgeResetCB=$ChanPrefix+ksSP2leoFitSlopeFudgeResetCB
			Nvar LEOfitSplitCalFactResetCB=$ChanPrefix+ksSP2leoFitSplitCalResetCB
			Svar LEOsplitCalChanPrefix=$ChanPrefix+ksSP2leoSplitCalChanPrefix
			Nvar MinPeakHtSV=$ChanPrefix+ksSP2leoMinPeakHeightSV
		//ice cores tab
		Nvar CETACsampleflow=$ksSP2CETACsampleflow
		Nvar CETACdrainflow=$ksSP2CETACdrainflow
		Nvar CETACpurgeairflow=$ksSP2CETACpurgeairflow
		//config tab
		Nvar ChanConfig_0=$ksSP2chan0config
		Nvar ChanConfig_1=$ksSP2chan1config
		Nvar ChanConfig_2=$ksSP2chan2config
		Nvar ChanConfig_3=$ksSP2chan3config
		Nvar ChanConfig_4=$ksSP2chan4config
		Nvar ChanConfig_5=$ksSP2chan5config
		Nvar ChanConfig_6=$ksSP2chan6config
		Nvar ChanConfig_7=$ksSP2chan7config
		Nvar loadSCHG=$ksSP2loadSCHGchan
		Nvar loadBBHG=$ksSP2loadBBHGchan
		Nvar loadNBHG=$ksSP2loadNBHGchan
		Nvar loadSPHG=$ksSP2loadSPHGchan
		Nvar loadSCLG=$ksSP2loadSCLGchan
		Nvar loadBBLG=$ksSP2loadBBLGchan
		Nvar loadNBLG=$ksSP2loadNBLGchan
		Nvar loadSPLG=$ksSP2loadSPLGchan
		Nvar invertSPHG=$ksSP2invertSPHGchan
		Nvar invertSPLG=$ksSP2invertSPHGchan
		Nvar MaxSigSCHG=$ksSP2maxSigSCHG
		Nvar MaxSigBBHG=$ksSP2maxSigBBHG
		Nvar MaxSigNBHG=$ksSP2maxSigNBHG
		Nvar MaxSigSPHG=$ksSP2maxSigSPHG
		Nvar MaxSigSCLG=$ksSP2maxSigSCLG
		Nvar MaxSigBBLG=$ksSP2maxSigBBLG
		Nvar MaxSigNBLG=$ksSP2maxSigNBLG
		Nvar MaxSigSPLG=$ksSP2maxSigSPLG
		Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//raw data waves
	wave TimeDiv10000=$ksSP2eventTimeDivPP
	wave TimeRemainder=$ksSP2eventTimeRemainder
	wave TimeStampEvent=$ksSP2eventTimeStamp
	wave TimeWave=$ksSP2timewave
	wave TimeDate=$ksSP2TimeDate
	wave YAGpower=$ksSP2YAGpower
	wave SampleInterval=$ksSP2sampleInterval
	wave SampleFlowRate=$ksSP2sampleFlowRate
	wave SampleVolume=$ksSP2sampleVolume
	wave Mask_BadDataMain=$ksSP2pbpMaskBadData
	wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
	wave TimeElapsedEff=$ksSP2TimeElapsedEff
	wave /d FileID=$ksSP2rawuniquefileID
	wave /d ConfigFileID=$ksSP2correspConfigfileID
	wave ParticleID=$ksSP2particleID
	wave scattTraceMat=$ksSP2SCHGprefix+ksSP2rawtracemat
	wave broadTraceMat=$ksSP2BBHGprefix+ksSP2rawtracemat
	wave narrTraceMat=$ksSP2NBHGprefix+ksSP2rawtracemat
	wave splitTraceMat=$ksSP2SPHGprefix+ksSP2rawtracemat
	wave Res1=$ksSP2rawRes1
	wave Res5=$ksSP2rawRes5
	wave Res6=$ksSP2rawRes6
	wave Res7=$ksSP2rawRes7
	wave Res8=$ksSP2rawRes8
	Svar HKfldrFP=$ksSP2hkFldrFP
	//housekeeping folder
		//variables
		Nvar FileFormatNum=$ksSP2hkFileFormatNum
		//waves		
		wave TimeStampHK=$ksSP2hkTimeStamp
		wave ElapsedTime=$ksSP2hkElapsedTime					//SP2 software version 4.x only
		wave FileIDHK=$ksSP2hkFileID
		wave SampleFlowRead_vccm=$ksSP2hkSampleFlowRead		//SP2 software version 3.x only
		wave SampleFlowSet_vccm=$ksSP2hkSampleFlowSet
		wave YAGPower_V=$ksSP2hkYAGpower
		wave IncandConc_1percc=$ksSP2hkIncandConc
		wave ScatterConc_1percc=$ksSP2hkScatterConc
		wave DutyCycle_perc=$ksSP2hkDutyCycle
		wave SampleFlowLFEv3=$ksSP2hkSampleFlowLFEv3		//SP2 software version 3.x only
		wave SampleFlowLFEv4=$ksSP2hkSampleFlowLFEv4		//SP2 software version 4.x only
		wave PurgeFlowSet_vccm=$ksSP2hkPurgeFlowSet
		wave PurgeFlowRead_vccm=$ksSP2hkPurgeFlowRead
		wave SheathFlowRead_sccm=$ksSP2hkSheathFlowRead
		wave SheathFlowSet_sccm=$ksSP2hkSheathFlowSet
		wave ChamberTemp_C=$ksSP2hkChamberTemp
		wave DiodeTemp_C=$ksSP2hkDiodeTemp
		wave YAGCrystalTemp_C=$ksSP2hkYAGcrystalTemp
		wave YAGHeatSinkT_C=$ksSP2hkYAGHeatSinkT
		wave Chan0HV_V=$ksSP2hkChan0HV
		wave Chan1HV_V=$ksSP2hkChan1HV
		wave Chan2HV_V=$ksSP2hkChan2HV
		wave Chan3HV_V=$ksSP2hkChan3HV
		wave ChamberPressure_mBar=$ksSP2hkChamberPressure

//configuration data folder (".ini")
	setdatafolder $ksSP2configSubFldr
	wave /t DataAll=$ksSP2configdataAll
	wave /d UniqueFileIDini=$ksSP2configUniqueFileIDini
	wave /d UniqueFileIDsp2b=$ksSP2configUniqueFileIDsp2b
	wave Channel1=$ksSP2configChannel1	
	wave Channel2=$ksSP2configChannel2
	wave Channel3=$ksSP2configChannel3
	wave SamplePerSec=$ksSP2configSamplesPSec
	wave PrimaryChanNum=$ksSP2configPrimaryChanNum
	wave SecondaryChanNum=$ksSP2configSecondaryChanNum
	wave UsePrimaryTrigger=$ksSP2configUsePrimaryTrigger
	wave UseSecondaryTrigger=$ksSP2configUseSecondaryTrigger
	wave PrimaryDelta=$ksSP2configPrimaryDelta
	wave SecondaryDelta=$ksSP2configSecondaryDelta
	wave PrimaryTriggerLevel=$ksSP2configPrimaryTriggerLevel
	wave SecondaryTriggerLevel=$ksSP2configSecondaryTrigLevel
	wave NumberOfPoints=$ksSP2configNumberOfPoints
	wave NumberOfPretrigger=$ksSP2configNumberOfPretrigger
	wave ScanLength=$ksSP2configScanLength
	wave Saturation=$ksSP2configSaturation
	wave WriteData=$ksSP2configWriteData
	wave OutOf=$ksSP2configOutOf
	wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
	wave OneOfEverySaved=$ksSP2configOneOfEverySaved
	wave SampleFlowSet=$ksSP2configSampleFlowSet
	wave /t DescriptChan0=$ksSP2configDescriptChan0
	wave /t DescriptChan1=$ksSP2configDescriptChan1
	wave /t DescriptChan2=$ksSP2configDescriptChan2
	wave /t DescriptChan3=$ksSP2configDescriptChan3


	//PBP waves
		//trace analysis
		//	string ChanPrefix=ksSP2SCHGprefix
		//	string ChanPrefix=ksSP2BBHGprefix
		//	string ChanPrefix=ksSP2NBHGprefix
		//	string ChanPrefix=ksSP2SPHGprefix
		//	string ChanPrefix=ksSP2BHNHprefix	
			//infostr
			Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr			
			//all channels
			wave saturated=$ChanPrefix+ksSP2PBPsaturated
			wave TraceFitOffset=$ChanPrefix+ksSP2PBPtracefitOffset
			wave TraceFitPeakHt=$ChanPrefix+ksSP2PBPtracefitPeakHt
			wave TraceFitPeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
			wave TraceFitPeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
			wave TraceFitPeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
			wave TraceFitPeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
			wave TraceFitPeakFWHM=$ChanPrefix+ksSP2PBPtracefitPeakFWHM
			wave TraceFitPeakPos=$ChanPrefix+ksSP2PBPtracefitPeakPos
			//incandescence channel
			wave FittedBLfitError=$ChanPrefix+ksSP2PBPincFittedBLfitError
			//scattering channel Gaussian fit
			wave GaussOffset=$ChanPrefix+ksSP2PBPscattGaussoffset					
			wave GaussPeakHt=$ChanPrefix+ksSP2PBPscattGausspeakHeight			
			wave GaussPeakPos=$ChanPrefix+ksSP2PBPscattGausspeakPos				
			wave ScattMaxPos=$ChanPrefix+ksSP2PBPscattMaxPos
			wave ScattMaxPeakHt=$ChanPrefix+ksSP2PBPscattMaxPeakHeight			
			wave ScattMaxB4IncPos=$ChanPrefix+ksSP2PBPscattMaxB4IncPos
			wave ScattMaxB4IncPeakHt=$ChanPrefix+ksSP2PBPscattMaxB4IncPeakHeight			
			wave GaussPeakFWHM=$ChanPrefix+ksSP2PBPscattGausspeakFWHM		
			wave GaussPeakChiSqr=$ChanPrefix+ksSP2PBPscattGausspeakChiSqr		
			wave GaussFitError=$ChanPrefix+ksSP2PBPscattFittedBLfitError				
			wave ScattFitSigAtIncand=$ChanPrefix+ksSP2PBPscattSigAtIncand
			//split channel basic fit
			wave BasicOffset=$ChanPrefix+ksSP2PBPsplitBasicOffset				
			wave BasicNegPeakHt=$ChanPrefix+ksSP2PBPsplitNegPeakHt				
			wave BasicPosPeakHt=$ChanPrefix+ksSP2PBPsplitPosPeakHt				
			wave BasicNegPeakPos=$ChanPrefix+ksSP2PBPsplitNegPeakPos			
			wave BasicPosPeakPos=$ChanPrefix+ksSP2PBPsplitPosPeakPos			
			wave BasicFirstSplitPos=$ChanPrefix+ksSP2PBPsplitFirstSplitPos			
			wave BasicLastSplitPos=$ChanPrefix+ksSP2PBPsplitLastSplitPos			
			wave BasicCentreSplitPos=$ChanPrefix+ksSP2PBPsplitCentreSplitPos		
			wave FilteredSplitPos=$ChanPrefix+ksSP2PBPsplitFilteredSplitPos		
			wave BasicSplitWidth=$ChanPrefix+ksSP2PBPsplitSplitWidth				
			wave BasicPeakDist=$ChanPrefix+ksSP2PBPsplitPeakDist					
		//post processing
			string pbpfldrfp
			//infostr
				Svar PostProcInfoStr=$ksSP2postProcInfoStr	
			//matrices for fitted data
				wave FitMatY=$ChanPrefix+ksSP2FitMatY
				wave FitMatX=$ChanPrefix+ksSP2FitMatX
			//concerining multiple channels
				//event classification
				wave Classification=$ksSP2pbpClassification
				wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut				
				//peak height histogram
				wave PeakHtDistr=$ChanPrefix+ksSP2pbpPeakHtDistr	
				//delay between scattering and incandescence peak
				wave DelayTimeScatt2Broad=$ksSP2PBPdelaytimeS2B
				wave DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B			
				wave DelayNumbFractThinTot=$ksSP2PBPdelayNumbFractThinTot
				wave DelayNumbFractThickTot=$ksSP2PBPdelayNumbFractThickTot
				wave DelayNumbFractSatTot=$ksSP2PBPdelayNumbFractSatTot
				wave DelayNumbFractThin=$ksSP2PBPdelayNumbFractThin
				wave DelayNumbFractThick=$ksSP2PBPdelayNumbFractThick
				wave DelayNumbFractSat=$ksSP2PBPdelayNumbFractSat
				wave DelayNumbFract_Xctr=$ksSP2PBPdelayNumbFractXctr
				wave DelayNumbFract_Xbdr=$ksSP2PBPdelayNumbFractXbdr
				wave DelayHistogram=$ksSP2PBPdelayHistogram
				wave DelayHistoXctr=$ksSP2PBPdelayHistoXctr
				wave DelayHistoXbdr=$ksSP2PBPdelayHistoXbdr			
			//incandescence channels
				//BC density
				wave DensityOfBC=$ksSP2PBPdensityOfBC
				//band ratio
				string PercSuffix
				wave BandRatioHG=$ksSP2pbpBCbandratHG			
				wave BandRatioHGavg=$ksSP2pbpBCbandratHGAvg				//filtered data		
				wave BandRatioHGavgAll=$ksSP2pbpBCbandratHGAvgAll			//all data unfiltered			
				wave BandratioPerc=$ksSP2pbpBandratHGPercBnam+PercSuffix		
				wave BandratioPercXbdr=$ksSP2pbpBandratHGPercBnam+PercSuffix+ksSP2pbpBandratioXbdrSuffix		
				wave BandratioPercXctr=$ksSP2pbpBandratHGPercBnam+PercSuffix+ksSP2pbpBandratioXctrSuffix						
				wave BandratioPercNarrXctr=$ksSP2pbpBandratHGPercBnam+PercSuffix+ksSP2pbpBandratioNarrXctrSuffix						
				wave BandRatLG=$ksSP2pbpBCbandratLG			
				wave BandRatLGavg=$ksSP2pbpBCbandratLGAvg				//filtered data			
				wave BandRatioLGAvgAll=$ksSP2pbpBCbandratLGAvgAll			//all data unfiltered
				wave BandratLGperc=$ksSP2pbpBandratLGpercBnam+PercSuffix		
				wave BandratLGpercXbdr=$ksSP2pbpBandratLGpercBnam+PercSuffix+ksSP2pbpBandratioXbdrSuffix
				wave BandratLGpercXctr=$ksSP2pbpBandratLGpercBnam+PercSuffix+ksSP2pbpBandratioXctrSuffix
				wave BandratLGpercNarrXctr=$ksSP2pbpBandratLGpercBnam+PercSuffix+ksSP2pbpBandratioNarrXctrSuffix
				//lower cut diameter
				wave DiamCutLow=$ChanPrefix+ksSP2pbpDiamCutLow
				//mass and MED of BC particles
				wave BCmass=$ChanPrefix+ksSP2pbpBCmass
				wave BCdiam=$ChanPrefix+ksSP2pbpBCdiam
				wave BClogdiam=$ChanPrefix+ksSP2pbpBClogdiam
				//diameter scale for BC size distributions
				wave BCDistrDiamMidpt=$ChanPrefix+ksSP2pbpBCdistrDiamMid
				wave BCDistrDiamBdr=$ChanPrefix+ksSP2pbpBCDistrDiamBdr
				wave BCDistrDlogDp=$ChanPrefix+ksSP2pbpBCDistrDlogDp			
				//BC number size distribution
				wave BCnumbdistr=$ChanPrefix+ksSP2pbpBCnumbdistr
				//BC mass size distribution
				wave BCmassdistr=$ChanPrefix+ksSP2pbpBCmassdistr
				//total number and mass of BC particles
				wave BCtotalnumb=$ChanPrefix+ksSP2pbpBCtotalnumb
				wave BCtotalnumbconc=$ChanPrefix+ksSP2pbpBCtotalnumbconc
				wave BCtotalmass=$ChanPrefix+ksSP2pbpBCtotalmass
				wave BCtotalmassconc=$ChanPrefix+ksSP2pbpBCtotalmassconc
				wave BCtotalnumbconcBelowCut=$ChanPrefix+ksSP2pbpBCtotalnumbconcBelowCut
				wave BCtotalmassconcBelowCut=$ChanPrefix+ksSP2pbpBCtotalmassconcBelowCut
				//fitting lognormals size distributions
				wave LogNormFitDiamMidpt=$ChanPrefix+ksSP2pbpLogNormFitDiamMidpt
				wave LogNormFitMassDistr=$ChanPrefix+ksSP2pbpLogNormFitMassDistr
				wave LogNormFitMassCoef=$ChanPrefix+ksSP2pbpLogNormFitMassCoef
				wave LogNormFitMassBCconc=$ChanPrefix+ksSP2pbpLogNormFitMassBCconc
				wave LogNormFitNumbDistr=$ChanPrefix+ksSP2pbpLogNormFitNumbDistr
				wave LogNormFitNumbCoef=$ChanPrefix+ksSP2pbpLogNormFitNumbCoef
				wave LogNormFitNumbBCtot=$ChanPrefix+ksSP2pbpLogNormFitNumbBCconc			
			//scattering channel
				//optical diameter (assuming purely scattering)
				wave OptDiam=$ksSP2SCHGprefix+ksSP2pbpOptDiam
				wave LogOptDiam=$ksSP2SCHGprefix+ ksSP2pbpLogOptDiam
				//total number and number concentration of scattering particles
				wave OptTotalNumb=$ksSP2SCHGprefix+ksSP2pbpOptTotalNumb
				wave OptNumbConc=$ksSP2SCHGprefix+ksSP2pbpOptNumbConc
				//diameter scale for size distributions
				wave OptDistrDiamMidpt=$ksSP2SCHGprefix+ ksSP2pbpOptdistrDiamMid
				wave OptDistrDiamBdr=$ksSP2SCHGprefix+ ksSP2pbpOptDistrDiamBdr
				wave OptDistrDlogDp=$ksSP2SCHGprefix+ ksSP2pbpOptDistrDlogDp			
				//number size distribution
				wave OptNumbDistr=$ksSP2SCHGprefix+ksSP2pbpOptNumbDistr
			//time series subfolders
				string conc_or_SD_fldrfp
				setdatafolder $conc_or_SD_fldrfp		//separate subfolder in PBP-folder!
				//general (both concentration and size distribution time series)(
				wave /d TimeCtr=$ksSP2timeSeriesTimeCtr
				wave /d TimeBdr=$ksSP2timeSeriesTimeBdr
				wave Numb=$ksSP2timeSeriesNumbBnam
				wave NumbConc=$ChanPrefix+ksSP2timeSeriesNumbConcBnam
				wave MassConc=$ChanPrefix+ksSP2timeSeriesMassConcBnam
				//concentration time series extras
				setdatafolder $ksSP2concTserSubFldrPP
				wave NumbMeanDpBroad=$ChanPrefix+ksSP2ConcTserNumbMeanDpBnam
				wave MassMeanDpBroad=$ChanPrefix+ksSP2ConcTserMassMeanDpBnam			
				//size distr extras
					setdatafolder $ksSP2SizeDistTserSubFldrPP
					//measured size distribution
					wave DiamMidpt=$ChanPrefix+ksSP2pbpSDtserDiamMidpt
					wave DiamBdr=$ChanPrefix+ksSP2pbpSDtserDiamBdr
					wave NumbDistr=$ChanPrefix+ksSP2pbpSDtserNumbDistr
					wave MassDistr=$ChanPrefix+ksSP2pbpSDtserMassDistr
					//fitted lognormal size distribution
					wave LognormNumbCoef=$ChanPrefix+ksSP2pbpSDtserLognormNumbCoef
					wave LognormMassCoef=$ChanPrefix+ksSP2pbpSDtserLognormMassCoef
					wave LognormDiamMidpt=$ChanPrefix+ksSP2pbpSDtserLognormDiamMidpt
					wave LognormDiamBdr=$ChanPrefix+ksSP2pbpSDtserLognormDiamBdr
					wave LognormNumbDistr=$ChanPrefix+ksSP2pbpSDtserLognormNumbDistr
					wave LognormMassDistr=$ChanPrefix+ksSP2pbpSDtserLognormMassDistr
					wave LognormNumbConc=$ChanPrefix+ksSP2pbpSDtserLognormNumbConc
					wave LognormNumbBlwCt=$ChanPrefix+ksSP2pbpSDtserLognormNumbBlwCt
					wave LognormMassConc=$ChanPrefix+ksSP2pbpSDtserLognormMassConc
					wave LognormMassBlwCt=$ChanPrefix+ksSP2pbpSDtserLognormMassBlwCt
					wave LognormNumbGmeanDp=$ChanPrefix+ksSP2pbpSDtserLognNumbGmeanDp
					wave LognormMassGmeanDp=$ChanPrefix+ksSP2pbpSDtserLognMassGmeanDp
			//LEO-fit subfolder
				string leofldrfp
				leofldrfp=choplastcharacteroff(leofldrfp, ":")	
				//beam and calibration data
					string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
					setdatafolder $LeoBeamCalibSubFldrFP
					//without channel prefix
						//info string
						Svar LEOfitPrepInfoStr=$ksSP2LEOfitPrepInfoStr			
						//calibration factors and QA
						wave LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt			
						wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
						wave LEObeamPos=$ksSP2LEObeamPosPureScatt			
						//only required for Gaussian fit or quality assurance
						wave LEObeamFWHM=$ksSP2LEObeamFWHMpureScatt	
						wave LEOfitBeamFWHM=$ksSP2LEOfitBeamFWHM		
//						wave LEOsplitPos=$ksSP2LEOsplitPosMeasPureScatt			
						wave LEOsplit2incandDelta=$ksSP2LEOsplit2incandDelta			
					//with channel prefix
						//beam shape
						wave BeamShapeData=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeData
						wave BeamShapeCentrePos=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos
						wave BeamShapeSplitPos=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos
						wave BeamShapeIncEarlyPos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos
						wave BeamShapeIncLatePos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos
						wave BeamShapePerc10=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc10
						wave BeamShapePerc25=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc25
						wave BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
						wave BeamShapePerc75=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc75
						wave BeamShapePerc90=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc90
						//calibration factors and QA
						wave LEOscattSlopeFudgeFactMeas=$ChanPrefix+ksSP2LEOscattSlopeFudgeFacMeas
						wave LEOscattSlopeFudgeFactFit=$ChanPrefix+ksSP2LEOscattSlopeFudgeFacFit
						wave LEOPSDcalFactMeas=$ChanPrefix+ksSP2LEOPSDcalFactMeas
						wave LEOPSDcalFactFit=$ChanPrefix+ksSP2LEOPSDcalFactFit
				//trace analysis
					string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
					//without channel prefix
					Svar LEOtraceFitInfoStr=$ksSP2LEOtraceFitInfoStr			
					Svar LEOverificationSizingInfoStr=$ksSP2LEOverificSizingInfoStr			
					wave LEOfitBeamPos=$ksSP2LEOfitBeamPos		
					wave LEOfitLastPt=$ksSP2LEOfitLastPt			
					wave BCcoreDiam=$ksSP2LEOBCcoreDiam
					//with channel prefix
					wave LEOfitSaturated=$ChanPrefix+ksSP2PBPsaturated
					wave LEOfitOffset=$ChanPrefix+ksSP2LEOfitOffsetBnam			
					wave LEOfitPeakHtAllUncorr=$ChanPrefix+ksSP2LEOfitPeakHtAllUncorrBnam			
					wave LEOfitPeakHtAll=$ChanPrefix+ksSP2LEOfitPeakHtAllBnam			
					wave LEOfitPeakHtScatt=$ChanPrefix+ksSP2LEOfitPeakHtScattBnam			
					wave ClassificationByType=$ChanPrefix+ksSP2pbpClassificationByTypeBN
					wave LEOfitError=$ChanPrefix+ksSP2LEOfitErrorBnam			
					wave LEOfitOptDiamAll=$ChanPrefix+ksSP2LEOoptDiamAllBnam			
					wave PerfomStatsPerc10=$ChanPrefix+ksSP2LEOperfomStatsPerc10
					wave PerfomStatsPerc25=$ChanPrefix+ksSP2LEOperfomStatsPerc25
					wave PerfomStatsPerc50=$ChanPrefix+ksSP2LEOperfomStatsPerc50
					wave PerfomStatsPerc75=$ChanPrefix+ksSP2LEOperfomStatsPerc75
					wave PerfomStatsPerc90=$ChanPrefix+ksSP2LEOperfomStatsPerc90
				//main results
					string LeoMainSubFldrFP=leofldrfp+ksSP2LEOmainSubFldrPP
					setdatafolder $LeoMainSubFldrFP
					//without channel prefix
					Svar LEOmainPostProcInfoStr=$ksSP2LEOmainPostProcInfoStr			
					//with channel prefix
					wave BCvolumeFraction=$ChanPrefix+ksSP2LEObcVolumeFraction			
					wave BCcoatingThickness=$ChanPrefix+ksSP2LEObcCoatingThickness			
					wave TotalNumbConcTableCol1=$ChanPrefix+ksSP2LEOTotalNumbConcTableCol1
					wave TotalNumbConcTableCol2=$ChanPrefix+ksSP2LEOTotalNumbConcTableCol2
					wave TotalNumbConcBC=$ChanPrefix+ksSP2LEOTotalNumbConcBC
					wave TotalNumbConcBCtiny=$ChanPrefix+ksSP2LEOTotalNumbConcBCtiny
					wave TotalNumbConcBCsatInc=$ChanPrefix+ksSP2LEOTotalNumbConcBCsatInc
					wave TotalNumbConcBCsatLEO=$ChanPrefix+ksSP2LEOTotalNumbConcBCsatLEO
					wave TotalNumbConcBCcores=$ChanPrefix+ksSP2LEOTotalNumbConcBCcores
					wave TotalNumbConcScatt=$ChanPrefix+ksSP2LEOTotalNumbConcScatt
					wave TotalNumbConcScattTiny=$ChanPrefix+ksSP2LEOTotalNumbConcScattTiny
					wave TotalNumbConcScattInvalRef=$ChanPrefix+ksSP2LEOTotalNumbConcScInvalRef
					wave TotalNumbConcScattSatRef=$ChanPrefix+ksSP2LEOTotalNumbConcScSatRef
					wave TotalNumbConcScattSatLEO=$ChanPrefix+ksSP2LEOTotalNumbConcScSatLEO
					wave TotalNumbConcAllValid=$ChanPrefix+ksSP2LEOTotalNumbConcAllValid
					wave OptDistrDiamMidpt=$ChanPrefix+ksSP2LEOoptdistrDiamMid
					wave OptDistrDiamBdr=$ChanPrefix+ksSP2LEOoptDistrDiamBdr
					wave OptDistrDlogDp=$ChanPrefix+ksSP2LEOoptDistrDlogDp			
					wave OptNumbDistrBC=$ChanPrefix+ksSP2LEOoptNumbDistrBC
					wave OptNumbDistrBCtiny=$ChanPrefix+ksSP2LEOoptNumbDistrBCtiny
					wave OptNumbDistrBCsatInc=$ChanPrefix+ksSP2LEOoptNumbDistrBCsatInc
					wave OptNumbDistrBCsatLEO=$ChanPrefix+ksSP2LEOoptNumbDistrBCsatLEO
					wave NumbDistrBCcores=$ChanPrefix+ksSP2LEOnumbDistrBCcores					
					wave OptNumbDistrScatt=$ChanPrefix+ksSP2LEOoptNumbDistrScatt
					wave OptNumbDistrScattTiny=$ChanPrefix+ksSP2LEOoptNumbDistrScattTiny
					wave OptNumbDistrScattInvalRef=$ChanPrefix+ksSP2LEOoptNumbDistrScInvalRef
					wave OptNumbDistrScattSatRef=$ChanPrefix+ksSP2LEOoptNumbDistrScattSatRef
					wave OptNumbDistrScattSatLEO=$ChanPrefix+ksSP2LEOoptNumbDistrScattSatLEO
					wave OptNumbDistrAllValid=$ChanPrefix+ksSP2LEOoptNumbDistrAllValid
					wave OptNumFracDistrBC=$ChanPrefix+ksSP2LEOoptNFDistrBC
					wave OptNumFracDistrBCtiny=$ChanPrefix+ksSP2LEOoptNFDistrBCtiny
					wave OptNumFracDistrBCsatInc=$ChanPrefix+ksSP2LEOoptNFDistrBCsatInc
					wave OptNumFracDistrScatt=$ChanPrefix+ksSP2LEOoptNFDistrScatt
					wave OptNumFracDistrScattTiny=$ChanPrefix+ksSP2LEOoptNFDistrScattTiny
					wave OptNumFracDistrBCsatLEO=$ChanPrefix+ksSP2LEOoptNFDistrBCsatLEO
					wave OptNumFracDistrScattInvalRef=$ChanPrefix+ksSP2LEOoptNFDistrScattInvalRef
					wave OptNumFracDistrScattSatRef=$ChanPrefix+ksSP2LEOoptNFDistrScattSatRef
					wave OptNumFracDistrScattSatLEO=$ChanPrefix+ksSP2LEOoptNFDistrScattSatLEO
					wave BCvolumeFractHist=$ChanPrefix+ksSP2LEObcVolFractHist
					wave BCcoatingThicknHist=$ChanPrefix+ksSP2LEObcCoatThicknHist
					wave DelayTimeHist=$ksSP2SCHGprefix+ksSP2LEOdelayTimeHist
			//scattering signal at incandescence (SAI)
				//name of subfolder in LEO folder
				string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
				//info strings
				Svar NormalizationInfoStr=$ksSP2SAInormalizInfoStr
				Svar OpticalSizingInfoStr=$ksSP2SAIOptSizeInfoStr
				//waves
				wave SAI_FitSigNorm=$ChanPrefix+ksSP2SAIFitSigNorm
				wave SAI_NormFactPosInLaser=$ksSP2SAInormFactPosInLaser
				wave FitOptDiam=$ChanPrefix+ksSP2SAIFitOptDiam					
			//CETAC liquid sample analysis (ice cores)
			wave LiqSampleMassConc=$ChanPrefix+ksSP2pbpLiquidSampleMassConc
			wave LiquidSampleMassConcBelowCut=$ChanPrefix+ksSP2pbpLiqSampMassConcBelowCut

	//calibration summary subfolder
		string CalibSummaryFldrFP
			//the functions: SP2_RawFldrFP2CalibSummfldrFP and SP2_CalibSummFldrFP2RawFldrFP may be helpful
		setdatafolder $CalibSummaryFldrFP
		Svar DMACPCfldrFP=$ksSP2calibDMACPCfldrFP
		Svar CalibInfoFldrFP=$ksSP2calibInfoFldrFP
		Svar SP2rawDataFldrFP=$ksSP2calibSP2rawDataFldrFP
		wave Scatt_CalibFactList=$ksSP2calibSCHGcalibFactList
		wave DiamMidptScale=$ksSP2calibDiamMidptScale
		wave HelpDiamYwav=$ksSP2calibHelpDiamYwav	
		//1e
		wave DiamList_1e=$ksSP2calibDiamList+ksSP2suffix1e
		wave MassList_1e=$ksSP2calibMassList+ksSP2suffix1e
		wave BandRatHG_1e=$ksSP2calibBandRatHG+ksSP2suffix1e
		wave BandRatLG_1e=$ksSP2calibBandRatLG+ksSP2suffix1e
		wave BBHGfromNBHG_FitPkHt_1e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix1e
		wave NBHGfromBBHG_FitPkHt_1e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix1e
		wave BBLGfromNBLG_FitPkHt_1e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix1e
		wave NBLGfromBBLG_FitPkHt_1e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix1e
		wave HelpDiamMat_1e=$ksSP2calibHelpDiamMat+ksSP2suffix1e
		//broadband / 1e
		wave Broad_FitPkHt_1e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
		//broadband
		wave Broad_CountEff=$ksSP2BBHGprefix+ksSP2calibCountEff
		wave Broad_ConcList=$ksSP2BBHGprefix+ksSP2calibConcList
		wave Broad_GaussAreaMat=$ksSP2BBHGprefix+ksSP2calibGaussAreaMat
		wave Broad_GaussSigmaMat=$ksSP2BBHGprefix+ksSP2calibGaussSigmaMat
		wave Broad_GaussModeMat=$ksSP2BBHGprefix+ksSP2calibGaussModeMat
		wave Broad_GaussLogModeMat=$ksSP2BBHGprefix+ksSP2calibGaussLogModeMat
		wave Broad_HistoMat=$ksSP2BBHGprefix+ksSP2calibHistoMat
		wave Broad_HistoMatFitted=$ksSP2BBHGprefix+ksSP2calibHistoMatFitted
		wave Broad_LogFitPkHt=$ksSP2BBHGprefix+ksSP2calibLogFitPkHt
		wave Broad_dNdlogDpMat=$ksSP2BBHGprefix+ksSP2calibdNdlogDpMat
		wave BBHG_SplineCalCurve=$ksSP2BBHGprefix+ksSP2calibSplineCalCurve
		wave BBHG_SplineCoefCompact=$ksSP2BBHGprefix+ksSP2calibSplineCoefCompact
		wave BBHG_SplineCoefComplete=$ksSP2BBHGprefix+ksSP2calibSplineCoefComplete
		wave BBHG_SplineHoldForFit=$ksSP2BBHGprefix+ksSP2calibSplineHoldForFit
		wave BBHG_SplineEps=$ksSP2BBHGprefix+ksSP2calibSplineEps
		//other incandescence channels and higher charges:
			//  ==>> similar to broadband and 1e
		//scattering / 1e
		wave Scatt_FitPkHt_1e=$ksSP2SCHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
		wave Scatt_FitPkHtNorm_1e=$ksSP2SCHGprefix+ksSP2calibFitPkHtNorm+ksSP2suffix1e
		//scattering
		wave Scatt_CountEff=$ksSP2SCHGprefix+ksSP2calibCountEff
		wave Scatt_ConcList=$ksSP2SCHGprefix+ksSP2calibConcList
		wave Scatt_GaussAreaMat=$ksSP2SCHGprefix+ksSP2calibGaussAreaMat
		wave Scatt_GaussSigmaMat=$ksSP2SCHGprefix+ksSP2calibGaussSigmaMat
		wave Scatt_GaussModeMat=$ksSP2SCHGprefix+ksSP2calibGaussModeMat
		wave Scatt_GaussLogModeMat=$ksSP2SCHGprefix+ksSP2calibGaussLogModeMat
		wave Scatt_HistoMat=$ksSP2SCHGprefix+ksSP2calibHistoMat
		wave Scatt_HistoMatFitted=$ksSP2SCHGprefix+ksSP2calibHistoMatFitted
		wave Scatt_LogFitPkHt=$ksSP2SCHGprefix+ksSP2calibLogFitPkHt
		
	//calibration coefficients data folder
		string CalibSubFldrNam
		setdatafolder $ksSP2PathToCalibDataFldr
		setdatafolder $CalibSubFldrNam
		wave CalCoef_XXX=$ChanPrefix+ksSP2CalCoefBnam
		wave scatt_CalCurve=$ksSP2SCHGprefix+ksSP2CalCurveBnam
		wave broad_CalCurve=$ksSP2BBHGprefix+ksSP2CalCurveBnam
		wave narr_CalCurve=$ksSP2NBHGprefix+ksSP2CalCurveBnam
		wave split_CalCurve=$ksSP2SPHGprefix+ksSP2CalCurveBnam	
		wave broad_SizeCalCurve=$ksSP2BBHGprefix+ksSP2CalSizeCurveBnam
		wave narr_SizeCalCurve=$ksSP2NBHGprefix+ksSP2CalSizeCurveBnam		
		wave BandRatioHGcoef=$ksSP2CalBandRatioHGcoef
		wave BandRatioHGcurve=$ksSP2CalBandRatioHGcurve
		wave BandRatioLGcoef=$ksSP2CalBandRatioLGcoef
		wave BandRatioLGcurve=$ksSP2CalBandRatioLGcurve

	//various waves of general use (e.g. for batch loading)
			wave /t FileDate=$ksSP2_FileDate
			wave /t FileDateFirst=$ksSP2_FileDateFirst
			wave /t FileDateLast=$ksSP2_FileDateLast
			wave /t FileNumList=$ksSP2_FileNumList
			wave /t FileNumFirst=$ksSP2_FileNumFirst
			wave /t FileNumLast=$ksSP2_FileNumLast
			wave /t SampleID=$ksSP2_SampleID

	//batch load
		//ice core specific
			wave LiqSampleFlow=$ksSP2icbatchLiqSampleFlow
			wave LiqDrainFlow=$ksSP2icbatchLiqDrainFlow
			wave PurgeAirFlow=$ksSP2icbatchPurgeAirFlow
			wave /t SP2RawDataFP=$ksSP2icbatchSP2RawDataFP

	//monodisperse measurements using DMA/CPC (using CPC-DMA-logger, DMPS or SMPS software) or PSLs
		//general (list of set (or PSL) diameters, concentrations, times, ....
		wave /d TimeStartList=$ksSP2_monodi_TimeStartList
		wave /d TimeEndList=$ksSP2_monodi_TimeEndList
		wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
		wave DiamList=$ksSP2_monodi_DiamList
		wave MassList=$ksSP2_monodi_MassList
		wave ConcList=$ksSP2_monodi_ConcList
		wave TClist=$ksSP2_monodi_TClist
		wave PressList=$ksSP2_monodi_PressList	
		wave LaserPowerList=$ksSP2_monodi_LaserPowerList
		wave SelectorMode=$ksSP2_monodi_SelectorMode
		//DMPS specific
		wave ScanStartTimes=$ksSP2_DMPS_ScanStartTimes
		wave ScanEndTimes=$ksSP2_DMPS_ScanEndTimes
		wave TC=$ksSP2_DMPS_TC
		wave Press=$ksSP2_DMPS_Press
		wave DiamMat=$ksSP2_DMPS_DiamMat
		wave CountsMat=$ksSP2_DMPS_CountsMat
		wave ConcMat=$ksSP2_DMPS_ConcMat
		wave SecsMeasMat=$ksSP2_DMPS_SecsMeasMat
		wave /d TimeStartMat=$ksSP2_DMPS_TimeStartMat
		wave /d TimeEndMat=$ksSP2_DMPS_TimeEndMat
		wave /t SettingsMat=$ksSP2_DMPS_SettingsMat
		//CPC-DMA-logger specific
			//see function "CPCDMAdataAccessAllWaves" and corresponding constants

	//Mie data
		//purely scattering
		setdatafolder $ksSP2PathToMiePureScattFldr
		setdatafolder $ScattRefractIndex
		wave SIGvsDp=$ksSP2MIE_SIGvsDp
		wave DpVsLogSIG=$ksSP2MIE_DpVsLogSIG
		//coated BC
		setdatafolder $ksSP2PathToMieCoatedBCfldr
		setdatafolder $LEOrefractIndexPair
		wave MieDcore=$ksSP2MIE_Dcore
		wave MieCoatingThickness=$ksSP2MIE_CoatingThickness
		wave MieScatCross=$ksSP2MIE_ScatCross

	//temporary waves for raw data loader
		//housekeeping file (HK)
		setdatafolder $ksSP2hkLoadTempFldrFP
		Svar LastHKfileNam=$ksSP2hkLoadLastHKfileNam
		Svar LastHKfldrFP=$ksSP2hkLoadLastHKfldrFP
		Nvar hkFileNameFormat=$ksSP2hkLoadFileNameFormatPP
		wave /t HKfileNames=$ksSP2hkLoadFileNamesPP
		Svar HKdataDir=$ksSP2hkLoadDataDir
		wave /d hkFileTimes=$ksSP2hkLoadFileTimesPP
		//configuration file (INI)
		setdatafolder $ksSP2iniLoadTempFldrFP
		Nvar iniFileNameFormat=$ksSP2iniLoadFileNameFormatPP
		wave /t INIfileNames=$ksSP2iniLoadFileNamesPP
		Svar INIdataDir=$ksSP2iniLoadDataDir
		wave /d iniFileTimes=$ksSP2iniLoadFileTimesPP
end


Function IceCoreLoader081103()
	string MainFP="root:IceCores:'081103'"
	string DataDir="N:RawData:2008:IceCores:20081103"
	
	setdatafolder root:
	CreateFoldersOfFullPath(MainFP, 0)
	//access waves
	setdatafolder $MainFP
	wave /t DateStr
	wave /t FileListStr
	wave LiqSupplyFlow
	wave DrainFlow
	wave NebulizerPurgeFlow
	wave /t SampleID
	variable nSamples=numpnts(DateStr)
	//prepare results summary waves
	make /o/n=(nSamples)/t RawFldrFP=""
	make /o/n=(nSamples) SampleIDNum=NaN
	//loop over loading all sample
	variable sind
	string FileDateString, FileNumList, currrawfldrfp, currpbpfldrfp, currID
	variable currLiqSupplyFlow, currNebPurgeFlow
	for (sind=0; sind<nSamples; sind+=1)
		FileDateString=DateStr[sind]
		FileNumList=FileListStr[sind]
		FileNumList=replacestring(",", FileNumList, ";")
		//load current sample
		currrawfldrfp=SP2_LoadRawData("", RawDataDir=DataDir, LoadType=3, FileDateString=FileDateString, FileNumList=FileNumList, ConcatMode=1, TAmode=1, PPmode=0, Omode=1)
		currrawfldrfp=choplastcharacteroff(currrawfldrfp,";")
		RawFldrFP[sind]=currrawfldrfp
		currID=SampleID[sind]
		SampleIDNum[sind]=str2num(currID[5,inf])
	endfor
End


Function IceCorePostProcAndSummary081103()
	string MainFP="root:IceCores:'081103'"
	
	setdatafolder root:
	CreateFoldersOfFullPath(MainFP, 0)
	//access waves
	setdatafolder $MainFP
	wave /t DateStr
	wave /t FileListStr
	wave LiqSupplyFlow
	wave DrainFlow
	wave NebulizerPurgeFlow
	wave /t SampleID
	variable nSamples=numpnts(DateStr)
	//access list of raw data folders
	setdatafolder $MainFP
	wave /t RawFldrFP
	//get number of histogram bins
	setdatafolder $SP2_RawFldrFP2PBPfldrFP(RawFldrFP[0])
	wave BroadBCmassdistr
	variable nHistoBins=numpnts(BroadBCmassdistr)
	//prepare results summary waves
	setdatafolder $MainFP
	make /o/n=(nSamples) BroadAirborneBCmassConc=NaN; wave BroadAirborneBCmassConc
	make /o/n=(nSamples) BroadLiquidSampleBCmassConc=NaN; wave BroadLiquidSampleBCmassConc
	make /o/n=(nSamples, nHistoBins) SizeDistrDiam=NaN; wave SizeDistrDiam
	make /o/n=(nSamples, nHistoBins) SizeDistrMass=NaN; wave SizeDistrMass
	make /o/n=(nSamples, nHistoBins) SizeDistrNumb=NaN; wave SizeDistrNumb
	//loop over loading all sample
	variable sind
	string currrawfldrfp, currpbpfldrfp
	variable currLiqSupplyFlow, currNebPurgeFlow
	for (sind=0; sind<nSamples; sind+=1)
		//current PBP folder
		currrawfldrfp=RawFldrFP[sind]
		currrawfldrfp=choplastcharacteroff(currrawfldrfp,";")
		currpbpfldrfp=SP2_RawFldrFP2PBPfldrFP(currrawfldrfp)
		//post processing
		SP2_PBPpostprocessing(pbpfldrfp=currpbpfldrfp)
		//calculate back to concentration in liquid sample
		SP2_CETAC_calc_LiquidConcBtt("", PBPfldrfp=currpbpfldrfp, LiqSampleFlow=LiqSupplyFlow[sind], DrainFlow=DrainFlow[sind], PurgeAirFlow=NebulizerPurgeFlow[sind])
		//access results waves
		setdatafolder $currpbpfldrfp
		wave BroadBCmassConc=$ksSP2BBHGprefix+ksSP2pbpBCtotalmassconc
		wave BroadBCDistrDiamMidpt=$ksSP2BBHGprefix+ksSP2pbpBCdistrDiamMid
		wave BroadBCmassdistr=$ksSP2BBHGprefix+ksSP2pbpBCmassdistr
		wave BroadBCnumbdistr=$ksSP2BBHGprefix+ksSP2pbpBCnumbdistr
		wave LiqSampleConc
		//copy to summary waves
		BroadAirborneBCmassConc[sind]=BroadBCmassConc[0]
		SizeDistrDiam[sind][]=BroadBCDistrDiamMidpt[q]
		SizeDistrMass[sind][]=BroadBCmassdistr[q]
		SizeDistrNumb[sind][]=BroadBCnumbdistr[q]
		BroadLiquidSampleBCmassConc[sind]=LiqSampleConc[0]
	endfor
End

Function IceCoreLoader081031()
	string MainFP="root:IceCores:'081031'"
	string DataDir="N:RawData:2008:IceCores:20081031 IceCores and Standards"
	
	setdatafolder root:
	CreateFoldersOfFullPath(MainFP, 0)
	//access waves
	setdatafolder $MainFP
	wave /t DateStr
	wave /t FileListStr
	wave LiqSupplyFlow
	wave DrainFlow
	wave NebulizerPurgeFlow
	wave /t SampleID
	variable nSamples=numpnts(DateStr)
	//prepare results summary waves
	make /o/n=(nSamples)/t RawFldrFP=""
	make /o/n=(nSamples) SampleIDNum=NaN
	//loop over loading all sample
	variable sind
	string FileDateString, FileNumList, currrawfldrfp, currpbpfldrfp, currID
	variable currLiqSupplyFlow, currNebPurgeFlow
	for (sind=0; sind<nSamples; sind+=1)
		FileDateString=DateStr[sind]
		FileNumList=FileListStr[sind]
		FileNumList=replacestring(",", FileNumList, ";")
		//load current sample
		currrawfldrfp=SP2_LoadRawData("", RawDataDir=DataDir, LoadType=3, FileDateString=FileDateString, FileNumList=FileNumList, ConcatMode=1, TAmode=1, PPmode=0, Omode=1)
		currrawfldrfp=choplastcharacteroff(currrawfldrfp,";")
		RawFldrFP[sind]=currrawfldrfp
		currID=SampleID[sind]
		SampleIDNum[sind]=str2num(currID[5,inf])
	endfor
End


Function IceCorePostProcAndSummary081031()
	string MainFP="root:IceCores:'081031'"
	
	setdatafolder root:
	CreateFoldersOfFullPath(MainFP, 0)
	//access waves
	setdatafolder $MainFP
	wave /t DateStr
	wave /t FileListStr
	wave LiqSupplyFlow
	wave DrainFlow
	wave NebulizerPurgeFlow
	wave /t SampleID
	variable nSamples=numpnts(DateStr)
	//access list of raw data folders
	setdatafolder $MainFP
	wave /t RawFldrFP
	//get number of histogram bins
	setdatafolder $SP2_RawFldrFP2PBPfldrFP(RawFldrFP[0])
	wave BroadBCmassdistr
	variable nHistoBins=numpnts(BroadBCmassdistr)
	//prepare results summary waves
	setdatafolder $MainFP
	make /o/n=(nSamples) BroadAirborneBCmassConc=NaN; wave BroadAirborneBCmassConc
	make /o/n=(nSamples) BroadLiquidSampleBCmassConc=NaN; wave BroadLiquidSampleBCmassConc
	make /o/n=(nSamples, nHistoBins) SizeDistrDiam=NaN; wave SizeDistrDiam
	make /o/n=(nSamples, nHistoBins) SizeDistrMass=NaN; wave SizeDistrMass
	make /o/n=(nSamples, nHistoBins) SizeDistrNumb=NaN; wave SizeDistrNumb
	//loop over loading all sample
	variable sind
	string currrawfldrfp, currpbpfldrfp
	variable currLiqSupplyFlow, currNebPurgeFlow
	for (sind=0; sind<nSamples; sind+=1)
		//current PBP folder
		currrawfldrfp=RawFldrFP[sind]
		currrawfldrfp=choplastcharacteroff(currrawfldrfp,";")
		currpbpfldrfp=SP2_RawFldrFP2PBPfldrFP(currrawfldrfp)
		//post processing
		SP2_PBPpostprocessing(pbpfldrfp=currpbpfldrfp)
		//calculate back to concentration in liquid sample
		SP2_CETAC_calc_LiquidConcBtt("", PBPfldrfp=currpbpfldrfp, LiqSampleFlow=LiqSupplyFlow[sind], DrainFlow=DrainFlow[sind], PurgeAirFlow=NebulizerPurgeFlow[sind])
		//access results waves
		setdatafolder $currpbpfldrfp
		wave BroadBCmassConc=$ksSP2BBHGprefix+ksSP2pbpBCtotalmassconc
		wave BroadBCDistrDiamMidpt=$ksSP2BBHGprefix+ksSP2pbpBCdistrDiamMid
		wave BroadBCmassdistr=$ksSP2BBHGprefix+ksSP2pbpBCmassdistr
		wave BroadBCnumbdistr=$ksSP2BBHGprefix+ksSP2pbpBCnumbdistr
		wave LiqSampleConc
		//copy to summary waves
		BroadAirborneBCmassConc[sind]=BroadBCmassConc[0]
		SizeDistrDiam[sind][]=BroadBCDistrDiamMidpt[q]
		SizeDistrMass[sind][]=BroadBCmassdistr[q]
		SizeDistrNumb[sind][]=BroadBCnumbdistr[q]
		BroadLiquidSampleBCmassConc[sind]=LiqSampleConc[0]
	endfor
End



Function SP2addEventTime([rawdatafp])
	//note: discrepancy of 6 hours in file 20080927x021_SP2 compared to TimeWave!
	//martin.gysel@psi.ch;
	string rawdatafp	//full path to the data folder containing the raw data
					//default: current data folder
					
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(rawdatafp))
		rawdatafp=savedDF
	endif
	
	//access waves
	setdatafolder $rawdatafp
	wave TimeDiv10000=$ksSP2eventTimeDivPP
	wave TimeRemainder=$ksSP2eventTimeRemainder
	variable nPts=dimsize(TimeDiv10000,0)
	//prepare wave for time stamp
	setdatafolder $rawdatafp
	make /d/o/n=(nPts) $ksSP2eventTimeStamp
	wave TimeStampEvent=$ksSP2eventTimeStamp
	setscale d 0,0,"dat", TimeStampEvent
	//convert time
	TimeStampEvent=10000*TimeDiv10000+TimeRemainder
		
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2filename2DateVal(filename)
	//This function extracts the date from an SP2 file name.
	//return value: date (Igor time format)
	//martin.gysel@psi.ch; 08/10/2008
	string filename //".sp2b", ".sp2", ".hk", or ".ini" file name
	
	//parse file name
	variable DateVal=DateTextToIgorTimeSortNoSep(filename[0,7])
	//finish procedure
	return DateVal
End

Function SP2filename2FileNum(filename)
	//This function extracts the file number from an SP2 file name.
	//return value: file number (number between 1 and 999)
	//martin.gysel@psi.ch; 08/10/2008, 09/09/2010
	string filename //".sp2b", ".sp2", ".hk", or ".ini" file name
	
	//check format of file name
	string filenametrunk=StringFromList(0, filename, ".")
	variable HKfileFormatNum
	if (strlen(filenametrunk)==12)
		HKfileFormatNum=3
	elseif (strlen(filenametrunk)==14)
		HKfileFormatNum=4
	else
		//assume file format 3.x as default
		HKfileFormatNum=3
	endif
	//parse file name
	variable FileNum
	switch(HKfileFormatNum)	
		case 3:
			FileNum=str2num(filename[9,11])
			break				
		case 4:
			FileNum=3600*str2num(filename[8,9])+60*str2num(filename[10,11])+str2num(filename[12,13])
			break				
	endswitch
	//finish procedure
	return FileNum
end

Function SP2filename2UniqueFileID(filename)
	//This function extracts a unique file ID from an SP2 file name.
	//return value: Igor time value, where the date represents the file date and the seconds since midnight the file number.
	//martin.gysel@psi.ch; 09/11/2008
	string filename //".sp2b", ".sp2", ".hk", or ".ini" file name
	
	//parse file name
	variable DateVal=SP2filename2DateVal(filename)
	variable SecsSinceMidnight=SP2filename2FileNum(filename)
	//finish procedure
	return DateVal+SecsSinceMidnight
End

Function /S SP2uniqueFileID2filenamebody(UniqueID)
	//This function converts a unique SP2 file ID into the corresponding SP2 file name.
	//return string: SP2 file name (body without extension)
	//martin.gysel@psi.ch, 09/11/2008
	variable UniqueID		//unique file ID:
						//Igor time value, where the date represents the file date and the seconds since midnight the file number.

	//datestring
	string datestring=IgorTimeToTimeText(UniqueID, mode=5)
	//file number string
	string filenumstring=number2fixedwidthintegerstring(mod(UniqueID, 86400), kSP2fileIDndigits)
	//finish procedure
	return datestring+ksSP2filenameX+filenumstring
End

Function /S SP2filename2RawDataFldrNam(filename)
	//martin.gysel@psi.ch; 01/11/2008, 26/08/2009
	string filename //"YYYYMMDDxnnn.sp2b" or "YYYYMMDDxnnn.hk" file name

	string retstr
	if (itemsinlist(filename, ".")>1)
		//strip file name extension if present
		retstr=RemoveLastItemFromList(filename, ListSepStr=".")
	else
		//no extension in filename => leave as is
		retstr=filename
	endif
	retstr=ChopLastCharacterOff(retstr,".")		//remove trailing "."
	retstr+=ksSP2rawdatafldrsuffix				//add SP2 folder suffix
	return retstr
	//return replacestring(ksSP2datafileExt,filename,"")+ksSP2rawdatafldrsuffix
end

Function /S SP2filename2HKdataFldrNam(filename)
	//martin.gysel@psi.ch; 15/04/2010
	string filename //"YYYYMMDDxnnn.sp2b" or "YYYYMMDDxnnn.hk" file name

	string retstr
	if (itemsinlist(filename, ".")>1)
		//strip file name extension if present
		retstr=RemoveLastItemFromList(filename, ListSepStr=".")
	else
		//no extension in filename => leave as is
		retstr=filename
	endif
	retstr=ChopLastCharacterOff(retstr,".")		//remove trailing "."
	retstr+=ksSP2hkFldrSuffix				//add HK folder suffix
	return retstr
end


Function SP2_LoadHouseKeepingFileButt(ctrlname) : ButtonControl
	//Function for button control to load one SP2 housekeeping file
	//return value: 1 if a file has been loaded, 0 otherwise.
	//martin.gysel@psi.ch; 06/11/2008, 26/08/2009
	string ctrlname	//name of button control; not used
					
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//browse for housekeeping file
	string hkfilefp
	hkfilefp=BrowseForFile(DialogStr="Select housekeeping file to be loaded", TypeStr=ksSP2hkFileType)
	if (stringmatch("cancelled",hkfilefp))
		setdatafolder $savedDF
		message="user cancelled procedure "+currproc+"!"
		print message; print RTStackInfo; abort message
	endif
	string hkfilenam=LastStringFromList(hkfilefp,ListSepStr=":")
	//prompt for target folder
	string hkfldrfp=SP2filename2HKfldrFP(hkfilenam)
	prompt hkfldrfp, "Select target folder for housekeeping data:"
	doprompt "Select Folder", hkfldrfp
	if (V_flag)
		setdatafolder $savedDF
		message="user cancelled procedure"+currproc+"!"
		print message; print RTStackInfo; abort message
	endif
	//load housekeeping file
	variable retval
	retval=SP2_LoadHouseKeepingFileFast(hkfilefp, hkfldrfp, 0,1)
	//finish procedure
	setdatafolder $savedDF
	return retval		
End


Function SP2_LoadHouseKeepingFileFast(hkfilefp, hkfldrfp, Omode, PrintInfo)
	//This function loads one SP2 housekeeping file of any format (faster than SP2_LoadHouseKeepingFile)
	//return value: 1 if a file has been loaded, 0 otherwise.
	//martin.gysel@psi.ch; 08/09/2010, 09/09/2010, 13/09/2011
	string hkfilefp		//full path to housekeeping file to be loaded
	string hkfldrfp		//full path to folder into which hk-data are to be loaded
	variable Omode	//1: overwrite previous data if target folder exists already
					//0: prompt before overwriting previous data
	variable PrintInfo	//1:	print loading information to history
					//0:	do not print loading information to history
					
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults and check input
	hkfldrfp=QuoteLiberalPath(hkfldrfp)				//make function compatible with liberal path names
	if (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	//check whether target folder exists already
	string overwrite="NO"
	string pstr="YES;NO"
	if (Omode!=1)
		do	
			if (datafolderexists(hkfldrfp))
				prompt overwrite, "Target folder exists already => overwrite?", popup, pstr
				doprompt "Overwrite?", overwrite
				if (stringmatch("YES", overwrite))
					break
				else
					prompt hkfldrfp, "Select target folder for housekeeping data:"
					doprompt "Select Folder", hkfldrfp
					if (V_flag)
						setdatafolder $savedDF
						message="user cancelled procedure"+currproc+"!"
						print message; print RTStackInfo; abort message
					endif		
				endif
			else
				break
			endif
		while (1)
	endif
	CreateFoldersOfFullPath(hkfldrfp, 0)
	//print info to history
	variable timerRefNum
	PrintInfo=PrintInfo & FileExists(hkfilefp)
	if (PrintInfo==1)
		printf "[%s] Loading HK file %s to folder %s... ", now(), hkfilefp, hkFldrfp
		timerRefNum=StartMSTimer			
	endif
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 hkfilefp
	if (V_isAliasShortcut)
		hkfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 hkfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			hkfilefp=S_aliasPath
		endif
	endif
	//read wave names from file
		//open file
		variable HKrefnum
		Open /R /Z HKrefnum  as hkfilefp
		if (V_flag)
			//file not available
			killdatafolder /z $hkfldrfp
			return 0
		endif
		//read first line
		string HeaderLine
		FReadLine HKrefnum, HeaderLine
		HeaderLine=ReplaceString("\t",HeaderLine,";")	//replace delimiter
		variable nWavs=itemsinlist(HeaderLine)
		//close file
		Close HKrefnum
	//check HK-file format
	setdatafolder $hkfldrfp
	variable /g $ksSP2hkFileFormatNum=NaN
	Nvar HKfileFormatNum=$ksSP2hkFileFormatNum
	string FirstWavNam=StringFromList(0, HeaderLine)
	string TimeWnam
	strswitch(FirstWavNam)
		case "Time":
			//HK-file version 3.x 
			HKfileFormatNum=3
			TimeWnam="Time_s"
			break
		case "Time (sec)":
			//HK-file version 4.x 
			HKfileFormatNum=4
			TimeWnam="Time_sec"
			break
		default:
			//file version unknown => skip loading
			setdatafolder $savedDF
			message="Wrong format of hk-file loaded within procedure "+currproc+"!"
			print message; print RTStackInfo; 
			SP2_postErrorMsg(message) // v4111, to avoid interruption
			killdatafolder /z $hkfldrfp
			return 0
	endswitch
	//adapt wave names and create column info string for data loading
	variable wind
	string prevwavnamlist=""
	string currwavnam
	string colinfostr=""
	for (wind=0; wind<nWavs; wind+=1)
		currwavnam=stringfromlist(wind,HeaderLine)
		currwavnam=WaveNameCleaner(currwavnam, convbits=15)	//replace special characters and remove forbidden characters
		if (WhichListItem(currwavnam, prevwavnamlist)>=0)
			//duplicate column name => add "_1"
			currwavnam+="_1"
		endif
		prevwavnamlist+=currwavnam+";"
		switch(HKfileFormatNum)	
			case 3:	
				//HK-file version 3.x 
				if(wind==0)
					//skip unnecessary columns
					colinfostr+="C=1,N='_skip_';"
//				elseif(wind==4 || wind==28)
//					//skip duplicate columns
//					colinfostr+="C=1,N='_skip_';"
				else
					//columns that are to be loaded normally
					colinfostr+="C=1,N="+currwavnam+";"
				endif						
				break				
			case 4:
				//HK-file version 4.x 
				if(wind<0)
					//skip unnecessary columns
					colinfostr+="C=1,N='_skip_';"
//				elseif(wind<0)
//					//skip duplicate columns
//					colinfostr+="C=1,N='_skip_';"
				else
					//columns that are to be loaded normally
					colinfostr+="C=1,N="+currwavnam+";"
				endif						
				break				
			default:							
				setdatafolder $savedDF
				killdatafolder /z $hkfldrfp
				message="Code error in the procedure"+currproc+"!"
				print message; print RTStackInfo; abort message
		endswitch
	endfor
	//load housekeeping file
	setdatafolder $hkfldrfp
	LoadWave /W/A /B=colinfostr /H /J /K=1 /O /Q hkfilefp
	//access loaded time wave
	setdatafolder $hkfldrfp
	wave SecsFromMidnight=$TimeWnam
	wave ElapsedTime=$ksSP2hkElapsedTime
	variable nPts=numpnts(SecsFromMidnight)
	//delete NaN entries from all columns (required to deal with LGGE's corrupt HK-file header)
	variable firstgoodrow=FirstAndLastNonNaNpoint(SecsFromMidnight)
	if (firstgoodrow>0)
		DeleteRunsFromDataFldr("0-"+num2str(firstgoodrow-1), nPts, DataFldrPath=hkfldrfp)
		nPts=numpnts(SecsFromMidnight)
	endif
	//create additional waves
		//filename => date
		string hkfilename=laststringfromlist(hkfilefp, ListSepStr=":")
		variable dateval=SP2filename2DateVal(hkfilename)
		//time stamp
		setdatafolder $hkfldrfp
		make /o/d/n=(nPts) $ksSP2hkTimeStamp
		wave TimeStampHK=$ksSP2hkTimeStamp
		setscale d,0,0,"dat", TimeStampHK
		switch(HKfileFormatNum)	
			case 3:	
				//HK-file version 3.x 
				TimeStampHK=dateval+SecsFromMidnight[p]
				break				
			case 4:
				//HK-file version 4.x  ("SecsFromMidnight" cannot be used directly as it is modulo 86400 in files that cross midnight.)
				TimeStampHK=dateval+SecsFromMidnight[0]+ElapsedTime[p]-ElapsedTime[0]
				break				
			default:							
				setdatafolder $savedDF
				killdatafolder /z $hkfldrfp
				message="Code error in the procedure"+currproc+"!"
				print message; print RTStackInfo; abort message
		endswitch
		//file ID
		variable FID=SP2filename2UniqueFileID(hkfilename)
		make /o/d/n=(nPts) $ksSP2hkFileID
		wave FileIDHK=$ksSP2hkFileID
		note FileIDHK, "Unique ID of housekeeping file;"
		note FileIDHK, "Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		setscale d 0,0,"dat", FileIDHK
		FileIDHK=FID
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "finished after %s.\r", secs2str(elapsed/1e6)
	endif
	//finish procedure
	killwaves /z SecsFromMidnight
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 1		
End


 
Function SP2_LoadHouseKeepingFile(hkfilefp, hkfldrfp, Omode, PrintInfo)
	//This function loads one SP2 housekeeping file of format 3.x
	//note: does not work for HK-files of format 4.x and it is slower than SP2_LoadHouseKeepingFileFast
	//return value: 1 if a file has been loaded, 0 otherwise.
	//martin.gysel@psi.ch; 06/11/2008, 15/04/2010
	string hkfilefp		//full path to housekeeping file to be loaded
	string hkfldrfp		//full path to folder into which hk-data are to be loaded
	variable Omode	//1: overwrite previous data if target folder exists already
					//0: prompt before overwriting previous data
	variable PrintInfo	//1:	print loading information to history
					//0:	do not print loading information to history
					
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults and check input
	hkfldrfp=QuoteLiberalPath(hkfldrfp)				//make function compatible with liberal path names
	if (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	//check whether target folder exists already
	string overwrite="NO"
	string pstr="YES;NO"
	if (Omode!=1)
		do	
			if (datafolderexists(hkfldrfp))
				prompt overwrite, "Target folder exists already => overwrite?", popup, pstr
				doprompt "Overwrite?", overwrite
				if (stringmatch("YES", overwrite))
					break
				else
					prompt hkfldrfp, "Select target folder for housekeeping data:"
					doprompt "Select Folder", hkfldrfp
					if (V_flag)
						setdatafolder $savedDF
						message="user cancelled procedure"+currproc+"!"
						print message; print RTStackInfo; abort message
					endif		
				endif
			else
				break
			endif
		while (1)
	endif
	CreateFoldersOfFullPath(hkfldrfp, 0)
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s tempLoadSP2hkFile
	string tmpfldrpath=getdatafolder(1)
	//print info to history
	variable timerRefNum
	PrintInfo=PrintInfo & FileExists(hkfilefp)
	if (PrintInfo==1)
		Print "Loading SP2 file: "+hkfilefp+" to folder "+hkfldrfp+"\r"
		timerRefNum=StartMSTimer			
	endif
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 hkfilefp
	if (V_isAliasShortcut)
		hkfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 hkfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			hkfilefp=S_aliasPath
		endif
	endif
	//load housekeeping file
	string FileWavNam
	setdatafolder $tmpfldrpath
	FileWavNam=LoadDelimitTxtFileTo1DWavNoAbrt("FileWav", PathToFile=hkfilefp, Omode=1)
	if (stringmatch("NoFileLoaded",FileWavNam))
		killdatafolder /z $hkfldrfp
		return 0
	endif
	wave /t CurrFileWav=$FileWavNam
	variable nPts=dimsize(CurrFileWav,0)-1
	//parse housekeeping data
		//filename => date
		string hkfilename=laststringfromlist(hkfilefp, ListSepStr=":")
		variable dateval=SP2filename2DateVal(hkfilename)
		//get list of waves
		string WavList=CurrFileWav[0]
		WavList=ReplaceString("\t",WavList,";")
		variable nWavs=itemsinlist(Wavlist)
		//time stamp
		setdatafolder $hkfldrfp
		make /o/d/n=(nPts) $ksSP2hkTimeStamp
		wave TimeStampHK=$ksSP2hkTimeStamp
		setscale d,0,0,"dat", TimeStampHK
		TimeStampHK=dateval+str2num(stringfromlist(1,CurrFileWav[p+1],"\t"))
		//file ID
		make /o/d/n=(nPts) $ksSP2hkFileID
		wave FileIDHK=$ksSP2hkFileID
		note FileIDHK, "Unique ID of housekeeping file;"
		note FileIDHK, "Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		setscale d 0,0,"dat", FileIDHK
		FileIDHK=SP2filename2UniqueFileID(hkfilename)
		//load all other waves
		variable wind
		string currwavnam
		for (wind=2; wind<nWavs; wind+=1)
			currwavnam=stringfromlist(wind,wavlist)
			currwavnam=WaveNameCleaner(currwavnam, convbits=15)	//replace special characters and remove forbidden characters
			make /o/n=(nPts) $currwavnam=str2num(stringfromlist(wind,CurrFileWav[p+1],"\t"))
		endfor
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "To time: %.2f seconds.\r", elapsed/1e6
	endif
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z tmpfldrpath
	return 1		
End

function SP2peakHt2BCmass(peakheight, CalibWav, nSegments)
	//this function converts an incandescence peak height value into a BC mass value according to the calibration coefficients provided.
	//return value: BC mass [fg]
	//martin.gysel@psi.ch; 09/10/2008, 04/11/2009, 13/11/2009
	variable peakheight	//incandescence peak height to be converted into a BC mass
	wave CalibWav		//wave containing the SP2's BC mass calibration coefficients (quadratic spline segments; expanded form)
						//CalibWav[0]=a0
						//CalibWav[1]=b0
						//CalibWav[2]=c0
						//CalibWav[3]=lowercut0
						//CalibWav[4]=a1
						//CalibWav[5]=b1
						//CalibWav[6]=c1
						//CalibWav[7]=lowercut1
						//CalibWav[8]=a2
						//CalibWav[9]=b2
						//CalibWav[10]=c2
						//CalibWav[11]=...
						//note: b1, c1, b2, c2, ... are no free coefficients and must be calculated using the function SP2_calibCurveSplineCoefExpand
	variable nSegments	//number of spline segments
	
	variable mass = SP2_calibCurveSplineFast(peakheight, CalibWav, nSegments)
	mass = mass<=0 ? NaN : mass	//filter negative and zero values
	return mass
end

function SP2bcMass2diam(BCmass, density)
	//This calculates the mass equivalent diameter of a BC core.
	//return value: mass equivalent diameter [nm]
	//martin.gysel@psi.ch; 09/10/2008
	variable BCmass	//mass of the BC core [fg]
	variable density	//BC density [kg/m]
	
	//convert units
	BCmass*=1e-18		//fg -> kg
	//calculate diameter
	variable diam
	diam=(6*BCmass/density/pi)^(1/3)		//m
	//convert units
	diam*=1e9	//m -> nm
	//finish procedure
	return diam
end

function SP2peakHt2BCdiam(peakheight, CalibWav, density, nSegments)
	//This function converts an incandescence peak height value into the corresponding mass equivalent diameter of the BC core
	//return value: mass equivalent diameter [nm]
	//martin.gysel@psi.ch; 09/10/2008, 04/11/2009, 13/11/2009, 20/11/2009
	variable peakheight	//incandescence peak height to be converted into a BC mass
	wave CalibWav		//wave containing the SP2's BC mass calibration coefficients (quadratic spline segments)
						//CalibWav[0]=a0
						//CalibWav[1]=b0
						//CalibWav[2]=c0
						//CalibWav[3]=lowercut0
						//CalibWav[4]=a1
						//CalibWav[5]=b1
						//CalibWav[6]=c1
						//CalibWav[7]=lowercut1
						//CalibWav[8]=a2
						//CalibWav[9]=b2
						//CalibWav[10]=c2
						//CalibWav[11]=...
						//note: b1, c1, b2, c2, ... are no free coefficients and must be calculated using the function SP2_calibCurveSplineCoefExpand
	variable density	//BC density [kg/m]
	variable nSegments	//number of spline segments
	
	//calculate diameter
	variable BCmass, diam
	BCmass=SP2PeakHt2BCmass(peakheight, CalibWav, nSegments)
	diam=SP2BCmass2diam(BCmass, density)
	//finish procedure
	return diam
end



Function /S SP2filenameStepBack(filename)
	//This function creates the name of the previous SP2 file
	//return string: 	name of previous file or "" (empty string) if file number x000 is reached
	//martin.gysel@psi.ch; 05/11/2008
	string filename	//name of sp2 data file (with or without extension)
	
	//preparations
	string previousfilename
	//get body and extension of file name
	string FileBody=filename[0,kSP2filenamelenNoExt+1]
	string FileEnding=filename[kSP2filenamelenNoExt,inf]
	//get date and number of file
	variable filedate=SP2filename2DateVal(filename)
	variable fileNum=SP2filename2FileNum(filename)
	//create previous file name
	if(fileNum==1)
		//previous file number would be x000 => return empty string
		previousfilename=""
//&%			//last file name of previous day
//&%			previousfilename=IgorTimeToTimeText(filedate-86400,mode=5)+ksSP2filenameX+num2str(10^kSP2fileIDndigits-1)+FileEnding
	else
		//previous file number
		previousfilename=IgorTimeToTimeText(filedate,mode=5)+ksSP2filenameX+number2fixedwidthintegerstring(fileNum-1,kSP2fileIDndigits)+FileEnding
	endif
	//finish procedure
	return previousfilename
end

Function SP2fileismorerecent(firstfilename, secondfilename)
	//This function tests which SP2 filename is more recent.
	//return value: 	0 if first file is more recent than second file (with or without extension)
	//				1 if second file is more recent than first file (with or without extension)
	//				2 if first and second file have equal data and file number
	//martin.gysel@psi.ch; 05/11/2008
	string firstfilename		//name of first file
	string secondfilename		//name of second file
	
	//preparations
	variable firstdate=SP2filename2DateVal(firstfilename)
	variable firstNum=SP2filename2FileNum(firstfilename)
	variable seconddate=SP2filename2DateVal(secondfilename)
	variable secondNum=SP2filename2FileNum(secondfilename)
	//check which file is more recent
	variable retval
	if (firstdate<seconddate)
		return 1
	elseif (firstdate>seconddate)
		return 0
	elseif (firstNum<secondNum)
		return 1
	elseif (firstNum>secondNum)
		return 0
	else
		return 2
	endif
End


Function SP2_CreateConfigDataWaves(configfldrfp, TraceLen, PreTrigNum, OneOfEverySavedVal, SampleFlowSetVal)
	//This function prepares the wave for the SP2 configuration data.
	//return value: 0; not used
	//martin.gysel@psi.ch; 22/10/2010, 18/11/2010
	string configfldrfp		//full path to folder in which the configuration data waves are to be created
	variable TraceLen		//trace length
	variable PreTrigNum	//number of pretrigger points
	variable OneOfEverySavedVal	//fraction of triggered data that have been saved
	variable SampleFlowSetVal	//nominal sample flow rate [ml/min]

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//prepare waves for configuration data
	CreateFoldersOfFullPath(configfldrfp, 0)
	setdatafolder $configfldrfp
		//channel 0
		make /o/n=(1) $ksSP2configChannel0=NaN
		wave Channel0=$ksSP2configChannel0	
		note Channel0, "1: recording of channel 0 turned on;"
		note Channel0, "0: recording of channel 0 turned off;"
		//channel 1
		make /o/n=(1) $ksSP2configChannel1=NaN
		wave Channel1=$ksSP2configChannel1	
		note Channel1, "1: recording of channel 1 turned on;"
		note Channel1, "0: recording of channel 1 turned off;"
		//channel 2
		make /o/n=(1) $ksSP2configChannel2=NaN
		wave Channel2=$ksSP2configChannel2	
		note Channel2, "1: recording of channel 2 turned on;"
		note Channel2, "0: recording of channel 2 turned off;"
		//channel 3
		make /o/n=(1) $ksSP2configChannel3=NaN
		wave Channel3=$ksSP2configChannel3	
		note Channel3, "1: recording of channel 3 turned on;"
		note Channel3, "0: recording of channel 3 turned off;"
		//channel 4
		make /o/n=(1) $ksSP2configChannel4=NaN
		wave Channel4=$ksSP2configChannel4	
		note Channel4, "1: recording of channel 4 turned on;"
		note Channel4, "0: recording of channel 4 turned off;"
		//channel 5
		make /o/n=(1) $ksSP2configChannel5=NaN
		wave Channel5g=$ksSP2configChannel5	
		note Channel5, "1: recording of channel 5 turned on;"
		note Channel5, "0: recording of channel 5 turned off;"
		//channel 6
		make /o/n=(1) $ksSP2configChannel6=NaN
		wave Channel6=$ksSP2configChannel6	
		note Channel6, "1: recording of channel 6 turned on;"
		note Channel6, "0: recording of channel 6 turned off;"
		//channel 7
		make /o/n=(1) $ksSP2configChannel7=NaN
		wave Channel7=$ksSP2configChannel7	
		note Channel7, "1: recording of channel 7 turned on;"
		note Channel7, "0: recording of channel 7 turned off;"
		//Sampling rate
		make /o/n=(1) $ksSP2configSamplesPSec=NaN
		wave SamplePerSec=$ksSP2configSamplesPSec
		note SamplePerSec, "Sampling rate for data traces;"
		//number of primary channel
		make /o/n=(1) $ksSP2configPrimaryChanNum=NaN
		wave PrimaryChanNum=$ksSP2configPrimaryChanNum
		note PrimaryChanNum, "Number of primary channel used for triggering data storage;"
		//number of secondary channel
		make /o/n=(1) $ksSP2configSecondaryChanNum=NaN
		wave SecondaryChanNum=$ksSP2configSecondaryChanNum
		note SecondaryChanNum, "Number of secondary channel used for triggering data storage;"
		//Use primary trigger
		make /o/n=(1) $ksSP2configUsePrimaryTrigger=NaN
		wave UsePrimaryTrigger=$ksSP2configUsePrimaryTrigger
		note UsePrimaryTrigger, "This specifies whether or not the primary channel is used to trigger data storage;"
		note UsePrimaryTrigger, "1: trigger turned on;"
		note UsePrimaryTrigger, "0: trigger turned off;"
		//Use secondary trigger
		make /o/n=(1) $ksSP2configUseSecondaryTrigger=NaN
		wave UseSecondaryTrigger=$ksSP2configUseSecondaryTrigger
		note UseSecondaryTrigger, "This specifies whether or not the secondary channel is used to trigger data storage;"
		note UseSecondaryTrigger, "1: trigger turned on;"
		note UseSecondaryTrigger, "0: trigger turned off;"
		//PrimaryDelta
		make /o/n=(1) $ksSP2configPrimaryDelta=NaN
		wave PrimaryDelta=$ksSP2configPrimaryDelta
		note PrimaryDelta, "Determines trigger type for primary channel."
		note PrimaryDelta, "0: constant absolute digital value as set elsewhere in the configuration file is used to trigger the primary channel."
		note PrimaryDelta, "n (>0): trace storage is triggered if the signal value exceeds baseline+n (digital units)."
		//SecondaryDelta
		make /o/n=(1) $ksSP2configSecondaryDelta=NaN
		wave SecondaryDelta=$ksSP2configSecondaryDelta
		note SecondaryDelta, "Determines trigger type for secondary channel."
		note SecondaryDelta, "0: constant absolute digital value as set elsewhere in the configuration file is used to trigger the secondary channel."
		note SecondaryDelta, "n (>0): trace storage is triggered if the signal value exceeds baseline+n (digital units)."
		//primary trigger level
		make /o/n=(1) $ksSP2configPrimaryTriggerLevel=NaN
		wave PrimaryTriggerLevel=$ksSP2configPrimaryTriggerLevel
		note PrimaryTriggerLevel, "Trigger level for primary channel;"
		note PrimaryTriggerLevel, "This value is given in absolute digital units (i.e. not relative to baseline);"
		note PrimaryTriggerLevel, "Note, this trigger level is only used, if PrimaryDelta=0;"
		//secondary trigger level
		make /o/n=(1) $ksSP2configSecondaryTrigLevel=NaN
		wave SecondaryTriggerLevel=$ksSP2configSecondaryTrigLevel
		note SecondaryTriggerLevel, "Trigger level for secondary channel;"
		note SecondaryTriggerLevel, "This value is given in absolute digital units (i.e. not relative to baseline);"
		note SecondaryTriggerLevel, "Note, this trigger level is only used, if SecondaryDelta=0;"
		//number of points in traces
		make /o/n=(1) $ksSP2configNumberOfPoints=TraceLen
		wave NumberOfPoints=$ksSP2configNumberOfPoints
		note NumberOfPoints, "Number of points in raw data traces;"
		//number of  pretrigger points
		make /o/n=(1) $ksSP2configNumberOfPretrigger=PreTrigNum
		wave NumberOfPretrigger=$ksSP2configNumberOfPretrigger
		note NumberOfPretrigger, "Number of baseline points recorded before trigger threshold is reached;"
		//Scan length
		make /o/n=(1) $ksSP2configScanLength=NaN
		wave ScanLength=$ksSP2configScanLength
		note ScanLength, "Number of points acquired and analysed in one burst;"
		//Saturation
		make /o/n=(1) $ksSP2configSaturation=NaN
		wave Saturation=$ksSP2configSaturation
		note Saturation, "Whenever a signal has a digital value greater than this value, it is considered to be saturated and the flag is set;"
		//Write Data
		make /o/n=(1) $ksSP2configWriteData=NaN
		wave WriteData=$ksSP2configWriteData
		note WriteData, "This parameter is used in conjunction with the 'Out Of' parameter to limit the amount of time during which data is collected."
		note WriteData, "0: all data acquired is saved to disk."
		note WriteData," e.g. 5: Then 5 minutes of data out of the interval specified by the 'Out Of' parameter will be saved to disk."
		//Out of
		make /o/n=(1) $ksSP2configOutOf=NaN
		wave OutOf=$ksSP2configOutOf
		note OutOf, "This parameter is used with the 'Write Data' parameter to limit how much data is actually saved."
		note OutOf, "Interval length between data saves of length 'Write Data' (minutes)."
		//1 of every (at saving)
		make /o/n=(1) $ksSP2configOneOfEverySaved=OneOfEverySavedVal
		wave OneOfEverySaved=$ksSP2configOneOfEverySaved
		note OneOfEverySaved, "1: the program acquired data as fast as possible, i.e. every triggered particle was saved."
		note OneOfEverySaved, "Integer n (>1): the program saved only 1 out of every n triggerd particles."
		//sample flow set
		make /o/n=(1) $ksSP2configSampleFlowSet=SampleFlowSetVal
		wave SampleFlowSet=$ksSP2configSampleFlowSet
		note SampleFlowSet, "Set sample flow rate [cm/min];"
		//description of chan0:
		make /o/t/n=(1) $ksSP2configDescriptChan0=""
		wave /t DescriptChan0=$ksSP2configDescriptChan0
		note DescriptChan0, "Description of channel 0;"
		//description of chan1:
		make /o/t/n=(1) $ksSP2configDescriptChan1=""
		wave /t DescriptChan1=$ksSP2configDescriptChan1
		note DescriptChan1, "Description of channel 1;"
		//description of chan2:
		make /o/t/n=(1) $ksSP2configDescriptChan2=""
		wave /t DescriptChan2=$ksSP2configDescriptChan2
		note DescriptChan2, "Description of channel 2;"
		//description of chan3:
		make /o/t/n=(1) $ksSP2configDescriptChan3=""
		wave /t DescriptChan3=$ksSP2configDescriptChan3
		note DescriptChan3, "Description of channel 3;"
		//description of chan4:
		make /o/t/n=(1) $ksSP2configDescriptChan4=""
		wave /t DescriptChan4=$ksSP2configDescriptChan4
		note DescriptChan4, "Description of channel 4;"
		//description of chan5:
		make /o/t/n=(1) $ksSP2configDescriptChan5=""
		wave /t DescriptChan5=$ksSP2configDescriptChan5
		note DescriptChan5, "Description of channel 5;"
		//description of chan6:
		make /o/t/n=(1) $ksSP2configDescriptChan6=""
		wave /t DescriptChan6=$ksSP2configDescriptChan6
		note DescriptChan6, "Description of channel 6;"
		//description of chan7:
		make /o/t/n=(1) $ksSP2configDescriptChan7=""
		wave /t DescriptChan7=$ksSP2configDescriptChan7
		note DescriptChan7, "Description of channel 7;"
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end



Function SP2_ParseConfigFile(ConfigWav [inifileformat])
	//Parser for SP2 configuration data.
	//return value: 0; not used
	//note: the parsed waves are created in the data folder of 'ConfigWav'
	//martin.gysel@psi.ch; 17/09/2009, 03/06/2010, 22/10/2010, 18/11/2010
	wave /t ConfigWav	//1-D text wave containing the ".ini"-file
	variable inifileformat	//ID for format of ini-file
						//0: same software version as PSI's SP2
						//1: same software version as Kaspari's SP2
						//default: determine from beginning of file
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	string configfldrfp=getwavesdatafolder(ConfigWav,1)
	variable nRows=dimsize(ConfigWav,0)
	//determine format of ini-file
	if (paramisdefault(inifileformat))
		string firstlinewithoutspace=ReplaceString(" ", ConfigWav[0], "")
		if (stringmatch(firstlinewithoutspace, "[Common]*" ))
			inifileformat=0
		elseif (stringmatch(firstlinewithoutspace, "[Versions]*" ))
			inifileformat=1		
		endif
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2configFileParser
	string tmpfldrpath=getdatafolder(1)
	make /o/t/n=(nRows) KeyWav=replacestring(" ",stringfromlist(0,ConfigWav[p], "="), "")
	make /o/t/n=(nRows) ValueStrWav=replacestring(" ",stringfromlist(1,ConfigWav[p], "="), "")
	//prepare waves for configuration data
	SP2_CreateConfigDataWaves(configfldrfp, NaN, NaN, NaN, NaN)
	//access configuration data waves
	setdatafolder $configfldrfp
	wave Channel0=$ksSP2configChannel0	
	wave Channel1=$ksSP2configChannel1	
	wave Channel2=$ksSP2configChannel2	
	wave Channel3=$ksSP2configChannel3	
	wave Channel4=$ksSP2configChannel4
	wave Channel5=$ksSP2configChannel5	
	wave Channel6=$ksSP2configChannel6	
	wave Channel7=$ksSP2configChannel7	
	wave SamplePerSec=$ksSP2configSamplesPSec
	wave PrimaryChanNum=$ksSP2configPrimaryChanNum
	wave SecondaryChanNum=$ksSP2configSecondaryChanNum
	wave UsePrimaryTrigger=$ksSP2configUsePrimaryTrigger
	wave UseSecondaryTrigger=$ksSP2configUseSecondaryTrigger
	wave PrimaryDelta=$ksSP2configPrimaryDelta
	wave SecondaryDelta=$ksSP2configSecondaryDelta
	wave PrimaryTriggerLevel=$ksSP2configPrimaryTriggerLevel
	wave SecondaryTriggerLevel=$ksSP2configSecondaryTrigLevel
	wave NumberOfPoints=$ksSP2configNumberOfPoints
	wave NumberOfPretrigger=$ksSP2configNumberOfPretrigger
	wave ScanLength=$ksSP2configScanLength
	wave Saturation=$ksSP2configSaturation
	wave WriteData=$ksSP2configWriteData
	wave OutOf=$ksSP2configOutOf
	wave OneOfEverySaved=$ksSP2configOneOfEverySaved
	wave SampleFlowSet=$ksSP2configSampleFlowSet
	wave /t DescriptChan0=$ksSP2configDescriptChan0
	wave /t DescriptChan1=$ksSP2configDescriptChan1
	wave /t DescriptChan2=$ksSP2configDescriptChan2
	wave /t DescriptChan3=$ksSP2configDescriptChan3
	wave /t DescriptChan4=$ksSP2configDescriptChan4
	wave /t DescriptChan5=$ksSP2configDescriptChan5
	wave /t DescriptChan6=$ksSP2configDescriptChan6
	wave /t DescriptChan7=$ksSP2configDescriptChan7
	//parse file into data waves
	switch(inifileformat)	
		case 0:		
			//Data acquisition software 2.9.5 (PSI's-SP2)
			Channel0=1
			Channel1=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2configChannel1Key, KeyWav)], ""))
			Channel2=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2configChannel2Key, KeyWav)], ""))
			Channel3=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2configChannel3Key, KeyWav)], ""))
			Channel4=0
			Channel5=0
			Channel6=0
			Channel7=0
			SamplePerSec=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configSamplesPsecKey, KeyWav)])
			PrimaryChanNum=0
			SecondaryChanNum=1
			UsePrimaryTrigger=1
			UseSecondaryTrigger=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2configUseCh1TriggerKey, KeyWav)], ""))
			PrimaryDelta=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configCh0DeltaKey, KeyWav)])			
			SecondaryDelta=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configCh1DeltaKey, KeyWav)])				
			PrimaryTriggerLevel=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configCh0TrigLevelKey, KeyWav)])
			SecondaryTriggerLevel=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configCh1TrigLevelKey, KeyWav)])
			NumberOfPoints=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configNumberOfPointsKey, KeyWav)])
			NumberOfPretrigger=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configNumberOfPretrigKey, KeyWav)])
			ScanLength=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configScanLengthKey, KeyWav)])
			Saturation=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configSaturationKey, KeyWav)])		
			WriteData=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configWriteDataKey, KeyWav)])
			OutOf=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configOutOfKey, KeyWav)])
			OneOfEverySaved=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config1ofEveryKey, KeyWav)])
			SampleFlowSet=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2configSampleFlowSetKey, KeyWav)])
			break			
		case 1:		
			//Data acquisition software 4.0.3 (Kaspari's-SP2)
			Channel0=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel0Key, KeyWav)], ""))
			Channel1=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel1Key, KeyWav)], ""))
			Channel2=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel2Key, KeyWav)], ""))
			Channel3=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel3Key, KeyWav)], ""))
			Channel4=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel4Key, KeyWav)], ""))
			Channel5=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel5Key, KeyWav)], ""))
			Channel6=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel6Key, KeyWav)], ""))
			Channel7=stringmatch("True",replacestring(" ",ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403Channel7Key, KeyWav)], ""))
			SamplePerSec=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403SamplesPsecKey, KeyWav)])
			PrimaryChanNum=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403PrimChanNumKey, KeyWav)])
			SecondaryChanNum=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403SecondChanNumKey, KeyWav)])
			UsePrimaryTrigger= PrimaryChanNum >= 0			//not sure whether this interpretation of the ini file is correct
			UseSecondaryTrigger= SecondaryChanNum >= 0	//not sure whether this interpretation of the ini file is correct
			PrimaryDelta=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403PrimaryDeltaKey, KeyWav)])			
			SecondaryDelta=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403SecondaryDeltaKey, KeyWav)])				
			PrimaryTriggerLevel=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403PrimTrigLevelKey, KeyWav)])		//not sure whether this interpretation of the ini file is correct
			SecondaryTriggerLevel=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403SeconTrigLevelKey, KeyWav)])	//not sure whether this interpretation of the ini file is correct
			NumberOfPoints=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403NumberOfPointsKey, KeyWav)])
			NumberOfPretrigger=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403NumbOfPretrigKey, KeyWav)])
			ScanLength=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403ScanLengthKey, KeyWav)])
			Saturation=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403SaturationKey, KeyWav)])		
			WriteData=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403WriteDataKey, KeyWav)])
			OutOf=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403OutOfKey, KeyWav)])
			OneOfEverySaved=str2num(ValueStrWav[StringSearchIn1DtxtWav(ksSP2config4031ofEveryKey, KeyWav)])
			SampleFlowSet=NaN		//ksSP2config403sampflowdirtyhack
			DescriptChan0=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan0Key, KeyWav)]
			DescriptChan1=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan1Key, KeyWav)]
			DescriptChan2=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan2Key, KeyWav)]
			DescriptChan3=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan3Key, KeyWav)]
			DescriptChan4=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan4Key, KeyWav)]
			DescriptChan5=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan5Key, KeyWav)]
			DescriptChan6=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan6Key, KeyWav)]
			DescriptChan7=ValueStrWav[StringSearchIn1DtxtWav(ksSP2config403DescriptChan7Key, KeyWav)]
			break			
		default:							
			setdatafolder $savedDF
			message="Undefined value of the parameter 'inifileformat' in the function "+currproc+"!"
			message="Dimension mismatch of the waves 'ParName1' and 'ParName2' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message							
	endswitch
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


Function SP2_LoadConfigFile(configfilefp, configfldrfp, Omode)
	//This function loads one SP2 configuration file (".ini")
	//return value: 1 if a file has been loaded, 0 otherwise.
	//martin.gysel@psi.ch; 06/11/2008, 08/11/2008, 15/04/2010, 03/06/2010
	string configfilefp		//full path to configuration file to be loaded
	string configfldrfp		//full path to folder into which the configuration-data are to be loaded
	variable Omode		//1: overwrite previous data if target folder exists already
						//0: prompt before overwriting previous data
					
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//check input
	if (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	//check whether target folder exists already
	string overwrite="NO"
	string pstr="YES;NO"
	if (Omode!=1)
		do	
			if (datafolderexists(configfldrfp))
				prompt overwrite, "Target folder exists already => overwrite?", popup, pstr
				doprompt "Overwrite?", overwrite
				if (stringmatch("YES", overwrite))
					break
				else
					prompt configfldrfp, "Select target folder for configuration data:"
					doprompt "Select Folder", configfldrfp
					if (V_flag)
						setdatafolder $savedDF
						message="user cancelled procedure"+currproc+"!"
						print message; print RTStackInfo; abort message
					endif		
				endif
			else
				break
			endif
		while (1)
	endif
	CreateFoldersOfFullPath(configfldrfp, 0)
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 configfilefp
	if (V_isAliasShortcut)
		configfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 configfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			configfilefp=S_aliasPath
		endif
	endif
	//load configuration file
	string ConfigFileWavNam=laststringfromlist(ksSP2configdataAll,listsepstr=":")
	setdatafolder $configfldrfp
	ConfigFileWavNam=LoadDelimitTxtFileTo1DWavNoAbrt(ConfigFileWavNam, PathToFile=configfilefp, Omode=1)
	if (stringmatch("NoFileLoaded",ConfigFileWavNam))
		return 0
	endif
	wave /t ConfigDataAll=$ConfigFileWavNam
	//parse configuration file
	SP2_ParseConfigFile(ConfigDataAll)
	//transpose wave containing all configuration information
	redimension /n=(1,numpnts(ConfigDataAll)) ConfigDataAll
	//add wave containing unique file ID
	string configfilenam=laststringfromlist(configfilefp, listsepstr=":")
	make /o/n=1/d $ksSP2configUniqueFileIDini=SP2filename2UniqueFileID(configfilenam)
	wave /d UniqueFileIDini=$ksSP2configUniqueFileIDini
	setscale d 0,0,"dat", UniqueFileIDini
	note UniqueFileIDini, "Unique ID of configuration file ("+ksSP2iniFileEnd+");"
	note UniqueFileIDini, "Igor time, where the date represents the file data and the seconds since midnight the file number;"
	//finish procedure
	setdatafolder $savedDF
	return 1			
End


Function SP2_TA_Incand_MT(channeltype, rawdatafp, PBPfldrfp, nPts4baselineWav, nPts4IncPeakHt, BaselineFilter, MatchNarrToBroad [BaselineDelta])
	//This function analyses SP2's raw traces from the incandescence channels.
	//Note: This function uses a basic peak find algorithm adapted from the procedure "SP2IncandAvgBaseFit" from DMT's PAPI software.
	//return value: 0; not used
	//martin.gysel@psi.ch;	10/11/2008; 11/07/2009, 06/10/2009, 07/01/2010, 08/01/2010, 26/04/2010, 27/04/2010, 18/05/2010, 20/11/2010, 07/12/2011, 15/12/2011;
	//						26/09/2012
	variable channeltype		//2: high gain broadband data
							//4: high gain narrowband data
							//32: low gain broadband data
							//64: low gain narrowband data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
	variable nPts4IncPeakHt	//number of points to be averaged for peak height of incandescence signals
							//note: will be rounded to the next odd number below
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
	variable MatchNarrToBroad		//0:	narrowband peak is searched anywhere in the trace
								//1:	narrowband peak is only searched near the broadband peak; narrowband peaks are ignored if there is no valid broadband peak
								//note: MatchNarrToBroad is ignored if corresponding broadband data are not available
								//note: MatchNarrToBroad is ignored for analysing broadband data
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//default: inf (i.e. equal to Baselinefiltetr=0)
	 
	//Start timing.
	variable timerRefNum = StartMSTimer
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//set defaults
	if (paramisdefault(BaselineDelta))
		BaselineDelta=inf
	endif
	//check input
	if (BaselineFilter!=0 && BaselineFilter!=1)
		//value of 'BaselineFilter' is not defined
		setdatafolder $savedDF
		message="The parameter 'BaselineFilter' handed over to the function "+currproc+" must be 0 or 1!"
		print message;print RTStackInfo;abort message										
	endif
	if (MatchNarrToBroad!=0 && MatchNarrToBroad!=1)
		//value of 'MatchNarrToBroad' is not defined
		setdatafolder $savedDF
		message="The parameter 'MatchNarrToBroad' handed over to the function "+currproc+" must be 0 or 1!"
		print message;print RTStackInfo;abort message										
	endif
	//make "nPts4IncPeakHt" odd (next below)
	nPts4IncPeakHt-=mod(nPts4IncPeakHt+1,2)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//channel specific
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitBBHG:
			//broadband high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigBBHG
			ChanPrefix=ksSP2BBHGprefix
			MatchNarrToBroad=0		//force it to 0, i.e. broadband peaks are searched in the whole trace	
			break
		case kSP2chanbitBBLG:
			//broadband low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigBBLG
			ChanPrefix=ksSP2BBLGprefix
			MatchNarrToBroad=0		//force it to 0, i.e. broadband peaks are searched in the whole trace	
			break
		case kSP2chanbitNBHG:
			//narrowband high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigNBHG
			ChanPrefix=ksSP2NBHGprefix
			//access broadband high gain fit results if needed
			if (MatchNarrToBroad)
				setdatafolder $PBPfldrfp			
				wave /Z PeakStartBroad=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakStart
				wave /Z PeakEndBroad=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakEnd
				if (!waveexists(PeakStartBroad) || !waveexists(PeakEndBroad))
					MatchNarrToBroad=0		//no broadband data available => search for peaks in the whole trace
				endif
			endif
			break
		case kSP2chanbitNBLG:
			//narrowband low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigNBLG
			ChanPrefix=ksSP2NBLGprefix
			//access broadband low gain fit results if needed
			if (MatchNarrToBroad)
				setdatafolder $PBPfldrfp
				wave /z PeakStartBroad=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakStart
				wave /z PeakEndBroad=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakEnd
				if (!waveexists(PeakStartBroad) || !waveexists(PeakEndBroad))
					MatchNarrToBroad=0		//no broadband data available => search for peaks in the whole trace
				endif
			endif
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string ChanDescript=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//access raw trace matrix
	setdatafolder $rawdatafp
	wave /z tracemat=$ChanPrefix+ksSP2rawtracemat
	//trace analysis
	if (!waveexists(tracemat))
		//raw trace matrix not available => nothing to be analysed
	else
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//temporary waves
			make /FREE/n=(nRows) TempResult
			//tweak to avoid error when handing an entry of this wave over to the sub-procedure
			if (MatchNarrToBroad==0)
				wave PeakStartBroad=TempResult
				wave PeakEndBroad=TempResult
			endif
			//create fit result waves
			CreateFoldersOfFullPath(pbpfldrfp, 0)
			setdatafolder $pbpfldrfp
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
			wave saturated=$ChanPrefix+ksSP2PBPsaturated
			note saturated, "Saturation of "+ChanDescript+" detector:"
			note saturated, "0: not saturated;"
			note saturated, "1: saturated;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitOffset=NaN
			wave Offset=$ChanPrefix+ksSP2PBPtracefitOffset
			note Offset, "baseline of "+ChanDescript+" detector;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHt=NaN
			wave PeakHt=$ChanPrefix+ksSP2PBPtracefitPeakHt
			note PeakHt, "peak height obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakStart=NaN
			wave PeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
			note PeakStart, "start position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakEnd=NaN
			wave PeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
			note PeakEnd, "end position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfRise=NaN
			wave PeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
			note PeakHalfRise, "half rise position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfDecay=NaN
			wave PeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
			note PeakHalfDecay, "half decay position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakPos=NaN
			wave PeakPos=$ChanPrefix+ksSP2PBPtracefitPeakPos
			note PeakPos, "peak position obtained by fitting the "+ChanDescript+" signal;"
			//get peak properties
				//various variables
//xx				variable PeakWidthThreshold=kSP2minValidPeakWidthInc*SamplingRateRawDataMHz
				//Determine baseline
				Multithread offset=SP2_TA_GetBaseline_TS(tracemat, p, nRows, nPts4baselineWav[p], BaselineFilter, BaselineDelta)					
				//analyze the incandescence peak
				Multithread TempResult=SP2_TA_FitPeakIncand_TS(tracemat, p, nRows, tracelen, MatchNarrToBroad, PeakStartBroad[p], PeakEndBroad[p], nPts4IncPeakHt, MaxSigVal, Offset, PeakHt, PeakPos, PeakStart, PeakEnd, PeakHalfRise, PeakHalfDecay, saturated, 0)
	endif
	//Display elapsed time.
	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//	Printf "TA incandescence (MT): %.2f seconds\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2IncandGaussianBaselineFit(channeltype, rawdatafp, PBPfldrfp)
	//This function analyses SP2's raw traces from the incandescence channels
	//return value: 0; not used
	//Note:	This function uses a Gaussian fit to find the baseline of the trace. Peak height, position, start, half rise, half decay and end
	//	are determined in a basic way. The algorithm has been adapted from the procedure "SP2IncandGaussBaseFit" from DMT's PAPI software.
	//martin.gysel@psi.ch; 10/11/2008, 06/10/2009, 27/04/2010, 18/05/2010, 20/11/2010; not tested
	variable channeltype		//2: high gain broadband data
							//4: high gain narrowband data
							//32: low gain broadband data
							//64: low gain narrowband data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	 
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2fit
	string tmpfldrpath=getdatafolder(1)
	//channel specific
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitBBHG:
			//broadband high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigBBHG
			ChanPrefix=ksSP2BBHGprefix
			break
		case kSP2chanbitBBLG:
			//broadband low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigBBLG
			ChanPrefix=ksSP2BBLGprefix
			break
		case kSP2chanbitNBHG:
			//narrowband high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigNBHG
			ChanPrefix=ksSP2NBHGprefix
			break
		case kSP2chanbitNBLG:
			//narrowband low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigNBLG
			ChanPrefix=ksSP2NBLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string ChanDescript=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//Start timing.
	variable timerRefNum = StartMSTimer
	//access raw data waves
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//trace analysis
	if (waveexists(tracemat))
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//create fit result waves
			setdatafolder $pbpfldrfp
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
			wave saturated=$ChanPrefix+ksSP2PBPsaturated
			note saturated, "Saturation of "+ChanDescript+" detector/DAQ:"
			note saturated, "0: not saturated;"
			note saturated, "1: saturated;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitOffset=NaN
			wave Offset=$ChanPrefix+ksSP2PBPtracefitOffset
			note Offset, "baseline of "+ChanDescript+" detector;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHt=NaN
			wave PeakHt=$ChanPrefix+ksSP2PBPtracefitPeakHt
			note PeakHt, "peak height obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakStart=NaN
			wave PeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
			note PeakStart, "start position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakEnd=NaN
			wave PeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
			note PeakEnd, "end position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfRise=NaN
			wave PeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
			note PeakHalfRise, "half rise position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfDecay=NaN
			wave PeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
			note PeakHalfDecay, "half decay position of peak obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakPos=NaN
			wave PeakPos=$ChanPrefix+ksSP2PBPtracefitPeakPos
			note PeakPos, "peak position obtained by fitting the "+ChanDescript+" signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPincFittedBLfitError=NaN
			wave incGaussFitError=$ChanPrefix+ksSP2PBPincFittedBLfitError
			note incGaussFitError, "bit0=1: singular matrix;"		
			note incGaussFitError, "bit1=2: out of memory;"		
			note incGaussFitError, "bit2=4: function returned NaN or INF;"		
			//temporary waves
			setdatafolder $tmpfldrpath
			make /o/n=(tracelen) currtrace
			wave currtrace
			//loop over rows of raw data matrix and fit.
			variable rind, tind, StartEndLevel
//			variable PeakWidthThreshold=kSP2minValidPeakWidthInc*SamplingRateRawDataMHz
			setdatafolder $tmpfldrpath
			Variable /g V_fitOptions=4
			Variable /g V_fitError
			for (rind=0;rind<nRows;rind+=1)
				//Put data from current row rind into temporary wave.
				currtrace=tracemat[rind][p]		
				//Gaussian fit to determine baseline.
				V_fitError=0
				CurveFit/N/NTHR=0/Q gauss currtrace				
				Wave W_coef; NVar V_FitError
				incGaussFitError[rind]=V_FitError
				if (V_FitError==0)
					offset[rind]=W_coef[0]
				else
					offset[rind]=NaN
				endif
				//continue analysis only if baseline was found
				if (numtype(offset[rind])==0)			
					//check whether detector is saturated
					WaveStats/Q currtrace
					if (V_max>=MaxSigVal)
						saturated[rind]=1
					endif
					//Determine peak height and location.
					if ((V_max-offset[rind])>1 &&V_maxloc>0 && V_maxloc<tracelen)		//Initial filtering: peak ht. > 1 and 0 < peak pos. < number of data points.
						PeakHt[rind]=(V_max-offset[rind])
						PeakPos[rind]=V_maxloc
					else
						offset[rind]=NaN								//If doesn't pass initial filtering test, make sure rest of waves are NaN at that point.
					endif
					if (numtype(offset[rind])==0)						//continue only if passed initial filtering	
						StartEndLevel=kSP2incStartEndDeltaPerc*PeakHt[rind]+offset[rind]
						//Determine peak start point.
						for (tind=PeakPos[rind];tind>0;tind-=1)
							if ((currtrace[tind]) < StartEndLevel)
								PeakStart[rind]=tind
								break
							endif
						endfor
						//Determine peak end point.
						for (tind=PeakPos[rind];tind<tracelen;tind+=1)
							if ((currtrace[tind]) < StartEndLevel)
								PeakEnd[rind]=tind
								break
							endif
						endfor
//						//filter noisy spikes based on their small width
//						if (PeakEnd[rind]-PeakStart[rind]>PeakWidthThreshold)	//proceed only if peak is sufficiently wide
//							//Determine half peak rise point.
//							for (tind=PeakPos[rind];tind>0;tind-=1)
//								if ((currtrace[tind]-offset[rind]) <= (0.5*PeakHt[rind]))
//									PeakHalfRise[rind]=tind
//									break
//								endif
//							endfor
//							//Determine half peak decay point.
//							for (tind=PeakPos[rind];tind<(numpnts(currtrace));tind+=1)
//								if ((currtrace[tind]-offset[rind]) <= (0.5*PeakHt[rind]))
//									PeakHalfDecay[rind]=tind
//									break
//								endif
//							endfor
//						else
//							//peak too narrow => considered to be a noisy spike
//							PeakHt[rind]=kSP2filteredPeakDummyPkHt
//							PeakPos[rind]=NaN
//							offset[rind]=NaN
//							PeakStart[rind]=NaN
//							PeakEnd[rind]=NaN
//						endif
					endif
				endif
			endfor	
	else
		//raw trace matrix not available
			//=> create dummy result waves if needed
	endif
	//Display elapsed time.
	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//	Printf "Elapsed time: %.2f seconds\r\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	return 0
End



//Override Function SP2_TA_Scattering_MT(channeltype, rawdatafp, PBPfldrfp, FitMode, nPts4PeakHt, nPts4baselineWav, BaselineFilter, BaselineDelta, GetSAI, SAIstartUS, SAIendUS, IncPrefixForSAI)
Function SP2_TA_ScatteringSlower_MT(channeltype, rawdatafp, PBPfldrfp, FitMode, nPts4PeakHt, nPts4baselineWav, BaselineFilter, BaselineDelta, GetSAI, SAIstartUS, SAIendUS, IncPrefixForSAI)
	//NOTE: THIS FUNCTION WAS NEVER USED, AS I WAS ABLE TO WRITE A FASTER VARIANT
	//This function analyses SP2's raw traces from the scattering channels.
	//Note: This function was originally based on the procedure "SP2IncandAvgBaseFit" from DMT's PAPI software.
	//return value: 0; not used
	//martin.gysel@psi.ch;	10/11/2008, 11/07/2009, 18/08/2009; 06/10/2010, 26/04/2010, 27/04/2010, 18/05/2010, 26/05/2010, 28/05/2010,
	//						04/11/2010, 12/05/2011, 18/05/2011, 19/05/2011; 15/12/2011; 24/09/2012
	//marie.laborde@psi.ch; 29/10/09
	variable channeltype		//1: high gain scattering data
							//16: low gain scattering data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	variable	FitMode			//fit type for scattering channel data
							//0: baseline + peak height from Gaussian fit
							//1: baseline from pretrigger points, peak height from Gaussian fit
							//2: baseline from pretrigger points, peak height from maximum value
	variable nPts4PeakHt		//number of points to be averaged for peak height of scattering signals
							//note: will be rounded to the next odd number below
							//note: must be provided if FitMode=2, ignored otherwise
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//note: must be provided if BaselineFilter=1 and if FitMode=1 or 2, ignored otherwise
	variable GetSAI		//1: get scattering signal amplitude just before incandescence peak
							//0: skip it
	variable SAIstartUS	//start of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	variable SAIendUS	//end of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	string IncPrefixForSAI	//prefix of incandescence channel to be used for position of incandescence peak
								//e.g: ":BBHG_" 
								//only required if GetSAI=1
								 
	//Start timing.
	variable timerRefNum = StartMSTimer
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//various FitMode specific preparations
	string FitHoldStr
	switch(FitMode)
		case 0:
			//nothing TBD
			break
		case 1:
			//nothing TBD
			break
		case 2:			
			nPts4PeakHt-=mod(nPts4PeakHt+1,2)		//make "nPts4PeakHt" odd (coerce to next odd number below)
			break
		default:	
			setdatafolder $savedDF
			message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//channel specific
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitSCHG:
			//scattering high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCHG
			ChanPrefix=ksSP2SCHGprefix
			break
		case kSP2chanbitSCLG:
			//scattering low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCLG
			ChanPrefix=ksSP2SCLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string ChanDescript=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//preparations for analysis of scattering signal at incandescence
	variable SAIstartDeltaPts=round(SAIstartUS*SamplingRateRawDataMHz)
	variable SAIendDeltaPts=round(SAIendUS*SamplingRateRawDataMHz)
	//write info string
	setdatafolder $PBPfldrfp
	string /g $ksSP2traceAnalysisInfoStr=""
	Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr			
	TraceAnalysisInfoStr+=ksSP2SAIdeltaStartKey+": "+num2str(SAIstartDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIdeltaEndKey+": "+num2str(SAIendDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIchanPrefixIncKey+": "+IncPrefixForSAI+"\r"
	//access raw trace matrix
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//access PBP waves
	setdatafolder $PBPfldrfp
	wave /Z IncPeakHalfDecay=$IncPrefixForSAI+ksSP2PBPtracefitPeakHalfDecay
	wave /Z IncandPos=$IncPrefixForSAI+ksSP2PBPtracefitPeakPos
	GetSAI=GetSAI && waveexists(IncandPos)
	//trace analysis
	if (!waveexists(tracemat))
		//raw trace matrix not available => nothing to be analysed
	else
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//create fit result waves
			CreateFoldersOfFullPath(PBPfldrfp, 0)
			setdatafolder $PBPfldrfp
			make /o/n=(nRows) $chanprefix+ksSP2PBPsaturated=0
			wave saturated=$chanprefix+ksSP2PBPsaturated
			note saturated, "Saturation of "+ChanDescript+" detector:"
			note saturated, "0: not saturated;"
			note saturated, "1: saturated;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGaussoffset=NaN
			wave Offset=$chanprefix+ksSP2PBPscattGaussoffset					
			note Offset, "baseline of "+ChanDescript+" detector;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakHeight=NaN
			wave PeakHt=$chanprefix+ksSP2PBPscattGausspeakHeight			
			note PeakHt, "peak height of "+ChanDescript+" signal;"
			note PeakHt, "note: obtained by averageing the selected number of points around the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakPos=NaN
			wave PeakPos=$chanprefix+ksSP2PBPscattGausspeakPos				
			note PeakPos, "position of "+ChanDescript+" signal;"
			note PeakPos, "note: this is identical to "+chanprefix+ksSP2PBPscattMaxPos+" if the peak height is obtained by searching the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPos=NaN		//ml
			wave MaxPos=$chanprefix+ksSP2PBPscattMaxPos		//ml		
			note MaxPos, "position of the global maximum of the "+ChanDescript+" signal;"			//ml
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPeakHeight=NaN		//ml
			wave MaxPeakHt=$chanprefix+ksSP2PBPscattMaxPeakHeight		//ml		
			note MaxPeakHt, "peak height of the "+ChanDescript+" signal determined from global maximum;"			//ml
			note MaxPeakHt, "peak height relative to baseline from pretrigger points;"
			note MaxPeakHt, "note: obtained from the single global maximum value;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakFWHM=NaN
			wave PeakFWHM=$chanprefix+ksSP2PBPscattGausspeakFWHM		
			note PeakFWHM, "FWHM of "+ChanDescript+" signal;" 
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPos=NaN
			wave MaxB4incPos=$chanprefix+ksSP2PBPscattMaxB4incPos
			note MaxB4incPos, "position of the maximum of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPeakHeight=NaN
			wave MaxB4incPeakHt=$chanprefix+ksSP2PBPscattMaxB4incPeakHeight
			note MaxB4incPeakHt, "maximum peak height of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			note MaxB4incPeakHt, "peak height relative to baseline from pretrigger points;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattSigAtIncand=NaN
			wave ScattFitSigAtIncand=$chanprefix+ksSP2PBPscattSigAtIncand
			note ScattFitSigAtIncand, "amplitude of the "+ChanDescript+" signal just before incandescence;"
			note ScattFitSigAtIncand, "details on data analysis settings are stored in the string "+ksSP2traceAnalysisInfoStr+";"
			//FitMode specific
			if (FitMode==0 || FitMode==1)
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakChiSqr=NaN
				wave PeakChiSqr=$chanprefix+ksSP2PBPscattGausspeakChiSqr		
				note PeakChiSqr, "ChiSqr of Gaussian fitted to "+ChanDescript+" signal;"
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattFittedBLfitError=NaN
				wave FitError=$chanprefix+ksSP2PBPscattFittedBLfitError				
				note FitError, "bit0=1: singular matrix;"		
				note FitError, "bit1=2: out of memory;"		
				note FitError, "bit2=4: function returned NaN or INF;"					
			elseif (FitMode==2)
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakStart=NaN
				wave PeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
				note PeakStart, "start position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakEnd=NaN
				wave PeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
				note PeakEnd, "end position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfRise=NaN
				wave PeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
				note PeakHalfRise, "half rise position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfDecay=NaN
				wave PeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
				note PeakHalfDecay, "half decay position of peak of the "+ChanDescript+" signal;"			
			else
				setdatafolder $savedDF
				message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
				print message;print RTStackInfo;abort message	
			endif
			//Multithreaded signal analysis
				//preparations
				make/o/FREE/WAVE/n=(nRows) ResultWavRefs
				variable GetMaxB4incPos
				if (waveexists(IncPeakHalfDecay))
					GetMaxB4incPos=1
				else
					GetMaxB4incPos=0
				endif
				//fit
				Multithread ResultWavRefs=SP2_TA_ScattFitWorker_TS(tracemat, p, FitMode, nPts4PeakHt, nPts4baselineWav[p], BaselineFilter, BaselineDelta, GetMaxB4incPos, IncPeakHalfDecay[p], GetSAI, IncandPos[p], SAIstartDeltaPts, SAIendDeltaPts, MaxSigVal, SamplingRateRawDataMHz)
				//extract results
				variable rind
				for (rind=0; rind<nRows; rind+=1)
					//access fit results
					wave SignalProps=ResultWavRefs[rind]
					//copy trace analysis results to target wave			
					Offset[rind]=SignalProps[0]
					saturated[rind]=SignalProps[1]
					PeakHt[rind]=SignalProps[2]
					MaxPos[rind]=SignalProps[3]
					MaxPeakHt[rind]=SignalProps[4]
					MaxB4incPos[rind]=SignalProps[5]
					MaxB4incPeakHt[rind]=SignalProps[6]
					ScattFitSigAtIncand[rind]=SignalProps[7]
					PeakPos[rind]=SignalProps[9]
					PeakFWHM[rind]=SignalProps[10]
					//FitMode specific
					if (FitMode==0 || FitMode==1)
						FitError[rind]=SignalProps[8]
						PeakChiSqr[rind]=SignalProps[11]
					elseif (FitMode==2)
						PeakStart[rind]=SignalProps[12]
						PeakEnd[rind]=SignalProps[13]
						PeakHalfRise[rind]=SignalProps[14]
						PeakHalfDecay[rind]=SignalProps[15]
					endif
				endfor
	endif
	//Display elapsed time.
//	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//		Printf "TA scattering MT 2nd attempt: %.2f seconds\r\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_TA_Scattering_MT(channeltype, rawdatafp, PBPfldrfp, FitMode, nPts4PeakHt, nPts4baselineWav, BaselineFilter, BaselineDelta, GetSAI, SAIstartUS, SAIendUS, IncPrefixForSAI)
	//This function analyses SP2's raw traces from the scattering channels.
	//return value: 0; not used
	//martin.gysel@psi.ch;	10/11/2008, 11/07/2009, 18/08/2009; 06/10/2010, 26/04/2010, 27/04/2010, 18/05/2010, 26/05/2010, 28/05/2010,
	//						04/11/2010, 12/05/2011, 18/05/2011, 19/05/2011; 15/12/2011; 21/09/2012, 25/09/2012
	//marie.laborde@psi.ch; 29/10/09
	variable channeltype		//1: high gain scattering data
							//16: low gain scattering data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	variable	FitMode			//fit type for scattering channel data
							//0: baseline + peak height from Gaussian fit
							//1: baseline from pretrigger points, peak height from Gaussian fit
							//2: baseline from pretrigger points, peak height from maximum value
	variable nPts4PeakHt		//number of points to be averaged for peak height of scattering signals
							//note: will be rounded to the next odd number below
							//note: must be provided if FitMode=2, ignored otherwise
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//note: must be provided if BaselineFilter=1 and if FitMode=1 or 2, ignored otherwise
	variable GetSAI			//1: get scattering signal amplitude just before incandescence peak
							//0: skip it
	variable SAIstartUS	//start of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	variable SAIendUS	//end of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	string IncPrefixForSAI	//prefix of incandescence channel to be used for position of incandescence peak
								//e.g: ":BBHG_" 
								//only required if GetSAI=1
								 
	//Start timing.
	variable timerRefNum = StartMSTimer
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//various FitMode specific preparations
	string FitHoldStr
	switch(FitMode)
		case 0:
			FitHoldStr="0000"
			break
		case 1:
			FitHoldStr="1000"
			break
		case 2:			
			nPts4PeakHt-=mod(nPts4PeakHt+1,2)		//make "nPts4PeakHt" odd (coerce to next odd number below)
			break
		default:	
			setdatafolder $savedDF
			message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	//channel specific
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitSCHG:
			//scattering high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCHG
			ChanPrefix=ksSP2SCHGprefix
			break
		case kSP2chanbitSCLG:
			//scattering low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCLG
			ChanPrefix=ksSP2SCLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string ChanDescript=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//preparations for analysis of scattering signal at incandescence
	variable ScattAtIncStartDeltaPts=round(SAIstartUS*SamplingRateRawDataMHz)
	variable ScattAtIncEndDeltaPts=round(SAIendUS*SamplingRateRawDataMHz)
	//write info string
	setdatafolder $PBPfldrfp
	string /g $ksSP2traceAnalysisInfoStr=""
	Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr			
	TraceAnalysisInfoStr+=ksSP2SAIdeltaStartKey+": "+num2str(ScattAtIncStartDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIdeltaEndKey+": "+num2str(ScattAtIncEndDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIchanPrefixIncKey+": "+IncPrefixForSAI+"\r"
	//access raw trace matrix
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//access PBP waves
	setdatafolder $PBPfldrfp
	wave /Z IncPeakHalfDecay=$IncPrefixForSAI+ksSP2PBPtracefitPeakHalfDecay
	wave /Z IncandPos=$IncPrefixForSAI+ksSP2PBPtracefitPeakPos
	GetSAI=GetSAI && waveexists(IncandPos)
	//trace analysis
	if (!waveexists(tracemat))
		//raw trace matrix not available => nothing to be analysed
	else
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//create fit result waves
			CreateFoldersOfFullPath(PBPfldrfp, 0)
			setdatafolder $PBPfldrfp
			make /o/n=(nRows) $chanprefix+ksSP2PBPsaturated=0
			wave saturated=$chanprefix+ksSP2PBPsaturated
			note saturated, "Saturation of "+ChanDescript+" detector:"
			note saturated, "0: not saturated;"
			note saturated, "1: saturated;"
			note saturated, "Saturation defined at " + num2str(MaxSigVal) + "by kSP2MaxSig***Gdefault, where *** is a channel descriptor like SCH."
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGaussoffset=NaN
			wave Offset=$chanprefix+ksSP2PBPscattGaussoffset					
			note Offset, "baseline of "+ChanDescript+" detector;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakHeight=NaN
			wave PeakHt=$chanprefix+ksSP2PBPscattGausspeakHeight			
			note PeakHt, "peak height of "+ChanDescript+" signal;"
			note PeakHt, "note: obtained by averageing the selected number of points around the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakPos=NaN
			wave PeakPos=$chanprefix+ksSP2PBPscattGausspeakPos				
			note PeakPos, "position of "+ChanDescript+" signal;"
			note PeakPos, "note: this is identical to "+chanprefix+ksSP2PBPscattMaxPos+" if the peak height is obtained by searching the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPos=NaN									//ml
			wave MaxPos=$chanprefix+ksSP2PBPscattMaxPos												//ml		
			note MaxPos, "position of the global maximum of the "+ChanDescript+" signal;"						//ml
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPeakHeight=NaN								//ml
			wave MaxPeakHt=$chanprefix+ksSP2PBPscattMaxPeakHeight									//ml		
			note MaxPeakHt, "peak height of the "+ChanDescript+" signal determined from global maximum;"		//ml
			note MaxPeakHt, "peak height relative to baseline from pretrigger points;"
			note MaxPeakHt, "note: obtained from the single global maximum value;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakFWHM=NaN
			wave PeakFWHM=$chanprefix+ksSP2PBPscattGausspeakFWHM		
			note PeakFWHM, "FWHM of "+ChanDescript+" signal;" 
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPos=NaN
			wave MaxB4incPos=$chanprefix+ksSP2PBPscattMaxB4incPos
			note MaxB4incPos, "position of the maximum of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPeakHeight=NaN
			wave MaxB4incPeakHt=$chanprefix+ksSP2PBPscattMaxB4incPeakHeight
			note MaxB4incPeakHt, "maximum peak height of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			note MaxB4incPeakHt, "peak height relative to baseline from pretrigger points;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattSigAtIncand=NaN
			wave ScattFitSigAtIncand=$chanprefix+ksSP2PBPscattSigAtIncand
			note ScattFitSigAtIncand, "amplitude of the "+ChanDescript+" signal just before incandescence;"
			note ScattFitSigAtIncand, "details on data analysis settings are stored in the string "+ksSP2traceAnalysisInfoStr+";"
			//FitMode specific
			if (FitMode==0 || FitMode==1)
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakChiSqr=NaN
				wave PeakChiSqr=$chanprefix+ksSP2PBPscattGausspeakChiSqr		
				note PeakChiSqr, "ChiSqr of Gaussian fitted to "+ChanDescript+" signal;"
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattFittedBLfitError=NaN
				wave FitError=$chanprefix+ksSP2PBPscattFittedBLfitError				
				note FitError, "bit0=1: singular matrix or filtered data point;"		
				note FitError, "bit1=2: out of memory;"		
				note FitError, "bit2=4: function returned NaN or INF;"					
			elseif (FitMode==2)
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakStart=NaN
				wave PeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
				note PeakStart, "start position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakEnd=NaN
				wave PeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
				note PeakEnd, "end position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfRise=NaN
				wave PeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
				note PeakHalfRise, "half rise position of peak of the "+ChanDescript+" signal;"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfDecay=NaN
				wave PeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
				note PeakHalfDecay, "half decay position of peak of the "+ChanDescript+" signal;"			
			else
				setdatafolder $savedDF
				message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
				print message;print RTStackInfo;abort message	
			endif
			//temporary waves
			make /FREE/c/n=(nRows) GlobalMaxValAndPos
			make /FREE/c/n=(nRows) LocalMaxValAndPos
			make /FREE/n=(nRows) TempResult
			//get peak properties
				//various variables
				variable PeakWidthThreshold=kSP2minValidPeakWidthScatt*SamplingRateRawDataMHz
				variable PeakFWHMmaxThrshld=kSP2maxValidPeakFWHMScatt*SamplingRateRawDataMHz
				variable PeakStart2PeakMaxThrshld=kSP2maxValidPeakStart2MaxScatt*SamplingRateRawDataMHz		
				variable WidthInitGuess=kSP2scattFWHMinitGuess*SamplingRateRawDataMHz/1.66511		//see below for meaning of factor "1.66511"
				//determine baseline			
				if (FitMode==0)
					//baseline from Gaussian fit => use global minimum as initial guess
					Multithread offset=MinFromMatrixRowRange_TS(tracemat, p, 0, tracelen-1,0)					
				elseif (FitMode==1 || FitMode==2)
					//baseline from pretrigger points
					Multithread offset=SP2_TA_GetBaseline_TS(tracemat, p, nRows, nPts4baselineWav[p], BaselineFilter, BaselineDelta)	
				endif
				//get global maximum
				Multithread GlobalMaxValAndPos=MaxFromMatrixRowRange_TS(tracemat, p, 0, tracelen-1,0)
				Multithread MaxPeakHt=real(GlobalMaxValAndPos[p])-offset[p]		//identical to PeakHt if FitMode=2 and nPts4PeakHt=1
				Multithread MaxPos=imag(GlobalMaxValAndPos[p])					//identical to PeakPos if FitMode=2
				//treat saturated particles
				Multithread saturated= real(GlobalMaxValAndPos[p])>=MaxSigVal
				Multithread PeakHt = saturated[p] ? real(GlobalMaxValAndPos[p])-Offset[p] : NaN
				//local maximum of the scattering signal before the half-decay of the incandescence signal
				if (waveexists(IncPeakHalfDecay))
					Multithread LocalMaxValAndPos=MaxFromMatrixRowRange_TS(tracemat, p, 0, ceil(IncPeakHalfDecay[p]), saturated[p])
					Multithread MaxB4IncPeakHt=real(LocalMaxValAndPos[p])-offset[p]
					Multithread MaxB4IncPos=imag(LocalMaxValAndPos[p])
				endif
				//Get SAI (signal amplitude just before incandescence peak)
				if (GetSAI)
					Multithread ScattFitSigAtIncand= -offset[p]+MeanMatrixRowRangeNaN_TS(tracemat, p, ScattAtIncStartDeltaPts+IncandPos[p], ScattAtIncEndDeltaPts+IncandPos[p],0)
				endif
				//analyze the scattering peak
				if (FitMode==0 || FitMode==1)
					//Gaussian fit
					Multithread FitError=SP2_TA_FitGaussian_TS(tracemat, p, nRows, tracelen, Offset, MaxPeakHt[p],MaxPos[p],WidthInitGuess, FitHoldStr, PeakHt, PeakPos, PeakFWHM, PeakChiSqr, MaxSigVal, saturated[p])
				elseif(FitMode==2)
					//obtain peak height by averaging the selected number of points around the global maximum
					Multithread TempResult=SP2_TA_FitPeakScatt_TS(tracemat, p, nRows, tracelen, nPts4PeakHt, PeakWidthThreshold, PeakFWHMmaxThrshld, PeakStart2PeakMaxThrshld, Offset, PeakHt, PeakPos, PeakStart, PeakEnd, PeakHalfRise, PeakHalfDecay, PeakFWHM, MaxPeakHt, MaxPos, MaxB4IncPos, MaxB4IncPeakHt, saturated[p])
				endif
	endif
	//Display elapsed time.
//	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//	Printf "Duration of scattering signal analysis: %.2f seconds\r\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2scattAdvancedFit_DEPRECATED(channeltype, rawdatafp, PBPfldrfp, FitMode, nPts4PeakHt, nPts4baselineWav, BaselineFilter, BaselineDelta, GetSAI, SAIstartUS, SAIendUS, IncPrefixForSAI)
	//NOTE: This function has been replaced by a multithreaded variant
	//This function analyses SP2's raw traces from the scattering channels.
	//Note: This function was originally based on the procedure "SP2IncandAvgBaseFit" from DMT's PAPI software.
	//return value: 0; not used
	//martin.gysel@psi.ch;	10/11/2008, 11/07/2009, 18/08/2009; 06/10/2010, 26/04/2010, 27/04/2010, 18/05/2010, 26/05/2010, 28/05/2010,
	//						04/11/2010, 12/05/2011, 18/05/2011, 19/05/2011; 15/12/2011
	//marie.laborde@psi.ch; 29/10/09
	variable channeltype		//1: high gain scattering data
							//16: low gain scattering data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	variable	FitMode			//fit type for scattering channel data
							//0: baseline + peak height from Gaussian fit
							//1: baseline from pretrigger points, peak height from Gaussian fit
							//2: baseline from pretrigger points, peak height from maximum value
	variable nPts4PeakHt		//number of points to be averaged for peak height of scattering signals
							//note: will be rounded to the next odd number below
							//note: must be provided if FitMode=2, ignored otherwise
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//note: must be provided if BaselineFilter=1 and if FitMode=1 or 2, ignored otherwise
	variable GetSAI		//1: get scattering signal amplitude just before incandescence peak
							//0: skip it
	variable SAIstartUS	//start of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	variable SAIendUS	//end of averaging interval for scattering peak height at incandescence
							//unit: s before incandescence peak
							//only required if GetSAI=1
	string IncPrefixForSAI	//prefix of incandescence channel to be used for position of incandescence peak
								//e.g: ":BBHG_" 
								//only required if GetSAI=1
								 
	//Start timing.
	variable timerRefNum = StartMSTimer
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2scattFit
	string tmpfldrpath=getdatafolder(1)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//various FitMode specific preparations
	string FitHoldStr
	switch(FitMode)
		case 0:
			setdatafolder $tmpfldrpath
			Variable /g V_fitOptions=4
			Variable /g V_fitError
			make /o/n=4 W_coef
			FitHoldStr="0000"
			break
		case 1:
			setdatafolder $tmpfldrpath
			Variable /g V_fitOptions=4
			Variable /g V_fitError
			make /o/n=4 W_coef
			FitHoldStr="1000"
			break
		case 2:			
			nPts4PeakHt-=mod(nPts4PeakHt+1,2)		//make "nPts4PeakHt" odd (coerce to next odd number below)
			break
		default:	
			setdatafolder $savedDF
			killdatafolder /z $tmpfldrpath
			message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	//channel specific
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitSCHG:
			//scattering high gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCHG
			ChanPrefix=ksSP2SCHGprefix
			break
		case kSP2chanbitSCLG:
			//scattering low gain
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar MaxSigVal=$ksSP2maxSigSCLG
			ChanPrefix=ksSP2SCLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			killdatafolder /z $tmpfldrpath
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string ChanDescript=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//preparations for analysis of scattering signal at incandescence
	variable SAIstartDeltaPts=round(SAIstartUS*SamplingRateRawDataMHz)
	variable SAIendDeltaPts=round(SAIendUS*SamplingRateRawDataMHz)
	//write info string
	setdatafolder $PBPfldrfp
	string /g $ksSP2traceAnalysisInfoStr=""
	Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr			
	TraceAnalysisInfoStr+=ksSP2SAIdeltaStartKey+": "+num2str(SAIstartDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIdeltaEndKey+": "+num2str(SAIendDeltaPts)+"\r"
	TraceAnalysisInfoStr+=ksSP2SAIchanPrefixIncKey+": "+IncPrefixForSAI+"\r"
	//access raw trace matrix
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//access PBP waves
	setdatafolder $PBPfldrfp
	wave /Z IncPeakHalfDecay=$IncPrefixForSAI+ksSP2PBPtracefitPeakHalfDecay
	wave /Z IncandPos=$IncPrefixForSAI+ksSP2PBPtracefitPeakPos
	GetSAI=GetSAI && waveexists(IncandPos)
	//trace analysis
	if (!waveexists(tracemat))
		//raw trace matrix not available => nothing to be analysed
	else
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//create fit result waves
			CreateFoldersOfFullPath(PBPfldrfp, 0)
			setdatafolder $PBPfldrfp
			make /o/n=(nRows) $chanprefix+ksSP2PBPsaturated=0
			wave saturated=$chanprefix+ksSP2PBPsaturated
			note saturated, "Saturation of "+ChanDescript+" detector:"
			note saturated, "0: not saturated;"
			note saturated, "1: saturated;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGaussoffset=NaN
			wave Offset=$chanprefix+ksSP2PBPscattGaussoffset					
			note Offset, "baseline of "+ChanDescript+" detector;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakHeight=NaN
			wave PeakHt=$chanprefix+ksSP2PBPscattGausspeakHeight			
			note PeakHt, "peak height of "+ChanDescript+" signal;"
			note PeakHt, "note: obtained by averageing the selected number of points around the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakPos=NaN
			wave PeakPos=$chanprefix+ksSP2PBPscattGausspeakPos				
			note PeakPos, "position of "+ChanDescript+" signal;"
			note PeakPos, "note: this is identical to "+chanprefix+ksSP2PBPscattMaxPos+" if the peak height is obtained by searching the maximum;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPos=NaN		//ml
			wave MaxPos=$chanprefix+ksSP2PBPscattMaxPos		//ml		
			note MaxPos, "position of the global maximum of the "+ChanDescript+" signal;"			//ml
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxPeakHeight=NaN		//ml
			wave MaxPeakHt=$chanprefix+ksSP2PBPscattMaxPeakHeight		//ml		
			note MaxPeakHt, "peak height of the "+ChanDescript+" signal determined from global maximum;"			//ml
			note MaxPeakHt, "peak height relative to baseline from pretrigger points;"
			note MaxPeakHt, "note: obtained from the single global maximum value;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakFWHM=NaN
			wave PeakFWHM=$chanprefix+ksSP2PBPscattGausspeakFWHM		
			note PeakFWHM, "FWHM of "+ChanDescript+" signal;" 
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPos=NaN
			wave MaxB4incPos=$chanprefix+ksSP2PBPscattMaxB4incPos
			note MaxB4incPos, "position of the maximum of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattMaxB4incPeakHeight=NaN
			wave MaxB4incPeakHt=$chanprefix+ksSP2PBPscattMaxB4incPeakHeight
			note MaxB4incPeakHt, "maximum peak height of the "+ChanDescript+" signal before the half decay of the BBHG peak;"
			note MaxB4incPeakHt, "peak height relative to baseline from pretrigger points;"
			make /o/n=(nRows) $chanprefix+ksSP2PBPscattSigAtIncand=NaN
			wave ScattFitSigAtIncand=$chanprefix+ksSP2PBPscattSigAtIncand
			note ScattFitSigAtIncand, "baseline-subtracted amplitude of the "+ChanDescript+" signal just before incandescence;"
			note ScattFitSigAtIncand, "details on data analysis settings are stored in the string "+ksSP2traceAnalysisInfoStr+";"
			//FitMode specific
			if (FitMode==0 || FitMode==1)
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattGausspeakChiSqr=NaN
				wave PeakChiSqr=$chanprefix+ksSP2PBPscattGausspeakChiSqr		
				note PeakChiSqr, "ChiSqr of Gaussian fitted to "+ChanDescript+" signal;"
				make /o/n=(nRows) $chanprefix+ksSP2PBPscattFittedBLfitError=NaN
				wave FitError=$chanprefix+ksSP2PBPscattFittedBLfitError				
				note FitError, "bit0=1: singular matrix;"		
				note FitError, "bit1=2: out of memory;"		
				note FitError, "bit2=4: function returned NaN or INF;"					
			elseif (FitMode==2)
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakStart=NaN
				wave PeakStart=$ChanPrefix+ksSP2PBPtracefitPeakStart
				note PeakStart, "start position of peak of the "+ChanDescript+" signal [0.4 s];"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakEnd=NaN
				wave PeakEnd=$ChanPrefix+ksSP2PBPtracefitPeakEnd
				note PeakEnd, "end position of peak of the "+ChanDescript+" signal [0.4 s];"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfRise=NaN
				wave PeakHalfRise=$ChanPrefix+ksSP2PBPtracefitPeakHalfRise
				note PeakHalfRise, "half rise position of peak of the "+ChanDescript+" signal [0.4 s];"
				make /o/n=(nRows) $ChanPrefix+ksSP2PBPtracefitPeakHalfDecay=NaN
				wave PeakHalfDecay=$ChanPrefix+ksSP2PBPtracefitPeakHalfDecay
				note PeakHalfDecay, "half decay position of peak of the "+ChanDescript+" signal [0.4 s];"
			else
				setdatafolder $savedDF
				killdatafolder /z $tmpfldrpath
				message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
				print message;print RTStackInfo;abort message	
			endif
			//temporary waves
			setdatafolder $tmpfldrpath
			make /o/n=(tracelen) currtrace
			wave currtrace
			//loop over rows of raw data matrix and fit.
			variable rind, tind, VmaxGlobal, VminGlobal, VmaxlocGlobal, VnpntsGlobal
			variable threshold, filtered, startpos, endpos, extrasearchrange, avgind, peakstartind
			variable PeakWidthThreshold=kSP2minValidPeakWidthScatt*SamplingRateRawDataMHz
			variable WidthInitGuess=kSP2scattFWHMinitGuess*SamplingRateRawDataMHz/1.66511		//see below for meaning of factor "1.66511"
			variable HalfPeakHt, SigScattAtInc, SAIind, startind, endind, MinInPretrigRange, StartEndLevel
			for (rind=0;rind<nRows;rind+=1)
				//reset
				filtered=0
				//Put data from current row rind into temporary wave.
				currtrace=tracemat[rind][p]		
				//get statistics of whole trace
				WaveStats/Q currtrace
				VmaxGlobal=V_max
				VminGlobal=V_min
				VmaxlocGlobal=V_maxloc
				VnpntsGlobal=V_npnts
				//Determine baseline from pretrigger points
				if (FitMode==1 || FitMode==2)
					switch(BaselineFilter)	
						case 0:	
							//average all pretrigger points to get baseline
							WaveStats/Q/R=[0,nPts4baselineWav[rind]-1] currtrace
							offset[rind]=V_avg						
							break				
						case 1:	
							//only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							MinInPretrigRange=MinFromWaveNaNrange(currtrace, 0, FirstPt=0, LastPt=nPts4baselineWav[rind]-1) 
							threshold=MinInPretrigRange+BaselineDelta
							offset[rind]=MeanNaNRangeBelowThreshold(currtrace, 0, nPts4baselineWav[rind]-1, threshold)
							break				
						default:						
							//value of 'BaselineFilter' is not defined
							setdatafolder $savedDF
							killdatafolder /z $tmpfldrpath
							message="The parameter 'BaselineFilter' handed over to the function "+currproc+" must be 0 or 1!"
							print message;print RTStackInfo;abort message										
					endswitch
				elseif (FitMode==0)
					Offset[rind]=VminGlobal		//set baseline to minimum reading ...
				else
					//undefined value of 'FitMode'
					setdatafolder $savedDF
					killdatafolder /z $tmpfldrpath
					message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
					print message;print RTStackInfo;abort message	
				endif
				//treat saturated particles
				if (VmaxGlobal>=MaxSigVal)
					saturated[rind]=1
					PeakHt[rind]=VmaxGlobal-Offset[rind]
					continue
				endif
				//global maximum					
				MaxPos[rind]=VmaxlocGlobal		//identical to PeakPos if FitMode=2
				MaxPeakHt[rind]=VmaxGlobal-offset[rind] 	//identical to PeakHt if FitMode=2 and nPts4PeakHt=1
				//local maximum of the scattering signal before the half-decay of the incandescence signal
				if (waveexists(IncPeakHalfDecay))
					WaveStats/Q /R=(0,IncPeakHalfDecay[rind]) currtrace
					MaxB4IncPos[rind]=V_maxloc
					MaxB4IncPeakHt[rind]=V_max-offset[rind]
				endif
				//signal amplitude just before incandescence peak position
				if (GetSAI)
					startind=SAIstartDeltaPts+IncandPos[rind]
					endind=SAIendDeltaPts+IncandPos[rind]
					if ( (numtype(startind)+numtype(endind))==0 )
						//proceed only if peak position is available
						SigScattAtInc=0
						for (SAIind=startind;SAIind<=endind;SAIind+=1)
							SigScattAtInc+=currtrace[SAIind]
						endfor
						SigScattAtInc/=(endind-startind)+1
						ScattFitSigAtIncand[rind]=SigScattAtInc-offset[rind]
					endif
				endif
				//Determine peak height and location.
				if (FitMode==0 || FitMode==1)
					//Gaussian fit
					if(VnpntsGlobal>4) //enough valid data points for fitting
						//initial guess for Gaussian fit
						W_coef={Offset[rind],MaxPeakHt[rind],MaxPos[rind],WidthInitGuess}				
						//fit Gaussian
						setdatafolder $tmpfldrpath
						V_fitError=0
						CurveFit/H=FitHoldStr/N/NTHR=0/Q gauss, kwCWave=W_coef, currtrace	
						//copy fit coefficients to corresponding result waves
						FitError[rind]=V_FitError
						Offset[rind]=W_coef[0]
						PeakHt[rind]=W_coef[1]
						PeakPos[rind]=W_coef[2]
						PeakFWHM[rind]=1.66511*W_coef[3]	//Built-in gauss fit returns "width=sqrt(2)*(std. dev.)" and "FWHM=2*sqrt(2*ln(2))*(std. dev.)"
						PeakChiSqr[rind]=V_chisq
						//basic quality check of fit result
							//check peak position
							if (PeakPos[rind]<0 || PeakPos[rind]>tracelen)
								FitError[rind]=1
							endif
							//check baseline
							if (Offset[rind]>MaxSigVal)
								FitError[rind]=1
							endif
							//check FWHM
							if ( (2*PeakFWHM[rind])>tracelen )
								FitError[rind]=1
							endif
							//check peak amplitude
							if ( PeakHt[rind]<1 || PeakHt[rind]>(kSP2scattMaxSatFact*(MaxSigVal-Offset[rind])) )
								FitError[rind]=1
							endif
					else
						//not enough valid data points => do not fit
						FitError[rind]=1
					endif
					if (FitError[rind]!=0)
						//unreasonable fit result or fit error => whiteout result waves
						Offset[rind]=NaN
						PeakHt[rind]=NaN
						PeakPos[rind]=NaN
						PeakFWHM[rind]=NaN
						PeakChiSqr[rind]=NaN		
					endif
				elseif(FitMode==2)
					//average of selected number of points around global maximum
					PeakPos[rind]=VmaxlocGlobal
					peakstartind=VmaxlocGlobal-(nPts4PeakHt-1)/2
					PeakHt[rind]=0
					for (avgind=0;avgind<nPts4PeakHt;avgind+=1)
						PeakHt[rind]+=currtrace[peakstartind+avgind]
					endfor
					PeakHt[rind]/=nPts4PeakHt
					PeakHt[rind]-=offset[rind]
					HalfPeakHt=0.5*PeakHt[rind]
					//filtering: peak ht. > 1 ;  0 < peak pos. < number of data points.
					if (PeakHt[rind]<1 || PeakPos[rind]<0 || PeakPos[rind]+2>tracelen)
						filtered=1
						PeakHt[rind]=NaN
						MaxPeakHt[rind]=NaN
						PeakPos[rind]=NaN
						MaxPos[rind]=NaN
						offset[rind]=NaN
						MaxB4IncPos[rind]=NaN
						MaxB4IncPeakHt[rind]=NaN
					endif
					//continue analysis only if trace passed above filtering test	
					if (filtered==0)	
						StartEndLevel=kSP2scattStartEndDeltaPerc*PeakHt[rind]+offset[rind]
						//Determine peak start point.
						for (tind=PeakPos[rind];tind>0;tind-=1)
							if ((currtrace[tind]) < StartEndLevel)
								PeakStart[rind]=tind
								break
							endif
						endfor
						if (tind==0)		//baseline not found before peak position
							PeakStart[rind]=0		//set peak start to 0
						endif
						//Determine peak end point.
						for (tind=PeakPos[rind];tind<tracelen;tind+=1)
							if ((currtrace[tind]) < StartEndLevel)
								PeakEnd[rind]=tind
								break
							endif
						endfor
						if (tind==tracelen)		//baseline not found after peak position
							PeakEnd[rind]=tracelen-1		//set peak end to last data point
						endif
						//filter noisy spikes based on their small width
						if (PeakEnd[rind]-PeakStart[rind]>PeakWidthThreshold)	//proceed only if peak is sufficiently wide
							//Determine half peak rise point.
							for (tind=PeakPos[rind];tind>0;tind-=1)
								if ((currtrace[tind]-offset[rind]) <= HalfPeakHt)
									PeakHalfRise[rind]=tind
									break
								endif
							endfor
							//Determine half peak decay point.
							for (tind=PeakPos[rind];tind<tracelen;tind+=1)
								if ((currtrace[tind]-offset[rind]) <= HalfPeakHt)
									PeakHalfDecay[rind]=tind
									break
								endif
							endfor
							//FWHM of peak
							if (PeakHalfRise[rind]>=0 && PeakHalfDecay[rind]<=tracelen)
								PeakFWHM[rind]= PeakHalfDecay[rind] - PeakHalfRise[rind]
							endif
						else
							//peak too narrow => considered to be a noisy spike
							PeakHt[rind]=kSP2filteredPeakDummyPkHt
							MaxPeakHt[rind]=NaN
							PeakPos[rind]=NaN
							MaxPos[rind]=NaN
							offset[rind]=NaN
							MaxB4IncPos[rind]=NaN
							MaxB4IncPeakHt[rind]=NaN
							PeakStart[rind]=NaN
							PeakEnd[rind]=NaN
						endif
					endif
				else
					setdatafolder $savedDF
					killdatafolder /z $tmpfldrpath
					message="Undefined value of the parameter 'FitMode' handed over to the function "+currproc+"!"
					print message;print RTStackInfo;abort message					
				endif
			endfor	
	endif
	//Display elapsed time.
//	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//		Printf "TA scattering traditional: %.2f seconds\r\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	return 0
End



Function SP2_TA_PSD_MT(channeltype, rawdatafp, PBPfldrfp, nPts4baselineWav, BaselineFilter [BaselineDelta])
	//This function analyses SP2's raw traces from the split detector.
	//return value: 0; not used
	//martin.gysel@psi.ch;	11/11/2008, 11/07/2009, 18/08/2009, 06/10/2009, 27/04/2010, 18/05/2010, 28/05/2010, 29/11/2010
	//						14/02/2011, 26/09/2012
	variable channeltype		//8: high gain split detector data
							//128: low gain split detector data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points above threshold=maximum in pretrigger range - BaselineDelta are averaged to get baseline
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//default: inf (i.e. equal to Baselinefiltetr=0)
	 
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//set defaults
	if (paramisdefault(BaselineDelta))
		BaselineDelta=inf
	endif
	//channel specific settings
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitSPHG:
			//high gain split detector
			ChanPrefix=ksSP2SPHGprefix
			break
		case kSP2chanbitSPLG:
			//high gain split detector
			ChanPrefix=ksSP2SPLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string DescriptStr=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//Start timing.
	variable timerRefNum = StartMSTimer
	//access raw data waves
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//trace analysis
	if (waveexists(tracemat))
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			variable LastTraceIndex=tracelen-1
			//create fit result waves
			setdatafolder $pbpfldrfp
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
			wave saturated=$ChanPrefix+ksSP2PBPsaturated
			note saturated, "0: split detector not saturated;"
			note saturated, "1: split detector saturated;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitBasicOffset=NaN
			wave Offset=$ChanPrefix+ksSP2PBPsplitBasicOffset				
			note Offset, "baseline of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitNegPeakHt=NaN
			wave NegPeakHt=$ChanPrefix+ksSP2PBPsplitNegPeakHt				
			note NegPeakHt, "negative peak height, obtained by fitting first part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPosPeakHt=NaN
			wave PosPeakHt=$ChanPrefix+ksSP2PBPsplitPosPeakHt				
			note PosPeakHt, "positive peak height, obtained by fitting second part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitNegPeakPos=NaN
			wave NegPeakPos=$ChanPrefix+ksSP2PBPsplitNegPeakPos			
			note NegPeakPos, "position of negative peak, obtained by fitting first part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPosPeakPos=NaN
			wave PosPeakPos=$ChanPrefix+ksSP2PBPsplitPosPeakPos			
			note PosPeakPos, "position of positivie peak, obtained by fitting second part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitFirstSplitPos=NaN
			wave FirstSplitPos=$ChanPrefix+ksSP2PBPsplitFirstSplitPos			
			note FirstSplitPos, "first crossing of baseline between positions of positive and negative peaks;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitLastSplitPos=NaN
			wave LastSplitPos=$ChanPrefix+ksSP2PBPsplitLastSplitPos			
			note LastSplitPos, "last crossing of baseline between positions of positive and negative peaks;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitCentreSplitPos=NaN
			wave CentreSplitPos=$ChanPrefix+ksSP2PBPsplitCentreSplitPos		//wave note is written below
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitSplitWidth=NaN
			wave SplitWidth=$ChanPrefix+ksSP2PBPsplitSplitWidth				
			note SplitWidth, "difference between  "+nameofwave(FirstSplitPos)+" and "+nameofwave(LastSplitPos)+";"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPeakDist=NaN
			wave PeakDist=$ChanPrefix+ksSP2PBPsplitPeakDist					
			note PeakDist, "distance between negative and positive peaks, obtained by fitting the split detector signal;"
			//temporary waves
			make /FREE/c/n=(nRows) MaxValAndPos
			make /FREE/n=(nRows) MaxPos
			make /FREE/n=(nRows) MaxVal
			make /FREE/c/n=(nRows) MinValAndPos
			make /FREE/n=(nRows) MinPos
			make /FREE/n=(nRows) MinVal
			make /FREE/n=(nRows) BadParticle=0
			make /FREE/n=(nRows) BaselineRange
			//get minimum and maximum of PSD trace
			NVAR splitSearchMode= $ksSP2PathToToolkitPanelFldr + ksSP2splitSearchMode
			switch(splitSearchMode)	// numeric switch
				case 0:	//search global max first and then the minimum before it
					//search global maximum of split detector trace
					Multithread MaxValAndPos=MaxFromMatrixRowRange_TS(tracemat, p, 0, LastTraceIndex,0)
					Multithread MaxPos=imag(MaxValAndPos)
					//search local minimum of PSD trace before the global maximum
					Multithread MinValAndPos=MinFromMatrixRowRange_TS(tracemat, p, 0,MaxPos[p]-1,0)
					Multithread MinPos=imag(MinValAndPos)
					break
				case 1:	//search global min first and then the maximum before it
					//search global minimum of split detector trace
					Multithread MinValAndPos=MinFromMatrixRowRange_TS(tracemat, p, 0, LastTraceIndex,0)
					Multithread MinPos=imag(MinValAndPos)
					//search maximum of split detector trace after the global minimum
					Multithread MaxValAndPos=MaxFromMatrixRowRange_TS(tracemat, p, MinPos[p]+1, LastTraceIndex,0)
					Multithread MaxPos=imag(MaxValAndPos)
					break
			endswitch	
			//check positions of negative and positive peaks
			Multithread BadParticle= 	MaxPos[p]<=MinPos[p] | BadParticle[p]
			Multithread BadParticle= 	numtype(MaxPos[p]+MinPos[p])==2 | BadParticle[p]
			//check whether trace is saturated
			Multithread MinVal=real(MinValAndPos)
			Multithread saturated= MinVal[p]<=kSP2rawSignalMin ? 1 : 0			
//			Multithread saturated= MinVal[p]>=kSP2rawSignalMax ? 1 : 0			// jcc (v4111):this is logically true, but i did not yet validate that no errors result. 2016-02-23
			//Determine baseline
			Multithread BaselineRange=min(nPts4baselineWav[p],MinPos[p])-1
			switch(BaselineFilter)	
				case 0:	
					//average all pretrigger points to get baseline
					Multithread offset=MeanMatrixRowRangeNaN_TS(tracemat, p, 0, BaselineRange[p],BadParticle[p])
					break				
				case 1:	
					//only those pretrigger points above threshold="maximum within baseline range minus BaselineDelta" are averaged to get baseline
					make /FREE/n=(nRows) PretriggerMax
					Multithread PretriggerMax=MaxFromMatrixRowRange_TS(tracemat, p, 0, BaselineRange[p],BadParticle[p])
					Multithread offset=MeanMatRowRangeNaNAboveThrsld(tracemat, p, 0, BaselineRange[p], PretriggerMax[p]-BaselineDelta, BadParticle[p])
					break				
				default:						
					//value of 'BaselineFilter' is not defined
					setdatafolder $savedDF
					message="The parameter 'BaselineFilter' handed over to the function "+currproc+" must be 0 or 1!"
					print message;print RTStackInfo;abort message										
			endswitch
			//check baseline
			Multithread MaxVal=real(MaxValAndPos)
			Multithread BadParticle= 	(MinVal[p]>=offset[p]) || (MaxVal[p]<=offset[p]) | BadParticle[p]
			//copy trace analysis results to target waves
			Multithread offset= BadParticle[p] ? NaN : offset[p]
			Multithread PosPeakHt= BadParticle[p] ? NaN : MaxVal[p]-offset[p]
			Multithread PosPeakPos= BadParticle[p] ? NaN : MaxPos[p]
			Multithread NegPeakHt= BadParticle[p] ? NaN : MinVal[p]-offset[p]
			Multithread NegPeakPos= BadParticle[p] ? NaN : MinPos[p]
			//determine first split position
			Multithread FirstSplitPos=FindLevelMatrixRowRangeP_TS(tracemat, p, offset[p], NegPeakPos[p], PosPeakPos[p], BadParticle[p])
			//determine last split position
			Multithread LastSplitPos=FindLevelMatrixRowRangeP_TS(tracemat, p, offset[p], PosPeakPos[p], NegPeakPos[p], BadParticle[p])
			//determine centre split position
			NVAR splitPosMode= $ksSP2PathToToolkitPanelFldr + ksSP2splitPosMode
			switch(splitPosMode)	
				case 0:	
					//0: use average of first and last baseline crossing between the minimum and maximum for the split position (always this caclulation until toolkit 3.200)
					Multithread CentreSplitPos=0.5*(FirstSplitPos[p]+LastSplitPos[p])
					note CentreSplitPos, "split point obtained by averaging "+nameofwave(FirstSplitPos)+" and "+nameofwave(LastSplitPos)+";"
					break		
				case 1:	
					//1: use first baseline crossing after negative peak
					Multithread CentreSplitPos=FirstSplitPos[p]
					note CentreSplitPos, "split point obtained from first baseline crossing after negative peak height (wave: "+nameofwave(FirstSplitPos)+");"
					break		
				default:					
					setdatafolder $savedDF
					message="Code error in the function "+currproc+"!"
					print message;print RTStackInfo;abort message										
			endswitch		
			//determine "width" of split point
			Multithread SplitWidth=LastSplitPos[p]-FirstSplitPos[p]
			//determine distance between negative and positive peaks
			Multithread PeakDist=PosPeakPos[p]-NegPeakPos[p]
	else
		//raw trace matrix not available
			//=> create dummy result waves if needed
	endif
	//Display elapsed time.
	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//	Printf "PSD fit (MT): %.2f seconds\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2splitDetectBasicFit(channeltype, rawdatafp, PBPfldrfp, nPts4baselineWav, BaselineFilter [BaselineDelta])
	//This function analyses SP2's raw traces from the split detector.
	//return value: 0; not used
	//martin.gysel@psi.ch;	11/11/2008, 11/07/2009, 18/08/2009, 06/10/2009, 27/04/2010, 18/05/2010, 28/05/2010, 29/11/2010
	//						14/02/2011,
	variable channeltype		//8: high gain split detector data
							//128: low gain split detector data
	string rawdatafp			//full path to folder containing the raw signal traces
	string PBPfldrfp			//full path to folder into which the fitted peak parameters are to be put
	wave nPts4baselineWav	//wave containing the number of pretrigger points to be used for determining baseline value
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points above threshold=maximum in pretrigger range - BaselineDelta are averaged to get baseline
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//default: inf (i.e. equal to Baselinefiltetr=0)
	 
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//set defaults
	if (paramisdefault(BaselineDelta))
		BaselineDelta=inf
	endif
	//channel specific settings
	string ChanPrefix
	switch(channeltype)
		case kSP2chanbitSPHG:
			//high gain split detector
			ChanPrefix=ksSP2SPHGprefix
			break
		case kSP2chanbitSPLG:
			//high gain split detector
			ChanPrefix=ksSP2SPLGprefix
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'channeltype' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	string DescriptStr=ChopLastCharacterOff(SP2_ChanListToDescrLongList(ChanPrefix),";")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2fit
	string tmpfldrpath=getdatafolder(1)
	//Start timing.
	variable timerRefNum = StartMSTimer
	//access raw data waves
	setdatafolder $rawdatafp
	wave /Z tracemat=$ChanPrefix+ksSP2rawtracemat
	//trace analysis
	if (waveexists(tracemat))
		//raw trace matrix available => proceed with trace analysis
			//dimensions
			variable nRows=dimsize(tracemat,0)
			variable tracelen=dimsize(tracemat,1)
			//create fit result waves
			setdatafolder $pbpfldrfp
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
			wave saturated=$ChanPrefix+ksSP2PBPsaturated
			note saturated, "0: split detector not saturated;"
			note saturated, "1: split detector saturated;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitBasicOffset=NaN
			wave Offset=$ChanPrefix+ksSP2PBPsplitBasicOffset				
			note Offset, "baseline of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitNegPeakHt=NaN
			wave NegPeakHt=$ChanPrefix+ksSP2PBPsplitNegPeakHt				
			note NegPeakHt, "negative peak height, obtained by fitting first part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPosPeakHt=NaN
			wave PosPeakHt=$ChanPrefix+ksSP2PBPsplitPosPeakHt				
			note PosPeakHt, "positive peak height, obtained by fitting second part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitNegPeakPos=NaN
			wave NegPeakPos=$ChanPrefix+ksSP2PBPsplitNegPeakPos			
			note NegPeakPos, "position of negative peak, obtained by fitting first part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPosPeakPos=NaN
			wave PosPeakPos=$ChanPrefix+ksSP2PBPsplitPosPeakPos			
			note PosPeakPos, "position of positivie peak, obtained by fitting second part of split detector signal;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitFirstSplitPos=NaN
			wave FirstSplitPos=$ChanPrefix+ksSP2PBPsplitFirstSplitPos			
			note FirstSplitPos, "first crossing of baseline between positions of positive and negative peaks;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitLastSplitPos=NaN
			wave LastSplitPos=$ChanPrefix+ksSP2PBPsplitLastSplitPos			
			note LastSplitPos, "last crossing of baseline between positions of positive and negative peaks;"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitCentreSplitPos=NaN
			wave CentreSplitPos=$ChanPrefix+ksSP2PBPsplitCentreSplitPos		//wave note is written below
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitSplitWidth=NaN
			wave SplitWidth=$ChanPrefix+ksSP2PBPsplitSplitWidth				
			note SplitWidth, "difference between  "+nameofwave(FirstSplitPos)+" and "+nameofwave(LastSplitPos)+";"
			make /o/n=(nRows) $ChanPrefix+ksSP2PBPsplitPeakDist=NaN
			wave PeakDist=$ChanPrefix+ksSP2PBPsplitPeakDist					
			note PeakDist, "distance between negative and positive peaks, obtained by fitting the split detector signal;"
			//temporary waves
			setdatafolder $tmpfldrpath
			make /o/n=(tracelen) currtrace
			wave currtrace
			//loop over rows of raw data matrix and fit.
			variable rind, tind, threshold, baseline, baselinerange
			variable GlobMaxVal, GlobMaxLoc, GlobMinVal, GlobMinLoc
			for (rind=0;rind<nRows;rind+=1)
				//Put data from current row rind into temporary wave.
				currtrace=tracemat[rind][p]		
				//search maximum and minimum of split detector trace
				NVAR splitSearchMode= $ksSP2PathToToolkitPanelFldr + ksSP2splitSearchMode
				switch(splitSearchMode)	// numeric switch
					case 0:	//search global max first and then the minimum before it
						//search global maximum of split detector trace
						WaveStats/Q currtrace
						GlobMaxVal=V_max
						GlobMaxLoc=V_maxloc
						//check whether trace is saturated
						if (V_min<=kSP2rawSignalMin)
							//test saturation of negative (1st) peak; note: saturation of positive peak is not tested
							saturated[rind]=1
						endif
						//check trace analysis results for positive peak
						if (numtype(GlobMaxLoc)==2 || numtype(GlobMaxVal)==2)
								continue		//invalid trace analysis results => skip this particle
						endif
						//search minimum of split detector trace before the global maximum
						WaveStats/Q/R=[0,GlobMaxLoc-1] currtrace
						GlobMinVal=V_min
						GlobMinLoc=V_minloc
						//check trace analysis results for negative peak
						if (numtype(GlobMinLoc)==2 || numtype(GlobMinVal)==2)
							continue		//invalid trace analysis results => skip this particle
						endif
						if ( GlobMinLoc>=GlobMaxLoc)
							continue		//invalid trace analysis results => skip this particle
						endif
						break
					case 1:	//search global min first and then the maximum before it
						//search global minimum of split detector trace
						WaveStats/Q currtrace
						GlobMinVal=V_min
						GlobMinLoc=V_minloc
						//check whether trace is saturated
						if (V_min<=kSP2rawSignalMin)
							//test saturation of negative (1st) peak; note: saturation of positive peak is not tested
							saturated[rind]=1
						endif
						//check trace analysis results for negative peak
						if (numtype(GlobMinLoc)==2 || numtype(GlobMinVal)==2)
								continue		//invalid trace analysis results => skip this particle
						endif
						//search maximum of split detector trace after the global minimum
						WaveStats/Q/R=[GlobMinLoc+1,tracelen-1] currtrace
						GlobMaxVal=V_max
						GlobMaxLoc=V_maxloc
						//check trace analysis results for negative peak
						if (numtype(GlobMaxLoc)==2 || numtype(GlobMaxVal)==2)
							continue		//invalid trace analysis results => skip this particle
						endif
						if ( GlobMinLoc>=GlobMaxLoc)
							continue		//invalid trace analysis results => skip this particle
						endif
						break
				endswitch
				//Determine baseline.
				baselinerange=min(nPts4baselineWav[rind],GlobMinLoc)-1
				WaveStats/Q/R=[0,baselinerange] currtrace
				switch(BaselineFilter)	
					case 0:	
						//average all pretrigger points to get baseline
						baseline=V_avg						
						break				
					case 1:	
						//only those pretrigger points above threshold="maximum within baseline range minus BaselineDelta" are averaged to get baseline
						threshold=V_max-BaselineDelta
						baseline=MeanNaNRangeAboveThreshold(currtrace, 0, baselinerange, threshold)
						break				
					default:						
						//value of 'BaselineFilter' is not defined
						setdatafolder $savedDF
						message="The parameter 'BaselineFilter' handed over to the function "+currproc+" must be 0 or 1!"
						print message;print RTStackInfo;abort message										
				endswitch
				//check baseline
				if ( (GlobMinVal>=baseline) || (GlobMaxVal<=baseline))
					//test whether baseline is in between negative and positive peak
					continue		//invalid trace analysis results => skip this particle
				endif
				//copy trace analysis results to target waves
				offset[rind]=baseline
				PosPeakHt[rind]=GlobMaxVal-baseline
				PosPeakPos[rind]=GlobMaxLoc
				NegPeakHt[rind]=GlobMinVal-baseline
				NegPeakPos[rind]=GlobMinLoc			
				//subtract baseline from current trace
				currtrace-=baseline
				//determine first split position
				for (tind=NegPeakPos[rind]+1;tind<=PosPeakPos[rind];tind+=1)
					if (currtrace[tind]==0)
						FirstSplitPos[rind]=tind
						break
					elseif (currtrace[tind]>0)
						FirstSplitPos[rind]=tind-1-currtrace[tind-1]/(currtrace[tind]-currtrace[tind-1])
						break
					endif
				endfor
				//determine last split position
				for (tind=PosPeakPos[rind]-1;tind>=NegPeakPos[rind];tind-=1)
					if (currtrace[tind]==0)
						LastSplitPos[rind]=tind
						break
					elseif (currtrace[tind]<0)
						LastSplitPos[rind]=tind-currtrace[tind]/(currtrace[tind+1]-currtrace[tind])
						break
					endif
				endfor
			endfor	
			//determine centre split position
			NVAR splitPosMode= $ksSP2PathToToolkitPanelFldr + ksSP2splitPosMode
			switch(splitPosMode)	
				case 0:	
					//0: use average of first and last baseline crossing between the minimum and maximum for the split position (always this caclulation until toolkit 3.200)
					CentreSplitPos=0.5*(FirstSplitPos[p]+LastSplitPos[p])
					note CentreSplitPos, "split point obtained by averaging "+nameofwave(FirstSplitPos)+" and "+nameofwave(LastSplitPos)+";"
					break		
				case 1:	
					//1: use first baseline crossing after negative peak
					CentreSplitPos=FirstSplitPos[p]
					note CentreSplitPos, "split point obtained from first baseline crossing after negative peak height (wave: "+nameofwave(FirstSplitPos)+");"
					break		
				default:					
					setdatafolder $savedDF
					message="Code error in the function "+currproc+"!"
					print message;print RTStackInfo;abort message										
			endswitch		
			//determine "width" of split point
			SplitWidth=LastSplitPos[p]-FirstSplitPos[p]
			//determine distance between negative and positive peaks
			PeakDist=PosPeakPos[p]-NegPeakPos[p]
	else
		//raw trace matrix not available
			//=> create dummy result waves if needed
	endif
	//Display elapsed time.
	variable elapsed = StopMSTimer(timerRefNum)					//In microseconds.
//	Printf "PSD fit (ST): %.2f seconds\r", elapsed / 1E6			
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	return 0
End

Function /S SP2_RawFldrFP2PBPfldrFP(rawfldrfp)
	//return string: full path to (or name of the) PBP-folder corresponding to an SP2 raw data folder.
	//martin.gysel@psi.ch; 11/11/2008
	string rawfldrfp	//full path to or name of an SP2 raw data folder
	
	string rawfldrnam=laststringfromlist(rawfldrfp, listsepstr=":")
	string pathtofldr
	if (strlen(rawfldrfp)==strlen(rawfldrnam))
		pathtofldr=""
	else
		pathtofldr=RemoveLastItemFromList(rawfldrfp,ListSepStr=":")
	endif
	string pbpfldrnam=QuoteRemover(rawfldrnam)+ksSP2PBPfldrSuffix	
	return QuoteLiberalPath(pathtofldr+pbpfldrnam)
end


Function /S SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	//return string: full path to (or name of the) raw data folder corresponding to an SP2 PBP-data folder.
	//martin.gysel@psi.ch; 12/11/2008
	string pbpfldrfp	//full path to or name of an SP2 PBP-data folder
	
	string pbpfldrnam=laststringfromlist(pbpfldrfp, listsepstr=":")
	string pathtofldr
	if (strlen(pbpfldrfp)==strlen(pbpfldrnam))
		pathtofldr=""
	else
		pathtofldr=RemoveLastItemFromList(pbpfldrfp,ListSepStr=":")
	endif
	string rawfldrnam=replacestring(ksSP2PBPfldrSuffix,pbpfldrnam,"")
	return pathtofldr+rawfldrnam
end

Function /S SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	//return string: full path to (or partial path to) LEO-fit data folder corresponding to an SP2 PBP-data folder.
	//martin.gysel@psi.ch; 17/05/2010
	string pbpfldrfp	//full path to or name of an SP2 PBP-data folder
	
	return ChopLastCharacterOff(pbpfldrfp,":")+ksSP2LEOsubFldrPP
end

Function /S SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
	//return string: full path to (or partial path to) SAI-analysis data folder corresponding to an SP2 PBP-data folder.
	//martin.gysel@psi.ch; 15/02/2012
	string pbpfldrfp	//full path to or name of an SP2 PBP-data folder
	
	return ChopLastCharacterOff(pbpfldrfp,":")+ksSP2LEOsubFldrPP+ksSP2SAIsubFldrPP
end


Function /S SP2_LEOfldrfp2PBPfldrfp(leofldrfp)
	//return string: full path to (or partial path to) PBP data folder corresponding to an LEO-fit data folder.
	//martin.gysel@psi.ch; 17/05/2010
	string leofldrfp	//full path (or partial path) to an SP2 LEO-fit data subfolder
	
	return ChopLastCharacterOff(RemoveLastItemFromList(leofldrfp,ListSepStr=":"),":")	//just move one directory up!
end

Function /S SP2_SAIfldrfp2PBPfldrfp(SAIfldrFP)
	//return string: full path to PBP data folder corresponding to an SAI-analysis data folder.
	//martin.gysel@psi.ch; 15/02/2012
	string SAIfldrFP	//full path to an SP2 SAI-analysis data subfolder
	
	string retstr=ChopLastCharacterOff(RemoveLastItemFromList(SAIfldrFP,ListSepStr=":"),":")	//just move one directory up!
	retstr=ChopLastCharacterOff(RemoveLastItemFromList(retstr,ListSepStr=":"),":")				//just move another directory up!
	return retstr
end


Function /S SP2_RawFldrFP2HKfldrFP(rawfldrfp)
	//return string: full path to (or name of the) housekeeping folder corresponding to an SP2 raw data folder.
	//martin.gysel@psi.ch; 11/11/2008
	string rawfldrfp	//full path to or name of an SP2 raw data folder
	
	string rawfldrnam=laststringfromlist(rawfldrfp, listsepstr=":")
	string pathtofldr
	if (strlen(rawfldrfp)==strlen(rawfldrnam))
		pathtofldr=""
	else
		pathtofldr=RemoveLastItemFromList(rawfldrfp,ListSepStr=":")
	endif
	string pbpfldrnam=QuoteRemover(rawfldrnam)+ksSP2hkFldrSuffix	
	return QuoteLiberalPath(pathtofldr+pbpfldrnam)
end

Function /S SP2_RawFldrFP2iniFldrFP(rawfldrfp)
	//return string: full path to (or name of the) config-file subfolder corresponding to an SP2 raw data folder.
	//martin.gysel@psi.ch; 11/11/2008
	string rawfldrfp	//full path to or name of an SP2 raw data folder
	
	string rawfldrnam=laststringfromlist(rawfldrfp, listsepstr=":")
	string pathtofldr
	if (strlen(rawfldrfp)==strlen(rawfldrnam))
		pathtofldr=""
	else
		pathtofldr=RemoveLastItemFromList(rawfldrfp,ListSepStr=":")
	endif
	string inifldrnam=QuoteRemover(rawfldrnam)+ksSP2configSubFldr	
	return QuoteLiberalPath(pathtofldr+inifldrnam)
end


Function SP2_AnalyseRawTracesBtt(ctrlname) : ButtonControl
	//Button procedure for the analysis of SP2 raw traces
	//return value: 0, not used
	//martin.gysel@psi.ch; 24/11/2010
	string ctrlname			//name of button control; not used
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//get data folder(s)
	string FldrFPlist=SP2_getFolder(startingDF=savedDF, type="raw", includeAll=1) // jcc  //	BrowseForFolder("Select folder(s) containing the SP2 raw data:", StartPath=savedDF, AbortMode=1, MultiMode=1)
	variable nFldrs=itemsinlist(FldrFPlist)
	//loop over selected folders and run post processing
	variable find
	string currFldr
	for (find=0; find<nFldrs; find+=1)
		currFldr=stringfromlist(find,FldrFPlist)
		SP2_AnalyseRawTraces(rawfldrfp=currFldr)
	endfor
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_AnalyseRawTraces([rawfldrfp, LEOTAmode, BeamShapeFldrFP, DelBits, ChannelBits, scattfittype, incfittype, incBLmode, nPts4ScattPeakHt, nPts4IncPeakHt, nPts4baselineVal, PPmode, PrintInfo]) : ButtonControl
	//This function analyses SP2 raw data traces.
	//return value: 0; not used
	//martin.gysel@psi.ch;	11/11/2008, 11/07/2009, 06/10/2009, 18/12/2009, 26/04/2010, 12/08/2010, 13/08/2010, 16/08/2010, 28/09/2010, 24/11/2010
	//						12/05/2011, 18/05/2011, 19/05/2011, 15/02/2012, 05/03/2012
	//joel.c.corbin+sci@gmail.com;	2016-09-21
	string rawfldrfp	//full path to data folder containing the raw trace matrices
					//default: browse for folder
	variable LEOTAmode		//1:	run LEO-fit trace analysis
							//0:	no LEO-fit
							//default: use panel setting
							//note: channel selection according to panel settings
	string BeamShapeFldrFP		//full path to folder containing the beam shape data
								//default: browse for folder
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0  => no raw traces are deleted
					//DelBits>0  => selected raw traces are deleted
					//see sub-procedure for meaning of the individual bits
					//default: use panel setting (all or nothing deleted)
	variable ChannelBits	//bitwise parameter determining which data channels are to be analysed
						//bit0=1 true: analyse high gain scattering channel
						//bit1=2 true: analyse high gain broadband incandescence channel
						//bit2=4 true: analyse high gain narrowband incandescence channel
						//bit3=8 true: analyse high gain split detector channel
						//bit4=16 true: analyse low gain scattering channel
						//bit5=32 true: analyse low gain broadband incandescence channel
						//bit6=64 true: analyse low gain narrowband incandescence channel
						//bit7=128 true: analyse low gain split detector channel
						//default: use panel settings
	variable scattfittype	//fit type for scattering channel data
						//0: baseline + peak height from Gaussian fit
						//1: baseline from pretrigger points, peak height from Gaussian fit
						//2: baseline from pretrigger points, peak height from maximum value
						//default: use panel settings
	variable incfittype		//fit type for incandescence data
						//0: baseline from pretrigger points, peak height from maximum value
						//1: baseline from Gaussian fit, peak height from maximum value
						//default: use panel settings
	variable incBLmode	//1: use configuration file to determine the number of pretrigger points for baseline averageing
						//0: get number of pretrigger points for baseline averageing from 'nPts4baseline'
						//default: use panel settings
						//note, this variable is only used if either
						//	- an incandescence channel is to be analysed and if incfittype=0 or
						//	- the split detector channel is to be analysed					
	variable nPts4baselineVal	//number of pretrigger points to be include for getting the baseline
							//default: use panel settings
							//note, this variable is only used if either
							//	- an incandescence channel is to be analysed and if incfittype=0 or
							//	- the split detector channel is to be analysed
	variable nPts4ScattPeakHt	//number of points to be averaged for peak height of scattering signals
							//note: use odd numbers
							//default: use panel setting 
	variable nPts4IncPeakHt	//number of points to be averaged for peak height of incandescence signals
							//note: use odd numbers
							//default: use panel setting 
	variable PPmode		//1:	run post processing after trace analysis
						//0:			do not run trace analysis
						//default:		use panel settings
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history

	//preparations
	string savedDF=getdatafolder(1)					
	string currproc, message
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2analyseTraces
	string tmpfldrpath=getdatafolder(1)
	//set defaults
	if (paramisdefault(rawfldrfp))
		rawfldrfp=SP2_getFolder(startingDF=savedDF, type="raw") // jcc :: was : BrowseForFolder("Select folder containing the raw data to be analysed", StartPath=savedDF)
		if (stringmatch(rawfldrfp, "cancelled"))		
			setdatafolder $savedDF
			killdatafolder /z $tmpfldrpath
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif	
	endif
	variable pathOK=SP2_check_IsRawFldr(rawfldrfp)
	if (!pathOK)
		//not a raw data folder => do nothing!
		setdatafolder $savedDF
		killdatafolder /z $tmpfldrpath
		return 0
	endif
	//associated data folders
	string pbpfldrfp=SP2_RawFldrFP2PBPfldrFP(rawfldrfp)
	string inifldrfp=SP2_RawFldrFP2inifldrFP(rawfldrfp)
	CreateFoldersOfFullPath(pbpfldrfp, 0)
	//get rows dimension
	setdatafolder $rawfldrfp
	wave /d RawFldrFileIDini=$ksSP2correspConfigfileID
	wave TimeWave=$ksSP2timewave
	variable nRows=numpnts(TimeWave)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//further default values
	if (paramisdefault(LEOTAmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar performLEOfit=$ksSP2performLEOfit
		LEOTAmode=performLEOfit
	endif
	if (paramisdefault(BeamShapeFldrFP))
		if (LEOTAmode)
			BeamShapeFldrFP= SP2_getBeamShapeFolder() // jcc addition, autodetect folder
		else
			//not needed
			BeamShapeFldrFP=""
		endif
	endif
	BeamShapeFldrFP=ChopLastCharacterOff(BeamShapeFldrFP,":")
	if (paramisdefault(DelBits))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar rawdatadelmode=$ksSP2rawdatadelmode
		DelBits=rawdatadelmode*(2^16-1)		//delete all raw traces and other unneccessary waves
	endif
	if (paramisdefault(channelbits))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar fitscatt=$ksSP2fitSCHGchan
		Nvar fitbroad=$ksSP2fitBBHGchan
		Nvar fitnarr=$ksSP2fitNBHGchan
		Nvar fitsplit=$ksSP2fitSPHGchan		
		Nvar fitscattLG=$ksSP2fitSCLGchan
		Nvar fitbroadLG=$ksSP2fitBBLGchan
		Nvar fitnarrLG=$ksSP2fitNBLGchan
		Nvar fitsplitLG=$ksSP2fitSPLGchan
		channelbits=fitscatt*kSP2chanbitSCHG
		channelbits+=fitbroad*kSP2chanbitBBHG
		channelbits+=fitnarr*kSP2chanbitNBHG
		channelbits+=fitsplit*kSP2chanbitSPHG
		channelbits+=fitscattLG*kSP2chanbitSCLG
		channelbits+=fitbroadLG*kSP2chanbitBBLG
		channelbits+=fitnarrLG*kSP2chanbitNBLG
		channelbits+=fitsplitLG*kSP2chanbitSPLG
	endif			
	if (paramisdefault(incfittype))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar panelincfittype=$ksSP2incfittype
		incfittype=panelincfittype
	endif
	if (incfittype!=0 && incfittype!=1)
		setdatafolder $savedDF
		SP2_abort("The parameter 'incfittype' handed over to the function "+currproc+" must be 0 or 1!")
	endif
	if (paramisdefault(scattfittype))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar panelscattfittype=$ksSP2scattfittype
		scattfittype=panelscattfittype
	endif
	if (scattfittype!=0 && scattfittype!=1 && scattfittype!=2)
		setdatafolder $savedDF
		SP2_abort("Undefined value of the parameter 'scattfittype' handed over to the function "+currproc+"!")
	endif
	if (paramisdefault(incBLmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PretriggerAvgMode=$ksSP2pretriggeravgmode
		incBLmode=PretriggerAvgMode			
	endif
	setdatafolder $tmpfldrpath
	make /o/n=(nRows) nPts4baselineWav=NaN
	if (incBLmode==1)
		//get number of pretrigger points from configuration file
		setdatafolder $inifldrfp
		wave NumberOfPretrigger=$ksSP2configNumberOfPretrigger
		wave /d iniFldrFileIDini=$ksSP2configUniqueFileIDini
		nPts4baselineWav=NumberOfPretrigger[binarysearch(iniFldrFileIDini,RawFldrFileIDini[p])]
		nPts4baselineWav-=kSP2ignoreMicrosecB4Trigger*SamplingRateRawDataMHz
	elseif (incBLmode==0)
		if (paramisdefault(nPts4baselineVal))
			//get "nPts4baseline" from toolkit panel
			setdatafolder $ksSP2PathToToolkitPanelFldr	
			Nvar PretriggerNumb=$ksSP2pretriggernumb
			nPts4baselineVal=PretriggerNumb			
		else
			//use "nPts4baseline" as provided with the optional parameter
		endif
		nPts4baselineWav=nPts4baselineVal
	else
		//value of incBLmode not defined => abort
		setdatafolder $savedDF
		killdatafolder /z $tmpfldrpath
		SP2_abort("The parameter 'incBLmode' handed over to the function "+currproc+" must be 0 or 1!")
	endif
	if (paramisdefault(nPts4ScattPeakHt))
		//get "nPts4IncPeakHt" from toolkit panel
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PanelnPts4scattPeakHt=$ksSP2scattFitnPts4Peak
		nPts4ScattPeakHt=PanelnPts4scattPeakHt			
	endif
	if (paramisdefault(nPts4IncPeakHt))
		//get "nPts4IncPeakHt" from toolkit panel
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PanelnPts4IncPeakHt=$ksSP2incFitnPts4Peak
		nPts4IncPeakHt=PanelnPts4IncPeakHt			
	endif
	if (paramisdefault(PPmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PanelPPmode=$ksSP2postProcessing
		PPmode=PanelPPmode
	endif
	if (PPmode!=0 && PPmode!=1)
		setdatafolder $savedDF
		killdatafolder /z $tmpfldrpath
		SP2_abort("The parameter 'PPmode' handed over to the function "+currproc+" must be 0 or 1!")
	endif
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	
//	//check availability of the raw data
//	setdatafolder $rawfldrfp
//	wave TraceMatSCHG=$ksSP2SCHGprefix+ksSP2rawtracemat
//	variable SCHGavailable=waveexists(TraceMatSCHG)
//	wave TraceMatBBHG=$ksSP2BBHGprefix+ksSP2rawtracemat
//	variable BBHGavailable=waveexists(TraceMatBBHG)
//	wave TraceMatNBHG=$ksSP2NBHGprefix+ksSP2rawtracemat
//	variable NBHGavailable=waveexists(TraceMatNBHG)
//	wave TraceMatSPHG=$ksSP2SPHGprefix+ksSP2rawtracemat
//	variable SPHGavailable=waveexists(TraceMatSPHG)
//	wave TraceMatSCLG=$ksSP2SCLGprefix+ksSP2rawtracemat
//	variable SCLGavailable=waveexists(TraceMatSCLG)
//	wave TraceMatBBLG=$ksSP2BBLGprefix+ksSP2rawtracemat
//	variable BBLGavailable=waveexists(TraceMatBBLG)
//	wave TraceMatNBLG=$ksSP2NBLGprefix+ksSP2rawtracemat
//	variable NBLGavailable=waveexists(TraceMatNBLG)
//	wave TraceMatSPLG=$ksSP2SPLGprefix+ksSP2rawtracemat
//	variable SPLGavailable=waveexists(TraceMatSPLG)
	//access further panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr	
	Nvar incFitMatchNarr2Broad=$ksSP2incFitMatchNarr2Broad
	Nvar BaselineFilterModeSCHG=$ksSP2baselineFiltermodeSCHG
	Nvar BaselineFilterModeBBHG=$ksSP2baselineFiltermodeBBHG
	Nvar BaselineFilterModeNBHG=$ksSP2baselineFiltermodeNBHG
	Nvar BaselineFilterModeSPHG=$ksSP2baselineFiltermodeSPHG
	Nvar BaselineFilterModeSCLG=$ksSP2baselineFiltermodeSCLG
	Nvar BaselineFilterModeBBLG=$ksSP2baselineFiltermodeBBLG
	Nvar BaselineFilterModeNBLG=$ksSP2baselineFiltermodeNBLG
	Nvar BaselineFilterModeSPLG=$ksSP2baselineFiltermodeSPLG
	Nvar BaselineNoiseAmpSCHG=$ksSP2baselineNoiseAmpSCHG
	Nvar BaselineNoiseAmpBBHG=$ksSP2baselineNoiseAmpBBHG
	Nvar BaselineNoiseAmpNBHG=$ksSP2baselineNoiseAmpNBHG
	Nvar BaselineNoiseAmpSPHG=$ksSP2baselineNoiseAmpSPHG
	Nvar BaselineNoiseAmpBBLG=$ksSP2baselineNoiseAmpBBLG
	Nvar BaselineNoiseAmpNBLG=$ksSP2baselineNoiseAmpNBLG	
	Nvar BaselineNoiseAmpSCLG=$ksSP2baselineNoiseAmpSCLG
	Nvar BaselineNoiseAmpSPLG=$ksSP2baselineNoiseAmpSPLG
	Nvar SAIgetIt=$ksSP2SAIgetIt
	Nvar SAItimeLagStart=$ksSP2SAItimeLagStart
	Nvar SAItimeLagEnd=$ksSP2SAItimeLagEnd
	Svar SAIchanPrefixInc=$ksSP2SAIchanPrefixInc
	if (SAItimeLagStart > SAItimeLagEnd) // v4111
		// Just annoying i guess: SP2_postErrorMsg("On the trace analysis tab, SAI start must precede SAI end. Inputs have now been corrected.")
		variable tmp= SAItimeLagStart
		SAItimeLagStart= SAItimeLagEnd
		SAItimeLagEnd= SAItimeLagStart
	endif
	
	//print info to history
	variable timerRefNum
	if (PrintInfo==1)
		Printf "[%s] Analysing %g events' raw traces in %s... ", now(), nRows, rawfldrfp 
		timerRefNum=StartMSTimer			
	endif
	
	//analyse raw traces
		//broadband channel (high gain)
		if (channelbits & kSP2chanbitBBHG)// & BBHGavailable)
			if (incfittype==0)
				SP2_TA_Incand_MT(kSP2chanbitBBHG, rawfldrfp, PBPfldrfp, nPts4baselineWav, nPts4IncPeakHt, BaselineFilterModeBBHG, 0, BaselineDelta=BaselineNoiseAmpBBHG)
			elseif (incfittype==1)
				SP2IncandGaussianBaselineFit(kSP2chanbitBBHG, rawfldrfp, PBPfldrfp)
			endif
		endif
		//broadband channel (low gain)
		if (channelbits & kSP2chanbitBBLG)// & BBLGavailable)
			if (incfittype==0)
				SP2_TA_Incand_MT(kSP2chanbitBBLG, rawfldrfp, PBPfldrfp, nPts4baselineWav, nPts4IncPeakHt, BaselineFilterModeBBLG, 0, BaselineDelta=BaselineNoiseAmpBBLG)
			elseif (incfittype==1)
				SP2IncandGaussianBaselineFit(kSP2chanbitBBLG, rawfldrfp, PBPfldrfp)
			endif
		endif
		//narrowband channel (high gain)
		if (channelbits & kSP2chanbitNBHG)// & NBHGavailable)
			if (incfittype==0)
				SP2_TA_Incand_MT(kSP2chanbitNBHG, rawfldrfp, PBPfldrfp, nPts4baselineWav, nPts4IncPeakHt, BaselineFilterModeNBHG, incFitMatchNarr2Broad, BaselineDelta=BaselineNoiseAmpNBHG)		
			elseif (incfittype==1)
				SP2IncandGaussianBaselineFit(kSP2chanbitNBHG, rawfldrfp, PBPfldrfp)			
			endif
		endif
		//narrowband channel (low gain)
		if (channelbits & kSP2chanbitNBLG)// & NBLGavailable)
			if (incfittype==0)
				SP2_TA_Incand_MT(kSP2chanbitNBLG, rawfldrfp, PBPfldrfp, nPts4baselineWav, nPts4IncPeakHt, BaselineFilterModeNBLG, incFitMatchNarr2Broad, BaselineDelta=BaselineNoiseAmpNBLG)		
			elseif (incfittype==1)
				SP2IncandGaussianBaselineFit(kSP2chanbitNBLG, rawfldrfp, PBPfldrfp)			
			endif
		endif
		//scattering channel (high gain)
		if (channelbits & kSP2chanbitSCHG)// & SCHGavailable)
			SP2_TA_Scattering_MT(kSP2chanbitSCHG, rawfldrfp, PBPfldrfp, scattfittype, nPts4scattPeakHt, nPts4baselineWav, BaselineFilterModeSCHG, BaselineNoiseAmpSCHG, SAIgetIt, SAItimeLagStart, SAItimeLagEnd, SAIchanPrefixInc)
		endif	
		//scattering channel (low gain)
		if (channelbits & kSP2chanbitSCLG)// & SCLGavailable)
			SP2_TA_Scattering_MT(kSP2chanbitSCLG, rawfldrfp, PBPfldrfp, scattfittype, nPts4scattPeakHt, nPts4baselineWav, BaselineFilterModeSCLG, BaselineNoiseAmpSCLG, SAIgetIt, SAItimeLagStart, SAItimeLagEnd, SAIchanPrefixInc)
		endif	
		//split detector channel (high gain)
		if (channelbits & kSP2chanbitSPHG)// & SPHGavailable)
			SP2_TA_PSD_MT(kSP2chanbitSPHG, rawfldrfp, PBPfldrfp, nPts4baselineWav, BaselineFilterModeSPHG, BaselineDelta=BaselineNoiseAmpSPHG)
		endif
		//split detector channel (low gain)
		if (channelbits & kSP2chanbitSPLG)// & SPLGavailable)
			SP2_TA_PSD_MT(kSP2chanbitSPLG, rawfldrfp, PBPfldrfp, nPts4baselineWav, BaselineFilterModeSPLG, BaselineDelta=BaselineNoiseAmpSPLG)
		endif
	//get bandratio from raw traces(ratio of peak areas)
		//high gain
		SP2_BandRatioFromTraceArea(0, PBPfldrfp)
		//low gain
		SP2_BandRatioFromTraceArea(1, PBPfldrfp)
	//traces analysis summary matrices for graphs
	SP2_traceAnalysisMatrices(pbpfldrfp, ChannelBits=ChannelBits)	
	//LEO-fit trace analysis
	if (LEOTAmode)
		SP2_LEOfitTraceAnalysisButt("", pbpfldrfp=pbpfldrfp, BeamShapeFldrFP=BeamShapeFldrFP, LEOppMode=0, DelBits=0)
	endif
	//delete raw data if selected
	SP2_DeleteRawTraces("", rawfldrfp=rawfldrfp, DelBits=DelBits)
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "finished in %s.\r", secs2str(elapsed/1e6)
	endif
	//post processing
	if (PPmode==1)
		SP2_PBPpostprocessing(pbpfldrfp=PBPfldrfp, PrintInfo=PrintInfo)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_PBPpostprocBtt(ctrlname) : ButtonControl
	//Button procedure for post processing of SP2 trace analysis results
	//return value: 0, not used
	//martin.gysel@psi.ch; 10/09/2010
	string ctrlname			//name of button control; not used
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//get data folder(s)  
//	string FldrFPlist=BrowseForFolder("Select folder(s) containing the SP2 PBP data:", StartPath=savedDF, AbortMode=1, MultiMode=1)
	string FldrFPlist=SP2_getFolder(startingDF=savedDF, type="PBP", includeAll=1) 
	variable nFldrs=itemsinlist(FldrFPlist)
	//loop over selected folders and run post processing
	variable find
	string currFldr
	for (find=0; find<nFldrs; find+=1)
		currFldr=stringfromlist(find,FldrFPlist)
		SP2_PBPpostprocessing(pbpfldrfp=currFldr)
	endfor
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2_PBPpostprocessing([pbpfldrfp, calibfldrfp, PrintInfo, GraphMode])
	//This function adds additional waves after basic fitting of SP2 data
	//return value: 0; not used
	//note: the post processing for the scattering and split detectors remains to be included
	//martin.gysel@psi.ch;	02/11/2008, 12/11/2008, 14/11/2008, 04/02/2009, 22/05/2009, 09/06/2009, 14/06/2009, 10/07/2009
	//						27/08/2009, 30/08/2009, 01/09/2009, 15/10/2009, 21/10/2009, 03/11/2009, 04/11/2009, 22/11/2009
	//						23/03/2010, 28/04/2010, 29/04/2010; 26/05/2010, 03/08/2010, 11/08/2010, 15/08/2010, 16/08/2010
	//						10/09/2010, 12/09/2010, 13/09/2010, 16/09/2010, 12/10/2010, 13/10/2010, 04/11/2010, 25/11/2010
	//						26/11/2010, 28/11/2010, 29/11/2010, 13/01/2010, 06/01/2012
	//marie.laborde@psi.ch;	29/10/09
	//joel.c.corbin+sci@gmail.com; 2016-03-04; minor changes + support for SAI calibration of scattering
	
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string calibfldrfp		//full path to folder containing the calibration coefficients to be applied
						//default: use panel settings
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
				
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc :: was : BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	pbpfldrfp=QuoteLiberalPath(pbpfldrfp)
	variable pathOK=SP2_check_IsPBPfldr(pbpfldrfp)
	if (!pathOK)
		//not a pbp data folder => do nothing!
		setdatafolder $savedDF
		return 0
	endif
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	if (paramisdefault(calibfldrfp))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Svar PanelCalibFldr=$ksSP2calibFldr
		calibfldrfp=ksSP2PathToCalibDataFldr+PanelCalibFldr
	endif
	calibfldrfp=QuoteLiberalPath(calibfldrfp)
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2postprocessing
	string tmpfldrpath=getdatafolder(1)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr	
	Nvar BCdensity=$ksSP2BCdensity
	Nvar nHistoBins=$ksSP2nHistobins
	Svar RefractIndexID=$ksSP2scattRefractIndex
	Nvar FitLogNorm=$ksSP2lognormfit	
	Nvar ExtractConcTser=$ksSP2extractConcTimeSer
	Nvar ExtractSDtser=$ksSP2extractSDTimeSer
	Nvar calcBHNH=$ksSP2calcBHNH
	Nvar calcBHNL=$ksSP2calcBHNL
	Nvar calcBHBL=$ksSP2calcBHBL
	Nvar calcBLNL=$ksSP2calcBLNL
	Nvar calcSHSL=$ksSP2calcSHSL
	Nvar calcPHPL=$ksSP2calcPHPL
	Nvar LEOfitPostProcModeCB=$ksSP2leoFitPostProcModeCB
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	NVAR SAI_calib_flag= $ksSP2useSAIforScattCalib
	NVAR treatSaturatedAsNaN= $ksSP2treatSaturatedAsNaN
	//write info string
	setdatafolder $pbpfldrfp
	string /g $ksSP2postProcInfoStr=""
	Svar PostProcInfoStr=$ksSP2postProcInfoStr
	PostProcInfoStr+=ksSP2calibFldrKey+": "+calibfldrfp+"\r"
	PostProcInfoStr+=ksSP2bcDensityKey+": "+num2str(BCdensity)+"\r"
	PostProcInfoStr+=ksSP2numbSizeBinsKey+": "+num2str(nHistoBins)+"\r"
	PostProcInfoStr+=ksSP2refractIndexKey+": "+RefractIndexID+"\r"
	//print info to history
	variable timerRefNum
	PrintInfo=PrintInfo
	if (PrintInfo==1)
		Printf "\t// Postprocessing PBP data in folder: "+pbpfldrfp+" ... \r"
		timerRefNum=StartMSTimer			
	endif
	//access general raw data waves
	setdatafolder $rawfldrfp
	wave TimeDate=$ksSP2TimeDate
	wave YAGpower=$ksSP2YAGpower	
	wave Mask_BadDataMain=$ksSP2pbpMaskBadData
	//get number of triggers
	variable nTriggers=numpnts(TimeDate)	
	//update sample volume wave and access it
	setdatafolder $rawfldrfp
	SP2sampleVolumeWaveCalc(rawfldrfp)
	wave SampleVolume=$ksSP2sampleVolume
	variable TotSampleVolume=SumNaN(SampleVolume)			//in m
	//prepare various waves
		//BC density
		setdatafolder $pbpfldrfp
		make /o/n=(nTriggers)  $ksSP2PBPdensityOfBC=BCdensity
		wave DensityOfBC=$ksSP2PBPdensityOfBC
		note DensityOfBC, "density used to convert measured BC mass of individual particles into corresponding BC core diameters;"
		note DensityOfBC, "note that this wave is sometimes used by the code as a variable. Then, only the first value [0] is used. This is confusing and should be fixed;"
		//classification of triggered events
		SP2_ClassificationWaveCreator(pbpfldrfp)
		setdatafolder $pbpfldrfp
		wave Classification=$ksSP2pbpClassification
		wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut
	//Mean YAG power
	variable MeanYAGpower=Mean(YAGpower)
	//various variables and strings
	variable nchans, chanind, nSplineSegments, currCut, currEventBit
	string currPrefix
	
	//ANALYSE SCATTERING CHANNEL DATA
		//define possible scattering channels
		string chanlist=SP2_ChanListScattOnly()
		nchans=itemsinlist(chanlist)
		//loop over all scattering channels and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,chanlist)
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 4)
			currCut=SP2chanPrefix2chanProperty(currPrefix, 1)
			//access peak analysis waves
			setdatafolder $pbpfldrfp
			wave /Z ScattPeakHt=$currPrefix+ksSP2PBPscattGausspeakHeight			
			//process data of current channel if available
			if ( waveexists(ScattPeakHt) )
				//access calibration coefficients
				string SAIfldrFP= SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
				if (SAI_calib_flag && DataFolderExists(SAIfldrFP))
					// this is not used on the first PP!
					SP2_PostErrorMsg("SAI scattering calibration was selected, but needs Postprocessing to be repeated before it can be applied")
					wave /d ScattCalCoef= SP2_get_SAI_scattCoef_wave(currPrefix[1,4], SAIfldrFP)
				else
					// old code + a hack to expand the single value as a wave
					setdatafolder $calibfldrfp
					wave /Z Panel_CalCoef_Scatt=$currPrefix+ksSP2CalCoefBnam
					if (!WaveExists(Panel_CalCoef_Scatt))
						SP2_postErrorMsg(currPrefix+" scattering calibration not found!")
						make /free Panel_CalCoef_Scatt={nan}
					endif
					make /free/d/n=(nTriggers) ScattCalCoef= Panel_CalCoef_Scatt[0]
				endif	
				variable meanScattCalCoef= wavemean(ScattCalCoef)
							/// old code;
														// setdatafolder $calibfldrfp
														// wave CalCoef=$currPrefix+ksSP2CalCoefBnam
														// if (!WaveExists(CalCoef))
															// string alertstr= "CalCoef wave for "+currPrefix+" not found. "
															// alertstr+= "Check your calibration folder. skipping channel. "
															// alertstr+= "ERROR AT: " + GetRTStackInfo(0)	
															// continue
														// endif
				//optical diameter assuming purely scattering particles
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $currPrefix+ksSP2pbpOptDiam
				wave satd=$currPrefix+ksSP2PBPsaturated
				wave OptDiam=$currPrefix+ksSP2pbpOptDiam
				note OptDiam, "optical diameter [nm] of individual particles, assuming purely scattering particles with the refractive index of: "+RefractIndexID+";"
				OptDiam= ( (Classification[p] & currEventBit) && !(ClassificationByMinCut[p]&kSP2incandEventBitSum) ) ? SP2scattPeakHt2OptDiamNoCore(ScattPeakHt[p], ScattCalCoef[p], YAGpower[p], RefractIndexID) : NaN		//filter points below cut
				make /o/n=(nTriggers) $currPrefix+ksSP2pbpLogOptDiam
				wave LogOptDiam=$currPrefix+ ksSP2pbpLogOptDiam
				note LogOptDiam, "logarithm of optical diameter of individual particles (purely scattering particles only);"
				note LogOptDiam, "see note of wave "+NameOfWave(OptDiam)+" for details on the diameter calculation;"
				LogOptDiam=log(OptDiam)	
				//lower cut-off diamter
				setdatafolder $pbpfldrfp
				make /o/n=1 	$currPrefix+ksSP2pbpDiamCutLow=SP2scattPeakHt2OptDiamNoCore(currCut, meanScattCalCoef, MeanYAGpower, RefractIndexID)
				wave DiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
				note DiamCutLow, "Lower cut-off diameter of scattering data;"
				note DiamCutLow, "Mean YAG power: "+num2str(MeanYAGpower)+";"
				note DiamCutLow, "calibration: "+getwavesdatafolder(ScattCalCoef,0)+";"
				//total number and number concentration of scattering particles
				make /o/n=(1) $currPrefix+ksSP2pbpOptTotalNumb
				wave OptTotalNumb=$currPrefix+ksSP2pbpOptTotalNumb
				note OptTotalNumb, "total number of purely scattering particles with peak height above threshold [#];"
				OptTotalNumb=NumberOfPointsWithTrueBitPair(Classification, currEventBit, ClassificationByMinCut, 0, ExcludeBitOr1=kSP2incandEventBitSum, ExcludeBitOr2=kSP2incandEventBitSum)
				make /o/n=(1) $currPrefix+ksSP2pbpOptNumbConc
				wave OptNumbConc=$currPrefix+ksSP2pbpOptNumbConc
				note OptNumbConc, "number concentration of purely scattering particles with peak height above threshold [#/cm];"			
				OptNumbConc=OptTotalNumb/TotSampleVolume*1e-6					//unit conversion factor: 1/m => 1/cm
				//peak height distribution
				setdatafolder $pbpfldrfp
				make /o/n=(nHistoBins) $currPrefix+ksSP2pbpPeakHtDistr
				wave PeakHtDistr=$currPrefix+ksSP2pbpPeakHtDistr	
				note PeakHtDistr, "histogram of measured scattering peak heights;"
				note PeakHtDistr, "note: this includes BC containing particles!;"
				if (nTriggers > 1) // jcc added 150930
					Histogram/C/B=1 ScattPeakHt,PeakHtDistr								//histogram of peak heights
				endif
				//number size distribution
				setdatafolder $pbpfldrfp
				make /o/n=(nHistoBins) $currPrefix+ksSP2pbpOptNumbDistr
				wave OptNumbDistr=$currPrefix+ksSP2pbpOptNumbDistr
				note OptNumbDistr, "number size distribution of purely scattering particles: dN/dlogDp [#/cm];"
				if (nTriggers > 1) // jcc added 150930
					Histogram/C/B=1 LogOptDiam,OptNumbDistr							//histogram of logDp values as first step towards dN/dlogDp
					if (treatSaturatedAsNaN) // note: this is done here (and not e.g. in Classification or the single-value waves) to allow the user to see that saturated peaks exist--jcc
						OptNumbDistr[nHistoBins-1]=nan
					endif 
				endif
				duplicate /o OptNumbDistr, $currPrefix+ksSP2pbpOptdistrDiamMid			//wave for midpoint diameters
				wave OptDistrDiamMidpt=$currPrefix+ ksSP2pbpOptdistrDiamMid
				note /K OptDistrDiamMidpt
				note OptDistrDiamMidpt, "midpoint diameters [nm] for number size distribution of scattering particles;"
				ScaleToWav(OptNumbDistr, OptDistrDiamMidpt, 0)								//get diameter scale
				OptDistrDiamMidpt=10^OptDistrDiamMidpt										//get diameter scale (histogram was done on logDp
				duplicate /o OptNumbDistr, $currPrefix+ksSP2pbpOptDistrDiamBdr			//wave for boundary diameters
				wave OptDistrDiamBdr=$currPrefix+ ksSP2pbpOptDistrDiamBdr
				note /K OptDistrDiamBdr
				note OptDistrDiamBdr, "bin boundary diameters [nm] for number size distribution of scattering particles;"
				BinCentresToBoundariesLog(OptDistrDiamMidpt, OptDistrDiamBdr)					//boundary diameters
				duplicate /o OptNumbDistr, $currPrefix+ksSP2pbpOptDistrDlogDp			//wave with deltaLogDp
				wave OptDistrDlogDp=$currPrefix+ksSP2pbpOptDistrDlogDp			
				note /K OptDistrDlogDp
				note OptDistrDlogDp, "widths \"dlogDp\" of size bins of number size distribution of scattering particles;"
				OptDistrDlogDp=log(OptDistrDiamBdr[p+1])-log(OptDistrDiamBdr[p])				//calculate dLogDp
				OptNumbDistr/=OptDistrDlogDp												//normalise with deltaLogD
				OptNumbDistr=OptNumbDistr/TotSampleVolume*1e-6							//unit conversion factor: 1/m => 1/cm
			endif
		endfor
		
		
//	//ANALYSE INCANDESCENCE CHANNEL DATA
		//define possible incandescence channels
		nchans=itemsinlist(SP2_ChanListIncandOnly())
		//loop over all incandescence channels and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,SP2_ChanListIncandOnly())
			currCut=SP2chanPrefix2chanProperty(currPrefix, 1)
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 4)
			//access peak analysis waves
			setdatafolder $pbpfldrfp
			wave /Z IncPeakHt=$currPrefix+ksSP2PBPtracefitPeakHt
			//process data of current channel if available
			if ( waveexists(IncPeakHt) )
				//access calibration coefficients
				setdatafolder $calibfldrfp
				wave CalCoefExpanded=$currPrefix+ksSP2CalCoefBnam
				nSplineSegments=SP2_calibCurveSplineCheck(CalCoefExpanded)
				//lower cut-off diamter
				setdatafolder $pbpfldrfp
				make /o/n=1 	$currPrefix+ksSP2pbpDiamCutLow=SP2peakHt2BCdiam(currCut, CalCoefExpanded, DensityOfBC, nSplineSegments)
				wave IncDiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
				note IncDiamCutLow, "Lower cut-off diameter;"
				note IncDiamCutLow, "BC density: "+num2str(DensityOfBC[0])+";"
				note IncDiamCutLow, "calibration: "+getwavesdatafolder(CalCoefExpanded,0)+";"
				//mass
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $currPrefix+ksSP2pbpBCmass
				wave IncBCmass=$currPrefix+ksSP2pbpBCmass
				note IncBCmass, "mass of individual BC particles [fg];"
				IncBCmass= Classification[p] & currEventBit ? SP2peakHt2BCmass(IncPeakHt, CalCoefExpanded, nSplineSegments) : NaN
				//diameter
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $currPrefix+ksSP2pbpBCdiam
				wave IncBCdiam=$currPrefix+ksSP2pbpBCdiam
				note IncBCdiam, "diameter of individual BC particles [nm], calculated from measured mass assuming density of "+num2str(BCdensity)+" kg/m;"
				IncBCdiam=SP2bcMass2diam(IncBCmass, DensityOfBC)
				//logDiam
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $currPrefix+ksSP2pbpBClogdiam
				wave IncBClogdiam=$currPrefix+ksSP2pbpBClogdiam
				note IncBClogdiam, "logarithm of diameter of individual BC particles;"
				note IncBClogdiam, "see note of wave "+NameOfWave(IncBCdiam)+" for details on the diameter calculation;"
				IncBClogdiam=log(IncBCdiam)
				//total number
				make /o/n=(1) $currPrefix+ksSP2pbpBCtotalnumb
				wave IncBCtotalnumb=$currPrefix+ksSP2pbpBCtotalnumb
				note IncBCtotalnumb, "total number of BC particles with peak height above threshold [#];"
				IncBCtotalnumb=NumberOfPointsWithTrueBit(Classification, currEventBit)
				make /o/n=(1) $currPrefix+ksSP2pbpBCtotalnumbconc
				wave IncBCtotalnumbconc=$currPrefix+ksSP2pbpBCtotalnumbconc
				note IncBCtotalnumbconc, "number concentration of BC particles with peak height above threshold [#/cm];"			
				IncBCtotalnumbconc=IncBCtotalnumb/TotSampleVolume*1e-6					//unit conversion factor: 1/m => 1/cm
				//total mass
				make /o/n=(1) $currPrefix+ksSP2pbpBCtotalmass
				wave IncBCtotalmass=$currPrefix+ksSP2pbpBCtotalmass
				note IncBCtotalmass, "total mass of BC particles with peak height above threshold [fg];"
				IncBCtotalmass=SumNaN(IncBCmass)		//IncBCmass already filtered
				make /o/n=(1) $currPrefix+ksSP2pbpBCtotalmassconc
				wave IncBCtotalmassconc=$currPrefix+ksSP2pbpBCtotalmassconc
				note IncBCtotalmassconc, "mass concentration of BC particles with peak height above threshold [g/m];"
				IncBCtotalmassconc=IncBCtotalmass/TotSampleVolume*1e-9					//unit conversion factor: fg/m => g/m																					
				//peak height distribution
				setdatafolder $pbpfldrfp
				make /o/n=(nHistoBins) $currPrefix+ksSP2pbpPeakHtDistr
				wave IncPeakHtDistr=$currPrefix+ksSP2pbpPeakHtDistr	
				note IncPeakHtDistr, "histogram of measured incandescence peak heights;"
				if (nTriggers > 1) // jcc added 150930
					Histogram/C/B=1 IncPeakHt,IncPeakHtDistr										//histogram of peak heights
				endif
				//number size distribution
				setdatafolder $pbpfldrfp
				make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCnumbdistr /WAVE=IncBCnumbdistr // for dN/dlogDp
				note IncBCnumbdistr, "number size distribution of BC cores: dN/dlogDp [#/cm];"
				if (nTriggers > 1) // v4111 jcc 
					Histogram/N/C/B=1 IncBClogdiam,IncBCnumbdistr						//histogram of logDp values as first step towards dN/dlogDp. 
					wave W_SqrtN // created due to Histogram/N, contains sqrt(N)...for uncertainty calculation. [v4111]
					if (treatSaturatedAsNaN) 
						IncBCnumbdistr[nHistoBins-1]=nan
						W_SqrtN[nHistoBins-1]=nan
					endif 
				endif
				duplicate /o IncBCnumbdistr, $currPrefix+ksSP2pbpBCdistrDiamMid				//wave for midpoint diameters
				wave IncBCDistrDiamMidpt=$currPrefix+ksSP2pbpBCdistrDiamMid							
				note /K IncBCDistrDiamMidpt
				note IncBCDistrDiamMidpt, "midpoint diameters [nm] of BC core number and mass size distributions;"
				ScaleToWav(IncBCnumbdistr, IncBCDistrDiamMidpt, 0)								//get diameter scale
				IncBCDistrDiamMidpt=10^IncBCDistrDiamMidpt										//get diameter scale (histogram was done on logDp
				duplicate /o IncBCnumbdistr, $currPrefix+ksSP2pbpBCDistrDiamBdr				//wave for boundary diameters
				wave IncBCDistrDiamBdr=$currPrefix+ksSP2pbpBCDistrDiamBdr								
				note /K IncBCDistrDiamBdr
				note IncBCDistrDiamBdr, "bin boundary diameters [nm] of BC core number and mass size distributions;"
				BinCentresToBoundariesLog(IncBCDistrDiamMidpt, IncBCDistrDiamBdr)				//boundary diameters
				duplicate /o IncBCnumbdistr, $currPrefix+ksSP2pbpBCDistrDlogDp				//wave with deltaLogDp
				wave IncBCDistrDlogDp=$currPrefix+ksSP2pbpBCDistrDlogDp											
				note /K IncBCDistrDlogDp
				note IncBCDistrDlogDp, "widths \"dlogDp\" of size bins of BC core number and mass size distributions;"
				IncBCDistrDlogDp=log(IncBCDistrDiamBdr[p+1])-log(IncBCDistrDiamBdr[p])			//calculate dLogDp
				IncBCnumbdistr/=IncBCDistrDlogDp												//normalise with deltaLogD
				IncBCnumbdistr=IncBCnumbdistr/TotSampleVolume*1e-6					//unit conversion factor: 1/m => 1/cm
				//mass size distribution
				duplicate /o IncBCnumbdistr, $currPrefix+ksSP2pbpBCmassdistr					//wave for dM/dlogDp
				wave IncBCmassdistr=$currPrefix+ksSP2pbpBCmassdistr
				note /K IncBCmassdistr
				note IncBCmassdistr, "mass size distribution of BC cores: dM/dlogDp [g/m];"
				IncBCmassdistr=IncBCnumbdistr*pi/6*IncBCDistrDiamMidpt^3*DensityOfBC*1e-12	//unit conversion factor: nm/cm*kg => g
				
				// UNCERTAINTIES [added in v4111 by jcc]
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCnumbdistr+ksSP2errSuffix /WAVE=IncBCnumbdistr_err 
					note IncBCnumbdistr_err, "Poisson-based uncertainty [#/cm] corresponding to "+currPrefix+ksSP2pbpBCnumbdistr+";"
					note IncBCnumbdistr_err, "\rSample-volume uncertainty taken as "+num2str(kSP2_sampleVolumeFracErr*100)+"%;"
					// note to self: while it seems counterintuitive that the result is greater uncertainty for more counts, 
					// 		this is consistent with the simple approach taken (zero uncertainty in x)
					IncBCnumbdistr_err= max(1,W_SqrtN) // Igor puts zero uncertainty for zero counts--Poisson says 1
					IncBCnumbdistr_err=IncBCnumbdistr*sqrt((1/IncBCnumbdistr_err)^2 + kSP2_sampleVolumeFracErr^2) // (dX/X)^2 = (dN/N)^2 + (dV/V)^2 = (1/sqrt(N))^2 + (dV/V)^2
					
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCmassdistr+ksSP2errSuffix /WAVE=IncBCmassdistr_err 
					note IncBCmassdistr_err, "Poisson-based uncertainty [#/cm] corresponding to "+currPrefix+ksSP2pbpBCmassdistr+";"
					note IncBCmassdistr_err, "\rSample-volume uncertainty taken as "+num2str(kSP2_sampleVolumeFracErr*100)+"%;"
					note IncBCmassdistr_err, "\rrBC core diameter uncertainty taken as "+num2str(kSP2_relErrDiam*100)+"%;"
					note IncBCmassdistr_err, "\rBC density uncertainty taken as "+num2str(kSP2_relErrDensity*100)+"%;"
					IncBCmassdistr_err=IncBCmassdistr*sqrt((IncBCnumbdistr_err/IncBCnumbdistr)^2 + 3*(kSP2_relErrDiam)^2 + kSP2_relErrDensity^2)  // same formula as for dNdlogDp
			endif
		endfor
		
		
	//ANALYSE PSD (SPLIT DETECTOR) DATA
		//define possible split detector channels
		string splitchanlist=SP2_ChanListSplitOnly()
		nchans=itemsinlist(splitchanlist)
		//loop over all split detector channels and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,splitchanlist)
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 4)
			//access peak analysis waves
			setdatafolder $pbpfldrfp
			wave/Z BasicCentreSplitPos=$currPrefix+ksSP2PBPsplitCentreSplitPos		
			//process data of current channel if available
			if (waveexists(BasicCentreSplitPos))
				//apply threshold via classification wave
				make /o/n=(nTriggers) $currPrefix+ksSP2PBPsplitFilteredSplitPos= Classification[p] & currEventBit ? BasicCentreSplitPos[p] : NaN
				wave FilteredCentreSplitPos=$currPrefix+ksSP2PBPsplitFilteredSplitPos		
				note FilteredCentreSplitPos, "split point copied from the wave \""+nameofwave(BasicCentreSplitPos)+"\" and filtered by the peak height threshold and bad data mask according to the wave \""+nameofwave(Classification)+"\";"
			endif
		endfor
	//Preparations for combining channels
		string PrefixListOne, PrefixListTwo, currPrefixOne, currPrefixTwo, DescriptOne, DescriptTwo, DescriptCombined, combchanlist
		variable CombineBits, nSplineSegmentsOne, nSplineSegmentsTwo, currCutOne, MaxSigOne
		variable MeanBaseLineOne, logSatDiamOne, currEventBitOne
		
		
//COMBINING TWO SCATTERING CHANNELS
		//define possible scattering channels to be combined
		CombineBits=0
		CombineBits+=calcSHSL*kSP2chanbitSHSL
		combchanlist=SP2_ChanListCombScattOnly()
		nchans=itemsinlist(combchanlist)
		//loop over all scattering channel pairs and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix etc.
			currPrefix=stringfromlist(chanind,combchanlist)
			currPrefixOne=stringfromlist(chanind,SP2_ChanListCombScattLowDiam())
			currPrefixTwo=stringfromlist(chanind,SP2_ChanListCombScattHighDiam())
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 0)
			currEventBitOne=SP2chanPrefix2chanProperty(currPrefixOne, 0)
			currCutOne=SP2chanPrefix2chanProperty(currPrefixOne, 1)
			MaxSigOne=SP2chanPrefix2chanProperty(currPrefixOne, 2)
			DescriptOne=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixOne),";")
			DescriptTwo=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixTwo),";")
			DescriptCombined=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefix),";")
			//proceed only if current combination is selected on toolkit panel
			if (currEventBit & CombineBits)	
				//access peak analysis and derived waves
				setdatafolder $pbpfldrfp
				wave /Z ScattDiamOne=$currPrefixOne+ksSP2pbpOptDiam
				wave /Z ScattDiamTwo=$currPrefixTwo+ksSP2pbpOptDiam
				wave /Z ScattOffsetOne=$currPrefixOne+ksSP2PBPscattGaussoffset					
				wave /Z ScattOneSaturated=$currPrefixOne+ksSP2PBPsaturated
				wave /Z ScattTwoSaturated=$currPrefixTwo+ksSP2PBPsaturated
				wave /Z IncOffsetOne=$currPrefixOne+ksSP2PBPtracefitOffset
				//process data of current channel if available
				if ( waveexists(ScattDiamOne) && waveexists(ScattDiamTwo) && waveexists(ScattOneSaturated) )		//proceed only if data are available
					//access calibration coefficients
					setdatafolder $calibfldrfp
					wave CalCoefOne=$currPrefixOne+ksSP2CalCoefBnam
					if (SAI_calib_flag)
						print "SAI CALIB WARNING [f3xw]: combined scattering channels (SHSL) are not yet supported" // anyway, why is this calculation repeated?? should be a wave reference only
					endif
					//baseline and saturation amplitude
					MeanBaseLineOne= WaveExists(IncOffsetOne) ? MeanNaN(IncOffsetOne) : nan // jcc
					logSatDiamOne=log(SP2scattPeakHt2OptDiamNoCore(MaxSigOne-MeanBaseLineOne, CalCoefOne[0], MeanYAGpower, RefractIndexID))
					//saturated
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2PBPsaturated=ScattOneSaturated && ScattTwoSaturated
					wave saturated=$currPrefix+ksSP2PBPsaturated
					note saturated, "Saturation of "+DescriptCombined+" detector:"
					note saturated, "0: not saturated;"
					note saturated, "1: saturated;"
					//lower cut-off diamter
					setdatafolder $pbpfldrfp
					make /o/n=1 	$currPrefix+ksSP2pbpDiamCutLow=SP2scattPeakHt2OptDiamNoCore(currCutOne, CalCoefOne, MeanYAGpower, RefractIndexID)
					wave DiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
					note DiamCutLow, "Lower cut-off diameter of combined "+DescriptOne+" and "+DescriptTwo+" data;"
					note DiamCutLow, "Mean YAG power: "+num2str(MeanYAGpower)+";"
					note DiamCutLow, "calibration: "+getwavesdatafolder(CalCoefOne,0)+";"
					//optical diameter assuming purely scattering particles
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2pbpOptDiam
					wave CombOptDiam=$currPrefix+ksSP2pbpOptDiam
					note CombOptDiam, "optical diameter [nm] of individual particles, assuming purely scattering particles with the refractive index of: "+RefractIndexID+";"
					note CombOptDiam, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombOptDiam= ScattOneSaturated[p] && numtype(ScattDiamTwo[p])==0 ? ScattDiamTwo[p] : ScattDiamOne[p]					
					//logDiam
					make /o/n=(nTriggers) $currPrefix+ksSP2pbpLogOptDiam
					wave CombLogOptDiam=$currPrefix+ ksSP2pbpLogOptDiam
					note CombLogOptDiam, "logarithm of optical diameter of individual particles (purely scattering particles only);"
					note CombLogOptDiam, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					note CombLogOptDiam, "see note of wave "+NameOfWave(CombOptDiam)+" for details on the diameter calculation;"
					CombLogOptDiam=log(CombOptDiam)	
					CombLogOptDiam=  ScattOneSaturated[p] && (CombLogOptDiam[p]<logSatDiamOne) ? 2*logSatDiamOne-CombLogOptDiam[p] : CombLogOptDiam[p]
					//total number and number concentration of scattering particles
					make /o/n=(1) $currPrefix+ksSP2pbpOptTotalNumb
					wave CombOptTotalNumb=$currPrefix+ksSP2pbpOptTotalNumb
					note CombOptTotalNumb, "total number of purely scattering particles with peak height above threshold [#];"
					note CombOptTotalNumb, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombOptTotalNumb=NumberOfPointsWithTrueBitPair(Classification, currEventBitOne, ClassificationByMinCut, 0, ExcludeBitOr1=kSP2incandEventBitSum, ExcludeBitOr2=kSP2incandEventBitSum)
					make /o/n=(1) $currPrefix+ksSP2pbpOptNumbConc
					wave CombOptNumbConc=$currPrefix+ksSP2pbpOptNumbConc
					note CombOptNumbConc, "number concentration of purely scattering particles with peak height above threshold [#/cm];"			
					note CombOptNumbConc, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombOptNumbConc=CombOptTotalNumb/TotSampleVolume*1e-6					//unit conversion factor: 1/m => 1/cm
					//number size distribution
					setdatafolder $pbpfldrfp
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpOptNumbDistr
					wave CombOptNumbDistr=$currPrefix+ksSP2pbpOptNumbDistr
					note CombOptNumbDistr, "number size distribution of purely scattering particles: dN/dlogDp [#/cm];"
					note CombOptNumbDistr, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					if (nTriggers > 1) // jcc added 150930
						Histogram/C/B=1 CombLogOptDiam,CombOptNumbDistr							//histogram of logDp values as first step towards dN/dlogDp
						if (treatSaturatedAsNaN)
							CombOptNumbDistr[nHistoBins-1]=nan
						endif 
					endif
					duplicate /o CombOptNumbDistr, $currPrefix+ksSP2pbpOptdistrDiamMid			//wave for midpoint diameters
					wave CombOptDistrDiamMidpt=$currPrefix+ ksSP2pbpOptdistrDiamMid
					note /K CombOptDistrDiamMidpt
					note CombOptDistrDiamMidpt, "midpoint diameters [nm] for number size distribution of scattering particles;"
					ScaleToWav(CombOptNumbDistr, CombOptDistrDiamMidpt, 0)						//get diameter scale
					CombOptDistrDiamMidpt=10^CombOptDistrDiamMidpt							//get diameter scale (histogram was done on logDp
					duplicate /o CombOptNumbDistr, $currPrefix+ksSP2pbpOptDistrDiamBdr			//wave for boundary diameters
					wave CombOptDistrDiamBdr=$currPrefix+ ksSP2pbpOptDistrDiamBdr
					note /K CombOptDistrDiamBdr
					note CombOptDistrDiamBdr, "bin boundary diameters [nm] for number size distribution of scattering particles;"
					BinCentresToBoundariesLog(CombOptDistrDiamMidpt, CombOptDistrDiamBdr)		//boundary diameters
					duplicate /o CombOptNumbDistr, $currPrefix+ksSP2pbpOptDistrDlogDp				//wave with deltaLogDp
					wave CombOptDistrDlogDp=$currPrefix+ksSP2pbpOptDistrDlogDp			
					note /K CombOptDistrDlogDp
					note CombOptDistrDlogDp, "widths \"dlogDp\" of size bins of number size distribution of scattering particles;"
					CombOptDistrDlogDp=log(CombOptDistrDiamBdr[p+1])-log(CombOptDistrDiamBdr[p])		//calculate dLogDp
					CombOptNumbDistr/=CombOptDistrDlogDp												//normalise with deltaLogD
					CombOptNumbDistr=CombOptNumbDistr/TotSampleVolume*1e-6							//unit conversion factor: 1/m => 1/cm
				endif
			endif
		endfor
		
		
	//COMBINING TWO INCANDESCENCE CHANNELS
		//define possible incandescence channels to be combined
		CombineBits=0
		CombineBits+=calcBHNH*kSP2chanbitBHNH
		CombineBits+=calcBHNL*kSP2chanbitBHNL
		CombineBits+=calcBHBL*kSP2chanbitBHBL
		CombineBits+=calcBLNL*kSP2chanbitBLNL
		combchanlist=SP2_ChanListCombIncandOnly()
		nchans=itemsinlist(combchanlist)
		//loop over all incandescence channel pairs and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix etc.
			currPrefix=stringfromlist(chanind,combchanlist)
			currPrefixOne=stringfromlist(chanind,SP2_ChanListCombIncandLowMass())
			currPrefixTwo=stringfromlist(chanind,SP2_ChanListCombIncandHighMass())
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 0)
			currCutOne=SP2chanPrefix2chanProperty(currPrefixOne, 1)
			MaxSigOne=SP2chanPrefix2chanProperty(currPrefixOne, 2)
			DescriptOne=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixOne),";")
			DescriptTwo=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixTwo),";")
			DescriptCombined=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefix),";")
			//proceed only if current combination is selected on toolkit panel
			if (currEventBit & CombineBits)
				//access peak analysis and derived waves
				setdatafolder $pbpfldrfp
				wave /Z IncBCmassOne=$currPrefixOne+ksSP2pbpBCmass
				wave /Z IncBCmassTwo=$currPrefixTwo+ksSP2pbpBCmass
				wave /Z IncBCdiamOne=$currPrefixOne+ksSP2pbpBCdiam
				wave /Z IncBCdiamTwo=$currPrefixTwo+ksSP2pbpBCdiam
				wave /Z IncOffsetOne=$currPrefixOne+ksSP2PBPtracefitOffset
				wave /Z IncOneSaturated=$currPrefixOne+ksSP2PBPsaturated
				wave /Z IncTwoSaturated=$currPrefixTwo+ksSP2PBPsaturated
				//process data of current channel if available
				if ( waveexists(IncBCmassOne) && waveexists(IncBCmassTwo) && waveexists(IncOffsetOne) )		//proceed only if data are available
					//access calibration coefficients
					setdatafolder $calibfldrfp
					wave CalCoefOneExpanded=$currPrefixOne+ksSP2CalCoefBnam
					wave CalCoefTwoExpanded=$currPrefixTwo+ksSP2CalCoefBnam
					nSplineSegmentsOne=SP2_calibCurveSplineCheck(CalCoefOneExpanded)
					nSplineSegmentsTwo=SP2_calibCurveSplineCheck(CalCoefTwoExpanded)
					//baseline and saturation amplitude
					MeanBaseLineOne=MeanNaN(IncOffsetOne)
					logSatDiamOne=log(SP2peakHt2BCdiam(MaxSigOne-MeanBaseLineOne, CalCoefOneExpanded, DensityOfBC[0], nSplineSegmentsOne))
					//saturated
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2PBPsaturated=IncOneSaturated && IncTwoSaturated
					wave saturated=$currPrefix+ksSP2PBPsaturated
					note saturated, "Saturation of "+DescriptCombined+" detector:"
					note saturated, "0: not saturated;"
					note saturated, "1: saturated;"
					//lower cut-off diamter
					setdatafolder $pbpfldrfp
					make /o/n=1 	$currPrefix+ksSP2pbpDiamCutLow=SP2peakHt2BCdiam(currCutOne, CalCoefOneExpanded, DensityOfBC, nSplineSegmentsOne)
					wave CombDiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
					note CombDiamCutLow, "Lower cut-off diameter of combined "+DescriptOne+" and "+DescriptTwo+" data;"
					note CombDiamCutLow, "BC density: "+num2str(DensityOfBC[0])+";"
					note CombDiamCutLow, "calibration: "+getwavesdatafolder(CalCoefOneExpanded,0)+";"
					//mass
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2pbpBCmass
					wave CombBCmass=$currPrefix+ksSP2pbpBCmass
					note CombBCmass, "mass of individual BC particles [fg];"
					note CombBCmass, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCmass= IncOneSaturated[p] && numtype(IncBCmassTwo[p])==0 ? IncBCmassTwo[p] : IncBCmassOne[p]
					//diameter
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2pbpBCdiam
					wave CombBCdiam=$currPrefix+ksSP2pbpBCdiam
					note CombBCdiam, "diameter of individual BC particles [nm], calculated from measured mass assuming density of "+num2str(BCdensity)+" kg/m;"
					note CombBCdiam, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCdiam= IncOneSaturated[p] && numtype(IncBCdiamTwo[p])==0? IncBCdiamTwo[p] : IncBCdiamOne[p]
					//logDiam
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2pbpBClogdiam
					wave CombBClogdiam=$currPrefix+ksSP2pbpBClogdiam
					note CombBClogdiam, "logarithm of diameter of individual BC particles;"
					note CombBClogdiam, "see note of wave "+NameOfWave(CombBCdiam)+" for details on the diameter calculation;"
					note CombBClogdiam, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBClogdiam=log(CombBCdiam)
					if (kSP2pbpStitchIncMirrorMode)
						CombBClogdiam=  IncOneSaturated[p] && (CombBClogdiam[p]<logSatDiamOne) ? 2*logSatDiamOne-CombBClogdiam[p] : CombBClogdiam[p]				
					endif
					//total mass
					make /o/n=(1) $currPrefix+ksSP2pbpBCtotalmass
					wave CombBCtotalmass=$currPrefix+ksSP2pbpBCtotalmass
					note CombBCtotalmass, "total mass of BC particles with peak height above threshold [fg];"
					note CombBCtotalmass, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCtotalmass=SumNaN(CombBCmass)		//CombBCmass already filtered
					make /o/n=(1) $currPrefix+ksSP2pbpBCtotalmassconc
					wave CombBCtotalmassconc=$currPrefix+ksSP2pbpBCtotalmassconc
					note CombBCtotalmassconc, "mass concentration of BC particles with peak height above threshold [g/m];"
					note CombBCtotalmassconc, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCtotalmassconc=CombBCtotalmass/TotSampleVolume*1e-9					//unit conversion factor: fg/m => g/m																					
					//number size distribution
					setdatafolder $pbpfldrfp
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCnumbdistr
					wave CombBCnumbdistr=$currPrefix+ksSP2pbpBCnumbdistr						//wave for dN/dlogDp
					note CombBCnumbdistr, "number size distribution of BC cores: dN/dlogDp [#/cm];"
					note CombBCnumbdistr, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					if (nTriggers > 1) // jcc added 150930
						Histogram/N/C/B=1 CombBClogdiam,CombBCnumbdistr										//histogram of logDp values as first step towards dN/dlogDp
						if (treatSaturatedAsNaN)
							CombBCnumbdistr[nHistoBins-1]=nan
						endif 
					endif
					duplicate /o CombBCnumbdistr, $currPrefix+ksSP2pbpBCdistrDiamMid				//wave for midpoint diameters
					wave CombBCDistrDiamMidpt=$currPrefix+ksSP2pbpBCdistrDiamMid							
					note /K CombBCDistrDiamMidpt
					note CombBCDistrDiamMidpt, "midpoint diameters [nm] of BC core number and mass size distributions;"
					note CombBCDistrDiamMidpt, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					ScaleToWav(CombBCnumbdistr, CombBCDistrDiamMidpt, 0)								//get diameter scale
					CombBCDistrDiamMidpt=10^CombBCDistrDiamMidpt										//get diameter scale (histogram was done on logDp
					duplicate /o CombBCnumbdistr, $currPrefix+ksSP2pbpBCDistrDiamBdr				//wave for boundary diameters
					wave CombBCDistrDiamBdr=$currPrefix+ksSP2pbpBCDistrDiamBdr								
					note /K CombBCDistrDiamBdr
					note CombBCDistrDiamBdr, "bin boundary diameters [nm] of BC core number and mass size distributions;"
					note CombBCDistrDiamBdr, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					BinCentresToBoundariesLog(CombBCDistrDiamMidpt, CombBCDistrDiamBdr)				//boundary diameters
					duplicate /o CombBCnumbdistr, $currPrefix+ksSP2pbpBCDistrDlogDp				//wave with deltaLogDp
					wave CombBCDistrDlogDp=$currPrefix+ksSP2pbpBCDistrDlogDp											
					note /K CombBCDistrDlogDp
					note CombBCDistrDlogDp, "widths \"dlogDp\" of size bins of BC core number and mass size distributions;"
					note CombBCDistrDlogDp, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCDistrDlogDp=log(CombBCDistrDiamBdr[p+1])-log(CombBCDistrDiamBdr[p])			//calculate dLogDp
					CombBCnumbdistr/=CombBCDistrDlogDp												//normalise with deltaLogD
					CombBCnumbdistr=CombBCnumbdistr/TotSampleVolume*1e-6					//unit conversion factor: 1/m => 1/cm
					//mass size distribution
					duplicate /o CombBCnumbdistr, $currPrefix+ksSP2pbpBCmassdistr					//wave for dM/dlogDp
					wave CombBCmassdistr=$currPrefix+ksSP2pbpBCmassdistr
					note /K CombBCmassdistr
					note CombBCmassdistr, "mass size distribution of BC cores: dM/dlogDp [g/m];"
					note CombBCmassdistr, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					CombBCmassdistr=CombBCnumbdistr*pi/6*CombBCDistrDiamMidpt^3*DensityOfBC*1e-12		//unit conversion factor: nm/cm*kg => g

					// UNCERTAINTIES [added in v4111 by jcc]
						wave IncBCnumbdistr= CombBCnumbdistr // why should these have difft names in combined code? The whole thing shuold be a separate function...
						wave IncBCmassdistr= CombBCmassdistr
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCnumbdistr+ksSP2errSuffix /WAVE=IncBCnumbdistr_err 
					note IncBCnumbdistr_err, "Poisson-based uncertainty [#/cm] corresponding to "+currPrefix+ksSP2pbpBCnumbdistr+";"
					note IncBCnumbdistr_err, "\rSample-volume uncertainty taken as "+num2str(kSP2_sampleVolumeFracErr*100)+"%;"
					IncBCnumbdistr_err= max(1,W_SqrtN) // Igor puts zero uncertainty for zero counts--Poisson says 1
					IncBCnumbdistr_err=IncBCnumbdistr*sqrt((1/IncBCnumbdistr_err)^2 + kSP2_sampleVolumeFracErr^2) // (dX/X)^2 = (dN/N)^2 + (dV/V)^2 = (1/sqrt(N))^2 + (dV/V)^2
					
					make /o/n=(nHistoBins) $currPrefix+ksSP2pbpBCmassdistr+ksSP2errSuffix /WAVE=IncBCmassdistr_err 
					note IncBCmassdistr_err, "Poisson-based uncertainty [#/cm] corresponding to "+currPrefix+ksSP2pbpBCmassdistr+";"
					note IncBCmassdistr_err, "\rSample-volume uncertainty taken as "+num2str(kSP2_sampleVolumeFracErr*100)+"%;"
					note IncBCmassdistr_err, "\rrBC core diameter uncertainty taken as "+num2str(kSP2_relErrDiam*100)+"%;"
					note IncBCmassdistr_err, "\rBC density uncertainty taken as "+num2str(kSP2_relErrDensity*100)+"%;"
					IncBCmassdistr_err=IncBCmassdistr*sqrt((IncBCnumbdistr_err/IncBCnumbdistr)^2 + 3*(kSP2_relErrDiam)^2 + kSP2_relErrDensity^2)  // same formula as for dNdlogDp
				endif
			endif
		endfor
		
		
	//COMBINING TWO PSD (SPLIT DETECTOR) CHANNELS
		//define possible scattering channels to be combined
		CombineBits=0
		CombineBits+=calcPHPL*kSP2chanbitPHPL
		combchanlist=SP2_ChanListCombPSDonly()
		nchans=itemsinlist(combchanlist)
		//loop over all PSD channel pairs and analyse
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix etc.
			currPrefix=stringfromlist(chanind,combchanlist)
			currPrefixOne=stringfromlist(chanind,SP2_ChanListCombPSDlowGain())
			currPrefixTwo=stringfromlist(chanind,SP2_ChanListCombPSDhighGain())
			currEventBit=SP2chanPrefix2chanProperty(currPrefix, 0)
			currEventBitOne=SP2chanPrefix2chanProperty(currPrefixOne, 0)
			currCutOne=SP2chanPrefix2chanProperty(currPrefixOne, 1)
			MaxSigOne=SP2chanPrefix2chanProperty(currPrefixOne, 2)
			DescriptOne=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixOne),";")
			DescriptTwo=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefixTwo),";")
			DescriptCombined=ChopLastCharacterOff(SP2_ChanListToDescrLongList(currPrefix),";")
			//proceed only if current combination is selected on toolkit panel
			if (currEventBit & CombineBits)	
				//access peak analysis and derived waves
				setdatafolder $pbpfldrfp
				wave /Z FilteredCentreSplitPosOne=$currPrefixOne+ksSP2PBPsplitFilteredSplitPos		
				wave /Z FilteredCentreSplitPosTwo=$currPrefixTwo+ksSP2PBPsplitFilteredSplitPos		
				wave /Z PSDoneSaturated=$currPrefixOne+ksSP2PBPsaturated
				wave /Z PSDtwoSaturated=$currPrefixTwo+ksSP2PBPsaturated
				//process data of current channel if available
				if ( waveexists(FilteredCentreSplitPosOne) && waveexists(FilteredCentreSplitPosTwo) && waveexists(PSDoneSaturated) && waveexists(PSDtwoSaturated))		//proceed only if data are available
					//saturated
					setdatafolder $pbpfldrfp
					make /o/n=(nTriggers) $currPrefix+ksSP2PBPsaturated=PSDoneSaturated && PSDtwoSaturated
					wave saturated=$currPrefix+ksSP2PBPsaturated
					note saturated, "Saturation of "+DescriptCombined+" detector:"
					note saturated, "0: not saturated;"
					note saturated, "1: saturated;"
					//centre split position
					make /o/n=(nTriggers) $currPrefix+ksSP2PBPsplitFilteredSplitPos=NaN
					wave CombFilteredCentreSplitPos=$currPrefix+ksSP2PBPsplitFilteredSplitPos		
					note CombFilteredCentreSplitPos, "split point filtered by the peak height threshold and bad data mask according to the wave \""+nameofwave(Classification)+"\";"
					note CombFilteredCentreSplitPos, "data taken from "+DescriptOne+" and "+DescriptTwo+" channels;"
					//this stuff needs to be replaced by filtered split positions!
					CombFilteredCentreSplitPos= PSDoneSaturated[p] && numtype(FilteredCentreSplitPosTwo[p])==0 ? FilteredCentreSplitPosTwo[p] : FilteredCentreSplitPosOne[p]					
				endif
			endif
		endfor
		
		//access waves for bandratio
		setdatafolder $pbpfldrfp
		//high gain
		wave /Z BBHGpeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
		wave /Z NBHGpeakHt=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakHt
		wave /Z BBHGsaturated=$ksSP2BBHGprefix+ksSP2PBPsaturated
		wave /Z NBHGsaturated=$ksSP2NBHGprefix+ksSP2PBPsaturated
		wave /Z BandRatioHGavg=$ksSP2pbpBCbandratHGAvg				//filtered data		
		wave /Z BandRatioHGavgAll=$ksSP2pbpBCbandratHGAvgAll			//all data unfiltered			
		//low gain	
		wave /Z BBLGpeakHt=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHt
		wave /Z NBLGpeakHt=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakHt
		wave /Z BBLGsaturated=$ksSP2BBLGprefix+ksSP2PBPsaturated
		wave /Z NBLGsaturated=$ksSP2NBLGprefix+ksSP2PBPsaturated
		wave /Z BandRatioLGavg=$ksSP2pbpBCbandratLGAvg				//filtered data		
		wave /Z BandRatioLGavgAll=$ksSP2pbpBCbandratLGAvgAll			//all data unfiltered			
		
		
	//BandRatio from peak heights
		//high gain
		if (waveexists(BBHGpeakHt) && waveexists(NBHGpeakHt) && waveexists(BBHGsaturated) && waveexists(NBHGsaturated))
			//proceed only if data are available
			setdatafolder $pbpfldrfp
			//individual particles
			make /o/n=(nTriggers) $ksSP2pbpBCbandratHG=NaN			
			wave BandRatHG=$ksSP2pbpBCbandratHG
			note BandRatHG, "ratio [-] of high gain broadband to high gain narrowband peak height of individual particles;"
			BandRatHG=BBHGpeakHt/NBHGpeakHt
			//filter saturated particles
			BandRatHG=  BBHGsaturated==0 && NBHGsaturated==0 ?  BandRatHG : NaN
			//apply bad data mask via classification wave
			BandRatHG= numtype(Classification[p])==2 ? NaN : BandRatHG																				
		endif
		//low gain
		if (waveexists(BBLGpeakHt) && waveexists(NBLGpeakHt) && waveexists(BBLGsaturated) && waveexists(NBLGsaturated))
			//proceed only if data are available
			setdatafolder $pbpfldrfp
			//individual particles
			make /o/n=(nTriggers) $ksSP2pbpBCbandratLG=NaN			
			wave BandRatLG=$ksSP2pbpBCbandratLG
			note BandRatLG, "ratio [-] of low gain broadband to low gain narrow band peak height of individual particles;"
			BandRatLG=BBLGpeakHt/NBLGpeakHt
			//filter saturated particles
			BandRatLG=  BBLGsaturated==0 && NBLGsaturated==0 ?  BandRatLG : NaN		//filter saturated particles!
			//apply bad data mask via classification wave
			BandRatLG= numtype(Classification[p])==2 ? NaN : BandRatLG																			
		endif
	//BandRatio from peak areas
		//high gain
		if ( (waveexists(BandRatioHGavg) || waveexists(BandRatioHGavgAll)) && waveexists(BBHGsaturated) && waveexists(NBHGsaturated) )
			//proceed only if data are available
			if  (!waveexists(BandRatioHGavgAll))
				//update data format for newer toolkit versions if needed
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $ksSP2pbpBCbandratHGAvgAll=BandRatioHGavg[p]		//BandRatioHGavg contained all unfiltered data in earlier versions
				wave BandRatioHGavgAll=$ksSP2pbpBCbandratHGAvgAll			
				note BandRatioHGavgAll, "band ratio (broadband : narrowband);"
				note BandRatioHGavgAll, "ratio of peak area between half-rise and half-decay position of broadband signal;"
				note BandRatioHGavgAll, "this wave contains all unfiltered data;"
			endif	
			//create wave for filtered bandratio data
			setdatafolder $pbpfldrfp
			make /o/n=(nTriggers) $ksSP2pbpBCbandratHGAvg=BandRatioHGavgAll		//restore all unfiltered data
			wave BandRatioHGavg=$ksSP2pbpBCbandratHGAvg
			note BandRatioHGavg, "band ratio (broadband : narrowband);"
			note BandRatioHGavg, "ratio of peak area between half-rise and half-decay position of broadband signal;"
			note BandRatioHGavg, "these data have been filtered by bad data mask;"
			//filter saturated particles
			BandRatioHGavg=  BBHGsaturated==0 && NBHGsaturated==0 ?  BandRatioHGavg : NaN
			//apply bad data mask via classification wave
			BandRatioHGavg= numtype(Classification[p])==2 ? NaN : BandRatioHGavg																				
		endif
		//low gain
		if ( (waveexists(BandRatioLGavg) || waveexists(BandRatioLGavgAll))  && waveexists(BBLGsaturated) && waveexists(NBLGsaturated) )
			//proceed only if data are available
			if  (!waveexists(BandRatioLGavgAll))
				//update data format for newer toolkit versions if needed
				setdatafolder $pbpfldrfp
				make /o/n=(nTriggers) $ksSP2pbpBCbandratLGAvgAll=BandRatioLGavg[p]		//BandRatioLGavg contained all unfiltered data in earlier versions
				wave BandRatioLGavgAll=$ksSP2pbpBCbandratLGAvgAll			
				note BandRatioLGavgAll, "band ratio (broadband : narrowband);"
				note BandRatioLGavgAll, "ratio of peak area between half-rise and half-decay position of broadband signal;"
				note BandRatioLGavgAll, "this wave contains all unfiltered data;"
			endif	
			//create wave for filtered bandratio data
			setdatafolder $pbpfldrfp
			make /o/n=(nTriggers) $ksSP2pbpBCbandratLGAvg=BandRatioLGavgAll		//restore all unfiltered data
			wave BandRatioLGavg=$ksSP2pbpBCbandratLGAvg
			note BandRatioLGavg, "band ratio (broadband : narrowband);"
			note BandRatioLGavg, "ratio of peak area between half-rise and half-decay position of broadband signal;"
			note BandRatioLGavg, "these data have been filtered by bad data mask;"
			//filter saturated particles
			BandRatioLGavg=  BBLGsaturated==0 && NBLGsaturated==0 ?  BandRatioLGavg : NaN
			//apply bad data mask via classification wave
			BandRatioLGavg= numtype(Classification[p])==2 ? NaN : BandRatioLGavg																				
		endif	
	//time delay scattering to incandescence peak (high gain)
	setdatafolder $pbpfldrfp
	wave /Z BBHGpeakPos=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakPos			
	wave /Z SCHGgaussPeakPos=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakPos				
	wave /Z SCHGmaxPos=$ksSP2SCHGprefix+ksSP2PBPscattMaxPos
	wave /Z SCHGmaxB4incPos=$ksSP2SCHGprefix+ksSP2PBPscattMaxB4incPos
	variable SCGHBBHGevent=kSP2BBHGeventBitVal+kSP2SCHGeventBitVal
	if (waveexists(BBHGpeakPos) && waveexists(SCHGgaussPeakPos))
		setdatafolder $pbpfldrfp
		make /o/n=(nTriggers) $ksSP2PBPdelaytimeS2B			
		wave DelayTimeScatt2Broad=$ksSP2PBPdelaytimeS2B
		note DelayTimeScatt2Broad, "time difference [s] between high gain scattering (position according to standard trace analysis) and high gain broadband incandescence peaks;"
		DelayTimeScatt2Broad= (Classification[p] & SCGHBBHGevent)==SCGHBBHGevent ?  (BBHGpeakPos[p]-SCHGgaussPeakPos[p])/SamplingRateRawDataMHz : NaN
	endif
	setdatafolder $pbpfldrfp
	make /o/n=(nTriggers) $ksSP2PBPdelaytimeMaxS2B=NaN			
	wave DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B
	if (kSP2PBPdelaySCHG2BBHGmode==0)
		//use global maximum of scattering peak
		if (waveexists(BBHGpeakPos) && waveexists(SCHGmaxPos))		//added by Marie
			note DelayTimeScattMax2Broad, "time difference [s] between high gain scattering and high gain broadband incandescence peaks;"
			note DelayTimeScattMax2Broad, "Note: the measured global maximum of the scattering trace is used for the position of the scattering peak (not the global maximum returned by the standard scattering signal analysis, which may be different in case of Gaussian fitting);"
			DelayTimeScattMax2Broad=Classification[p] & (kSP2BBHGeventBitVal+kSP2SCHGeventBitVal) ?  (BBHGpeakPos[p]-SCHGmaxPos[p])/SamplingRateRawDataMHz : NaN
		endif
	elseif (kSP2PBPdelaySCHG2BBHGmode==1)
		//use maximum of scattering peak before half decay of incandescence peak
		if (waveexists(BBHGpeakPos) && waveexists(SCHGmaxB4incPos))
			note DelayTimeScattMax2Broad, "time difference [s] between high gain scattering and high gain broadband incandescence peaks;"
			note DelayTimeScattMax2Broad, "Note: the measured maximum of the scattering trace before the half decay of the incandescence peak is used for the position of the scattering peak (not the global maximum returned by the standard scattering signal analysis);"
			DelayTimeScattMax2Broad= (Classification[p] & SCGHBBHGevent)==SCGHBBHGevent ?  (BBHGpeakPos[p]-SCHGmaxB4incPos[p])/SamplingRateRawDataMHz : NaN
		endif
	endif
	//fit lognormal size distributions
	if (FitLogNorm)
		//note: panel settings are used for the diameter range considered in the fit!
		SP2_LogNormFitButt("", pbpfldrfp=pbpfldrfp, showgraphs=0)
	endif
	if (GraphMode)
		SP2graph_NumbSizeDistrBC(pbpfldrfp=pbpfldrfp)
		SP2graph_NumbSizeDistrScatt(pbpfldrfp=pbpfldrfp)
		SP2graph_MassSizeDistrBC(pbpfldrfp=pbpfldrfp)
	endif
	//extract concentration time series
	if (ExtractConcTser)
		SP2_ConcTimeSeriesExtractor("", pbpfldrfp=pbpfldrfp, GraphMode=GraphMode)
	endif
	//extract size distribution with applied lower cut-off diameter
	if (ExtractSDtser)
		SP2_SizeDistTimeSeriesExtractor("", pbpfldrfp=pbpfldrfp, FitLogNorm=FitLogNorm, MakeGraph=GraphMode)
	endif
	//LEO fit preparation (needs to be repeated in order to apply the most recent data mask and signal thresholds)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(ChopLastCharacterOff(pbpfldrfp,":"))
	string LeoBeamAndCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	if (datafolderexists(LeoBeamAndCalibSubFldrFP))		//update only if LEO-fit data are available
		setdatafolder $LeoBeamAndCalibSubFldrFP
		SVAR /Z LEOfitPrepInfoStr=$ksSP2LEOfitPrepInfoStr
		wave /Z LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt			
		if (waveExists(LEOsplit2centreDelta))		//update only if LEO-fit data are available
			if (SVAR_Exists(LEOfitPrepInfoStr))
				//get prefixes from info string
				string SCprefix=StringByKey(ksSP2LEOfitPrepSCprefixKey, LEOfitPrepInfoStr,"=","\r")
				string SPprefix=StringByKey(ksSP2LEOfitPrepSPprefixKey, LEOfitPrepInfoStr,"=","\r")
			else
				//missing info string (legacy code) => use old standard settings
				SCprefix=ksSP2SCHGprefix
				SPprefix=ksSP2SPHGprefix
			endif
			SP2_LEOfitPreparation("",pbpfldrfp=pbpfldrfp, BeamShapeMode=0, GaussShapeMode=0, GraphMode=0, SCprefix=SCprefix, SPprefix=SPprefix)
		endif
	endif
	//post processing of LEO-fit results
	if (LEOfitPostProcModeCB)
		SP2_LEOverificationAndSizing("", pbpfldrfp=pbpfldrfp, MainPostProcMode=1, PrintInfo=PrintInfo, GraphMode=GraphMode)
	endif
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "%s finished at %s after %.2f seconds.\r", GetRTStackInfo(1), now(), elapsed/1e6
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end




Function SP2_traceAnalysisMatrices(pbpfldrfp [, ChannelBits])
	//This function collects incandescence peak analysis results and puts them into a pair of X/Y matrices,
	//which can be used to check the quality of the fit against the raw data. 
	//note: As of now this function works on the current data folder.
	//martin.gysel@psi.ch; 10/10/2008,  12/11/2008, 06/10/2009, 27/04/2010, 12/05/2011
	string pbpfldrfp		//full path to folder containing the PBP data
	variable ChannelBits	//bitwise parameter determining which data channels are to be analysed
						//bit0=1 true: analyse high gain scattering channel
						//bit1=2 true: analyse high gain broadband incandescence channel
						//bit2=4 true: analyse high gain narrowband incandescence channel
						//bit3=8 true: analyse high gain split detector channel
						//bit4=16 true: analyse low gain scattering channel
						//bit5=32 true: analyse low gain broadband incandescence channel
						//bit6=64 true: analyse low gain narrowband incandescence channel
						//bit7=128 true: analyse low gain split detector channel
						//default: use panel settings
						
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string inifldrfp=SP2_RawFldrFP2iniFldrFP(rawfldrfp)
	CreateFoldersOfFullPath(pbpfldrfp, 0)		//make sure that this folder exists
	//set defaults
	if (paramisdefault(channelbits))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar fitSCHG=$ksSP2fitSCHGchan
		Nvar fitBBHG=$ksSP2fitBBHGchan
		Nvar fitNBHG=$ksSP2fitNBHGchan
		Nvar fitSPHG=$ksSP2fitSPHGchan		
		Nvar fitSCLG=$ksSP2fitSCLGchan
		Nvar fitBBLG=$ksSP2fitBBLGchan
		Nvar fitNBLG=$ksSP2fitNBLGchan
		Nvar fitSPLG=$ksSP2fitSPLGchan		
		channelbits=fitSCHG*kSP2chanbitSCHG+fitBBHG*kSP2chanbitBBHG+fitNBHG*kSP2chanbitNBHG+fitSPHG*kSP2chanbitSPHG
		channelbits+=fitSCLG*kSP2chanbitSCLG+fitBBLG*kSP2chanbitBBLG+fitNBLG*kSP2chanbitNBLG+fitSPLG*kSP2chanbitSPLG
	endif
	//get trace length from configuration file
	setdatafolder $inifldrfp
	wave NumberOfPoints=$ksSP2configNumberOfPoints
	variable nTracePts=NumberOfPoints[0]
	variable nPts, FromBasicFit
	string ChanPrefix
	//high gain scattering channel
	if (channelbits&kSP2chanbitSCHG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2SCHGprefix+ksSP2PBPscattGaussoffset					
		wave /Z PeakHt=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakHeight			
		wave /Z PeakPos=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakPos		
		wave /Z PeakFWHM=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakFWHM		
		wave /Z PeakStart=$ksSP2SCHGprefix+ksSP2PBPtracefitPeakStart
		wave /Z PeakEnd=$ksSP2SCHGprefix+ksSP2PBPtracefitPeakEnd
		wave /Z PeakHalfRise=$ksSP2SCHGprefix+ksSP2PBPtracefitPeakHalfRise
		wave /Z PeakHalfDecay=$ksSP2SCHGprefix+ksSP2PBPtracefitPeakHalfDecay
		FromBasicFit=waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay)
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakPos) && waveexists(PeakFWHM) )
			//trace analysis waves of scattering channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsscatt) $ksSP2SCHGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2SCHGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsscatt) $ksSP2SCHGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2SCHGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][3]=PeakPos[p]
				FitMatX[][6]=nTracePts-1
				if (FromBasicFit)
					FitMatX[][1]=PeakStart[p]	
					FitMatX[][2]=PeakHalfRise[p]
					FitMatX[][4]=PeakHalfDecay[p]
					FitMatX[][5]=PeakEnd[p]
				else
					FitMatX[][1]=PeakPos[p]-0.5*PeakFWHM[p]			//to be improved (TBD)
					FitMatX[][2]=PeakPos[p]-0.5*PeakFWHM[p]
					FitMatX[][4]=PeakPos[p]+0.5*PeakFWHM[p]
					FitMatX[][5]=PeakPos[p]+0.5*PeakFWHM[p]		//to be improved (TBD)				
				endif
		else
			//trace analysis waves of scattering channel are not available
				//create dummy waves if needed
		endif
	endif
	//low gain scattering channel
	if (channelbits&kSP2chanbitSCLG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2SCLGprefix+ksSP2PBPscattGaussoffset					
		wave /Z PeakHt=$ksSP2SCLGprefix+ksSP2PBPscattGausspeakHeight			
		wave /Z PeakPos=$ksSP2SCLGprefix+ksSP2PBPscattGausspeakPos		
		wave /Z PeakFWHM=$ksSP2SCLGprefix+ksSP2PBPscattGausspeakFWHM		
		wave /Z PeakStart=$ksSP2SCLGprefix+ksSP2PBPtracefitPeakStart
		wave /Z PeakEnd=$ksSP2SCLGprefix+ksSP2PBPtracefitPeakEnd
		wave /Z PeakHalfRise=$ksSP2SCLGprefix+ksSP2PBPtracefitPeakHalfRise
		wave /Z PeakHalfDecay=$ksSP2SCLGprefix+ksSP2PBPtracefitPeakHalfDecay
		FromBasicFit=waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay)
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakPos) && waveexists(PeakFWHM) )
			//trace analysis waves of scattering channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsscatt) $ksSP2SCLGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2SCLGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsscatt) $ksSP2SCLGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2SCLGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][3]=PeakPos[p]
				FitMatX[][6]=nTracePts-1
				if (FromBasicFit)
					FitMatX[][1]=PeakStart[p]	
					FitMatX[][2]=PeakHalfRise[p]
					FitMatX[][4]=PeakHalfDecay[p]
					FitMatX[][5]=PeakEnd[p]
				else
					FitMatX[][1]=PeakPos[p]-0.5*PeakFWHM[p]			//to be improved (TBD)
					FitMatX[][2]=PeakPos[p]-0.5*PeakFWHM[p]
					FitMatX[][4]=PeakPos[p]+0.5*PeakFWHM[p]
					FitMatX[][5]=PeakPos[p]+0.5*PeakFWHM[p]		//to be improved (TBD)				
				endif
		else
			//trace analysis waves of scattering channel are not available
				//create dummy waves if needed
		endif
	endif
	//high gain broadband channel
	if (channelbits&kSP2chanbitBBHG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave Offset=$ksSP2BBHGprefix+ksSP2PBPtracefitOffset
		wave PeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
		wave PeakStart=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakStart
		wave PeakEnd=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakEnd
		wave PeakHalfRise=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHalfRise
		wave PeakHalfDecay=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHalfDecay
		wave PeakPos=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakPos	
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay) && waveexists(PeakPos) )
			//trace analysis waves of broadband channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2BBHGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2BBHGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2BBHGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2BBHGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=PeakStart[p]
				FitMatX[][2]=PeakHalfRise[p]
				FitMatX[][3]=PeakPos[p]
				FitMatX[][4]=PeakHalfDecay[p]
				FitMatX[][5]=PeakEnd[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of broadband channel are not available
				//create dummy waves if needed
		endif
	endif
	//low gain broadband channel
	if (channelbits&kSP2chanbitBBLG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2BBLGprefix+ksSP2PBPtracefitOffset
		wave /Z PeakHt=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHt
		wave /Z PeakStart=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakStart
		wave /Z PeakEnd=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakEnd
		wave /Z PeakHalfRise=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHalfRise
		wave /Z PeakHalfDecay=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHalfDecay
		wave /Z PeakPos=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakPos	
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay) && waveexists(PeakPos) )
			//trace analysis waves of broadband channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2BBLGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2BBLGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2BBLGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2BBLGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=PeakStart[p]
				FitMatX[][2]=PeakHalfRise[p]
				FitMatX[][3]=PeakPos[p]
				FitMatX[][4]=PeakHalfDecay[p]
				FitMatX[][5]=PeakEnd[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of broadband channel are not available
				//create dummy waves if needed
		endif
	endif
	//high gain narrowband channel
	if (channelbits&kSP2chanbitNBHG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2NBHGprefix+ksSP2PBPtracefitOffset
		wave /Z PeakHt=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakHt
		wave /Z PeakStart=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakStart
		wave /Z PeakEnd=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakEnd
		wave /Z PeakHalfRise=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakHalfRise
		wave /Z PeakHalfDecay=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakHalfDecay
		wave /Z PeakPos=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakPos	
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay) && waveexists(PeakPos) )
			//trace analysis waves of narrowband channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2NBHGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2NBHGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2NBHGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2NBHGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=PeakStart[p]
				FitMatX[][2]=PeakHalfRise[p]
				FitMatX[][3]=PeakPos[p]
				FitMatX[][4]=PeakHalfDecay[p]
				FitMatX[][5]=PeakEnd[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of narrowband channel are not available
				//create dummy waves if needed
		endif
	endif
	//low gain narrowband channel
	if (channelbits&kSP2chanbitNBLG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2NBLGprefix+ksSP2PBPtracefitOffset
		wave /Z PeakHt=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakHt
		wave /Z PeakStart=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakStart
		wave /Z PeakEnd=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakEnd
		wave /Z PeakHalfRise=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakHalfRise
		wave /Z PeakHalfDecay=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakHalfDecay
		wave /Z PeakPos=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakPos	
		if( waveexists(Offset) && waveexists(PeakHt) && waveexists(PeakStart) && waveexists(PeakEnd) && waveexists(PeakHalfRise) && waveexists(PeakHalfDecay) && waveexists(PeakPos) )
			//trace analysis waves of narrowband channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2NBLGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2NBLGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][3]=Offset[p]+1.0*PeakHt[p]
				FitMatY[][4]=Offset[p]+0.5*PeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtsIncand) $ksSP2NBLGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2NBLGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=PeakStart[p]
				FitMatX[][2]=PeakHalfRise[p]
				FitMatX[][3]=PeakPos[p]
				FitMatX[][4]=PeakHalfDecay[p]
				FitMatX[][5]=PeakEnd[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of narrowband channel are not available
				//create dummy waves if needed
		endif
	endif
	//high gain split detector channel
	if (channelbits&kSP2chanbitSPHG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2SPHGprefix+ksSP2PBPsplitBasicOffset				
		wave /Z NegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
		wave /Z PosPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitPosPeakHt				
		wave /Z NegPeakPos=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakPos			
		wave /Z PosPeakPos=$ksSP2SPHGprefix+ksSP2PBPsplitPosPeakPos			
		wave /Z CentreSplitPos=$ksSP2SPHGprefix+ksSP2PBPsplitCentreSplitPos		
		if( waveexists(Offset) && waveexists(NegPeakHt) && waveexists(PosPeakHt) && waveexists(NegPeakPos) && waveexists(PosPeakPos) && waveexists(CentreSplitPos) )
			//trace analysis waves of split channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtssplit) $ksSP2SPHGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2SPHGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+NegPeakHt[p]
				FitMatY[][3]=Offset[p]
				FitMatY[][4]=Offset[p]+PosPeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtssplit) $ksSP2SPHGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2SPHGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=NegPeakPos[p]
				FitMatX[][2]=NegPeakPos[p]
				FitMatX[][3]=CentreSplitPos[p]
				FitMatX[][4]=PosPeakPos[p]
				FitMatX[][5]=PosPeakPos[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of split channel are not available
				//create dummy waves if needed
		endif
	endif
	//low gain split detector channel
	if (channelbits&kSP2chanbitSPLG)
		//access fit results
		setdatafolder $pbpfldrfp
		wave /Z Offset=$ksSP2SPLGprefix+ksSP2PBPsplitBasicOffset				
		wave /Z NegPeakHt=$ksSP2SPLGprefix+ksSP2PBPsplitNegPeakHt				
		wave /Z PosPeakHt=$ksSP2SPLGprefix+ksSP2PBPsplitPosPeakHt				
		wave /Z NegPeakPos=$ksSP2SPLGprefix+ksSP2PBPsplitNegPeakPos			
		wave /Z PosPeakPos=$ksSP2SPLGprefix+ksSP2PBPsplitPosPeakPos			
		wave /Z CentreSplitPos=$ksSP2SPLGprefix+ksSP2PBPsplitCentreSplitPos		
		if( waveexists(Offset) && waveexists(NegPeakHt) && waveexists(PosPeakHt) && waveexists(NegPeakPos) && waveexists(PosPeakPos) && waveexists(CentreSplitPos) )
			//trace analysis waves of split channel are available => put them into matrix
				//dimensions
				nPts=dimsize(Offset,0)
				//fit Y-matrix
				make /o/n=(nPts,kSP2FitMatnPtssplit) $ksSP2SPLGprefix+ksSP2FitMatY
				wave FitMatY=$ksSP2SPLGprefix+ksSP2FitMatY
				note FitMatY, "matrix for displaying the fit results in the slider graph;"
				FitMatY[][0]=Offset[p]
				FitMatY[][1]=Offset[p]	
				FitMatY[][2]=Offset[p]+NegPeakHt[p]
				FitMatY[][3]=Offset[p]
				FitMatY[][4]=Offset[p]+PosPeakHt[p]
				FitMatY[][5]=Offset[p]	
				FitMatY[][6]=Offset[p]
				//fit X-matrix
				make /o/n=(nPts,kSP2FitMatnPtssplit) $ksSP2SPLGprefix+ksSP2FitMatX
				wave FitMatX=$ksSP2SPLGprefix+ksSP2FitMatX
				note FitMatX, "matrix for displaying the fit results in the slider graph;"
				FitMatX[][0]=0
				FitMatX[][1]=NegPeakPos[p]
				FitMatX[][2]=NegPeakPos[p]
				FitMatX[][3]=CentreSplitPos[p]
				FitMatX[][4]=PosPeakPos[p]
				FitMatX[][5]=PosPeakPos[p]
				FitMatX[][6]=nTracePts-1
		else
			//trace analysis waves of split channel are not available
				//create dummy waves if needed
		endif
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function /S SP2_BinaryDataLoaderOld(rawfilefp, rawfldrfp, Omode [, PrintInfo, loadini, loadHK, FractMode, LoadOutOfEvery, MaxDataRate, ChannelBitsLoad])
	//This procedures loads SP2 raw data.
	//The file parser is based on the procedure "LoadSP2BinaryData()" provided by DMT (PAPI software).
	//return string: string list with the following three entries
	//	first entry:	
	//		"2": file has not been loaded because it could not be opened (e.g. does not exist)
	//		"1": file has not been loaded because it is empty
	//		or full path to the target folder into which the raw data have been loaded, if successful
	//	second entry:
	//		"0": configuration file has not been loaded
	//		"1": configuration file with equal file number has been loaded		
	//		"2": most recent configuration file with with lower file number has been loaded
	//	third entry:
	//		"0": housekeeping file has not been loaded
	//		"1":	housekeeping file with equal file number has been loaded
	//		"2":	most recent housekeeping file with lower file number has been loaded
	//	forth entry:
	//		full path to housekeeping data folder (empty string if no housekeeping data have been loaded)
	//martin.gysel@psi.ch; 14/11/2008, 11/06/2009, 12/07/2009, 15/04/2010, 23/04/2010, 26/04/2010, 10/08/2010, 20/10/2010
	string rawfilefp	//full path to SP2B data file to be loaded
	string rawfldrfp	//full path to folder into which the raw data are loaded
	variable Omode	//1: overwrite existing data
					//0: prompt if the target folder exists already
	variable PrintInfo	//1 (default):	print loading information to history
					//0: 			to not print loading information to history
	variable loadini	//0:			do not load configuration file
					//1:			load configuration file only if one with equal file number as the raw data file exists
					//2 (default):	load most recent configuration file
	variable loadHK	//0			do not load housekeeping file
					//1 (default):	load housekeeping file only if one with equal file number as the raw data file exists
					//2:			load most recent housekeeping file
	variable FractMode		//0 (default):	load fraction of particles according to variable "LoadOutOfEvery"
							//1:			restrict fraction of loaded particles such the the maximum data rate "MaxDataRate" is not exceeded
	variable LoadOutOfEvery	//LoadOutOfEvery=5 means that only 1 out of every 5 triggered particles is loaded
							//default: LoadOutOfEvery=1
	variable MaxDataRate		//restricts the number of loaded particles
							//unit: 1000 particles / hour
							//i.e: MaxDataRate=5, means that only every second particle is loaded from a file which contains 50'000 particles measured in 5 hours (data rate of file = 10 k#/h)
							//default: inf
	variable ChannelBitsLoad	//bitwise parameter determining which data channels are to be loaded (if available)
							//bit0=1 true: load high gain scattering channel
							//bit1=2 true: load high gain broadband incandescence channel
							//bit2=4 true: load high gain narrowband incandescence channel
							//bit3=8 true: load high gain split detector channel
							//bit4=16 true: load low gain scattering channel
							//bit5=32 true: load low gain broadband incandescence channel
							//bit6=64 true: load low gain narrowband incandescence channel
							//bit7=128 true: load low gain split detector channel
							//default: use panel settings
					
	//internal variables
	variable LoadResWaves=0	//0: do not load reserved waves; 1: load reserved waves
	//end of internal variables

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(loadini))
		loadini=2
	endif
	if (paramisdefault(loadHK))
		loadHK=1
	endif
	if (paramisdefault(FractMode))
		FractMode=0
	endif
	if (FractMode!=0 && FractMode!=1)
		setdatafolder $savedDF
		message="The parameter 'FractMode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	if (paramisdefault(LoadOutOfEvery))
		LoadOutOfEvery=1
	endif
	if (paramisdefault(MaxDataRate))
		MaxDataRate=inf
	endif	
	if (paramisdefault(ChannelBitsLoad))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar loadscatt=$ksSP2loadSCHGchan
		Nvar loadbroad=$ksSP2loadBBHGchan
		Nvar loadnarr=$ksSP2loadNBHGchan
		Nvar loadsplit=$ksSP2loadSPHGchan
		Nvar loadSCLG=$ksSP2loadSCLGchan
		Nvar loadBBLG=$ksSP2loadBBLGchan
		Nvar loadNBLG=$ksSP2loadNBLGchan
		Nvar loadSPLG=$ksSP2loadSPLGchan
		ChannelBitsLoad=loadscatt*kSP2chanbitSCHG
		ChannelBitsLoad+=loadbroad*kSP2chanbitBBHG
		ChannelBitsLoad+=loadnarr*kSP2chanbitNBHG
		ChannelBitsLoad+=loadsplit*kSP2chanbitSPHG
		ChannelBitsLoad+=loadSCLG*kSP2chanbitSCLG
		ChannelBitsLoad+=loadBBLG*kSP2chanbitBBLG
		ChannelBitsLoad+=loadNBLG*kSP2chanbitNBLG
		ChannelBitsLoad+=loadSPLG*kSP2chanbitSPLG
	endif
	//list of channel-names to be loaded
	string DAQchanlist=SP2_ChanListAllDAQ()
	variable MaxNumbChans=itemsinlist(DAQchanlist)
	variable cind
	string ChansToBeLoadedList=""
	for (cind=0; cind<MaxNumbChans; cind+=1)
		if ( (2^cind)&ChannelBitsLoad)
			ChansToBeLoadedList+=stringfromlist(cind,DAQchanlist)+";"
		endif
	endfor
	//check whether the target folder exists already
	if (datafolderexists(rawfldrfp) && Omode==0)
		//there is already data in the target folder
		variable oval
		do
			prompt oval, "The target folder exists already. Do you want to overwrite?", popup, "YES;NO"
			doprompt "Overwrite?", oval
			if (V_flag)
				//user pressed cancel button		
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message; print RTStackInfo; abort message			
			endif
			if (oval==0)
				//user wants to overwrite => continue with loading the file
				break
			else
				//user does not want to overwrite => prompt for alternative target folder
				prompt rawfldrfp, "Enter new target folder for the SP2 raw data:"
				doprompt "Target Folder"
				if (V_flag)
					//user pressed cancel button		
					setdatafolder $savedDF
					message="User cancelled the procedure "+currproc+"!"
					print message; print RTStackInfo; abort message
				endif
				//check the target folder exists already
				if (datafolderexists(rawfldrfp))
					//it does exist => prompt user again
					continue
				else
					//data folder does not exist => continue with loading the file
					break
				endif
			endif
		while (1)
	endif
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 rawfilefp
	if (V_isAliasShortcut)
		rawfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 rawfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			rawfilefp=S_aliasPath
		endif
	endif
	string filename=laststringfromlist(rawfilefp,listsepstr=":")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2fileLoader
	string tmpfldrpath=getdatafolder(1)
	//print info to history
	variable timerRefNum
	if (PrintInfo==1)
		printf "Loading "+rawfilefp+" to "+rawfldrfp+"\r"
		timerRefNum=StartMSTimer			
	endif
	//Open selected SP2B binary file
	variable FileRefNum, fileerror=0
	variable inifileloaded
	Open/R/Z FileRefNum as rawfilefp	
	if (V_flag)
		//error occured at opening => finish procedure
		setdatafolder $savedDF
		fileerror=2
		inifileloaded=0
	endif
	//Determine total length of file and check whether it is empty
	FStatus FileRefNum
	variable totalBytes=V_logEOF
	if (totalBytes==0)
		//file is empty => do not load it
		setdatafolder $savedDF
		fileerror=1
		inifileloaded=0
	endif
	if (fileerror==0)		//load and parse configuration file and binary raw data file
		//create folder for SP2 data
		CreateFoldersOfFullPath(rawfldrfp, 0)
		//load configuration file
		string inifilefp=replacestring(ksSP2datafileEnd,rawfilefp,ksSP2iniFileEnd)	  //path to configuration file
		string inifldrfp=SP2_RawFldrFP2iniFldrFP(rawfldrfp)		//path to folder for configuration data
		string inifilenam
		switch (loadini)
			case 0:
				//do not load configuration file
				inifileloaded=0
				inifilenam=""
				break	//leave case structure
			case 1:
				//load configuration file only if one with equal file number as the binary data file exists
				inifileloaded=SP2_LoadConfigFile(inifilefp, inifldrfp, 1)
				inifilenam=LastStringFromList(inifilefp,ListSepStr=":")			//remember name of current configuration file
				break
			case 2:
				//load most recent configuration file
				string inifiledir=RemoveLastItemFromList(inifilefp,ListSepStr=":")		//get path of directory containing the configuration files
				inifilenam=LastStringFromList(inifilefp,ListSepStr=":")			//get name of current configuration file
				variable hind
				for (hind=0; hind<1e4; hind+=1)
					inifileloaded=SP2_LoadConfigFile(inifilefp, inifldrfp, 1)		//try to load configuration file
					if (inifileloaded==1)
						//successfully loaded configuration file
						if (hind>0)
							inifileloaded=2	//set it up to 2 because it has a lower file number than the raw data file	
						endif
						break		//leave loop searching for configuration files
					else
						inifilenam=SP2filenameStepBack(inifilenam)		//step file name one instance back
						inifilefp=inifiledir+inifilenam						//path to previous housekeeping file
						if (strlen(inifilenam)==0)
							//counted back to file x000	=> configuration file is missing
							break	//leave loop searching for configuration files
						endif
					endif
				endfor
				break		//leave case structure
			default:
				//do not load
				inifileloaded=0
				break   //leave case structure
		endswitch
		//prepare names for raw data matrices
			//get list of logged channels
			variable ChannelBitsSaved
			if (inifileloaded==0)
				//no configuration file loaded => assume that all channels were saved
				ChannelBitsSaved=2^4-1
			else
				//get information on logged channels from configuration file
				setdatafolder $inifldrfp
				wave Channel1=$ksSP2configChannel1	
				wave Channel2=$ksSP2configChannel2
				wave Channel3=$ksSP2configChannel3
				ChannelBitsSaved=1+Channel1[0]*2^1+Channel2[0]*2^2+Channel3[0]*2^3	//channel 0 is always active
			endif
			//loop over all possible channels and prepare list of channel names, etc., according to channel configuration
			variable skipped=0, currbit, loadbits=0
			string channame, chandescript, datamatnamlist="", datamatnotelist=""
			string ChanPrefixList=SP2chanConfig2chanOrder()
			string ChanDescriptList=SP2_ChanListToDescrLongList(ChanPrefixList)
			for (cind=0; cind<4; cind+=1)
				currbit=2^cind
				channame=stringfromlist(cind,ChanPrefixList)
				chandescript=stringfromlist(cind,ChanDescriptList)
				if (ChannelBitsSaved&currbit)
					//current channel active => add to list
					datamatnamlist+=channame+ksSP2rawtracemat+";"
					datamatnotelist+="Raw traces recorded from the "+chandescript+" channel;"
					if ( whichlistitem(channame,ChansToBeLoadedList,";",0,0)>=0 )
						//current channel to be loaded
						loadbits+=currbit				
					endif
				endif
			endfor
		//Load the entire file into a temporary 1D wave as 16-bit signed integer (I16). This file will later be parsed.
		setdatafolder $tmpfldrpath
		Make/O/N=(totalBytes/2)/W tempSP2LoaderWaveI16
		FBinRead /F=2/B=2 FileRefNum, tempSP2LoaderWaveI16	   			//Signed 16 bit, Big Endian.
		//Close the file.
		Close FileRefNum
		//Determine number of rows and columns for all records.	
		variable numCols, numChannels
		numCols = 2^16*tempSP2LoaderWaveI16[0] + tempSP2LoaderWaveI16[1]				//trace length
		numChannels = 2^16*tempSP2LoaderWaveI16[2] + tempSP2LoaderWaveI16[3]			//number of recorded traces;
		//Determine number of records in the file.
		variable RawTracesPointsPerRecord, bytesPerRecord, bytesTraceDataPerRecord, bytesAuxDataPerRecord, bytesSpareDataPerRecord, lastI32Pos, numSpareCols, numRecords
		RawTracesPointsPerRecord = numChannels*numCols
		bytesTraceDataPerRecord=RawTracesPointsPerRecord*2				//trace data recorded as I16
		bytesAuxDataPerRecord=3*4 + 1*2 + 7*4 + 2*8 						//Account for three extra I32's, one U16, 7 single-precision floats, and 2 double-precision floats.
		lastI32Pos=RawTracesPointsPerRecord+(bytesAuxDataPerRecord/2)-1
		numSpareCols = 2^16*tempSP2LoaderWaveI16[lastI32Pos-1] + tempSP2LoaderWaveI16[lastI32Pos]		//Determine if spare 1D array is present.
		numSpareCols=max(0,numSpareCols)			//make sure that it is not negative
		bytesSpareDataPerRecord=numSpareCols*4						//spare data stored as single-precision if present
		bytesPerRecord=bytesTraceDataPerRecord+bytesAuxDataPerRecord+bytesSpareDataPerRecord		//total number of bytes per record			
		numRecords = trunc(totalBytes/bytesPerRecord)				//total number of particles recorded in the file
		//determine fraction of particles to be loaded if the option to limit the maximum data rate was chosen
		if (FractMode==1)
			setdatafolder $tmpfldrpath
			Make/O/W/N=2 FirstTime, LastTime		//single precision
			variable readindex=(0 * bytesPerRecord / 2) + 4 + RawTracesPointsPerRecord
			FirstTime[0] = tempSP2LoaderWaveI16[readindex+2]					//Single-precision time wave.
			FirstTime[1] = tempSP2LoaderWaveI16[readindex+1]
			readindex=( (numRecords-1) * bytesPerRecord / 2) + 4 + RawTracesPointsPerRecord
			LastTime[0] = tempSP2LoaderWaveI16[readindex+2]					//Single-precision time wave.
			LastTime[1] = tempSP2LoaderWaveI16[readindex+1]			
			Redimension /N=(1)/S/E=1 FirstTime, LastTime						//FP32
			variable DataRate=numRecords/(LastTime[0]-FirstTime[0])*3.6	 // jcc added [0] in v412, Igor6 treated this as such.  
			LoadOutOfEvery=round(DataRate/MaxDataRate)
			LoadOutOfEvery=max(1,LoadOutOfEvery)
			if (PrintInfo) // jcc 4111
				
			endif
		endif
		//Create 1-D output waves as I16. They will be redimensioned later to the correct data type.
		setdatafolder $rawfldrfp
		variable totalDataPoints, numLoadRecords
		numLoadRecords=ceil(numRecords/LoadOutOfEvery)			//total number of particles to be loaded
		Make/O/W/N=(numLoadRecords) Flag						//U16				
		Make/O/W/N=(2*numLoadRecords) TimeWave,EventIndex,TimeDiv10000,TimeRemainder		//single precision
		if (LoadResWaves)
			Make/O/W/N=(2*numLoadRecords) Res1,Res5,Res6		//single precision
			Make/O/W/N=(4*numLoadRecords) Res7,Res8			//double precision
		endif
		//create temporary 1-D output wave for all raw data traces
		setdatafolder $tmpfldrpath
		Make/O/W/N=(numLoadRecords*numChannels,numCols) RawTracesWave					//W gives I16 wave.			
		//create temporary 1-D output wave for spare data array (if present)
		if (numSpareCols!=0)												//If spare 1D array is present...
			setdatafolder $tmpfldrpath
			Make/O/W/N=(2*numSpareCols*numLoadRecords) SpareWave	//make wave for that.
		endif
		//Transfer data from binary file wave into I16 1-D waves.
		variable CurrLoadIndex, CurrRecordIndex, CurrRawDataStartIndex, CurrWriteRow, CurrAuxDataStartIndex, CurrSpareDataStartIndex
		variable i
		for(CurrLoadIndex=0; CurrLoadIndex<numLoadRecords; CurrLoadIndex+=1)		//loop over records to be loaded
			//index of current particle in the file
			CurrRecordIndex=LoadOutOfEvery*CurrLoadIndex
			//Skip the two I32's before the data.
			CurrRawDataStartIndex = (CurrRecordIndex * bytesPerRecord / 2) + 4		//start index in file-wave of raw traces data in current record						
			//raw traces
				//2D data array of I16
				CurrWriteRow = CurrLoadIndex * numChannels
				//Note: the trace data are ordered as follows:
				//	1st point of 1st channel, 1st pt of 2nd chan, ..., 2nd pt of 1st chan, 2nd pt of 2nd chan, ...
				RawTracesWave[CurrWriteRow,CurrWriteRow+numChannels-1][0,numCols-1] = tempSP2LoaderWaveI16[CurrRawDataStartIndex+p-CurrWriteRow+numChannels*q]
				CurrAuxDataStartIndex=CurrRawDataStartIndex+RawTracesPointsPerRecord					//start index in file-wave of auxiliary data in current record 
			//auxiliary data
				//U16
				CurrWriteRow= CurrLoadIndex
				Flag[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex]							//U16 flag wave.		
				//single precision
				CurrWriteRow= 2*CurrLoadIndex
				TimeWave[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+2]					//Single-precision time wave.
				TimeWave[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+1]
				EventIndex[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+6]					//Single-precision event index wave.
				EventIndex[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+5]
				TimeDiv10000[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+8]				//Single-precision Time/10000 wave.
				TimeDiv10000[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+7]
				TimeRemainder[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+10]			//Single-precision time remainder wave.
				TimeRemainder[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+9]		
				//reserved waves
				if (LoadResWaves)
					//single precision
					CurrWriteRow= 2*CurrLoadIndex
					Res1[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+4]					//Single-precision reserved wave.
					Res1[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+3]
					Res5[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+12]					//Single-precision reserved wave.
					Res5[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+11]		
					Res6[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+14]					//Single-precision reserved wave.
					Res6[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+13]		
					//double precision
					CurrWriteRow= 4*CurrLoadIndex
					Res7[CurrWriteRow]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+18]					//Double-precision reserved wave.
					Res7[CurrWriteRow+1]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+17]
					Res7[CurrWriteRow+2]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+16]
					Res7[CurrWriteRow+3]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+15]	
					Res8[CurrWriteRow]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+22]					//Double-precision reserved wave.
					Res8[CurrWriteRow+1]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+21]
					Res8[CurrWriteRow+2]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+20]
					Res8[CurrWriteRow+3]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+19]		
				endif
			if (numSpareCols!=0)
				CurrWriteRow = 2*numSpareCols*CurrLoadIndex
				CurrSpareDataStartIndex=CurrAuxDataStartIndex+bytesAuxDataPerRecord/2-4					//start index in file-wave of spare data in current record
				for (i=CurrWriteRow;i<(CurrWriteRow+(2*numSpareCols));i+=1)
					SpareWave[i]=tempSP2LoaderWaveI16[CurrSpareDataStartIndex+i]						//Spare 1D array of single-precision.
				endfor
			endif
		endfor
		//free up memory space
		killwaves /z tempSP2LoaderWaveI16
		//Redimension the auxiliary and spares data waves which were treated as I16 but really contain U16, FP32, or FP64 data.
		//Using the /E=1 flag causes Redimension to merely change how the existing bits in the wave
		//are interpreted rather than doing a conversion from the old data type to the new.
			//auxiliary data waves
			Redimension/N=(numLoadRecords)/U/E=1 Flag									//U16
			Redimension /N=(numLoadRecords)/S/E=1 TimeWave							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 EventIndex							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeDiv10000							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeRemainder						//FP32
			if (LoadResWaves)
				Redimension /N=(numLoadRecords)/S/E=1 Res1								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res5								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res6								//FP32
				Redimension /N=(numLoadRecords)/D/E=1 Res7								//FP64
				Redimension /N=(numLoadRecords)/D/E=1 Res8								//FP64	
			endif
			//spare data waves
			if (numSpareCols!=0)
				Redimension /N=(numSpareCols*numLoadRecords)/S/E=1 SpareWave			//FP32
				setdatafolder $rawfldrfp
				//create array for spare data and copy data from temporary spare wave
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					Make/O/S/N=(numLoadRecords,numSpareCols) SpareDataArray=SpareWave[p*numSpareCols+q]
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			endif
		//Create a matrix for each channel and parse full data matrix into individual channel matrices.
		string currmatnam
		variable chanindex
		for (chanindex=0;chanindex<numChannels;chanindex+=1)		//loop over all saved channels
			if ( (2^chanindex)&loadbits)								//load only selected channels
				currmatnam=stringfromlist(chanindex,datamatnamlist)
				setdatafolder $rawfldrfp
				Make/O/W/N=(numLoadRecords,numCols) $currmatnam		//I16
				Wave RawTraceMat=$currmatnam
				note RawTraceMat, stringfromlist(chanindex,datamatnotelist)
				RawTraceMat=RawTracesWave[chanindex+p*numChannels][q]
			endif
		endfor
		//add further waves to "ini"-subfolder
		if (inifileloaded>0)
			//OneOfEveryLoaded
			setdatafolder $inifldrfp
			wave OneOfEverySaved=$ksSP2configOneOfEverySaved
			make /o/n=(numpnts(OneOfEverySaved)) $ksSP2configOneOfEveryLoaded=LoadOutOfEvery
			wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = 1 means that every recorded particle was loaded;"
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = n means that only one out of n recorded particles was loaded;"
			//SP2B unique file ID
			make /o/n=1/d $ksSP2configUniqueFileIDsp2b=SP2filename2UniqueFileID(filename)
			wave /d UniqueFileIDsp2b=$ksSP2configUniqueFileIDsp2b
			setscale d 0,0,"dat", UniqueFileIDsp2b
			note UniqueFileIDsp2b, "Unique ID of raw data file ("+ksSP2datafileEnd+");"
			note UniqueFileIDsp2b, "Igor time, where the date represents the file data and the seconds since midnight the file number;"			
		endif
		//create time stamp wave
		variable dateval=SP2filename2DateVal(filename)
		setdatafolder $rawfldrfp
		wave TimeWave=$ksSP2timewave
		variable nPts=dimsize(TimeWave,0)
		make /o/n=(nPts)/d $ksSP2TimeDate
		wave TimeDate=$ksSP2TimeDate
		setscale d 0, 0, "dat", TimeDate
		note TimeDate, "TimeStamp"	
		TimeDate=dateval+TimeWave[p]
		//create wave containing the total elapsed measurment time
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedMeas=TimeWave[p]-TimeWave[0]
		wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
		note TimeElapsedMeas, "Total elapsed measurement time [s]."
		note TimeElapsedMeas, "No correction - for saving or loading only a fraction of the total data - has been applied to this wave."
			//clean TimeElapsedMeas for gaps in the measurement
			variable gind, gap
			for (gind=1; gind<nPts; gind+=1)
				gap=TimeElapsedMeas[gind]-TimeElapsedMeas[gind-1]
				if (gap>ksSP2maxGapSec)
					//interpret long time gap between two readings as a break in the measurement
					TimeElapsedMeas[gind,inf]-=gap
				endif
			endfor
		//create wave containing the "effective" elapsed time
		setdatafolder $inifldrfp
		wave OneOfEverySaved=$ksSP2configOneOfEverySaved
		wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedEff=TimeElapsedMeas/OneOfEverySaved/OneOfEveryLoaded
		wave TimeElapsedEff=$ksSP2TimeElapsedEff
		note TimeElapsedEff, "\"effective\" elapsed measurement time [s], corrected for saving or loading only a fraction of the triggered particles."
		//create wave containing file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2rawuniquefileID=SP2filename2UniqueFileID(filename)
		wave FileID=$ksSP2rawuniquefileID
		setscale d 0, 0, "dat", FileID
		note FileID, "This file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing corresponding config file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2correspConfigfileID=SP2filename2UniqueFileID(inifilenam)
		wave ConfigFileID=$ksSP2correspConfigfileID
		setscale d 0, 0, "dat", ConfigFileID
		note ConfigFileID, "This is the unique file ID of the corresponding configuration file;"
		note ConfigFileID, "The file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing particle ID
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2particleID=p*LoadOutOfEvery
		wave ParticleID=$ksSP2particleID		
		note ParticleID, "number of particle within the raw data file;"	
		//create main mask wave
		SP2rawDataMainMaskPrep(rawfldrfp, 1)
	endif
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "Elapsed time: %.2f seconds.\r", elapsed/1e6
	endif
	//load housekeeping file
	variable hkfileloaded
	string hkfilefp=replacestring(ksSP2datafileEnd,rawfilefp,ksSP2hkFileEnd)	//path to housekeeping file
	string hkfldrfp=SP2_RawFldrFP2HKfldrFP(rawfldrfp)						//path to folder for housekeeping data
	switch (loadHK)
		case 0:
			//do not load
			hkfileloaded=0		
			break
		case 1:
			//load housekeeping file only if one with equal file number as the binary data file exists
			hkfileloaded=SP2_LoadHouseKeepingFileFast(hkfilefp, hkfldrfp, 1, PrintInfo)
			break
		case 2:
			//load most recent housekeeping file
			string hkfiledir=RemoveLastItemFromList(hkfilefp,ListSepStr=":")		//get path of directory containing the housekeeping files
			string hkfilenam=LastStringFromList(hkfilefp,ListSepStr=":")			//get name of current housekeeping file
			for (hind=0; hind<1e4; hind+=1)
				hkfileloaded=SP2_LoadHouseKeepingFileFast(hkfilefp, hkfldrfp, 1, PrintInfo)
				if (hkfileloaded==1)
					//file loaded
					if (hind>0)
						hkfileloaded=2		//set it up to 2 because it has a lower file number than the raw data file
					endif
					break	//leave loop searching for housekeeping files
				else
					//file not loaded => step file name back
					hkfilenam=SP2filenameStepBack(hkfilenam)		//step file name one instance back
					hkfilefp=hkfiledir+hkfilenam						//path to previous housekeeping file
					if (strlen(hkfilenam)==0)
						//counted back to file x000	=> housekeeping file is missing
						break	//leave loop searching for housekeeping files
					endif
				endif
			endfor
			break		//leave case structure
		default:
			//do not load
			hkfileloaded=0
			break		//leave case structure
	endswitch
	if (hkfileloaded==0)
		hkfldrfp=""
	endif
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	if (fileerror==0)
		return rawfldrfp+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)+";"+hkfldrfp+";"
	else
		return num2str(fileerror)+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)	+";"+hkfldrfp+";"	
	endif
End



Function SP2batchLoadWavesPrepButt(ctrlname [, BatchFldrFP, nSamples]) : ButtonControl
	//This function prepares the info waves required for batch loading/analysis of ice core data.
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/01/2009;
	string ctrlname		//name of button control; not used
	string BatchFldrFP		//full path to folder in which the load info (and later on the results summary) waves are to be created
						//default: prompt
	variable nSamples	//number of rows for batch load info waves
						//default: prompt
	
	//preparations:
	string savedDF=getdatafolder(1)
	//set defaults
	variable MustPormpt=0
	if (paramisdefault(BatchFldrFP))
		BatchFldrFP="root:IceCores:YYYYMMDD_summary"
		MustPormpt=1
	endif
	if (paramisdefault(nSamples))
		nSamples=1
		MustPormpt=1
	endif
	if (MustPormpt==1)
		prompt BatchFldrFP, "Full path to folder for batch load instructions and summary waves:"
		prompt nSamples, "Number of rows for batch load info waves (number of different samples):"
		doprompt "Target Folder and Number of Samples", BatchFldrFP, nSamples
		if (V_flag)
			setdatafolder $savedDF
			abort "User cancelled procedure!"	
		endif
	endif
	BatchFldrFP=QuoteLiberalPath(BatchFldrFP)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar CETACsampleflow=$ksSP2CETACsampleflow
	Nvar CETACdrainflow=$ksSP2CETACdrainflow
	Nvar CETACpurgeairflow=$ksSP2CETACpurgeairflow
	//create waves for batch loading instructions	
	CreateFoldersOfFullPath(BatchFldrFP, 0)
	setdatafolder $BatchFldrFP
	make /o/t/n=(nSamples) $ksSP2_FileDate="YYYYMMDD"
	wave /t DateStr=$ksSP2_FileDate
	note DateStr, "Date format required: \"YYYYMMDD\""
	make /o/t/n=(nSamples) $ksSP2_FileNumList=""
	wave /t FileListStr=$ksSP2_FileNumList
	note FileListStr, "list format required: e.g. \"1,2,5,7\""
	make /o/t/n=(nSamples) $ksSP2_SampleID=""
	wave /t SampleID=$ksSP2_SampleID
	note SampleID, "Provide any information string about the sample"
	make /o/n=(nSamples) $ksSP2icbatchLiqSampleFlow=CETACsampleflow
	wave LiqSampleFlow=$ksSP2icbatchLiqSampleFlow
	note LiqSampleFlow, "Liquid sample flow fed into the Cetac nebulizer;"
	note LiqSampleFlow, "unit: [ml/min];"
	make /o/n=(nSamples) $ksSP2icbatchLiqDrainFlow=CETACdrainflow
	wave LiqDrainFlow=$ksSP2icbatchLiqDrainFlow
	note LiqDrainFlow, "Liquid drain flow from the vibrating orifice chamber of the Cetac nebulizer;"
	note LiqDrainFlow, "unit: [ml/min];"
	make /o/n=(nSamples) $ksSP2icbatchPurgeAirFlow=CETACpurgeairflow
	wave PurgeAirFlow=$ksSP2icbatchPurgeAirFlow
	note PurgeAirFlow, "Purge air flow into the vibrating orifice chamber of the Cetac nebulizer;"
	note PurgeAirFlow, "unit: [l/min];"
	//create table
	edit/W=(32.25,98.75,633,236) datestr, fileliststr, sampleID, LiqSampleFlow, LiqDrainFlow, PurgeAirFlow
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2batchLoadBtt(ctrlname [, BatchFldrFP, RawDataDir])
	//This function loads and analyses a series of ice core data according to the instructions in the folder "BatchFldrFP".
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/01/2009, 13/08/2010
	string ctrlname		//name of button control; not used
	string BatchFldrFP	//full path to batch load folder containing the batch load instructions
						//default: browse for folder
	string RawDataDir	//full path to directory containing the SP2 raw data to be loaded
						//e.g.: "N:RawData:2008:IceCores:20081103"
						//default: browse for directory
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(BatchFldrFP))
		BatchFldrFP=BrowseForFolder("Select folder containing the batch load instructions:", StartPath=savedDF)
		if (stringmatch(BatchFldrFP,"cancelled"))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	if (paramisdefault(RawDataDir))
		newpath /o/m="Select folder containing the 'SP2B' raw data files."/q NewDataPath
		if (V_flag != 0)												//abort execution if "cancel"-button is pressed
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message
			print RTStackInfo
			abort message
		endif
		PathInfo NewDataPath
		RawDataDir=S_path
		RawDataDir=choplastcharacteroff(RawDataDir, ":")
	endif	
	//access panel variables/strings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar ConcatMode=$ksSP2loadConcatMode
	Nvar TAmode=$ksSP2analyseTraces
	Nvar DelMode=$ksSP2rawdatadelmode
	Nvar PPmode=$ksSP2postProcessing
	//force load/analysis/postprocessing settings
	ConcatMode=1
	TAmode=1
	DelMode=1
	variable DelBits=DelMode*2^16-1
	PPmode=0	//done with extracting data into batch folder
	//access waves containing load instructions
	setdatafolder $BatchFldrFP
	wave /t DateStr=$ksSP2_FileDate
	wave /t FileListStr=$ksSP2_FileNumList
	wave /t SampleID=$ksSP2_SampleID
	variable nSamples=numpnts(DateStr)
	//prepare results summary waves
	setdatafolder $BatchFldrFP
	make /o/n=(nSamples)/t $ksSP2icbatchSP2RawDataFP=""
	wave /t SP2RawDataFP=$ksSP2icbatchSP2RawDataFP
	//loop over all samples
	variable sind
	string FileDateString, FileNumList, currrawfldrfp, currpbpfldrfp
	for (sind=0; sind<nSamples; sind+=1)
		FileDateString=DateStr[sind]
		FileNumList=FileListStr[sind]
		FileNumList=replacestring(",", FileNumList, ";")
		//load and analyse current sample
		currrawfldrfp=SP2_LoadRawData("", RawDataDir=RawDataDir, LoadType=3, FileDateString=FileDateString, FileNumList=FileNumList, ConcatMode=ConcatMode, DelBits=DelBits, TAmode=TAmode, PPmode=PPmode, Omode=1)
		currrawfldrfp=choplastcharacteroff(currrawfldrfp,";")
		SP2RawDataFP[sind]=currrawfldrfp
	endfor
	//extract data to summary waves
	SP2batchLoadExtractSummaryBtt("", BatchFldrFP=BatchFldrFP, PrintInfo=0)
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2batchLoadExtractSummaryBtt(ctrlname [, BatchFldrFP, PrintInfo]) : ButtonControl
	//This function does the post-processing of ice core data and collects all relevant data in the batch load folder "BatchFldrFP"
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/01/2009, 19/11/2009, 22/11/2009, 23/11/2009, 06/05/2010, 07/12/2011
	string ctrlname		//name of button control; not used
	string BatchFldrFP	//full path to batch load folder containing the batch load instructions
						//default: browse for folder
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
		
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(BatchFldrFP))
		BatchFldrFP=BrowseForFolder("Select folder containing the batch load instructions:", StartPath=savedDF)
		if (stringmatch(BatchFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	//access waves in batch load folder
	setdatafolder $BatchFldrFP
	wave /Z /t SP2RawDataFP=$ksSP2icbatchSP2RawDataFP
	wave /t SampleID=$ksSP2_SampleID
	wave LiqSampleFlow=$ksSP2icbatchLiqSampleFlow
	wave LiqDrainFlow=$ksSP2icbatchLiqDrainFlow
	wave PurgeAirFlow=$ksSP2icbatchPurgeAirFlow
	variable nSamples=dimsize(SP2RawDataFP,0)
	if (!waveexists(SP2RawDataFP))
		setdatafolder $savedDF
		message="Error in the function "+currproc+": batch load instructions are not complete!"
		print message;print RTStackInfo;abort message					
	endif
	//access panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		//number of histogram bins
		Nvar nHistoBins=$ksSP2nHistobins
		//calibration data
		Svar CalibFldr=$ksSP2calibFldr
		string calibfldrfp=ksSP2PathToCalibDataFldr+CalibFldr
	//prepare results summary waves
		setdatafolder $BatchFldrFP
		//all channels
		make /o/d/n=(nSamples) TimeDateAvg=NaN
		wave TimeDateAvg
		setscale d 0,0,"dat", TimeDateAvg
		make /o/d/n=(nSamples,1) $ksSP2icbatchConcTserTimeCtr=NaN
		wave /d ConcTimeCtrBatch=$ksSP2icbatchConcTserTimeCtr	
		setscale d 0,0,"dat", ConcTimeCtrBatch
		//various variables and strings
		variable chanind
		string ChanList=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
		variable nchans=itemsinlist(ChanList)
		string currPrefix
		//loop over all incandescence channels
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,ChanList)
			//prepare waves in ice core summary folder
			setdatafolder $BatchFldrFP
			make /o/n=(nSamples) $currPrefix+ksSP2pbpLiquidSampleMassConc=NaN
			make /o/n=(nSamples) $currPrefix+ksSP2pbpLiqSampMassConcBelowCut=NaN
			make /o/n=(nSamples) $currPrefix+ksSP2pbpBCtotalmassconc=NaN
			make /o/n=(nSamples) $currPrefix+ksSP2pbpBCtotalmassconcBelowCut=NaN
			make /o/n=(nSamples,1) $currPrefix+ksSP2pbpBCdistrDiamMid=NaN
			make /o/n=(nSamples,1) $currPrefix+ksSP2pbpBCmassdistr=NaN
			make /o/n=(nSamples,1) $currPrefix+ksSP2pbpLogNormFitDiamMidpt=NaN
			make /o/n=(nSamples,1) $currPrefix+ksSP2pbpLogNormFitMassDistr=NaN
			make /o/n=(nSamples,1) $currPrefix+ksSP2timeSeriesMassConcBnam=NaN
		endfor
		//loop over all samples and copy PBP-data to summary folder
		variable sind
		variable newdim
		string FileDateString, FileNumList, currrawfldrfp, currpbpfldrfp, currconcfldrfp
		for (sind=0; sind<nSamples; sind+=1)
			currrawfldrfp=SP2RawDataFP[sind]
			currpbpfldrfp=SP2_RawFldrFP2PBPfldrFP(currrawfldrfp)
			currconcfldrfp=ChopLastCharacterOff(currpbpfldrfp,":")+ksSP2concTserSubFldrPP
			//standard post processing
			SP2_PBPpostprocessing(pbpfldrfp=currpbpfldrfp, calibfldrfp=calibfldrfp, PrintInfo=PrintInfo, GraphMode=0)		
			//calculate liquid sample concentration
			SP2_CETAC_calc_LiquidConcBtt("", PBPfldrfp=currpbpfldrfp, LiqSampleFlow=LiqSampleFlow[sind], DrainFlow=LiqDrainFlow[sind], PurgeAirFlow=PurgeAirFlow[sind])
			//copy data to summary waves
				//averaged time stamp
				setdatafolder $currrawfldrfp
				wave TimeDate=$ksSP2TimeDate
				TimeDateAvg[sind]=0.5*(TimeDate[0]+TimeDate[inf])
				//copy data that are common to all channels
					//access result waves
					setdatafolder $currconcfldrfp
					wave ConcTimeCtrPBP=$ksSP2timeSeriesTimeCtr
					//copy to summary waves
					newdim=dimsize(ConcTimeCtrPBP,0)
					RedimensionNaNmg(ConcTimeCtrBatch, 1, max(dimsize(ConcTimeCtrBatch,1),newdim))
					ConcTimeCtrBatch[sind][0,newdim-1]=ConcTimeCtrPBP[q]
				//loop over all incandescence channels and copy channel specific data
				for (chanind=0; chanind<nchans; chanind+=1)
					//channel prefix
					currPrefix=stringfromlist(chanind,ChanList)
					//access PBP data of current sample
					setdatafolder $currpbpfldrfp
					wave /Z LiqSampleMassConcPBP=$currPrefix+ksSP2pbpLiquidSampleMassConc
					wave /Z LiqSampMassConcBlwCtPBP=$currPrefix+ksSP2pbpLiqSampMassConcBelowCut
					wave /Z BCmassConcPBP=$currPrefix+ksSP2pbpBCtotalmassconc
					wave /Z BCmassconcBelowCutPBP=$currPrefix+ksSP2pbpBCtotalmassconcBelowCut
					wave /Z BCDistrDiamPBP=$currPrefix+ksSP2pbpBCdistrDiamMid
					wave /Z BCmassdistrPBP=$currPrefix+ksSP2pbpBCmassdistr
					wave /Z LogNormFitDiamMidptPBP=$currPrefix+ksSP2pbpLogNormFitDiamMidpt
					wave /Z LogNormFitMassDistrPBP=$currPrefix+ksSP2pbpLogNormFitMassDistr
					//access concentration time series of current sample
					setdatafolder $currconcfldrfp
					wave ConcTserMassPBP=$currPrefix+ksSP2timeSeriesMassConcBnam
					if (waveexists(LiqSampleMassConcPBP))
						//access summary waves				
						setdatafolder $BatchFldrFP
						wave LiqSampleMassConcBatch=$currPrefix+ksSP2pbpLiquidSampleMassConc
						wave LiqSampMassConcBlwCtBtch=$currPrefix+ksSP2pbpLiqSampMassConcBelowCut
						wave BCmassConcBatch=$currPrefix+ksSP2pbpBCtotalmassconc
						wave BCmassconcBelowCutBatch=$currPrefix+ksSP2pbpBCtotalmassconcBelowCut
						wave BCDistrDiamBatch=$currPrefix+ksSP2pbpBCdistrDiamMid
						wave BCmassdistrBatch=$currPrefix+ksSP2pbpBCmassdistr
						wave LogNormFitDiamMidptBatch=$currPrefix+ksSP2pbpLogNormFitDiamMidpt
						wave LogNormFitMassDistrBatch=$currPrefix+ksSP2pbpLogNormFitMassDistr
						wave ConcTserMassBatch=$currPrefix+ksSP2timeSeriesMassConcBnam
						//copy to summary waves
						LiqSampleMassConcBatch[sind]=LiqSampleMassConcPBP[0]
						LiqSampMassConcBlwCtBtch[sind]=LiqSampMassConcBlwCtPBP[0]
						BCmassConcBatch[sind]=BCmassConcPBP[0]
						BCmassconcBelowCutBatch[sind]=BCmassconcBelowCutPBP[0]
						newdim=dimsize(BCDistrDiamPBP,0)
						RedimensionNaNmg(BCDistrDiamBatch, 1, max(dimsize(BCDistrDiamBatch,1),newdim))
						BCDistrDiamBatch[sind][0,newdim-1]=BCDistrDiamPBP[q]
						newdim=dimsize(BCmassdistrPBP,0)
						RedimensionNaNmg(BCmassdistrBatch, 1, max(dimsize(BCmassdistrBatch,1),newdim))
						BCmassdistrBatch[sind][0,newdim-1]=BCmassdistrPBP[q]
						newdim=dimsize(LogNormFitDiamMidptPBP,0)
						RedimensionNaNmg(LogNormFitDiamMidptBatch, 1, max(dimsize(LogNormFitDiamMidptBatch,1),newdim))
						LogNormFitDiamMidptBatch[sind][0,newdim-1]=LogNormFitDiamMidptPBP[q]
						newdim=dimsize(LogNormFitMassDistrPBP,0)
						RedimensionNaNmg(LogNormFitMassDistrBatch, 1, max(dimsize(LogNormFitMassDistrBatch,1),newdim))
						LogNormFitMassDistrBatch[sind][0,newdim-1]=LogNormFitMassDistrPBP[q]
						newdim=dimsize(ConcTserMassPBP,0)
						RedimensionNaNmg(ConcTserMassBatch, 1, max(dimsize(ConcTserMassBatch,1),newdim))
						ConcTserMassBatch[sind][0,newdim-1]=ConcTserMassPBP[q]
					endif
				endfor
		endfor
//create table
SP2table_IceCoreSummary(SummaryFldrFP=BatchFldrFP)
//create graphs
SP2graph_IceCoreSummarySlider(SummaryFldrFP=BatchFldrFP, Omode=1)
SP2graph_IceCoreSummary(SummaryFldrFP=BatchFldrFP)
//finish procedure
setdatafolder $savedDF
End


Function /C SP2_LogNormSizeDistrFit(dMdlogDp, DpScale [, DmeasMin, DmeasMax, DfullMin, DfullMax, LogNormParam, dYdlogDpFitted, DpScaleFitted, nDistrPts, FitErrorQuit, KillTmpFldr])
	//This function fits a lognormal distribution to a BC mass size distribution
	//in order to determine the total BC mass of the fitted lognormal size distribution and the ratio of 
	//to total mass to the measured mass.
	//Note: This function can also be used to fit the BC number size distribution!
	//Complex return value:
	//	real part: ratio of the area of dM/dlogDp_fit (between DfullMin, DfullMax) to the area of dM/dlogDp_meas (between DmeasMin and DmeasMax)
	//	imaginary part: integrated mass of the fitted lognormal mass size distribution between DfullMin, DfullMax
	//martin.gysel@psi.ch; 16/02/2008, 10/07/2009, 05/11/2009
	//joel.c.corbin+sci@gmail.com; 2016-05-11 
	wave dMdlogDp	//measured mass size distribution
	wave DpScale	//diameter scale corresponding to dMdlogDp
	variable DmeasMin	//minimum diameter of the measurement to be included in the fit and mass calculation of the measurement
						//default: minimum diameter of Dpscale
	variable DmeasMax	//maximum diameter of the measurement to be included in the fit and the mass calculation of the measurement
						//default: maximum diameter of Dpscale (see note next line)
						//note: the uppermost size bin, which contains the saturated particles, is not included in the fit
	variable DfullMin		//minimum diameter to be included in the mass calculation of the fitted size distribution
						//default: 1
	variable DfullMax		//maximum diameter to be included in the mass calculation of the fitted size distribution
						//default: 1000
	wave LogNormParam	//wave for fitted parameters
						//default: lognormal parameters are not returned
	wave dYdlogDpFitted	//wave for returning the fitted size distribution
						//default: fitted size distribution is not returned
	wave DpScaleFitted	//wave for returning the diameter scale of the fitted size distribution
						//default: the fitted size distribution is not returned
	variable nDistrPts		//number of points for 'dYdlogDpFitted'
						//default: 200
	wave FitErrorQuit		//wave for returning the values of V_FitError and V_FitQuitReason 
						// FitQuitError[0]=V_FitError
						// FitQuitError[1]=V_FitQuitReason
						//default: not returned
	variable KillTmpFldr	//1 (default):	kill temporary data folder
						//0:			do not kill temporary data folder
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//check input
	variable nPtsMeas=dimsize(dMdlogDp,0)
	if (dimsize(DpScale,0)!=nPtsMeas)
		setdatafolder $savedDF
		string /g RTStackInfo
		RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
		currproc=laststringfromlist(RTStackInfo)
		message="Dimension mismatch of the waves 'dMdlogDp' and 'DpScale' handed over to the function "+currproc+"!"
		print message
		print RTStackInfo
		abort message		
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2massCorrFactLogNorm
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	//set defaults
	if (paramisdefault(DmeasMin))
		DmeasMin=-inf
	endif	
	if (paramisdefault(DmeasMax))
		DmeasMax=inf
	endif	
	if (paramisdefault(DfullMin))
		DfullMin=1
	endif
	if (paramisdefault(DfullMax))
		DfullMax=1000
	endif
	if (paramisdefault(nDistrPts))
		nDistrPts=200
	endif
	if (paramisdefault(LogNormParam))
		setdatafolder $tmpfldrpath
		make /o/n=0 LogNormParam
	endif
	if (paramisdefault(dYdlogDpFitted))
		setdatafolder $tmpfldrpath
		make /o/n=0 dYdlogDpFitted
	endif
	if (paramisdefault(DpScaleFitted))
		setdatafolder $tmpfldrpath
		make /o/n=0 DpScaleFitted
	endif
	if (paramisdefault(FitErrorQuit))
		setdatafolder $tmpfldrpath
		make /o/n=0 FitErrorQuit
	endif
	if (paramisdefault(KillTmpFldr))
		KillTmpFldr=1
	endif
	//temporary copies of measured size distribution
	setdatafolder $tmpfldrpath
	duplicate /o dMdlogDp, MeasDistrY
	duplicate /o DpScale, MeasDistrX
	DeleteNaNPtsFromWavePair(MeasDistrX, MeasDistrY)
	nPtsMeas=dimsize(MeasDistrX,0)
	//coerce DmeasMin to D-range of measurement distribution
	DmeasMin=Max(DmeasMin,MinFromWaveNaN(DpScale, mode=1))	
	//coerce DmeasMax to second last size bin of dM/dlogDp
	variable V2ndLastDp=DpScale[imag(FirstAndLastNonNaNpoint(dMdlogDp))-1]	//diameter of 2nd-last size bin of dM/dlogDp
	DmeasMax=Min(DmeasMax,V2ndLastDp)
	//remove leading and trailing tails of measured size distribution, which extend beyond DmeasMin and DmeasMax, respectively
	variable firstpt, lastpt
	firstpt=Round(BinarySearchInterp(MeasDistrX, DmeasMin))		//round to nearest point
	if (numtype(firstpt)==2)
		firstpt=0
	endif
	lastpt=Round(BinarySearchInterp(MeasDistrX, DmeasMax))		//round to nearest point
	if (numtype(lastpt)==2)
		lastpt=nPtsMeas-1
	endif
	deletepoints lastpt+1, (nPtsMeas-lastpt-1), MeasDistrX, MeasDistrY
	deletepoints 0, firstpt, MeasDistrX, MeasDistrY
	//get properties of measured size distribution
	variable gDmeanMeas=Distribution_geomMean_XYlogNaN(MeasDistrX, MeasDistrY, 1)
	variable gSigmaMeas=Distribution_geomSdev_XYlog_NaN(MeasDistrX, MeasDistrY, 1, Xgeommean=gDmeanMeas)
	variable MtotMeas=Distribution_Number_XYlog_NaN(MeasDistrX, MeasDistrY)
	//initial guess for fitting
	LogNormParam={0,MtotMeas, gSigmaMeas, gDmeanMeas}
	variable nFitParam=numpnts(LogNormParam)
	//fit lognormal distribution
	setdatafolder $tmpfldrpath
	variable nNonNans
	if (numpnts(MeasDistrY))
		wavestats /q MeasDistrY
		nNonNans=V_npnts
	else
		nNonNans=0
	endif
	if (nNonNans>nFitParam)
		variable V_chisq= FuncFitXYWav(MeasDistrY, LogNormParam, "HTDMA_LogNorm_fitfkt", XvalWav=MeasDistrX, HoldString="1000")
		variable /g V_FitError			//access fit error
		variable /g V_FitQuitReason	//access fit quit reason value
		FitErrorQuit={V_FitError, V_FitQuitReason}
	else
		LogNormParam=NaN
		FitErrorQuit={NaN,NaN}		//NaN because there are no data
	endif
	//analyse fitted size distribution
	redimension /n=(nDistrPts) dYdlogDpFitted, DpScaleFitted
	setscale /i x, log(DfullMin), log(DfullMax), dYdlogDpFitted, DpScaleFitted
	variable dlogDp=(log(DfullMax)-log(DfullMin))/(nDistrPts-1)
	DpScaleFitted=10^x
	dYdlogDpFitted=HTDMA_LogNorm_fitfkt(LogNormParam, DpScaleFitted[p])
	//add note to wave containing fit info
		string fitnote
		wfprintf fitnote, "%g,", LogNormParam
		fitnote = "W_coef={" +  removeEnding(fitnote,",")  + "}"
		fitnote += "\rV_chisq=" + num2str(V_Chisq)
		fitnote += "\rFit_date=" + now()
		fitnote += "\rFittedY=" + getwavesdatafolder(dMdlogDp,2)
		fitnote += "\rFittedX=" + getwavesdatafolder(DpScale,2)
		fitnote += "\rFitRange=(" + num2str(DmeasMin)+", "+num2str(DmeasMax) + ")"
		note dYdlogDpFitted, fitnote
	//calculate the ratio of the integrated masses of the fitted and measured size distributions
	variable IntMass=sum(dYdlogDpFitted)*dlogDp	//	/nDistrPts
	variable MassCorrFact= IntMass/MtotMeas
	//finish procedure
	setdatafolder $savedDF
	if (KillTmpFldr==1)
		killdatafolder /z $tmpfldrpath
	endif
	return cmplx(MassCorrFact,IntMass)
end


Function SP2_CETAC_calc_LiquidConcBtt(ctrlname [, PBPfldrfp, LiqSampleFlow, DrainFlow, PurgeAirFlow]) : ButtonControl
	//This function calculates the liquid sample concentration from the measured mass concentration
	//if a CETAC nebulizer has been used to nebulise the sample.
	//return value: not used; the result is written to waves
	//martin.gysel@psi.ch; 04/11/2008, 22/01/2009, 23/11/2009, 07/05/2010
	string ctrlname				//name of button control; not used
	string PBPfldrfp				//full path to folder containing the PBP data
								//default: browse for folder
	variable LiqSampleFlow		//flow rate of liquid sample pumped into CETAC nebulizer
								//unit: ml/min
								//default: use panel value
	variable DrainFlow			//flow rate of liquid drain from CETAC nebulizer (not in particle phase)
								//unit: ml/min
								//default: use panel value
	variable PurgeAirFlow			//flow rate of purge air blown into CETAC nebulizer
								//unit: l/min
								//default: use panel value
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(PBPfldrfp))
		PBPfldrfp=BrowseForFolder("Select folder containing the PBP data to be analysed", StartPath=savedDF)
		if (stringmatch(PBPfldrfp, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif	
	endif
	if (paramisdefault(LiqSampleFlow))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar GlobalVal=$ksSP2CETACsampleflow
		LiqSampleFlow=GlobalVal
	endif
	if (paramisdefault(DrainFlow))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar GlobalVal=$ksSP2CETACdrainflow
		DrainFlow=GlobalVal
	endif
	if (paramisdefault(PurgeAirFlow))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar GlobalVal=$ksSP2CETACpurgeairflow
		PurgeAirFlow=GlobalVal
	endif
	//concentration unit conversion factor
	variable ConvFact=PurgeAirFlow/(LiqSampleFlow-DrainFlow)
	//various variables and strings
	variable chanind
	string chanprefixlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string chandescrlist=SP2_ChanListToDescrShortList(chanprefixlist)
	variable nchans=itemsinlist(chanprefixlist)
	string currPrefix, currDescript
	variable calind, currstart, currend, offset, delta, nIncPart, volume
	//loop over all incandescence channels and calculate liquid sample conc.
	for (chanind=0; chanind<nchans; chanind+=1)
		//channel prefix and description
		currPrefix=stringfromlist(chanind,chanprefixlist)
		currDescript=stringfromlist(chanind,chandescrlist)
		//access waves
		setdatafolder $pbpfldrfp
		wave /Z BCtotalmassconc=$currPrefix+ksSP2pbpBCtotalmassconc
		wave /Z BCtotalmassconcBelowCut=$currPrefix+ksSP2pbpBCtotalmassconcBelowCut	
		//create result waves
		if (waveexists(BCtotalmassconc))
			setdatafolder $pbpfldrfp
			make /o/n=1 $currPrefix+ksSP2pbpLiquidSampleMassConc
			wave LiqSampleConc=$currPrefix+ksSP2pbpLiquidSampleMassConc
			note LiqSampleConc, "mass concentration of BC in liquid sample [g/l] as derived from "+currDescript+" data;"
			note LiqSampleConc, "CETAC liquid sample flow: "+num2str(LiqSampleFlow)+" ml/min;"
			note LiqSampleConc, "CETAC liquid drain flow: "+num2str(DrainFlow)+" ml/min;"
			note LiqSampleConc, "CETAC purge air flow: "+num2str(PurgeAirFlow)+" l/min;"
			//calculate liquid concentration
			LiqSampleConc=BCtotalmassconc*ConvFact
		endif
		if (waveexists(BCtotalmassconcBelowCut))
			setdatafolder $pbpfldrfp
			make /o/n=1 $currPrefix+ksSP2pbpLiqSampMassConcBelowCut
			wave LiquidSampleMassConcBelowCut=$currPrefix+ksSP2pbpLiqSampMassConcBelowCut
			note LiquidSampleMassConcBelowCut, "mass concentration of estimated BC below cut-off in liquid sample [g/l] as derived from "+currDescript+" data;"
			note LiquidSampleMassConcBelowCut, "CETAC liquid sample flow: "+num2str(LiqSampleFlow)+" ml/min;"
			note LiquidSampleMassConcBelowCut, "CETAC liquid drain flow: "+num2str(DrainFlow)+" ml/min;"
			note LiquidSampleMassConcBelowCut, "CETAC purge air flow: "+num2str(PurgeAirFlow)+" l/min;"
			//calculate liquid concentration
			LiquidSampleMassConcBelowCut=BCtotalmassconcBelowCut*ConvFact
		endif
	endfor
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function MatSlider090113(GraphIDstr, RefPath, Prefix)
	//This function is a template to call the MatrixSuperSlider function
	string GraphIDstr
	string RefPath
	string Prefix		//either "Broad_" or "Narr_"
	string YMatL=Prefix+"HistoMat;"+Prefix+"HistoMatFitted"
	//optional strings
	string TimeRunPath="root:DMPS090113:TimeStartSeries"
	string TimeRunType="time"
	variable Omode=1
	
	string savedDF=getdatafolder(1)
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=RefPath, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	
	//graph window size
//&%	MoveWindow 170.25,59.75,755.25,451.25

	//format graph
	ModifyGraph rgb(Ywave1)=(0,0,52224)	
	//optional slider proc
//&%	setdatafolder $MSSfldrpath
//&%	Svar OptionalCurrPtCmd
//&%	OptionalCurrPtCmd="exampleProc()"
//e.g. displaying 1 extra value	
		//OptionalCurrPtCmd="MatSupSlid1extraValDispProc(\""+MSSfldrpath+"\", \""+DataWaveFpath+"\")"
		//TextBox/N=ExVal1Disp/A=MC/X=0/Y=0 "RH measured: \\{"+MSSfldrpath+":"+ksExtraVal1ToBeDisplayedNam+"}"

	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2_Calib_DummyCalibCoeffButt(ctrlname [, CalibSubfldrName]) : ButtonControl
	//This function prepares the waves for the calibration coefficients.
	//return value: 0; not used
	//martin.gysel@psi.ch; 23/01/2009, 04/11/2009, 13/11/2009, 26/04/2010, 10/05/2010; tested
	string ctrlname			//name of button control; not used
	string CalibSubfldrName	//name of subfolder in which the SP2 calibration coefficients are to be created
							//default: prompt
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibSubfldrName))
		CalibSubfldrName="LabYYYY_incMMDD_scaMMDD_vN"
		prompt CalibSubfldrName, "Name for subfolder for calibration coefficients (must not start with a number):"
		doprompt "Calibration Folder Name", CalibSubfldrName
		if (V_flag)
			SP2_abort("")
		endif
	endif
	CalibSubfldrName=WaveNameCleaner(CalibSubfldrName, prefix="")
	//create calibration coefficient waves
	newdatafolder /o/s $ksSP2PathToCalibDataFldr
	newdatafolder /o/s $CalibSubfldrName
	string calibcoeffldrfp=getdatafolder(1)
		//scattering high gain ("scatt")
		if (kSP2disableSCHG==0)
			make /o/n=(kSP2SCHGnCalibCoeff) $ksSP2SCHGprefix+ksSP2CalCoefBnam=kSP2defaultSCHGcalibCoeff
			wave CalCoef_Scatt=$ksSP2SCHGprefix+ksSP2CalCoefBnam
			note CalCoef_Scatt, "calibration coefficients for high gain scattering channel;"
			note CalCoef_Scatt, "value to be taken from the wave '"+ksSP2calibSCHGcalibFactList+"' determined from a PSL calibration;"
		endif
		//broadband high gain ("broad")
		if (kSP2disableBBHG==0)
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2BBHGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_Broad=$ksSP2BBHGprefix+ksSP2CalCoefBnam
			note CalCoef_Broad, "calibration coefficients for high gain broadband incandescence channel;"
			note CalCoef_Broad, "coefficients for quadratic spline;"
			note CalCoef_Broad, "use function 'SP2_calibCurveSpline';"
			CalCoef_Broad[1]=1
		endif
		//narrowband high gain ("narr")
		if (kSP2disableNBHG==0)
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2NBHGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_Narr=$ksSP2NBHGprefix+ksSP2CalCoefBnam
			note CalCoef_narr, "calibration coefficients for high gain narrowband incandescence channel;"
			note CalCoef_narr, "coefficients for quadratic spline;"
			note CalCoef_narr, "use function 'SP2_calibCurveSpline';"
			CalCoef_Narr[1]=1
		endif
		//split detector high gain ("split")
		if (kSP2disableSPHG==0)
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2SPHGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_Split=$ksSP2SPHGprefix+ksSP2CalCoefBnam
			note CalCoef_Split, "calibration coefficients for high gain split detector channel;"
			note CalCoef_Split, "polynomial coefficients;"
			CalCoef_Split[1]=1
		endif
		//scattering low gain ("SCLG")
		if (kSP2disableSCLG==0)
			make /o/n=(kSP2SCLGnCalibCoeff) $ksSP2SCLGprefix+ksSP2CalCoefBnam=kSP2defaultSCLGcalibCoeff
			wave CalCoef_SCLG=$ksSP2SCLGprefix+ksSP2CalCoefBnam
			note CalCoef_SCLG, "calibration coefficients for low gain scattering channel;"
			note CalCoef_SCLG, "value to be taken from the wave '"+ksSP2calibSCLGcalibFactList+"' determined from a PSL calibration;"
		endif
		if (kSP2disableBBHG==0)
		//broadband low gain ("BBLG")
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2BBLGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_BBLG=$ksSP2BBLGprefix+ksSP2CalCoefBnam
			note CalCoef_BBLG, "calibration coefficients for low gain broadband incandescence channel;"
			note CalCoef_BBLG, "coefficients for quadratic spline;"
			note CalCoef_BBLG, "use function 'SP2_calibCurveSpline';"
			CalCoef_BBLG[1]=1
		endif
		//narrowband low gain ("NBLG")
		if (kSP2disableNBLG==0)
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2NBLGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_NBLG=$ksSP2NBLGprefix+ksSP2CalCoefBnam
			note CalCoef_NBLG, "calibration coefficients for low gain narrowband incandescence channel;"
			note CalCoef_NBLG, "coefficients for quadratic spline;"
			note CalCoef_NBLG, "use function 'SP2_calibCurveSpline';"
			CalCoef_NBLG[1]=1
		endif
		//split detector low gain ("SPLG")
		if (kSP2disableSPLG==0)
			make /o/n=(kSP2defaultNCalibCoeff) $ksSP2SPLGprefix+ksSP2CalCoefBnam=0
			wave CalCoef_SPLG=$ksSP2SPLGprefix+ksSP2CalCoefBnam
			note CalCoef_SPLG, "calibration coefficients for low gain split detector channel;"
			note CalCoef_SPLG, "polynomial coefficients;"
			CalCoef_SPLG[1]=1
		endif
		//bandratio BBHG/NBHG
		if ( (kSP2disableBBHG+kSP2disableNBHG)==0 )
			make /o/n=(kSP2BandRatioNCalibCoeff) $ksSP2CalBandRatioHGcoef=0
			wave BandRatioHGcoef=$ksSP2CalBandRatioHGcoef
			note BandRatioHGcoef, "calibration coefficients for high gain bandratio curve;"
			note BandRatioHGcoef, "Coefficients for function SP2_BandRatioVsBroadPkHT_FitFct;"
			BandRatioHGcoef[0]=1	
			BandRatioHGcoef[3]=1	
		endif
		//bandratio BBLG/NBLG
		if ( (kSP2disableBBLG+kSP2disableNBLG)==0 )
			make /o/n=(kSP2BandRatioNCalibCoeff) $ksSP2CalBandRatioLGcoef=0
			wave BandRatioLGcoef=$ksSP2CalBandRatioLGcoef
			note BandRatioLGcoef, "calibration coefficients for low gain bandratio curve;"
			note BandRatioLGcoef, "Coefficients for function SP2_BandRatioVsBroadPkHT_FitFct;"
			BandRatioLGcoef[0]=1	
			BandRatioLGcoef[3]=1	
		endif
	//create table showing the calibration coefficients
	SP2table_CalibCoef(calibcoeffldrfp=calibcoeffldrfp)
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2_Calib_AddCalibCurveWavesBtt(ctrlname [, CalibCoeffFldrFP, RhoEff]) : ButtonControl
	//This function creates the calibration curve waves calculated from the calibration coefficients
	//return value: 0, not used
	//martin.gysel@psi.ch; 23/01/09, 04/11/2009, 13/11/2009, 26/04/2010;
	string ctrlname			//name of button control; not used
	string CalibCoeffFldrFP	//folder containing the SP2 calibration coefficients
							//default: browse for folder
	variable RhoEff			//effective density used to convert the calibration results onto a diameter scale
							//unit: [kg/m]
							//default: prompt
							
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(CalibCoeffFldrFP))
		CalibCoeffFldrFP=BrowseForFolder("Select folder containing the calibration coefficients", StartPath=ksSP2PathToCalibDataFldr)
		if (stringmatch(CalibCoeffFldrFP, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif	
	endif
	if (paramisdefault(RhoEff))
		RhoEff=kSP2CalibRhoEffDef
		prompt RhoEff, "bulk density [kg/m] (for calculating diameter scale):"
		doprompt "Effective Density", RhoEff
	endif
	//access waves
	setdatafolder $CalibCoeffFldrFP
	wave /Z CalCoef_scatt=$ksSP2SCHGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_broad=$ksSP2BBHGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_narr=$ksSP2NBHGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_split=$ksSP2SPHGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_SCLG=$ksSP2SCLGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_BBLG=$ksSP2BBLGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_NBLG=$ksSP2NBLGprefix+ksSP2CalCoefBnam
	wave /Z CalCoef_SPLG=$ksSP2SPLGprefix+ksSP2CalCoefBnam
	wave /Z BandRatioHGcoef=$ksSP2CalBandRatioHGcoef
	wave /Z BandRatioLGcoef=$ksSP2CalBandRatioLGcoef
	//calculate calibration curves
	variable Xmin=0, Xmax=kSP2signalAmpMax
	setdatafolder $CalibCoeffFldrFP
	//high gain scattering channel peak height calibration curve
	if (waveexists(CalCoef_scatt))
//		Note: The shape of the calibration curve is taken from the Mie data folder
//		make /o/n=(kSP2CalibCurveNumPts) $ksSP2CalCurve_SCHG
//		wave scatt_CalCurve=$ksSP2CalCurve_SCHG
//		setscale /i x, Xmin, Xmax, scatt_CalCurve
//		scatt_CalCurve=max(0,Polynom_fkt(CalCoef_scatt, x))
	endif
	//high gain broadband incandescence channel peak height calibration curve
	if (waveexists(CalCoef_broad))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2BBHGprefix+ksSP2CalCurveBnam
		wave broad_CalCurve=$ksSP2BBHGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, broad_CalCurve
		broad_CalCurve=SP2_calibCurveSpline(x,CalCoef_broad)
	endif
	//high gain broadband channel size calibration curve
	if (waveexists(CalCoef_broad))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2BBHGprefix+ksSP2CalSizeCurveBnam
		wave broad_SizeCalCurve=$ksSP2BBHGprefix+ksSP2CalSizeCurveBnam
		setscale /i x, Xmin, Xmax, broad_SizeCalCurve
		broad_SizeCalCurve=(6/pi*broad_CalCurve/RhoEff*1e9)^(1/3)
	endif
	//high gain narrowband incandescence channel  peak height calibration curve
	if (waveexists(CalCoef_narr))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2NBHGprefix+ksSP2CalCurveBnam
		wave narr_CalCurve=$ksSP2NBHGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, narr_CalCurve
		narr_CalCurve=SP2_calibCurveSpline(x,CalCoef_narr)
	endif
	//high gain narrowband channel size calibration curve
	if (waveexists(CalCoef_narr))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2NBHGprefix+ksSP2CalSizeCurveBnam
		wave narr_SizeCalCurve=$ksSP2NBHGprefix+ksSP2CalSizeCurveBnam
		setscale /i x, Xmin, Xmax, narr_SizeCalCurve
		narr_SizeCalCurve=(6/pi*narr_CalCurve/RhoEff*1e9)^(1/3)
	endif
	//high gain split detector channel peak height calibration curve
	if (waveexists(CalCoef_split))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2SPHGprefix+ksSP2CalCurveBnam
		wave split_CalCurve=$ksSP2SPHGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, split_CalCurve
		split_CalCurve=max(0,Polynom_fkt(CalCoef_split, x))
	endif
	//high gain bandratio vs broadband peak height calibration curve
	if (waveexists(BandRatioHGcoef))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2CalBandRatioHGcurve
		wave BandRatioHGcurve=$ksSP2CalBandRatioHGcurve
		setscale /i x, Xmin, Xmax, BandRatioHGcurve
		BandRatioHGcurve=max(0,SP2_BandRatioVsBroadPkHT_FitFct(BandRatioHGcoef, x))
	endif
	//low gain scattering channel peak height calibration curve
	if (waveexists(CalCoef_SCLG))
//		Note: The shape of the calibration curve is taken from the Mie data folder
	endif
	//low gain broadband incandescence channel peak height calibration curve
	if (waveexists(CalCoef_BBLG))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2BBLGprefix+ksSP2CalCurveBnam
		wave BBLG_CalCurve=$ksSP2BBLGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, BBLG_CalCurve
		BBLG_CalCurve=SP2_calibCurveSpline(x,CalCoef_BBLG)
	endif
	//low gain broadband channel size calibration curve
	if (waveexists(CalCoef_BBLG))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2BBLGprefix+ksSP2CalSizeCurveBnam
		wave BBLG_SizeCalCurve=$ksSP2BBLGprefix+ksSP2CalSizeCurveBnam
		setscale /i x, Xmin, Xmax, BBLG_SizeCalCurve
		BBLG_SizeCalCurve=(6/pi*BBLG_CalCurve/RhoEff*1e9)^(1/3)
	endif
	//low gain narrowband incandescence channel  peak height calibration curve
	if (waveexists(CalCoef_NBLG))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2NBLGprefix+ksSP2CalCurveBnam
		wave NBLG_CalCurve=$ksSP2NBLGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, NBLG_CalCurve
		NBLG_CalCurve=SP2_calibCurveSpline(x,CalCoef_NBLG)
	endif
	//low gain narrowband channel size calibration curve
	if (waveexists(CalCoef_NBLG))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2NBLGprefix+ksSP2CalSizeCurveBnam
		wave NBLG_SizeCalCurve=$ksSP2NBLGprefix+ksSP2CalSizeCurveBnam
		setscale /i x, Xmin, Xmax, NBLG_SizeCalCurve
		NBLG_SizeCalCurve=(6/pi*NBLG_CalCurve/RhoEff*1e9)^(1/3)
	endif
	//low gain split detector channel peak height calibration curve
	if (waveexists(CalCoef_SPLG))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2SPLGprefix+ksSP2CalCurveBnam
		wave SPLG_CalCurve=$ksSP2SPLGprefix+ksSP2CalCurveBnam
		setscale /i x, Xmin, Xmax, SPLG_CalCurve
		SPLG_CalCurve=max(0,Polynom_fkt(CalCoef_SPLG, x))
	endif
	//low gain bandratio vs broadband peak height calibration curve
	if (waveexists(BandRatioLGcoef))
		make /o/n=(kSP2CalibCurveNumPts) $ksSP2CalBandRatioLGcurve
		wave BandRatioLGcurve=$ksSP2CalBandRatioLGcurve
		setscale /i x, Xmin, Xmax, BandRatioLGcurve
		BandRatioLGcurve=max(0,SP2_BandRatioVsBroadPkHT_FitFct(BandRatioLGcoef, x))
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end



Function SP2_calib_DMPSdataDummyWavsButt(ctrlname [, DMPSfldrFP, nScans, nBins]) : ButtonControl
	//This function creates empty waves for copying the data from ".rmf", ".dmf", and ".smf" files into them.
	//return value: 0; not used
	//note: the DMPS data matrices must be loaded without header line!
	//martin.gysel@psi.ch; 27/01/2009; 
	string ctrlname		//name of button control; not used
	string DMPSfldrFP	//full path to folder in which the DMPS raw data waves are to be created
						//e.g: "root:DMPSYYMMDD"
						//default: browse for folder
	variable nScans		//number of scans in DMPS data
						//default: prompt
	variable nBins		//number of size bins in DMPS size distributions
						//default: prompt
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	variable mustprompt=0
	if (paramisdefault(DMPSfldrFP))
		DMPSfldrFP="root:DMPSYYMMDD"
		mustprompt=1		
	endif
	if (paramisdefault(nScans))
		nScans=0
		mustprompt=1
	endif
	if (paramisdefault(nBins))
		nScans=0
		mustprompt=1
	endif
	if (mustprompt==1)
		prompt DMPSfldrFP, "Full path to folder for DMPS raw data:"
		prompt nScans, "Number of scans in DMPS data:"
		prompt nBins, "Number of size bins in DMPS size distributions:"
		doprompt "DMPS Data Folder And Matrix Dimensions", DMPSfldrFP, nScans, nBins
		if (V_flag)
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	DMPSfldrFP=QuoteLiberalPath(DMPSfldrFP)
	//create waves
	CreateFoldersOfFullPath(DMPSfldrFP, 0)
	setdatafolder $DMPSfldrFP
//	make /o/d/n=(nScans) $ksSP2_CPCDMA_ScanStartTimes
//	wave ScanStartTimes=$ksSP2_CPCDMA_ScanStartTimes
//	setscale d 0,0,"dat", ScanStartTimes
	make /o/n=(nScans, nBins) $ksSP2_DMPS_DiamMat
	wave DiamMat=$ksSP2_DMPS_DiamMat
	make /o/n=(nScans, nBins) $ksSP2_DMPS_CountsMat
	wave CountsMat=$ksSP2_DMPS_CountsMat
	make /o/n=(nScans, nBins) $ksSP2_DMPS_SecsMeasMat
	wave SecsMeasMat=$ksSP2_DMPS_SecsMeasMat
	make /t/o/n=(nScans, kDMPSheadernHeaderData) $ksSP2_DMPS_SettingsMat	
	wave /t SettingsMat=$ksSP2_DMPS_SettingsMat
	//user notification
	doalert 0, "Make sure the scan start and end times are correctly copied into to the DMPS settings matrix."
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2_calib_DMPSdataPrepButt(ctrlname [, DMPSfldrFP]) : ButtonControl
	//This function is to be used for conversion of DMPS after loading the ".rmf", ".dmf", and ".smf" files.
	//return value: 0; not used
	//note: The DMPS data matrices must be named as follows:
		//- diameter matrix from ".dmf": DiamMat
		//- scan start time wave taken from e.g. ".dmf": StartTimes
		//- matrix containing seconds measured per bin from ".smf": SecsMeasMat
		//- matrix containing raw counts ".rmf": CountsMat
	//note: the DMPS data matrices must be loaded without header line!
	//martin.gysel@psi.ch; 27/01/2009; 
	string ctrlname		//name of button control; not used
	string DMPSfldrFP	//full path to folder containing the DMPS raw data
						//default: browse for folder

	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(DMPSfldrFP))
		DMPSfldrFP=BrowseForFolder("Select folder containing the DMPS raw data:", StartPath=savedDF)
		if (stringmatch(DMPSfldrFP,"cancelled"))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	//access waves
	setdatafolder $DMPSfldrFP
	wave ScanStartTimes=$ksSP2_DMPS_ScanStartTimes
	wave DiamMat=$ksSP2_DMPS_DiamMat
	wave CountsMat=$ksSP2_DMPS_CountsMat
	wave SecsMeasMat=$ksSP2_DMPS_SecsMeasMat
	wave /t SettingsMat=$ksSP2_DMPS_SettingsMat
	variable nRows=dimsize(DiamMat,0)
	variable nCols=dimsize(DiamMat,1)
	variable nPtsTot=nRows*nCols
	//extract scan start times
	make /o/d/n=(nRows) $ksSP2_DMPS_ScanStartTimes
	wave ScanStartTimes=$ksSP2_DMPS_ScanStartTimes
	setscale d 0,0,"dat", ScanStartTimes
	ScanStartTimes=TimeTextToIgorTime(SettingsMat[p][kDMPSheaderStartTime])
	make /o/d/n=(nRows) $ksSP2_DMPS_ScanEndTimes
	wave ScanEndTimes=$ksSP2_DMPS_ScanEndTimes
	setscale d 0,0,"dat", ScanEndTimes
	ScanEndTimes=TimeTextToIgorTime(SettingsMat[p][kDMPSheaderEndTime])
	//extract temperature and pressure for each scan
	make /o/n=(nRows) $ksSP2_DMPS_TC	
	wave TC=$ksSP2_DMPS_TC
	TC=str2num(SettingsMat[p][kDMPSheaderTemperature])
	make /o/n=(nRows) $ksSP2_DMPS_Press	
	wave Press=$ksSP2_DMPS_Press
	Press=str2num(SettingsMat[p][kDMPSheaderPressure])
	//determine exact DMPS times
	setdatafolder $DMPSfldrFP
	make /o/d/n=(nRows,nCols) $ksSP2_DMPS_TimeStartMat
	wave /d TimeStartMat=$ksSP2_DMPS_TimeStartMat
	TimeStartMat=str2num(SettingsMat[p][kDMPSheaderTwait])+(ScanStartTimes[p])*(q==0)+(SecsMeasMat[p][q-1]+TimeStartMat[p][q-1])*(q!=0)
	duplicate /o TimeStartMat, $ksSP2_DMPS_TimeEndMat		
	wave /d TimeEndMat=$ksSP2_DMPS_TimeEndMat
	TimeEndMat+=SecsMeasMat[p][q]
	//determine concentration matrix from counts matrix
	setdatafolder $DMPSfldrFP
	make /o/n=(nRows,nCols) $ksSP2_DMPS_ConcMat
	wave ConcMat=$ksSP2_DMPS_ConcMat
	ConcMat=CountsMat[p][q]/CPCQinlet2Qdetector(UnitConverterMG(0, str2num(SettingsMat[p][kDMPSheaderQae])), SettingsMat[p][kDMPSheaderCPCtype])/SecsMeasMat[p][q]		
	//extract time series of diameter, start time, end time, concentration, temperature and pressure
	setdatafolder $DMPSfldrFP	
	make /d/o/n=(nPtsTot) $ksSP2_monodi_TimeStartList
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	setscale d 0,0,"dat", TimeStartList
	TimeStartList=TimeStartMat[floor(p/nCols)][mod(p,nCols)]
	make /d/o/n=(nPtsTot) $ksSP2_monodi_TimeEndList
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	setscale d 0,0,"dat", TimeEndList
	TimeEndList=TimeEndMat[floor(p/nCols)][mod(p,nCols)]
	make /d/o/n=(nPtsTot) $ksSP2_monodi_TimeCentreList
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	setscale d 0,0,"dat", TimeCentreList
	TimeCentreList=0.5*(TimeStartList+TimeEndList)
	make /o/n=(nPtsTot) $ksSP2_monodi_DiamList
	wave DiamList=$ksSP2_monodi_DiamList
	DiamList=DiamMat[floor(p/nCols)][mod(p,nCols)]
	make /o/n=(nPtsTot) $ksSP2_monodi_ConcList
	wave ConcList=$ksSP2_monodi_ConcList
	ConcList=ConcMat[floor(p/nCols)][mod(p,nCols)]
	make /o/n=(nPtsTot) $ksSP2_monodi_TClist
	wave TClist=$ksSP2_monodi_TClist
	TClist=TC[floor(p/nCols)]
	make /o/n=(nPtsTot) $ksSP2_monodi_PressList
	wave PressList=$ksSP2_monodi_PressList	
	PressList=Press[floor(p/nCols)]
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2_DMPSdataLoaderButt(ctrlname [RawPMFfileFP, DMPSfldrFP]) : ButtonControl
	//This function load DMPS data (format: PSI DMPS 1.0) and retrieves all relevant stuff for further data analysis
	//return value: 0; not used
	//note: the DMPS data matrices must be loaded without header line!
	//martin.gysel@psi.ch; 27/01/2009; 
	string ctrlname		//name of button control; not used
	string RawPMFfileFP	//full path to "PMF"-file to be loaded
						//note: the associated "RMF", "SMF" and "DMF" files must be in the same directory
						//note: use colon as path delimiter, e.g.: 
						//default: browse for file						
	string DMPSfldrFP	//full path to folder in which the DMPS raw data waves are to be created
						//e.g: "root:DMPSYYMMDD"
						//default: browse for folder
//	variable nScans		//number of scans in DMPS data
//						//default: prompt
//	variable nBins		//number of size bins in DMPS size distributions
//						//default: prompt
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(DMPSfldrFP))
		DMPSfldrFP="root:DMPSYYMMDD"
		prompt DMPSfldrFP, "Full path to folder for DMPS raw data:"
		doprompt "DMPS Data Folder", DMPSfldrFP
		if (V_flag)
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	DMPSfldrFP=QuoteLiberalPath(DMPSfldrFP)
	CreateFoldersOfFullPath(DMPSfldrFP, 0)
	if (paramisdefault(RawPMFfileFP))
		RawPMFfileFP=BrowseForFile(DialogStr="select PMF-file of DMPS measurement", TypeStr=".pmf")
		if (stringmatch("cancelled",RawPMFfileFP))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	string RawRMFfileFP=Replacestring("_PMF",RawPMFfileFP,"_RMF")
	RawRMFfileFP=Replacestring(".pmf",RawRMFfileFP,".rmf")
	string RawSMFfileFP=Replacestring("_PMF",RawPMFfileFP,"_SMF")
	RawSMFfileFP=Replacestring(".pmf",RawSMFfileFP,".smf")
	string RawDMFfileFP=Replacestring("_PMF",RawPMFfileFP,"_DMF")
	RawDMFfileFP=Replacestring(".pmf",RawDMFfileFP,".dmf")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s DMPSloader
	string tmpfldrpath=getdatafolder(1)
	//load PMF file
	setdatafolder $tmpfldrpath
	string PMFwavNam=LoadDelimitTxtFileTo1DWavNoAbrt("PMFfile", PathToFile=RawPMFfileFP, Omode=1)	
	wave /t PMFwav=$PMFwavNam
	variable nScans=dimsize(PMFwav,0)-1
	//parse PMF file
	setdatafolder $DMPSfldrFP
	make /t/o/n=(nScans, kDMPSheadernHeaderData) $ksSP2_DMPS_SettingsMat	
	wave /t SettingsMat=$ksSP2_DMPS_SettingsMat
	SettingsMat=stringfromlist(q,PMFwav[p+1],ksDMPSdatafileDelimiter)
	//load DMF file
	setdatafolder $tmpfldrpath
	string DMFwavNam=LoadDelimitTxtFileTo1DWavNoAbrt("DMFfile", PathToFile=RawDMFfileFP, Omode=1)	
	wave /t DMFwav=$DMFwavNam
	variable nBins=ItemsInListMaxFor1DWav(DMFwav, ksDMPSdatafileDelimiter)-kDMPSnDMFinfoCols
	//parse DMF file
	setdatafolder $DMPSfldrFP
	make /o/n=(nScans, nBins) $ksSP2_DMPS_DiamMat
	wave DiamMat=$ksSP2_DMPS_DiamMat
	DiamMat=str2num(stringfromlist(q+kDMPSnDMFinfoCols,DMFwav[p+1],ksDMPSdatafileDelimiter))
	//load RMF file
	setdatafolder $tmpfldrpath
	string RMFwavNam=LoadDelimitTxtFileTo1DWavNoAbrt("RMFfile", PathToFile=RawRMFfileFP, Omode=1)	
	wave /t RMFwav=$RMFwavNam
	//parse RMF file
	setdatafolder $DMPSfldrFP
	make /o/n=(nScans, nBins) $ksSP2_DMPS_CountsMat
	wave CountsMat=$ksSP2_DMPS_CountsMat
	CountsMat=str2num(stringfromlist(q+kDMPSnRMFinfoCols,RMFwav[p+1],ksDMPSdatafileDelimiter))
	//load SMF file
	setdatafolder $tmpfldrpath
	string SMFwavNam=LoadDelimitTxtFileTo1DWavNoAbrt("SMFfile", PathToFile=RawSMFfileFP, Omode=1)	
	wave /t SMFwav=$SMFwavNam
	//parse SMF file
	setdatafolder $DMPSfldrFP
	make /o/n=(nScans, nBins) $ksSP2_DMPS_SecsMeasMat
	wave SecsMeasMat=$ksSP2_DMPS_SecsMeasMat
	SecsMeasMat=str2num(stringfromlist(q+kDMPSnSMFinfoCols,SMFwav[p+1],ksDMPSdatafileDelimiter))
	//extract additional waves
	SP2_calib_DMPSdataPrepButt("", DMPSfldrFP=DMPSfldrFP)
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


Function /S SP2_RawFldrFP2CalibSummfldrFP(rawfldrfp)
	//return string: full path to (or name of the) calibration summary folder corresponding to an SP2 raw data folder.
	//martin.gysel@psi.ch; 28/01/2008
	string rawfldrfp	//full path to or name of an SP2 raw data folder
	
	string rawfldrnam=laststringfromlist(rawfldrfp, listsepstr=":")
	string pathtofldr
	if (strlen(rawfldrfp)==strlen(rawfldrnam))
		pathtofldr=""
	else
		pathtofldr=RemoveLastItemFromList(rawfldrfp,ListSepStr=":")
	endif
	string CalibSummaryFdlrNam=QuoteRemover(rawfldrnam)+ksSP2calibSummaryfldrSuffix	
	return QuoteLiberalPath(pathtofldr+CalibSummaryFdlrNam)
end


Function SP2_CalibAnalyzerIncandMono(ctrlname [CPCDMAfldrFP, SP2fldrFP, TargetFldrFP, CalibBCtype, rho_eff, nGauss, FitRangeFact, nHistoBins, nSizeBins, FirstHistoPt, LastHistoPt, graphs, DistrMode]) : ButtonControl
	//This function analyses data from a monodisperse calibration of the SP2's incandescence channels
	//return value: 0, not used
	//martin.gysel@psi.ch; 28/01/2009, 26/08/2009, 02/10/2009, 12/11/09, 13/11/2009, 04/05/2010, 11/05/2010, 29/09/2010, 22/10/2010, 10/11/2010, 12/11/2010, 16/11/2010, 18/11/2010
	string ctrlname			//name of button control; not used
	string CPCDMAfldrFP		//full path to folder containing the list of set diameters (plus measured concentrations, ...)
							//default: browse for folder
	string SP2fldrFP			//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
							//default: browse for folder
	string TargetFldrFP		//full path to folder for the calibration summary waves
							//default: prompt
	string CalibBCtype		//type of calibration material
							//e.g.: "Fullerene Soot", "AquaDag", ...
							//see stringconstant "ksSP2calibMatList" for possible options
							//default: use panel setting
	variable rho_eff			//effective density of calibration material
							//unit: [kg/m]
							//default: use panel setting
							//note: this variable is only used if "constant mobility density" is selected as calibration material
	variable nGauss			//maximum number of Gaussians to be fitted
							//see subprocedure for details
	variable FitRangeFact		//determines the width of the data range about the peak position to be fitted in each iteration step
							//i.e: range fitted about peak of mode: FitRangeFact*FWHM
							//see subprocedure for details
	variable nHistoBins		//number of bins for peak height histogram
	variable nSizeBins		//number of bins for number size distribution
	variable FirstHistoPt		//number of leading histogram bins to be ignored during Gaussian fit
	variable LastHistoPt		//number of trailing histogram bins to be ignored during Gaussian fit
	variable graphs			//0:			do not draw graphs automatically
							//1 (default):	draw graphs automatically
	variable DistrMode		//0 (default):  number size distribution is not determined
							//1:			number size distribution using selected calibration is determined
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(CPCDMAfldrFP))
	// jcc v4111--try to be more user friendly
		// todo: save a global string of the last folder and access it here...
		
		DoAlert /T="SP2 toolkit" 1, "Have you already prepared tables describing the calibration files?"
		if (V_flag==2) // no--user should not have clicked this button
			
			SP2_CalibBCinfoWavesPrepButt("BCemptyInfoWavsButt") // click correct button
			
			string Sinfo= "Incandescence calibration procedure:"
			Sinfo+= "\r\t-check the BC type entered on the panel and fill in the table."
			DoAlert /T="SP2 toolkit" 0, "Fill in this table, then click 'analyse monodisperse calibration' again.\rSee history for brief instructions, and manual for detailed instructions."
				Sinfo+= "\r\t-You don't need to fill in all table rows manually, e.g. (after changing data folders):"
				Sinfo+= "\r\tFileDateFirst= \"20150609\""
				Sinfo+= "\r\tFileDateLast= FileDateFirst"
				Sinfo+= "\r\tFileNumFirst= num2istr(19 + p)"
				Sinfo+= "\r\tFileNumLast= FileNumFirst"
				Sinfo+= "\r\tMassList= nan"
			Sinfo+= "\rAfterwards, run: SP2_CalibAnalyzerScatt(\"CalibAnalyseMonoScatt\")"
			
			print Sinfo
			return V_flag
			
			return 1
		endif
		CPCDMAfldrFP=BrowseForFolder("Select folder containing the calibration info data:", StartPath="root:", selectStr="CalibInfo")
		if (stringmatch(CPCDMAfldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	CPCDMAfldrFP=QuoteLiberalPath(CPCDMAfldrFP)
	if (paramisdefault(SP2fldrFP))
		SP2fldrFP=SP2_getFolder(startingDF=savedDF, type="raw", promptText="Select folder containing all sp2 raw data (you should have selected Concatenate when loading)") // jcc :: was : BrowseForFolder("Select folder containing the SP2 raw data:", StartPath=savedDF)
		if (stringmatch(SP2fldrFP,"cancelled"))
			SP2_abort("User cancelled procedure"+currproc+"!")	
		endif
	endif
	SP2fldrFP=QuoteLiberalPath(SP2fldrFP)
	string SP2PBPfldr=SP2_RawFldrFP2PBPfldrFP(SP2fldrFP)
	if (paramisdefault(rho_eff))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar CalibMatBCdensity=$ksSP2calibMatBCdensity
		rho_eff=CalibMatBCdensity
	endif
	if (paramisdefault(CalibBCtype))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Svar CalibMatBCtype=$ksSP2calibMatBCtype
		CalibBCtype=CalibMatBCtype
	endif
	variable mustprompt=0
	if (paramisdefault(TargetFldrFP))
		TargetFldrFP=SP2_RawFldrFP2CalibSummfldrFP(SP2fldrFP)
		mustprompt=1
	endif
	if (paramisdefault(nGauss))
		nGauss=1
		mustprompt=1
	endif
	if (paramisdefault(FitRangeFact))
		FitRangeFact=2
		mustprompt=1
	endif
	if (paramisdefault(nHistoBins))
		nHistoBins=75
		mustprompt=1
	endif
	if (paramisdefault(nSizeBins))
		nSizeBins=100
		mustprompt=1
	endif
	if (paramisdefault(FirstHistoPt))
		FirstHistoPt=2
		mustprompt=1
	endif
	if (paramisdefault(LastHistoPt))
		LastHistoPt=2
		mustprompt=1
	endif
	if (mustprompt==1)
		prompt TargetFldrFP, "target folder for calibration summary:"
		prompt nGauss, "maximum # of Gaussians to be fitted:"
		prompt FitRangeFact, "range to be fitted about peak of mode: FitRangeFact*FWHM:"
		prompt nHistoBins, "# of bins for peak height histogram:"
		prompt nSizeBins, "# of bins for size distribution:"
		prompt FirstHistoPt, "# of leading histogram bins to be ignored during Gaussian fit:"
		prompt LastHistoPt, "# of trailing histogram bins to be ignored during Gaussian fit:"
		doprompt "Optional parameters", TargetFldrFP, nGauss, FitRangeFact, nHistoBins, nSizeBins, FirstHistoPt, LastHistoPt
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message					
		endif
	endif
	variable LastPt=nHistoBins-LastHistoPt
	TargetFldrFP=QuoteLiberalPath(TargetFldrFP)
	CreateFoldersOfFullPath(TargetFldrFP, 0)
	if (paramisdefault(graphs))
		graphs=1
	endif
	if (paramisdefault(DistrMode))
		DistrMode=0
	endif
	//print command to history
	string cmd=currproc
	cmd+="(\"\""
	cmd+=", DistrMode="+num2str(DistrMode)
	cmd+=", nHistoBins="+num2str(nHistoBins)
	cmd+=", nSizeBins="+num2str(nSizeBins)
	cmd+=", nGauss="+num2str(nGauss)
	cmd+=", FitRangeFact="+num2str(FitRangeFact)
	cmd+=", CalibBCtype=\""+CalibBCtype+"\""
	cmd+=", rho_eff="+num2str(rho_eff)
	cmd+=", CPCDMAfldrFP=\""+CPCDMAfldrFP+"\""
	cmd+=", SP2fldrFP=\""+SP2fldrFP+"\""
	cmd+=", TargetFldrFP=\""+TargetFldrFP+"\""
	cmd+=", FirstHistoPt="+num2str(FirstHistoPt)
	cmd+=", LastHistoPt="+num2str(LastHistoPt)
	cmd+=", graphs=0"	//keep it fixed at 0 because they are only needed once
	cmd+=")"
	print cmd
	//temporary waves
	newdatafolder /o/s root:temp
	newdatafolder /o/s SP2calib
	string tmpfldrpath=getdatafolder(1)
	make /o/n=0 TempGaussCoeff
	make /o/n=0 tempFittedHistogram
	make /o/n=(nHistoBins) tempHistogram
	make /o/n=(nSizeBins) tempdNdlogDp
	make /o/n=0 SplineCoefM2D, SplineCoefD2M
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar CalibSubFldrNam=$ksSP2calibFldr
	Nvar CalibBetaDMA=$ksSP2calibBetaDMA	
	//access SP2 raw waves
	setdatafolder $SP2fldrFP
	wave /d TimeDate=$ksSP2TimeDate
	wave SampleVolume=$ksSP2sampleVolume
	variable nRawRows=dimsize(TimeDate,0)
	//access SP2 PBP waves
	if (!DataFolderExists(SP2PBPfldr))
		SP2_abort("Didn't find the given PBP folder.\r(You may need to repeat pre-processing)") // specifically, the Classification wave is needed.
	endif
	setdatafolder $SP2PBPfldr
	wave Classification=$ksSP2pbpClassification					
	variable nData=numpnts(Classification)
	//access DMA/CPC waves
	setdatafolder $CPCDMAfldrFP
	wave /Z SelectorModeWav=$ksSP2_monodi_SelectorMode
	wave /d/Z TimeStartList=$ksSP2_monodi_TimeStartList
	wave /d/Z TimeEndList=$ksSP2_monodi_TimeEndList
	wave /d/Z TimeCentreList=$ksSP2_monodi_TimeCentreList
	wave /Z ConcListCPC=$ksSP2_monodi_ConcList
	variable nCals=dimsize(TimeStartList,0)
	//deal with legacy data format
	if (!waveexists(SelectorModeWav))
		setdatafolder $CPCDMAfldrFP
		make /o/n=1 $ksSP2_monodi_SelectorMode=1		//everything was for DMA with legacy toolkit
		wave SelectorModeWav=$ksSP2_monodi_SelectorMode
		note SelectorMode, "1: particles selected using "+stringfromlist(0,ksSP2_monodi_SelectorList)+";" 
		note SelectorMode, "2: particles selected using "+stringfromlist(1,ksSP2_monodi_SelectorList)+";" 	
	endif
	variable SelectorMode=SelectorModeWav[0]
	//strings for storing paths to other folder
	setdatafolder $TargetFldrFP
	string /g $ksSP2calibDMACPCfldrFP=CPCDMAfldrFP
	string /g $ksSP2calibSP2rawDataFldrFP=SP2fldrFP
	//get start and end times if needed
	variable NaNbits
	NaNbits=CheckWaveForNaNs(TimeStartList)
	if (NaNbits & 8)
		//only NaNs in TimeStartList => get start and end times ...
		SP2_CalibInfogetTimesButt("", CalibInfoFldrFP=CPCDMAfldrFP, SP2rawFldrFP=SP2fldrFP)
	endif
	//prepare diameter and mass lists
	setdatafolder $TargetFldrFP
	make /o/n=(nCals) $ksSP2calibDiamList+ksSP2suffix1e
	wave DiamList_1e=$ksSP2calibDiamList+ksSP2suffix1e
	make /o/n=(nCals) $ksSP2calibDiamList+ksSP2suffix2e
	wave DiamList_2e=$ksSP2calibDiamList+ksSP2suffix2e
	make /o/n=(nCals) $ksSP2calibDiamList+ksSP2suffix3e
	wave DiamList_3e=$ksSP2calibDiamList+ksSP2suffix3e
	make /o/n=(nCals) $ksSP2calibMassList+ksSP2suffix1e
	wave MassList_1e=$ksSP2calibMassList+ksSP2suffix1e
	make /o/n=(nCals) $ksSP2calibMassList+ksSP2suffix2e
	wave MassList_2e=$ksSP2calibMassList+ksSP2suffix2e
	make /o/n=(nCals) $ksSP2calibMassList+ksSP2suffix3e
	wave MassList_3e=$ksSP2calibMassList+ksSP2suffix3e
	//prepare DMA/APM size distributions for size distributon slider
	setdatafolder $TargetFldrFP
	make /o $ksSP2calibHelpDiamYwav={0,1,0,1,0}
	wave HelpDiamYwav=$ksSP2calibHelpDiamYwav	
	make /o/n=(nCals,5) $ksSP2calibHelpDiamMat+ksSP2suffix1e
	wave HelpDiamMat_1e=$ksSP2calibHelpDiamMat+ksSP2suffix1e
	make /o/n=(nCals,5) $ksSP2calibHelpDiamMat+ksSP2suffix2e
	wave HelpDiamMat_2e=$ksSP2calibHelpDiamMat+ksSP2suffix2e
	make /o/n=(nCals,5) $ksSP2calibHelpDiamMat+ksSP2suffix3e
	wave HelpDiamMat_3e=$ksSP2calibHelpDiamMat+ksSP2suffix3e
	//selector specific
	variable nSplineSegmM2D, nSplineSegmD2M
	switch (SelectorMode)
		case 1:
			//using DMA
				//access wave
				setdatafolder $CPCDMAfldrFP
				wave DiamSetList=$ksSP2_monodi_DiamList
				wave TClist=$ksSP2_monodi_TClist
				wave PressList=$ksSP2_monodi_PressList	
				//calculate nominal diameters for all charges
				DiamList_1e=DiamSetList
				DiamList_2e=MultiChargeSizesEqualMob(DiamList_1e, 2,TC=TClist[p], press=PressList[p])
				DiamList_3e=MultiChargeSizesEqualMob(DiamList_1e, 3,TC=TClist[p], press=PressList[p])
				//calculate mass from mobility diameter
				strswitch (CalibBCtype)
					case ksSP2calibMatConstMobDens:
						//use constant mobility density
						MassList_1e=pi/6*DiamList_1e^3*1e-9*rho_eff		//fg
						MassList_2e=pi/6*DiamList_2e^3*1e-9*rho_eff		//fg
						MassList_3e=pi/6*DiamList_3e^3*1e-9*rho_eff		//fg
						break
					case ksSP2AquadagRCAST090904:
						//Aquadag (effective density data pers. comm. with RCAST on 04/09/2009) 
						nSplineSegmD2M=Aquadag_RhoVsLogDspline_Var25(SplineCoefD2M)
						MassList_1e=AquaDag_Diam2Mass(DiamList_1e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=AquaDag_Diam2Mass(DiamList_2e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=AquaDag_Diam2Mass(DiamList_3e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2AquadagMotekiAST2010:
						//Aquadag (effective density data from Moteki et al., AST, 2010) 
						nSplineSegmD2M=Aquadag_RhoVsLogDspline_Var25(SplineCoefD2M)
						MassList_1e=AquaDag_Diam2Mass(DiamList_1e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=AquaDag_Diam2Mass(DiamList_2e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=AquaDag_Diam2Mass(DiamList_3e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2AquadagClassicPSIOct2010:
						//Aquadag batch "classic" (effective density data from PSI measured with ETH APM in Oct 2010) 
						nSplineSegmD2M=Aquadag_RhoVsLogDspline_Var8(SplineCoefD2M)
						MassList_1e=AquaDag_Diam2Mass(DiamList_1e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=AquaDag_Diam2Mass(DiamList_2e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=AquaDag_Diam2Mass(DiamList_3e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2FullereneSootRCAST090904:
						//Fullerene Soot (effective density data pers. comm. with RCAST on 04/09/2009) 
						nSplineSegmD2M=Fullerene_RhoVsLogDspline_Var2(SplineCoefD2M)
						MassList_1e=FullereneSoot_Diam2Mass(DiamList_1e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=FullereneSoot_Diam2Mass(DiamList_2e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=FullereneSoot_Diam2Mass(DiamList_3e, 2, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2FullereneSootMotekiAST2010:
						//Fullerene Soot (effective density data from Moteki et al., AST, 2010) 
						nSplineSegmD2M=Fullerene_RhoVsLogDspline_Var5(SplineCoefD2M)
						MassList_1e=FullereneSoot_Diam2Mass(DiamList_1e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=FullereneSoot_Diam2Mass(DiamList_2e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=FullereneSoot_Diam2Mass(DiamList_3e, 5, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2FullereneSootPSIOct2010:
						//Fullerene Soot (effective density data from PSI measured with ETH APM in Oct 2010) 
						nSplineSegmD2M=Fullerene_RhoVsLogDspline_Var8(SplineCoefD2M)
						MassList_1e=FullereneSoot_Diam2Mass(DiamList_1e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_2e=FullereneSoot_Diam2Mass(DiamList_2e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						MassList_3e=FullereneSoot_Diam2Mass(DiamList_3e, 8, SplineCoef=SplineCoefD2M, nSegmentsSpline=nSplineSegmD2M)	//fg
						break
					case ksSP2GlassyCarbonAlphaAesar:
						//Alpha Aeaser glassy carbon spheres
						MassList_1e=GlassyCarbonAlpha_Diam2Mass(DiamList_1e)	//fg
						MassList_2e=GlassyCarbonAlpha_Diam2Mass(DiamList_2e)	//fg
						MassList_3e=GlassyCarbonAlpha_Diam2Mass(DiamList_3e)	//fg
						break
					case ksSP2calibMatAquaBlack162:
						//Tokai AquaBlack 162
						abort "The mass-mobility relationship for AquaBlack 162 is not yet implemented!"
						MassList_1e=AquaBlack162Tokai_Diam2Mass(DiamList_1e)	//fg
						MassList_2e=AquaBlack162Tokai_Diam2Mass(DiamList_2e)	//fg
						MassList_3e=AquaBlack162Tokai_Diam2Mass(DiamList_3e)	//fg
						break
					default:			
						//ERROR: calibration material not defined!
						setdatafolder $savedDF
						message="Calibration material '"+CalibBCtype+"' not defined in the function "+currproc+"!"
						print message; print RTStackInfo; abort message
				endswitch
				//calculate DMA size distributions for size distributon slider
				HelpDiamMat_1e[][0]=DiamList_1e[p]-DMATransferFWHM_Ci(DiamList_1e[p], CalibBetaDMA, 1,TC=TClist[p], press=PressList[p])
				HelpDiamMat_1e[][1,3]=DiamList_1e[p]
				HelpDiamMat_1e[][4]=DiamList_1e[p]+DMATransferFWHM_Ci(DiamList_1e[p], CalibBetaDMA, 1,TC=TClist[p], press=PressList[p])
				HelpDiamMat_2e[][0]=DiamList_2e[p]-DMATransferFWHM_Ci(DiamList_2e[p], CalibBetaDMA, 2,TC=TClist[p], press=PressList[p])
				HelpDiamMat_2e[][1,3]=DiamList_2e[p]
				HelpDiamMat_2e[][4]=DiamList_2e[p]+DMATransferFWHM_Ci(DiamList_2e[p], CalibBetaDMA, 2,TC=TClist[p], press=PressList[p])
				HelpDiamMat_3e[][0]=DiamList_3e[p]-DMATransferFWHM_Ci(DiamList_3e[p], CalibBetaDMA, 3,TC=TClist[p], press=PressList[p])
				HelpDiamMat_3e[][1,3]=DiamList_3e[p]
				HelpDiamMat_3e[][4]=DiamList_3e[p]+DMATransferFWHM_Ci(DiamList_3e[p], CalibBetaDMA, 3,TC=TClist[p], press=PressList[p])
				break
		case 2:
			//using APM
				//access waves
				setdatafolder $CPCDMAfldrFP
				wave MassSetList=$ksSP2_monodi_MassList
				//calculate nominal masses for all charges
				MassList_1e=MassSetList
				MassList_2e=2*MassSetList
				MassList_3e=3*MassSetList
				//calculate mobility diameter from mass
				strswitch (CalibBCtype)
					case ksSP2calibMatConstMobDens:
						//use constant mobility density
						DiamList_1e=1e3*((6*MassList_1e)/(pi*rho_eff))^(1/3)
						DiamList_2e=1e3*((6*MassList_2e)/(pi*rho_eff))^(1/3)
						DiamList_3e=1e3*((6*MassList_3e)/(pi*rho_eff))^(1/3)
						break
					case ksSP2AquadagRCAST090904:
						//Aquadag (effective density data pers. comm. with RCAST on 04/09/2009) 
						nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var25(SplineCoefM2D)
						DiamList_1e=AquaDag_Mass2Diam(MassList_1e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=AquaDag_Mass2Diam(MassList_2e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=AquaDag_Mass2Diam(MassList_3e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2AquadagMotekiAST2010:
						//Aquadag (effective density data from Moteki et al., AST, 2010) 
						nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var25(SplineCoefM2D)
						DiamList_1e=AquaDag_Mass2Diam(MassList_1e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=AquaDag_Mass2Diam(MassList_2e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=AquaDag_Mass2Diam(MassList_3e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2AquadagClassicPSIOct2010:
						//Aquadag batch "classic" (effective density data from PSI measured with ETH APM in Oct 2010) 
						nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var8(SplineCoefM2D)
						DiamList_1e=AquaDag_Mass2Diam(MassList_1e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=AquaDag_Mass2Diam(MassList_2e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=AquaDag_Mass2Diam(MassList_3e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2FullereneSootRCAST090904:
						//Fullerene Soot (effective density data pers. comm. with RCAST on 04/09/2009) 
						nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var2(SplineCoefM2D)
						DiamList_1e=FullereneSoot_Mass2Diam(MassList_1e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=FullereneSoot_Mass2Diam(MassList_2e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=FullereneSoot_Mass2Diam(MassList_3e[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2FullereneSootMotekiAST2010:
						//Fullerene Soot (effective density data from Moteki et al., AST, 2010) 
						nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var5(SplineCoefM2D)
						DiamList_1e=FullereneSoot_Mass2Diam(MassList_1e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=FullereneSoot_Mass2Diam(MassList_2e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=FullereneSoot_Mass2Diam(MassList_3e[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2FullereneSootPSIOct2010:
						//Fullerene Soot (effective density data from PSI measured with ETH APM in Oct 2010) 
						nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var8(SplineCoefM2D)
						DiamList_1e=FullereneSoot_Mass2Diam(MassList_1e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_2e=FullereneSoot_Mass2Diam(MassList_2e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						DiamList_3e=FullereneSoot_Mass2Diam(MassList_3e[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D)
						break
					case ksSP2GlassyCarbonAlphaAesar:
						//Alpha Aeaser glassy carbon spheres
						DiamList_1e=GlassyCarbonAlpha_Mass2Diam(MassList_1e)		//nm
						DiamList_2e=GlassyCarbonAlpha_Mass2Diam(MassList_2e)		//nm
						DiamList_3e=GlassyCarbonAlpha_Mass2Diam(MassList_3e)		//nm
						break
					case ksSP2calibMatAquaBlack162:
						//Tokai AquaBlack 162
						doalert 0, "The mass-mobility relationship used for AquaBlack 162 is provisional!!!"
						DiamList_1e=AquaBlack162Tokai_Mass2Diam(MassList_1e)		//nm
						DiamList_2e=AquaBlack162Tokai_Mass2Diam(MassList_2e)		//nm
						DiamList_3e=AquaBlack162Tokai_Mass2Diam(MassList_3e)		//nm
						break
					default:			
						//ERROR: calibration material not defined!
						setdatafolder $savedDF
						message="Calibration material '"+CalibBCtype+"' not defined in the function "+currproc+"!"
						print message; print RTStackInfo; abort message
				endswitch
				//calculate APM size distributions for size distributon slider
				HelpDiamMat_1e[][0]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_1e[][1,3]=DiamList_1e[p]
				HelpDiamMat_1e[][4]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_2e[][0]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_2e[][1,3]=DiamList_2e[p]
				HelpDiamMat_2e[][4]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_3e[][0]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_3e[][1,3]=DiamList_3e[p]
				HelpDiamMat_3e[][4]=nan			//width of APM size distribution still needs to be implemented
				HelpDiamMat_1e[][3]=nan		//avoid problem with overlapping dashed line
				HelpDiamMat_2e[][3]=nan		//avoid problem with overlapping dashed line
				HelpDiamMat_3e[][3]=nan		//avoid problem with overlapping dashed line
				break
		default:
			message="Undefined value of the parameter 'SelectorMode' in the function "+currproc+"!"
			print message; print RTStackInfo; abort message		
	endswitch
	//prepare various result waves
	variable LogDmin=1, LogDmax=3
	setdatafolder $TargetFldrFP
	make /o/n=(nSizeBins) $ksSP2calibDiamMidptScale
	wave DiamMidptScale=$ksSP2calibDiamMidptScale	
	//various variables and strings
	variable chanind, nPrevHistoBins, currEventBit
	string chanlist=SP2_ChanListIncandOnly()
	string descrlist=SP2_ChanListToDescrShortList(SP2_ChanListIncandOnly())
	variable nchans=itemsinlist(chanlist)
	variable slidergraphs=graphs
	string currPrefix, currDescript
	variable calind, currstart, currend, offset, delta, nIncPart, volume
	//loop over all incandescence channels and analyse calibration
	for (chanind=0; chanind<nchans; chanind+=1)
		//channel prefix
		currPrefix=stringfromlist(chanind,chanlist)
		currDescript=stringfromlist(chanind,descrlist)
		currEventBit=SP2chanPrefix2chanProperty(currPrefix, 0)
		//make sure that slider graphs are recreated if number of histogram bins change!
		nPrevHistoBins=nHistoBins
		wave /Z HistoMat=$currPrefix+ksSP2calibHistoMat
		if (waveexists(HistoMat))
			nPrevHistoBins=dimsize(HistoMat,1)
		endif
		//access calibration data
		string calibfldrfp=ksSP2PathToCalibDataFldr+CalibSubFldrNam
		setdatafolder QuoteLiberalPath(calibfldrfp)
		wave CalCoefExpanded=$currPrefix+ksSP2CalCoefBnam
		variable nSegmentsBroad=SP2_calibCurveSplineCheck(CalCoefExpanded)
		//access SP2 PBP waves
		setdatafolder $SP2PBPfldr
		wave FitPeakHt=$currPrefix+ksSP2PBPtracefitPeakHt
		//proceed only if peak height data from current channel are available 
		if (!waveexists(FitPeakHt))
			continue
		endif
		//steps only required for calculating number size distribution
		if (DistrMode)
			//further temporary waves
			setdatafolder $tmpfldrpath
			make /o/n=(nData) LogDiam=SP2peakHt2BCmass(FitPeakHt, CalCoefExpanded, nSegmentsBroad)		//write BC mass to LogDiam
			//calculate logarithm of BC-core diameter
			strswitch (CalibBCtype)
				case ksSP2calibMatConstMobDens:
					//use constant mobility density
					LogDiam=3+log(6*LogDiam[p]/pi/rho_eff)/3			//LogDiam contained mass till now
					break
				case ksSP2AquadagRCAST090904:
					//Aquadag (effective density data pers. comm. with RCAST on 04/09/2009) 
					nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var25(SplineCoefM2D)
					LogDiam=log(AquaDag_Mass2Diam(LogDiam[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2AquadagMotekiAST2010:
					//Aquadag (effective density data from Moteki et al., AST, 2010) 
					nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var25(SplineCoefM2D)
					LogDiam=log(AquaDag_Mass2Diam(LogDiam[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2AquadagClassicPSIOct2010:
					//Aquadag batch "classic" (effective density data from PSI measured with ETH APM in Oct 2010) 
					nSplineSegmM2D=Aquadag_RhoVsLogMspline_Var8(SplineCoefM2D)
					LogDiam=log(AquaDag_Mass2Diam(LogDiam[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2FullereneSootRCAST090904:
					//Fullerene Soot (effective density data pers. comm. with RCAST on 04/09/2009) 
					nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var2(SplineCoefM2D)
					LogDiam=log(FullereneSoot_Mass2Diam(LogDiam[p], 2, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2FullereneSootMotekiAST2010:
					//Fullerene Soot (effective density data from Moteki et al., AST, 2010) 
					nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var5(SplineCoefM2D)
					LogDiam=log(FullereneSoot_Mass2Diam(LogDiam[p], 5, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2FullereneSootPSIOct2010:
					//Fullerene Soot (effective density data from PSI measured with ETH APM in Oct 2010) 
					nSplineSegmM2D=Fullerene_RhoVsLogMspline_Var8(SplineCoefM2D)
					LogDiam=log(FullereneSoot_Mass2Diam(LogDiam[p], 8, SplineCoef=SplineCoefM2D, nSegmentsSpline=nSplineSegmM2D))		//LogDiam contained mass till now
					break
				case ksSP2GlassyCarbonAlphaAesar:
					//Alpha Aeaser glassy carbon spheres
					LogDiam=log(GlassyCarbonAlpha_Mass2Diam(LogDiam[p]))		//LogDiam contained mass till now
					break
				case ksSP2calibMatAquaBlack162:
					//Tokai AquaBlack 162
					doalert 0, "The mass-mobility relationship used for AquaBlack 162 is provisional!!!"
					LogDiam=log(AquaBlack162Tokai_Mass2Diam(LogDiam[p]))		//LogDiam contained mass till now
					break
				default:			
					//ERROR: calibration material not defined!
					setdatafolder $savedDF
					message="Calibration material '"+CalibBCtype+"' not defined in the function "+currproc+"!"
					print message; print RTStackInfo; abort message
					break
			endswitch
		endif
		//prepare waves for current channel
		setdatafolder $TargetFldrFP
		wave /Z FitPkHt_1e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
		if (!waveexists(FitPkHt_1e))	//create it if it doesn't yet exist
			make /o/n=(nCals) $currPrefix+ksSP2calibFitPkHt+ksSP2suffix1e=NaN	
			wave FitPkHt_1e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
		endif
		wave /Z FitPkHt_2e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix2e
		if (!waveexists(FitPkHt_2e))	//create it if it doesn't yet exist
			make /o/n=(nCals) $currPrefix+ksSP2calibFitPkHt+ksSP2suffix2e=NaN	
			wave FitPkHt_2e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix2e
		endif
		wave /Z FitPkHt_3e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix3e
		if (!waveexists(FitPkHt_3e))	//create it if it doesn't yet exist
			make /o/n=(nCals) $currPrefix+ksSP2calibFitPkHt+ksSP2suffix3e=NaN	
			wave FitPkHt_3e=$currPrefix+ksSP2calibFitPkHt+ksSP2suffix3e
		endif
		make /o/n=(nCals,nGauss) $currPrefix+ksSP2calibGaussAreaMat=NaN
		wave GaussAreaMat=$currPrefix+ksSP2calibGaussAreaMat
		make /o/n=(nCals,nGauss) $currPrefix+ksSP2calibGaussSigmaMat=NaN
		wave GaussSigmaMat=$currPrefix+ksSP2calibGaussSigmaMat
		make /o/n=(nCals,nGauss) $currPrefix+ksSP2calibGaussModeMat=NaN
		wave GaussModeMat=$currPrefix+ksSP2calibGaussModeMat
		make /o/n=(nCals,nGauss) $currPrefix+ksSP2calibGaussLogModeMat=NaN
		wave GaussLogModeMat=$currPrefix+ksSP2calibGaussLogModeMat
		make /o/n=(nCals,nHistoBins) $currPrefix+ksSP2calibHistoMat=NaN
		wave HistoMat=$currPrefix+ksSP2calibHistoMat
		make /o/n=(nCals,nHistoBins) $currPrefix+ksSP2calibHistoMatFitted=NaN
		wave HistoMatFitted=$currPrefix+ksSP2calibHistoMatFitted
		make /o/n=(nRawRows) $currPrefix+ksSP2calibLogFitPkHt=NaN
		wave LogFitPkHt=$currPrefix+ksSP2calibLogFitPkHt
		LogFitPkHt=log(FitPeakHt)
		make /o/n=(nCals) $currPrefix+ksSP2calibConcList=NaN
		wave IncandConcList=$currPrefix+ksSP2calibConcList
		make /o/n=(nCals,nSizeBins) $currPrefix+ksSP2calibdNdlogDpMat=NaN
		wave dNdlogDpMat=$currPrefix+ksSP2calibdNdlogDpMat
		note dNdlogDpMat, "arbitrary units;"
		note dNdlogDpMat, "diameter scale in the wave "+ksSP2calibDiamMidptScale+";"
		//loop over BC sizes measured during the calibration
		for (calind=0; calind<nCals; calind+=1)
			currstart=BinarySearch(TimeDate, TimeStartList[calind])
			currend=BinarySearch(TimeDate, TimeEndList[calind])
			//concentration of incandescent particles
			volume=SumNaNrange(SampleVolume, currstart, currend)		//m^3
			volume=UnitConverterMG(20, volume)						//=> cm^3
			nIncPart=BitNumberOfTrueInWave(Classification, currEventBit, startind=currstart, endind=currend)
			IncandConcList[calind]=nIncPart/volume
			//peak height histogram
			setscale /i x, log(1), log(kSP2signalAmpMax), tempHistogram
			Histogram/C/R=[currstart,currend]/B=2 LogFitPkHt, temphistogram
			HistoMat[calind][]=temphistogram[q]
			//fitting multiple Gaussians
			GaussianFITnPeaks(tempHistogram, TempGaussCoeff, nGauss=nGauss, StartPt=FirstHistoPt, EndPt=LastPt, FitRangeFact=FitRangeFact, FitGaussians=tempFittedHistogram)
			GaussAreaMat[calind][]=TempGaussCoeff[q][1]
			GaussSigmaMat[calind][]=TempGaussCoeff[q][2]
			GaussLogModeMat[calind][]=TempGaussCoeff[q][3]
			HistoMatFitted[calind][]=tempFittedHistogram[q]		
			//number size distribution dN/dlogDp
			if (DistrMode)
				setscale /i x, LogDmin, LogDmax, tempdNdlogDp
				Histogram/C/R=[currstart,currend]/B=2 LogDiam, tempdNdlogDp
				dNdlogDpMat[calind][]=tempdNdlogDp[q]
			endif
		endfor
		//channel specific post processing
			//wave scales
			setscale /i x, LogDmin, LogDmax, dNdlogDpMat
			ScaleCopyFromWavToWav(tempHistogram, 0, HistoMat, 1)	
			ScaleCopyFromWavToWav(tempHistogram, 0, HistoMat, 1)	
			ScaleCopyFromWavToWav(tempHistogram, 0, HistoMatFitted, 1)	
			GaussModeMat=10^GaussLogModeMat
			//counting efficiency
			setdatafolder $TargetFldrFP
			make /o/n=(nCals) $currPrefix+ksSP2calibCountEff=IncandConcList/ConcListCPC
		//show graphs
		if (graphs==1)
			//calibration summary
			SP2graph_IncandCalibResults(CalibFldrFP=TargetFldrFP, ChanDescr=currDescript)
		endif
		if (slidergraphs==1)
			//peak height histogram slider
			SP2_CalibBCAnalyzerSlider(ChanDescr=currDescript, CalibSummaryFP=TargetFldrFP, Omode=1)	
		endif
	endfor
	//general post processing
		//diameter scale to number size distribution matrices
		setscale /i x, LogDmin, LogDmax, DiamMidptScale
		DiamMidptScale=10^x
		//bandratio of calibration points
			//high gain
				variable HGavailable=0
				//access waves
				setdatafolder $TargetFldrFP
				wave /Z BBHG_FitPkHt_1e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
				wave /Z NBHG_FitPkHt_1e=$ksSP2NBHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
				wave /Z BBHG_FitPkHt_2e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
				wave /Z NBHG_FitPkHt_2e=$ksSP2NBHGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
				wave /Z BBHG_FitPkHt_3e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
				wave /Z NBHG_FitPkHt_3e=$ksSP2NBHGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
				//calculate bandratio 
				setdatafolder $TargetFldrFP
				if ( waveexists(BBHG_FitPkHt_1e) && waveexists(NBHG_FitPkHt_1e) )
					make /o/n=(nCals) $ksSP2calibBandRatHG+ksSP2suffix1e=BBHG_FitPkHt_1e/NBHG_FitPkHt_1e
					HGavailable=1
				endif
				if ( waveexists(BBHG_FitPkHt_2e) && waveexists(NBHG_FitPkHt_2e) )
					make /o/n=(nCals) $ksSP2calibBandRatHG+ksSP2suffix2e=BBHG_FitPkHt_2e/NBHG_FitPkHt_2e
				endif
				if ( waveexists(BBHG_FitPkHt_3e) && waveexists(NBHG_FitPkHt_3e) )
					make /o/n=(nCals) $ksSP2calibBandRatHG+ksSP2suffix3e=BBHG_FitPkHt_2e/NBHG_FitPkHt_3e
				endif
			//low gain
				variable LGavailable=0
				//access waves
				setdatafolder $TargetFldrFP
				wave /Z BBLG_FitPkHt_1e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
				wave /Z NBLG_FitPkHt_1e=$ksSP2NBLGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
				wave /Z BBLG_FitPkHt_2e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
				wave /Z NBLG_FitPkHt_2e=$ksSP2NBLGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
				wave /Z BBLG_FitPkHt_3e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
				wave /Z NBLG_FitPkHt_3e=$ksSP2NBLGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
				//calculate bandratio 
				setdatafolder $TargetFldrFP
				if ( waveexists(BBLG_FitPkHt_1e) && waveexists(NBLG_FitPkHt_1e) )
					make /o/n=(nCals) $ksSP2calibBandRatLG+ksSP2suffix1e=BBLG_FitPkHt_1e/NBLG_FitPkHt_1e
					LGavailable=1
				endif
				if ( waveexists(BBLG_FitPkHt_2e) && waveexists(NBLG_FitPkHt_2e) )
					make /o/n=(nCals) $ksSP2calibBandRatLG+ksSP2suffix2e=BBLG_FitPkHt_2e/NBLG_FitPkHt_2e
				endif
				if ( waveexists(BBLG_FitPkHt_3e) && waveexists(NBLG_FitPkHt_3e) )
					make /o/n=(nCals) $ksSP2calibBandRatLG+ksSP2suffix3e=BBLG_FitPkHt_2e/NBLG_FitPkHt_3e
				endif
		//bandratio statistics
		setdatafolder $TargetFldrFP
		wave /Z BandratHGperc50=$ksSP2pbpBandratHGPercBnam+"50"
		wave /Z BandratLGperc50=$ksSP2pbpBandratLGPercBnam+"50"
		if ( (!waveexists(BandratHGperc50)&&HGavailable) || (!waveexists(BandratLGperc50)&&LGavailable) )
			//do it only if it isn't done yet because it is slow
			SP2_PBPbandratioStats("", pbpfldrfp=SP2PBPfldr, targetfldrfp=TargetFldrFP, PercList="0.5", nPercBins=kSP2pbpBandRatioNbins, Xmin=kSP2pbpBandRatioXmin, Xmax=kSP2pbpBandRatioXmax, BRmode=0, startind=0, endind=inf)
			wave BandratHGperc50=$ksSP2pbpBandratHGPercBnam+"50"
			wave BandratLGperc50=$ksSP2pbpBandratLGPercBnam+"50"
		endif
		wave /Z BandratHGpercXctr50=$ksSP2pbpBandratHGPercBnam+"50"+ksSP2pbpBandratioXctrSuffix						
		wave /Z BandratHGPercNarrXctr50=$ksSP2pbpBandratHGPercBnam+"50"+ksSP2pbpBandratioNarrXctrSuffix						
		wave /Z BandratLGpercXctr50=$ksSP2pbpBandratLGPercBnam+"50"+ksSP2pbpBandratioXctrSuffix						
		wave /Z BandratLGPercNarrXctr50=$ksSP2pbpBandratLGPercBnam+"50"+ksSP2pbpBandratioNarrXctrSuffix						
		//convert broadband calibration points to narrowband calibration points using bandratio data
			//high gain
			setdatafolder $TargetFldrFP
			if ( waveexists(BandratHGperc50) && waveexists(BandratHGpercXctr50) ) 
				//1e
				if ( waveexists(BBHG_FitPkHt_1e) ) 
					make /o/n=(nCals) $ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix1e=NaN
					wave NBHGfromBBHG_FitPkHt_1e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix1e
					NBHGfromBBHG_FitPkHt_1e=BBHG_FitPkHt_1e[p]/(InterpLinearNaNTails(BBHG_FitPkHt_1e[p], BandratHGperc50, BandratHGpercXctr50))
				endif
				//2e
				if ( waveexists(BBHG_FitPkHt_2e) ) 
					make /o/n=(nCals) $ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix2e=NaN
					wave NBHGfromBBHG_FitPkHt_2e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix2e
					NBHGfromBBHG_FitPkHt_2e=BBHG_FitPkHt_2e[p]/(InterpLinearNaNTails(BBHG_FitPkHt_2e[p], BandratHGperc50, BandratHGpercXctr50))
				endif
				//3e
				if ( waveexists(BBHG_FitPkHt_3e) ) 
					make /o/n=(nCals) $ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix3e=NaN
					wave NBHGfromBBHG_FitPkHt_3e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix3e
					NBHGfromBBHG_FitPkHt_3e=BBHG_FitPkHt_3e[p]/(InterpLinearNaNTails(BBHG_FitPkHt_3e[p], BandratHGperc50, BandratHGpercXctr50))
				endif
			endif
			//low gain
			setdatafolder $TargetFldrFP
			if ( waveexists(BandratLGperc50) && waveexists(BandratLGpercXctr50) ) 
				//1e
				if ( waveexists(BBLG_FitPkHt_1e) ) 
					make /o/n=(nCals) $ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix1e=NaN
					wave NBLGfromBBLG_FitPkHt_1e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix1e
					NBLGfromBBLG_FitPkHt_1e=BBLG_FitPkHt_1e[p]/(InterpLinearNaNTails(BBLG_FitPkHt_1e[p], BandratLGperc50, BandratLGpercXctr50))
				endif
				//2e
				if ( waveexists(BBLG_FitPkHt_2e) ) 
					make /o/n=(nCals) $ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix2e=NaN
					wave NBLGfromBBLG_FitPkHt_2e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix2e
					NBLGfromBBLG_FitPkHt_2e=BBLG_FitPkHt_2e[p]/(InterpLinearNaNTails(BBLG_FitPkHt_2e[p], BandratLGperc50, BandratLGpercXctr50))
				endif
				//3e
				if ( waveexists(BBLG_FitPkHt_3e) ) 
					make /o/n=(nCals) $ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix3e=NaN
					wave NBLGfromBBLG_FitPkHt_3e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix3e
					NBLGfromBBLG_FitPkHt_3e=BBLG_FitPkHt_3e[p]/(InterpLinearNaNTails(BBLG_FitPkHt_3e[p], BandratLGperc50, BandratLGpercXctr50))
				endif
			endif
		//convert narrowband calibration points to broadband calibration points using bandratio data
			//high gain
			setdatafolder $TargetFldrFP
			if ( waveexists(BandratHGperc50) && waveexists(BandratHGPercNarrXctr50) ) 
				//1e
				if ( waveexists(NBHG_FitPkHt_1e) ) 
					make /o/n=(nCals) $ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix1e=NaN
					wave BBHGfromNBHG_FitPkHt_1e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix1e
					BBHGfromNBHG_FitPkHt_1e=NBHG_FitPkHt_1e[p]*(InterpLinearNaNTails(NBHG_FitPkHt_1e[p], BandratHGperc50, BandratHGPercNarrXctr50))
				endif
				//2e
				if ( waveexists(NBHG_FitPkHt_2e) ) 
					make /o/n=(nCals) $ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix2e=NaN
					wave BBHGfromNBHG_FitPkHt_2e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix2e
					BBHGfromNBHG_FitPkHt_2e=NBHG_FitPkHt_2e[p]*(InterpLinearNaNTails(NBHG_FitPkHt_2e[p], BandratHGperc50, BandratHGPercNarrXctr50))
				endif
				//3e
				if ( waveexists(NBHG_FitPkHt_3e) ) 
					make /o/n=(nCals) $ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix3e=NaN
					wave BBHGfromNBHG_FitPkHt_3e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix3e
					BBHGfromNBHG_FitPkHt_3e=NBHG_FitPkHt_3e[p]*(InterpLinearNaNTails(NBHG_FitPkHt_3e[p], BandratHGperc50, BandratHGPercNarrXctr50))
				endif
			endif
			//low gain
			setdatafolder $TargetFldrFP
			if ( waveexists(BandratLGperc50) && waveexists(BandratLGPercNarrXctr50) ) 
				//1e
				if ( waveexists(NBLG_FitPkHt_1e) ) 
					make /o/n=(nCals) $ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix1e=NaN
					wave BBLGfromNBLG_FitPkHt_1e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix1e
					BBLGfromNBLG_FitPkHt_1e=NBLG_FitPkHt_1e[p]*(InterpLinearNaNTails(NBLG_FitPkHt_1e[p], BandratLGperc50, BandratLGPercNarrXctr50))
				endif
				//2e
				if ( waveexists(NBLG_FitPkHt_2e) ) 
					make /o/n=(nCals) $ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix2e=NaN
					wave BBLGfromNBLG_FitPkHt_2e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix2e
					BBLGfromNBLG_FitPkHt_2e=NBLG_FitPkHt_2e[p]*(InterpLinearNaNTails(NBLG_FitPkHt_2e[p], BandratLGperc50, BandratLGPercNarrXctr50))
				endif
				//3e
				if ( waveexists(NBLG_FitPkHt_3e) ) 
					make /o/n=(nCals) $ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix3e=NaN
					wave BBLGfromNBLG_FitPkHt_3e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix3e
					BBLGfromNBLG_FitPkHt_3e=NBLG_FitPkHt_3e[p]*(InterpLinearNaNTails(NBLG_FitPkHt_3e[p], BandratLGperc50, BandratLGPercNarrXctr50))
				endif
			endif
	//display further graphs
	if (slidergraphs==1)
		//size distribution slider
		SP2_CalibBCSizeDistSlider(CalibSummaryFP=TargetFldrFP, Omode=1)
	endif
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	return 0
end



Function SP2_calib_CPCDMAdataPrepButt(ctrlname [, CPCDMAfldrFP, TC, press, IgnoreSecs]) : ButtonControl
	//This function is to be used for extracting the list of diameters and corresponding concentrations
	//from CPC-DMA-logger raw data.
	//return value: 0; not used
	//note: The CPC-DMA-logger data waves must be named as follows:
		//- diameter wave: DMAnm
		//- start time wave: TimeStart
		//- CPC concentration wave: CPCconc
		//- ...
	//note:	the temperature and pressure will be used in the subsequent SP2 calibration analysis to calculate the corresp. diameters of doubly and triply charged particles
	//		it might be worth checking the guessed values back with the available voltages/diameters
	//martin.gysel@psi.ch; 03/02/2009; 
	string ctrlname		//name of button control; not used
	string CPCDMAfldrFP	//full path to folder containing the CPC-DMA-logger data
						//default: browse for folder
	variable TC			//temperature [C]
						//note: this value is only used if the temperature wave is not available with the CPC/DMA data
						//default: prompt
	variable press		//pressure [mbar]
						//note: this value is only used if the pressure wave is not available with the CPC/DMA data
						//default: prompt
	variable IgnoreSecs	//seconds of data to be ignored after DMA setpoint change
						//default: prompt

	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(CPCDMAfldrFP))
		CPCDMAfldrFP=BrowseForFolder("Select folder containing the CPC-DMA-logger data:", StartPath=savedDF)
		if (stringmatch(CPCDMAfldrFP,"cancelled"))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message			
		endif
	endif
	if (paramisdefault(IgnoreSecs))
		IgnoreSecs=10
		prompt IgnoreSecs, "number of seconds to be ignored after DMA setpoint change [s]:"
		doprompt "Seconds to be Ignored", IgnoreSecs
		if (V_flag)
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message
			print RTStackInfo
			abort message					
		endif
	endif
	//access waves
	setdatafolder $CPCDMAfldrFP
	wave /Z TimeEnd=$ksCPCtimeEndPP
	wave /Z TimeStart=$ksCPCtimeStartPP
	wave /Z TimeCentre=$ksCPCtimeCentrePP
	wave /Z DMAnm=$ksCPCDMAnmPP
	wave /Z CPCconc=$ksCPCCPCconcPP
	wave /Z Temperature=$ksCPCtemperaturePP
	wave /Z Pressure=$ksCPCpressurePP
	variable nRows=dimsize(DMAnm,0)
	//create temperature wave if not available
	if (!waveexists(Temperature))
		if (paramisdefault(TC))
			TC=25
			prompt TC, "temperature [C]:"
			doprompt "Temperature", TC
			if (V_flag)
				setdatafolder $savedDF
				string /g RTStackInfo
				RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
				currproc=laststringfromlist(RTStackInfo)
				message="User cancelled procedure"+currproc+"!"
				print message
				print RTStackInfo
				abort message					
			endif
		endif
		make /o/n=(nRows) $ksCPCtemperaturePP=TC
		wave Temperature=$ksCPCtemperaturePP	
	endif
	//create pressure wave if not available
	if (!waveexists(Pressure))
		if (paramisdefault(press))
			press=1013
			prompt press, "pressure [mbar]:"
			doprompt "Pressure", press
			if (V_flag)
				setdatafolder $savedDF
				string /g RTStackInfo
				RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
				currproc=laststringfromlist(RTStackInfo)
				message="User cancelled procedure"+currproc+"!"
				print message
				print RTStackInfo
				abort message					
			endif
		endif
		make /o/n=(nRows) $ksCPCpressurePP=press
		wave Pressure=$ksCPCpressurePP
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2CPCDMA
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=(nRows) IndexList=p
	wave IndexList
	//prepare waves containing list of diameter set points and corresp. times, concentrations, ....
	setdatafolder $CPCDMAfldrFP	
	duplicate /o DMAnm, $ksSP2_monodi_DiamList
	wave DiamList=$ksSP2_monodi_DiamList
	duplicate /o TimeStart, $ksSP2_monodi_TimeStartList
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	setscale d 0,0,"dat", TimeStartList
	duplicate /o TimeEnd, $ksSP2_monodi_TimeEndList
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	setscale d 0,0,"dat", TimeEndList
	//extract list of diameter set points and corresp. times, concentrations, ....
	variable pind
	for (pind=nRows-1; pind>0; pind-=1)
		if (DiamList[pind]==DiamList[pind-1])
			DeletePoints pind, 1, DiamList, TimeStartList, IndexList
			DeletePoints pind-1, 1, TimeEndList
		endif
	endfor
	//adapt start times in order to ignore first couple of seconds of data after setpoint change
	TimeStartList+=IgnoreSecs
	//remap concentration, temperature and pressure onto new time scale
	variable nSetPt=dimsize(DiamList,0)
	variable RMind, firstPt, lastPt, EndReached
//	string PtsList
	setdatafolder $CPCDMAfldrFP	
	make /o/n=(nSetPt) $ksSP2_monodi_ConcList=NaN
	wave ConcList=$ksSP2_monodi_ConcList
	make /o/n=(nSetPt) $ksSP2_monodi_TClist=NaN
	wave TClist=$ksSP2_monodi_TClist
	note TClist, "temperature [C] in DMA;"
	note TClist, "used to calculate diameters of particles carrying multiple charges;"
	make /o/n=(nSetPt) $ksSP2_monodi_PressList=NaN
	wave PressList=$ksSP2_monodi_PressList	
	note PressList, "pressure [mbar] in DMA;"
	note PressList, "used to calculate diameters of particles carrying multiple charges;"
	for (rmind=0; rmind<nSetPt; rmind+=1)
		firstPt=IndexList[rmind]
		EndReached=1
		do	 
			if (TimeStartList[rmind]<=TimeStart[firstPt])
				EndReached=0
				break
			else
				firstPt+=1
			endif
		while (firstPt<nRows)
		if (EndReached==0)
			//data available
			lastPt=IndexList[rmind+1]
			firstPt=min(firstPt,lastPt)	//make sure that at least 1 point is included
			TimeStartList[rmind]=TimeStart[firstPt]
//			PtsList=num2str(firstPt)+"-"+num2str(lastPt)
			ConcList[rmind]=MeanNaNRange(CPCconc, FirstPt, LastPt)
			TClist[rmind]=MeanNaNRange(Temperature, FirstPt, LastPt)
			PressList[rmind]=MeanNaNRange(Pressure, FirstPt, LastPt)
		else
			//no data available
			TimeStartList[rmind]=NaN
//			PtsList="-"
		endif
	endfor
	//determine centre time
	setdatafolder $CPCDMAfldrFP	
	make /d/o/n=(nSetPt) $ksSP2_monodi_TimeCentreList
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	setscale d 0,0,"dat", TimeCentreList
	TimeCentreList=0.5*(TimeStartList+TimeEndList)
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


function SP2_LogNormFitButt(ctrlname [, pbpfldrfp, DmeasMin, DmeasMax, DfullMin, DfullMax, nDistrPts, showgraphs]) : ButtonControl
	//This function fits lognormal functions to measured SP2 number and mass size distributions
	//return value: 0; not used
	//martin.gysel@psi.ch; 18/02/2009, 06/11/2009, 22/11/2009, 29/04/2010
	//joel.c.corbin+sci@gmail.com; 2015-10-01, corrected DistribMomentumScaledWavRange to start from zero (was throwing an error)
	
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable DmeasMin	//minimum diameter of the measurement to be included in the fit and mass (number) calculation of the measurement
						//default: use panel setting
	variable DmeasMax	//maximum diameter of the measurement to be included in the fit and the mass (number) calculation of the measurement
						//default: use panel setting
						//note: the uppermost size bin, which contains the saturated particles, is not included in the fit
	variable DfullMin		//minimum diameter to be included in the mass (number) calculation of the fitted size distribution
						//note: this limit is also applied for calculating the BC mass below the cut of the measurement
						//default: use panel setting
	variable DfullMax		//maximum diameter to be included in the mass (number) calculation of the fitted size distribution
						//default: use panel setting
	variable nDistrPts		//number of points for fitted lognormal size distribution
						//default: use panel setting
	variable showgraphs	//1:	display graphs showing the results
						//0:			do not display graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//set defaults
	if (paramisdefault(pbpfldrfp))
// jcc		pbpfldrfp=BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		pbpfldrfp= SP2_getFolder(type="PBP") // jcc
	endif
	if (paramisdefault(DmeasMin))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDmeasMin=$ksSP2LogNormFitDmeasMin
		DmeasMin=LogNormFitDmeasMin
	endif	
	if (paramisdefault(DmeasMax))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDmeasMax=$ksSP2LogNormFitDmeasMax
		DmeasMax=LogNormFitDmeasMax
	endif	
	if (paramisdefault(DfullMin))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDfitMin=$ksSP2LogNormFitDfitMin
		DfullMin=LogNormFitDfitMin
	endif
	if (paramisdefault(DfullMax))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDfitMax=$ksSP2LogNormFitDfitMax
		DfullMax=LogNormFitDfitMax
	endif
	if (paramisdefault(nDistrPts))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitnPts=$ksSP2LogNormFitnPts	
		nDistrPts=LogNormFitnPts
	endif
	if (paramisdefault(showgraphs))
		showgraphs=1
	endif
	if (paramisdefault(showgraphs))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		showgraphs=AutoGraphCB
	endif
	//loop over all incandescence channels and fit lognormal size distributions
	string IncandList=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	variable nChans=itemsinlist(IncandList)
	variable cind
	string currPrefix
	for (cind=0; cind<nChans; cind+=1)
		currPrefix=stringfromlist(cind,IncandList)
		//access PBP data
		setdatafolder $pbpfldrfp
		wave /Z Inc_BCDistrDiamMidpt=$currPrefix+ksSP2pbpBCdistrDiamMid
		wave /Z Inc_BCnumbdistr=$currPrefix+ksSP2pbpBCnumbdistr
		wave /Z Inc_BCmassdistr=$currPrefix+ksSP2pbpBCmassdistr
		wave /Z Inc_DiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
		if (waveexists(Inc_BCDistrDiamMidpt))		//proceed only if data are available
			//prepare result waves
			setdatafolder $pbpfldrfp
			make /o/n=0 $currPrefix+ksSP2pbpLogNormFitDiamMidpt
			wave Inc_LogNormFitDiamMidpt=$currPrefix+ksSP2pbpLogNormFitDiamMidpt
			note Inc_LogNormFitDiamMidpt, "midpoint diameters of fitted lognormal size distributions;"
			make /o/n=0 $currPrefix+ksSP2pbpLogNormFitMassDistr
			wave Inc_LogNormFitMassDistr=$currPrefix+ksSP2pbpLogNormFitMassDistr
			note Inc_LogNormFitMassDistr, "fitted lognormal mass size distribution, dM/dlogDp [g/m];"
			note Inc_LogNormFitMassDistr, "diameter range considered for fitting: "+num2str(DmeasMin)+" to "+num2str(DmeasMax)+" nm;"
			make /o/n=0 $currPrefix+ksSP2pbpLogNormFitMassCoef
			wave Inc_LogNormFitMassCoef=$currPrefix+ksSP2pbpLogNormFitMassCoef
			note Inc_LogNormFitMassCoef, "coefficients of fitted lognormal mass size distributon (offset, area [g/m], geom. sigma [-], median Dp [nm]);"
			note Inc_LogNormFitMassCoef, "diameter range considered for fitting: "+num2str(DmeasMin)+" to "+num2str(DmeasMax)+" nm;"
			make /o/n=1 $currPrefix+ksSP2pbpLogNormFitMassBCconc
			wave Inc_LogNormFitMassBCconc=$currPrefix+ksSP2pbpLogNormFitMassBCconc
			note Inc_LogNormFitMassBCconc, "total BC mass concentration [g/m] of the fitted lognormal mass size distribution integrated between "+num2str(DfullMin)+" and "+num2str(DfullMax)+" nm;"
			make /o/n=0 $currPrefix+ksSP2pbpLogNormFitNumbDistr
			wave Inc_LogNormFitNumbDistr=$currPrefix+ksSP2pbpLogNormFitNumbDistr
			note Inc_LogNormFitNumbDistr, "fitted lognormal number size distribution, dN/dlogDp [#/cm];"
			note Inc_LogNormFitNumbDistr, "diameter range considered for fitting: "+num2str(DmeasMin)+" to "+num2str(DmeasMax)+" nm;"
			make /o/n=0 $currPrefix+ksSP2pbpLogNormFitNumbCoef
			wave Inc_LogNormFitNumbCoef=$currPrefix+ksSP2pbpLogNormFitNumbCoef
			note Inc_LogNormFitNumbCoef, "coefficients of fitted lognormal number size distributon (offset, area [#/cm], geom. sigma [-], median Dp [nm]);"
			note Inc_LogNormFitNumbCoef, "diameter range considered for fitting: "+num2str(DmeasMin)+" to "+num2str(DmeasMax)+" nm;"
			make /o/n=1 $currPrefix+ksSP2pbpLogNormFitNumbBCconc	
			wave Inc_LogNormFitNumbBCconc=$currPrefix+ksSP2pbpLogNormFitNumbBCconc			
			note Inc_LogNormFitNumbBCconc, "total BC core number concentration [#/cm] of the fitted lognormal number size distribution integrated between "+num2str(DfullMin)+" and "+num2str(DfullMax)+" nm;"
			//fit mass and number size distribution 
			Inc_LogNormFitMassBCconc=imag(SP2_LogNormSizeDistrFit(Inc_BCmassdistr, Inc_BCDistrDiamMidpt, DmeasMin=DmeasMin, DmeasMax=DmeasMax, DfullMin=DfullMin, DfullMax=DfullMax, LogNormParam=Inc_LogNormFitMassCoef, dYdlogDpFitted=Inc_LogNormFitMassDistr, DpScaleFitted=Inc_LogNormFitDiamMidpt, nDistrPts=nDistrPts))
			Inc_LogNormFitNumbBCconc=imag(SP2_LogNormSizeDistrFit(Inc_BCnumbdistr, Inc_BCDistrDiamMidpt, DmeasMin=DmeasMin, DmeasMax=DmeasMax, DfullMin=DfullMin, DfullMax=DfullMax, LogNormParam=Inc_LogNormFitNumbCoef, dYdlogDpFitted=Inc_LogNormFitNumbDistr, DpScaleFitted=Inc_LogNormFitDiamMidpt, nDistrPts=nDistrPts))
			//calculate number and mass concentration of BC below cut-off diameter of measurement
			make /o/n=(1) $currPrefix+ksSP2pbpBCtotalnumbconcBelowCut=DistribMomentumScaledWavRange(Inc_LogNormFitNumbDistr, 0, 1, xmin=0, xmax=log(Inc_DiamCutLow[0]))
			wave Inc_BCtotalnumbconcBelowCut=$currPrefix+ksSP2pbpBCtotalnumbconcBelowCut
			note Inc_BCtotalnumbconcBelowCut, "total number concentration of BC particles below cut-off diameter [#/cm];"
			make /o/n=(1) $currPrefix+ksSP2pbpBCtotalmassconcBelowCut=DistribMomentumScaledWavRange(Inc_LogNormFitmassDistr, 0, 1, xmin=0, xmax=log(Inc_DiamCutLow[0]))
			wave Inc_BCtotalmassconcBelowCut=$currPrefix+ksSP2pbpBCtotalmassconcBelowCut
			note Inc_BCtotalmassconcBelowCut, "total mass concentration of BC particles below cut-off diameter channel [g/m];"					
		endif		
	endfor
	//show graphs
	if (showgraphs)
		SP2graph_NumbSizeDistrBC(pbpfldrfp=pbpfldrfp)
		SP2graph_MassSizeDistrBC(pbpfldrfp=pbpfldrfp)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end



Function /S SP2_LoadRawData(ctrlname [RawDataFileFP, RawDataDir, LoadType, FileDateString, FileNumList, ConcatMode, TAmode, LEOTAmode, ChannelBitsTA, ChannelBitsLoad, DelBits, PPmode, FitLogNorm, Omode, HKloadMode, hkfldrfp, FractMode, LoadOutOfEvery, MaxDataRate]) : ButtonControl
	//This function loads SP2 raw data
	//return string: list full paths to folders containing the raw data that have been loaded
	//martin.gysel@psi.ch;	01/11/2008, 03/11/2008, 05/11/2008, 09/11/2008,12/11/2008, 25/11/2008, 10/06/2009, 10/07/2009, 12/07/2009, 13/07/2009, 15/08/2009, 26/04/2010;
	//						13/08/2010, 16/08/2010, 09/09/2010, 28/09/2010, 21/10/2010
	// joel.c.corbin@gmail.com 2015-09-18: added multiple-selection dialog option
	// joel.c.corbin@gmail.com 2015-09-21: added subfolder-loading option
	//things to be done:
	//	- write an extra (button-) procedure for concatenating the raw and configuration data, if this is possible
	//	- ....
	string ctrlname
	string RawDataFileFP	// full path to file containing the raw data to be loaded
							// only used if LoadType=1
							// default: browse for file
	string RawDataDir		// full path to directory containing the raw data to be loaded
							// note:	- Sub-directories are included!
							//			- only used if LoadType=2 or 3
							//default: browse for directory
	variable LoadType			//1:		load a single file
								//2:		load all files from data folder
								//3:		load files according to list provided in 'FileNumList' along with 'FileDateString'
								//			note: this option allows only to load files with equal date string in the file name
								//4:		load from multiple selection (via Open dialog)		
								//5:		load all .sp2b files in all subfolders [new in v4111]
								//6:		attempt to load exactly the same files as last time [new in v4111]
							//default:	use panel setting
	string FileDateString		//only used if LoadType=3;
							//date string in names of files to be loaded
							//format: "YYYYMMDD"
							//e.g: "20081123"
							//default: prompt
	string FileNumList		//only used if LoadType=3;
							//list of file numbers to be loaded (date in file name is taken from 'FileDateString')
							//e.g.: "3-4;6-7"		this would load the files 20081123x003, 20081123x004, 20081123x006, 20081123x007
							//default: prompt
	variable ConcatMode		//1:			raw data folders of individual files are concatenated into the first folder
							//0:			raw data folders of individual files are not concatenated
							//default:	use panel setting
	variable TAmode			//1:			analyse traces
							//0:			do not analyse traces 
							//default:	use panel setting
	variable LEOTAmode		//1:	run LEO-fit trace analysis
							//0:	no LEO-fit
							//default: use panel setting
							//note: channel selection according to panel settings
	variable ChannelBitsTA		//bitwise parameter determining which data channels are to be analysed
							//bit0=1 true: analyse scattering channel
							//bit1=2 true: analyse broadband incandescence channel
							//bit2=4 true: analyse narrowband incandescence channel
							//bit3=8 true: analyse split detector channel
							//default: use panel settings

	variable ChannelBitsLoad	//bitwise parameter determining which data channels are to be loaded (if available)
							//note: any changes to this variable must be coordinated with internal variables provided below
							//bit0=1 true: load high gain scattering channel
							//bit1=2 true: load high gain broadband incandescence channel
							//bit2=4 true: load high gain narrowband incandescence channel
							//bit3=8 true: load high gain split detector channel
							//bit4=16 true: load low gain scattering channel
							//bit5=32 true: load low gain broadband incandescence channel
							//bit6=64 true: load low gain narrowband incandescence channel
							//bit7=128 true: load low gain split detector channel
							//default: use panel settings
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0  => no raw traces are deleted
					//DelBits>0  => selected raw traces are deleted
					//see sub-procedure for meaning of the individual bits
					//default: use panel setting (all or nothing deleted)
	variable PPmode			//1:			run post processing after trace analysis
							//0:			do not run post processing
							//default:	use panel setting
							//note: the post processing is only done if TAmode==1
	variable FitLogNorm		//1:			fit lognormal size distributions
							//0:			do not fit lognormal size distributions
							//default:		use panel settings
							//note: panel settings are used for the diameter range considered in the fit!
	variable Omode			//1 (default):	overwrite existing data
							//0:			prompt if data folder exists already
	variable HKloadMode		//0:			do not load housekeeping data
							//1:			load housekeeping data
							//default:		use panel setting
	string hkfldrfp				//full path to housekeeping folder
							//note: only required if housekeeping files are not loaded and if sample flow rate or YAG power are to be take from housekeeping data
							//default: browse for folder if required
	variable FractMode		//0:	load fraction of particles according to variable "LoadOutOfEvery"
							//1:	restrict fraction of loaded particles such the the maximum data rate "MaxDataRate" is not exceeded
							//default:		use panel setting
	variable LoadOutOfEvery	//LoadOutOfEvery=5 means that only 1 out of every 5 triggered particles is loaded
							//default: use panel setting
	variable MaxDataRate		//restricts the number of loaded particles
							//unit: 1000 particles / hour
							//i.e: MaxDataRate=5, means that only every second particle is loaded from a file which contains 50'000 particles measured in 5 hours (data rate of file = 10 k#/h)
							//default:		use panel setting
	
	//internal variables
	variable PrintInfo=1
	variable scattbit=1, broadbit=2, narrbit=4, splitbit=8, SCLGbit=16, BBLGbit=32, NBLGbit=64, SPLGbit=128		//these bit values define the meaning of "ChannelBitsLoad"
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	MSTimer_ResetAll()							//reset all timers
	//set default values
	if (paramisdefault(LoadType))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadTypeGlob=$ksSP2LoadType
		LoadType=LoadTypeGlob
	endif
	if (paramisdefault(Omode))
		Omode=1
	endif
	if (paramisdefault(ConcatMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar ConcatModeGlob=$ksSP2loadConcatMode
		ConcatMode=ConcatModeGlob	
	endif
	if (paramisdefault(TAmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar analyseTraces=$ksSP2analyseTraces
		TAmode=analyseTraces
	endif
	if (paramisdefault(LEOTAmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar performLEOfit=$ksSP2performLEOfit
		LEOTAmode=performLEOfit
	endif
	string BeamShapeFldrFP=""
	if (LEOTAmode && TAmode)
		BeamShapeFldrFP=SP2_getBeamShapeFolder() // BrowseForFolder("Select folder containing the beam shape data:", StartPath=savedDF, AbortMode=1, selectStr="*BeamAndCalib*")
		BeamShapeFldrFP=ChopLastCharacterOff(BeamShapeFldrFP,":")
	endif
	if (paramisdefault(ChannelBitsTA))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar fitSCHG=$ksSP2fitSCHGchan
		Nvar fitBBHG=$ksSP2fitBBHGchan
		Nvar fitNBHG=$ksSP2fitNBHGchan
		Nvar fitSPHG=$ksSP2fitSPHGchan		
		Nvar fitSCLG=$ksSP2fitSCLGchan
		Nvar fitBBLG=$ksSP2fitBBLGchan
		Nvar fitNBLG=$ksSP2fitNBLGchan
		Nvar fitSPLG=$ksSP2fitSPLGchan
		ChannelBitsTA=fitSCHG*2^0+fitBBHG*2^1+fitNBHG*2^2+fitSPHG*2^3+fitSCLG*2^4+fitBBLG*2^5+fitNBLG*2^6+fitSPLG*2^7
	endif
	if (paramisdefault(ChannelBitsLoad))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar loadscatt=$ksSP2loadSCHGchan
		Nvar loadbroad=$ksSP2loadBBHGchan
		Nvar loadnarr=$ksSP2loadNBHGchan
		Nvar loadsplit=$ksSP2loadSPHGchan
		Nvar loadSCLG=$ksSP2loadSCLGchan
		Nvar loadBBLG=$ksSP2loadBBLGchan
		Nvar loadNBLG=$ksSP2loadNBLGchan
		Nvar loadSPLG=$ksSP2loadSPLGchan
		ChannelBitsLoad=loadscatt*scattbit+loadbroad*broadbit+loadnarr*narrbit+loadsplit*splitbit+loadSCLG*SCLGbit+loadBBLG*BBLGbit+loadNBLG*NBLGbit+loadSPLG*SPLGbit
	endif
	if (paramisdefault(DelBits))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar rawdatadelmode=$ksSP2rawdatadelmode
		DelBits=rawdatadelmode*(2^16-1)		//delete all raw traces and other unneccessary waves
	endif
	if (paramisdefault(PPmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar postprocessing=$ksSP2postProcessing
		PPmode=postprocessing
	endif
	if (paramisdefault(FitLogNorm))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PanelFitLogNorm=$ksSP2lognormfit	
		FitLogNorm=PanelFitLogNorm
	endif		
	
	if (LoadType==6) 
		// this option ends up calling the current function again, so just do it early
		return SP2_repeatLastLoad(interact=0)
	endif
	
	if (LoadType==3)
		if (paramisdefault(FileDateString))
			// load last saved file date string (gets saved below) --// jcc
			SVAR /Z lastFileDateString= root:SP2toolkit:FileDateString
			if (SVAR_Exists(lastFileDateString))
				FileDateString= lastFileDateString
			else
				FileDateString="YYYYMMDD"
			endif
		endif
		if (paramisdefault(FileNumList))
			SVAR /Z lastFileNumList= root:SP2toolkit:FileNumList
			if (SVAR_Exists(lastFileNumList))
				FileNumList= lastFileNumList
			else
				FileNumList="1;"
			endif
		endif
		if (paramisdefault(FileDateString) || paramisdefault(FileNumList))
			prompt FileDateString, "date string in names of files to be loaded:"
			prompt FileNumList, "list of file numbers to be loaded (e.g: \"2-5;8;10-14\")"
			doprompt "List of files to be loaded:", FileDateString, FileNumList
			if (V_flag)
				SP2_abort("")		
			else
				string/G root:SP2toolkit:FileDateString= FileDateString // save for next time --// jcc
				string/G root:SP2toolkit:FileNumList= FileNumList // save for next time --// jcc
			endif	
		endif
	endif
	
	// PREPARE LOADING PARAMETERS [LoadTypes are defined in Switch below!
	//get directory or file path if needed
	if (LoadType==1) 
		if (paramisdefault(RawDataFileFP))
			SVAR /Z lastRawDataFileFP= root:SP2toolkit:lastRawDataFileFP // saved from last time (potentially) // jcc
			if (SVAR_Exists(lastRawDataFileFP))
				RawDataFileFP= lastRawDataFileFP
			endif
			RawDataFileFP=BrowseForFile(DialogStr="Select 'SP2B'-file to be loaded", TypeStr=ksSP2datafileType)
			if (stringmatch(RawDataFileFP,"cancelled"))
				SP2_abort("")
			else
				string/G root:SP2toolkit:lastRawDataFileFP= RawDataFileFP // save for next time
			endif
		endif
		RawDataFileFP=ChopLastCharacterOff(RawDataFileFP,":")
	elseif (LoadType==2 || LoadType==3 || LoadType==4 || LoadType==5)
		// set data path 
		if (paramisdefault(RawDataDir))
			newpath /o/m="Select folder containing the 'SP2B'-files to be loaded."/q NewDataPath
			if (V_flag != 0)												//abort execution if "cancel"-button is pressed
				SP2_abort("")		
			endif
			PathInfo NewDataPath
			RawDataDir=S_path
			RawDataDir=choplastcharacteroff(RawDataDir, ":")
		else
			// make data path anyway, for Open when LoadType==4 [possibly, this never gets evaluated given the OR above...]
			newpath /o/q NewDataPath, RawDataDir
		endif	
	endif
	if (LoadType==5) // jcc added v4111
		// Either load all subfolders directly into one folder,
		// or run the load-all-in-folder version of this function on each
		// folder in the provided directly.
		// The second one is often more convenient.
		string Salert= "Create one Igor data folder per SP2 folder? (== per day)"
		Salert+= "\r\r('Yes' is recommended to avoid memory problems.)"
		DoAlert/T="Type of multiple-file load" 2, Salert
		if (V_flag==1) // yes
			// User should use this function, which remote-controls the SP2 toolkit and is more flexible:
			variable loadHK=1, fileStep=1, delAllRaw=0, delPBP=0
			prompt loadHK, "Load HK data as well:", popup, "1;0"
			prompt fileStep, "Load 1 of <<n>> files"
//			prompt delAllRaw, "Delete[!] raw DFs after load?:", popup, "0;1"
			prompt delPBP, "Clear PBP folders after load?:", popup, "0;1"
			doprompt "Input options:", loadHK, fileStep, delPBP
			if (V_flag==1) // cancel
				SP2_abort("User cancelled")
			endif
			
			// next 3 lines are necessary because the popup result counts from 0, not 1
			loadHK= loadHK==1 ? 1 : 0
			delAllRaw= 0 // permanently disabled... only from command line this dangerous option. delAllRaw -= 1
			delPBP -= 1
			return num2str(SP2_load_multiple_days(folderPath=RawDataDir, loadHK=loadHK, fileStep=fileStep, deleteEntireRawDFs=delAllRaw, deletePBPdata=delPBP))
//			print "\rSP2_load_multiple_days(folderPath=\""+RawDataDir+"\", loadHK=1, fileStep=1, deleteEntireRawDFs=0, deletePBPdata=0)"; return ""
		elseif(V_flag==2) // no
			// Load subfolders as though all files are in one group -- this just needs a change in the file search flag
			// done here because it also applies to HK and INI files
			variable noSubDirs= 0
		else // 3, cancel
			SP2_abort("User cancelled")
		endif
		
	else
		noSubDirs= 1
	endif
	
	if (paramisdefault(HKloadMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar HKloadModeGlob=$ksSP2loadHKmode
		HKloadMode=HKloadModeGlob	
	endif
	if (paramisdefault(FractMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadFractMode=$ksSP2LoadFractMode
		FractMode=LoadFractMode
	endif
	if (paramisdefault(LoadOutOfEvery))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadOneOutOfGlobal=$ksSP2LoadOneOutOf
		LoadOutOfEvery=LoadOneOutOfGlobal
	endif
	if (paramisdefault(MaxDataRate))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadMaxDataRate=$ksSP2LoadMaxDataRate
		MaxDataRate=LoadMaxDataRate
	endif
	//access further panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SampleFlowModePanel=$ksSP2sampleFlowMode
	Nvar YAGpowerModePanel=$ksSP2YAGpowerMode
	//browse for housekeeping folder if needed
	if (paramisdefault(hkfldrfp))
		hkfldrfp=""
		//path to existing HK data is not provided
		if (HKloadMode==0)	
			//HK files are not loaded
			if (SampleFlowModePanel==0 || YAGpowerModePanel==0)
				//HK data are required => browse for HK-folder
				hkfldrfp=SP2_getFolder(type="HK", startingDF="root:") // BrowseForFolder("Select housekeeping data folder:", StartPath=savedDF)
				if (stringmatch(hkfldrfp, "cancelled"))		
					setdatafolder $savedDF
					message="User cancelled the procedure "+currproc+"!"
					print message; print RTStackInfo; abort message
				endif	
			endif
		endif
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2loadRawData
	string tmpfldrpath=getdatafolder(1)
	//get list of files to be loaded
	string filepathlist
	switch(LoadType)
		case 1:
			//load single file		
			filepathlist=RawDataFileFP+";"			
			RawDataDir=RemoveLastItemFromList(RawDataFileFP, ListSepStr=":")
			break	
		case 2:
			//load all files in raw data folder	-- noSubDirs=1
			filepathlist=ListOfAllFilesInDirAndSubDir2(RawDataDir, SubDirMode=noSubDirs, PathMode=1, fileExtStr=ksSP2datafileEnd, ShortcutMode=1)
			break
		case 3:
			//load files according to list provided in 'FileNumList' along with 'FileDateString'
			setdatafolder $tmpfldrpath
			make /o NumListWav
			wave NumListWav
			NumberList_to_IndexWave_Parser(FileNumList, NumListWav, INFval=10^kSP2fileIDndigits-1)
			variable nfiles=numpnts(NumListWav)
			variable nind, dateval
			string currfilenamstr
			filepathlist=""
			for (nind=0; nind<nfiles; nind+=1)
				dateval=TimeTextToIgorTimeNoSepStr(FileDateString+" 000000", nYearChars=4)
				currfilenamstr=SP2uniqueFileID2filenamebody(dateval+NumListWav[nind])+ksSP2datafileEnd
				filepathlist+=RawDataDir+":"+currfilenamstr+";"
			endfor
			break
		case 4:		
			// v4111 jcc : user selects multiple files via "Open" dialog
			if (ParamIsDefault(RawDataFileFP)) 
				string S_case4popup = "SP2 data files (*.%s,):.%s;SP2 %s files (*.%s):.%s;All Files:.*;"
				sprintf S_case4popup, S_case4popup, ksSP2datafileType, ksSP2datafileType, ksSP2datafileType ,ksSP2datafileType ,ksSP2datafileType
				Open /MULT=1 /P=NewDataPath/R/D /F=S_case4popup /M="Select SP2 file(s) to load..." afile // generates S_fileName, a \r-list of selected files
				if (V_flag==-1)
					SP2_abort("")
				endif
				filepathlist = replaceString("\r", S_fileName, ";")  // list of files
			else 
				// assume user knows what she is doing (likely repeating a load)...
				filepathlist= RawDataFileFP
			endif
			RawDataFileFP= stringFromList(0,filepathlist) // provide one file path for the HK loading below
			RawDataDir=RemoveLastItemFromList(RawDataFileFP, ListSepStr=":")
			break
		case 5:		
			// v4111 jcc : Load files in subfolders -- similar to LoadType==2, but with noSubDirs=0 above
			filepathlist=ListOfAllFilesInDirAndSubDir2(RawDataDir, SubDirMode=noSubDirs, PathMode=1, fileExtStr=ksSP2datafileEnd, ShortcutMode=1)
			break
		default:						
	endswitch
	RawDataDir=ChopLastCharacterOff(RawDataDir,":")
	filepathlist=SortList(filepathlist)
	string filenamlist=replacestring(RawDataDir+":",filepathlist,"")
	variable nSP2B=itemsinlist(filepathlist)
	
	// jcc -- avoid creating too many graphs
	if (nSP2B > 3)
		NVAR /Z AutoGraphCB=$(ksSP2PathToToolkitPanelFldr + ksSP2autoGraphCB)
		if (NVAR_Exists(AutoGraphCB) && AutoGraphCB && ConcatMode==0)
			string graphwarning = "You are about to load %g files and generate separate graphs for each. Disable graphs first?"
			sprintf graphwarning, graphwarning, itemsInList(filepathlist)
			DoAlert 1, graphwarning
			if (V_flag==1)
				AutoGraphCB=0
			endif
		endif
	elseif (nSP2B==0)
		SP2_postErrorMsg("No files found in chosen folder " + RawDataDir)
	endif
	
	//preparations for HK file loading
	if (HKloadMode)
		//HK-specific temporary folder
		CreateFoldersOfFullPath(ksSP2hkLoadTempFldrFP, 0)
		setdatafolder $ksSP2hkLoadTempFldrFP
		//load info strings and variables
		string /g $ksSP2hkLoadLastHKfileNam=""
		Svar LastHKfileNam=$ksSP2hkLoadLastHKfileNam
		string /g $ksSP2hkLoadLastHKfldrFP=""
		Svar LastHKfldrFP=$ksSP2hkLoadLastHKfldrFP
		variable /g $ksSP2hkLoadFileNameFormatPP=NaN
		Nvar hkFileNameFormat=$ksSP2hkLoadFileNameFormatPP
		string /g $ksSP2hkLoadDataDir=ChopLastCharacterOff(RawDataDir,":")		//trailing ":" must be removed!
		Svar HKdataDir=$ksSP2hkLoadDataDir
		//get list of all HK files
		string HKfileList
		HKfileList=ListOfAllFilesInDirAndSubDir2(RawDataDir, SubDirMode=noSubDirs, PathMode=0, fileExtStr=ksSP2hkFileEnd, ShortcutMode=1)
		variable nHKfiles=itemsinlist(HKfileList)
		//list of HK file names, file times and file numbers
		make /o/t/n=(nHKfiles) $ksSP2hkLoadFileNamesPP=parseFilePath(0, stringfromlist(p,HKfileList), ":", 1, 0) // jcc -- was Replacestring(":",stringfromlist(p,HKfileList),"") ...note this is copy pasted below for ini as well
		wave /t HKfileNames=$ksSP2hkLoadFileNamesPP
		make /o/d/n=(nHKfiles) $ksSP2hkLoadFileTimesPP=NaN
		wave /d hkFileTimes=$ksSP2hkLoadFileTimesPP
		
		make /o/t/n=(nHKfiles) HKfilePaths= ReplaceString(":",stringFromList(p,HKfileList),HKdataDir + ":", 0, 1) // jcc -- save entire paths for when LoadType=5. (this is not a HKpretty way to do it...)
		
		setscale d 0,0,"dat", hkFileTimes
		//determine file name format and write file times or numbers
		if (strlen(HKfileNames[0])==15)
			//YYYYMMDDxnnn.hk
			hkFileNameFormat=kSP2hkNamesWithDateAndFileNum
			hkFileTimes=SP2filename2UniqueFileID(HKfileNames[p])
		elseif (strlen(HKfileNames[0])==17)
			//YYYYMMDDhhmmss.hk
			hkFileNameFormat=kSP2hkNamesWithDateTimeStr
			hkFileTimes=TimeTextToIgorTimeNoSepStr(HKfileNames[p], nYearChars=4)
		else
			//unknown format of HK file names
			hkFileNameFormat=NaN
			hkFileTimes=NaN
		endif
	endif
	//preparations for INI file loading
		//INI-specific temporary folder
		CreateFoldersOfFullPath(ksSP2iniLoadTempFldrFP, 0)
		setdatafolder $ksSP2iniLoadTempFldrFP
		//load info strings and variables
		variable /g $ksSP2iniLoadFileNameFormatPP=NaN
		Nvar iniFileNameFormat=$ksSP2iniLoadFileNameFormatPP
		string /g $ksSP2iniLoadDataDir=ChopLastCharacterOff(RawDataDir,":")		//trailing ":" must be removed!
		Svar INIdataDir=$ksSP2iniLoadDataDir
		//get list of all INI files
		string INIfileList=ListOfAllFilesInDirAndSubDir2(RawDataDir, SubDirMode=noSubDirs, PathMode=0, fileExtStr=ksSP2iniFileEnd, ShortcutMode=1)
		variable nINIfiles=itemsinlist(INIfileList)
		//list of INI file names, file times and file numbers
		make /o/t/n=(nINIfiles) $ksSP2iniLoadFileNamesPP=parseFilePath(0, stringfromlist(p,INIfileList), ":", 1, 0) // jcc -- was Replacestring(":",stringfromlist(p,INIfileList),"")
		wave /t INIfileNames=$ksSP2iniLoadFileNamesPP
		make /o/d/n=(nINIfiles) $ksSP2iniLoadFileTimesPP=NaN
		wave /d iniFileTimes=$ksSP2iniLoadFileTimesPP
		make /o/t/n=(nINIfiles) INIfilePaths= ReplaceString(":",stringFromList(p,INIfileList),INIdataDir + ":", 0, 1) // jcc -- save entire paths for when LoadType=5. (this is not a INIpretty way to do it...)
		setscale d 0,0,"dat", iniFileTimes
		//determine file name format and write file times or numbers
		if (strlen(INIfileNames[0])==16)
			//YYYYMMDDxnnn.ini
			iniFileNameFormat=kSP2iniNamesWithDateAndFileNum
			iniFileTimes=SP2filename2UniqueFileID(INIfileNames[p])
		elseif (strlen(INIfileNames[0])==18)
			//YYYYMMDDhhmmss.ini
			iniFileNameFormat=kSP2iniNamesWithDateTimeStr
			iniFileTimes=TimeTextToIgorTimeNoSepStr(INIfileNames[p], nYearChars=4)
		else
			//unknown format of INI file names
			iniFileNameFormat=NaN
			iniFileTimes=NaN
		endif
	//loop over loading files
	variable find, hind
	string currfilefp, currfilename
	string currrawfldrfp, rawdatafldrlist=""
	string rawmainfp
	variable rawmaindim, rawappdim, tracelenmain, tracelenapp
	variable rawfileloaded, firstrawfile=0
	string hkfilefp, hkfilenam, hkfiledir
	string hkmainfp
	variable hkmaindim, hkappdim
	variable hkfileloaded, firsthkfile=0
	string inifilefp, inifldrfp, inifilenam, inifiledir
	string PBPmainfp
	string loadinfostr
	for (find=0; find<nSP2B; find+=1)
		//current file path and name
		currfilefp=stringfromlist(find,filepathlist)
		currfilename=LastStringFromList(currfilefp,ListSepStr=":")
		currfilename=replacestring(ksShortcutFileExtWindows,currfilename,"")
		currfilename=replacestring(ksSP2datafileEnd,currfilename,"")
		currrawfldrfp=ksSP2defRawLoadPartentFldr+SP2filename2RawDataFldrNam(currfilename)
		currrawfldrfp=QuoteLiberalPath(currrawfldrfp)
		//load binary raw data file as well as most recent configuration and housekeeping files
		loadinfostr=SP2_Load_BinaryFile_MT(currfilefp, currrawfldrfp, Omode, printinfo=printinfo, loadini=2, loadHK=HKloadMode, LoadOutOfEvery=LoadOutOfEvery, FractMode=FractMode, MaxDataRate=MaxDataRate, ChannelBitsLoad=ChannelBitsLoad)
		//get info on success of loading attempt
		currrawfldrfp=stringfromlist(0,loadinfostr)
		if (strlen(currrawfldrfp)>1)
			rawfileloaded=1
		else
			rawfileloaded=0
		endif
		hkfileloaded=str2num(stringfromlist(2,loadinfostr))
		if (hkfileloaded>0)
			//new housekeeping file loaded => update path to HK-folder
			hkfldrfp=stringfromlist(3,loadinfostr)
		endif
		//trace analysis and post processing
		if (rawfileloaded==1)
			//get sample flow rate
			SP2sampleFlowGetData(SP2rawFldrFP=currrawfldrfp, HKfldrFP=hkfldrfp, FromMode=SampleFlowModePanel)
			//get laser power
			SP2_YAGpowerGetHKdata("", SP2rawFldrFP=currrawfldrfp, HKfldrFP=hkfldrfp, HKmode=YAGpowerModePanel)
			//trace analysis and post processing
			if (TAmode==1 && ConcatMode==0)
				//analyse traces including post processing if selected
				SP2_AnalyseRawTraces(rawfldrfp=currrawfldrfp, LEOTAmode=LEOTAmode, BeamShapeFldrFP=BeamShapeFldrFP, PPmode=PPmode, DelBits=DelBits, ChannelBits=ChannelBitsTA)
			elseif (TAmode==1 && ConcatMode==1)
				//analyse traces, postpone postprocessing after concatenating
				SP2_AnalyseRawTraces(rawfldrfp=currrawfldrfp, LEOTAmode=LEOTAmode, BeamShapeFldrFP=BeamShapeFldrFP, PPmode=0, DelBits=DelBits, ChannelBits=ChannelBitsTA)				
			else	
				//do not analyse traces => nothing to be done
			endif
		endif
		//concatenate raw, configuration, housekeeping and PBP data if chosen to do so
		if (ConcatMode==1 && rawfileloaded)
			//concatenate raw data
			if (firstrawfile==0)	//first file loaded => concatenating is obsolet
				firstrawfile=1
				rawdatafldrlist+=currrawfldrfp+";"	//update list of loaded files
				rawmainfp=currrawfldrfp
			else		//concatenate
				SP2_ConcatenateRawDataFldrs("", MainRawFldrFP=rawmainfp, AppendRawFldrFP=currrawfldrfp)
			endif
		else
			//do not concatenate
			rawdatafldrlist+=currrawfldrfp+";"	//update list of loaded files
		endif		
		//concatenate housekeeping data
		if (ConcatMode==1 && hkfileloaded==1)
			//housekeeping file has been loaded => concatenate
			if (firsthkfile==0)	//first file loaded => concatenating is obsolet
				firsthkfile=1
				hkmainfp=hkfldrfp
			else		//concatenate
				SP2_ConcatenateHKfldrs("", MainHKfldrFP=hkmainfp, AppendHKfldrFP=hkfldrfp)
				hkfldrfp=hkmainfp		//lastest HK data are now also in "hkmainfp"
			endif
		endif
	endfor
	//post processing of trace analysis if the folders have been concatenated
	if (ConcatMode==1 && TAmode==1 && PPmode==1 && strlen(rawmainfp))
		PBPmainfp=SP2_RawFldrFP2PBPfldrFP(rawmainfp)
		SP2_PBPpostprocessing(pbpfldrfp=PBPmainfp)
	endif
	
	//save the loaded files--for reloading [jcc v4111a]
	string loadHistory_fullpathStr= ksSP2PathToToolkitPanelFldr + ksSP2reloadWaveName
	Wave /Z /T loadHistory= $loadHistory_fullpathStr
	if (!WaveExists(loadHistory))
		make /T/N=0 $(loadHistory_fullpathStr) /WAVE= loadHistory
	endif 
	string loaded= "SP2_LoadRawData(\"\""
	loaded+= ", RawDataFileFP=\"" + filepathlist + "\"" // RawDataFileFP got updated to this!
	loaded+= ", RawDataDir=\"" + RawDataDir + "\""
	// loaded+= ", RawDataDir=\"" + "\"" // redundant with complete filepaths in filepathlist
	if (strlen(FileDateString) && strlen(FileNumList))
		loaded+= ", FileDateString=\"" + FileDateString + "\""
		loaded+= ", FileNumList=\"" + FileNumList + "\""
	else
		loaded+= ", LoadType=4" // here we force 4, because other modes will have filled the filepathlist via the dialog above
	endif
	// save to load history WITHOUT panel options
		loadHistory[numpnts(loadHistory)]= {loaded + ")"} // automatically lengthens wave
	// print to command history WITH panel options
		loaded+= ", ConcatMode=" + num2str(ConcatMode)
		loaded+= ", TAmode=" + num2str(TAmode)
		loaded+= ", LEOTAmode=" + num2str(LEOTAmode)
		loaded+= ", ChannelBitsTA=" + num2str(ChannelBitsTA)
		loaded+= ", ChannelBitsLoad=" + num2str(ChannelBitsLoad)
		loaded+= ", DelBits=" + num2str(DelBits)
		loaded+= ", PPmode=" + num2str(PPmode)
		loaded+= ", FitLogNorm=" + num2str(FitLogNorm)
		loaded+= ", Omode=" + num2str(Omode)
		loaded+= ", HKloadMode= " + num2str(HKloadMode)
		loaded+= ", hkfldrfp=\"" + hkfldrfp + "\""
		loaded+= ", FractMode=" + num2str(FractMode)
		loaded+= ", LoadOutOfEvery=" + num2str(LoadOutOfEvery)
		loaded+= ", MaxDataRate=" + num2str(MaxDataRate)
		loaded+= ")"
		print loaded
		if (strlen(loaded) > 400)
			// print "\t//* Use SP2_repeatLastLoad() to reload data." // now a toolkit option
		endif
	
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	killdatafolder /z $ksSP2hkLoadTempFldrFP
	
	return rawdatafldrlist
End



Function SP2_LEOfitPreparation(ctrlname, [pbpfldrfp, BeamShapeMode, GaussShapeMode, GraphMode, SCprefix, SPprefix, Kmode]) : ButtonControl
	//This function extracts the data required for the LEO fit analysis:
	//	- time difference between split point and beam centre
	//	- beam width (only required when applying Gaussian)
	//	- median beam shape (only required when using actual beam shape)
	//return value: 0; not used
	//Note: this function can only be executed after running the function SP2_PBPpostprocessing
	//martin.gysel@psi.ch; 	22/05/2009, 12/06/2009, 25/05/2010, 26/05/2010, 13/08/2010, 11/09/2010, 12/09/2010, 24/11/2010, 25/11/2010, 01/12/2010
	//						13/01/2011, 15/02/2012
	//joel.c.corbin+sci@gmail.com;2016-08-22 minor changes to graphing/printing inpust
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable BeamShapeMode	//1: determine median beam shape from pure scattering traces only required when using actual beam shape for LEO-fit
							//0: do not determine median beam shape
							//default: use panel setting
	variable GaussShapeMode	//1: determine Gaussian beam parameters from pure scattering traces only required for Gaussian fit to leading edge
							//0: do not determine Gaussian beam parameters
							//default: use panel setting
							//note: these data are also useful for quality assurance of beam shape stability
	variable GraphMode	//1:			create graphs
						//0: 			do not show graphs
	string SCprefix		//prefix of scattering channel to be used:
						//e.g. ksSP2SCHGprefix or ksSP2SCLGprefix
						//default: prompt
						//note: this cannot be a combined channel
	string SPprefix		//prefix of position sensitive detector (split detector) channel to be used
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//default: prompt
						//note, this can also be a combined channel
	variable Kmode		//0: The matrix containing the normalised beam shapes is retained
						//1 (default): The matrix containing the normalised beam shapes is deleted
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(pbpfldrfp))
// jcc		pbpfldrfp=BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoBeamAndCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	string LeoMainSubFldrFP=leofldrfp+ksSP2LEOmainSubFldrPP
	CreateFoldersOfFullPath(leofldrfp, 0)
	CreateFoldersOfFullPath(LeoBeamAndCalibSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoTraceFitSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoMainSubFldrFP, 0)
	if (paramisdefault(BeamShapeMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitSkipBeamShapeCB=$ksSP2leoFitSkipBeamShapeCB
		BeamShapeMode=LEOfitSkipBeamShapeCB
	endif
	if (paramisdefault(GaussShapeMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitSkipGaussCB=$ksSP2leoFitSkipGaussCB
		GaussShapeMode=LEOfitSkipGaussCB
	endif
	if (paramisdefault(GraphMode))
		GraphMode= SP2_graphsOn() // v4111--from panel
	endif
	variable mustprompt=0
	if (paramisdefault(SCprefix))
		mustprompt=1
		SCprefix=ksSP2SCHGprefix
	endif
	if (paramisdefault(SPprefix))
		mustprompt=1
		SPprefix=ksSP2SPHGprefix
	endif
	if (mustprompt)
		string SCprefixList=SP2_ChanListScattOnly()
		string SCabbrevList=SP2_ChanListToAbbrevList(SCprefixList)
		variable SCmode=1+WhichListItem(SCprefix, SCprefixList)
		string SPprefixList=SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()
		string SPabbrevList=SP2_ChanListToAbbrevList(SPprefixList)
		variable SPmode=1+WhichListItem(SPprefix, SPprefixList)
		prompt SCmode, "scattering channel to be used:", popup, SCabbrevList
		prompt SPmode, "split detector channel to be used:", popup, SPabbrevList
		doprompt "Select Channels", SCmode, SPmode
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message		
		endif
		SCmode-=1
		SPmode-=1
		SCprefix=stringfromlist(SCmode,SCprefixList)
		SPprefix=stringfromlist(SPmode,SPprefixList)
	endif
	if (paramisdefault(Kmode))
		Kmode=1
	endif
	
	// if (paramisdefault(printInfo) || printInfo)
		// printf "SP2_LEOfitPreparation(\"\", pbpfldrfp=\"%s\", ", pbpfldrfp
		// printf "BeamShapeMode=%g, GaussShapeMode=%g, GraphMode=%g, ", BeamShapeMode, GaussShapeMode, GraphMode
		// printf "SCprefix=\"%s\", SPprefix=\"%s\", Kmode=%g, printInfo=0)\r", SCprefix, SPprefix, Kmode
	// endif
	
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar BBHGdetectCut=$ksSP2BBHGdetectCut
	Nvar NBHGdetectCut=$ksSP2NBHGdetectCut
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access PBP waves
		setdatafolder $pbpfldrfp
		//incandescence channels
		wave BroadIncPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
		wave BBHGPeakPos=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakPos
		//scattering channel Gaussian fit
		wave ScattSaturated=$SCprefix+ksSP2PBPsaturated
		wave ScattPeakHt=$SCprefix+ksSP2PBPscattGausspeakHeight			
		wave ScattPeakPos=$SCprefix+ksSP2PBPscattGausspeakPos				
		wave ScattPeakFWHM=$SCprefix+ksSP2PBPscattGausspeakFWHM		
		//split channel basic fit
		wave SplitSaturated=$SPprefix+ksSP2PBPsaturated
		wave FilteredCentreSplitPos=$SPprefix+ksSP2PBPsplitFilteredSplitPos		
		//post processing
		wave Classification=$ksSP2pbpClassification					
		variable nRows=numpnts(ScattPeakPos)
	//prepare LEO waves in beam and calibration data subfolder
		//info string
		setdatafolder $LeoBeamAndCalibSubFldrFP
		string /g $ksSP2LEOfitPrepInfoStr=""
		SVAR /Z LEOfitPrepInfoStr=$ksSP2LEOfitPrepInfoStr
		if (!SVAR_Exists(LEOfitPrepInfoStr))
			string/G $ksSP2LEOfitPrepInfoStr; SVAR LEOfitPrepInfoStr
		endif
		LEOfitPrepInfoStr+=ksSP2LEOfitPrepSCprefixKey+"="+SCprefix+"\r"
		LEOfitPrepInfoStr+=ksSP2LEOfitPrepSPprefixKey+"="+SPprefix+"\r"
		//always required for LEO-fit
		setdatafolder $LeoBeamAndCalibSubFldrFP
		make /o/n=(nRows) $ksSP2LEOsplit2centreDeltaScatt=NaN
		wave LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt			
		note LEOsplit2centreDelta, "time difference ["+num2str(1/SamplingRateRawDataMHz)+" s] between split point and beam centre crossing (t_beamcentre - t_split);"
		note LEOsplit2centreDelta, "these values are derived from the two waves "+nameofwave(ScattPeakPos)+" and "+nameofwave(FilteredCentreSplitPos)+";"
		make /o/n=(nRows) $ksSP2LEOfitSplit2centreDelta=NaN // jcc -- n from 1 to nRows, for plot LEO_BeamFWHM_and_SplitTime_graph, which is vs. TimeDate
		wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta			
		note LEOfitSplit2centreDelta, "cleaned time difference between split point and beam centre, which is used for LEO-fits;"
		note LEOfitSplit2centreDelta, "these values are smoothed/averaged values based on the data in the wave "+ksSP2LEOsplit2centreDeltaScatt+";"
		//specific for applying Gaussian fit or quality assurance
		if (GaussShapeMode)
			setdatafolder $LeoBeamAndCalibSubFldrFP
			make /o/n=(nRows) $ksSP2LEObeamFWHMpureScatt=NaN
			wave LEObeamFWHM=$ksSP2LEObeamFWHMpureScatt
			note LEObeamFWHM, "measured FWHM of laser beam;"
			note LEObeamFWHM, "these values are taken from the scattering channel data and filtered by event type;"
			make /o/n=(nRows) $ksSP2LEOfitBeamFWHM=NaN
			wave LEOfitBeamFWHM=$ksSP2LEOfitBeamFWHM
			note LEOfitBeamFWHM, "cleaned beam FWHM values which are used for LEO-fits;"
			note LEOfitBeamFWHM, "these values are smoothed/averaged values based on the data in the wave "+ksSP2LEObeamFWHMpureScatt+";"		
			make /o/n=(nRows) $ksSP2LEObeamPosPureScatt=NaN
			wave LEObeamPos=$ksSP2LEObeamPosPureScatt			
			note LEObeamPos, "measured centre position of laser beam;"
			note LEObeamPos, "these values are taken from the scattering channel data and filtered by event type;"
//********************************it looks like below wave is obsolete
//			make /o/n=(nRows) $ksSP2LEOsplitPosMeasPureScatt=NaN
//			wave LEOsplitPos=$ksSP2LEOsplitPosMeasPureScatt			
//			note LEOsplitPos, "split time;"
//			note LEOsplitPos, "these values are taken from the split detector data and filtered by event type;"
//********************************it looks like above wave is obsolete
			make /o/n=(nRows) $ksSP2LEOsplit2incandDelta=NaN
			wave LEOsplit2incandDelta=$ksSP2LEOsplit2incandDelta			
			note LEOsplit2incandDelta, "time difference ["+num2str(1/SamplingRateRawDataMHz)+" s] between split point and centre of incandescence peak (t_inc,centre - t_split);"
		endif
	//loop over all data points and prepare waves for LEO-fit data analysis
	variable pind
	for (pind=0; pind<=nRows; pind+=1)
		//pure scattering particles with split detector signal only
		if ( ScattPeakHt[pind]>=kSP2LEOverificSCHGcut && !(BroadIncPeakHt[pind]>BBHGdetectCut) )	//  && !(NarrIncPeakHt[pind]>NBHGdetectCut) )		//skipped NBHG test on 22/03/2013
			//split to centre time difference (required for LEO-trace analysis)
			if ( (ScattSaturated[pind]==0) && (SplitSaturated[pind]==0) )		//filter saturated traces
				LEOsplit2centreDelta[pind]=ScattPeakPos[pind]-FilteredCentreSplitPos[pind]
			endif
			//only for determining Gaussian beam parameters as well as beam stability and other quality assurance
			if (GaussShapeMode)
				//beam width and position
				if(ScattSaturated[pind]==0)		//scattering channel not saturated
					LEObeamFWHM[pind]=ScattPeakFWHM[pind]
					LEObeamPos[pind]=ScattPeakPos[pind]
				endif				
//********************************it looks like below wave is obsolete
//				//split position
//				if(SplitSaturated[pind]==0)		//split detector not saturated
//					LEOsplitPos[pind]=FilteredCentreSplitPos[pind]
//				endif		
//********************************it looks like above wave is obsolete
			endif
		endif
		//BC particles with split detector signal
		if (BroadIncPeakHt[pind]>=kSP2LEOprepBBHGcutIncandDelay)
			//time lag between split point and incandescence
			if (GaussShapeMode)
					LEOsplit2incandDelta[pind]=BBHGPeakPos[pind]-FilteredCentreSplitPos[pind]
			endif		
		endif
	endfor
	//smoothed time difference between split point and beam centre  (required for LEO-trace analysis)
	variable MedianSplit2centreDelta=Percentile_of_ListNaN(LEOsplit2centreDelta, 0.5)
	LEOfitSplit2centreDelta=MedianSplit2centreDelta
	//smoothed beam FWHM
	if (GaussShapeMode)
		variable MedianBeamWidth=Percentile_of_ListNaN(LEObeamFWHM, 0.5)
		LEOfitBeamFWHM=MedianBeamWidth
	endif
	//determine beam shape
	if (BeamShapeMode==1)
		//get beam shape
		SP2_LEOgetBeamShape(SCprefix, SPprefix, pbpfldrfp=pbpfldrfp, PosMode=1, StatsMode=0, Kmode=Kmode, printInfo=1)
	endif
	//show graphs
	if (GraphMode)
		if (GaussShapeMode)
					///SP2_LEOgr_SplitDeltaVsSCHGpkht(LEOfldrfp=leofldrfp)			//skip this graph
			SP2_LEOgr_FWHMandSplitPt(LeoBeamCalibSubFldrFP=LeoBeamAndCalibSubFldrFP)
			SP2_LEOgr_IncandDelayVsBBHGpkHt(LEOfldrfp=leofldrfp)
			SP2_LEOgr_IncandDelayVsSplitNeg(LEOfldrfp=leofldrfp)
		else
			SP2_LEOgr_Split2CentrePosVsTime(LEOfldrfp=leofldrfp)		
		endif
		if (BeamShapeMode==1)
			//beam shape statistics graph
			SP2_LEOgr_BeamShapeStats(LeoBeamCalibSubFldrFP=LeoBeamAndCalibSubFldrFP)
		endif
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end

Function SP2_DeleteDataIndexRange(ctrlname [, rawfldrfp, firstrowindex, lastrowindex, PPmode, FitlogNorm, PrintInfo]) : ButtonControl
	//This function deletes rows from SP2 data permanently.
	//return value: 0; not used
	//martin.gysel@psi.ch; 05/06/2009; 23/07/2009
	String ctrlname	//name of button control; not used
	string rawfldrfp	//full path to data folder containing the raw trace matrices
					//default: browse for folder
	variable firstrowindex	//index of first row, which is to be deleted
						//default: prompt
	variable lastrowindex	//index of last row, which is to be deleted
						//default: prompt
	variable PPmode		//1 (default):	run post processing afterwards
						//0:			do not run trace analysis
	variable FitLogNorm	//1 (default):	fit lognormal size distributions
						//0:			do not fit lognormal size distributions
						//note: panel settings are used for the diameter range considered in the fit!
	variable PrintInfo		//0 (default):	no information is printed to history
						//1:			progress information is printed to history

	//preparations
	string savedDF=getdatafolder(1)					
	string currproc, message
	//set defaults
	if (paramisdefault(rawfldrfp))
		rawfldrfp= SP2_getFolder(type="raw")
//		rawfldrfp=BrowseForFolder("Select folder containing the raw data:", StartPath=savedDF)
//		if (stringmatch(rawfldrfp, "cancelled"))		
//			setdatafolder $savedDF
//			string /g RTStackInfo
//			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
//			currproc=laststringfromlist(RTStackInfo)
//			message="User cancelled the procedure "+currproc+"!"
//			print message;print RTStackInfo;abort message			
//		endif	
	endif
	string pbpfldrfp=SP2_RawFldrFP2PBPfldrFP(rawfldrfp)
	variable mustprompt=0
	if (paramisdefault(firstrowindex))
		mustprompt=1
		firstrowindex=NaN
	endif
	if (paramisdefault(lastrowindex))
		mustprompt=1
		lastrowindex=NaN
	endif
	if (mustprompt)
		prompt firstrowindex, "index of first data row to be deleted:"
		prompt lastrowindex, "index of last data row to be deleted:"
		doprompt "Data Range to be Deleted", firstrowindex, lastrowindex
		if (V_flag)
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message;print RTStackInfo;abort message					
		endif
	endif
	if (paramisdefault(PPmode))
		PPmode=1
	endif
	if (paramisdefault(FitLogNorm))
		FitLogNorm=1
	endif	
	if (paramisdefault(PrintInfo))
		PrintInfo=0
	endif
	//access waves from raw data folder
	setdatafolder $rawfldrfp
	wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
	wave TimeElapsedEff=$ksSP2TimeElapsedEff
	variable nRows=numpnts(TimeElapsedMeas)
	//check/coerce data range, which is to be deleted
	if(lastrowindex<firstrowindex) 
		setdatafolder $savedDF
		string /g RTStackInfo
		RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
		currproc=laststringfromlist(RTStackInfo)
		message="Invalid row index range handed over to the procedure "+currproc+"!"
		print message;print RTStackInfo;abort message							
	endif
	firstrowindex=max(0,firstrowindex)
	lastrowindex=min(nRows-1,lastrowindex)
	string startstr, endstr
	sprintf startstr, "%d",firstrowindex
	sprintf endstr, "%d",lastrowindex
	string runlist=startstr+"-"+endstr
	//interval length of deleted data
	variable intsecMeas=TimeElapsedMeas[lastrowindex+1]-TimeElapsedMeas[firstrowindex]
	variable intsecEff=TimeElapsedEff[lastrowindex+1]-TimeElapsedEff[firstrowindex]
	//delete data from raw data folder
	DeleteRunsFromDataFldrFast(runlist, nRows, DataFldrPath=rawfldrfp, PrintInfo=PrintInfo)
	//adapt waves containing the "elapsed time"
	if (firstrowindex<numpnts(TimeElapsedMeas))		//only if last points in "TimeElapsedMeas" and "TimeElapsedEff" were not deleted
		TimeElapsedMeas[firstrowindex,inf]-=intsecMeas
		TimeElapsedEff[firstrowindex,inf]-=intsecEff
	endif
	//delete data from PBP data folder
	if (datafolderexists(pbpfldrfp))
		DeleteRunsFromDataFldrFast(runlist, nRows, DataFldrPath=pbpfldrfp, PrintInfo=PrintInfo)
	else
		PPmode=0
	endif
	//post processing
	if (PPmode==1)
		SP2_PBPpostprocessing(pbpfldrfp=PBPfldrfp, PrintInfo=0)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_DeleteDataTimeRange(ctrlname [, rawfldrfp, StartTimeStr, EndTimeStr, PPmode, FitlogNorm, PrintInfo]) : ButtonControl
	//This function deletes a time range from SP2 data permanently.
	//return value: 0; not used
	//martin.gysel@psi.ch; 07/06/2009; 
	String ctrlname	//name of button control; not used
	string rawfldrfp	//full path to data folder containing the raw trace matrices
					//default: browse for folder
	string StartTimeStr	//time from which onwards the SP2 data are to be deleted
						//format: "DD/MM/YY hh:mm:ss"
						//default: prompt
						//note: data points with time stamp equal to StartTimeStr are also deleted
	string EndTimeStr	//time until which the SP2 data are to be deleted
						//format: "DD/MM/YY hh:mm:ss"
						//default: prompt						
						//note: data points with time stamp equal to EndTimeStr are also deleted
	variable PPmode		//1 (default):	run post processing afterwards
						//0:			do not run trace analysis
	variable FitLogNorm	//1 (default):	fit lognormal size distributions
						//0:			do not fit lognormal size distributions
						//note: panel settings are used for the diameter range considered in the fit!
	variable PrintInfo		//0 (default):	no information is printed to history
						//1:			progress information is printed to history


	//preparations
	string savedDF=getdatafolder(1)					
	string currproc, message
	//set defaults
	if (paramisdefault(rawfldrfp))
		rawfldrfp= SP2_getFolder(type="raw")
//		rawfldrfp= BrowseForFolder("Select folder containing the raw data:", StartPath=savedDF)
//		if (stringmatch(rawfldrfp, "cancelled"))		
//			setdatafolder $savedDF
//			string /g RTStackInfo
//			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
//			currproc=laststringfromlist(RTStackInfo)
//			message="User cancelled the procedure "+currproc+"!"
//			print message;print RTStackInfo;abort message			
//		endif	
	endif
	string pbpfldrfp=SP2_RawFldrFP2PBPfldrFP(rawfldrfp)
	variable mustprompt=0
	if (paramisdefault(StartTimeStr))
		mustprompt=1
		StartTimeStr="DD/MM/YY hh:mm:ss"
	endif
	if (paramisdefault(EndTimeStr))
		mustprompt=1
		EndTimeStr="DD/MM/YY hh:mm:ss"
	endif
	if (mustprompt)
		prompt StartTimeStr, "time from which onwards the SP2 data are to be deleted:"
		prompt EndTimeStr, "time until which the SP2 data are to be deleted:"
		doprompt "Data Range to be Deleted", StartTimeStr, EndTimeStr
		if (V_flag)
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message;print RTStackInfo;abort message					
		endif
	endif
	if (paramisdefault(PPmode))
		PPmode=1
	endif
	if (paramisdefault(FitLogNorm))
		FitLogNorm=1
	endif	
	if (paramisdefault(PrintInfo))
		PrintInfo=0 // do not print in subfunctions
		
		// by default, print info for this function only:
		printf "SP2_DeleteDataTimeRange(\"\", rawfldrfp=\"%s\", ", rawfldrfp
		printf "StartTimeStr=\"%s\", EndTimeStr=\"%s\", ", StartTimeStr, EndTimeStr
		printf "PPmode=%g, FitlogNorm=%g, PrintInfo=0)\r", PPmode, FitlogNorm
	endif
	//access waves from raw data folder
	setdatafolder $rawfldrfp
	wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
	wave TimeElapsedEff=$ksSP2TimeElapsedEff
	wave TimeDate=$ksSP2TimeDate
	variable nRows=numpnts(TimeElapsedMeas)
	//check/coerce data range, which is to be deleted
	if (stringmatch(StartTimeStr, "*/*")) // Martin's format: "DD/MM/YY hh:mm:ss"	
		variable StartTimeVal=TimeTextToIgorTime(StartTimeStr, DateSepStr="/",TimeSepStr=":",CenturyVal=2000)
		variable EndTimeVal=TimeTextToIgorTime(EndTimeStr, DateSepStr="/",TimeSepStr=":",CenturyVal=2000)
	else // v4111: ISO format (YYYY-MM-DD HH:MM:SS)
		StartTimeVal=dt2secs(StartTimeStr)
		EndTimeVal=dt2secs(EndTimeStr)
	endif
	EndTimeVal+=1e-3	//make sure that data points with time stamp equal to EndTimeStr are also deleted
	if(EndTimeVal<StartTimeVal) 
		setdatafolder $savedDF
		string /g RTStackInfo
		RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
		currproc=laststringfromlist(RTStackInfo)
		message="Invalid time range handed over to the procedure "+currproc+"!"
		print message;print RTStackInfo;abort message							
	endif
	//determine row indices corresponding to time range
	variable NothingToDelete=0
	variable firstrowindex=BinarySearch(TimeDate, StartTimeVal)
	if (firstrowindex==-2)
		//=> start time falls behind last measured data point
		//=> nothing to be deleted
		NothingToDelete=1
	elseif (firstrowindex==-1)
		//=> start time falls before first measured data point
		firstrowindex=0
	endif
	variable lastrowindex=BinarySearch(TimeDate, EndTimeVal)
	if (lastrowindex==-1)
		//=> end time falls before first measured data point
		//=> nothing to be deleted
		NothingToDelete=1
	elseif (lastrowindex==-2)
		//=> end time falls behind last measured data point
		lastrowindex=nRows-1
	endif
	//delete data
	if(NothingToDelete==0)
		SP2_DeleteDataIndexRange("", rawfldrfp=rawfldrfp, firstrowindex=firstrowindex, lastrowindex=lastrowindex, PPmode=PPmode, FitlogNorm=FitlogNorm, PrintInfo=PrintInfo)
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_ClassificationWaveCreator(pbpfldrfp)
	//This function creates the particle type classification waves, which are used by various post-processing functions.
	//return value: 0; not used
	//martin.gysel@psi.ch; 09/06/2009, 10/07/2009, 27/04/2010, 28/04/2010, 10/08/2010, 09/09/2010, 12/09/2010, 25/11/2010;
	string pbpfldrfp		//full path to folder containing the PBP data
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	//create main mask wave if it doesn't yet exist (needed for compatibility with older toolkit releases)
	SP2rawDataMainMaskPrep(rawfldrfp, 0)	
	//access raw data waves
	setdatafolder $rawfldrfp
	wave Mask_BadDataMain=$ksSP2pbpMaskBadData
	variable nParticles=numpnts(Mask_BadDataMain)
	//access PBP waves
	setdatafolder $pbpfldrfp
	wave /Z SCHGPeakHt=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakHeight			
	wave /Z SCHGsaturated=$ksSP2SCHGprefix+ksSP2PBPsaturated
	wave /Z BBHGpeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
	wave /Z BBHGsaturated=$ksSP2BBHGprefix+ksSP2PBPsaturated
	wave /Z NBHGpeakHt=$ksSP2NBHGprefix+ksSP2PBPtracefitPeakHt
	wave /Z SPHGnegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
	wave /Z SCLGPeakHt=$ksSP2SCLGprefix+ksSP2PBPscattGausspeakHeight			
	wave /Z BBLGpeakHt=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHt
	wave /Z NBLGpeakHt=$ksSP2NBLGprefix+ksSP2PBPtracefitPeakHt
	wave /Z SPLGnegPeakHt=$ksSP2SPLGprefix+ksSP2PBPsplitNegPeakHt
	
	//classify particles with cut-offs from toolkit panel
		//get minimum peak heights for classifiaction as a valid signal according to panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar SCHGcut=$ksSP2SCHGMinCut
		Nvar BBHGcut=$ksSP2BBHGMinCut
		Nvar NBHGcut=$ksSP2NBHGMinCut
		Nvar SPHGcut=$ksSP2SPHGMinCut
		Nvar SCLGcut=$ksSP2SCLGMinCut
		Nvar BBLGcut=$ksSP2BBLGMinCut
		Nvar NBLGcut=$ksSP2NBLGMinCut
		Nvar SPLGcut=$ksSP2SPLGMinCut
		//prepare classification wave
		setdatafolder $pbpfldrfp
		make /o/n=(nParticles)  $ksSP2pbpClassification=0
		wave Classification=$ksSP2pbpClassification
		note Classification, "Classification of recorded particles by signal cut-off values from toolkit panel;"
		note Classification, "bit"+num2str(ln(kSP2SCHGeventBitVal)/ln(2))+"="+num2str(kSP2SCHGeventBitVal)+": high gain scattering detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2BBHGeventBitVal)/ln(2))+"="+num2str(kSP2BBHGeventBitVal)+": high gain broadband detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2NBHGeventBitVal)/ln(2))+"="+num2str(kSP2NBHGeventBitVal)+": high gain narrowband detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2SPHGeventBitVal)/ln(2))+"="+num2str(kSP2SPHGeventBitVal)+": high gain split detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2SCLGeventBitVal)/ln(2))+"="+num2str(kSP2SCLGeventBitVal)+": low gain scattering detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2BBLGeventBitVal)/ln(2))+"="+num2str(kSP2BBLGeventBitVal)+": low gain broadband detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2NBLGeventBitVal)/ln(2))+"="+num2str(kSP2NBLGeventBitVal)+": low gain narrowband detector above threshold;"
		note Classification, "bit"+num2str(ln(kSP2SPLGeventBitVal)/ln(2))+"="+num2str(kSP2SPLGeventBitVal)+": low gain split detector above threshold;"
		note Classification, ksSP2SCHGcutKey+": "+num2str(SCHGcut)
		note Classification, ksSP2BBHGcutKey+": "+num2str(BBHGcut)
		note Classification, ksSP2NBHGcutKey+": "+num2str(NBHGcut)
		note Classification, ksSP2SPHGcutKey+": "+num2str(SPHGcut)
		note Classification, ksSP2SCLGcutKey+": "+num2str(SCLGcut)
		note Classification, ksSP2BBLGcutKey+": "+num2str(BBLGcut)
		note Classification, ksSP2NBLGcutKey+": "+num2str(NBLGcut)
		note Classification, ksSP2SPLGcutKey+": "+num2str(SPLGcut)
		//classify
		if (waveexists(SCHGPeakHt))
			Classification+= SCHGPeakHt[p]>=SCHGcut ? kSP2SCHGeventBitVal : 0			//high gain scattering channel
		endif
		if (waveexists(BBHGpeakHt))
			Classification+= BBHGpeakHt[p]>=BBHGcut ? kSP2BBHGeventBitVal : 0		//high gain broadband channel
		endif
		if (waveexists(NBHGpeakHt))
			Classification+= NBHGpeakHt[p]>=NBHGcut ? kSP2NBHGeventBitVal : 0			//high gain narrowband channel
		endif
		if (waveexists(SPHGnegPeakHt))
			Classification+= -SPHGnegPeakHt[p]>=SPHGcut ? kSP2SPHGeventBitVal : 0			//high gain split detector
		endif
		if (waveexists(SCLGPeakHt))
			Classification+= SCLGPeakHt[p]>=SCLGcut ? kSP2SCLGeventBitVal : 0			//low gain scattering channel
		endif
		if (waveexists(BBLGpeakHt))
			Classification+= BBLGpeakHt[p]>=BBLGcut ? kSP2BBLGeventBitVal : 0		//low gain broadband channel
		endif
		if (waveexists(NBLGpeakHt))
			Classification+= NBLGpeakHt[p]>=NBLGcut ? kSP2NBLGeventBitVal : 0			//low gain narrowband channel
		endif
		if (waveexists(SPLGnegPeakHt))
			Classification+= -SPLGnegPeakHt[p]>=SPLGcut ? kSP2SPLGeventBitVal : 0			//low gain split detector
		endif
		
	//classify particles with minimum cut-offs
		//get minimum peak heights of true signals according to panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar SCHGdetectCut=$ksSP2SCHGdetectCut
		Nvar BBHGdetectCut=$ksSP2BBHGdetectCut
		Nvar NBHGdetectCut=$ksSP2NBHGdetectCut
		Nvar SPHGdetectCut=$ksSP2SPHGdetectCut
		Nvar SCLGdetectCut=$ksSP2SCLGdetectCut
		Nvar BBLGdetectCut=$ksSP2BBLGdetectCut
		Nvar NBLGdetectCut=$ksSP2NBLGdetectCut
		Nvar SPLGdetectCut=$ksSP2SPLGdetectCut
		//prepare classification wave
		setdatafolder $pbpfldrfp
		make /o/n=(nParticles)  $ksSP2pbpClassificationByMinCut=0
		wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut
		note ClassificationByMinCut, "Classification of recorded particles by minimum signal cut-off values;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2SCHGeventBitVal)/ln(2))+"="+num2str(kSP2SCHGeventBitVal)+": high gain scattering detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2BBHGeventBitVal)/ln(2))+"="+num2str(kSP2BBHGeventBitVal)+": high gain broadband detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2NBHGeventBitVal)/ln(2))+"="+num2str(kSP2NBHGeventBitVal)+": high gain narrowband detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2SPHGeventBitVal)/ln(2))+"="+num2str(kSP2SPHGeventBitVal)+": high gain split detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2SCLGeventBitVal)/ln(2))+"="+num2str(kSP2SCLGeventBitVal)+": low gain scattering detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2BBLGeventBitVal)/ln(2))+"="+num2str(kSP2BBLGeventBitVal)+": low gain broadband detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2NBLGeventBitVal)/ln(2))+"="+num2str(kSP2NBLGeventBitVal)+": low gain narrowband detector above minimum threshold;"
		note ClassificationByMinCut, "bit"+num2str(ln(kSP2SPLGeventBitVal)/ln(2))+"="+num2str(kSP2SPLGeventBitVal)+": low gain split detector above minimum threshold;"
		note ClassificationByMinCut, ksSP2SCHGminCutKey+": "+num2str(SCHGdetectCut)
		note ClassificationByMinCut, ksSP2BBHGminCutKey+": "+num2str(BBHGdetectCut)
		note ClassificationByMinCut, ksSP2NBHGminCutKey+": "+num2str(NBHGdetectCut)
		note ClassificationByMinCut, ksSP2SPHGminCutKey+": "+num2str(SPHGdetectCut)
		note ClassificationByMinCut, ksSP2SCLGminCutKey+": "+num2str(SCLGdetectCut)
		note ClassificationByMinCut, ksSP2BBLGminCutKey+": "+num2str(BBLGdetectCut)
		note ClassificationByMinCut, ksSP2NBLGminCutKey+": "+num2str(NBLGdetectCut)
		note ClassificationByMinCut, ksSP2SPLGminCutKey+": "+num2str(SPLGdetectCut)
		//classify
		if (waveexists(SCHGPeakHt))
			ClassificationByMinCut+= SCHGPeakHt[p]>=SCHGdetectCut ? kSP2SCHGeventBitVal : 0			//high gain scattering channel
		endif
		if (waveexists(BBHGpeakHt))
			ClassificationByMinCut+= BBHGpeakHt[p]>=BBHGdetectCut ? kSP2BBHGeventBitVal : 0		//high gain broadband channel
		endif
		if (waveexists(NBHGpeakHt))
			ClassificationByMinCut+= NBHGpeakHt[p]>=NBHGdetectCut ? kSP2NBHGeventBitVal : 0			//high gain narrowband channel
		endif
		if (waveexists(SPHGnegPeakHt))
			ClassificationByMinCut+= -SPHGnegPeakHt[p]>=SPHGdetectCut ? kSP2SPHGeventBitVal : 0			//high gain split detector
		endif
		if (waveexists(SCLGPeakHt))
			ClassificationByMinCut+= SCLGPeakHt[p]>=SCLGdetectCut ? kSP2SCLGeventBitVal : 0			//low gain scattering channel
		endif
		if (waveexists(BBLGpeakHt))
			ClassificationByMinCut+= BBLGpeakHt[p]>=BBLGdetectCut ? kSP2BBLGeventBitVal : 0		//low gain broadband channel
		endif
		if (waveexists(NBLGpeakHt))
			ClassificationByMinCut+= NBLGpeakHt[p]>=NBLGdetectCut ? kSP2NBLGeventBitVal : 0			//low gain narrowband channel
		endif
		if (waveexists(SPLGnegPeakHt))
			ClassificationByMinCut+= -SPLGnegPeakHt[p]>=SPLGdetectCut ? kSP2SPLGeventBitVal : 0			//low gain split detector
		endif
		
	//apply bad data mask
		Classification = Mask_BadDataMain[p] ? NaN : Classification[p]		
		ClassificationByMinCut = Mask_BadDataMain[p] ? NaN : ClassificationByMinCut[p]
	
	//jcc--apply custom data mask (convention: update this mask externally when desired. Eventually this could be used by functions to apply saved 'selections')
		wave /Z ClassificationByUser 
		if (WaveExists(ClassificationByUser))
			Classification = ClassificationByUser[p] ? Classification[p] : NaN
			ClassificationByMinCut = ClassificationByUser[p] ? ClassificationByMinCut[p] : NaN
		endif
	
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end

Function SP2_LEOclassificationWave(pbpfldrfp, IncChanPrefix, RefScattChanPrefix, LEOchanPrefix)
	//This function creates the particle type classification wave, which is used by various LEOfit-post-processing functions.
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/09/2010, 21/12/2011, 23/12/2011, 04/01/2012;
	string pbpfldrfp			//full path to folder containing the PBP data
	string IncChanPrefix		//prefix of incandescence channel used to determine the BC core size
							//e.g: ksSP2BBHGprefix, ksSP2BHNHprefix
	string RefScattChanPrefix	//prefix of scattering channel which is used as a verification reference for the LEO-fit analysis
							//e.g: ksSP2SCHGprefix, ksSP2SCLGprefix
	string LEOchanPrefix		//prefix of scattering or split detector channel used as a verification reference for the LEO-fit analysis
							//e.g: ksSP2SCHGprefix, ksSP2SPHGprefix

	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	string ScattAbbrev=replacestring(";",SP2_ChanListToAbbrevList(RefScattChanPrefix),"")
	//specific to channel selection
	variable IncEventBit=SP2chanPrefix2chanProperty(IncChanPrefix, 4)
	variable RefScattEventBit=SP2chanPrefix2chanProperty(RefScattChanPrefix, 4)
	//create main mask wave if it doesn't yet exist (needed for compatibility with older toolkit releases)
	SP2rawDataMainMaskPrep(rawfldrfp, 0)	
	//access raw data waves
	setdatafolder $rawfldrfp
	wave TimeDate=$ksSP2TimeDate	
	variable nParticles=numpnts(TimeDate)
	wave Mask_BadDataMain=$ksSP2pbpMaskBadData
	//access PBP waves
	setdatafolder $pbpfldrfp
	wave Classification=$ksSP2pbpClassification
	wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut
	wave RefScattSaturated=$RefScattChanPrefix+ksSP2PBPsaturated
	wave IncSaturated=$IncChanPrefix+ksSP2PBPsaturated
	//access waves in LEO trace fit subfolder
	setdatafolder $LeoTraceFitSubFldrFP
	wave LEOsaturated=$LEOchanPrefix+ksSP2PBPsaturated
	//classify by particle type
		//prepare classification wave
		setdatafolder $LeoTraceFitSubFldrFP
		make /o/n=(nParticles)  $LEOchanPrefix+ksSP2pbpClassificationByTypeBN=0
		wave ClassificationByType=$LEOchanPrefix+ksSP2pbpClassificationByTypeBN
		
		if (0) // jcc's descriptions--for user
			note ClassificationByType, "Particle classifications for LEO according to signal type;"
			note ClassificationByType, "0 or NaN: 'bad particle' (excluded based on mask);"
			note ClassificationByType, "1: 'valid BC' (BC-containing particle with BBxG above threshold, not saturated)"
			note ClassificationByType, "2: 'tiny BC' (BBxG below threshold but above detection limit);"
			note ClassificationByType, "4: 'huge BC' (BBxG saturated)';"
			note ClassificationByType, "8: 'huge-coating BC' (LEO saturated at point of fit)';" // note: set by SP2_LEO_FitWorker_ShapeFast_TS() and its sisters
			note ClassificationByType, "64: 'valid BC-free' (BBxG below threshold, SxxG above threshold, not saturated)"
			note ClassificationByType, "128: 'tiny BC-free' (BBxG below threshold, SxxG below threshold but above detection limit)"
			note ClassificationByType, "256: 'no-ref-scattering BC-free' (BBxG below threshold, SxxG signal below detection limit);"
			note ClassificationByType, "512: 'saturated-ref-scattering BC-free'(BBxG below threshold, SxxG saturated);"
			note ClassificationByType, "1024: 'saturated-LEO-scattering BC-free' (LEO saturated at point of fit);"
			note ClassificationByType, "Notes:;"
			note ClassificationByType, "BBxG (incandescence channel) used was: \""+IncChanPrefix+"\";"
			note ClassificationByType, "SxxG (reference scattering channel) used was: \""+RefScattChanPrefix+"\";"
			note ClassificationByType, "LEO (scattering/PSD channel for LEO fit) used was: \""+LEOchanPrefix+"\";"
			note ClassificationByType, "Note: 'thresholds' here refer to the Post Processing panel's True Signals;"
			note ClassificationByType, "Note: 'detection limit' here refers to the Post Processing panel's Include In Results;"
			note ClassificationByType, "Note: for BBxG or SxxG, 'above' or 'below' refers to the fitted peak height;"
			note ClassificationByType, "Note: LEO panel thresholds are applied AFTER this classification;"
			// note /K ClassificationByType, replaceString("BBxG", note(ClassificationByType), removeEnding("RefS ...blahblahblah ...possibly. -jcc
			
		else // Martin's descriptions--programmatic version
			note ClassificationByType, "Classification of recorded particles by type;"
			note ClassificationByType, "Incandescence channel: \""+IncChanPrefix+"\";"
			note ClassificationByType, "Reference scattering channel: \""+RefScattChanPrefix+"\";"
			note ClassificationByType, "Scattering/PSD channel for LEO-fit: \""+LEOchanPrefix+"\";"
			note ClassificationByType, "0 or NaN: filtered particle;"
			note ClassificationByType, "1: 'BC with incandescence peak height in range' (incandescence peak height above selected threshold and not saturated);"
			note ClassificationByType, "2: 'tiny BC' (incandescence peak height between minimum cut and selected threshold);"
			note ClassificationByType, "4: 'BC with saturated incandescence';"
			note ClassificationByType, "8: 'BC with saturated LEO-signal';"
			note ClassificationByType, "64: 'purely scattering with reference scattering peak height in range' (reference scattering peak height above selected threshold and not saturated and incandescene peak height below minimum cut);"
			note ClassificationByType, "128: 'tiny purely scattering with reference scattering peak height below threshold' (reference scattering peak height between minimum cut and selected threshold and incandescence peak height below minimum cut);"
			note ClassificationByType, "256: 'purely scattering with invalid reference scattering peak height' (LEO-signal saturated and incandescence peak height below minimum cut);"
			note ClassificationByType, "512: 'purely scattering with saturated reference scattering signal' (reference scattering peak height saturated and incandescence peak height below minimum cut);"
			note ClassificationByType, "1024: 'purely scattering with saturated LEO-signal' (reference scattering peak height below minimum cut or not available and incandescence peak height below minimum cut);"
		endif
		
		//classify
		variable pind
		for (pind=0; pind<nParticles; pind+=1)
			if (Mask_BadDataMain[pind])
				//particle to be filtered
				ClassificationByType[pind]=0
			else
				//particle to be included
				if (ClassificationByMinCut[pind]&IncEventBit)
					//it is a BC particle (incandescence peak height above minimum threshold for true signals)
					if (LEOsaturated[pind])
						//LEO-signal saturated
						ClassificationByType[pind]=8					
					else
						//LEO-signal not saturated
						if (IncSaturated[pind])
							//incandescence channel saturated
							ClassificationByType[pind]=4
						else
							//incandescence channel not saturated
							if (Classification[pind]&IncEventBit)
								//incandescence peak height above lower threshold set for data analysis
								ClassificationByType[pind]=1
							else
								//tiny BC particle (incandescence peak height below lower threshold set for data analysis)
								ClassificationByType[pind]=2				
							endif				
						endif
					endif
				else
					//it is a purely scattering particle (incandescence peak height missing or below minimum threshold for true signals)
					if (LEOsaturated[pind])
						//LEO-signal saturated
						ClassificationByType[pind]=1024
					else
						//LEO-signal not saturated
						if (RefScattSaturated[pind])
							//reference scattering channel saturated
							ClassificationByType[pind]=512
						else
							//reference scattering channel not saturated
							if (Classification[pind]&RefScattEventBit)
								//reference scattering peak height above threshold set for data analysis
								ClassificationByType[pind]=64
							else
								//reference scattering peak height not above threshold set for data analysis
								if (ClassificationByMinCut[pind]&RefScattEventBit)
									//tiny purely scattering particle (reference scattering peak height above minimum threshold for true signals)
									ClassificationByType[pind]=128
								else
									//invalid reference scattering peak height (missing or amplitude below minimum threshold for true signals)
									ClassificationByType[pind]=256
								endif							
							endif				
						endif						
					endif					
				endif
			endif
		endfor
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_ClassificationNote2CutOff(ClassificationWav, ChanMode)
	//This function determines the applied lower cut-offs from the classification wave note.
	//return value: cut-off applied to the selected channel
	//martin.gysel@psi.ch; 14/06/2009, 11/05/2010
	wave ClassificationWav	//wave containing the particle type classification
	variable ChanMode		//0: high gain scattering channel cut-off
							//1: high gain broadband incandescence cut-off
							//2: high gain narrowband incandescence cut-off
							//3: high gain split detector channel cut-off
							//4: low gain scattering channel cut-off
							//5: low gain broadband incandescence cut-off
							//6: low gain narrowband incandescence cut-off
							//7: low gain split detector channel cut-off
						
	string Key
	switch(ChanMode)
		case 0:	
			//high gain scattering channel
			Key=ksSP2SCHGcutKey
			break						
		case 1:	
			//high gain broadband incandescence channel
			Key=ksSP2BBHGcutKey
			break						
		case 2:	
			//high gain narrowband incandescence channel
			Key=ksSP2NBHGcutKey
			break						
		case 3:	
			//high gain split detector channel
			Key=ksSP2SPHGcutKey
			break						
		case 4:	
			//low gain scattering channel
			Key=ksSP2SCLGcutKey
			break						
		case 5:	
			//low gain broadband incandescence channel
			Key=ksSP2BBLGcutKey
			break						
		case 6:	
			//low gain narrowband incandescence channel
			Key=ksSP2NBLGcutKey
			break						
		case 7:	
			//low gain split detector channel
			Key=ksSP2SPLGcutKey
			break						
	endswitch
	return str2num(StringByKey(Key, note(ClassificationWav), ":", "\r"))
end


Function SP2_SizeDistTimeSeriesExtractor(ctrlname, [pbpfldrfp, IntSec, StartTime, EndTime, Offset, nSizeBins, FitLogNorm, MakeGraph]) : ButtonControl
	//This function determines the time series of the BC mass and number size distribution from PBP data
	//return value: 0; not used
	//note: the lower cut-off values for each detector are taken into account by referring to the classification wave.
	//martin.gysel@psi.ch;	13/06/2009 14/06/2009, 06/10/2009, 05/11/2009 (rather carefully tested), 03/05/2010, 23/06/2010; 11/08/2010
	//						26/11/2010; 16/05/2011
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable IntSec		//interval [s] of concentration time series
						//default: use panel value
						//use IntSec=0 to extract just one size distribution of all data
						//		=> "StartTime" and "EndTime" are ignored if IntSec=0
						//use IntSec=-1 to extract just one size distribution of all data between "StartTime" and "EndTime"
						//note: IntSec is rounded to the nearest integer value
	variable StartTime		//start time stamp (begin of first interval) for concentration time series
						//default: use time stamp of first data point
						//note: ignored if IntSec=0
	variable EndTime		//end time stamp (end of last interval) for concentration time series
						//default: use time stamp of last data point
						//note: ignored if IntSec=0
	variable Offset		//offset [secs] of interval boundary time values relative to 01.01.1904 00:00:00
						//default: determine offset from "StartTime"
	variable nSizeBins	//number of bins for histograms
						//default: use panel settings
	variable FitLogNorm	//1:			fit lognormal size distributions
						//0:			do not fit lognormal size distributions
						//default:		use panel settings
						//note:
						//	- the diameter range of the extracted size distributions fitted is chosen according to the panel settings (the last point is always excluded)
						//	- the resolution of the fitted lognormal curves is chosen according to the corresponding panel setting
	variable MakeGraph	//1 (default):	show graph display concentration time series
						//0:			no graph is shown
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp= SP2_getFolder(type="PBP", includeAll=1) // BrowseForFolder("Select folder containing the SP2-PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			SP2_abort("")			
		endif
	endif
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string SDtserfldrfp=ChopLastCharacterOff(pbpfldrfp,":")+ksSP2SizeDistTserSubFldrPP
	if (paramisdefault(IntSec))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar panelSDinterval=$ksSP2SDinterval
		IntSec=panelSDinterval
	endif
	IntSec=round(IntSec)			//round to nearest integer
	if (paramisdefault(nSizeBins))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar panelSDnbins=$ksSP2SDnbins
		nSizeBins=panelSDnbins
	endif		
	if (paramisdefault(FitLogNorm))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar PanelFitLogNorm=$ksSP2lognormfit	
		FitLogNorm=PanelFitLogNorm
	endif
	if (paramisdefault(MakeGraph))
		MakeGraph=SP2_graphsOn()
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2SDtimeseries
	string tmpfldrpath=getdatafolder(1)
	//update classification wave	(applies thresholds and main data mask)
	SP2_ClassificationWaveCreator(pbpfldrfp)
	//update sample interval and volume wave and access them	(applies main data mask)
	setdatafolder $rawfldrfp
	SP2sampleVolumeWaveCalc(rawfldrfp)
	wave SampleVolume=$ksSP2sampleVolume
	wave SampleInterval=$ksSP2sampleInterval
	//access data
		//access raw data waves
		setdatafolder $rawfldrfp
		wave TimeDate=$ksSP2TimeDate
		wave Mask_BadDataMain=$ksSP2pbpMaskBadData
		wave TimeElapsedEff=$ksSP2TimeElapsedEff
		//access PBP waves	
		setdatafolder $pbpfldrfp
			//general
			wave Classification=$ksSP2pbpClassification
			variable nTriggers=dimsize(Classification,0)	
			wave /Z BCdensityWav=$ksSP2PBPdensityOfBC
			variable BCdensity=NaN			
			if (waveexists(BCdensityWav))
				BCdensity=BCdensityWav[FirstAndLastNonNaNpoint(BCdensityWav)]
			endif
	//prepare wave containing the time stamps
	if (paramisdefault(StartTime))
		StartTime=TimeDate[0]
	endif
	if (paramisdefault(EndTime))
//		EndTime=TimeDate[inf] 
		variable idx_lastGoodTime= getIndex(0, TimeDate, tol=inf, rev=1)		// jcc 4112...sometimes ends in NaN, bug in DMT or PSI software?
		EndTime=TimeDate[idx_lastGoodTime]
	endif
	if (IntSec==0)
		//extract just one size distribution including all measured particles
		IntSec=ceil(TimeDate[inf]-TimeDate[0])
		StartTime=TimeDate[0]
		EndTime=StartTime+1	//make sure that "TimeWaveCreatorVar" below creates just a 1-element wave
	endif
	if (IntSec==-1)
		//extract just one size distribution including all measured particles
		IntSec=ceil(EndTime-StartTime)
	endif
	if (paramisdefault(Offset))
		Offset=mod(StartTime, IntSec)
	endif
	newdatafolder /o/s $SDtserfldrfp
	TimeWaveCreatorVar(StartTime, EndTime, IntSec, Offset, ksSP2timeSeriesTimeBdr, Omode=1)
	wave /d SD_TimeBdr=$ksSP2timeSeriesTimeBdr
	note SD_TimeBdr, "Interval boundary time stamps for size distribution time series;"
	setscale d 0,0,"dat", SD_TimeBdr
	variable nSDpts=numpnts(SD_TimeBdr)-1
	make /o/d/n=(nSDpts) $ksSP2timeSeriesTimeCtr
	wave /d SD_TimeCtr=$ksSP2timeSeriesTimeCtr
	note SD_TimeCtr, "Interval centre time stamps for size distribution time series;"
	setscale d 0,0,"dat", SD_TimeCtr
	BinBoundariesToCentres(SD_TimeBdr, SD_TimeCtr)
	//prepare further general waves
	setdatafolder $SDtserfldrfp
	make /o/n=(nSDpts) $ksSP2tottrigPrefix+ksSP2timeSeriesNumbBnam=NaN
	wave SD_numbTotTrig=$ksSP2tottrigPrefix+ksSP2timeSeriesNumbBnam
	note SD_numbTotTrig, "total number of triggered particles in each time interval;"
	make /o/n=(nSDpts) $ksSP2tottrigPrefix+ksSP2timeSeriesNumbConcBnam=NaN
	wave SD_numbConcTotTrig=$ksSP2tottrigPrefix+ksSP2timeSeriesNumbConcBnam		
	note SD_numbConcTotTrig, "number concentration [#/cm] of totally triggered particles (any type, no cut-off applied);"
	//temporary waves
	setdatafolder $tmpfldrpath
	make /o/n=(nSizeBins) CurrNumbSizeDistr
	make /o/n=10000 CurrDiamList
	//various variables
	variable chanind, tind, currstart, currend, firstpind, coverage, totsampletimeeff, totsamplevolume, tempDim, count
	variable numbBCsum, massBCsum, currEventBit, fractsaveloadfact
	variable pind=0
	string currprefix, currEventPrefix
	//loop over incandescence channels and get size distribution time series
	string incchanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string incListForEventBits=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandLowMass()
	variable nIncChans=itemsinlist(incchanlist)
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, incchanlist)
		currEventPrefix=stringfromlist(chanind, incListForEventBits)
		currEventBit=SP2chanPrefix2chanProperty(currEventPrefix, 0)	
		//access channel-specific PBP waves	
		setdatafolder $pbpfldrfp
		wave /Z BCmassPBP=$currprefix+ksSP2pbpBCmass
		wave /Z BCdiamPBPorig=$currprefix+ksSP2pbpBCdiam	
		wave /Z BCdiamCutLow=$currPrefix+ksSP2pbpDiamCutLow
		//check data availability
		variable CurrChanAvailable= waveexists(BCmassPBP)
		//continue with next channel if no data waves are available
		if(!CurrChanAvailable)
			//no analysed data waves available => proceed with next channel
			continue
		endif	
		//prepare concentration time series waves 
		setdatafolder $SDtserfldrfp
		duplicate /o BCdiamCutLow, $currPrefix+ksSP2pbpDiamCutLow
		make /o/n=(nSDpts) $currprefix+ksSP2timeSeriesNumbBnam=NaN
		wave Tser_BC_numb=$currprefix+ksSP2timeSeriesNumbBnam
		note Tser_BC_numb, "number of detected particles [#] with incandescence peak height above threshold;"
		make /o/n=(nSDpts) $currprefix+ksSP2timeSeriesNumbConcBnam=NaN
		wave Tser_BCnumbConc=$currprefix+ksSP2timeSeriesNumbConcBnam
		note Tser_BCnumbConc, "number concentration [#/cm] of detected particles with incandescence peak height above threshold;"
		note Tser_BCnumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		make /o/n=(nSDpts) $currprefix+ksSP2timeSeriesMassConcBnam=NaN
		wave Tser_BCmassConc=$currprefix+ksSP2timeSeriesMassConcBnam
		note Tser_BCmassConc, "mass concentration [g/m] of detected particles with incandescence peak height above threshold;"
		note Tser_BCmassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		//prepare size distribution waves
			//get diameter scale for histograms
			setdatafolder $SDtserfldrfp
			variable LogDmin=log(MinFromWaveNaN(BCdiamPBPorig, mode=1))		//log of minimum diameter of all data points
			variable LogDmax=log(MaxFromWaveNaN(BCdiamPBPorig, mode=1))		//log of maximum diameter of all data points
			variable DeltaLogDp=(LogDmax-LogDmin)/nSizeBins						//logarithmic bin width
			make /o/n=(nSizeBins+1) $currprefix+ksSP2pbpSDtserDiamBdr=10^(LogDmin+p*DeltaLogDp)
			wave SD_BCdiamBdr=$currprefix+ksSP2pbpSDtserDiamBdr
			note SD_BCdiamBdr, "Bin boundary diameters [nm] for size distribution matrices "+currprefix+ksSP2pbpSDtserNumbDistr+" and "+currprefix+ksSP2pbpSDtserMassDistr+";"
			make /o/n=(nSizeBins) $currprefix+ksSP2pbpSDtserDiamMidpt=10^(LogDmin+(p+0.5)*DeltaLogDp)
			wave SD_BCdiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
			note SD_BCdiamMidpt, "Midpoint diameters [nm] for size distribution matrices "+currprefix+ksSP2pbpSDtserNumbDistr+" and "+currprefix+ksSP2pbpSDtserMassDistr+";"
			//size distribution matrices
			setdatafolder $SDtserfldrfp
			make /o/n=(nSDpts, nSizeBins) $currprefix+ksSP2pbpSDtserNumbDistr=NaN
			wave SD_BCnumbDistr=$currprefix+ksSP2pbpSDtserNumbDistr
			note SD_BCnumbDistr, "dN/dlogDp [#/cm], BC number size distribution;"
			note SD_BCnumbDistr, "corresponding diameter scales: "+currprefix+ksSP2pbpSDtserDiamMidpt+" and "+currprefix+ksSP2pbpSDtserDiamBdr+";"
			note SD_BCnumbDistr, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nSDpts, nSizeBins) $currprefix+ksSP2pbpSDtserMassDistr=NaN
			wave SD_BCmassDistr=$currprefix+ksSP2pbpSDtserMassDistr
			note SD_BCmassDistr, "dM/dlogDp [g/m], BC mass size distribution;"
			note SD_BCmassDistr, "corresponding diameter scales: "+currprefix+ksSP2pbpSDtserDiamMidpt+" and "+currprefix+ksSP2pbpSDtserDiamBdr+";"
			note SD_BCmassDistr, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		//extract concentration and size distribution time series
			//loop over points of time series
			pind=0
			for (tind=0; tind<nSDpts; tind+=1)
				currstart=SD_TimeBdr[tind]
				currend=SD_TimeBdr[tind+1]
				numbBCsum=0
				massBCsum=0
				CurrDiamList=NaN
				//count number of particles in current time interval
					//check whether measurement has already started
					if (TimeDate[pind]>=currend)
						//measurement started later => continue
						continue
					endif
					//search first particle within current interval	
					do
						if (TimeDate[pind]>=currstart)
							//=> first particle within interval
							firstpind=pind		//remember index of first particle
							break
						endif
						pind+=1
					while (pind<nTriggers)
					if (pind==nTriggers)
						//end of measurement reached
						break
					endif		
					//count particles within current interval
					count=0
					do
						//count this particle
						count+=1		//total triggers
						if (Classification[pind] & currEventBit)		//events corresponding to current channel only
							numbBCsum+=1
							massBCsum+=BCmassPBP[pind]
							CurrDiamList[count]=BCdiamPBPorig[pind]
						endif
						tempDim=numpnts(CurrDiamList)
						pind+=1
						if (count==tempDim)
							//make sure that the temporary diameter list waves are big enough ...
							RedimensionNaNmg(CurrDiamList, 0, tempDim+10000)
						endif
					while (TimeDate[pind]<currend && pind<nTriggers)
				//fractional coverage of current interval by the measurement
				totsampletimeeff=SumNaNrange(SampleInterval, firstpind, pind-1)
				fractsaveloadfact=(TimeElapsedEff[pind-1]-TimeElapsedEff[firstpind-1])/(TimeDate[pind-1]-TimeDate[firstpind-1])		//mean fraction of total triggered particles eventually loaded into the file
				totsamplevolume=SumNaNrange(SampleVolume, firstpind, pind-1)
				coverage=(totsampletimeeff/fractsaveloadfact)/(currend-currstart)
				//determine size distribution
				HistogramMGNaN(CurrDiamList, CurrNumbSizeDistr, SD_BCdiamBdr)
				//copy concentration values to target waves if fractional coverage is sufficiently high
				if (coverage>kSP2SDTserMinCoverage)
					//units:
						//numbXXXX; [#]
						//massXXXX; [fg]
						//sample volume: [m]
						//sampletime: [s]
						//SD_BCnumbConcXXXX: [#/cm]
						//SD_BCmassConcXXXX: [g/m]
						//SD_BCnumbDistrXXXX: [#/cm]
						//SD_BCmassDistrXXXX: [g/m]
					//copy to target waves
						SD_numbTotTrig[tind]=count	//note: unnecessarily this wave is calculated with each iteration (simplest way of programming)
						SD_numbConcTotTrig[tind]=count/(totsamplevolume*1e6)
						Tser_BC_numb[tind]=numbBCsum
						Tser_BCnumbConc[tind]=numbBCsum/(totsamplevolume*1e6)
						Tser_BCmassConc[tind]=(massBCsum*1e-9)/totsamplevolume
						SD_BCnumbDistr[tind][]=CurrNumbSizeDistr[q]/DeltaLogDp/(totsamplevolume*1e6)
						SD_BCmassDistr[tind][]=SD_BCnumbDistr[p][q]*pi/6*SD_BCdiamMidpt[q]^3*BCdensity*1e-12		//unit conversion factor: nm/cm*kg => g
				endif
			endfor
	endfor
	//loop over scattering channels and get size distribution time series
	string scattchanlist=SP2_ChanListScattOnly()+SP2_ChanListCombScattOnly()
	string ScattListForEventBits=SP2_ChanListScattOnly()+SP2_ChanListCombScattLowDiam()
	variable nScattChans=itemsinlist(scattchanlist)
	variable LogDminScatt, LogDmaxScatt, DeltaLogDpScatt, numbScattSum
	for (chanind=0; chanind<nScattChans; chanind+=1)
		currprefix=stringfromlist(chanind, scattchanlist)
		currEventPrefix=stringfromlist(chanind, ScattListForEventBits)
		currEventBit=SP2chanPrefix2chanProperty(currEventPrefix, 0)	
		//access channel-specific PBP waves	
		setdatafolder $pbpfldrfp
		wave /Z OptDiamOrig=$currprefix+ksSP2pbpOptDiam
		//check data availability
		CurrChanAvailable= waveexists(OptDiamOrig)
		//continue with next channel if no data waves are available
		if(!CurrChanAvailable)
			//no analysed data waves available => proceed with next channel
			continue
		endif	
		//prepare concentration time series waves 
		setdatafolder $SDtserfldrfp
		make /o/n=(nSDpts) $currprefix+ksSP2timeSeriesNumbBnam=NaN
		wave Tser_Scatt_numb=$currprefix+ksSP2timeSeriesNumbBnam
		note Tser_Scatt_numb, "number of detected particles [#] with scattering peak height above threshold;"
		make /o/n=(nSDpts) $currprefix+ksSP2timeSeriesNumbConcBnam=NaN
		wave Tser_ScattNumbConc=$currprefix+ksSP2timeSeriesNumbConcBnam
		note Tser_ScattNumbConc, "number concentration [#/cm] of detected particles with scattering peak height above threshold;"
		note Tser_ScattNumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		//prepare size distribution waves
			//get diameter scale for histograms
			setdatafolder $SDtserfldrfp
			LogDminScatt=log(MinFromWaveNaN(OptDiamOrig, mode=1))			//log of minimum diameter of all data points
			LogDmaxScatt=log(MaxFromWaveNaN(OptDiamOrig, mode=1))		//log of maximum diameter of all data points
			DeltaLogDpScatt=(LogDmaxScatt-LogDminScatt)/nSizeBins						//logarithmic bin width
			make /o/n=(nSizeBins+1) $currprefix+ksSP2pbpSDtserDiamBdr=10^(LogDminScatt+p*DeltaLogDpScatt)
			wave SD_ScattDiamBdr=$currprefix+ksSP2pbpSDtserDiamBdr
			note SD_ScattDiamBdr, "Bin boundary diameters [nm] for size distribution matrices "+currprefix+ksSP2pbpSDtserNumbDistr+" and "+currprefix+ksSP2pbpSDtserMassDistr+";"
			make /o/n=(nSizeBins) $currprefix+ksSP2pbpSDtserDiamMidpt=10^(LogDminScatt+(p+0.5)*DeltaLogDpScatt)
			wave SD_ScattDiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
			note SD_ScattDiamMidpt, "Midpoint diameters [nm] for size distribution matrices "+currprefix+ksSP2pbpSDtserNumbDistr+" and "+currprefix+ksSP2pbpSDtserMassDistr+";"
			//size distribution matrices
			setdatafolder $SDtserfldrfp
			make /o/n=(nSDpts, nSizeBins) $currprefix+ksSP2pbpSDtserNumbDistr=NaN
			wave SD_ScattNumbDistr=$currprefix+ksSP2pbpSDtserNumbDistr
			note SD_ScattNumbDistr, "dN/dlogDopt [#/cm], number size distribution of purely scattering particles;"
			note SD_ScattNumbDistr, "corresponding diameter scales: "+currprefix+ksSP2pbpSDtserDiamMidpt+" and "+currprefix+ksSP2pbpSDtserDiamBdr+";"
			note SD_ScattNumbDistr, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		//extract concentration and size distribution time series
			//loop over points of time series
			pind=0
			for (tind=0; tind<nSDpts; tind+=1)
				currstart=SD_TimeBdr[tind]
				currend=SD_TimeBdr[tind+1]
				numbScattSum=0
				CurrDiamList=NaN
				//count number of particles in current time interval
					//check whether measurement has already started
					if (TimeDate[pind]>=currend)
						//measurement started later => continue
						continue
					endif
					//search first particle within current interval	
					do
						if (TimeDate[pind]>=currstart)
							//=> first particle within interval
							firstpind=pind		//remember index of first particle
							break
						endif
						pind+=1
					while (pind<nTriggers)
					if (pind==nTriggers)
						//end of measurement reached
						break
					endif		
					//count particles within current interval
					count=0
					do
						//count this particle
						count+=1		//total triggers
						if (Classification[pind] & currEventBit)		//events corresponding to current channel only
							numbScattSum+=1
							CurrDiamList[count]=OptDiamOrig[pind]
						endif
						tempDim=numpnts(CurrDiamList)
						pind+=1
						if (count==tempDim)
							//make sure that the temporary diameter list waves are big enough ...
							RedimensionNaNmg(CurrDiamList, 0, tempDim+10000)
						endif
					while (TimeDate[pind]<currend && pind<nTriggers)
				//fractional coverage of current interval by the measurement
				totsampletimeeff=SumNaNrange(SampleInterval, firstpind, pind-1)
				fractsaveloadfact=(TimeElapsedEff[pind-1]-TimeElapsedEff[firstpind-1])/(TimeDate[pind-1]-TimeDate[firstpind-1])		//mean fraction of total triggered particles eventually loaded into the file
				totsamplevolume=SumNaNrange(SampleVolume, firstpind, pind-1)
				coverage=(totsampletimeeff/fractsaveloadfact)/(currend-currstart)
				//determine size distribution
				HistogramMGNaN(CurrDiamList, CurrNumbSizeDistr, SD_ScattDiamBdr)
				//copy concentration values to target waves if fractional coverage is sufficiently high
				if (coverage>kSP2SDTserMinCoverage)
					//units:
						//numbXXXX; [#]
						//massXXXX; [fg]
						//sample volume: [m]
						//sampletime: [s]
						//SD_BCnumbConcXXXX: [#/cm]
						//SD_BCmassConcXXXX: [g/m]
						//SD_BCnumbDistrXXXX: [#/cm]
						//SD_BCmassDistrXXXX: [g/m]
					//copy to target waves
						//broadband
						SD_numbTotTrig[tind]=count	//note: unnecessarily this wave is calculated with each iteration (simplest way of programming)
						Tser_Scatt_numb[tind]=numbScattSum
						Tser_ScattNumbConc[tind]=numbScattSum/(totsamplevolume*1e6)
						SD_ScattNumbDistr[tind][]=CurrNumbSizeDistr[q]/DeltaLogDpScatt/(totsamplevolume*1e6)
				endif
			endfor
	endfor
	//fit lognormal to BC size distributions
	if (FitLogNorm==1)
		SP2_LogNormFitSDtimeSeries("", SDtserfldrfp=SDtserfldrfp)
	endif
	//display results
	if (MakeGraph)
		SD_LogNormFitNumbSlider(SDtserfldrfp=SDtserfldrfp)
		SD_LogNormFitMassSlider(SDtserfldrfp=SDtserfldrfp)
		SD_NumbSizeDistScattSlider(SDtserfldrfp=SDtserfldrfp)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


Function SP2_LogNormFitSDtimeSeries(ctrlname [SDtserfldrfp, DmeasMin, DmeasMax, DfullMin, DfullMax, nDistrPts]) : ButtonControl
	//This function fits lognormal distributions to each size distribution of a time series extracted by "SP2_SizeDistTimeSeriesExtractor"
	//return value: 0; not used
	//martin.gysel@psi.ch; 14/06/2009, 06/10/2009, 05/11/2009, 03/05/2010, 16/05/2011
	string ctrlname		//name of button control; not used
	string SDtserfldrfp		//full path to folder containing the size distribution time series data
						//default: browse for folder
	variable DmeasMin	//minimum diameter of the measurement to be included in the fit and mass (number) calculation of the measurement
						//default: use panel setting
	variable DmeasMax	//maximum diameter of the measurement to be included in the fit and the mass (number) calculation of the measurement
						//default: use panel setting
						//note: the uppermost size bin, which contains the saturated particles, is not included in the fit
	variable DfullMin		//minimum diameter to be included in the mass (number) calculation of the fitted size distribution
						//default: use panel setting
	variable DfullMax		//maximum diameter to be included in the mass (number) calculation of the fitted size distribution
						//default: use panel setting
	variable nDistrPts		//number of points for fitted lognormal size distribution
						//default: use panel setting
		
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(SDtserfldrfp))
		SDtserfldrfp=BrowseForFolder("Select folder containing the size distribution time series data:", StartPath=savedDF)
		if (stringmatch(SDtserfldrfp,"cancelled"))
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	if (paramisdefault(DmeasMin))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDmeasMin=$ksSP2LogNormFitDmeasMin
		DmeasMin=LogNormFitDmeasMin
	endif	
	if (paramisdefault(DmeasMax))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDmeasMax=$ksSP2LogNormFitDmeasMax
		DmeasMax=LogNormFitDmeasMax
	endif	
	if (paramisdefault(DfullMin))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDfitMin=$ksSP2LogNormFitDfitMin
		DfullMin=LogNormFitDfitMin
	endif
	if (paramisdefault(DfullMax))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitDfitMax=$ksSP2LogNormFitDfitMax
		DfullMax=LogNormFitDfitMax
	endif
	if (paramisdefault(nDistrPts))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LogNormFitnPts=$ksSP2LogNormFitnPts	
		nDistrPts=LogNormFitnPts
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2SDtserFitLogNorm
	string tmpfldrpath=getdatafolder(1)
	//various variables
	variable rind, nRows, nColsMeas
	string incchanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string currprefix
	variable chanind
	variable nIncChans=itemsinlist(incchanlist)
	//loop over incandescence channels to fit lognormal size distributions
	for (chanind=0; chanind<nIncChans; chanind+=1)
		//get prefix of current channel
		currprefix=stringfromlist(chanind, incchanlist)
		//access size distribution data
		setdatafolder $SDtserfldrfp
		wave /Z BCdiamCutLow=$currPrefix+ksSP2pbpDiamCutLow		
		wave /Z SD_BCdiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
		wave /Z SD_BCnumbDistr=$currprefix+ksSP2pbpSDtserNumbDistr
		wave /Z SD_BCmassDistr=$currprefix+ksSP2pbpSDtserMassDistr
		if (!waveexists(SD_BCdiamMidpt))
			//no data of current channel available => proceed with next channel
			continue
		endif
		//dimensions
		nRows=dimsize(SD_BCnumbDistr,0)
		nColsMeas=dimsize(SD_BCnumbDistr,1)
		//prepare waves for fitted lognormal distributions
		setdatafolder $SDtserfldrfp
		make /o/n=(nRows,4) $currprefix+ksSP2pbpSDtserLognormNumbCoef=NaN
		wave LognormNumbCoef=$currprefix+ksSP2pbpSDtserLognormNumbCoef
		note LognormNumbCoef, "Coefficients of fitted lognormal number size distributions;"
		make /o/n=(nRows,4) $currprefix+ksSP2pbpSDtserLognormMassCoef=NaN
		wave SD_LognormMassCoef=$currprefix+ksSP2pbpSDtserLognormMassCoef
		note SD_LognormMassCoef, "Coefficients of fitted lognormal mass size distributions;"
		make /o/n=(nDistrPts) $currprefix+ksSP2pbpSDtserLognormDiamMidpt=NaN
		wave SD_LognormDiamMidpt=$currprefix+ksSP2pbpSDtserLognormDiamMidpt
		note SD_LognormDiamMidpt, "Midpoint diameter [nm] scale corresponding to columns of fitted lognormal size distributions;"
		make /o/n=(nDistrPts+1) $currprefix+ksSP2pbpSDtserLognormDiamBdr=NaN
		wave SD_LognormDiamBdr=$currprefix+ksSP2pbpSDtserLognormDiamBdr
		note SD_LognormDiamBdr, "Boundary diameter [nm] scale corresponding to columns of fitted lognormal size distributions;"
		make /o/n=(nRows,nDistrPts) $currprefix+ksSP2pbpSDtserLognormNumbDistr=NaN
		wave SD_LognormNumbDistr=$currprefix+ksSP2pbpSDtserLognormNumbDistr
		note SD_LognormNumbDistr, "Fitted lognormal number size distributions;"
		note SD_LognormNumbDistr, "dN/dlogDp, [#/cm];"
		note SD_LognormNumbDistr, "diameter scale corresponding to columns in the waves "+currprefix+ksSP2pbpSDtserLognormDiamMidpt+" and "+currprefix+ksSP2pbpSDtserLognormDiamBdr+";"
		make /o/n=(nRows,nDistrPts) $currprefix+ksSP2pbpSDtserLognormMassDistr=NaN
		wave SD_LognormMassDistr=$currprefix+ksSP2pbpSDtserLognormMassDistr
		note SD_LognormMassDistr, "Fitted lognormal mass size distributions;"
		note SD_LognormMassDistr, "dM/dlogDp, [g/m];"
		note SD_LognormMassDistr, "diameter scale corresponding to columns in the waves "+currprefix+ksSP2pbpSDtserLognormDiamMidpt+" and "+currprefix+ksSP2pbpSDtserLognormDiamBdr+";"
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognormNumbConc=NaN
		wave SD_LognormNumbConc=$currprefix+ksSP2pbpSDtserLognormNumbConc
		note SD_LognormNumbConc, "Integrated number concentration [#/cm] of fitted lognormal number size distributions;"	
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognormMassConc=NaN
		wave SD_LognormMassConc=$currprefix+ksSP2pbpSDtserLognormMassConc
		note SD_LognormMassConc, "Integrated BC mass concentration [g/m] of fitted lognormal mass size distributions;"
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognMassGmeanDp=NaN
		wave SD_LognormMassGmeanDp=$currprefix+ksSP2pbpSDtserLognMassGmeanDp
		note SD_LognormMassGmeanDp, "Geometric mean diameter [nm] of fitted lognormal mass size distributions;"
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognNumbGmeanDp=NaN
		wave SD_LognormNumbGmeanDp=$currprefix+ksSP2pbpSDtserLognNumbGmeanDp
		note SD_LognormNumbGmeanDp, "Geometric mean diameter [nm] of fitted lognormal number size distributions;"
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognormNumbBlwCt=NaN
		wave Tser_BCnumbConcBlwCt=$currprefix+ksSP2pbpSDtserLognormNumbBlwCt
		note Tser_BCnumbConcBlwCt, "estimated number concentration [#/cm] of BC particles with incandescence peak height below detection limit;"
		note Tser_BCnumbConcBlwCt, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		make /o/n=(nRows) $currprefix+ksSP2pbpSDtserLognormMassBlwCt=NaN
		wave Tser_BCmassConcBlwCt=$currprefix+ksSP2pbpSDtserLognormMassBlwCt
		note Tser_BCmassConcBlwCt, "estimated mass concentration [#/cm] of BC particles with incandescence peak height below detection limit;"
		note Tser_BCmassConcBlwCt, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+" and "+ksSP2timeSeriesTimeCtr+";"
		//temporary waves
		setdatafolder $tmpfldrpath
		make /o/n=4 CurrFitCoefNumbBC, CurrFitCoefMassBC
		make /o/n=(nColsMeas) CurrDiamScaleBC, CurrdNdlogDpBC, CurrdMdlogDpBC
		make /o/n=(nDistrPts) CurrFitteddNdlogDpBC, CurrFitteddMdlogDpBC, CurrFittedDpScaleBC
		//loop over size distributions and fit lognormal
		CurrDiamScaleBC=SD_BCdiamMidpt
		for (rind=0; rind<nRows; rind+=1)
			//copy measurement to 1-D temporary wave
			CurrdNdlogDpBC=SD_BCnumbDistr[rind][p]
			CurrdMdlogDpBC=SD_BCmassDistr[rind][p]
			//fit lognormal number and mass size distribution
			SD_LognormNumbConc[rind]=imag(SP2_LogNormSizeDistrFit(CurrdNdlogDpBC, CurrDiamScaleBC, DmeasMin=DmeasMin, DmeasMax=DmeasMax, DfullMin=DfullMin, DfullMax=DfullMax, LogNormParam=CurrFitCoefNumbBC, dYdlogDpFitted=CurrFitteddNdlogDpBC, DpScaleFitted=CurrFittedDpScaleBC, nDistrPts=nDistrPts))
			SD_LognormMassConc[rind]=imag(SP2_LogNormSizeDistrFit(CurrdMdlogDpBC, CurrDiamScaleBC, DmeasMin=DmeasMin, DmeasMax=DmeasMax, DfullMin=DfullMin, DfullMax=DfullMax, LogNormParam=CurrFitCoefMassBC, dYdlogDpFitted=CurrFitteddMdlogDpBC, DpScaleFitted=CurrFittedDpScaleBC, nDistrPts=nDistrPts))
			//copy fit to results wave
			if (rind==0)
				//copy diameter scale of fitted size distributions at first iteration only
				SD_LognormDiamMidpt=CurrFittedDpScaleBC
				BinCentresToBoundariesLog(SD_LognormDiamMidpt, SD_LognormDiamBdr)
				ScaleCopyFromWavToWav(CurrFittedDpScaleBC, 0, SD_LognormNumbDistr, 1)
				ScaleCopyFromWavToWav(CurrFittedDpScaleBC, 0, SD_LognormMassDistr, 1)
			endif
			LognormNumbCoef[rind][]=CurrFitCoefNumbBC[q]
			SD_LognormMassCoef[rind][]=CurrFitCoefMassBC[q]
			SD_LognormNumbDistr[rind][]=CurrFitteddNdlogDpBC[q]
			SD_LognormMassDistr[rind][]=CurrFitteddMdlogDpBC[q]
			//calculate estimated number/mass concentration below the lower detection limit
			Tser_BCnumbConcBlwCt[rind]=DistribMomentumScaledWavRange(CurrFitteddNdlogDpBC, 0, 1, xmax=log(BCdiamCutLow[0]))
			Tser_BCmassConcBlwCt[rind]=DistribMomentumScaledWavRange(CurrFitteddMdlogDpBC, 0, 1, xmax=log(BCdiamCutLow[0]))
		endfor		
		//copy geometric mean Dp from coefficients wave to separate wave
		SD_LognormMassGmeanDp=SD_LognormMassCoef[p][3]
		SD_LognormNumbGmeanDp=LognormNumbCoef[p][3]
	endfor
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end

Function SP2_ConcatenateRawDataFldrs(ctrlname [MainRawFldrFP, AppendRawFldrFP]) : ButtonControl
	//This function concatenates SP2 raw data folders including configuration subfolder (":INI") and postprocessing folder (..._PBP).
	//note: Any postprocessing other than trace analysis must be repeated separately (though I should add this option later).
	//note: Configuration and PBP folders are automatically concatenated if they are present
	//return value: 0; not used
	//martin.gysel@psi.ch; 13/07/2009
	string ctrlname	//name of button control; not used
	string MainRawFldrFP		//full path to SP2 raw data folder to which the data from "AppendRawFldrFP" are to be appended
							//default: browse for folder
	string AppendRawFldrFP	//full path to SP2 raw data folder which is to be appended to "MainRawFldrFP".
							//default: browse for folder
		
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set default values
	if (paramisdefault(MainRawFldrFP))
		MainRawFldrFP=SP2_getFolder(type="raw", promptText= "Select target SP2 raw data folder:", alwaysPrompt=1)
		if (stringmatch(MainRawFldrFP, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif	
	endif
	if (paramisdefault(AppendRawFldrFP))
		AppendRawFldrFP=SP2_getFolder(type="raw", promptText= "Select SP2 raw data folder which is to be appended:", alwaysPrompt=1)
		if (stringmatch(AppendRawFldrFP, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif	
	endif
	
	// ensure inputs differ [v4111a]
	if (stringMatch(MainRawFldrFP, AppendRawFldrFP))
		SP2_abort("Input and output folders identical--aborting.")
	endif
	
	//concatenate raw data folder
		variable rawmaindim, rawappdim
		//access special waves
			//data from target folder
			setdatafolder $MainRawFldrFP
			wave/z TimeDate=$ksSP2TimeDate
			wave/z TimeElapsedMeas=$ksSP2TimeElapsedMeas
			wave/z TimeElapsedEff=$ksSP2TimeElapsedEff
			rawmaindim=dimsize(TimeDate,0)
			wave/z scattTraceMatMain=$ksSP2SCHGprefix+ksSP2rawtracemat
			wave/z broadTraceMatMain=$ksSP2BBHGprefix+ksSP2rawtracemat
			wave/z narrTraceMatMain=$ksSP2NBHGprefix+ksSP2rawtracemat
			wave/z splitTraceMatMain=$ksSP2SPHGprefix+ksSP2rawtracemat
			//data from folder which is to be appended
			setdatafolder $AppendRawFldrFP
			wave/z AppTimeDate=$ksSP2TimeDate
			rawappdim=dimsize(AppTimeDate,0)
			wave/z scattTraceMatApp=$ksSP2SCHGprefix+ksSP2rawtracemat
			wave/z broadTraceMatApp=$ksSP2BBHGprefix+ksSP2rawtracemat
			wave/z narrTraceMatApp=$ksSP2NBHGprefix+ksSP2rawtracemat
			wave/z splitTraceMatApp=$ksSP2SPHGprefix+ksSP2rawtracemat
		//concatenate raw trace matrices
			//scattering channel
			variable tracelenmain, tracelenapp
			if (waveexists(scattTraceMatMain) && waveexists(scattTraceMatApp))
				tracelenmain=dimsize(scattTraceMatMain,1)
				tracelenapp=dimsize(scattTraceMatApp,1)
				if (tracelenapp>tracelenmain)
					RedimensionNaNmg(scattTraceMatMain, 1, tracelenapp)
				endif
				redimension /s scattTraceMatMain		//must convert to single precision floating point in order to enable "NaN"	
				RedimensionNaNmg(scattTraceMatMain, 0, rawmaindim+rawappdim)
				scattTraceMatMain[rawmaindim,rawmaindim+rawappdim-1][0,tracelenapp-1]=scattTraceMatApp[p-rawmaindim][q]
			endif
			//broadband channel
			if (waveexists(broadTraceMatMain) && waveexists(broadTraceMatApp))
				tracelenmain=dimsize(broadTraceMatMain,1)
				tracelenapp=dimsize(broadTraceMatApp,1)
				if (tracelenapp>tracelenmain)
					RedimensionNaNmg(broadTraceMatMain, 1, tracelenapp)
				endif
				redimension /s broadTraceMatMain		//must convert to single precision floating point in order to enable "NaN"	
				RedimensionNaNmg(broadTraceMatMain, 0, rawmaindim+rawappdim)
				broadTraceMatMain[rawmaindim,rawmaindim+rawappdim-1][0,tracelenapp-1]=broadTraceMatApp[p-rawmaindim][q]
			endif
			//narrowband channel
			if (waveexists(narrTraceMatMain) && waveexists(narrTraceMatApp))
				tracelenmain=dimsize(narrTraceMatMain,1)
				tracelenapp=dimsize(narrTraceMatApp,1)
				if (tracelenapp>tracelenmain)
					RedimensionNaNmg(narrTraceMatMain, 1, tracelenapp)
				endif
				redimension /s narrTraceMatMain		//must convert to single precision floating point in order to enable "NaN"	
				RedimensionNaNmg(narrTraceMatMain, 0, rawmaindim+rawappdim)
				narrTraceMatMain[rawmaindim,rawmaindim+rawappdim-1][0,tracelenapp-1]=narrTraceMatApp[p-rawmaindim][q]
			endif
			//splitering channel
			if (waveexists(splitTraceMatMain) && waveexists(splitTraceMatApp))
				tracelenmain=dimsize(splitTraceMatMain,1)
				tracelenapp=dimsize(splitTraceMatApp,1)
				if (tracelenapp>tracelenmain)
					RedimensionNaNmg(splitTraceMatMain, 1, tracelenapp)
				endif
				redimension /s splitTraceMatMain		//must convert to single precision floating point in order to enable "NaN"	
				RedimensionNaNmg(splitTraceMatMain, 0, rawmaindim+rawappdim)
				splitTraceMatMain[rawmaindim,rawmaindim+rawappdim-1][0,tracelenapp-1]=splitTraceMatApp[p-rawmaindim][q]
			endif
		//concatenate all other raw data waves
			ConcatenateDataFldrs(MainRawFldrFP, rawmaindim, AppendRawFldrFP, rawappdim)
		//adapt "TimeElapsed" waves
			TimeElapsedMeas[rawmaindim,inf]+=TimeElapsedMeas[rawmaindim-1]
			TimeElapsedEff[rawmaindim,inf]+=TimeElapsedEff[rawmaindim-1]
	//concatenate configuration data ("INI")
		string inimainfp, iniappfp=""
		variable inimaindim, iniappdim
		inimainfp=SP2_RawFldrFP2iniFldrFP(MainRawFldrFP)
		iniappfp=SP2_RawFldrFP2iniFldrFP(AppendRawFldrFP)	
		if ( datafolderexists(inimainfp) && datafolderexists(iniappfp) )
			//preparations
			setdatafolder $inimainfp
			wave DataAlliniMain=$ksSP2configdataAll
			inimaindim=dimsize(DataAlliniMain,0)
			setdatafolder $iniappfp
			wave DataAlliniApp=$ksSP2configdataAll
			iniappdim=dimsize(DataAlliniApp,0)
			//concatenate
			ConcatenateDataFldrs(inimainfp, inimaindim, iniappfp, iniappdim)
		endif
	//concatenate PBP data
	string PBPmainfp, PBPappfp
	PBPmainfp=SP2_RawFldrFP2PBPfldrFP(MainRawFldrFP)
	PBPappfp=SP2_RawFldrFP2PBPfldrFP(AppendRawFldrFP)
	if ( datafolderexists(PBPmainfp) && datafolderexists(PBPappfp) )	
		ConcatenateDataFldrs(PBPmainfp, rawmaindim, PBPappfp, rawappdim)
	endif
	//kill folders which have been appended
	killdatafolder /z $iniappfp						
	killdatafolder /z $AppendRawFldrFP							
	killdatafolder /z $PBPappfp					
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_ConcatenateHKfldrs(ctrlname [MainHKfldrFP, AppendHKfldrFP]) : ButtonControl
	//This function concatenates SP2 housekeeping data folders.
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/08/2009, 26/08/2009
	string ctrlname			//name of button control; not used
	string MainHKfldrFP		//full path to SP2 housekeeping data folder to which the data from "AppendHKfldrFP" are to be appended
							//default: browse for folder
	string AppendHKfldrFP	//full path to SP2 housekeeping data folder which is to be appended to "MainHKfldrFP".
							//default: browse for folder
		
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values
	if (paramisdefault(MainHKfldrFP))
		MainHKfldrFP=SP2_getFolder(type="HK", promptText= "Select target SP2 housekeeping data folder:", alwaysPrompt=1)
	endif
	if (paramisdefault(AppendHKfldrFP))
		AppendHKfldrFP=SP2_getFolder(type="HK", promptText= "Select SP2 housekeeping data folder which is to be appended:", alwaysPrompt=1)
	endif
	
	// ensure inputs differ [v4111a]
	if (stringMatch(MainHKfldrFP, AppendHKfldrFP))
		SP2_abort("Input and output folders identical--aborting.")
	endif
	
	//concatenate housekeeping folders data folder
		//access waves
		setdatafolder $MainHKfldrFP
		wave MainTimeStampHK=$ksSP2hkTimeStamp
		variable MainDim=dimsize(MainTimeStampHK,0)
		setdatafolder $AppendHKfldrFP
		wave AppendTimeStampHK=$ksSP2hkTimeStamp
		variable AppendDim=dimsize(AppendTimeStampHK,0)
		//concatenate
		ConcatenateDataFldrs(MainHKfldrFP, MainDim, AppendHKfldrFP, AppendDim, KillMode=1)
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_CalibScattInfoWavesPrepButt(ctrlname [, PSLinfoFldrFP, nSamples]) : ButtonControl
	//This function prepares the info waves required for analysing a calibration of the scattering detector using PSL's.
	//return value: 0; not used
	//martin.gysel@psi.ch; 19/08/2009;
	string ctrlname		//name of button control; not used
	string PSLinfoFldrFP	//full path to folder in which the info waves about the PSL calibration of the scattering detector are stored
						//default: prompt
	variable nSamples	//number of rows for the PSL calibration info waves
						//default: prompt
	
	//preparations:
	string savedDF=getdatafolder(1)
	//set defaults
	variable MustPormpt=0
	if (paramisdefault(PSLinfoFldrFP))
		PSLinfoFldrFP="root:PSLcalib:YYYYMMDD"
		MustPormpt=1
	endif
	if (paramisdefault(nSamples))
		nSamples=1
		MustPormpt=1
	endif
	if (MustPormpt==1)
		prompt PSLinfoFldrFP, "Full path to folder for the info waves about the PSL calibration:"
		prompt nSamples, "Number of rows for PSL calibration info waves (number of different samples):"
		doprompt "Target Folder and Number of Samples", PSLinfoFldrFP, nSamples
		if (V_flag)
			setdatafolder $savedDF
			abort "User cancelled procedure!"	
		endif
	endif
	PSLinfoFldrFP=QuoteLiberalPath(PSLinfoFldrFP)
	//create PSL calibration info waves	
	CreateFoldersOfFullPath(PSLinfoFldrFP, 0)
	setdatafolder $PSLinfoFldrFP
	make /o/t/n=(nSamples) $ksSP2_FileDateFirst="YYYYMMDD"
	wave /t FileDateFirst=$ksSP2_FileDateFirst
	note FileDateFirst, "Date of first SP2 raw data file corresponding to current PSL sample;"
	note FileDateFirst, "e.g. \"20090522\" for file 20090522x009.sp2b;"
	note FileDateFirst, "This information is only required if the start and end times of current PSL sample are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileDateLast="YYYYMMDD"
	wave /t FileDateLast=$ksSP2_FileDateLast
	note FileDateLast, "Date of last SP2 raw data file corresponding to current PSL sample;"
	note FileDateLast, "e.g. \"20090522\" for file 20090522x009.sp2b;"
	note FileDateLast, "This information is only required if the start and end times of current PSL sample are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileNumFirst=""
	wave /t FileNumFirst=$ksSP2_FileNumFirst
	note FileNumFirst, "number of first SP2 raw data file corresponding to current PSL sample;"
	note FileNumFirst, "e.g. \"009\" for file 20090522x009.sp2b;"
	note FileNumFirst, "This information is only required if the start and end times of current PSL sample are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileNumLast=""
	wave /t FileNumLast=$ksSP2_FileNumLast
	note FileNumLast, "number of last SP2 raw data file corresponding to current PSL sample;"
	note FileNumLast, "e.g. \"009\" for file 20090522x009.sp2b;"
	note FileNumLast, "This information is only required if the start and end times of current PSL sample are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_SampleID=""
	wave /t SampleID=$ksSP2_SampleID
	note SampleID, "Provide any information string about the current PSL sample"
	make /o/n=(nSamples) $ksSP2_monodi_DiamList=NaN
	wave DiamList=$ksSP2_monodi_DiamList
	note DiamList, "Nominal diameter [nm] of current PSL sample;"
	make /o/n=(nSamples) $ksSP2_monodi_ConcList=NaN
	wave ConcList=$ksSP2_monodi_ConcList
	note ConcList, "Particle number concentration [#/cm] measured by e.g. a CPC operated in parallel;"
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeStartList=NaN
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	note TimeStartList, "start time of current PSL sample;"
	note TimeStartList, "can optionally be retrieved from the SP2 data files if the waves "+nameofwave(FileDate)+" and "+nameofwave(FileNumList)+" are completely filled in;"
	setscale d, 0, 0, "dat", TimeStartList
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeEndList=NaN
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	note TimeEndList, "end time of current PSL sample;"
	note TimeEndList, "can optionally be retrieved from the SP2 data files if the waves "+nameofwave(FileDate)+" and "+nameofwave(FileNumList)+" are completely filled in;"
	setscale d, 0, 0, "dat", TimeEndList
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeCentreList=0.5*(TimeStartList+TimeEndList)
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	note TimeCentreList, "centre time of current PSL sample;"
	note TimeCentreList, "calculated from the waves "+nameofwave(TimeStartList)+" and "+nameofwave(TimeEndList)+" if they are provided;"
	setscale d, 0, 0, "dat", TimeCentreList
	//create table
	Edit/W=(5.25,41.75,879.75,234.5) SampleID,TimeStartList,TimeCentreList,TimeEndList, FileDateFirst,FileNumFirst,FileDateLast,FileNumLast,DiamList,ConcList
	ModifyTable format(Point)=1,format(TimeStartList)=8,width(TimeStartList)=101,format(TimeEndList)=8
	ModifyTable width(TimeEndList)=101,format(TimeCentreList)=8,width(TimeCentreList)=101
	ModifyTable width(FileDateFirst)=69,width(FileNumFirst)=68,width(FileDateLast)=69
	ModifyTable width(FileNumLast)=67,width(DiamList)=62,width(ConcList)=53
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2_CalibInfogetTimesButt(ctrlname [CalibInfoFldrFP, SP2rawFldrFP]) : ButtonControl
	//This function gets the start and end times of a series of different PSL calibration measurements
	//from the time waves of the corresponding SP2 raw data files.
	//return value: 0; not used
	//martin.gysel@psi.ch; 19/08/2009; 26/08/2009
	string ctrlname		//name of but/ton control; not used
	string CalibInfoFldrFP	//full path to folder in which the info waves about the PSL calibration of the scattering detector are stored
						//default: prompt
	string SP2rawFldrFP	//full path to folder containing the previously loaded SP2 raw data
						//default: prompt
	
	//preparations:
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(CalibInfoFldrFP))
		CalibInfoFldrFP=BrowseForFolder("Select folder containing PSL calibration info waves:", StartPath=savedDF, selectStr="CalibInfo")
		if (stringmatch(CalibInfoFldrFP, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif	
	endif
	if (paramisdefault(SP2rawFldrFP))
		SP2rawFldrFP=BrowseForFolder("Select folder containing the SP2 raw data:", StartPath=savedDF)
		if (stringmatch(SP2rawFldrFP, "cancelled"))		
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif	
	endif
	//access PSL calibration info waves	
	setdatafolder $CalibInfoFldrFP	
	wave /t FileNumFirst=$ksSP2_FileNumFirst
	wave /t FileNumLast=$ksSP2_FileNumLast
	wave /t FileDateFirst=$ksSP2_FileDateFirst
	wave /t FileDateLast=$ksSP2_FileDateLast
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	variable nSamples=numpnts(FileNumFirst)
	//access SP2 raw data waves
	setdatafolder $SP2rawFldrFP
	wave SP2TimeDate=$ksSP2TimeDate
	wave /d SP2FileID=$ksSP2rawuniquefileID
	//loop over all PSL samples and get start/end times
	variable sind
	string currfilenumstr, currfilename
	variable currID, currindex, testindex
	for (sind=0; sind<nSamples; sind+=1)
		//find start time
			//NumberList_to_FirstAndLastIndex(ListStr [SepStr, RangeStr, INFval])
		currfilenumstr=number2fixedwidthintegerstring(str2num(FileNumFirst[sind]), 3)		//make sure to get 3-character string for file number
		currfilename=FileDateFirst[sind]+"x"+currfilenumstr
		currID=SP2filename2UniqueFileID(currfilename)
		testindex=BinarySearchMG(SP2FileID, currID)
		currindex=BinarySearchMG(SP2FileID, currID-0.1)			//using "currID-0.1" in order to make sure that I get the index of the first occurrence of currID
		if (testindex==-1)
			TimeStartList[sind]=SP2TimeDate[0]-1		//subtract 1 second to make sure that first data point of following file is not included	
		elseif (testindex==-2)
			TimeStartList[sind]=SP2TimeDate[inf]+1		//add 1 second to make sure that last data point of previous file is not included
		else
			TimeStartList[sind]=SP2TimeDate[currindex+1]		//using "currindex+1" in order to make sure that I get the index of the first occurrence of currID
		endif
		//find end time
		currfilenumstr=number2fixedwidthintegerstring(str2num(FileNumLast[sind]), 3)		//make sure to get 3-character string for file number
		currfilename=FileDateLast[sind]+"x"+currfilenumstr
		currID=SP2filename2UniqueFileID(currfilename)
		testindex=BinarySearchMG(SP2FileID, currID)
		currindex=BinarySearchMG(SP2FileID, currID+0.1)			//using "currID+0.1" in order to make sure that I get the index of the last occurrence of currID
		if (testindex==-1)
			TimeEndList[sind]=SP2TimeDate[0]-1		//subtract 1 second to make sure that first data point of following file is not included	
		elseif (testindex==-2)
			TimeEndList[sind]=SP2TimeDate[inf]+1		//add 1 second to make sure that last data point of previous file is not included
		else
			if (currindex==-2)
				currindex=inf		//make sure that I get the index of the last occurrence of currID
			endif
			TimeEndList[sind]=SP2TimeDate[currindex]
		endif
	endfor
	//calculate centre times
	TimeCentreList=0.5*(TimeStartList+TimeEndList)
	//finish procedure
	if(datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_CalibAnalyzerScatt(ctrlname [chanPrefix, CalibInfoFldrFP, SP2rawFldrFP, TargetFldrFP, MieDataPP, nGauss, FitRangeFact, nHistoBins, FirstHistoPt, LastHistoPt, printMode, GraphMode]) : ButtonControl
	//This function analyses data from a monodisperse calibration of the SP2's scattering channel
	//return value: 0, not used
	//martin.gysel@psi.ch; 26/08/2009, 27/08/2009, 25/06/2010, 22/10/2010, 07/01/2011
	//joel.c.corbin+sci@gmail.com; 2016-02-24 added support for SCLG and various improvements
	
	string ctrlname			//name of button control; not used
	string chanPrefix		// Channel prefix like ":SCHG_" or ":SCLG_" (function will convert "SCHG" or "SCLG" to these) 
	string CalibInfoFldrFP		//full path to folder containing the calibration info (diameters, start/end times, concentrations, ... )
							//default: browse for folder
	string SP2rawFldrFP			//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
							//default: browse for folder
	string TargetFldrFP		//full path to folder for the calibration summary waves
							//default: prompt
							//TargetFldrFP can be equal to CalibInfoFldrFP
	string MieDataPP			//partial path to subfolder containing the Mie data of the calibration material
							//default: use panel setting
	variable nGauss			//maximum number of Gaussians to be fitted
							//see subprocedure for details
	variable FitRangeFact		//determines the width of the data range about the peak position to be fitted in each iteration step
							//i.e: range fitted about peak of mode: FitRangeFact*FWHM
							//see subprocedure for details
	variable nHistoBins		//number of bins for peak height histogram
	variable FirstHistoPt		//number of leading histogram bins to be ignored during Gaussian fit
	variable LastHistoPt		//number of trailing histogram bins to be ignored during Gaussian fit
	variable GraphMode		//1 (default):	graphs are automatically shown
							//0:			graphs are not shown
	variable printMode		// boolean: print repetition command or not. default 1
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(CalibInfoFldrFP))
		// jcc v4111--try to be more user friendly
		// todo: save a global string of the last folder and access it here...
		
		DoAlert /T="SP2 toolkit" 1, "Have you already prepared tables describing the calibration files?"
		if (V_flag==2) // no--user should not have clicked this button
			
			SP2_CalibScattInfoWavesPrepButt("ScattEmptyInfoWavsButt") // click correct button
			
			string Sinfo= "Calibration procedure:"
			Sinfo+= "\r\t-check the refractive index entered on the panel."
//			Sinfo+= "\r\t-check the laser power (if updated, click 'write YAG power wave')."	// now automated below
			Sinfo+= "\r\t-in the table, enter the relevant information."
			DoAlert /T="SP2 toolkit" 0, "Fill in this table, then click calibrate again. See history for instructions."
				Sinfo+= "\r\t-You don't need to fill in all table rows. For example (after changing data folders):"
				Sinfo+= "\r\tFileDateFirst= \"20150609\""
				Sinfo+= "\r\tFileDateLast= FileDateFirst"
				Sinfo+= "\r\tFileNumFirst= num2istr(19 + p)"
				Sinfo+= "\r\tFileNumLast= FileNumFirst"
				Sinfo+= "\r\tDiamList= 269"
			Sinfo+= "\rAfterwards, run: SP2_CalibAnalyzerScatt(\"CalibAnalyseMonoScatt\")"
			
			print Sinfo
			return V_flag
		endif
		CalibInfoFldrFP=BrowseForFolder("Select folder containing the calibration info waves data:", StartPath="root:", selectStr="PSLcalib")
		if (stringmatch(CalibInfoFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	CalibInfoFldrFP=QuoteLiberalPath(CalibInfoFldrFP)
	if (paramisdefault(SP2rawFldrFP))
		SP2rawFldrFP=SP2_getFolder(startingDF="root:", type="raw", promptText="Select folder containing the SP2 raw data:")
		if (stringmatch(SP2rawFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	if (ParamIsDefault(chanPrefix))
		chanPrefix= SP2_getChanPrefix("Scatt")
	elseif (!strlen(chanPrefix)==(4+2))
		if (grepString(chanPrefix, "[A-Z]{4}"))  // was given as 4 consecutive capital letters
			chanPrefix= ":" + chanPrefix + "_"
		endif
	endif
	
	SP2rawFldrFP=QuoteLiberalPath(SP2rawFldrFP)
	string SP2PBPfldr=SP2_RawFldrFP2PBPfldrFP(SP2rawFldrFP)
	variable mustprompt=0
	if (paramisdefault(TargetFldrFP))
		TargetFldrFP=CalibInfoFldrFP
		mustprompt=1
	endif
	if (paramisdefault(nGauss))
		nGauss=3
		mustprompt=1
	endif
	if (paramisdefault(FitRangeFact))
		FitRangeFact=3
		mustprompt=1
	endif
	if (paramisdefault(nHistoBins))
		nHistoBins=200
		mustprompt=1
	endif
	if (paramisdefault(FirstHistoPt))
		FirstHistoPt=2
		mustprompt=1
	endif
	if (paramisdefault(LastHistoPt))
		LastHistoPt=2
		mustprompt=1
	endif
	if (mustprompt==1)
		prompt TargetFldrFP, "target folder for calibration summary:"
		prompt nGauss, "maximum number of Gaussians to be fitted:"
		prompt FitRangeFact, "range to fit about peak of mode: FitRangeFact*FWHM:"
		prompt nHistoBins, "num of bins for peak height histogram:"
		prompt FirstHistoPt, "num of leading histogram bins to ignore during fit:"
		prompt LastHistoPt, "num of trailing histogram bins to ignore during fit:"
		doprompt "Optional parameters", TargetFldrFP, nGauss, FitRangeFact, nHistoBins, FirstHistoPt, LastHistoPt
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message					
		endif
	endif
	variable LastPt=nHistoBins-LastHistoPt
	TargetFldrFP=QuoteLiberalPath(TargetFldrFP)
	CreateFoldersOfFullPath(TargetFldrFP, 0)
	if (paramisdefault(MieDataPP))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Svar RefractIndexID=$ksSP2scattRefractIndex
		MieDataPP=RefractIndexID
	endif
	if (paramisdefault(GraphMode))
		GraphMode=1
	endif
	if (paramisdefault(printMode))
		printMode=1
	endif
	if (printMode)	//print command to history
		string cmd=currproc
		cmd+="(\"\""
		cmd+=", chanPrefix=\""+chanPrefix+"\""
		cmd+=", GraphMode="+"0" // num2str(GraphMode) // probably user doesnt want that
		cmd+=", PrintMode="+"0"
		cmd+=", nGauss="+num2str(nGauss)
		cmd+=", FitRangeFact="+num2str(FitRangeFact)
		cmd+=", nHistoBins="+num2str(nHistoBins)
		cmd+=", CalibInfoFldrFP=\""+CalibInfoFldrFP+"\""
		cmd+=", SP2rawFldrFP=\""+SP2rawFldrFP+"\""
		cmd+=", TargetFldrFP=\""+TargetFldrFP+"\""
		cmd+=", MieDataPP=\""+MieDataPP+"\""
		cmd+=", FirstHistoPt="+num2str(FirstHistoPt)
		cmd+=", LastHistoPt="+num2str(LastHistoPt)
		cmd+=")"
		print cmd
	endif
	
	//access SP2 raw waves
	setdatafolder $SP2rawFldrFP
	wave TimeDate=$ksSP2TimeDate
	wave YAGpower=$ksSP2YAGpower
	wave SampleVolume=$ksSP2sampleVolume
	variable nRawRows=dimsize(TimeDate,0)
	
	//access SP2 PBP waves
	setdatafolder $SP2PBPfldr
	wave Scatt_FitPeakHt=$chanPrefix+ksSP2PBPscattGausspeakHeight			
	wave Classification=$ksSP2pbpClassification		
	
	//access calibration info waves
	setdatafolder $CalibInfoFldrFP
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	wave ConcListCPC=$ksSP2_monodi_ConcList
	wave DiamSetList=$ksSP2_monodi_DiamList
	variable nRows=dimsize(TimeStartList,0)
	
	//strings for storing paths to other folder
	setdatafolder $TargetFldrFP
	string /g $ksSP2calibInfoFldrFP=CalibInfoFldrFP
	string /g $ksSP2calibSP2rawDataFldrFP=SP2rawFldrFP
	
	//get start and end times if needed
	variable NaNbits
	NaNbits=CheckWaveForNaNs(TimeStartList)
	if (NaNbits & 8)
		//only NaNs in TimeStartList => get start and end times ...
		SP2_CalibInfogetTimesButt("", CalibInfoFldrFP=CalibInfoFldrFP, SP2rawFldrFP=SP2rawFldrFP)
	endif
	
	//prepare diameter list
	setdatafolder $TargetFldrFP
	make /o/n=(nRows) $ksSP2calibDiamList+ksSP2suffix1e
	wave DiamList_1e=$ksSP2calibDiamList+ksSP2suffix1e
	DiamList_1e=DiamSetList		//=> this is just a copy of DiamSetList
	
	//average laser power data
		// first ensure that laser power was loaded from HK
		ControlInfo /W=$ksSP2toolkitPanelWnam YAGpowerFromHK
				CheckBox YAGpowerFromHK win=$ksSP2toolkitPanelWnam , disable=0	// enable the box for calibration
		variable V_YAGfromHKboxChecked= V_value
		if (!V_YAGfromHKboxChecked)
			string YAGalert= "The current YAG power represents a user-chosen "
			YAGalert += "value.\rChange to the measured (HK) values instead?"
			doAlert /T="SP2toolkit" 1, YAGalert
			if (V_flag==1)//yes
				SP2_YAGpowerModeCBproc("YAGpowerFromHK", 1)						// check the box
				SP2_YAGpowerGetHKdata("", HKmode=0) // click the update button
			endif
		endif
	make /o/n=(nRows) $ksSP2_monodi_LaserPowerList=NaN
	wave LaserPowerList=$ksSP2_monodi_LaserPowerList
	note LaserPowerList, "Mean laser power [V] (data originally taken from housekeeping file);"
	RemapTimeSeriesSimpleVar(YAGpower, TimeDate, TimeStartList, TimeEndList, LaserPowerList)
	
	//scattering channel: prepare waves
	setdatafolder $TargetFldrFP
	wave /Z Scatt_FitPkHt_1e=$chanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
	if (!waveexists(Scatt_FitPkHt_1e))	//create it if it doesn't yet exist
		make /o/n=(nRows) $chanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e=NaN	
		wave Scatt_FitPkHt_1e=$chanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
		note Scatt_FitPkHt_1e, "scattering peak height measured for current particle size;"
		note Scatt_FitPkHt_1e, "values may be manually copied from the main peak in the wave "+chanPrefix+ksSP2calibGaussModeMat+";"
	endif	
	make /o/n=(nRows,nGauss) $chanPrefix+ksSP2calibGaussAreaMat=NaN
	wave Scatt_GaussAreaMat=$chanPrefix+ksSP2calibGaussAreaMat
	make /o/n=(nRows,nGauss) $chanPrefix+ksSP2calibGaussSigmaMat=NaN
	wave Scatt_GaussSigmaMat=$chanPrefix+ksSP2calibGaussSigmaMat
	make /o/n=(nRows,nGauss) $chanPrefix+ksSP2calibGaussModeMat=NaN
	wave Scatt_GaussModeMat=$chanPrefix+ksSP2calibGaussModeMat
	make /o/n=(nRows,nGauss) $chanPrefix+ksSP2calibGaussLogModeMat=NaN
	wave Scatt_GaussLogModeMat=$chanPrefix+ksSP2calibGaussLogModeMat
	make /o/n=(nRows,nHistoBins) $chanPrefix+ksSP2calibHistoMat=NaN
	wave Scatt_HistoMat=$chanPrefix+ksSP2calibHistoMat
	make /o/n=(nRows,nHistoBins) $chanPrefix+ksSP2calibHistoMatFitted=NaN
	wave Scatt_HistoMatFitted=$chanPrefix+ksSP2calibHistoMatFitted
	make /o/n=(nRawRows) $chanPrefix+ksSP2calibLogFitPkHt=NaN
	wave Scatt_LogFitPkHt=$chanPrefix+ksSP2calibLogFitPkHt
	Scatt_LogFitPkHt=log(Scatt_FitPeakHt)
	make /o/n=(nRows) $chanPrefix+ksSP2calibConcList=NaN
	wave Scatt_ConcList=$chanPrefix+ksSP2calibConcList
	note Scatt_ConcList, "mean number concentration [#/cm] of detected scattering particles;"
	//temporary waves
	newdatafolder /o/s root:temp
	newdatafolder /o/s SP2calibScatt
	string tmpfldrpath=getdatafolder(1)
	make /o/n=0 TempGaussCoeff
	make /o/n=0 tempFittedHistogram
	make /o/n=(nHistoBins) tempHistogram
	
	//do QC on inputs--jcc v4111
	variable firstTimeGiven= wavemin(TimeStartList)
	variable lastTimeGiven= wavemax(TimeEndList)
	variable t0= wavemin(TimeDate)
	variable t1= wavemax(TimeDate) 
	if ((firstTimeGiven > t1) || (lastTimeGiven < t0))
		// no overlap between inputs and data--user probably made an error
		SP2_abort("The calibration time ranges do not match any loaded data--check your inputs.\rNote: set time waves to nan if updating dates.")
	endif
	
	//loop over calibrations
	variable cind, currstart, currend, offset, delta, Scatt_nPart, volume
	for (cind=0; cind<nRows; cind+=1)
		currstart=BinarySearch(TimeDate, TimeStartList[cind])
		currend=BinarySearch(TimeDate, TimeEndList[cind])
		//concentration of scattering particles
		volume=SumNaNrange(SampleVolume, currstart, currend)		//m^3
		volume=UnitConverterMG(20, volume)						//=> cm^3
		Scatt_nPart=BitNumberOfTrueInWave(Classification, kSP2SCHGeventBitVal, startind=currstart, endind=currend)
		Scatt_ConcList[cind]=Scatt_nPart/volume
		//histogram and Gaussian fit
		setscale /i x, log(1), log(kSP2signalAmpMax), tempHistogram
		Histogram/C/R=[currstart,currend]/B=2 Scatt_LogFitPkHt, temphistogram
		Scatt_HistoMat[cind][]=temphistogram[q]
		GaussianFITnPeaks(tempHistogram, TempGaussCoeff, nGauss=nGauss, StartPt=FirstHistoPt, EndPt=LastPt, FitRangeFact=FitRangeFact, FitGaussians=tempFittedHistogram)
		Scatt_GaussAreaMat[cind][]=TempGaussCoeff[q][1]
		Scatt_GaussSigmaMat[cind][]=TempGaussCoeff[q][2]
		Scatt_GaussLogModeMat[cind][]=TempGaussCoeff[q][3]
		Scatt_HistoMatFitted[cind][]=tempFittedHistogram[q]		
	endfor
	//some post processing
		//scaling of histogram
		ScaleCopyFromWavToWav(tempHistogram, 0, Scatt_HistoMat, 1)	
		ScaleCopyFromWavToWav(tempHistogram, 0, Scatt_HistoMatFitted, 1)	
		//mode matrix
		Scatt_GaussModeMat=10^Scatt_GaussLogModeMat
	//further calibration summary waves
	SP2_CalibAnalyzerScattPostProc("", ChanPrefix=ChanPrefix, CalibSummaryFldrFP=TargetFldrFP, MieDataPP=MieDataPP)
	//display graphs
	if (GraphMode)
		//slider graph
		SP2_CalibScattAnalyzerSlider(ChanPrefix=ChanPrefix, CalibSummaryFP=TargetFldrFP, Omode=1)
		//calibration factor graph
		SP2graph_ScattCalibFact(CalibSummaryFP=TargetFldrFP)	
	endif
	//finish procedure
	setdatafolder $savedDF
	killdatafolder /z $tmpfldrpath
	return 0
end

function SP2_CalibAnalyzerScattPostProc(ctrlname [chanPrefix, CalibSummaryFldrFP, MieDataPP]) : ButtonControl
	//Post processing of the analysis of the scattering channel
	//	- counting efficiency wave
	//	- normalizing calibrated peak height by laser power
	//return value: 0, not used
	//martin.gysel@psi.ch; 27/08/2009, 28/08/2009, 02/06/2010, 25/06/2010
	//joel.c.corbin+sci@gmail.com; 2016-02-25 added support for arbitrary channels
	string ctrlname			//name of button control; not used	
	string chanPrefix		// Channel prefix like ":SCHG_" or ":SCLG_" (function will convert "SCHG" or "SCLG" to these) 
	string CalibSummaryFldrFP	//full path to folder containing the calibration summary waves
								//default: browse for folder
	string MieDataPP			//partial path to subfolder containing the Mie data of the calibration material
							//default: use panel setting

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default
	if (paramisdefault(CalibSummaryFldrFP))
		CalibSummaryFldrFP=BrowseForFolder("Select folder containing the calibration summary waves:", StartPath=savedDF, selectStr="CalibSummary")
		if (stringmatch(CalibSummaryFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	if (ParamIsDefault(chanPrefix))
		chanPrefix= SP2_getChanPrefix("Scatt")
	elseif (!strlen(chanPrefix)==(4+2))
		if (grepString(chanPrefix, "[A-Z]{4}"))  // was given as 4 consecutive capital letters
			chanPrefix= ":" + chanPrefix + "_"
		endif
	endif
	
	CalibSummaryFldrFP=QuoteLiberalPath(CalibSummaryFldrFP)
	if (paramisdefault(MieDataPP))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Svar RefractIndexID=$ksSP2scattRefractIndex
		MieDataPP=RefractIndexID
	endif
	//access calibration summary waves
	setdatafolder $CalibSummaryFldrFP
	wave Scatt_GaussModeMat=$chanPrefix+ksSP2calibGaussModeMat
	wave Scatt_FitPkHt_1e=$chanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
	wave LaserPowerList=$ksSP2_monodi_LaserPowerList
	wave DiamList_1e=$ksSP2calibDiamList+ksSP2suffix1e
	wave Scatt_ConcList=$chanPrefix+ksSP2calibConcList
	wave ConcListCPC=$ksSP2_monodi_ConcList
	variable nRows=numpnts(Scatt_FitPkHt_1e)
	//access Mie data for purely scattering spheres
	setdatafolder $ksSP2PathToMiePureScattFldr
	setdatafolder $MieDataPP
	wave SIGvsDp=$ksSP2MIE_SIGvsDp
	
	//create and determine post processing waves
		//counting efficiency
		setdatafolder $CalibSummaryFldrFP
		make /o/n=(nRows) $chanPrefix+ksSP2calibCountEff=NaN
		wave Scatt_CountEff=$chanPrefix+ksSP2calibCountEff
		note Scatt_CountEff, "counting efficiency of scattering detector relative to CPC [-];"
		Scatt_CountEff=Scatt_ConcList/ConcListCPC
		//copy fit results to peak height wave if the latter is still empty
		variable NanCheck=CheckWaveForNaNs(Scatt_FitPkHt_1e)
		if (NanCheck&8)
			Scatt_FitPkHt_1e=Scatt_GaussModeMat[p][0]
		endif
		//normalizing calibrated peak height by laser power
		setdatafolder $CalibSummaryFldrFP
		make /o/n=(nRows) $chanPrefix+ksSP2calibFitPkHtNorm+ksSP2suffix1e=NaN	
		wave Scatt_FitPkHtNorm_1e=$chanPrefix+ksSP2calibFitPkHtNorm+ksSP2suffix1e
		note Scatt_FitPkHtNorm_1e, "scattering peak height normalised by laser power measured for current PSL size;"
		Scatt_FitPkHtNorm_1e=Scatt_FitPkHt_1e/LaserPowerList
		//normalize peak height by PSL size
		setdatafolder $CalibSummaryFldrFP
		make /o/n=(nRows) $ksSP2calibSCHGcalibFactList=NaN	
		wave Scatt_CalibFactList=$ksSP2calibSCHGcalibFactList
		note Scatt_CalibFactList, "scattering peak height normalised by PSL size according to Mie theory (and of course laser power);"
		Scatt_CalibFactList=Scatt_FitPkHtNorm_1e/InterpLinearNaNTailsScaled(DiamList_1e[p], SIGvsDp)

		//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
end


Function /S SP2filename2HKfldrFP(filename)
	//martin.gysel@psi.ch; 26/08/2009
	string filename //".sp2b" or ".hk" file name
	
	string rawfldrfp=ksSP2defRawLoadPartentFldr+SP2filename2RawDataFldrNam(filename)
	string hkfldrfp=SP2_RawFldrFP2HKfldrFP(rawfldrfp)
	return hkfldrfp
end


Function SP2_YAGpowerGetHKdata(ctrlname [SP2rawFldrFP, HKfldrFP, HKmode]) : ButtonControl
	//This function gets the YAG-power from the panel setvariable or from the housekeeping data and writes it to the SP2 raw data folder.
	//return value: 0, not used
	//martin.gysel@psi.ch; 29/08/2009; 18/12/2009, 21/10/2010, 14/09/2011
	//joel.c.corbin+sci@gmail.com; 2016-02-09 // change from doAlert to Notebook for errors 
	string ctrlname			//name of button control; not used
	string SP2rawFldrFP		//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
							//default: browse for folder
	string HKfldrFP			//full path to folder containing the housekeeping data
							//default: browse for folder
	variable HKmode			//0: use housekeeping data for YAG power
							//1: write panel value to to YAG power wave
							//default: use panel settings
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults	
	if (paramisdefault(SP2rawFldrFP))
		SP2rawFldrFP=SP2_getFolder(startingDF=savedDF, type="raw") // jcc -- BrowseForFolder("Select folder containing the SP2 raw data:", StartPath=savedDF)
		if (stringmatch(SP2rawFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	SP2rawFldrFP=QuoteLiberalPath(SP2rawFldrFP)
	if (paramisdefault(HKmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar YAGpowerMode=$ksSP2YAGpowerMode
		HKmode=YAGpowerMode
	endif
	if (HKmode==0)
		//access global string containing path to HK-folder
		setdatafolder $SP2rawFldrFP
		Svar /Z HKfldrFP_Svar=$ksSP2hkFldrFP
		if (!SVAR_Exists(HKfldrFP_Svar))
			string /g $ksSP2hkFldrFP=SP2_RawFldrFP2HKfldrFP(SP2rawFldrFP)		//try default name of housekeeping data folder
			Svar HKfldrFP_Svar=$ksSP2hkFldrFP
		endif
		//get path to housekeeping data folder
		if (paramisdefault(HKfldrFP))
			HKfldrFP=HKfldrFP_Svar
		endif
		if (datafolderexists(HKfldrFP))
			//HK-folder exists => nothing else to be done
		else
			//HK-folder does not exist => browse for housekeeping data folder
			HKfldrFP=SP2_getFolder(startingDF=savedDF, type="HK") // BrowseForFolder("Select folder with housekeeping data (''root:'' if not available):", StartPath="root:")
			if (stringmatch(HKfldrFP,"cancelled"))
				setdatafolder $savedDF
				message="User cancelled procedure"+currproc+"!"
				print message;print RTStackInfo;abort message			
			endif
			if (stringmatch(HKfldrFP,"root:"))
				//no housekeeping data available => use panel data
				HKmode=1
				HKfldrFP_Svar=" "
			endif
		endif
		HKfldrFP=QuoteLiberalPath(HKfldrFP)
		HKfldrFP_Svar=HKfldrFP
	endif
	//access SP2 raw data waves
	setdatafolder $SP2rawFldrFP
	wave TimeDate=$ksSP2TimeDate
	variable nRawRows=numpnts(TimeDate)
	//prepare and access YAG power wave in SP2 raw data
	setdatafolder $SP2rawFldrFP
	make /o/n=(nRawRows) $ksSP2YAGpower=NaN
	wave YAGpower_RM=$ksSP2YAGpower
	note YAGpower_RM, "YAG laser power [V] to be used for optical sizing;"
	//get YAG power data
	switch (HKmode)
		case 0:
			//access housekeeping waves
			setdatafolder $HKfldrFP
			wave /Z TimeStampHK=$ksSP2hkTimeStamp
			wave /Z YAGPower_HK=$ksSP2hkYAGpower
			//check whether housekeeping that are available
			variable HKmissing=0, startind, endind
			string alertstr
			if (waveexists(TimeStampHK) && waveexists(YAGPower_HK) )
				startind=BinarySearch(TimeStampHK, TimeDate[0]+kSP2hkExtrapolationSecs)		//search row index in HK-time wave corresponding to the first trigger (give it some tolerance for extrapolation)
				endind=BinarySearch(TimeStampHK, TimeDate[inf]-kSP2hkExtrapolationSecs)		//search row index in HK-time wave corresponding to the last trigger (give it some tolerance for extrapolation)
				if (startind<0 || endind<0)				//previously had an additional test:  || endind-startind<0
					//missing data
					HKmissing=1
					alertstr="Gap in housekeeping data => using the YAG power value of setvariable on the toolkit panel!"				
				endif
			else
				//missing data
				HKmissing=1
				alertstr="Missing housekeeping data => using the YAG power value of setvariable on the toolkit panel!"
			endif
			if (HKmissing)
				// DoAlert 1, alertstr+" ("+SP2rawFldrFP+"). Continue?"
				// if (V_flag==2) // jcc -- 'no', don't continue
					// abort "Cancelled procedure."
				// endif
				HKmode=1		//don't add 'break' here!
				SP2_postErrorMsg(alertstr  +"(file: " + HKfldrFP + ")") 
			else
				//interpolate YAG power data to time scale of SP2 raw data
				InterpLinearConstTailsWholeWave(TimeStampHK, YAGPower_HK, TimeDate, YAGpower_RM)
				note YAGpower_RM, "These data are taken from the housekeeping file;"
				break
			endif
		case 1:
			//access panel value for YAG power
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar YAGpowerPanel=$ksSP2YAGpowerpanel
			//write panel value to YAG power wave
			YAGpower_RM=YAGpowerPanel
			if (YAGpowerPanel==kSP2YAGpowerPanelDefault) // jcc- default is invalid
				// TODO: interactive popup to set
				SP2_postErrorMsg("Used default YAG power => optical sizing likely invalid (file: " + HKfldrFP + ")") 
			else
				note YAGpower_RM, "Manually set value;"
			endif
			break
		default:
			setdatafolder $savedDF
			message="The variable 'HKmode' in the function "+currproc+" must be 0 or 1!"
			print message;print RTStackInfo;abort message					
	endswitch
	//finish procedure
	setdatafolder $savedDF
	return 0
end


function SP2_calibCurveScattChanCalc(calibFact, RImode, LaserPower, CalibCurveWav)
	//This function generates the calibration curve for the SP2's scattering channel for a certain laser power
	//return value: 0; not used
	//martin.gysel@psi.ch; 30/08/09, 02/06/2010, 25/06/2010
	variable calibFact		//calibration factor for SP2's scattering channel
	variable RImode		//generate calibration curve for:
						//	0: PSL equivalent sizes
						//	1: (NH4)2SO4 equivalent sizes
	variable LaserPower	//YAG laser power [V]
	wave CalibCurveWav	//wave into which the calibration curve is to be written
						
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access Mie data
	string MieDataPP, RFnote
	switch(RImode)	
		case 0:
			MieDataPP=ksSP2PathToMiePSL159subfolder
			RFnote="PSL equivalent diameter scale;"
			break					
		case 1:
			MieDataPP=ksSP2PathToMieAS151subfolder
			RFnote="(NH4)2SO4 equivalent diameter scale;"
			break					
		default:							
			setdatafolder $savedDF
			message="Undefined value of the parameter 'RImode' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message	
	endswitch
	setdatafolder $ksSP2PathToMiePureScattFldr
	setdatafolder $MieDataPP
	
	wave /Z DpVsLogSIG=$ksSP2MIE_DpVsLogSIG
	if (!waveexists(DpVsLogSIG))
		setdatafolder $savedDF
		message="Error in the function "+currproc+": Mie data are missing!"
		print message; print RTStackInfo; abort message		
	endif
	//determine calibration curve
	variable Offset=dimoffset(DpVsLogSIG,0)
	variable Delta=dimdelta(DpVsLogSIG,0)
	duplicate /o DpVsLogSIG, CalibCurveWav
	setscale /p x, Offset+log(LaserPower*calibFact), Delta, DpVsLogSIG		//the signal is LaserPower*calibFact times the signal of the reference Mie curve
	note DpVsLogSIG, "Signal is scaled to a laser power of "+num2str(LaserPower)+" V and an SP2 scattering channel calibration factor of "+num2str(calibFact)+";"
	note DpVsLogSIG, RFnote
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_SelectScattRefractPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the refractive index to be used for the sizing of the purely scatterig particles.
	//return value: 0; not used
	//martin.gysel@psi.ch, 30/08/2009, 02/06/2010, 25/06/2010
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar ScattRefractIndex=$ksSP2scattRefractIndex
	//update selected Mie data folder
	ScattRefractIndex=popStr
	//determine popNum
	string RefractList=SP2_MiePureScattDataFldrList()
	popNum=1+WhichListItem(popStr, RefractList)
	//update all popmenus on the panel
	PopupMenu ScattSizingRefractIndex,mode=popNum
	PopupMenu ScattSizingRefractIndexCalTab,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End



function SP2scattPeakHt2OptDiamNoCore(ScattPeakHt, ScattCalCoef, YAGpower, MieDataSubFldrFP)
	//this function converts a scattering peak height value into an optical diameter according to the following values provided: calibration coefficient, YAG power and ID of refractive index.
	//note: a purely scattering particle is assumed in this calculation
	//return value: optical diameter [nm]
	//martin.gysel@psi.ch; 31/08/2009, 02/06/2010
	//joel.c.corbin+sci@gmail.com; 2016-02-03 simple change to setdatafolder for speed
	variable ScattPeakHt		//scattering peak height to be converted into an optical diameter
	variable ScattCalCoef		//calibration coefficient for SP2's scattering channel
	variable YAGpower			//YAG laser power [V]
	string MieDataSubFldrFP		//partial path to folder containing the Mie data for purely scattering particles
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access MIE data for purely scattering particles
	setdatafolder $ksSP2PathToMiePureScattFldr+MieDataSubFldrFP
	wave DpVsLogSIG=$ksSP2MIE_DpVsLogSIG
	//calculate optical diameter D_OPT_CALC
	variable OptDiam=DpVsLogSIG(log(ScattPeakHt/YAGpower/ScattCalCoef))
	//finish procedure
	setdatafolder $savedDF
	return OptDiam
	
	// Note on units [by JCC after consulting MG on 2018-11-07]:
	// For historical reasons, ScattPeakHt/YAGpower/ScattCalCoef is not actually in units of [nm2] 
	// over the SP2 detector's solid angle as one might expect.
	// The correct scattering cross section (CS) units have likely been scaled by (1/1.7091e-14)/1.2356
	// This scaling was performed to match the true CS to those earlier used by Shuka (J Schwarz, NOAA)
	// which corresponded to a wrong angular weighting.
	// This can easily be fixed in the toolkit but would render all previous ScattCalCoef data wrong.
	// It's better, if you want to get correct CS units, to just calculate the CS yourself. 
	// Martin's unpublished technical paper provides more information on the solid-angle weighting function.
end
	


Function SP2_CalibBCinfoWavesPrepButt(ctrlname [, CalibInfoFldrFP, nSamples, SelectorMode]) : ButtonControl
	//This function prepares the info waves required for analysing a calibration of the incandescence detectors using reference BC particles.
	//return value: 0; not used
	//martin.gysel@psi.ch; 02/10/2009; 28/09/2010, 29/09/2010
	string ctrlname		//name of button control; not used
	string CalibInfoFldrFP	//full path to folder in which the info waves about the calibrationare stored
						//default: prompt
	variable nSamples	//number of rows for the calibration info waves
						//default: prompt
	variable SelectorMode	//1: using DMA particle selection by diameter
						//2: using APM for particle selection by mass
						//default: prompt
	
	//preparations:
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	variable MustPormpt=0
	if (paramisdefault(CalibInfoFldrFP))
		CalibInfoFldrFP="root:CalibInfoYYYYMMDD"
		MustPormpt=1
	endif
	if (paramisdefault(nSamples))
		nSamples=1
		MustPormpt=1
	endif
	if (paramisdefault(SelectorMode))
		SelectorMode=1
		MustPormpt=1
	endif
	if (MustPormpt==1)
		prompt CalibInfoFldrFP, "Full path to folder for the calibration info waves:"
		prompt nSamples, "Number of rows for calibration info waves (number of different sizes):"
		prompt SelectorMode, "Device used to select particles:", popup, ksSP2_monodi_SelectorList
		doprompt "Calibration Settings", CalibInfoFldrFP, nSamples, SelectorMode
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message		
		endif
	endif
	CalibInfoFldrFP=QuoteLiberalPath(CalibInfoFldrFP)
	//create calibration info waves	
	CreateFoldersOfFullPath(CalibInfoFldrFP, 0)
	setdatafolder $CalibInfoFldrFP
	make /o/n=1 $ksSP2_monodi_SelectorMode=SelectorMode
	wave SelectorModeWav=$ksSP2_monodi_SelectorMode
	note SelectorModeWav, "1: particles selected using "+stringfromlist(0,ksSP2_monodi_SelectorList)+";" 
	note SelectorModeWav, "2: particles selected using "+stringfromlist(1,ksSP2_monodi_SelectorList)+";" 
	make /o/t/n=(nSamples) $ksSP2_FileDateFirst="YYYYMMDD"
	wave /t FileDateFirst=$ksSP2_FileDateFirst
	note FileDateFirst, "Date of first SP2 raw data file corresponding to current size;"
	note FileDateFirst, "e.g. \"20090522\" for file 20090522x009.sp2b;"
	note FileDateFirst, "This information is only required if the start and end times of each size are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileDateLast="YYYYMMDD"
	wave /t FileDateLast=$ksSP2_FileDateLast
	note FileDateLast, "Date of last SP2 raw data file corresponding to current size;"
	note FileDateLast, "e.g. \"20090522\" for file 20090522x009.sp2b;"
	note FileDateLast, "This information is only required if the start and end times of each size are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileNumFirst=""
	wave /t FileNumFirst=$ksSP2_FileNumFirst
	note FileNumFirst, "number of first SP2 raw data file corresponding to current size;"
	note FileNumFirst, "e.g. \"009\" for file 20090522x009.sp2b;"
	note FileNumFirst, "This information is only required if the start and end times of each size are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_FileNumLast=""
	wave /t FileNumLast=$ksSP2_FileNumLast
	note FileNumLast, "number of last SP2 raw data file corresponding to current size;"
	note FileNumLast, "e.g. \"009\" for file 20090522x009.sp2b;"
	note FileNumLast, "This information is only required if the start and end times of each size are to be taken from the SP2 raw data files;"
	make /o/t/n=(nSamples) $ksSP2_SampleID=""
	wave /t SampleID=$ksSP2_SampleID
	note SampleID, "Provide any information string about the current sample"
	make /o/n=(nSamples) $ksSP2_monodi_ConcList=NaN
	wave ConcList=$ksSP2_monodi_ConcList
	note ConcList, "Particle number concentration [#/cm] measured by e.g. a CPC operated in parallel;"
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeStartList=NaN
	wave /d TimeStartList=$ksSP2_monodi_TimeStartList
	note TimeStartList, "start time of current BC sample;"
	note TimeStartList, "can optionally be retrieved from the SP2 data files if the waves "+nameofwave(FileDate)+" and "+nameofwave(FileNumList)+" are completely filled in;"
	setscale d, 0, 0, "dat", TimeStartList
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeEndList=NaN
	wave /d TimeEndList=$ksSP2_monodi_TimeEndList
	note TimeEndList, "end time of current BC sample;"
	note TimeEndList, "can optionally be retrieved from the SP2 data files if the waves "+nameofwave(FileDate)+" and "+nameofwave(FileNumList)+" are completely filled in;"
	setscale d, 0, 0, "dat", TimeEndList
	make /o/d/n=(nSamples) $ksSP2_monodi_TimeCentreList=0.5*(TimeStartList+TimeEndList)
	wave /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	note TimeCentreList, "centre time of current BC sample;"
	note TimeCentreList, "calculated from the waves "+nameofwave(TimeStartList)+" and "+nameofwave(TimeEndList)+" if they are provided;"
	setscale d, 0, 0, "dat", TimeCentreList
	//selector mode specific
	switch (SelectorMode)
		case 1:
			//using DMA
			setdatafolder $CalibInfoFldrFP
			make /o/n=(nSamples) $ksSP2_monodi_DiamList=NaN
			wave DiamList=$ksSP2_monodi_DiamList
			note DiamList, "Nominal diameter [nm] of current BC sample;"
			make /o/n=(nSamples) $ksSP2_monodi_TClist=NaN
			wave TClist=$ksSP2_monodi_TClist
			note TClist, "temperature [C] in DMA;"
			note TClist, "used to calculate diameters of particles carrying multiple charges;"
			make /o/n=(nSamples) $ksSP2_monodi_PressList=NaN
			wave PressList=$ksSP2_monodi_PressList	
			note PressList, "pressure [mbar] in DMA;"
			note PressList, "used to calculate diameters of particles carrying multiple charges;"
			break
		case 2:
			//using APM
			setdatafolder $CalibInfoFldrFP
			make /o/n=(nSamples) $ksSP2_monodi_MassList=NaN
			wave MassList=$ksSP2_monodi_MassList
			note MassList, "Nominal mass [fg] of current BC sample;"
			break
		default:
			message="Undefined value of the parameter 'SelectorMode' in the function "+currproc+"!"
			print message; print RTStackInfo; abort message		
	endswitch
	//create table
	SP2table_CalibInfoMonodispBC(CalibInfoFldrFP=CalibInfoFldrFP)
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_PBPbandratioStats(ctrlname [pbpfldrfp, targetfldrfp, PercList, nPercBins, Xmin, Xmax, BRmode, startind, endind, GraphMode]) : ButtonControl
	//This function adds statistics of the bandratio binned by broadband peak height.
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/10/2009, 10/11/2009, 19/02/2010, 05/05/2010, 12/10/2010
	
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string targetfldrfp		//full path to folder into which the bandratio statistics waves are to be written
						//default: same as pbpfldrfp
	string PercList		//list of percentiles for which the bandratio statistics is to be determined
						//e.g: "0.1;0.25;0.5;0.75;0.9"
						//default: prompt
	variable nPercBins	//number of bins for bandratio statistics
						//default: prompt
	variable Xmin			//lower boundary of first bin (broadband peak height)
						//default: prompt
	variable Xmax		//upper boundary of last bin (broadband peak height)
						//default: prompt
	variable BRmode		//0:	determine band ratio statistics for band ratio from peak heights
						//1:	determine band ratio statistics for band ratio from peak areas
						//default: prompt
	variable startind		//first data point to be included in bandratio statistics
						//default: 0
	variable endind		//last data point to be included in bandratio statistics
						//default: inf
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc :: was : BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	if (paramisdefault(targetfldrfp))
		targetfldrfp=pbpfldrfp
	endif	
	variable mustprompt=0
	if (paramisdefault(PercList))
		mustprompt=1
		PercList=ksSP2pbpBandratioPercList
	endif
	if (paramisdefault(nPercBins))
		mustprompt=1
		nPercBins=kSP2pbpBandRatioNbins
	endif
	if (paramisdefault(Xmin))
		mustprompt=1
		Xmin=kSP2pbpBandRatioXmin
	endif
	if (paramisdefault(Xmax))
		mustprompt=1
		Xmax=kSP2pbpBandRatioXmax
	endif
	if (paramisdefault(BRmode))
		mustprompt=1
		BRmode=kSP2pbpBandRatioBRmode
	endif
	if (paramisdefault(startind))
		startind=0
	endif
	if (paramisdefault(endind))
		endind=inf
	endif
	if (mustprompt)
		BRmode+=1
		prompt PercList, "List of percentiles to be calculated:"
		prompt Xmin, "lower boundary of first bin (broadband peak height):"
		prompt Xmax, "upper boundary of last bin (broadband peak height):"
		prompt nPercBins, "number of bins for bandratio statistics:"
		prompt BRmode, "use band ratio from:", popup, "peak heights;peak areas"
		prompt startind "index of first data point to be included:"
		prompt endind "index of last data point to be included:"
		doprompt "Bandratio Statistics", PercList, Xmin, Xmax, nPercBins, BRmode, startind, endind
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message						
		endif
		BRmode-=1
	endif
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	//access PBP waves	
	setdatafolder $pbpfldrfp
	wave BBHGpeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
	wave BBLGpeakHt=$ksSP2BBLGprefix+ksSP2PBPtracefitPeakHt
	string statsbnamHG
	string statsbnamLG
	if (BRmode==0)
		statsbnamHG=ksSP2pbpBandratHGPercBnam
		statsbnamLG=ksSP2pbpBandratLGPercBnam
		wave /Z BandRatHG=$ksSP2pbpBCbandratHG
		wave /Z BandRatLG=$ksSP2pbpBCbandratLG
	elseif (BRmode==1)
		statsbnamHG=ksSP2pbpBandratHGAvgPercBnam
		statsbnamLG=ksSP2pbpBandratLGAvgPercBnam
		wave /Z BandRatHG=$ksSP2pbpBCbandratHGAvg
		wave /Z BandRatLG=$ksSP2pbpBCbandratLGAvg
	else
		setdatafolder $savedDF
		message="The optional parameter 'BRmode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message									
	endif
	//loop over percentiles and make bandratio statistics
	variable nPercs=itemsinlist(PercList)
	variable currPerc
	string currSuffix
	variable pind
	for (pind=0;pind<nPercs;pind+=1)
		setdatafolder $targetfldrfp
		currPerc=RoundToNDigits(str2num(stringfromlist(pind,PercList)),2)
		currSuffix=num2str(100*currperc)
		//high gain
		if (waveexists(BandRatHG) && waveexists(BBHGpeakHt))		//only if high gain data are available
			make /o/n=(nPercBins) $statsbnamHG+currSuffix
			wave BandratioPercHG=$statsbnamHG+currSuffix
			note BandratioPercHG currSuffix+"th percentile value of the high gain bandratio [-] binned by high gain broadband peak height;"		
			note BandratioPercHG "x-scaling of wave represents high gain broadband peak height [d.u.];"		
			PercentilesBinnedBy2ndWaveV2(BandRatHG, BBHGpeakHt, currPerc, nPercBins, PercWav=BandratioPercHG, XminBdr=Xmin, XmaxBdr=Xmax, LogMode=1, startind=startind, endind=endind)
			wave BandratioPercXctrHG=$statsbnamHG+currSuffix+ksSP2pbpBandratioXctrSuffix						
			make /o/n=(nPercBins) $statsbnamHG+currSuffix+ksSP2pbpBandratioNarrXctrSuffix=BandratioPercXctrHG[p]/BandratioPercHG[p]
			wave BandratioPercNarrXctrHG=$statsbnamHG+currSuffix+ksSP2pbpBandratioNarrXctrSuffix						
			note BandratioPercNarrXctrHG "high gain narrowband peak heights [d.u.] corresponding to wave "+statsbnamHG+currSuffix+";"		
		endif
		//low gain
		if (waveexists(BandRatLG) && waveexists(BBLGpeakHt))		//only if low gain data are available
			make /o/n=(nPercBins) $statsbnamLG+currSuffix
			wave BandratioPercLG=$statsbnamLG+currSuffix
			note BandratioPercLG currSuffix+"th percentile value of the low gain bandratio [-] binned by low gain broadband peak height;"		
			note BandratioPercLG "x-scaling of wave represents low gain broadband peak height [d.u.];"		
			PercentilesBinnedBy2ndWaveV2(BandRatLG, BBLGpeakHt, currPerc, nPercBins, PercWav=BandratioPercLG, XminBdr=Xmin, XmaxBdr=Xmax, LogMode=1, startind=startind, endind=endind)
			wave BandratioPercXctrLG=$statsbnamLG+currSuffix+ksSP2pbpBandratioXctrSuffix						
			make /o/n=(nPercBins) $statsbnamLG+currSuffix+ksSP2pbpBandratioNarrXctrSuffix=BandratioPercXctrLG[p]/BandratioPercLG[p]
			wave BandratioPercNarrXctrLG=$statsbnamLG+currSuffix+ksSP2pbpBandratioNarrXctrSuffix						
			note BandratioPercNarrXctrLG "low gain narrowband peak heights [d.u.] corresponding to wave "+statsbnamLG+currSuffix+";"		
		endif
	endfor
	//show graphs
	if (GraphMode)
		SP2graph_BandratioVsBroadpkht(DataFldrFP=targetfldrfp)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function /C SP2_PBPscatt2broadDelayNumbFr(ctrlname [pbpfldrfp, targetfldrfp, delaythreshold, nPHbins, bPHmin, bPHmax, startind, endind]) : ButtonControl
	//This function determines the number fractions of thinly and thickly coated particles as a function of broadband peak height.
	//return value:	real part: total number thin+thickly coated particles included in the delay time statistics
	//				imaginary part: total number thin coated+thickly coated+saturated particles included in the delay time statistics
	//martin.gysel@psi.ch; 26/11/2009, 27/11/2009, 23/06/2010, 24/06/2010
	string ctrlname			//name of button control; not used
	string pbpfldrfp			//full path to folder containing the PBP data
							//default: browse for folder
	string targetfldrfp			//full path to folder into which the bandratio statistics waves are to be written
							//default: same as pbpfldrfp
	variable delaythreshold	//threshold of delay time above which particles are considered to be thickly coated
							//default: prompt
	variable nPHbins			//number of bins for delay time statistics
							//default: prompt
	variable bPHmin				//lower boundary of first bin (broadband peak height)
							//default: prompt
	variable bPHmax			//upper boundary of last bin (broadband peak height)
							//default: prompt
	variable startind			//first data point to be included in delay time statistics
							//default: 0
	variable endind			//last data point to be included in delay time statistics
							//default: inf
	
	//internal settings
	variable logmode=1	//1: use logarithmic even-spaced bins; 0: use linear even-spaced bins
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc :: was: BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			SP2_abort("User cancelled procedure "+currproc+"!")	
		endif
	endif
	if (paramisdefault(targetfldrfp))
		targetfldrfp=pbpfldrfp
	endif	
	variable mustprompt=0
	if (paramisdefault(delaythreshold))
		mustprompt=1
		delaythreshold=kSP2PBPdelaytimeThrshldDefault
	endif
	if (paramisdefault(nPHbins))
		mustprompt=1
		nPHbins=ksSP2pbpDelayTimeMedianBins
	endif
	if (paramisdefault(bPHmin))
		mustprompt=1
		bPHmin=ksSP2pbpDelayTimeMedianXmin
	endif
	if (paramisdefault(bPHmax))
		mustprompt=1
		bPHmax=ksSP2pbpDelayTimeMediamXmax
	endif
	if (paramisdefault(startind))
		startind=0
	endif
	if (paramisdefault(endind))
		endind=inf
	endif
	if (mustprompt)
		prompt delaythreshold, "delay time threshold between thin/thick coating [s]:"
		prompt bPHmin, "lower boundary of first bin (broadband peak height):"
		prompt bPHmax, "upper boundary of last bin (broadband peak height):"
		prompt nPHbins, "number of bins for delay time statistics:"
		prompt startind "index of first data point to be included:"
		prompt endind "index of last data point to be included:"
		doprompt "Delay Time Statistics", delaythreshold, bPHmin, bPHmax, nPHbins, startind, endind
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message						
		endif
		
		// print inputs for repeats, v4111
		string printme= "SP2_PBPscatt2broadDelayNumbFr(\"\""
		printme+= ", pbpfldrfp= \"" + pbpfldrfp
		printme+= "\", targetfldrfp= \"" + targetfldrfp
		printme+= "\", delaythreshold= " + num2str(delaythreshold)
		printme+= ", nPHbins= " + num2str(nPHbins)
		printme+= ", bPHmin= " + num2str(bPHmin)
		printme+= ", bPHmax= " + num2str(bPHmax)
		printme+= ", startind= " + num2str(startind)
		printme+= ", endind= " + num2str(endind)
		printme+= ")\r"
		print printme
	endif
	if (bPHmin<=0)
		setdatafolder $savedDF
		message="The variable the lower boundary of the first bin (bPHmin) in the function"+currproc+" must be greater than 0!"
		print message; print RTStackInfo; abort message						
	endif
	//access PBP waves	
	setdatafolder $pbpfldrfp
	wave /Z BroadPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
	wave /Z DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B			
	wave /Z ScattSaturated=$ksSP2SCHGprefix+ksSP2PBPsaturated
	if (!waveexists(DelayTimeScattMax2Broad) || !waveexists(BroadPeakHt) || !waveexists(ScattSaturated))
		//all three data waves are required!
		return 0
	endif
	variable nPts=numpnts(DelayTimeScattMax2Broad)
	startind=max(0,startind)
	endind=min(endind,nPts)
	//prepare result waves
	setdatafolder $targetfldrfp
	make /o/n=(nPHbins) $ksSP2PBPdelayNumbFractXctr=NaN
	wave DelayNumbFract_Xctr=$ksSP2PBPdelayNumbFractXctr
	make /o/n=(nPHbins+1) $ksSP2PBPdelayNumbFractXbdr=NaN
	wave DelayNumbFract_Xbdr=$ksSP2PBPdelayNumbFractXbdr
	variable binwidth
	if (logmode==1)
		//use logarithmic even-spaced bins
		bPHmax=log(bPHmax)
		bPHmin=log(bPHmin)
		binwidth=(bPHmax-bPHmin)/nPHbins
		DelayNumbFract_Xbdr=bPHmin+p*binwidth
		DelayNumbFract_Xctr=0.5*(DelayNumbFract_Xbdr[p]+DelayNumbFract_Xbdr[p+1])
		DelayNumbFract_Xbdr=10^DelayNumbFract_Xbdr[p]
		DelayNumbFract_Xctr=10^DelayNumbFract_Xctr[p]
	else
		//use linear even-spaced bins
		binwidth=(bPHmax-bPHmin)/nPHbins
		DelayNumbFract_Xbdr=bPHmin+p*binwidth
		DelayNumbFract_Xctr=0.5*(DelayNumbFract_Xbdr[p]+DelayNumbFract_Xbdr[p+1])
	endif
	make /o/n=(nPHbins) $ksSP2PBPdelayNumbFractThin=NaN
	wave DelayNumbFractThin=$ksSP2PBPdelayNumbFractThin
	setscale /i x, bPHmin+0.5*binwidth, bPHmax-0.5*binwidth, DelayNumbFractThin
	note DelayNumbFractThin, "number fraction of thinly coated BC particles [-] binned by broadband peak height;"		
	note DelayNumbFractThin, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	note DelayNumbFractThin, "corresponding peak height scale is given in the wave "+ksSP2PBPdelayNumbFractXctr+";"		
	make /o/n=(nPHbins) $ksSP2PBPdelayNumbFractThick=NaN
	wave DelayNumbFractThick=$ksSP2PBPdelayNumbFractThick
	setscale /i x, bPHmin+0.5*binwidth, bPHmax-0.5*binwidth, DelayNumbFractThick
	note DelayNumbFractThick, "number fraction of thickly coated BC particles [-] binned by broadband peak height;"		
	note DelayNumbFractThick, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	note DelayNumbFractThick, "corresponding peak height scale is given in the wave "+ksSP2PBPdelayNumbFractXctr+";"		
	make /o/n=(nPHbins) $ksSP2PBPdelayNumbFractSat=NaN
	wave DelayNumbFractSat=$ksSP2PBPdelayNumbFractSat
	setscale /i x, bPHmin+0.5*binwidth, bPHmax-0.5*binwidth, DelayNumbFractSat
	note DelayNumbFractSat, "number fraction of particles with saturated scattering signal [-] binned by broadband peak height;"		
	note DelayNumbFractSat, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	note DelayNumbFractSat, "corresponding peak height scale is given in the wave "+ksSP2PBPdelayNumbFractXctr+";"		
	if (logmode==1)
		note DelayNumbFractThin "x-scaling of wave represents logarithm of broadband peak height [d.u.];"		
		note DelayNumbFractThick "x-scaling of wave represents logarithm of broadband peak height [d.u.];"		
		note DelayNumbFractSat "x-scaling of wave represents logarithm of broadband peak height [d.u.];"		
	else
		note DelayNumbFractThin "x-scaling of wave represents broadband peak height [d.u.];"		
		note DelayNumbFractThick "x-scaling of wave represents broadband peak height [d.u.];"		
		note DelayNumbFractSat "x-scaling of wave represents broadband peak height [d.u.];"		
	endif
	make /o/n=1 $ksSP2PBPdelayNumbFractThinTot
	wave DelayNumbFractThinTot=$ksSP2PBPdelayNumbFractThinTot
	note DelayNumbFractThinTot, "total number fraction of thinly coated particles with peak heights between "+num2str(DelayNumbFract_Xbdr[0])+" and "+num2str(DelayNumbFract_Xbdr[inf])+";"
	note DelayNumbFractThinTot, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	make /o/n=1 $ksSP2PBPdelayNumbFractThickTot
	wave DelayNumbFractThickTot=$ksSP2PBPdelayNumbFractThickTot	
	note DelayNumbFractThickTot, "total number fraction of thickly coated particles with peak heights between "+num2str(DelayNumbFract_Xbdr[0])+" and "+num2str(DelayNumbFract_Xbdr[inf])+";"
	note DelayNumbFractThickTot, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	make /o/n=1 $ksSP2PBPdelayNumbFractSatTot
	wave DelayNumbFractSatTot=$ksSP2PBPdelayNumbFractSatTot
	note DelayNumbFractSatTot, "total number fraction of particles with saturated scattering signal with peak heights between "+num2str(DelayNumbFract_Xbdr[0])+" and "+num2str(DelayNumbFract_Xbdr[inf])+";"
	note DelayNumbFractSatTot, "threshold delay used for distinction: "+num2str(delaythreshold)+" [s];"		
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s tempDelayStats
	string tmpfldrpath=getdatafolder(1)
	make /o/n=(nPHbins) countthin=0, countthick=0, countsat=0
	make /o/n=(nPHbins+1) binBdr=bPHmin+p*binwidth		//can be peak height or log(peak height) depending on 'logmode'
	//loop over particles count thinly/thickly coated ones in each bin
	variable pind, bind, currPH, currDelay, currSat
	for (pind=startind; pind<endind; pind+=1)
		currPH=BroadPeakHt[pind]
		currDelay=DelayTimeScattMax2Broad[pind]
		currSat=ScattSaturated[pind]
		if (numtype(currPH)!=0)	//proceed only if broadband peak height is available for current particle
			//broadband peak height not available => continue with next particle
			continue
		else
			//broadband peak available => proceed with delaytime statistics
			if (logmode)
				currPH=log(currPH)		//use logarithmic even-spaced bins
			endif
			if (currPH<bPHmin || currPH>bPHmax)
				//peak height out of range => continue with next particle
				continue
			endif
			if (numtype(currDelay)!=0)
				if (currSat==0)
					//delay time not available for other reason than scattering detector saturation => continue with next particle
					continue
				endif
			endif
			//loop over bins and count particles below/above threshold (or saturated)
			for (bind=0; bind<nPHbins; bind+=1)
				if (currPH<=binBdr[bind+1])
					//peak height falls into current bin
					if (currSat==1)
						//scattering detector saturated
						countsat[bind]+=1
					elseif (currdelay<delaythreshold)
						//thinly coated
						countthin[bind]+=1
					else
						//thickly coated
						countthick[bind]+=1						
					endif
					break	//leave loop once the particle is assigned to a bin
				endif
			endfor
		endif
	endfor
	//write result waves
	variable totthin=sum(countthin)
	variable totthick=sum(countthick)
	variable totsat=sum(countsat)
	variable totAll=totthin+totthick+totsat
	DelayNumbFractThinTot=totthin/totAll
	DelayNumbFractThickTot=totthick/totAll
	DelayNumbFractSatTot=totsat/totAll
	DelayNumbFractThin=countthin[p]/(countthin[p]+countthick[p]+countsat[p])
	DelayNumbFractThick=countthick[p]/(countthin[p]+countthick[p]+countsat[p])
	DelayNumbFractSat=countsat[p]/(countthin[p]+countthick[p]+countsat[p])
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return cmplx(totthin+totthick,totAll)
end


Function SP2_calibAquadag2Fullerene(NewAquadagCurve, PrevAquadagCurve, PrevFullereneCurve)
	//This function converts a new aquadag calibration curve into a fullerene calibration curve
	//using previously existing calibration curves of aquadag and fullerene soot taken at the same time
	//return value: 0; not used
	//note: The new fullerene calibration data are returned in the waves "NewFullerenePeakHeight" and "NewFullereneMass" in the temporary data folder "root:Temp:AquadagToFullerene"
	//martin.gysel@psi.ch; 04/11/2009
	wave NewAquadagCurve	//new aquadag calibration curve
	wave PrevAquadagCurve	//previous aquadag calibration curve
	wave PrevFullereneCurve	//previous fullerene calibration curve
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s AquadagToFullerene
	string tmpfldrpath=getdatafolder(1)
	//prepare temporary waves for existing calibration curves
	setdatafolder $tmpfldrpath
	make /o/n=(kSP2CalibCurveNumPts) NewFullerenePeakHeight=NaN
	make /o/n=(kSP2CalibCurveNumPts) NewFullereneMass=NaN
	//loop over peak height scale and convert calibration
	variable pind, NewAquadagPH, NewAquadagMass, PrevAquadagPH, PrevFullerenePH
	for (pind=0; pind<kSP2CalibCurveNumPts; pind+=1)
		NewAquadagPH=pnt2x(NewAquadagCurve,pind)
		NewAquadagMass=NewAquadagCurve[pind]
		PrevAquadagPH=YtoX(PrevAquadagCurve, NewAquadagMass)
		PrevFullerenePH=YtoX(PrevFullereneCurve, NewAquadagMass)
		NewFullerenePeakHeight[pind]=NewAquadagPH/PrevAquadagPH*PrevFullerenePH
		NewFullereneMass[pind]=NewAquadagMass
	endfor	 
	//filter all 0 values in new calibration curves
	NewFullerenePeakHeight= NewFullerenePeakHeight[p]==0? NaN : NewFullerenePeakHeight[p]
	NewFullereneMass= NewFullereneMass[p]==0? NaN : NewFullereneMass[p]
	//get wave names for graph:
	string NewAquadagCurveNam=NameOfWave(NewAquadagCurve)
	string PrevAquadagCurveNam=NameOfWave(PrevAquadagCurve)+"#1"
	string PrevFullereneCurveNam=NameOfWave(PrevFullereneCurve)+"#2"
	//display graph
	Display /W=(329.25,121.25,723.75,329.75) NewAquadagCurve,PrevAquadagCurve,PrevFullereneCurve
	AppendToGraph NewFullereneMass vs NewFullerenePeakHeight
	ModifyGraph lSize=2
	ModifyGraph rgb($NewAquadagCurveNam)=(16384,48896,65280),rgb($PrevAquadagCurveNam)=(0,0,52224)
	ModifyGraph rgb(NewFullereneMass)=(65280,43520,0)
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "BC mass [fg]"
	Label bottom "Peak height [d.u.]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	Legend/C/N=text0/J/X=61.40/Y=7.14 "\\s("+NewAquadagCurveNam+") new aquadag curve\r\\s("+PrevAquadagCurveNam+") previous aquadag curve\r\\s("+PrevFullereneCurveNam+") previous fullerene curve"
	AppendText "\\s(NewFullereneMass) new fullerene curve"	
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_calibBroadAndNarr2Bandratio(Broad_CalCurve, Narr_CalCurve [TargetFldrFP])
	//This function determines the bandratio calibration curve from existing broadband and narrowband calibration curves.
	//return value: 0; not used
	//note: The broadband calibration curve is returned in the wave "BandratioCurve" in the temporary data folder "root:Temp:BroadAndNarr2Bandratio".
	//martin.gysel@psi.ch; 04/11/2009, 16/11/2009
	wave Broad_CalCurve	//calibration curve of broadband channel
	wave Narr_CalCurve	//calibration curve of narrowband channel
	string TargetFldrFP	//full path to folder for calculated bandratio curve
						//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//set defaults
	if (paramisdefault(TargetFldrFP))
		TargetFldrFP=savedDF
	endif
	//create target folder
	CreateFoldersOfFullPath(TargetFldrFP, 0)
	//prepare wave for calculated bandratio
	setdatafolder $TargetFldrFP
	make /o/n=(kSP2CalibCurveNumPts) BandratioFromCalCurves=NaN
	//copy wave scaling to bandratio curve
	ScaleCopyFromWavToWav(Broad_CalCurve, 0, BandratioFromCalCurves, 0)
	//loop over peak height scale and determine band ratio
	variable pind, currBroadPH, currMass, currNarrPH
	for (pind=0; pind<kSP2CalibCurveNumPts; pind+=1)
		currBroadPH=pnt2x(Broad_CalCurve,pind)
		currMass=Broad_CalCurve[pind]
		currNarrPH=YtoX(Narr_CalCurve, currMass)
		BandratioFromCalCurves[pind]=currBroadPH/currNarrPH
	endfor	 
	//filter all 0 values in new calibration curves
	BandratioFromCalCurves= BandratioFromCalCurves[p]==0? NaN : BandratioFromCalCurves[p]
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function /C SP2calibHighMass2LowMassCoef(xcut, ah, bh, ch, al)
	variable xcut
	variable ah
	variable bh
	variable ch
	variable al
	
	//precaution for cases where ah, bh, ch are take from 2-element wave (line coefficients)
	if (bh==ch)
		ch=0
	endif
	//calculate coefficients
	variable cl=(al-ah+ch*xcut^2)/xcut^2
	variable bl=bh+2*ch*xcut-2*xcut*(cl)
	//finish procedure
	return cmplx(bl,cl)
end




Function SP2_PBPscatt2broadDelayHisto(ctrlname [pbpfldrfp, targetfldrfp, BroadPHmin, BroadPHmax, nDelayBins, DelayMin, DelayMax, ForceDefaultValues]) : ButtonControl
	//This function creates a histogram of the time lag between scattering and incandescence peak height.
	//return value: total number of particles included in the delay time histogram (saturated traces are not included)
	//martin.gysel@psi.ch; 29/11/2009, 30/11/2009, 17/09/2010
	string ctrlname			//name of button control; not used
	string pbpfldrfp			//full path to folder containing the PBP data
							//default: browse for folder
	string targetfldrfp			//full path to folder into which the delay time statistics waves are to be written
							//default: same as pbpfldrfp
	variable BroadPHmin		//minimum broadband peak height of particles to be included in delay time histogram
							//default: prompt
	variable BroadPHmax		//maximum broadband peak height of particles to be included in delay time histogram
							//default: prompt
	variable nDelayBins		//number of bins for delay times histogram
							//default: prompt
	variable DelayMin			//lower boundary of first bin (delay time)
							//default: prompt
	variable DelayMax		//upper boundary of last bin (delay time)
							//default: prompt
	variable ForceDefaultValues	//1: use default values (overwriting other optional parameters)
								//0 (default: use values as provided or prompt)
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//set defaults
	if (paramisdefault(ForceDefaultValues))
		ForceDefaultValues=0
	endif
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc :: was : BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	if (paramisdefault(targetfldrfp))
		targetfldrfp=pbpfldrfp
	endif
	CreateFoldersOfFullPath(targetfldrfp, 0)	
	//prompt for optional parameters if not provided
	variable mustprompt=0
	if (paramisdefault(BroadPHmin) || ForceDefaultValues)
		mustprompt=1
		BroadPHmin=ksSP2pbpDelayHistoBroadPHmin
	endif
	if (paramisdefault(BroadPHmax) || ForceDefaultValues)
		mustprompt=1
		BroadPHmax=ksSP2pbpDelayHistoBroadPHmax
	endif
	if (paramisdefault(DelayMin) || ForceDefaultValues)
		mustprompt=1
		DelayMin=ksSP2pbpDelayHistoDelayMin
	endif
	if (paramisdefault(DelayMax) || ForceDefaultValues)
		mustprompt=1
		DelayMax=ksSP2pbpDelayHistoDelayMax
	endif
	if (mustprompt && !ForceDefaultValues)
		prompt BroadPHmin, "minimum broadband peak height to be included [d.u.]:"
		prompt BroadPHmax, "maximum broadband peak height to be included [d.u.]:"
		prompt DelayMin, "lower boundary of first bin (delay time [s]):"
		prompt DelayMax, "upper boundary of last bin (delay time [s]):"
		doprompt "Delay Time Histogram", BroadPHmin, BroadPHmax, DelayMin, DelayMax
		if (V_flag)
			SP2_abort("User cancelled procedure "+currproc+"!")				
		endif
		
	endif
	if (paramisdefault(nDelayBins) || ForceDefaultValues)
		nDelayBins=5*(DelayMax-DelayMin)
		if (!ForceDefaultValues)	
			prompt nDelayBins, "number of bins for delay time histogram:"
			doprompt "Delay Time Histogram", nDelayBins
			if (V_flag)
				SP2_abort("User cancelled procedure "+currproc+"!")				
			endif
		endif
	endif		

	// v4111 print inputs
	if (mustprompt)
		printf "SP2_PBPscatt2broadDelayHisto(\"\""
		printf ", pbpfldrfp= \"%s\"", pbpfldrfp
		printf ", targetfldrfp= \"%s\"", targetfldrfp
		printf ", BroadPHmin= %g", BroadPHmin
		printf ", BroadPHmax= %g", BroadPHmax
		printf ", nDelayBins= %g", nDelayBins
		printf ", DelayMin= %g", DelayMin
		printf ", DelayMax= %g", DelayMax
		printf ", ForceDefaultValues= %g)\r", ForceDefaultValues
	endif
	
	//access PBP waves	
	setdatafolder $pbpfldrfp
	wave /Z BroadPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
	wave /Z DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B			
	wave /Z ScattSaturated=$ksSP2SCHGprefix+ksSP2PBPsaturated
	wave /Z BroadSaturated=$ksSP2BBHGprefix+ksSP2PBPsaturated
	if (!waveexists(DelayTimeScattMax2Broad) || !waveexists(BroadPeakHt) || !waveexists(ScattSaturated) || !waveexists(BroadSaturated))
		//all four data waves are required!
		return 0
	endif
	variable nPts=numpnts(DelayTimeScattMax2Broad)
	//prepare result waves
	setdatafolder $targetfldrfp
	make /o/n=(nDelayBins+1) $ksSP2PBPdelayHistoXbdr=DelayMin+(DelayMax-DelayMin)/nDelayBins*p
	wave DelayHistoXbdr=$ksSP2PBPdelayHistoXbdr			
	note DelayHistoXbdr, "boundaries of delay time bins corresponding to the wave "+ksSP2PBPdelayHistogram+";"		
	DelayHistoXbdr[0]=-inf
	DelayHistoXbdr[inf]=inf
	make /o/n=(nDelayBins) $ksSP2PBPdelayHistoXctr=DelayMin+(DelayMax-DelayMin)/nDelayBins*(p+0.5)
	wave DelayHistoXctr=$ksSP2PBPdelayHistoXctr			
	note DelayHistoXctr, "centres of delay time bins corresponding to the wave "+ksSP2PBPdelayHistogram+";"		
	make /o/n=(nDelayBins) $ksSP2PBPdelayHistogram=NaN
	wave DelayHistogram=$ksSP2PBPdelayHistogram
	note DelayHistogram, "histogram of time lag [s] between maximum of scattering and incandescence signals;"
	note DelayHistogram, "only particles with broadband peak heights between "+num2str(BroadPHmin)+" and "+num2str(BroadPHmax)+" are considered;"		
	note DelayHistogram, "corresponding time lag scales are given in the waves "+ksSP2PBPdelayHistoXctr+" and "+ksSP2PBPdelayHistoXctr+";"		
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s DelayHisto
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=(nPts) DelayFiltered
	//filter points by various criteria (NaN, broadband or scattering saturated, broadband peak height below/above selected thresholds)
	variable find, count=0, currVal
	for (find=0; find<nPts; find+=1)
		currVal=DelayTimeScattMax2Broad[find]
		if (numtype(currVal)==2 || ScattSaturated[find]==1 || BroadSaturated[find]==1 || BroadPeakHt[find]<BroadPHmin || BroadPeakHt[find]>BroadPHmax)
			//ignore this data point
			continue
		else 
			//consider this data point
			DelayFiltered[count]=currVal
			count+=1
		endif
	endfor
	redimension /n=(count) DelayFiltered
	//get normalised histogram
	variable CountInRange=HistogramMGNaN(DelayFiltered, DelayHistogram, DelayHistoXbdr, NormMode=1)
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return CountInRange
end


Function SP2_BandRatioFromTraceArea(gainmode, pbpfldrfp)
	//This function calculates the band ratio from the trace area between half rise and half decay position of broadband channel,
	//martin.gysel@psi.ch; 18/12/2009, 27/04/2010, 16/09/2010, 26/11/2010
	variable gainmode		//0: use high gain broadband and high gain narrowband data
						//1: use low gain broadband and low gain narrowband data
	string pbpfldrfp		//full path to folder containing the PBP data
						
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	//get gain specific parameters
	string BBprefix, NBprefix, BandRatioAvgAllPP
	switch(gainmode)
		case 0:
			//use high gain broadband and high gain narrowband channels
			BBprefix=ksSP2BBHGprefix
			NBprefix=ksSP2NBHGprefix
			BandRatioAvgAllPP=ksSP2pbpBCbandratHGAvgAll
			break
		case 1:
			//use low gain broadband and low gain narrowband channels
			BBprefix=ksSP2BBLGprefix
			NBprefix=ksSP2NBLGprefix
			BandRatioAvgAllPP=ksSP2pbpBCbandratLGAvgAll
			break
		default:							
			//channel type not defined
			setdatafolder $savedDF
			message="Undefined value of the parameter 'gainmode' handed over to the function "+currproc+"!"
			print message;print RTStackInfo;abort message	
	endswitch
	//access waves
		//broadband channel
			variable broadavailable
			string RangeNote
			//access PBP data
			setdatafolder $pbpfldrfp
			wave /Z BroadOffset=$BBprefix+ksSP2PBPtracefitOffset
			wave /Z BroadPeakHalfDecay=$BBprefix+ksSP2PBPtracefitPeakHalfDecay
			switch(kSP2PBPbandratioRangeMode)
				case 0:	
					wave /z BroadBeginArea=$BBprefix+ksSP2PBPtracefitPeakPos
					RangeNote="ratio of peak area between peak and half-decay position of broadband signal;"
					break			
				case 1:	
					wave /z BroadBeginArea=$BBprefix+ksSP2PBPtracefitPeakHalfRise
					RangeNote="ratio of peak area between half-rise and half-decay position of broadband signal;"
					break			
				default:							
					setdatafolder $savedDF
					message="Code error in the function "+currproc+"!"
					print message;print RTStackInfo;abort message	
			endswitch
			//access raw data
			setdatafolder $rawfldrfp
			wave /Z BroadTraceMat=$BBprefix+ksSP2rawtracemat
			if( waveexists(BroadOffset) && waveexists(BroadBeginArea) && waveexists(BroadPeakHalfDecay) && waveexists(BroadTraceMat))
				//trace analysis waves of broadband channel are available
				broadavailable=1
			else
				//trace analysis waves of broadband channel are not available
				broadavailable=0
			endif
		//narrowband channel
			variable narravailable
			//access PBP data
			setdatafolder $pbpfldrfp
			wave /Z narrOffset=$NBprefix+ksSP2PBPtracefitOffset
			//access raw data
			setdatafolder $rawfldrfp
			wave /Z narrTraceMat=$NBprefix+ksSP2rawtracemat
			if( waveexists(narrOffset) && waveexists(narrTraceMat))
				//trace analysis waves of narrband channel are available
				narravailable=1
			else
				//trace analysis waves of narrband channel are not available
				narravailable=0
			endif
	//determine bandratio
	if (broadavailable && narravailable)
		variable nRows=numpnts(BroadOffset)
		setdatafolder $pbpfldrfp
		//prepare wave
		make /o/n=(nRows) $BandRatioAvgAllPP=NaN
		wave BandRatioAvgAll=$BandRatioAvgAllPP			
		note BandRatioAvgAll, "band ratio (broadband : narrowband);"
		note BandRatioAvgAll, RangeNote
		note BandRatioAvgAll, "this wave contains all unfiltered data;"
		//loop over particles and determine peak area
		variable rind, tind, BroadArea, narrarea
		for (rind=0;rind<nRows;rind+=1)
			//determine peak areas and bandratio
			broadarea=0
			narrarea=0
			for (tind=BroadBeginArea[rind];tind<=BroadPeakHalfDecay[rind];tind+=1)
				BroadArea+=BroadTraceMat[rind][tind]-BroadOffset[rind]
				NarrArea+=NarrTraceMat[rind][tind]-NarrOffset[rind]
			endfor
			BandRatioAvgAll[rind]=BroadArea/NarrArea
		endfor
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function /S SP2_LoadHKfiles(ctrlname [DataFileFP, DataDir, LoadType, FileDateString, FileNumList, ConcatMode, RMmode, RMint, Omode]) : ButtonControl
	//This function loads SP2 housekeeping data and is called by the 'load HK' button.
	//This is not the function that gets called from the 'load raw data' button! 
	//(SP2_LoadHouseKeepingFileFast is the common subfunction)
	//return string: list of full paths to folders containing the housekeeping data that have been loaded
	//martin.gysel@psi.ch; 15/04/2010, 16/04/2010;
	//joel.c.corbin+sci@gmail.com; 2016-12-02
	string ctrlname
	string DataFileFP		//full path to file containing the housekeeping data to be loaded
							//only used if LoadType=1
							//default: browse for file
	string DataDir		//full path to directory containing the housekeeping data to be loaded
							//note:	- Sub-directories are included!
							//		- only used if LoadType=2 or 3
							//default: browse for directory
	variable LoadType			//1:		load a single file
							//2:		load all files from data folder
							//3:		load files according to list provided in 'FileNumList' along with 'FileDateString'
							//		note: this option allows only to load files with equal date string in the file name
							//default:	use panel setting
	string FileDateString		//only used if LoadType=3;
							//date string in names of files to be loaded
							//format: "YYYYMMDD"
							//e.g: "20081123"
							//default: prompt
	string FileNumList		//only used if LoadType=3;
							//list of file numbers to be loaded (date in file name is taken from 'FileDateString')
							//e.g.: "3-4;6-7"		this would load the files 20081123x003, 20081123x004, 20081123x006, 20081123x007
							//default: prompt
	variable ConcatMode		//1:			HK data folders of individual files are concatenated into the first folder
							//0:			HK data folders of individual files are not concatenated
							//default:	use panel setting
	variable RMmode			//1: HK data are remapped at loading
							//0: HK data are not remapped
							//default: use panel setting
	variable RMint			//interval [s] for remapping of housekeeping data
							//note: only used if RMmode==1
							//default: use panel setting
	variable Omode			//1 (default):	overwrite existing data
							//0:			prompt if data folder exists already
	
	//internal variables
	variable PrintInfo=1
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values
	if (paramisdefault(LoadType))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadTypeGlob=$ksSP2LoadHKtype
		LoadType=LoadTypeGlob	
	endif
	if (paramisdefault(Omode))
		Omode=1
	endif
	if (paramisdefault(ConcatMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar ConcatModeGlob=$ksSP2loadHKconcatMode
		ConcatMode=ConcatModeGlob	
	endif
	if (paramisdefault(RMmode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar RMmodeGlob=$ksSP2loadHKremapMode
		RMmode=RMmodeGlob	
	endif
	if (paramisdefault(RMint))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar RMintGlob=$ksSP2loadHKremapInt
		RMint=RMintGlob	
	endif
	if (LoadType==3)
		if (paramisdefault(FileDateString))
			// load last saved file date string (gets saved below) --// jcc
			SVAR /Z lastFileDateString= $ksSP2PathToToolkitPanelFldr + "FileDateString"
			if (SVAR_Exists(lastFileDateString))
				FileDateString= lastFileDateString
			else
				FileDateString="YYYYMMDD"
			endif
		endif
		if (paramisdefault(FileNumList))
			SVAR /Z lastFileNumList= $ksSP2PathToToolkitPanelFldr + "FileNumList"
			if (SVAR_Exists(lastFileNumList))
				FileNumList= lastFileNumList
			else
				FileNumList="1;"
			endif
		endif
		
		if (paramisdefault(FileDateString) || paramisdefault(FileNumList))
			prompt FileDateString, "date string in names of files to be loaded:"
			prompt FileNumList, "list of file numbers to be loaded"
			doprompt "List of files to be loaded:", FileDateString, FileNumList
			if (V_flag)
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message;print RTStackInfo;abort message	
			else
				string/G root:SP2toolkit:FileNumList= FileNumList
				string/G root:SP2toolkit:FileDateString= FileDateString
			endif	
		endif
	endif
	//get directory or file path if needed
	if (LoadType==1)
		if (paramisdefault(DataFileFP))
			DataFileFP=BrowseForFile(DialogStr="Select '*.hk'-file to be loaded", TypeStr=ksSP2hkFileType)
			if (stringmatch(DataFileFP,"cancelled"))
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message;print RTStackInfo;abort message				
			endif
		endif
		DataFileFP=ChopLastCharacterOff(DataFileFP,":")		
	elseif (LoadType==2 || LoadType==3)
		if (paramisdefault(DataDir))
			newpath /o/m="Select folder containing the '*.hk'-files to be loaded."/q NewDataPath
			if (V_flag != 0)												//abort execution if "cancel"-button is pressed
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message;print RTStackInfo;abort message				
			endif
			PathInfo NewDataPath
			DataDir=S_path
			DataDir=choplastcharacteroff(DataDir, ":")
		endif	
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2loadHKdata
	string tmpfldrpath=getdatafolder(1)
	//get list of files to be loaded
	
	string filepathlist
	switch(LoadType)
		case 1:
			//load single file		
			filepathlist=DataFileFP+";"			
			DataDir=RemoveLastItemFromList(DataFileFP, ListSepStr=":")
			break	
		case 2:
			//load all files in directory		
			filepathlist=ListOfAllFilesInDirAndSubDir2(DataDir, SubDirMode=1, PathMode=1, fileExtStr=ksSP2hkFileEnd, ShortcutMode=1)
			break
		case 3:
			//load files according to list provided in 'FileNumList' along with 'FileDateString'
			setdatafolder $tmpfldrpath
			make /o NumListWav
			wave NumListWav
			NumberList_to_IndexWave_Parser(FileNumList, NumListWav, INFval=10^kSP2fileIDndigits-1)
			variable nFiles=numpnts(NumListWav) // number of EXPECTED files, not detected files ... // jcc
			variable nind, dateval
			string currfilenamstr
			filepathlist=""
			for (nind=0; nind<nFiles; nind+=1)
				dateval=TimeTextToIgorTimeNoSepStr(FileDateString+" 000000", nYearChars=4)
				currfilenamstr=SP2uniqueFileID2filenamebody(dateval+NumListWav[nind])+ksSP2hkFileEnd
				filepathlist+=DataDir+":"+currfilenamstr+";"
			endfor
			break
		default:						
	endswitch
	DataDir=ChopLastCharacterOff(DataDir,":")
	filepathlist=SortList(filepathlist)
	string filenamlist=replacestring(DataDir+":",filepathlist,"")
	nFiles=itemsinlist(filepathlist)
	//loop over loading files
	variable find, hind
	string currfilefp, currfilename
	string currfldrfp, datafldrlist=""
	string mainfp
	variable fileloaded
	variable firstfile=0
	for (find=0; find<nFiles; find+=1)
		//current file path and name
		currfilefp=stringfromlist(find,filepathlist)
		currfilename=LastStringFromList(currfilefp,ListSepStr=":")
		currfilename=replacestring(ksShortcutFileExtWindows,currfilename,"")
		currfilename=replacestring(ksSP2hkFileEnd,currfilename,"")
		currfldrfp=ksSP2defRawLoadPartentFldr+SP2filename2HKdataFldrNam(currfilename)
		currfldrfp=QuoteLiberalPath(currfldrfp)
		//load HK data file
		fileloaded=SP2_LoadHouseKeepingFileFast(currfilefp, currfldrfp, Omode, printinfo)
		//remap HK data if chosen to do so
		if (RMmode==1 && fileloaded)
			SP2_HKfileRemapper("", hkfldrfp=currfldrfp, rmfldrfp=currfldrfp, intsecs=RMint, Omode=1)
		endif		
		//concatenate HK data if chosen to do so
		if (ConcatMode==1 && fileloaded)
			//concatenate data folders
			if (firstfile==0)	//first file loaded => concatenating is obsolet
				firstfile=1
				datafldrlist+=currfldrfp+";"	//update list of loaded files
				mainfp=currfldrfp
			else		//concatenate
				SP2_ConcatenateHKfldrs("", MainHKfldrFP=mainfp, AppendHKfldrFP=currfldrfp)
			endif
		else
			//do not concatenate
			datafldrlist+=currfldrfp+";"	//update list of loaded files
		endif		
	endfor
	
	// graph loaded data 
	if (SP2_graphsOn() && strlen(ctrlname)) // the latter check is so button was clicked
		SP2_Graph_HK_vs_time()
	endif
	
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return datafldrlist
End


function SP2_HKfileRemapper(ctrlname [hkfldrfp, rmfldrfp, intsecs, Omode]) : ButtonControl
	//This function remaps a housekeeping data folder
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/04/2010; to be tested
	//joel.c.corbin+sci@gmail.com 2016-08-28 allow "all" option
	string ctrlname	//name of button control, not used
	string hkfldrfp		//full path to to housekeeping folder to be remapped
					//default: browse for folder
	string rmfldrfp	//full path of folder for remapped housekeeping data
					//default: prompt
	variable intsecs	//remapping interval [s]
					//default: prompt
	variable Omode	//0 (default): do not overwrite existing folder
					//1: overwrite existing folder
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	variable mustprompt=0
	if (paramisdefault(hkfldrfp))
		hkfldrfp=SP2_getFolder(type="HK", promptText= "Housekeeping data folder to be remapped:", includeAll=1)
		variable multipleChosen= itemsInList(hkfldrfp) > 1
	endif
	if (paramisdefault(Omode))
		Omode=0
	endif
	if (paramisdefault(rmfldrfp))
		rmfldrfp=QuoteRemover(hkfldrfp)
		mustprompt=1
	endif
	if (paramisdefault(intsecs))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LoadHKremapInt=$ksSP2loadHKremapInt	//panel value
		intsecs=LoadHKremapInt
		mustprompt=1
	endif
	if (mustprompt==1)
		Omode+=2
		prompt intsecs, "remapping interval [s]:"
		prompt Omode, "overwrite existing folder if exists?", popup, "NO;YES"
		prompt rmfldrfp, "target folder for remapped data:"
	
		if (multipleChosen)
			doprompt "REMAP SETTINGS (multiple folders were chosen, so overwrite and own folder targets are forced)", intsecs
		else
			doprompt "REMAP SETTINGS", rmfldrfp, intsecs, Omode
		endif
		if (V_flag)
			SP2_abort("")				
		endif
		Omode-=1
		rmfldrfp=QuoteLiberalPath(rmfldrfp)
	endif
		
	// all pption
	if (multipleChosen)
		variable i,n=itemsInList(hkfldrfp)
		for (i=0;i<n;i+=1)
			string thisHK= stringFromList(i, hkfldrfp)
			SP2_HKfileRemapper("", hkfldrfp=thisHK, rmfldrfp=thisHK, intsecs=intsecs, Omode=1)
		endfor
		return 1
	endif
	
	//access original time stamp wave
	setdatafolder $hkfldrfp
	wave TimeStampHK=$ksSP2hkTimeStamp
	string TimeCentreFP=GetWavesDataFolder(TimeStampHK, 2)
	//remap HK-folder 
	RemapDataFolder(sourcefldrfp=hkfldrfp, rmfldrfp=rmfldrfp, intsecs=intsecs, TimeCentreFP=TimeCentreFP, Omode=Omode)	

	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


function /S SP2chanConfig2chanOrder()
	//This function returns a string list containing the channel order according to the configuration on the toolkit panel
	//return string:	mode=0 => list of channel prefixes
	//				mode=1 => list of long channel descriptions
	//martin.gysel@psi.ch; 23/04/2010, 24/04/2010, 07/05/2010

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar ChanConfig_0=$ksSP2chan0config
	Svar ChanConfig_1=$ksSP2chan1config
	Svar ChanConfig_2=$ksSP2chan2config
	Svar ChanConfig_3=$ksSP2chan3config
	Svar ChanConfig_4=$ksSP2chan4config
	Svar ChanConfig_5=$ksSP2chan5config
	Svar ChanConfig_6=$ksSP2chan6config
	Svar ChanConfig_7=$ksSP2chan7config
	//create channel order list
	string list=""
	string LongDescrList=ksSP2allchanLongDescrListP1+ksSP2allchanLongDescrListP2+ksSP2allchanLongDescrListP3
	list+=stringfromlist(WhichListItem(ChanConfig_0, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_1, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_2, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_3, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_4, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_5, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_6, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	list+=stringfromlist(WhichListItem(ChanConfig_7, LongDescrList,";",0,0),ksSP2allchanPrefixList)+";"
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return list
end



function /S SP2chanBit2chanPrefix(ChanBit)
	//return string:	prefix of data channel corresponding to bit value 'ChanBit'
	//martin.gysel@psi.ch; 28/04/2010
	variable ChanBit
	
	string ChanPrefix
	switch(ChanBit)
		case kSP2chanbitSCHG:		
			ChanPrefix=ksSP2SCHGprefix
			break
		case kSP2chanbitBBHG:		
			ChanPrefix=ksSP2BBHGprefix
			break
		case kSP2chanbitNBHG:		
			ChanPrefix=ksSP2NBHGprefix
			break
		case kSP2chanbitSPHG:
			ChanPrefix=ksSP2SPHGprefix
			break
		case kSP2chanbitSCLG:		
			ChanPrefix=ksSP2SCLGprefix
			break
		case kSP2chanbitBBLG:		
			ChanPrefix=ksSP2BBLGprefix
			break
		case kSP2chanbitNBLG:		
			ChanPrefix=ksSP2NBLGprefix
			break
		case kSP2chanbitSPLG:		
			ChanPrefix=ksSP2SPLGprefix
			break
		default:
			string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
			string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
			string message="Undefined value of parameter 'ChanBit' handed over to the function "+currproc+" must be XXX or YYYY!"
			print message; print RTStackInfo; abort message			
	endswitch
	//finish procedure
	return ChanPrefix
end


function SP2chanPrefix2chanProperty(ChanPrefix, Mode)
	//return value:	property of data channel with prefix 'ChanPrefix' according to selected 'Mode'
	//martin.gysel@psi.ch; 28/04/2010, 29/04/2010, 11/09/2010, 12/09/2010
	string ChanPrefix	//Prefix of data channel
	variable Mode	//the function returns the following property of the channel with prefix 'ChanPrefix':
					//0: standard bit value in the igor code of the SP2-toolkit
					//1: lower cut-off value for data analysis according to value set on the toolkit panel
					//2: maximum valid signal according to toolkit panel settings (either given by detector electronics or D/A-DAQ saturation)
					//3: standard bit value of the channel used for the small signal range
					//4: event bit value used for classification waves (combined channels: event bit of channel used for the small signal range)
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//determine properties
	variable ChanBit
	variable SmallSigChanBit
	variable EventBit
	strswitch(ChanPrefix)
		case ksSP2SCHGprefix:		
			ChanBit=kSP2chanbitSCHG
			SmallSigChanBit=kSP2chanbitSCHG	//for mode=3
			EventBit=kSP2SCHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SCHGMinCut
			Nvar MaxSig=$ksSP2maxSigSCHG
			break
		case ksSP2BBHGprefix:		
			ChanBit=kSP2chanbitBBHG
			SmallSigChanBit=kSP2chanbitBBHG	//for mode=3
			EventBit=kSP2BBHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBHGMinCut
			Nvar MaxSig=$ksSP2maxSigBBHG
			break
		case ksSP2NBHGprefix:		
			ChanBit=kSP2chanbitNBHG
			SmallSigChanBit=kSP2chanbitNBHG	//for mode=3
			EventBit=kSP2NBHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2NBHGMinCut
			Nvar MaxSig=$ksSP2maxSigNBHG
			break
		case ksSP2SPHGprefix:		
			ChanBit=kSP2chanbitSPHG
			SmallSigChanBit=kSP2chanbitSPHG	//for mode=3
			EventBit=kSP2SPHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SPHGMinCut
			Nvar MaxSig=$ksSP2maxSigSPHG
			break
		case ksSP2SCLGprefix:		
			ChanBit=kSP2chanbitSCLG
			SmallSigChanBit=kSP2chanbitSCLG	//for mode=3
			EventBit=kSP2SCLGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SCLGMinCut
			Nvar MaxSig=$ksSP2maxSigSCLG
			break
		case ksSP2BBLGprefix:		
			ChanBit=kSP2chanbitBBLG
			SmallSigChanBit=kSP2chanbitBBLG	//for mode=3
			EventBit=kSP2BBLGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBLGMinCut
			Nvar MaxSig=$ksSP2maxSigBBLG
			break
		case ksSP2NBLGprefix:		
			ChanBit=kSP2chanbitNBLG
			SmallSigChanBit=kSP2chanbitNBLG	//for mode=3
			EventBit=kSP2NBLGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2NBLGMinCut
			Nvar MaxSig=$ksSP2maxSigNBLG
			break
		case ksSP2SPLGprefix:		
			ChanBit=kSP2chanbitSPLG
			SmallSigChanBit=kSP2chanbitSPLG	//for mode=3
			EventBit=kSP2SPLGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SPLGMinCut
			Nvar MaxSig=$ksSP2maxSigSPLG
			break
		case ksSP2BHNHprefix:		
			ChanBit=kSP2chanbitBHNH
			SmallSigChanBit=kSP2chanbitBBHG	//for mode=3
			EventBit=kSP2BBHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBHGMinCut
			Nvar MaxSig=$ksSP2maxSigNBHG
			break
		case ksSP2BHNLprefix:		
			ChanBit=kSP2chanbitBHNL
			SmallSigChanBit=kSP2chanbitBBHG	//for mode=3
			EventBit=kSP2BBHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBHGMinCut
			Nvar MaxSig=$ksSP2maxSigNBLG
			break
		case ksSP2BHBLprefix:		
			ChanBit=kSP2chanbitBHBL
			SmallSigChanBit=kSP2chanbitBBHG	//for mode=3
			EventBit=kSP2BBHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBHGMinCut
			Nvar MaxSig=$ksSP2maxSigBBLG
			break
		case ksSP2BLNLprefix:		
			ChanBit=kSP2chanbitBLNL
			SmallSigChanBit=kSP2chanbitBBLG	//for mode=3
			EventBit=kSP2BBLGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2BBLGMinCut
			Nvar MaxSig=$ksSP2maxSigNBLG
			break
		case ksSP2SHSLprefix:		
			ChanBit=kSP2chanbitSHSL
			SmallSigChanBit=kSP2chanbitSCHG	//for mode=3
			EventBit=kSP2SCHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SCHGMinCut
			Nvar MaxSig=$ksSP2maxSigSCLG
			break
		case ksSP2PHPLprefix:		
			ChanBit=kSP2chanbitPHPL
			SmallSigChanBit=kSP2chanbitSPHG	//for mode=3
			EventBit=kSP2SPHGeventBitVal		//for mode=4
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Nvar LowCut=$ksSP2SPHGMinCut
			Nvar MaxSig=$ksSP2maxSigSPLG
			break
		default:
			setdatafolder $savedDF
			message="Undefined value of parameter 'ChanPrefix' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message			
	endswitch
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	switch(mode)	
		case 0:		
			return ChanBit			
			break			
		case 1:		
			return LowCut			
			break			
		case 2:		
			return MaxSig			
			break			
		case 3:		
			return SmallSigChanBit			
			break			
		case 4:		
			return EventBit			
			break			
		default:							
			setdatafolder $savedDF
			message="Undefined value of parameter 'mode' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message			
	endswitch
end


Function /S SP2_ChanListToDescrShortList(ChanPrefixList)
	//return string: list of short channel descriptions corresponding to the list of channel prefixes
	//martin.gysel@psi.ch; 07/05/2010
	string ChanPrefixList	//list of channel prefixes
	
	variable nChans=itemsinlist(ChanPrefixList)
	variable cind
	string retlist=""
	for (cind=0; cind<nChans; cind+=1)
		retlist+=stringfromlist(WhichListItem(StringFromList(cind, ChanPrefixList), ksSP2allchanPrefixList,";", 0,0),ksSP2allchanShortDescrListP1+ksSP2allchanShortDescrListP2+ksSP2allchanShortDescrListP3)+";"
	endfor
	return retlist
end

Function /S SP2_ChanListToChanBitList(ChanPrefixList)
	//return string: list of channel bit values corresponding to the list of channel prefixes
	//martin.gysel@psi.ch; 09/05/2010
	string ChanPrefixList	//list of channel prefixes
	
	variable nChans=itemsinlist(ChanPrefixList)
	variable cind
	string retlist=""
	for (cind=0; cind<nChans; cind+=1)
		retlist+=stringfromlist(WhichListItem(StringFromList(cind, ChanPrefixList), ksSP2allchanPrefixList,";", 0,0),ksSP2allchanBitList)+";"
	endfor
	return retlist
end


Function /S SP2_ChanListToDescrLongList(ChanPrefixList)
	//return string: list of long channel descriptions corresponding to the list of channel prefixes
	//martin.gysel@psi.ch; 07/05/2010
	string ChanPrefixList	//list of channel prefixes
	
	variable nChans=itemsinlist(ChanPrefixList)
	variable cind
	string retlist=""
	for (cind=0; cind<nChans; cind+=1)
		retlist+=stringfromlist(WhichListItem(StringFromList(cind, ChanPrefixList), ksSP2allchanPrefixList,";", 0,0),ksSP2allchanLongDescrListP1+ksSP2allchanLongDescrListP2+ksSP2allchanLongDescrListP3)+";"
	endfor
	return retlist
end


Function /S SP2_ChanListToColourList(ChanPrefixList)
	//return string: list of colour indices corresponding to the list of channel prefixes
	//martin.gysel@psi.ch; 07/05/2010
	string ChanPrefixList	//list of channel prefixes
	
	variable nChans=itemsinlist(ChanPrefixList)
	variable cind
	string retlist=""
	for (cind=0; cind<nChans; cind+=1)
		retlist+=stringfromlist(WhichListItem(StringFromList(cind, ChanPrefixList), ksSP2allchanPrefixList,";", 0,0),ksSP2allchanColourList)+";"
	endfor
	return retlist
end


Function /S SP2_ChanListToAbbrevList(ChanPrefixList)
	//return string: list of colour indices corresponding to the list of channel prefixes
	//martin.gysel@psi.ch; 07/05/2010
	string ChanPrefixList	//list of channel prefixes
	
	variable nChans=itemsinlist(ChanPrefixList)
	variable cind
	string retlist=""
	for (cind=0; cind<nChans; cind+=1)
		retlist+=stringfromlist(WhichListItem(StringFromList(cind, ChanPrefixList), ksSP2allchanPrefixList,";", 0,0),ksSP2allchanAbbrevList)+";"
	endfor
	return retlist
end


Function SP2calib_FitCalCurve(ctrlname [CalibFldrFP, ChanBit, GraphMode, TableMode]) : ButtonControl
	//This function fits a quadratic spline through calibration data and displays the results
	//martin.gysel@psi.ch; 08/05/2010, 09/05/2010;
	string ctrlname		//name of button control; not used
	string CalibFldrFP	//full path to the data folder containing the calibration results
						//default: browse for folder
	variable	ChanBit				//2:		BBHG
								//4:		NBHG
								//32:	BBLG
								//64:	NBLG
	variable GraphMode	//0:			do not show the graph
						//1 (default):	show the graph
	variable TableMode	//0:			do not show the table
						//1 (default):	show the table
	

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(CalibFldrFP))
		CalibFldrFP=BrowseForFolder("Select folder containing the calibration summary:", StartPath="root:", selectStr="CalibSummary")
		if (stringmatch(CalibFldrFP, "cancelled"))
			setdatafolder $savedDF
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif
	endif
	if (paramisdefault(GraphMode))
		GraphMode=1
	endif
	if (paramisdefault(TableMode))
		TableMode=1
	endif
	CalibFldrFP=ChopLastCharacterOff(CalibFldrFP,":")
	string ChanPrefix
	if (paramisdefault(ChanBit))
		string PrefixList=SP2_ChanListIncandOnly()
		string DescriptList=SP2_ChanListToDescrShortList((PrefixList))
		string ChanDescript
		variable PopVal
		prompt PopVal, "Select incandescence channel:", popup, DescriptList
		doprompt "Incandescence channel", PopVal
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled the procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
		endif
		ChanPrefix=stringfromlist(PopVal-1,PrefixList)
		ChanBit=str2num(SP2_ChanListToChanBitList(ChanPrefix))
	else
		ChanPrefix=SP2chanBit2chanPrefix(ChanBit)
	endif
	string ChanDescr=ChopLastCharacterOff(SP2_ChanListToDescrShortList(chanprefix),";")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s QuadraticSpline
	string tmpfldrpath=getdatafolder(1)
	//prepare fit coefficient waves
	string SplineCoefNam=ChanPrefix+ksSP2calibSplineCoefCompact
	setdatafolder $CalibFldrFP
	wave /Z SplineCoef=$SplineCoefNam
	if (!waveexists(SplineCoef))
		make /d/o $SplineCoefNam={0,1,0}
		wave SplineCoef=$SplineCoefNam
	endif
	variable nSplineCoef=numpnts(SplineCoef)
	string HoldNam=ChanPrefix+ksSP2calibSplineHoldForFit
	setdatafolder $CalibFldrFP
	wave /Z HoldForFit=$HoldNam
	if (!waveexists(HoldForFit))
		make /o/n=(nSplineCoef) $HoldNam=0
		wave HoldForFit=$HoldNam
	else
		RedimensionNaNmg(HoldForFit, 0, nSplineCoef, FillVal=0)
	endif
	//create HoldString
	string HoldString=""
	variable hind
	for (hind=0; hind<nSplineCoef; hind+=1)
		HoldString+=num2str(HoldForFit[hind])
	endfor
	//temporary waves for fitting
	setdatafolder $tmpfldrpath
	string EpsNam=ChanPrefix+ksSP2calibSplineEps
	make /o/n=(nSplineCoef) $EpsNam=0.1
	wave Eps=$EpsNam
	//access waves to be fitted
	setdatafolder $CalibFldrFP
	wave MassList_1e=$ksSP2calibMassList+ksSP2suffix1e
	wave FitPkHt_1e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
	duplicate /o MassList_1e, $ChanPrefix + "_MassList_1e_FitResid" /WAVE=resids // v4111a for residuals -- eventually shuold go into SP2 Constants ipf
	//fit spline
	setdatafolder $tmpfldrpath
	FuncFit/Q/H=HoldString/NTHR=0 SP2_calibCurveSpline_FitFkt SplineCoef  MassList_1e /X=FitPkHt_1e /E=Eps /R=resids
	//create wave containing the complete spline coefficients
	variable nSegments
	setdatafolder $CalibFldrFP
	make /d/o/n=0 $ChanPrefix+ksSP2calibSplineCoefComplete
	wave CompleteCoef=$ChanPrefix+ksSP2calibSplineCoefComplete
	nSegments=SP2_calibCurveSplineCoefExpand(SplineCoef, CompleteCoef)
	//calculate fit curve
	setdatafolder $CalibFldrFP
	make /o/n=(kSP2CalibCurveNumPts) $ChanPrefix+ksSP2calibSplineCalCurve
	wave FittedSpline=$ChanPrefix+ksSP2calibSplineCalCurve
	string FitWavNam=NameOfWave(FittedSpline )
	setscale /i x, 0, kSP2signalAmpMax, FittedSpline
	FittedSpline=SP2peakHt2BCmass(x, CompleteCoef, nSegments)	//use this line rather than the next to assure that the "CompleteCoef" are correct
		//alternative command: FittedSpline=SP2_calibCurveSpline_FitFkt(SplineCoef,x)
	//create graph
	if (GraphMode)
		SP2graph_IncandCalibResults(CalibFldrFP=CalibFldrFP, ChanDescr=ChanDescr)
		SetAxis/Z /A=2 Res_Left; ModifyGraph/Z zero(Res_Left)=1 // jcc, after adding /R to FuncFit
	endif
	//show coefficients table
	if (TableMode)
		edit SplineCoef, HoldForFit, Eps, CompleteCoef
		ModifyTable autosize={0, 0, 16, 0, 0}
	endif
	//finish procedure
	string CommandLine="SP2calib_FitCalCurve(\"\", "
	CommandLine+="CalibFldrFP=\""+CalibFldrFP+"\", "
	CommandLine+="ChanBit="+num2str(ChanBit)+", "
	CommandLine+="GraphMode=0, "
	CommandLine+="TableMode=0)"
	print CommandLine
	setdatafolder $savedDF
	return 0
End


Function SP2_FilterBadTraces(pbpfldrfp)
	string pbpfldrfp		//full path to folder containing the PBP data
	//Below code was never really used and I forgot what it was actually intended for (only instance in "SP2_AnalyseRawTraces").
	//=> removed it from the SP2-toolkit code on 10/08/2010

//	//This function set the filter flags for bad raw traces
//	//return value: 0; not used
//	//martin.gysel@psi.ch; 17/05/2010
//	
//	//preparations
//	string savedDF=getdatafolder(1)
//	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
//	//temporary data folder
//	newdatafolder /o/s root:Temp
//	newdatafolder /o/s SP2filterbadtraces
//	string tmpfldrpath=getdatafolder(1)
//	//loop over all channels and filter bad traces
//	string chanlist=SP2_ChanListAllDAQ()
//	variable nchans=itemsinlist(chanlist)
//	variable chanind, nRows, nCols, tind
//	string currPrefix
//	for (chanind=0; chanind<nchans; chanind+=1)
//		//channel prefix
//		currPrefix=stringfromlist(chanind,chanlist)
//		//access raw trace matrix
//		setdatafolder $rawfldrfp
//		wave TraceMat=$currPrefix+ksSP2rawtracemat
//		if (!waveexists(TraceMat))
//			//raw traces not available => proceed with next channel
//			continue
//		endif
//		//get dimensions
//		nRows=dimsize(TraceMat,0)
//		nCols=dimsize(TraceMat,1)
//		//prepare temporary wave
//		setdatafolder $tmpfldrpath
//		make /o/n=(nCols) currTrace
//		//access PBP waves
//		setdatafolder $pbpfldrfp
//		wave BadTrace=$currPrefix+ksSP2PBPbadTrace
//		if (!waveexists(BadTrace))
//			//create flag wave
//			make /o/n=(nRows)  $currPrefix+ksSP2PBPbadTrace=0
//			wave BadTrace=$currPrefix+ksSP2PBPbadTrace
//			note BadTrace, "Flags for bad raw traces;"
//			note BadTrace, "bit"+num2str(ln(kSP2PBPbadTrManualFilterVal)/ln(2))+"="+num2str(kSP2PBPbadTrManualFilterVal)+": manually filtered bad trace;"
//		else
//			//reset automatic flags (but keep manually set flags)
//			redimension /n=(nRows) BadTrace
//			BadTrace=BadTrace[p] & kSP2PBPbadTrManualFilterVal
//		endif
////&%		//loop over all traces and set automatic flags
////&%		for (tind=0; tind<nRows; tind+=1)
////&%			currTrace=TraceMat[tind][p]
////&%			//no automatic flagging implemented so far
////&%		endfor
//	endfor
//	//finish procedure
//	if (datafolderexists(savedDF))
//		setdatafolder $savedDF
//	endif
//	killdatafolder /z $tmpfldrpath
//	return 0
end

Function SP2_LEOgetBeamShape(SCprefix, SPprefix, [pbpfldrfp, PosMode, ScattPkHtMin, StatsMode, TraceLenB4Pk, Kmode, printInfo])
	//This function determines the median beam shape of purely scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 20/05/2010, 21/05/2010, 22/05/2010, 23/05/2010, 08/09/2010, 01/12/2010, 14/09/2011
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable PosMode		//1: use information from split detector (standard)
						//0: use centre position from Gaussian fit to scattering trace
						//default: prompt
						//note: split detector (PosMode=1) can only be used if LEO-fit preparation has previously been done.
	variable ScattPkHtMin	//minimum peak height of scattering traces of purely scattering particles to be considered for the median beam shape
							//default: prompt
	variable StatsMode	//0: determine median beam shape only
						//1: determine 10th, 25th, median, 75th and 90th percentiles of beam shape.
						//default: prompt
	variable TraceLenB4Pk	//length of trace [# data points] before peak centre to be considered for median beam shape
	string SCprefix		//prefix of scattering channel to be used:
						//e.g. ksSP2SCHGprefix or ksSP2SCLGprefix
						//note: this cannot be a combined channel
	string SPprefix		//prefix of position sensitive detector (split detector) channel to be used
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//note, this can be a combined channel
	variable Kmode		//0: The matrix containing the normalised beam shapes is retained
						//1 (default): The matrix containing the normalised beam shapes is deleted
	variable printInfo // 0//1 disables//enables printing inputs
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	variable mustprompt=0
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string leofldrfp=SP2_PBPfldrFP2LEOfldrFP(pbpfldrfp)
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	CreateFoldersOfFullPath(leofldrfp, 0)
	CreateFoldersOfFullPath(LeoBeamCalibSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoTraceFitSubFldrFP, 0)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//set further defaults
	if (paramisdefault(PosMode))
		MustPrompt=1
		PosMode=1
	endif
	if (paramisdefault(StatsMode))
		MustPrompt=1
		StatsMode=0
	endif
	if (paramisdefault(ScattPkHtMin))
		MustPrompt=1
		ScattPkHtMin=kSP2LEOprepScattMinCutBeamShape
	endif
	if (paramisdefault(TraceLenB4Pk))
		MustPrompt=1
		TraceLenB4Pk=kSP2LEOusB4Pk4Shape*SamplingRateRawDataMHz	//convert value of default constant from [us] to [# data points]
	endif
	if (mustprompt)
		PosMode+=1
		StatsMode+=1
		string PosPopList="use maximum of scattering signal;use split detector"
		string StatsPopList="median only;10th, 25th, median, 75th and 90th percentiles"
		prompt PosMode, "Determining beam position:", popup, PosPopList
		prompt StatsMode, "Beam shape statistics:", popup, StatsPopList
		prompt ScattPkHtMin, "Minimum peak height of scattering traces to be considered:"
		prompt TraceLenB4Pk, "Trace length [# data points] before peak centre to be considered:"
		doprompt "Beam Shape", PosMode, StatsMode, ScattPkHtMin, TraceLenB4Pk
		if (V_flag)
			SP2_abort("")
		endif
		PosMode-=1
		StatsMode-=1
	endif
	if (paramisdefault(Kmode))
		Kmode=1
	endif
	
	
	if (paramisdefault(printInfo) || printInfo)
		printf "SP2_LEOgetBeamShape(\"%s\", \"%s\", pbpfldrfp=\"%s\", ", SCprefix, SPprefix, pbpfldrfp
		printf "PosMode=%g, ScattPkHtMin=%g, StatsMode=%g, ", PosMode, ScattPkHtMin, StatsMode
		printf "TraceLenB4Pk=%g, Kmode=%g, printInfo=0)\r", TraceLenB4Pk, Kmode
	endif
	
	
	//access raw data waves
	setdatafolder $rawfldrfp
	wave /Z Scatt_TraceMat=$SCprefix+ksSP2rawtracemat
	if (!WaveExists(Scatt_TraceMat))
		setdatafolder $savedDF
		message= "%s() did not find the raw scattering data in the expected place (%s:%s%s).\rData were not loaded or were deleted after loading file %s."
		sprintf message, message, currproc, rawfldrfp, SCprefix, ksSP2rawtracemat, ksSP2datafileExt
		print message; print RTStackInfo; abort message				
	endif
	
	variable nRows=dimsize(Scatt_TraceMat,0)
	variable tracelen=dimsize(Scatt_TraceMat,1)
	//access PBP waves
	setdatafolder $pbpfldrfp
		//scattering channel
		wave Scatt_Offset=$SCprefix+ksSP2PBPscattGaussoffset
		wave Scatt_PeakHt=$SCprefix+ksSP2PBPscattGausspeakHeight			
		wave Scatt_PeakPos=$SCprefix+ksSP2PBPscattGausspeakPos				
		wave Scatt_Saturated=$SCprefix+ksSP2PBPsaturated
		//PSD (split detector) channel
		wave Split_FilteredSplitPos=$SPprefix+ksSP2PBPsplitFilteredSplitPos		
		//various post processing data
		wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut				
	//access waves in LEO beam and calibration data subfolder
	setdatafolder $LeoBeamCalibSubFldrFP	
	wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta
	wave LEOsplit2incandDelta=$ksSP2LEOsplit2incandDelta		
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2beamShape
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=0 currtrace
	//get beam centre positions
	setdatafolder $tmpfldrpath
	make /o/n=(nrows) CentrePos=NaN
	if (PosMode==0)
		CentrePos=Scatt_PeakPos[p]
	elseif (PosMode==1)
		CentrePos=Split_FilteredSplitPos[p]+LEOfitSplit2centreDelta[0]
	endif
	//get list of pure scattering particles
	setdatafolder $tmpfldrpath
	make /o/n=(nrows) PureScattList=NaN
	variable rind
	variable IncEvent=kSP2BBHGeventBitVal+kSP2NBHGeventBitVal+kSP2BBLGeventBitVal+kSP2NBLGeventBitVal
	variable nPureScatt=0
	for (rind=0; rind<nRows; rind+=1)
		if (!(ClassificationByMinCut[rind]&IncEvent))
			//pure scattering particle
			if ((Scatt_PeakHt[rind]>ScattPkHtMin) && !Scatt_Saturated[rind])
				//scattering peak height above selected threshold and not saturated
				PureScattList[nPureScatt]=rind
				nPureScatt+=1
			endif
		endif
	endfor
	redimension /n=(nPureScatt) PureScattList
	//get normalized beam shapes and put them into beam and calibration data subfolder
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=(nPureScatt,tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeData=NaN
	wave BeamShapeData=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeData
	variable psind, currindex, currshift
	for (psind=0; psind<nPureScatt; psind+=1)
		currindex=PureScattList[psind]
		currshift=CentrePos[currindex]-TraceLenB4Pk
		if (numtype(currshift)==2)
			BeamShapeData[psind][]=NaN
			continue
		endif
		redimension /n=(tracelen-currshift) currtrace
		currtrace=NaN
		currtrace=Scatt_TraceMat[currindex][p+currshift]-Scatt_Offset[currindex]
		NormalizeScaledWaveOverwriteNaN(currtrace)
		BeamShapeData[psind][]=currtrace[q]
	endfor
	//beam centre and mean split position (LEO beam and calibration data subfolder)
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=1 $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos=TraceLenB4Pk
	wave BeamShapeCentrePos=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos
	make /o/n=1 $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos=TraceLenB4Pk-LEOfitSplit2centreDelta[0]
	wave BeamShapeSplitPos=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos
	make /o/n=1 $ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos=BeamShapeSplitPos+Percentile_of_ListNaN(LEOsplit2incandDelta, kSP2LEOprepIncandDelayEarlyPerc)
	wave BeamShapeIncEarlyPos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos
	make /o/n=1 $ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos=BeamShapeSplitPos+Percentile_of_ListNaN(LEOsplit2incandDelta, kSP2LEOprepIncandDelayLatePerc)
	wave BeamShapeIncLatePos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos
	//statistics of normalized beam shapes (LEO beam and calibration data subfolder)
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=(tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50=NaN
	wave BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
	Percentiles_From_MatrixCols(0.50, BeamShapePerc50, BeamShapeData)
	wavestats /q BeamShapePerc50
	variable normfact=V_max
	BeamShapePerc50/=normfact		//renormalize maximum peak height to unity
	if (StatsMode)
		//extra statistics only if selected
		setdatafolder $LeoBeamCalibSubFldrFP
		make /o/n=(tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc10=NaN
		wave BeamShapePerc10=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc10
		Percentiles_From_MatrixCols(0.10, BeamShapePerc10, BeamShapeData)
		BeamShapePerc10/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc25=NaN
		wave BeamShapePerc25=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc25
		Percentiles_From_MatrixCols(0.25, BeamShapePerc25, BeamShapeData)
		BeamShapePerc25/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc75=NaN
		wave BeamShapePerc75=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc75
		Percentiles_From_MatrixCols(0.75, BeamShapePerc75, BeamShapeData)
		BeamShapePerc75/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc90=NaN
		wave BeamShapePerc90=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc90
		Percentiles_From_MatrixCols(0.90, BeamShapePerc90, BeamShapeData)
		BeamShapePerc90/=normfact
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	if (Kmode==1)
		killwaves /z BeamShapeData
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


function SP2_LEOPeakHt2DoptCoatedBC_v2(LEOfitPeakHt, BCcoreDiam, YAGpower, ScattCalCoef [MieDataSubFldrPP])
// This is a rewrite of the optical-diameter-of-coated-BC code, 
// taking a different logical approach to the v4110 and earlier code.
// The old logic is implicit in the code (see 'COATING_THICKNESS_CALC')
// and shrinks the BC core when excess scattering is negative 
// (measured_scattering > predicted_scattering).
// The new logic is to attribute negative excess scattering to noise.
//
// In detail:
//	- Assume a correct BC calibration, density, and refractive index (RI)
//	- Define CS_LEO as the scattering cross-section obtained from a LEO fit
//		-- (CS_LEO = Signal_x% / x% / scattCoef / laserPower)
//	- Consider that LEO noise dominates the overall error 
//		-- (e.g. LEO/optical sizing was 88%--210% for 2015-05-06 test data)
//	- Thus each particle is:
//		CS_LEO = CS_true + CS_noise + CS_overallBias ~= CS_true + CS_noise
//	- The function CS_noise is assumed to be an even function (eg Gaussian)
//    so if a particle appears to have a negative coating thickness, the 
//	  'negative part' (the missing scattering signal) is redefined as positive
//	  during Mie lookup. 
//	- The net effect is that the COATING RI and NOT THE CORE RI is used for 
//	  negative coating thicknesses, a major change since v4110. 
//
//	Tests showed that this does not make a huge difference, but seems to help.
//  After writing the first version of this function I realized it is used for BC-free particles too!
//
// joel.c.corbin+sci@gmail.com; 2016-02-29
//
// pseudo-code:
// if 0 < scattering < thickest-coated core: return coating
// if scattering > thickest-coated core: return fail
// if scattering < zero-coated core: assume due to noise, invert defect as positive, return coating

// Returns the core + 2* coating thickness diameter.
// Returns nan if inputs are invalid or outside of the Mie table range.
// (No fancy negative values are returned as was done in v4110)

// These inputs are consistent with the v4110 function:
	variable LEOfitPeakHt	// scattering peak height from LEO fit to be converted into an optical diameter
							// note: this can be derived from the split or the scattering detector data
	variable BCcoreDiam		// diameter [nm] of BC core
	variable YAGpower		// YAG laser power [V]
	variable ScattCalCoef	// calibration coefficient of the SP2's scattering/split detector
	string MieDataSubFldrPP	// partial path to folder containing the Mie data for coated BC particles
							// default: use panel selection
					
	
	// preliminaries [access data]
	if (paramisdefault(MieDataSubFldrPP))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Svar Panel_LEOrefractIndexPair=$ksSP2leoRefractIndexPair	
		MieDataSubFldrPP=Panel_LEOrefractIndexPair
	endif
				// note: lookup up these waves for every LEO fit is inefficient in Igor.
				// they should be converted to inputs later. 
	DFREF sdf= getDataFolderDFR()
	cd ksSP2PathToMieCoatedBCfldr+MieDataSubFldrPP
	wave MieDcore=$ksSP2MIE_Dcore					// core diameters
	wave MieCoatThckn=$ksSP2MIE_CoatingThickness	// thicknesses
	wave MieMat=$ksSP2MIE_ScatCross			// rows: D_core;   columns: coating_thickness
	cd sdf
	variable nDcore=numpnts(MieDcore)	
	variable nCoatThckn=numpnts(MieCoatThckn)
	
	// check if BC core in range
	if ((BCcoreDiam < 0) || (BCcoreDiam > MieDcore[nDcore-1])) // BCcoreDiam==0 means BCfree--we are at the non-BC row of the MieMat!   in the other case we don't have Mie data and anyway probably shouldnt use Mie theory.
		return NaN
	endif

	// initial calculations
	variable CS_LEO= LEOfitPeakHt/YAGpower/ScattCalCoef							// convert to scattering cross section (normalize measured scattering amplitude with laser power and calibration coefficient of detector)
	variable BCidx_interp=BinarySearchInterp(MieDcore, BCcoreDiam)				// INTERPOLATED	-- e.g. returns 0.5 for 2.5 nm, since the Mie data are {0, 5, 10, ... 1000}
	variable BCidx_low= floor(BCidx_interp) 
	variable BCidx_high= ceil(BCidx_interp)
	variable wt_low=  1 - (BCidx_interp - BCidx_low)
	variable wt_high= (BCidx_low==BCidx_high) ? 0 : 1 - (BCidx_high - BCidx_interp)	// if interp value was exact, don't combine
		
	// get the columns between which we will interpolate
	ImageTransform /G=(BCidx_low) getRow MieMat; wave BCrow= W_ExtractedRow; duplicate /free BCrow, BCrow0
	ImageTransform /G=(BCidx_high) getRow MieMat;wave BCrow= W_ExtractedRow; duplicate /free BCrow, BCrow1
	variable lastMieCol= 200 - BCidx_high										// the scattering dimension of the Mie Matrix is only filled until this row [below the diagonal is nan]
	DeletePoints lastMieCol+1, 200-lastMieCol+1, BCrow0, BCrow1					// I don't think this is necessary, but it is 'safe'--remove empty entries
	
	// is input valid? 
	if (numtype(CS_LEO)==2) // if is nan
		return NaN
	elseif (BCidx_high > lastMieCol)
		return nan // -99 
	endif
	
	// is coating thickness negative?
	if (CS_LEO < MieMat[BCidx_low][0])
		variable coatingIsNegative=1
		variable CS_core_min=MieMat[BCidx_low][0]								// predicted CS of BC core
		variable CS_noise= CS_core_min - CS_LEO									// we assume the negative value is due to noise!
		CS_LEO= CS_core_min + CS_noise
	endif
	
	
	if (CS_LEO < wavemin(BCrow0))
		// CS not available. Note that this threshold is higher than the old function's if coatingIsNegative
		return nan// -999
	elseif (CS_LEO > wavemax(BCrow1))
		return nan//-9999 
	endif

	
	// now do the Mie lookup
	variable CSidx_interp0=BinarySearchInterp(BCrow0, CS_LEO)
	variable CSidx_interp1=BinarySearchInterp(BCrow1, CS_LEO)
	variable thisCoating= MieCoatThckn[CSidx_interp0]*wt_low + MieCoatThckn[CSidx_interp1]*wt_high
	if (coatingIsNegative)
		thisCoating *= -1
	endif
	
	// finalize and return (to be consistent with the old function, we return the combiend size):
	killwaves BCrow0, BCrow1
	return BCcoreDiam + 2*thisCoating
end	

function SP2_LEOPeakHt2DoptCoatedBC(LEOfitPeakHt, BCcoreDiam, YAGpower, ScattCalCoef [MieDataSubFldrPP, negMode])
	//this function determines the optical diameter of a coated BC particle from the following parameters:
	//   - scattering peak height (obtained with LEO-fit)
	//   - calibration coefficient of the scattering/split detector
	//   - YAG power
	//   - BC mass obtained from incandescence detector
	//   - BC density
	//   - Mie data for coated BC particles.
	//return value:	optical diameter of coated BC particle [nm]
	//				-99 if BC core diameter is not within range of Mie data matrix
	//				-999 if scattering amplitude is not within range of Mie data matrix and optical size is smaller than expected for pure BC particle (negative coating)
	//				-9999 if scattering amplitude is not within range of Mie data matrix and optical size is bigger than expected for pure BC particle (positive coating)
	//note: Mie data must be available in sufficiently high resolution because no interpolation is made
	//martin.gysel@psi.ch; 10/06/2010, 11/06/2010, 12/08/2010, 13/08/2010, 10/09/2010, 02/03/2011, 01/04/2011, 23/12/2011
	// joel.c.corbin+sci@gmail.com; 2016-03-01--added negMode==1 option
	variable LEOfitPeakHt		//scattering peak height from LEO fit to be converted into an optical diameter
								//note: this can be derived from the split or the scattering detector data
	variable BCcoreDiam		//diameter [nm] of BC core
	variable YAGpower		//YAG laser power [V]
	variable ScattCalCoef	//calibration coefficient of the SP2's scattering/split detector
	string MieDataSubFldrPP	//partial path to folder containing the Mie data for coated BC particles
							//default: use panel selection
	variable negMode	//default==0: negative coatings? assign smaller BC core size
							 // if 1: negative coatings? consider as noise, make negative defect positive (=> assign coating RI)
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//set defaults
	if (paramisdefault(MieDataSubFldrPP))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Svar Panel_LEOrefractIndexPair=$ksSP2leoRefractIndexPair	
		MieDataSubFldrPP=Panel_LEOrefractIndexPair
	endif
	// use new code?
	if (negMode==1)
		return SP2_LEOPeakHt2DoptCoatedBC_v2(LEOfitPeakHt, BCcoreDiam, YAGpower, ScattCalCoef, MieDataSubFldrPP=MieDataSubFldrPP)
	endif
		
	//access MIE data for coated BC particles particles
	setdatafolder $ksSP2PathToMieCoatedBCfldr+MieDataSubFldrPP
	wave MieDcore=$ksSP2MIE_Dcore
	wave MieCoatThckn=$ksSP2MIE_CoatingThickness
	wave MieScatCross=$ksSP2MIE_ScatCross
	variable nDcore=numpnts(MieDcore)	
	variable nCoatThckn=numpnts(MieCoatThckn)
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2leoFitMieSizing
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=(nDcore) MieMatCol
	make /o/n=(nCoatThckn) MieMatRow
	//reset datafolder
	
	setdatafolder $savedDF
	//determine optical diameter of coated BC particle
		variable retval=NaN
		//return NaN if LEOfitPeakHt is not available
		if (numtype(LEOfitPeakHt)==2)
			return NaN
		endif
		//get row index of BCcoreDiam in diameter scale wave 'MieCore' of the Mie data matrix 
		variable coreindinterp=BinarySearchInterp(MieDcore, BCcoreDiam)
		variable coreindmod=mod(coreindinterp,1)
		variable coreindfloor=floor(coreindinterp)
		variable coreindceil=coreindfloor+1
		if (numtype(coreindinterp)==2)
			//BC core diameter is not within the range of available Mie data
			return -99
		endif
		//determine scattering amplitude of pure BC core
		variable ScatCrossPureBC, currMieScatCross
		if (coreindmod==0)
			//exact value available
			ScatCrossPureBC=MieScatCross[coreindinterp][0]
		else
			//linear interpolation
			ScatCrossPureBC=MieScatCross[coreindfloor][0]+(MieScatCross[coreindceil][0]-MieScatCross[coreindfloor][0])*(BCcoreDiam-MieDcore[coreindfloor])/(MieDcore[coreindceil]-MieDcore[coreindfloor])
		endif
		//search scattering amplitude in Mie data matrix
		LEOfitPeakHt=LEOfitPeakHt/YAGpower/ScattCalCoef		//normalize measured scattering amplitude with laser power and calibration coefficient of detector
		if (LEOfitPeakHt==ScatCrossPureBC)
		// if (abs(LEOfitPeakHt - ScatCrossPureBC) < tol) // *******************************new
			//measured scattering amplitude matches value expected for pure BC exactly
			return BCcoreDiam	//pure BC
		elseif (LEOfitPeakHt<ScatCrossPureBC)
			//measured scattering amplitude is smaller than expected for a pure BC particle => search along pure BC cores with decreasing core diameter (=> negative coating!)
			MieMatCol=MieScatCross[p][0]		//column 0 = zero coating thickness
			variable coreindex
			for (coreindex=coreindceil; coreindex>=0; coreindex-=1)
				currMieScatCross=MieMatCol[coreindex]
				if (numtype(currMieScatCross)==2)
					//scattering amplitude is not within the range of available Mie data
					return -999				
				elseif (LEOfitPeakHt<currMieScatCross)
					//measured scattering amplitude still smaller than expected for current core size => proceed with next smaller core diameter
					continue
				elseif (LEOfitPeakHt>currMieScatCross)
					//linear interpolation of core size
					return MieDcore[coreindex]+(MieDcore[coreindex-1]-MieDcore[coreindex])*(LEOfitPeakHt-currMieScatCross)/(MieMatCol[coreindex-1]-currMieScatCross)
				elseif (LEOfitPeakHt==currMieScatCross)
				// elseif (abs(LEOfitPeakHt - currMieScatCross) < tol)// *******************************new
					return MieDcore[coreindex]
				endif
			endfor
			//scattering amplitude is not within the range of available Mie data
			return -999
		elseif (LEOfitPeakHt>ScatCrossPureBC)
			//measured scattering amplitude is bigger than expected for a pure BC particle => search along constant BC core size with increasing coating thickness (=> positive coating!)
				variable ScatCrossCoatedBC
				//interpolate Mie data matrix to exact core size
				if (coreindmod==0)
					//exact value available
					MieMatRow=MieScatCross[coreindfloor][p]
				else
					//linear interpolation
					MieMatRow=MieScatCross[coreindfloor][p]+(MieScatCross[coreindceil][p]-MieScatCross[coreindfloor][p])*(BCcoreDiam-MieDcore[coreindfloor])/(MieDcore[coreindceil]-MieDcore[coreindfloor])		
				endif
				//search scattering amplitude in row of Mie data matrix (test increasing coating thickness)
				variable coatindex, CurrCoatThickn
				for (coatindex=1; coatindex<nCoatThckn; coatindex+=1)		//note: start loop with coatindex==1 as LEOfitPeakHt>MieMatRow[0]
					ScatCrossCoatedBC=MieMatRow[coatindex]
					if (numtype(ScatCrossCoatedBC)==2)
						//scattering amplitude is not within the range of available Mie data
						return -9999		
					elseif (LEOfitPeakHt>ScatCrossCoatedBC)
						//measured scattering amplitude still bigger than expected for current coating thickness => proceed with next bigger coating thickness
						continue
					elseif (LEOfitPeakHt<ScatCrossCoatedBC)
						//interpolate coating thickness
						CurrCoatThickn=MieCoatThckn[coatindex-1]+(MieCoatThckn[coatindex]-MieCoatThckn[coatindex-1])*(LEOfitPeakHt-MieMatRow[coatindex-1])/(ScatCrossCoatedBC-MieMatRow[coatindex-1])
						return BCcoreDiam+2*CurrCoatThickn
					elseif (LEOfitPeakHt==ScatCrossCoatedBC)
					// elseif (abs(LEOfitPeakHt - ScatCrossCoatedBC) < tol)// *******************************new
						return BCcoreDiam+2*MieCoatThckn[coatindex]
					endif
				endfor
				//scattering amplitude is not within the range of available Mie data
				return -9999
		else
			//the program should never enter into this option!
			string currproc, message
			setdatafolder $savedDF
			string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="Code error in the function "+currproc+"!"
			print message; print RTStackInfo; abort message		
		endif
end


Function SP2_SIGvsDp_to_DpVsLogSIG(SIGvsDp)
	//This function converts the scaled wave 'SIGvsDp' into the corresponding wave 'DpVsLogSIG'
	//return value:	0; not used
	//				the function creates the wave 'DpVsLogSIG' in the same folder as 'SIGvsDp'
	//martin.gysel@psi.ch, 25/06/2010
	wave SIGvsDp	//scaled wave containing the scattering inensity into the SP2's solid angle vs the particle diameter (wave scaling)
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string TargetFP=GetWavesDataFolder(SIGvsDp, 1)
	variable nPts=numpnts(SIGvsDp)
	//create 'DpVsLogSIG'-wave
	setdatafolder $TargetFP
	make /o/n=(nPts) $ksSP2MIE_DpVsLogSIG
	wave DpVsLogSIG=$ksSP2MIE_DpVsLogSIG
	setscale /i x, log(SIGvsDp[0]), log(SIGvsDp[inf]), DpVsLogSIG		//assume monotonically increasing 'SIGvsDp' without NaN-entries
	DpVsLogSIG=YtoX(SIGvsDp, 10^x)
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2sampleFlowGetDataBtt(ctrlname) : ButtonControl
	//Button procedure which gets the sample flow rate from the housekeeping data or from the panel setvariable and writes it to the SP2 raw data folder.
	//return value: 0, not used
	//martin.gysel@psi.ch; 10/09/2010
	string ctrlname			//name of button control; not used
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//get data folder(s)
	string FldrFPlist=SP2_getFolder(startingDF=savedDF, type="raw") // jcc :: was : BrowseForFolder("Select folder containing the SP2 raw data:", StartPath=savedDF, AbortMode=1, MultiMode=1)
	variable nFldrs=itemsinlist(FldrFPlist)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar FromMode=$ksSP2sampleFlowMode
	//get path to housekeeping data folder
	string HKfldrFP=""
	if (FromMode==0)
		//default HK-folder does not exist => browse for housekeeping data folder
		HKfldrFP=SP2_getFolder(startingDF=savedDF, type="HK") // jcc :: was : BrowseForFolder("Select folder with housekeeping data (''root:'' if not available):", StartPath="root:", AbortMode=1)
		if (stringmatch(HKfldrFP,"root:"))
			//no housekeeping data available => use panel data
			FromMode=1
		endif
	endif	
	//loop over selected folders and get sample flow data
	variable find
	string currFldr
	for (find=0; find<nFldrs; find+=1)
		currFldr=stringfromlist(find,FldrFPlist)
		SP2sampleFlowGetData(SP2rawFldrFP=currFldr, HKfldrFP=HKfldrFP, FromMode=FromMode)
	endfor
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2sampleFlowGetData([SP2rawFldrFP, HKfldrFP, FromMode])
	//This function gets the sample flow rate from the housekeeping data or from the panel setvariable and writes it to the SP2 raw data folder.
	//return value: 0, not used
	//martin.gysel@psi.ch; 03/08/2010, 10/08/2010, 11/08/2010, 10/09/2010, 21/10/2010, 14/09/2011
	string SP2rawFldrFP		//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
							//default: browse for folder
	string HKfldrFP			//full path to folder containing the housekeeping data
							//default: use path from global string or browse for folder if no valid data is available
	variable FromMode		//0: regrid housekeeping data to sample flow rate wave
							//1: regrid nominal values from "INI"-files to sample flow rate wave
							//2: write value provided with panel setvariable to sample flow rate wave
							//default: use panel setting for FromMode
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access SP2 raw data waves
	setdatafolder $SP2rawFldrFP
	wave TimeDate=$ksSP2TimeDate
	variable nRawRows=numpnts(TimeDate)
	wave /d RawData_INIfileID=$ksSP2correspConfigfileID
	SVAR /Z HKfldrFP_Svar=$ksSP2hkFldrFP
	if (!SVAR_Exists(HKfldrFP_Svar))
		string /g $ksSP2hkFldrFP=SP2_RawFldrFP2HKfldrFP(SP2rawFldrFP)		//try default name of housekeeping data folder
		Svar HKfldrFP_Svar=$ksSP2hkFldrFP
	endif
	//set defaults	
	if (paramisdefault(SP2rawFldrFP))
		SP2rawFldrFP=SP2_getFolder(startingDF=savedDF, type="raw") // jcc :: was : BrowseForFolder("Select folder containing the SP2 raw data:", StartPath=savedDF)
		if (stringmatch(SP2rawFldrFP,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message;print RTStackInfo;abort message			
		endif
	endif
	SP2rawFldrFP=QuoteLiberalPath(SP2rawFldrFP)
	variable pathOK=SP2_check_IsRawFldr(SP2rawFldrFP)
	if (!pathOK)
		//not a raw data folder => do nothing!
		setdatafolder $savedDF
		return 0
	endif
	string SP2iniFldrFP=SP2_RawFldrFP2iniFldrFP(SP2rawFldrFP)
	if (paramisdefault(FromMode))
		//access panel setting
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar SampleFlowModePanel=$ksSP2sampleFlowMode
		FromMode=SampleFlowModePanel
	endif
	if(FromMode!=0 && FromMode!=1 && FromMode!=2)
		//invalid value of FromMode
		setdatafolder $savedDF
		message="Undefined value of the variable 'FromMode' in the function "+currproc+"!"
		print message;print RTStackInfo;abort message						
	endif	
	if (FromMode==0)
		//get path to housekeeping data folder
		if (paramisdefault(HKfldrFP))
			HKfldrFP=HKfldrFP_Svar
		endif
		if (datafolderexists(HKfldrFP))
			//HK-folder exists => nothing else to be done
		else
			//HK-folder does not exist => browse for housekeeping data folder
			HKfldrFP=SP2_getFolder(startingDF=savedDF, type="HK") // jcc :: was : BrowseForFolder("Select folder with housekeeping data (''root:'' if not available):", StartPath="root:", AbortMode=1)
			if (stringmatch(HKfldrFP,"root:"))
				//no housekeeping data available => use panel data
				FromMode=1
				HKfldrFP_Svar=" "
			endif
		endif
		HKfldrFP=QuoteLiberalPath(HKfldrFP)
		HKfldrFP_Svar=HKfldrFP
	endif
	//prepare sample flow rate wave in SP2 raw data
	setdatafolder $SP2rawFldrFP
	make /o/n=(nRawRows) $ksSP2sampleFlowRate=NaN
	wave SampleFlowRate_RM=$ksSP2sampleFlowRate
	//get sample flow rate data
	if(FromMode==0)		//from HK-file
		HKfldrFP=QuoteLiberalPath(HKfldrFP)
		//get HK-file-format version
		setdatafolder $HKfldrFP
		Nvar /Z HKfileFormat_Nvar=$ksSP2hkFileFormatNum
		variable HKfileFormatNum
		if (NVAR_Exists(HKfileFormat_Nvar))
			HKfileFormatNum=HKfileFormat_Nvar
		else
			//assume version 3.x
//			HKfileFormatNum=3   // v4111 --- it's 2016, time to assume version 4.x
			HKfileFormatNum=4
		endif
		//file format specific wave names
		string SampleFlowLFEpp
		switch(HKfileFormatNum)	
			case 3:	
				SampleFlowLFEpp=ksSP2hkSampleFlowLFEv3
				break				
			case 4:
				SampleFlowLFEpp=ksSP2hkSampleFlowLFEv4
				break				
			default:							
				setdatafolder $savedDF
				message="Code error in the procedure"+currproc+"!"
				print message; print RTStackInfo; abort message
		endswitch
		//access housekeeping waves
		setdatafolder $HKfldrFP
		wave /Z TimeStampHK=$ksSP2hkTimeStamp
		wave /Z SampleFlow_HK=$SampleFlowLFEpp
		//check whether housekeeping that are available
		variable HKmissing=0, startind, endind
		string alertstr
		if (waveexists(TimeStampHK) && waveexists(SampleFlow_HK))
			startind=BinarySearch(TimeStampHK, TimeDate[0]+kSP2hkExtrapolationSecs)		//search row index in HK-time wave corresponding to the first trigger (give it some tolerance for extrapolation)
//			endind=BinarySearch(TimeStampHK, TimeDate[nRawRows-1]-kSP2hkExtrapolationSecs)		//search row index in HK-time wave corresponding to the last trigger (give it some tolerance for extrapolation)
			variable idx_lastGoodTime= getIndex(0, TimeDate, tol=inf, rev=1)						// jcc 4112...sometimes ends in NaN, bug in DMT or PSI software?
			endind=BinarySearch(TimeStampHK, TimeDate[idx_lastGoodTime]-kSP2hkExtrapolationSecs)		//search row index in HK-time wave corresponding to the last trigger (give it some tolerance for extrapolation)

			if (startind<0 || endind<0)				//previously had an additional test:  || endind-startind<0
				//missing data
				HKmissing=1
				alertstr="Gap in housekeeping data => use the sample flow rate value of setvariable on the toolkit panel!\r(while searching between %s and %s)"
				sprintf alertstr, alertstr, secs2dt(TimeDate[0]), secs2dt(TimeDate[nRawRows-1])
			endif
		else
			//missing data
			HKmissing=1
			alertstr="Missing housekeeping data => use the sample flow rate value of setvariable on the toolkit panel!\r(potentially caused by wrong value of HKfileFormat_Nvar in HK folder: try 3 or 4)"
		endif
		if (HKmissing)
			FromMode=2
			Print alertstr+" ("+SP2rawFldrFP+")"		
			// jcc v4111-- switch from constant to NVAR, so that the mode can be switched programmatically (constant was 'kSP2missingHKalertMode')
			SP2_postErrorMsg(alertstr+" ("+SP2rawFldrFP+")") // allows continuous loading
		else
			//interpolate housekeeping data to time scale of SP2 raw data
			InterpLinearConstTailsWholeWave(TimeStampHK, SampleFlow_HK, TimeDate, SampleFlowRate_RM)
			note /K SampleFlowRate_RM
			note SampleFlowRate_RM, "SP2 sample flow rate [cm/min];"
			note SampleFlowRate_RM, "These data are taken from the housekeeping file;"
		endif
	endif
	if(FromMode==1)		//from INI-file
		//access configuration waves from INI-file
		setdatafolder $SP2iniFldrFP
		wave /d INIfile_UniqueFileIDini=$ksSP2configUniqueFileIDini
		wave INIfile_SampleFlowSet=$ksSP2configSampleFlowSet
		//copy nominal flow rate values to raw data wave (value may differ from file to file)
		SampleFlowRate_RM=INIfile_SampleFlowSet[BinarySearch(INIfile_UniqueFileIDini, RawData_INIfileID[p])]
		note /K SampleFlowRate_RM
		note SampleFlowRate_RM, "SP2 sample flow rate [cm/min];"
		note SampleFlowRate_RM, "These data are taken from the nominal flow rate set in the configuration file (i.e. INI-subfolder);"
	endif
	if(FromMode==2)		//from panel constant
		//access panel constant
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar SampleFlowPanel=$ksSP2sampleFlowPanel
		//write panel value to raw data wave
		SampleFlowRate_RM=SampleFlowPanel
		note /K SampleFlowRate_RM
		note SampleFlowRate_RM, "SP2 sample flow rate [cm/min];"
		if (SampleFlowPanel!=kSP2sampleFlowPanelDefault) // jcc -- default value is invalid
			note SampleFlowRate_RM, "Manually set value;"
		endif
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2rawDataMainMaskPrep(SP2rawFldrFP, Omode)
	//This function creates the wave for the main raw data mask if it does not yet exist.
	//return value: 0, not used
	//martin.gysel@psi.ch; 10/08/2010; 09/08/2013
	string SP2rawFldrFP		//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
	variable Omode			//1: main mask is always recreated
							//0: main mask is only created if they are not yet existing
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access raw data waves
	setdatafolder $SP2rawFldrFP
	wave TimeDate=$ksSP2TimeDate
	variable nRows=numpnts(TimeDate)
	//create main mask wave
	setdatafolder $SP2rawFldrFP
	wave /Z Mask_BadDataMain=$ksSP2pbpMaskBadData
	if (!waveexists(Mask_BadDataMain) || Omode==1)
		make /o/n=(nRows) $ksSP2pbpMaskBadData=0
		wave Mask_BadDataMain=$ksSP2pbpMaskBadData
		note Mask_BadDataMain, "0=row to be included in the data analysis;"		
		note Mask_BadDataMain, "1=row to be ignored in the data analysis;"		
		note Mask_BadDataMain, "This wave is used to FILTER A CONNECTED PART OF THE RAW DATA during any kind of automated data analysis."
		note Mask_BadDataMain, "IMPORTANT NOTE: 'ignoring' means that neither the measured particle signals, nor the corresponding sampling volume/interval are considered, as if the instrument wasn't running during this period."
		note Mask_BadDataMain, "This mask wave can also be used to filter OUTLIERS (e.g. from electronic signal spikes), but ONLY IF THE OUTLIERS ARE AN INSIGNIFICANT FRACTION of all triggered particles."
		note Mask_BadDataMain, "If a significant fraction of the particles are outliers, then a separate filter must be written to get rid of them."
		note Mask_BadDataMain, "Using this mask wave in such a case would result in an overestimation of the number/mass concentrations of particles."
	endif	
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2sampleVolumeWaveCalc(SP2rawFldrFP)
	//This function creates and updates the wave for the sample volume corresponding to each particle including applying the main data filter.
	//return value: 0, not used
	//martin.gysel@psi.ch; 11/08/2010
	// jcc 150605: fixed infinite loop bug when numpnts(TimeElapsed)==1
	string SP2rawFldrFP		//full path to folder containing the SP2 raw data
							//e.g: root:20090113x029_SP2
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//make sure that main data mask exists (needed for compatibility reasons with previous toolkit releases)
	SP2rawDataMainMaskPrep(SP2rawFldrFP, 0)
	//access raw data waves
	setdatafolder $SP2rawFldrFP
	wave TimeElapsedEff=$ksSP2TimeElapsedEff
	wave SampleFlowRate=$ksSP2sampleFlowRate
	wave Mask_BadDataMain=$ksSP2pbpMaskBadData
	variable nRows=numpnts(TimeElapsedEff)
	//prepare sample interval wave
	setdatafolder $SP2rawFldrFP
	make /o/d/n=(nRows) $ksSP2sampleInterval=0		//must be double precision!
	wave SampleInterval=$ksSP2sampleInterval
	note SampleInterval, "sample interval [s] corresponding to each trigger;"
	note SampleInterval, "note: the main data mask according to wave "+NameOfWave(Mask_BadDataMain)+" is applied, i.e. interval is set to NaN for flagged triggers;"
	//prepare sample volume wave
	setdatafolder $SP2rawFldrFP
	make /o/d/n=(nRows) $ksSP2sampleVolume=0		//must be double precision!
	wave SampleVolume=$ksSP2sampleVolume
	note SampleVolume, "sample volume [m] corresponding to each trigger;"
	note SampleVolume, "note: the main data mask according to wave "+NameOfWave(Mask_BadDataMain)+" is applied, i.e. volume is set to NaN for flagged triggers;"
	//calculate filtered sample interval per particle
	variable pind, lastind, nextind=0, timediff
	
	do
		lastind=nextind
		nextind+=1
		do
			//search next time increase
			timediff=TimeElapsedEff[nextind]-TimeElapsedEff[lastind]
			// jcc change -- for one specific bad case, may be treating the symptom and not the problem...
// jcc		if ( (timediff!=0) || (nextind==nRows-1))
			if ( (timediff!=0) || (nextind>nRows))
				break
			else
				nextind+=1
			endif			
		while (1)
		timediff/=(nextind-lastind)
		SampleInterval[lastind,nextind-1]=  Mask_BadDataMain[p] ? NaN : timediff		//s
	while (nextind<nRows) // jcc change from (1)
	//calculate filtered sample volume per particle
	SampleVolume=SampleInterval[p]*SampleFlowRate[p]/60e6				//  s*cm/min => m
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2_DeleteRawTraces(ctrlname [rawfldrfp, DelBits]) : ButtonControl
	//This function deletes SP2 raw data traces.
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/08/2010
	String ctrlname	//name of button control; not used
	string rawfldrfp	//full path to data folder containing the raw trace matrices
					//default: browse for folder
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0 => no raw traces are deleted
					//bit0=1:		SCHG traces
					//bit1=2: 	BBHG traces
					//bit2=4:		NBHG traces
					//bit3=8:		SPHG traces
					//bit4=16:	SCLG traces
					//bit5=32:	BBLG traces
					//bit6=64:	NBLG traces
					//bit7=128:	SPLG traces
					//bit8=256:	auxiliary time waves etc.

	
	//preparations
	string savedDF=getdatafolder(1)					
	if (DelBits==0)
		return 0
	endif
	//access data
	setdatafolder $rawfldrfp
	wave /z TimeDiv10000=$ksSP2eventTimeDivPP
	wave /z TimeRemainder=$ksSP2eventTimeRemainder
	wave /z TimeStampEvent=$ksSP2eventTimeStamp
	wave /z Timewave=$ksSP2timewave
	wave /z ParticleID=$ksSP2particleID
	wave /z scattTraceMat=$ksSP2SCHGprefix+ksSP2rawtracemat
	wave /z broadTraceMat=$ksSP2BBHGprefix+ksSP2rawtracemat
	wave /z narrTraceMat=$ksSP2NBHGprefix+ksSP2rawtracemat
	wave /z splitTraceMat=$ksSP2SPHGprefix+ksSP2rawtracemat
	wave /z SCLGtraceMat=$ksSP2SCLGprefix+ksSP2rawtracemat
	wave /z BBLGtraceMat=$ksSP2BBLGprefix+ksSP2rawtracemat
	wave /z NBLGtraceMat=$ksSP2NBLGprefix+ksSP2rawtracemat
	wave /z SPLGtraceMat=$ksSP2SPLGprefix+ksSP2rawtracemat
	//kill data
	if (DelBits&1)
		killwaves /z 	scattTraceMat
	endif
	if (DelBits&2)
		killwaves /z 	broadTraceMat
	endif
	if (DelBits&4)
		killwaves /z 	narrTraceMat
	endif
	if (DelBits&8)
		killwaves /z 	splitTraceMat
	endif
	if (DelBits&16)
		killwaves /z 	SCLGtraceMat
	endif
	if (DelBits&32)
		killwaves /z 	BBLGtraceMat
	endif
	if (DelBits&64)
		killwaves /z 	NBLGtraceMat
	endif
	if (DelBits&128)
		killwaves /z 	SPLGtraceMat
	endif
	if (DelBits&256)
		killwaves /z ParticleID, TimeStampEvent, TimeRemainder, TimeDiv10000, TimeWave	
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end



Function SP2_LEO_TA_FitMain_MT(rawfldrfp, BeamShapeFldrFP, LEOfitFastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ChanPrefix, PSDprefix, DelBits)
	//This function performs the LEO-fit trace analysis for the selected scattering or split detector channel.
	//return value:	0, not used
	//note: standard trace analysis must be run before using this function
	//martin.gysel@psi.ch; 	12/08/2010, 13/08/2010, 15/08/2010, 24/08/2010, 12/09/2010, 28/09/2010, 02/12/2010
	//						13/01/2011, 16/05/2011, 14/12/2011, 23/12/2011, 01/10/2012
	//joel.c.corbin+sci@gmail.com; 2016-02-16 
	string rawfldrfp		//full path to folder containing the raw data
	string BeamShapeFldrFP		//full path to folder containing the beam shape data
	variable LEOfitFastFit	//0: use slow and more accurate variant of LEO fit
						//1: use fast variant of LEO fit
	variable LEOfitRange	//fraction of maximum scattering amplitude of last data point to be included in LEO fit
						//unit: [%]
	variable LEOfitMinNumPts	//minimum number of data points within LEO-fit-range required for valid LEO fit
							//unit: [-]
							//ignored if fast variant of LEO fit is used
	variable LEOfitFastNumPts	//number of points averaged for peak height with fast variant of LEO fit
								//unit: [-]
								//ingnored if slow and more accurate variant of LEO fit is used
	string ChanPrefix		//prefix of channel to be analysed
						//use constant "ksSP2SCHGprefix" or "ksSP2SPHGprefix"
	string PSDprefix		//prefix of PSD (split detector) channel to be used for split point
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//note, this can be a combined channel
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0  => no raw traces are deleted
					//DelBits>0  => selected raw traces are deleted
					//see sub-procedure for meaning of the individual bits
					//default: use panel setting (all or nothing deleted)
	
	//start timing
	variable timerRefNum = StartMSTimer
	variable PrintDuration=1
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	rawfldrfp=ChopLastCharacterOff(rawfldrfp,":")
	string pbpfldrfp=SP2_RawfldrFP2PBPfldrFP(rawfldrfp)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	CreateFoldersOfFullPath(leofldrfp, 0)
	CreateFoldersOfFullPath(LeoTraceFitSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoBeamCalibSubFldrFP, 0)
	//channel specific preparations
	string ChanDescr=stringfromlist(0,SP2_ChanListToDescrLongList(ChanPrefix))
	string BaselineBnam
	Variable SatVal, MinOrMaxForSat
	setdatafolder $ksSP2PathToToolkitPanelFldr
	strswitch(ChanPrefix)	
		case ksSP2SCHGprefix:	
			BaselineBnam=ksSP2PBPscattGaussoffset
			Nvar MaxSigVal=$ksSP2maxSigSCHG
			SatVal=MaxSigVal
			MinOrMaxForSat=1
			break				
		case ksSP2SCLGprefix:	
			BaselineBnam=ksSP2PBPscattGaussoffset
			Nvar MaxSigVal=$ksSP2maxSigSCLG
			SatVal=MaxSigVal
			MinOrMaxForSat=1
			break				
		case ksSP2SPHGprefix:	
			BaselineBnam=ksSP2PBPsplitBasicOffset
			SatVal=kSP2rawSignalMin
			MinOrMaxForSat=0
			break				
		case ksSP2SPLGprefix:	
			BaselineBnam=ksSP2PBPsplitBasicOffset
			SatVal=kSP2rawSignalMin
			MinOrMaxForSat=0
			break				
		default:							
			setdatafolder $savedDF
			message="Undefined value of the parameter 'ChanPrefix' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message			
	endswitch
	//write info string (LEO trace fit subfolder)
	setdatafolder $LeoTraceFitSubFldrFP
	string /g $ksSP2LEOtraceFitInfoStr=""
	Svar LEOtraceFitInfoStr=$ksSP2LEOtraceFitInfoStr			
	LEOtraceFitInfoStr+=ksSP2LEOfitRangeKey+"="+num2str(LEOfitRange)+"\r"
	LEOtraceFitInfoStr+=ksSP2LEOfitMinNumbPtsKey+"="+num2str(LEOfitMinNumPts)+"\r"
	LEOtraceFitInfoStr+=ksSP2LEOfitBeamShapeFPkey+"="+BeamShapeFldrFP+"\r"
	//access raw data waves
	setdatafolder $rawfldrfp
	wave /Z RawTraceMat=$ChanPrefix+ksSP2rawtracemat
	variable nRows=dimsize(RawTraceMat,0)
	variable tracelen=dimsize(RawTraceMat,1)
	if (!waveexists(RawTraceMat))
		//no data trace data available => nothing to be done
		if (datafolderexists(savedDF))
			setdatafolder $savedDF
		endif
		return 0
	endif
	
	//access PBP waves
	setdatafolder $pbpfldrfp
		//general
		wave BasicCentreSplitPos=$PSDprefix+ksSP2PBPsplitCentreSplitPos		
		//specific for selected channel
		wave StandardFitBaseline=$ChanPrefix+BaselineBnam
	//access mandatory LEO waves  (below three waves must be in the folder "BeamShapeFldrFP" in order to perform the LEO-fit
	setdatafolder $BeamShapeFldrFP
	wave /Z LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta					
	wave /Z BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
	wave /Z scatt_BeamShapeCentrePos=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos
	if (!WaveExists(LEOfitSplit2centreDelta) || !WaveExists(BeamShapePerc50) || !WaveExists(scatt_BeamShapeCentrePos))
		// v4111 jcc -- ensure essential waves exist (sometimes the folder is created without the waves)
		SP2_abort("LEO fit error -- did not find the required beam shape and split-position waves in folder " + BeamShapeFldrFP)
	endif
	
	//copy slope fudge factor and PSD calibration factor if needed
		variable meanFSSF, meanFSCF
		//SCHG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsSlopeFudgeFactFitSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
			//scattering slope fudge factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitSlopeFudgeFactSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
			if (!waveexists(LEOfitSlopeFudgeFactSCHG) && waveexists(BeamFldrsSlopeFudgeFactFitSCHG) )
				wavestats /Q BeamFldrsSlopeFudgeFactFitSCHG
				meanFSSF=V_avg
//						meanFSSF=MeanNaN(BeamFldrsSlopeFudgeFactFitSCHG)
				make /o/n=(nRows) $ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit=meanFSSF
				wave LEOfitSlopeFudgeFactSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
				note LEOfitSlopeFudgeFactSCHG, note(BeamFldrsSlopeFudgeFactFitSCHG)						
			endif
		//SCLG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsSlopeFudgeFactFitSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
			//scattering slope fudge factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitSlopeFudgeFactSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
			if (!waveexists(LEOfitSlopeFudgeFactSCLG) && waveexists(BeamFldrsSlopeFudgeFactFitSCLG) )
				wavestats /Q BeamFldrsSlopeFudgeFactFitSCLG
				meanFSSF=V_avg
//						meanFSSF=MeanNaN(BeamFldrsSlopeFudgeFactFitSCLG)
				make /o/n=(nRows) $ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit=meanFSSF
				wave LEOfitSlopeFudgeFactSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
				note LEOfitSlopeFudgeFactSCLG, note(BeamFldrsSlopeFudgeFactFitSCLG)					
			endif			
		//SPHG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit
			//PSD calibration factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit										
			if (!waveexists(LEOfitCalFactSPHG) && waveexists(BeamFldrsCalFactSPHG))
				wavestats /Q BeamFldrsCalFactSPHG
				meanFSCF=V_avg
//					meanFSCF=MeanNaN(BeamFldrsCalFactSPHG)
				make /o/n=(nRows) $ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit=meanFSCF
				wave LEOfitCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit										
				note LEOfitCalFactSPHG, note(BeamFldrsCalFactSPHG)
			endif
		//SPLG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit
			//PSD calibration factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit										
			if (!waveexists(LEOfitCalFactSPLG) && waveexists(BeamFldrsCalFactSPLG))
				wavestats /Q BeamFldrsCalFactSPLG
				meanFSCF=V_avg
//					meanFSCF=MeanNaN(BeamFldrsCalFactSPLG)
				make /o/n=(nRows) $ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit=meanFSCF
				wave LEOfitCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit										
				note LEOfitCalFactSPLG, note(BeamFldrsCalFactSPLG)
			endif
			
	//prepare LEO trace fit result waves (trace fit subfolder)
		//general
		setdatafolder $LeoTraceFitSubFldrFP
		make /o/n=(nRows) $ksSP2LEOfitBeamPos=NaN
		wave LEOfitBeamPos=$ksSP2LEOfitBeamPos		
		note LEOfitBeamPos, "Beam position derived from split detector signal;"
		make /o/n=(nRows) $ksSP2LEOfitLastPt=NaN
		wave LEOfitLastPt=$ksSP2LEOfitLastPt			
		note LEOfitLastPt, "Last point of trace included in the LEO fit;"
		//channel specific
		setdatafolder $LeoTraceFitSubFldrFP
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitOffsetBnam=NaN
		wave LEOfitOffset=$ChanPrefix+ksSP2LEOfitOffsetBnam			
		note LEOfitOffset, ChanDescr+" channel baseline obtained from LEO fit: all particles;"
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitPeakHtAllUncorrBnam=NaN
		wave LEOfitPeakHtAllUncorr=$ChanPrefix+ksSP2LEOfitPeakHtAllUncorrBnam			
		note LEOfitPeakHtAllUncorr, ChanDescr+" channel peak height obtained from LEO fit: all particles;"
		note LEOfitPeakHtAllUncorr, "Not corrected with slope fudge factor;"
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitErrorBnam=NaN
		wave LEOfitError=$ChanPrefix+ksSP2LEOfitErrorBnam			
		note LEOfitError, "Fit error reported when fitting beam shape to leading edge of "+ChanDescr+" channel;"
		make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
		wave LEOfitSaturated=$ChanPrefix+ksSP2PBPsaturated
		note LEOfitSaturated, "1: Leading edge of "+ChanDescr+" trace is saturated;"
		note LEOfitSaturated, "0: not saturated;"
		
	//various preparations for LEO-fit
	variable Level2CentreDeltaP=SP2_LEO_Fit_BeamShapePrep_MT(BeamShapePerc50, scatt_BeamShapeCentrePos[0], LEOfitRange/100)
	wave BeamShapeForFitFkt=$ksSP2LEOfitTempBeamShape_MT
	variable FitWave_Xmin=pnt2x(BeamShapeForFitFkt, 0)
	Multithread LEOfitBeamPos=BasicCentreSplitPos[p]+LEOfitSplit2centreDelta[0]					//beam centre position for each particles (row)
	Multithread LEOfitLastPt=floor(LEOfitBeamPos[p]-Level2CentreDeltaP)							//index of last raw signal data point to be included in the LEO fit for each particle (row)
	make /o/FREE/n=(nRows) LEOfitFirstPt=ceil(LEOfitBeamPos[p]-scatt_BeamShapeCentrePos[0])		//index of first raw signal data point to be included in the LEO fit for each particle (row)
	variable	LEOfitLastPtInBeamShape=floor(scatt_BeamShapeCentrePos[0]-Level2CentreDeltaP)	//index of last reference beam shape data point to be included in the LEO fit			
	//fit type specific preparations
	string HoldStr

	//perform the LEO-fit
	switch(LEOfitFastFit)
		case kSP2LEOfitTypeBeamShapeSlow:		//slow and accurate fit using actual beam shape				
			//preparations
			HoldStr="10"		//use "10" to hold the offset or "00" to refit the offset
			make /O/FREE/C/n=(nRows) tempFitResult
			make /O/FREE/n=(nRows) BadInput= numtype(LEOfitLastPt[p])==2	//0: good input; 1: bad input => skip LEO-fit
			//fit   Note:	Multithread does not yet work on the following line, even though it should!? Is this a problem with the "all-at-once" fit function?
			//			Adding "Threadsafe to SP2_LEO_FitWorker_ShapeSlow_TS brings an error at execution, which is not of consequence
			//			Adding "Multithread" to the next line causes false results (except if the next line is just executed for a single row)
			tempFitResult=SP2_LEO_FitWorker_ShapeSlow_TS(RawTraceMat, p, LEOfitBeamPos[p], StandardFitBaseline[p], LEOfitFirstPt[p], LEOfitLastPt[p], LEOfitMinNumPts, SatVal, MinOrMaxForSat, LEOfitRange/100, HoldStr, LEOfitSaturated, LEOfitError)
			//write fit result to target waves
			Multithread LEOfitOffset=real(tempFitResult[p])
			Multithread LEOfitPeakHtAllUncorr=imag(tempFitResult[p])
			break				
		case kSP2LEOfitTypeBeamShapeFast:		//fast fit using actual beam shape
			//preparations
			make /O/FREE/C/n=(nRows,2) tempFitResult
			make /O/FREE/n=(nRows) BadInput= numtype(LEOfitLastPt[p])==2	//0: good input; 1: bad input => skip LEO-fit
			variable RefPkHtFast
				//note: the following approach for calculating "RefPkHtFast" must be consistent with the sub-procedure performing the actual LEO-fit
				make/o/FREE/n=(LEOfitFastNumPts) BeamShapeAvgRangeTrace=BeamShapePerc50[p+LEOfitLastPtInBeamShape+1-LEOfitFastNumPts]
				wavestats /Q BeamShapeAvgRangeTrace
				RefPkHtFast=V_avg
			//fit
			Multithread tempFitResult=SP2_LEO_FitWorker_ShapeFast_TS(RawTraceMat, p, StandardFitBaseline[p], LEOfitLastPt[p], LEOfitMinNumPts, LEOfitFastNumPts, RefPkHtFast, MinOrMaxForSat, SatVal, LEOfitRange/100, LEOfitError)
			//write fit result to target waves
			Multithread LEOfitOffset=StandardFitBaseline[p]	
			Multithread LEOfitPeakHtAllUncorr=real(tempFitResult[p])
			Multithread LEOfitSaturated=imag(tempFitResult[p])
			break				
		case kSP2LEOfitTypeBeamGauss:			//slow fit assuming Gaussian beam shape
			//not yet implemented
//Gauss			//preparations
//Gauss			SP2_LEO_FitWorker_Gaussian_TS		//this is just a dummy function so far ...
//Gauss			HoldStr="1011"		//use "1011" to hold the offset or "0011" to refit the offset
//Gauss			setdatafolder $tmpfldrpath
//Gauss			make /o/n=4 LEOcoef
//Gauss			break				
			break				
		default:
			setdatafolder $savedDF
			message="Undefined value of the parameter 'LEOfitFastFit' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message							
	endswitch
	
// print "jcc temp LEO hack on ", now()
// LEOfitPeakHtAllUncorr=doLEOfitAtPoint(p, RawTraceMat)
	
	
	//delete raw traces if selected
	SP2_DeleteRawTraces("", rawfldrfp=rawfldrfp, DelBits=DelBits)	
	//print duration
	string elapsed=num2str(StopMSTimer(timerRefNum)/1e6)
	if(PrintDuration)
		Printf "LEO-fit MT = "+elapsed+"s\r"
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_LEOfitTraceAnalysis(rawfldrfp, BeamShapeFldrFP, LEOfitFastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ChanPrefix, PSDprefix, DelBits)
	//This function performs the LEO-fit trace analysis for the selected scattering or split detector channel.
	//it is not currently used!! v4110
	//return value:	0, not used
	//note: standard trace analysis must be run before using this function
	//martin.gysel@psi.ch; 	12/08/2010, 13/08/2010, 15/08/2010, 24/08/2010, 12/09/2010, 28/09/2010, 02/12/2010
	//						13/01/2011, 16/05/2011, 14/12/2011, 23/12/2011
	string rawfldrfp		//full path to folder containing the raw data
	string BeamShapeFldrFP		//full path to folder containing the beam shape data
	variable LEOfitFastFit	//0: use slow and more accurate variant of LEO fit
						//1: use fast variant of LEO fit
	variable LEOfitRange	//fraction of maximum scattering amplitude of last data point to be included in LEO fit
						//unit: [%]
	variable LEOfitMinNumPts	//minimum number of data points within LEO-fit-range required for valid LEO fit
							//unit: [-]
							//ignored if fast variant of LEO fit is used
	variable LEOfitFastNumPts	//number of points averaged for peak height with fast variant of LEO fit
								//unit: [-]
								//ingnored if slow and more accurate variant of LEO fit is used
	string ChanPrefix		//prefix of channel to be analysed
						//use constant "ksSP2SCHGprefix" or "ksSP2SPHGprefix"
	string PSDprefix		//prefix of PSD (split detector) channel to be used for split point
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//note, this can be a combined channel
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0  => no raw traces are deleted
					//DelBits>0  => selected raw traces are deleted
					//see sub-procedure for meaning of the individual bits
					//default: use panel setting (all or nothing deleted)
	
	//start timing
	variable timerRefNum = StartMSTimer
	variable PrintDuration=1
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	rawfldrfp=ChopLastCharacterOff(rawfldrfp,":")
	string pbpfldrfp=SP2_RawfldrFP2PBPfldrFP(rawfldrfp)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	CreateFoldersOfFullPath(leofldrfp, 0)
	CreateFoldersOfFullPath(LeoTraceFitSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoBeamCalibSubFldrFP, 0)
	//channel specific
	string ChanDescr=stringfromlist(0,SP2_ChanListToDescrLongList(ChanPrefix))
	string BaselineBnam
	setdatafolder $ksSP2PathToToolkitPanelFldr
	strswitch(ChanPrefix)	
		case ksSP2SCHGprefix:	
			BaselineBnam=ksSP2PBPscattGaussoffset
			Nvar MaxSigVal=$ksSP2maxSigSCHG
			break				
		case ksSP2SCLGprefix:	
			BaselineBnam=ksSP2PBPscattGaussoffset
			Nvar MaxSigVal=$ksSP2maxSigSCLG
			break				
		case ksSP2SPHGprefix:	
			BaselineBnam=ksSP2PBPsplitBasicOffset
			Nvar MaxSigVal=$ksSP2maxSigSPHG
			break				
		case ksSP2SPLGprefix:	
			BaselineBnam=ksSP2PBPsplitBasicOffset
			Nvar MaxSigVal=$ksSP2maxSigSPLG
			break				
		default:							
			setdatafolder $savedDF
			message="Undefined value of the parameter 'ChanPrefix' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message			
	endswitch
	//write info string (LEO trace fit subfolder)
	setdatafolder $LeoTraceFitSubFldrFP
	string /g $ksSP2LEOtraceFitInfoStr=""
	Svar LEOtraceFitInfoStr=$ksSP2LEOtraceFitInfoStr			
	LEOtraceFitInfoStr+=ksSP2LEOfitRangeKey+"="+num2str(LEOfitRange)+"\r"
	LEOtraceFitInfoStr+=ksSP2LEOfitMinNumbPtsKey+"="+num2str(LEOfitMinNumPts)+"\r"
	LEOtraceFitInfoStr+=ksSP2LEOfitBeamShapeFPkey+"="+BeamShapeFldrFP+"\r"
	//access raw data waves
	setdatafolder $rawfldrfp
	wave RawTraceMat=$ChanPrefix+ksSP2rawtracemat
	variable nRows=dimsize(RawTraceMat,0)
	variable tracelen=dimsize(RawTraceMat,1)
	if (!waveexists(RawTraceMat))
		//no data trace data available => nothing to be done
		if (datafolderexists(savedDF))
			setdatafolder $savedDF
		endif
		return 0
	endif
	//access PBP waves
	setdatafolder $pbpfldrfp
		//general
		wave BasicCentreSplitPos=$PSDprefix+ksSP2PBPsplitCentreSplitPos		
		//specific for selected channel
		wave StandardFitBaseline=$ChanPrefix+BaselineBnam
	//access mandatory LEO waves  (below three waves must be in the folder "BeamShapeFldrFP" in order to perform the LEO-fit
	setdatafolder $BeamShapeFldrFP
	wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta					
	wave BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
	wave scatt_BeamShapeCentrePosN1=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos // jcc v420: N1 == 1 point only
	//find level in beam shape trace and determine number of points before beam centre to be skipped
	FindLevel /P/Q/R=(0,scatt_BeamShapeCentrePosN1[0]) BeamShapePerc50, LEOfitRange/100
	variable deltaskip=scatt_BeamShapeCentrePosN1[0]-V_LevelX		
	//copy slope fudge factor and PSD calibration factor if needed
		variable meanFSSF, meanFSCF
		//SCHG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z  BeamFldrsSlopeFudgeFactFitSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
			//scattering slope fudge factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitSlopeFudgeFactSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
			if (!waveexists(LEOfitSlopeFudgeFactSCHG) && waveexists(BeamFldrsSlopeFudgeFactFitSCHG) )
				wavestats /Q BeamFldrsSlopeFudgeFactFitSCHG
				meanFSSF=V_avg
//						meanFSSF=MeanNaN(BeamFldrsSlopeFudgeFactFitSCHG)
				make /o/n=(nRows) $ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit=meanFSSF
				wave LEOfitSlopeFudgeFactSCHG=$ksSP2SCHGprefix+ksSP2LEOscattSlopeFudgeFacFit
				note LEOfitSlopeFudgeFactSCHG, note(BeamFldrsSlopeFudgeFactFitSCHG)						
			endif
		//SCLG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsSlopeFudgeFactFitSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
			//scattering slope fudge factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitSlopeFudgeFactSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
			if (!waveexists(LEOfitSlopeFudgeFactSCLG) && waveexists(BeamFldrsSlopeFudgeFactFitSCLG) )
				wavestats /Q BeamFldrsSlopeFudgeFactFitSCLG
				meanFSSF=V_avg
//						meanFSSF=MeanNaN(BeamFldrsSlopeFudgeFactFitSCLG)
				make /o/n=(nRows) $ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit=meanFSSF
				wave LEOfitSlopeFudgeFactSCLG=$ksSP2SCLGprefix+ksSP2LEOscattSlopeFudgeFacFit
				note LEOfitSlopeFudgeFactSCLG, note(BeamFldrsSlopeFudgeFactFitSCLG)					
			endif			
		//SPHG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave /Z BeamFldrsCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit
			//PSD calibration factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave /Z LEOfitCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit										
			if (!waveexists(LEOfitCalFactSPHG) && waveexists(BeamFldrsCalFactSPHG))
				wavestats /Q BeamFldrsCalFactSPHG
				meanFSCF=V_avg
//					meanFSCF=MeanNaN(BeamFldrsCalFactSPHG)
				make /o/n=(nRows) $ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit=meanFSCF
				wave LEOfitCalFactSPHG=$ksSP2SPHGprefix+ksSP2LEOPSDcalFactFit										
				note LEOfitCalFactSPHG, note(BeamFldrsCalFactSPHG)
			endif
		//SPLG
			//access waves
			setdatafolder $BeamShapeFldrFP
			wave BeamFldrsCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit
			//PSD calibration factor for LEO-fit
			setdatafolder $LeoBeamCalibSubFldrFP
			wave LEOfitCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit										
			if (!waveexists(LEOfitCalFactSPLG) && waveexists(BeamFldrsCalFactSPLG))
				wavestats /Q BeamFldrsCalFactSPLG
				meanFSCF=V_avg
//					meanFSCF=MeanNaN(BeamFldrsCalFactSPLG)
				make /o/n=(nRows) $ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit=meanFSCF
				wave LEOfitCalFactSPLG=$ksSP2SPLGprefix+ksSP2LEOPSDcalFactFit										
				note LEOfitCalFactSPLG, note(BeamFldrsCalFactSPLG)
			endif
	//prepare LEO trace fit result waves (trace fit subfolder)
		//general
		setdatafolder $LeoTraceFitSubFldrFP
		make /o/n=(nRows) $ksSP2LEOfitBeamPos=NaN
		wave LEOfitBeamPos=$ksSP2LEOfitBeamPos		
		note LEOfitBeamPos, "Beam position derived from split detector signal;"
		make /o/n=(nRows) $ksSP2LEOfitLastPt=NaN
		wave LEOfitLastPt=$ksSP2LEOfitLastPt			
		note LEOfitLastPt, "Last point of trace included in the LEO fit;"
		//channel specific
		setdatafolder $LeoTraceFitSubFldrFP
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitOffsetBnam=NaN
		wave LEOfitOffset=$ChanPrefix+ksSP2LEOfitOffsetBnam			
		note LEOfitOffset, ChanDescr+" channel baseline obtained from LEO fit: all particles;"
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitPeakHtAllUncorrBnam=NaN
		wave LEOfitPeakHtAllUncorr=$ChanPrefix+ksSP2LEOfitPeakHtAllUncorrBnam			
		note LEOfitPeakHtAllUncorr, ChanDescr+" channel peak height obtained from LEO fit: all particles;"
		note LEOfitPeakHtAllUncorr, "Not corrected with slope fudge factor;"
		make /o/n=(nRows) $ChanPrefix+ksSP2LEOfitErrorBnam=NaN
		wave LEOfitError=$ChanPrefix+ksSP2LEOfitErrorBnam			
		note LEOfitError, "Fit error reported when fitting beam shape to leading edge of "+ChanDescr+" channel;"
		make /o/n=(nRows) $ChanPrefix+ksSP2PBPsaturated=0
		wave LEOfitSaturated=$ChanPrefix+ksSP2PBPsaturated
		note LEOfitSaturated, "1: Leading edge of "+ChanDescr+" trace is saturated;"
		note LEOfitSaturated, "0: not saturated;"
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2LEOtraceFit
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=0 currtrace
	Variable /g V_fitOptions=4
	Variable /g V_fitError; NVar V_fitError
	//various preparations for LEO-fit
	LEOfitBeamPos=BasicCentreSplitPos[p]+LEOfitSplit2centreDelta[0]
	CreateFoldersOfFullPath(ksSP2LEOfitTempBeamShape, 1)
	SP2_LEOfitWithBeamShape_FitPrep(BeamShapePerc50, 0)
	wave RefBeamShape=$ksSP2LEOfitTempBeamShape
	//fit type specific preparations
	string HoldStr
	variable aind, FastAvg, RefPkHtFast
	switch(LEOfitFastFit)
		case kSP2LEOfitTypeBeamShapeSlow:		//slow and accurate fit using actual beam shape				
			HoldStr="10"		//use "10" to hold the offset or "00" to refit the offset
			setdatafolder $tmpfldrpath
			make /o/n=2 LEOcoef
			break				
		case kSP2LEOfitTypeBeamShapeFast:		//fast fit using actual beam shape	
			FastAvg=0
			for (aind=0; aind<LEOfitFastNumPts; aind+=1)
				FastAvg+=BeamShapePerc50[scatt_BeamShapeCentrePosN1[0]-deltaskip-1-aind]	
			endfor
			RefPkHtFast=FastAvg/LEOfitFastNumPts
			break				
//Gauss		case kSP2LEOfitTypeBeamGauss:			//slow fit assuming Gaussian beam shape
//Gauss			HoldStr="1011"		//use "1011" to hold the offset or "0011" to refit the offset
//Gauss			setdatafolder $tmpfldrpath
//Gauss			make /o/n=4 LEOcoef
//Gauss			break				
		default:
			setdatafolder $savedDF
			message="Undefined value of the parameter 'LEOfitFastFit' handed over to the function "+currproc+"!"
			print message; print RTStackInfo; abort message							
	endswitch
	//loop over all data points and perform LEO-fit
	variable pind, fitrange
	setdatafolder $tmpfldrpath

	for (pind=0; pind<=nRows; pind+=1)
		//fit type specific preparations
		switch(LEOfitFastFit)
			case kSP2LEOfitTypeBeamShapeSlow:		//slow and accurate fit using actual beam shape				
				//"deltaskip":
					//so far treated as time independent beam shape => deltasdone above
				//get reference beam shape:
					SP2_LEOfitWithBeamShape_FitPrep(BeamShapePerc50, scatt_BeamShapeCentrePosN1[0]-LEOfitBeamPos[pind])				
				break				
			case kSP2LEOfitTypeBeamShapeFast:		//fast fit using actual beam shape				
				//"deltaskip":
					//so far treated as time independent beam shape => deltasdone above
				//get reference beam shape:
					//not required
				break				
//Gauss			case kSP2LEOfitTypeBeamGauss:			//slow fit assuming Gaussian beam shape
//Gauss				//"deltaskip":
//Gauss					//time dependent beam shape (FWHM) is possible
//Gauss					deltaskip=LEOfitBeamFWHM[pind]/1.66511*sqrt(ln(100/LEOfitRange))			//number of points across which the amplitude drops to LEOfitRange ([%]) times its maximum
//Gauss				//get reference beam shape:
//Gauss					//not required
				break				
			default:
				setdatafolder $savedDF
				message="Undefined value of the parameter 'LEOfitFastFit' handed over to the function "+currproc+"!"
				print message; print RTStackInfo; abort message							
		endswitch
		//determine number of points of raw signal trace which are to be included in LEO fit
		LEOfitLastPt[pind]=round(LEOfitBeamPos[pind]-deltaskip)
		if (numtype(LEOfitLastPt[pind])==2)
			//split point not available
			//	=> skip this particle
			continue
		elseif (LEOfitLastPt[pind]<LEOfitMinNumPts)
			//not enough valid data points within fit range
			//	=> skip this particle
			continue
		endif
		fitrange=LEOfitLastPt[pind]+1		//"+1" in order to make sure that the "LastPt" is also included in the fit
		//extract current trace
		redimension /n=(fitrange) currtrace
		currtrace=RawTraceMat[pind][p]
		//check whether leading edge of trace is saturated
		wavestats /q currtrace
		variable SatVal
		strswitch(ChanPrefix)	
			case ksSP2SCHGprefix:	
				if ( V_max>=MaxSigVal)					
					LEOfitSaturated[pind]=1
					SatVal=MaxSigVal
				endif
				break				
			case ksSP2SCLGprefix:	
				if ( V_max>=MaxSigVal)					
					LEOfitSaturated[pind]=1
					SatVal=MaxSigVal
				endif
				break				
			case ksSP2SPHGprefix:	
				if ( V_min<=kSP2rawSignalMin )
					LEOfitSaturated[pind]=1
					SatVal=kSP2rawSignalMin
				endif
				break				
			case ksSP2SPLGprefix:	
				if ( V_min<=kSP2rawSignalMin )
					LEOfitSaturated[pind]=1
					SatVal=kSP2rawSignalMin
				endif
				break				
			default:							
				setdatafolder $savedDF
				message="Undefined value of the parameter 'ChanPrefix' handed over to the function "+currproc+"!"
				print message; print RTStackInfo; abort message			
		endswitch
		if(LEOfitSaturated[pind]==1)
			//write value corresponding to saturation into fit coefficients
			switch(LEOfitFastFit)
				case kSP2LEOfitTypeBeamShapeSlow:		//slow and accurate fit using actual beam shape				
					V_fitError=0
					LEOfitOffset[pind]=StandardFitBaseline[pind]
					LEOfitPeakHtAllUncorr[pind]=(SatVal-StandardFitBaseline[pind])/RefBeamShape[fitrange-1]
					continue		//proceed with next trace			
					break				
				case kSP2LEOfitTypeBeamShapeFast:		//fast fit using actual beam shape				
					SP2_LEOfitWithBeamShape_FitPrep(BeamShapePerc50, scatt_BeamShapeCentrePosN1[0]-LEOfitBeamPos[pind])	//this hasen't yet been done
					V_fitError=0
					LEOfitOffset[pind]=StandardFitBaseline[pind]
					LEOfitPeakHtAllUncorr[pind]=(SatVal-StandardFitBaseline[pind])/RefBeamShape[fitrange-1]
					continue		//proceed with next trace			
					break				
//Gauss				case kSP2LEOfitTypeBeamGauss:			//slow fit assuming Gaussian beam shape
//Gauss					//treatment of saturated particles remains to be implemented
//Gauss					break				
				default:
					setdatafolder $savedDF
					message="Undefined value of the parameter 'LEOfitFastFit' handed over to the function "+currproc+"!"
					print message; print RTStackInfo; abort message							
			endswitch
		endif
		//do LEO-fit depending on selected fit type 	LEO_FAST_FIT
		switch(LEOfitFastFit)
			case kSP2LEOfitTypeBeamShapeSlow:		//slow and accurate fit using actual beam shape				
				//initial guess
				V_fitError=0
				LEOcoef[0]=StandardFitBaseline[pind]
				LEOcoef[1]=(currtrace[inf]-StandardFitBaseline[pind])/RefBeamShape[fitrange-1]
				//fit
				FuncFit/H=HoldStr/N/NTHR=0/Q SP2_LEOfitWithBeamShape_AAOFfkt, kwCWave=LEOcoef, currtrace		//use all at once fit function
				//copy data to result waves
				LEOfitError[pind]=V_fitError
				if (V_FitError==0)
					//keep fit results only if there was no fit error
					LEOfitOffset[pind]=LEOcoef[0]
					LEOfitPeakHtAllUncorr[pind]=LEOcoef[1]
				endif
				break				
			case kSP2LEOfitTypeBeamShapeFast:		//fast fit using actual beam shape
				//baseline
				LEOfitOffset[pind]=StandardFitBaseline[pind]		//use baseline from standard trace analysis
				//read peak height from latest possible point
				FastAvg=0
				for (aind=0; aind<LEOfitFastNumPts; aind+=1)
					FastAvg+=currtrace[fitrange-1-aind]
//xx						FastAvg+=BeamShapePerc50[scatt_BeamShapeCentrePos-deltaskip-1-aind]	 // jcc : this was an error until v4111, but we are talking about 0.03 error compared to -30000
				endfor
				FastAvg/=LEOfitFastNumPts
				FastAvg-=StandardFitBaseline[pind]		//subtract baseline
				FastAvg/=RefPkHtFast					//normalize signal by corresponding value of reference beam shape

				//copy to result waves if no error occurred
				if (numtype(FastAvg)==2)
					//failed
					LEOfitError[pind]=1
					LEOfitOffset[pind]=NaN
					LEOfitPeakHtAllUncorr[pind]=NaN
				else
					//"successfull"
					LEOfitError[pind]=0
					LEOfitOffset[pind]=StandardFitBaseline[pind]	
					LEOfitPeakHtAllUncorr[pind]=FastAvg
				endif
				break				
//Gauss			case kSP2LEOfitTypeBeamGauss:			//slow fit assuming Gaussian beam shape
//Gauss				//fit Gaussian to current trace
//Gauss				V_fitError=0
//Gauss				LEOcoef[0]=StandardFitBaseline[pind]
//Gauss				LEOcoef[1]=1000
//Gauss				LEOcoef[2]=LEOfitBeamPos[pind]
//Gauss				LEOcoef[3]=LEOfitBeamFWHM[pind]/(1.66511)
//Gauss					//note: 
//Gauss						//Built-in gauss fit uses: width=sqrt(2)*(std. dev.)
//Gauss						//FWHM=2*sqrt(2*ln(2))*(std. dev.)
//Gauss						// => width = FWHM/(2*sqrt(ln(2)))=FWHM/1.66511
//Gauss				CurveFit/H=HoldStr/N/NTHR=0/Q gauss, kwCWave=LEOcoef, currtrace				
//Gauss				//copy data to result waves
//Gauss				LEOfitError[pind]=V_fitError
//Gauss				if (V_FitError==0)
//Gauss					//keep fit results only if there was no fit error
//Gauss					LEOfitOffset[pind]=LEOcoef[0]
//Gauss					LEOfitPeakHtAllUncorr[pind]=LEOcoef[1]
//Gauss				endif
			default:
				setdatafolder $savedDF
				message="Undefined value of the parameter 'LEOfitFastFit' handed over to the function "+currproc+"!"
				print message; print RTStackInfo; abort message							
		endswitch
	endfor
	//delete raw traces if selected
	SP2_DeleteRawTraces("", rawfldrfp=rawfldrfp, DelBits=DelBits)	
	//print duration
	string elapsed=num2str(StopMSTimer(timerRefNum)/1e6)
	if(PrintDuration)
		Printf "LEO-fit ST = "+elapsed+"s\r"
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


Function SP2_LEOfitTraceAnalysisButt(ctrlname, [pbpfldrfp, BeamShapeFldrFP, LEOfitfastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, LEOppMode, ChanBits, PSDprefix, DelBits]) : ButtonControl
	//LEO-fit trace analysis (scattering and/or split detector channel) and LEO post processing if selected.
	//return value:	0, not used
	//note: standard trace analysis must be run for the selected channels before using this function (baseline will be taken from standard trace analysis)
	//martin.gysel@psi.ch;	12/08/2010, 13/08/2010, 15/08/2010, 16/08/2010, 19/09/2010, 28/09/2010, 02/12/2010
	//						13/01/2011, 16/05/2011
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string BeamShapeFldrFP		//full path to folder containing the beam shape data
								//default: browse for folder
	variable LEOfitfastFit	//0: use slow and more accurate variant of LEO fit
						//1: use fast variant of LEO fit
						//default: use panel setting
	variable LEOfitRange	//fraction of maximum scattering amplitude of last data point to be included in LEO fit
						//unit: [%]
						//default: use panel setting
	variable LEOfitMinNumPts	//minimum number of data points within LEO-fit-range required for valid LEO fit
							//unit: [-]
							//ingnored if fast variant of LEO fit is used
							//default: use panel setting
	variable LEOfitFastNumPts	//number of points averaged for peak height with fast variant of LEO fit
								//unit: [-]
								//ingnored if slow and more accurate variant of LEO fit is used
								//default: use panel setting
	variable LEOppMode	//1: run LEO post processing after LEO trace analysis
						//0: do not run LEO post processing
						//default: use panel setting
	variable ChanBits		//bitwise number to determine which channels are to be fitted
						//bit0=1: true: fit SCHG channel
						//bit3=8: true: fit SPHG channel
						//bit4=16: true: fit SCLG channel
						//bit7=128: true: fit SPLG channel
						//default: use panel settings
	string PSDprefix		//prefix of position sensitive detector (split detector) channel to be used
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//default: use panel setting
						//note, this can also be a combined channel
	variable DelBits	//bitwise value indicating which type of raw data traces are to be deleted
					//DelBits=0  => no raw traces are deleted
					//DelBits>0  => selected raw traces are deleted
					//see sub-procedure for meaning of the individual bits
					//default: use panel setting (all or nothing deleted)
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP") // jcc
// jcc		pbpfldrfp=BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF, AbortMode=1)
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	if (paramisdefault(BeamShapeFldrFP))
		BeamShapeFldrFP= SP2_getBeamShapeFolder() // jcc addition, autodetect folder
	endif
	BeamShapeFldrFP=ChopLastCharacterOff(BeamShapeFldrFP,":")
	if (paramisdefault(LEOfitFastNumPts))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar PanelLEOfitFastNumPts=$ksSP2LEOfitFastNumPts
		LEOfitFastNumPts=PanelLEOfitFastNumPts	
	endif
	if (paramisdefault(LEOfitRange))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar PanelLEOfitRange=$ksSP2LEOfitRange
		LEOfitRange=PanelLEOfitRange	
	endif
	if (paramisdefault(LEOfitMinNumPts))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar PanelLEOfitMinNumPnts=$ksSP2LEOfitMinNumPts
		LEOfitMinNumPts=PanelLEOfitMinNumPnts	
	endif	
	if (paramisdefault(LEOfitFastFit))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar PanelLEOfitFastFit=$ksSP2LEOfitFastFit
		LEOfitFastFit=PanelLEOfitFastFit	
	endif
	if (paramisdefault(LEOppMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitPostProcModeCB=$ksSP2leoFitPostProcModeCB
		LEOppMode=LEOfitPostProcModeCB
	endif
	if (paramisdefault(ChanBits))
		//use panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitSCHGcb=$ksSP2leoFitSCHGcb
		Nvar LEOfitSCLGcb=$ksSP2leoFitSCLGcb
		Nvar LEOfitSPHGcb=$ksSP2leoFitSPHGcb
		Nvar LEOfitSPLGcb=$ksSP2leoFitSPLGcb
		ChanBits=0
		ChanBits+=LEOfitSCHGcb*kSP2chanbitSCHG
		ChanBits+=LEOfitSPHGcb*kSP2chanbitSPHG
		ChanBits+=LEOfitSCLGcb*kSP2chanbitSCLG
		ChanBits+=LEOfitSPLGcb*kSP2chanbitSPLG
	endif
	if (paramisdefault(DelBits))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar rawdatadelmode=$ksSP2rawdatadelmode
		DelBits=rawdatadelmode*(2^16-1)		//delete all raw traces and other unneccessary waves
	endif
	variable mustprompt=0
	if (paramisdefault(PSDprefix))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Svar LEOsplitChanPrefix=$ksSP2leoSplitChanPrefix
		PSDprefix=LEOsplitChanPrefix
	endif
	//LEO-fit trace analysis (the following differ only in the ksSP2...prefix)		
		//SCHG channel
		if (ChanBits&kSP2chanbitSCHG)
			SP2_LEO_TA_FitMain_MT(rawfldrfp, BeamShapeFldrFP, LEOfitfastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ksSP2SCHGprefix, PSDprefix, DelBits)
		endif	
		//SCLG channel
		if (ChanBits&kSP2chanbitSCLG)
			SP2_LEO_TA_FitMain_MT(rawfldrfp, BeamShapeFldrFP, LEOfitfastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ksSP2SCLGprefix, PSDprefix, DelBits)
		endif	
		//SPHG channel
		if (ChanBits&kSP2chanbitSPHG)
			SP2_LEO_TA_FitMain_MT(rawfldrfp, BeamShapeFldrFP, LEOfitfastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ksSP2SPHGprefix, PSDprefix, DelBits)
		endif	
		//SPLG channel
		if (ChanBits&kSP2chanbitSPLG)
			SP2_LEO_TA_FitMain_MT(rawfldrfp, BeamShapeFldrFP, LEOfitfastFit, LEOfitRange, LEOfitMinNumPts, LEOfitFastNumPts, ksSP2SPLGprefix, PSDprefix, DelBits)
		endif	
	//LEO post processing
		if (LEOppMode)
			SP2_LEOverificationAndSizing("", pbpfldrfp=pbpfldrfp)
		endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_LEOperformanceStats(ctrlname, [pbpfldrfp, PercMode]) : ButtonControl
	//Statistics of LEO-fit performance for all channels
	//return value: 0; not used
	//martin.gysel@psi.ch; 08/09/2010, 13/02/2012
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable PercMode	//1: determine median LEO-fit performance only
						//0: determine all percentiles of LEO-fit performance
						//default: use panel settings


	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//channel list
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nChans=itemsinlist(chanlist)	
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	if (paramisdefault(PercMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar LEOfitStatsMedianCB=$ksSP2leoFitStatsMedianCB
		PercMode=LEOfitStatsMedianCB
	endif
	//data folders
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
//	//further defaults
//	if (paramisdefault(PercMode))
//		PercMode=0+1
//		string StatsPopList="10th, 25th, median, 75th and 90th percentiles;median only"
//		prompt PercMode, "Statistics of LEO-fit performance:", popup, StatsPopList
//		doprompt "LEO-fit statistics", PercMode
//		if (V_flag)
//			setdatafolder $savedDF
//			message="User cancelled procedure"+currproc+"!"
//			print message; print RTStackInfo; abort message				
//		endif
//		PercMode-=1	
//	endif
	//loop over all channels
	string CurrLEOprefix, CurrRefPrefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		CurrLEOprefix=stringfromlist(chanind, chanlist)
		//get calibration reference channel
		CurrRefPrefix=SP2_LEO_RetrieveRefChanPrefix(CurrLEOprefix, LeoTraceFitSubFldrFP)
		//determine performance statistics
		SP2_LEOperformanceStats1Chan(CurrLEOprefix, CurrRefPrefix, pbpfldrfp, PercMode)
	endfor
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_LEOperformanceStats1Chan(LEOchanPrefix, RefChanPrefix, pbpfldrfp, PercMode)
	//Statistics of LEO-fit performance.
	//return value: 0; not used
	//martin.gysel@psi.ch; 13/02/2012
	string LEOchanPrefix	//prefix of LEO-fit channel for which the performance statistics are to be made
						//e.g: ksSP2SCHGprefix, ":SCHG_", ksSP2SPHGprefix, or ":SPHG_"
	string RefChanPrefix	//prefix of reference channel against which the LEO-fit channel is verified
						//e.g.: ksSP2SCHGprefix or ":SCHG_"
	string pbpfldrfp		//full path to folder containing the PBP data
	variable PercMode	//1: determine median LEO-fit performance only
						//0: determine 10th, 25th, median, 75th and 90th percentiles of LEO-fit performance
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//data folders
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	//channel properties
	string RefChanAbbrev=ChopLastCharacterOff(SP2_ChanListToAbbrevList(RefChanPrefix),";")
	string LEOchanAbbrev=ChopLastCharacterOff(SP2_ChanListToAbbrevList(LEOchanPrefix),";")
	//access PBP waves
	setdatafolder $pbpfldrfp
	wave /Z RefScattPeakHt=$RefChanPrefix+ksSP2PBPscattGausspeakHeight		
	variable ReferenceAvailable=waveExists(RefScattPeakHt)
	//access LEO waves in trace fit subfolder
	setdatafolder $LeoTraceFitSubFldrFP
	wave /Z LEOfitPeakHtScatt=$LEOchanPrefix+ksSP2LEOfitPeakHtScattBnam
	variable LEOfitAvailable=waveExists(LEOfitPeakHtScatt)
	variable XminBdr, XmaxBdr
	//proceed only if LEO-fit data are available
	if (LEOfitAvailable)
		//proceed with LEO-fit performance statistics only if reference channel data are available
		if (ReferenceAvailable)
			setdatafolder $LeoTraceFitSubFldrFP
			//median
			make /o/n=(1) $LEOchanPrefix+ksSP2LEOperfomStatsPerc50
			wave PerfomStatsPerc50=$LEOchanPrefix+ksSP2LEOperfomStatsPerc50
			note PerfomStatsPerc50, "median of performance of LEO-fit using the"+LEOchanAbbrev+" channel verified against the "+RefChanAbbrev+" channel;"
			XminBdr=max(1,MinFromWaveNaN(RefScattPeakHt,mode=1))
			XmaxBdr=min(kSP2signalAmpMax,MaxFromWaveNaN(RefScattPeakHt,mode=1))
			PercentilesBinnedBy2ndWaveV2(LEOfitPeakHtScatt, RefScattPeakHt, 0.50, kSP2LEOnBinsPerfomStats, PercWav=PerfomStatsPerc50, LogMode=1, XminBdr=XminBdr, XmaxBdr=XmaxBdr)
			if (PercMode==0)
				setdatafolder $LeoTraceFitSubFldrFP
				//10th percentile
				make /o/n=(1) $LEOchanPrefix+ksSP2LEOperfomStatsPerc10
				wave PerfomStatsPerc10=$LEOchanPrefix+ksSP2LEOperfomStatsPerc10
				note PerfomStatsPerc10, "10th percentile of performance of LEO-fit using the"+LEOchanAbbrev+" verified against the "+RefChanAbbrev+" channel;"
				PercentilesBinnedBy2ndWaveV2(LEOfitPeakHtScatt, RefScattPeakHt, 0.10, kSP2LEOnBinsPerfomStats, PercWav=PerfomStatsPerc10, LogMode=1, XminBdr=XminBdr, XmaxBdr=XmaxBdr)
				//25th percentile
				make /o/n=(1) $LEOchanPrefix+ksSP2LEOperfomStatsPerc25
				wave PerfomStatsPerc25=$LEOchanPrefix+ksSP2LEOperfomStatsPerc25
				note PerfomStatsPerc25, "25th percentile of performance of LEO-fit using the"+LEOchanAbbrev+" verified against the "+RefChanAbbrev+" channel;"
				PercentilesBinnedBy2ndWaveV2(LEOfitPeakHtScatt, RefScattPeakHt, 0.25, kSP2LEOnBinsPerfomStats, PercWav=PerfomStatsPerc25, LogMode=1, XminBdr=XminBdr, XmaxBdr=XmaxBdr)
				//75th percentile
				make /o/n=(1) $LEOchanPrefix+ksSP2LEOperfomStatsPerc75
				wave PerfomStatsPerc75=$LEOchanPrefix+ksSP2LEOperfomStatsPerc75
				note PerfomStatsPerc75, "75th percentile of performance of LEO-fit using the"+LEOchanAbbrev+" verified against the "+RefChanAbbrev+" channel;"
				PercentilesBinnedBy2ndWaveV2(LEOfitPeakHtScatt, RefScattPeakHt, 0.75, kSP2LEOnBinsPerfomStats, PercWav=PerfomStatsPerc75, LogMode=1, XminBdr=XminBdr, XmaxBdr=XmaxBdr)
				//90th percentile
				make /o/n=(1) $LEOchanPrefix+ksSP2LEOperfomStatsPerc90
				wave PerfomStatsPerc90=$LEOchanPrefix+ksSP2LEOperfomStatsPerc90
				note PerfomStatsPerc90, "90th percentile of performance of LEO-fit using the"+LEOchanAbbrev+" verified against the "+RefChanAbbrev+" channel;"
				PercentilesBinnedBy2ndWaveV2(LEOfitPeakHtScatt, RefScattPeakHt, 0.90, kSP2LEOnBinsPerfomStats, PercWav=PerfomStatsPerc90, LogMode=1, XminBdr=XminBdr, XmaxBdr=XmaxBdr)				
			endif
		endif
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_check_IsRawFldr(FldrFP)
	//This function checks whether FldrFP is an SP2 raw data folder
	//return value:	1, if it is an SP2 raw data folder
	//				0, if it is not an SP2 raw data folder
	//martin.gysel@psi.ch; 10/09/2010
	string FldrFP		//full path to folder to be checked

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	FldrFP=QuoteLiberalPath(FldrFP)
	//access raw data waves
	setdatafolder $FldrFP
	wave /Z TimeElapsedEff=$ksSP2TimeElapsedEff
	wave /Z/d ConfigFileID=$ksSP2correspConfigfileID
	//check whether it is a raw data folder
	variable isOK=0
	if ( waveexists(TimeElapsedEff) && waveexists(ConfigFileID) )
		isOK=1
	endif
	//finish procedure
	setdatafolder $savedDF
	return isOK
end


Function SP2_check_IsPBPfldr(FldrFP)
	//This function checks whether FldrFP is an SP2 PBP data folder
	//return value:	1, if it is an SP2 PBP data folder
	//				0, if it is not an SP2 PBP data folder
	//martin.gysel@psi.ch; 10/09/2010
	string FldrFP		//full path to folder to be checked

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	FldrFP=QuoteLiberalPath(FldrFP)
	//try to access pbp data waves
	setdatafolder $FldrFP
	variable nChan, index
	string currPrefix, PrefixList
		//test for incandescence channels
		PrefixList=SP2_ChanListIncandOnly()
		nChan=itemsinlist(PrefixList)
		for (index=0; index<nChan; index+=1)
			currPrefix=stringfromlist(index, PrefixList)
			wave /Z PeakHt=$currPrefix+ksSP2PBPtracefitPeakHt
			if (waveexists(PeakHt))
				setdatafolder $savedDF
				return 1	
			endif
		endfor
		//test for scattering channels
		PrefixList=SP2_ChanListScattOnly()
		nChan=itemsinlist(PrefixList)
		for (index=0; index<nChan; index+=1)
			currPrefix=stringfromlist(index, PrefixList)
			wave /Z PeakHt=$currPrefix+ksSP2PBPscattGausspeakHeight
			if (waveexists(PeakHt))
				setdatafolder $savedDF
				return 1	
			endif
		endfor
		//test for split detector channels
		PrefixList=SP2_ChanListSplitOnly()
		nChan=itemsinlist(PrefixList)
		for (index=0; index<nChan; index+=1)
			currPrefix=stringfromlist(index, PrefixList)
			wave PeakHt=$currPrefix+ksSP2PBPsplitNegPeakHt
			if (waveexists(PeakHt))
				setdatafolder $savedDF
				return 1	
			endif
		endfor
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2_LEOverificationAndSizing(ctrlname, [pbpfldrfp, SlopeResetBits, CalFactResetBits, MainPostProcMode, StatsMode, PercMode, PrintInfo, GraphMode, negMode]) : ButtonControl
	//Post processing of LEO-fit trace analysis results (scattering and split detector channels).
	//return value: 0; not used
	//martin.gysel@psi.ch;	25/05/2009, 18/05/2010, 19/05/2010, 25/05/2010, 26/05/2010, 11/06/2010, 12/08/2010, 13/08/2010
	//						15/08/2010, 16/08/2010, 09/09/2010, 10/09/2010, 11/09/2010, 12/09/2010, 16/09/2010, 28/09/2010
	//						13/10/2010, 07/04/2011, 20/12/2011, 22/12/2011, 23/12/2011, 13/02/2011
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable SlopeResetBits	//0:			all previous slope fudge factors are maintained if already available (recalculated otherwise)
							//true bits:	the slope fudge factor of the corresponding scattering channel is automatically recalculated
							//			e.g. SlopeResetBits=17 (kSP2chanbitSCHG+kSP2chanbitSCLG) => reset for SCHG and SCLG channels
							//0: previous slope fudge factor is maintained if available (recalculated otherwise)
							//default: use panel settings
	variable CalFactResetBits	//0:			previous calibration factors are maintained for all PSD channels if available (recalculated otherwise)
							//true bits:	the calibration factor of the corresponding PSD detector channel is automatically recalculated
							//			e.g. CalFactResetBits=136 (kSP2chanbitSPHG+kSP2chanbitSPLG) => reset for SPHG and SPLG channels
							//default: use panel settings
	variable MainPostProcMode	//1 (default):	run main LEO post processing
								//0:			do not run main LEO post processing
	variable StatsMode	//1:	run statistics automatically
						//0:	do not run statistics
						//default: use panel setting
	variable negMode	// changes handling of 'negative' coatings (== scattering less than predicted for bare core).
						//0: a BC core smaller than predicted from the incandescent signal is assigned [pre-v4111]
						//1: the underprediction is converted to an overprediction for Mie lookup 
						// Mode 1 thus considers the underprediction to be due to noise and allows the noise response to be an even function.
						//
	variable PercMode	//1:	median only
						//0:	all percentiles
						//default: use panel setting
						//note: not used if "StatsMode=0"
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	CreateFoldersOfFullPath(LeoBeamCalibSubFldrFP, 0)
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	if (paramisdefault(StatsMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar LEOfitStatsRunCB=$ksSP2leoFitStatsRunCB
		StatsMode=LEOfitStatsRunCB
	endif
	if (paramisdefault(negMode)) // v4111
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		NVAR /Z coatingNegMode= $ksSP2LEOnegCoatingAsNoise
		if (!NVAR_Exists(coatingNegMode))
			SP2_postErrorMsg("Negative coatings as noise variable not found -- creating it and setting to zero. MAY NOT BE APPLIED -- DUPLICATE THE CHECKBOX (this shouldnt happen. toolkit version recently upgraded?).") 
			variable/G $ksSP2LEOnegCoatingAsNoise= 0
			NVAR coatingNegMode= $ksSP2LEOnegCoatingAsNoise
		endif
		negMode= coatingNegMode
	endif
	if (paramisdefault(PercMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar LEOfitStatsMedianCB=$ksSP2leoFitStatsMedianCB
		PercMode=LEOfitStatsMedianCB
	endif
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(SlopeResetBits))
		//use panel setting
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitSlopeResetSCHGCB=$ksSP2SCHGprefix+ksSP2leoFitSlopeFudgeResetCB
		Nvar LEOfitSlopeResetSCLGCB=$ksSP2SCLGprefix+ksSP2leoFitSlopeFudgeResetCB
		SlopeResetBits=LEOfitSlopeResetSCHGCB*kSP2chanbitSCHG+LEOfitSlopeResetSCLGCB*kSP2chanbitSCLG
	endif
	if (paramisdefault(CalFactResetBits))
		//use panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitCalFactResetSPHGCB=$ksSP2SPHGprefix+ksSP2leoFitSplitCalResetCB
		Nvar LEOfitCalFactResetSPLGCB=$ksSP2SPLGprefix+ksSP2leoFitSplitCalResetCB
		CalFactResetBits=LEOfitCalFactResetSPHGCB*kSP2chanbitSPHG+LEOfitCalFactResetSPLGCB*kSP2chanbitSPLG
	endif
	if (paramisdefault(MainPostProcMode))
		MainPostProcMode=1
	endif
	//prepare command
	string cmd=""
	cmd+=currproc+"(\""
	cmd+=ctrlname+"\", "
	cmd+="pbpfldrfp=\""+pbpfldrfp+"\", "
	cmd+="SlopeResetBits="+num2str(SlopeResetBits)+", "
	cmd+="CalFactResetBits="+num2str(CalFactResetBits)+", "
	cmd+="MainPostProcMode="+num2str(MainPostProcMode)+", "
	cmd+="PercMode="+num2str(PercMode)+", "
	cmd+="StatsMode="+num2str(StatsMode)+", "
	cmd+="PrintInfo="+num2str(PrintInfo)+", "
	cmd+="GraphMode="+num2str(GraphMode)+")"
	//proceed only if trace analysis data are available
	if (!DataFolderExists(LeoTraceFitSubFldrFP))
		//no leo-fit trace analysis data are not available => finish this procedure
		print "no LEO-trace fit data available => skipped: "+cmd
		if (datafolderexists(savedDF))
			setdatafolder $savedDF
		endif
		return 0
	endif
	//print command
	if (PrintInfo)
		print cmd
	endif
	//access further panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar Panel_IncandPrefix=$ksSP2leoIncandPrefix
	Svar Panel_LEOrefractIndexPair=$ksSP2leoRefractIndexPair	
	variable LowMassChanBit=SP2chanPrefix2chanProperty(Panel_IncandPrefix, 3)
	string LowMassChanPrefix=SP2chanBit2chanPrefix(LowMassChanBit)
	NVAR SAI_calib_flag= $ksSP2useSAIforScattCalib
	variable SPHG
	//access PBP-postprocessing info string and extract settings
	setdatafolder $pbpfldrfp
	Svar PBPpostProcInfoStr=$ksSP2postProcInfoStr
	string calibfldrfp=StringByKey(ksSP2calibFldrKey, PBPpostProcInfoStr,  ":" , "\r")	
	variable DensityOfBC=str2num(StringByKey(ksSP2bcDensityKey, PBPpostProcInfoStr,  ":" , "\r"))
	//copy PBP-postprocessing info string to trace fit folder
	setdatafolder $LeoTraceFitSubFldrFP
	string /g 	$ksSP2postProcInfoStr=PBPpostProcInfoStr
	//write LEO verification and Sizing info string
	setdatafolder $LeoTraceFitSubFldrFP
	string /g $ksSP2LEOverificSizingInfoStr=""
	Svar LEOverificSizingInfoStr=$ksSP2LEOverificSizingInfoStr			
	LEOverificSizingInfoStr+=ksSP2calibFldrKey+"="+calibfldrfp+"\r"
	LEOverificSizingInfoStr+=ksSP2bcDensityKey+"="+num2str(DensityOfBC)+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOfitIncandPrefixKey+"="+Panel_IncandPrefix+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOrefractIndexPairKey+"="+Panel_LEOrefractIndexPair+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOcalChanPrefixSCHGKey+"="+SP2_LEO_GetRefChanPrefix(ksSP2SCHGprefix)+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOcalChanPrefixSCLGKey+"="+SP2_LEO_GetRefChanPrefix(ksSP2SCLGprefix)+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOcalChanPrefixSPHGKey+"="+SP2_LEO_GetRefChanPrefix(ksSP2SPHGprefix)+"\r"
	LEOverificSizingInfoStr+=ksSP2LEOcalChanPrefixSPLGKey+"="+SP2_LEO_GetRefChanPrefix(ksSP2SPLGprefix)+"\r"
	//access calibration curve for low mass range of BC channel
	setdatafolder $calibfldrfp
	wave IncCalCoefExpanded=$LowMassChanPrefix+ksSP2CalCoefBnam
	variable nSplineSegments=SP2_calibCurveSplineCheck(IncCalCoefExpanded)
	//access raw data waves
	setdatafolder $rawfldrfp
	wave YAGpower=$ksSP2YAGpower
	variable nRows=dimsize(YAGpower,0)
	SP2sampleVolumeWaveCalc(rawfldrfp)
	wave SampleVolume=$ksSP2sampleVolume
	variable TotSampleVolume=SumNaN(SampleVolume)			//in m
	//access PBP waves
	setdatafolder $pbpfldrfp
	wave BCcoreDiamFromPBP=$Panel_IncandPrefix+ksSP2pbpBCdiam	
	wave BCpeakHeightSmallSigChan=$LowMassChanPrefix+ksSP2PBPtracefitPeakHt
	wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut				
	//recalculate BC core diameter for all particles (also those with peak height below selected peak height threshold)
	setdatafolder $LeoTraceFitSubFldrFP
	make /o/n=(nRows) $ksSP2LEOBCcoreDiam=NaN
	wave BCcoreDiam=$ksSP2LEOBCcoreDiam
	note BCcoreDiam, "BC core diameter from "+Panel_IncandPrefix+" PBP peaks, with LOD but not LOQ applied" // jcc v4111
	variable bind
	for (bind=0; bind<nRows; bind+=1)
		if (numtype(BCcoreDiamFromPBP[bind])!=2)
			//use BC core diameter from PBP data
			BCcoreDiam[bind]=BCcoreDiamFromPBP[bind]
		else
			//recalculate BC core diameter
			BCcoreDiam[bind]=SP2peakHt2BCdiam(BCpeakHeightSmallSigChan[bind], IncCalCoefExpanded, DensityOfBC, nSplineSegments)
		endif
	endfor
	BCcoreDiam= ClassificationByMinCut[p]&LowMassChanBit ? NanToZero(BCcoreDiam[p]) : 0 		//set it to zero for purely scattering particles
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2verificationSizing
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=0 tempSlopeFactMeas, tempCalFactMeas
	//various variables and strings
	variable nchans, chanind, currChanBit, MedianSlopeFudgeFactor, MedianPSDcalFact
	string currPrefix, currDescriptLong, currRefChanPrefix
	//SCATTERING CHANNELS
		//define possible scattering channels
		string chanlist=SP2_ChanListScattOnly()
		nchans=itemsinlist(chanlist)
		//loop over all scattering channels
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,chanlist)
			currRefChanPrefix=SP2_LEO_GetRefChanPrefix(currPrefix)
			currChanBit=SP2chanPrefix2chanProperty(currPrefix, 0)
			currDescriptLong=replacestring(";",SP2_ChanListToDescrLongList(currPrefix),"")
			//access trace analysis results (trace fit subfolder)
			setdatafolder $LeoTraceFitSubFldrFP
			wave /Z Scatt_LEOfitPeakHtAllUncorr=$currPrefix+ksSP2LEOfitPeakHtAllUncorrBnam			
			wave /Z Scatt_LEOfitSaturated=$currPrefix+ksSP2PBPsaturated
			variable Scatt_leoAvailable= waveexists(Scatt_LEOfitPeakHtAllUncorr) && waveexists(Scatt_LEOfitSaturated)
			//proceed only if trace analysis data are available
			if (Scatt_leoAvailable)		
				//access PBP waves
				setdatafolder $pbpfldrfp
				wave RefChanPeakHtScatt=$currRefChanPrefix+ksSP2PBPscattGausspeakHeight			
				//access calibration coefficient  -- change in v4111 to support time dependent cal coeff [jcc]
				string SAIfldrFP= SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
				if (SAI_calib_flag && DataFolderExists(SAIfldrFP))
					wave /d ScattCalCoef= SP2_get_SAI_scattCoef_wave(currPrefix[1,4], SAIfldrFP)
				else
					// old code + a hack to expand the single value as a wave
					setdatafolder $calibfldrfp
					wave Panel_CalCoef_Scatt=$currRefChanPrefix+ksSP2CalCoefBnam
					make /free/d/n=(nRows) ScattCalCoef= Panel_CalCoef_Scatt[0]
				endif
				//classify particles by type as required for LEO-fit analysis
				setdatafolder $LeoTraceFitSubFldrFP
				SP2_LEOclassificationWave(pbpfldrfp, Panel_IncandPrefix, currRefChanPrefix, currPrefix)
				wave ClassificationByTypeScatt=$currPrefix+ksSP2pbpClassificationByTypeBN
				//prepare waves in LEO beam and calibration data subfolder
					//measured slope fudge factor
					setdatafolder $LeoBeamCalibSubFldrFP
					make /o/n=(nRows) $currPrefix+ksSP2LEOscattSlopeFudgeFacMeas=NaN
					wave LEOslopeFudgeFactorMeas=$currPrefix+ksSP2LEOscattSlopeFudgeFacMeas							
					note LEOslopeFudgeFactorMeas, "Measured fudge factor for the "+currDescriptLong+" channel to account for deviations from the nominal laser shape at the leading edge of the laser beam;"
					//"calibrated" slope fudge factor for LEO-fit for SCHG channel
					setdatafolder $LeoBeamCalibSubFldrFP
					wave /Z LEOscattSlopeFudgeFactFit=$currPrefix+ksSP2LEOscattSlopeFudgeFacFit
					if (!waveexists(LEOscattSlopeFudgeFactFit) || (SlopeResetBits&currChanBit))
//						SlopeResetBits=SlopeResetBits | currChanBit		//=> force recalculation for this scattering channel
//						make /o/n=(nRows) $currPrefix+ksSP2LEOscattSlopeFudgeFacFit=NaN
						make /o/n=(nRows) $currPrefix+ksSP2LEOscattSlopeFudgeFacFit=1
						wave LEOscattSlopeFudgeFactFit=$currPrefix+ksSP2LEOscattSlopeFudgeFacFit	
						note LEOscattSlopeFudgeFactFit, "Fudge factor used in the LEO-fit analysis of the "+currDescriptLong+" channel to account for deviations of the leading edge of the laser beam from the calibrated beam shape ;"						
					endif
				//prepare waves in trace fit subfolder
				setdatafolder $LeoTraceFitSubFldrFP
				make /o/n=(nRows) $currPrefix+ksSP2LEOfitPeakHtAllBnam=NaN
				wave Scatt_LEOfitPeakHtAll=$currPrefix+ksSP2LEOfitPeakHtAllBnam			
				note Scatt_LEOfitPeakHtAll, currDescriptLong+" channel peak height obtained from LEO fit: all particles;"
				note Scatt_LEOfitPeakHtAll, "Corrected with slope fudge factor;"
				make /o/n=(nRows) $currPrefix+ksSP2LEOfitPeakHtScattBnam=NaN
				wave Scatt_LEOfitPeakHtScatt=$currPrefix+ksSP2LEOfitPeakHtScattBnam			
				note Scatt_LEOfitPeakHtScatt, currDescriptLong+" channel peak height obtained from LEO fit: pure scattering particles only;"
				note Scatt_LEOfitPeakHtScatt, "Corrected with slope fudge factor;"
				note Scatt_LEOfitPeakHtScatt, "Particles with saturated "+currDescriptLong+" signal are filtered;"
				make /o/n=(nRows) $currPrefix+ksSP2LEOoptDiamAllBnam=NaN
				wave Scatt_LEOfitOptDiamAll=$currPrefix+ksSP2LEOoptDiamAllBnam
				note Scatt_LEOfitOptDiamAll, "Optical particle diameter [nm] inferred from LEO-fit to "+currDescriptLong+" channel;"				
				//copy LEO-fit results to particle type specific waves
					//all particle types
					Scatt_LEOfitPeakHtAll=Scatt_LEOfitPeakHtAllUncorr[p]>0 ? Scatt_LEOfitPeakHtAllUncorr[p] : NaN		//restore uncorrected fit results and filter negative peak heights			
					//purely scattering particles (filtered by saturation of LEO-fit and saturation of reference scattering signal)
					Scatt_LEOfitPeakHtScatt= ClassificationByTypeScatt[p]&(64+128+256) ? Scatt_LEOfitPeakHtAll[p] : NaN
				
				//calculate slope fudge factor ***marker text for future searching : SLOPE_FUDGE_FACTOR_CALC
				LEOslopeFudgeFactorMeas= RefChanPeakHtScatt[p]/Scatt_LEOfitPeakHtScatt[p]
				if (SlopeResetBits & currChanBit)
					redimension /n=(nRows) tempSlopeFactMeas
					tempSlopeFactMeas= Scatt_LEOfitPeakHtScatt[p]>=kSP2LEOprepScattCutSlopeFact ? LEOslopeFudgeFactorMeas[p] : NaN
					MedianSlopeFudgeFactor=Percentile_of_ListNaN(tempSlopeFactMeas, 0.5)	//intermediate step to prevent calculation of percentile for each row LEOscattSlopeFudgeFactFit seperately
					LEOscattSlopeFudgeFactFit=MedianSlopeFudgeFactor
				endif
				//apply slope fudge factor to LEO-fit results
				Scatt_LEOfitPeakHtAll*=LEOscattSlopeFudgeFactFit
				Scatt_LEOfitPeakHtScatt*=LEOscattSlopeFudgeFactFit
				//determine optical particle diameter from LEOfitPeakHt
				Scatt_LEOfitOptDiamAll=SP2_LEOPeakHt2DoptCoatedBC(Scatt_LEOfitPeakHtAll, BCcoreDiam[p], YAGpower[p], ScattCalCoef[p], MieDataSubFldrPP=Panel_LEOrefractIndexPair, negMode=negMode) 
				//apply bad data mask (via ClassificationByMinCut)
				Scatt_LEOfitOptDiamAll= ClassificationByMinCut[p]>0 ? Scatt_LEOfitOptDiamAll[p] : NaN				
			endif
		endfor	
	//POSITION SENSITIVE DETECTOR CHANNELS
		//define possible PSD channels
		string PSDchanList=SP2_ChanListSplitOnly()
		string CurrCalChanDescrLong
		nchans=itemsinlist(PSDchanList)
		//loop over all PSD channels
		string currSplitCalChanPrefix
		for (chanind=0; chanind<nchans; chanind+=1)
			//channel prefix
			currPrefix=stringfromlist(chanind,PSDchanList)
			currSplitCalChanPrefix=SP2_LEO_GetRefChanPrefix(currPrefix)
			currChanBit=SP2chanPrefix2chanProperty(currPrefix, 0)
			currDescriptLong=replacestring(";",SP2_ChanListToDescrLongList(currPrefix),"")
			CurrCalChanDescrLong=replacestring(";",SP2_ChanListToDescrLongList(currSplitCalChanPrefix),"")
			//access trace analysis results (trace fit subfolder)
			setdatafolder $LeoTraceFitSubFldrFP
			wave /Z PSD_LEOfitPeakHtAllUncorr=$currPrefix+ksSP2LEOfitPeakHtAllUncorrBnam			
			wave /Z PSD_LEOfitSaturated=$currPrefix+ksSP2PBPsaturated
			variable PSD_LEOavailable= waveexists(PSD_LEOfitPeakHtAllUncorr) && waveexists(PSD_LEOfitSaturated)
			//proceed only if trace analysis data are available
			if (PSD_LEOavailable)			
				//access panel settings
				setdatafolder $ksSP2PathToToolkitPanelFldr
				//access PBP waves
				setdatafolder $pbpfldrfp
				wave RefScattChanPeakHtForSplit=$currSplitCalChanPrefix+ksSP2PBPscattGausspeakHeight			
				//access calibration coefficient
				setdatafolder $calibfldrfp
				wave Panel_CalCoef_PSD=$currSplitCalChanPrefix+ksSP2CalCoefBnam
			variable PSD_CalCoef= Panel_CalCoef_PSD[0]				
				//classify particles by type as required for LEO-fit analysis
				setdatafolder $LeoTraceFitSubFldrFP
				SP2_LEOclassificationWave(pbpfldrfp, Panel_IncandPrefix, currSplitCalChanPrefix, currPrefix)
				wave ClassificationByTypeSplit=$currPrefix+ksSP2pbpClassificationByTypeBN
				//prepare waves in LEO beam and calibration data subfolder
					//measured calibration factor
					setdatafolder $LeoBeamCalibSubFldrFP
					make /o/n=(nRows) $currPrefix+ksSP2LEOPSDcalFactMeas=NaN
					wave /Z LEOPSDcalFactMeas=$currPrefix+ksSP2LEOPSDcalFactMeas
					note LEOPSDcalFactMeas, "Measured calibration factor of the "+currDescriptLong+" channel;"
					note LEOPSDcalFactMeas, "Calibration done against the "+CurrCalChanDescrLong+" detector;"
					//averaged PSD calibration factor for LEO-fit
					setdatafolder $LeoBeamCalibSubFldrFP
					wave /Z LEOPSDcalFactFit=$currPrefix+ksSP2LEOPSDcalFactFit
					if (!waveexists(LEOPSDcalFactFit) || (CalFactResetBits & currChanBit))
						CalFactResetBits=(CalFactResetBits | currChanBit)		//=> force recalculation for this channel
						make /o/n=(nRows) $currPrefix+ksSP2LEOPSDcalFactFit=NaN
						wave LEOPSDcalFactFit=$currPrefix+ksSP2LEOPSDcalFactFit										
						note LEOPSDcalFactFit, "Averaged calibration factor of the "+currDescriptLong+" channel used in the LEO-fit analysis;"
						note LEOPSDcalFactFit, "Calibration done against the "+CurrCalChanDescrLong+" detector;"
					endif
				//prepare waves in trace fit subfolder
				setdatafolder $LeoTraceFitSubFldrFP
				make /o/n=(nRows) $currPrefix+ksSP2LEOfitPeakHtAllBnam=NaN
				wave PSD_LEOfitPeakHtAll=$currPrefix+ksSP2LEOfitPeakHtAllBnam			
				note PSD_LEOfitPeakHtAll, currDescriptLong+" channel peak height obtained from LEO fit: all particles;"
				note PSD_LEOfitPeakHtAll, "Corrected with absolute calibration coefficient of "+currDescriptLong+" detector;"
				make /o/n=(nRows) $currPrefix+ksSP2LEOfitPeakHtScattBnam=NaN
				wave PSD_LEOfitPeakHtScatt=$currPrefix+ksSP2LEOfitPeakHtScattBnam			
				note PSD_LEOfitPeakHtScatt, currDescriptLong+" channel peak height obtained from LEO fit: pure scattering particles only;"
				note PSD_LEOfitPeakHtScatt, "Corrected with absolute calibration coefficient of "+currDescriptLong+" detector;"
				note PSD_LEOfitPeakHtScatt, "Particles with saturated "+CurrCalChanDescrLong+" signal are filtered;"
				make /o/n=(nRows) $currPrefix+ksSP2LEOoptDiamAllBnam=NaN
				wave PSD_LEOfitOptDiamAll=$currPrefix+ksSP2LEOoptDiamAllBnam
				note PSD_LEOfitOptDiamAll, "Optical particle diameter [nm] inferred from LEO-fit to "+currDescriptLong+" channel;"
				//copy LEO-fit results to particle type specific waves
					//all particle types
					PSD_LEOfitPeakHtAll=PSD_LEOfitPeakHtAllUncorr[p]<0 ? PSD_LEOfitPeakHtAllUncorr[p] : NaN		//restore uncorrected fit results and filter positive peak heights			
					//purely scattering particles  (filtered by saturation of LEO-fit and saturation of reference scattering signal)
					PSD_LEOfitPeakHtScatt= ClassificationByTypeSplit[p]&(64+128+256) ? PSD_LEOfitPeakHtAll[p] : NaN
				//calculate calibration factor for PSD channel
				LEOPSDcalFactMeas=RefScattChanPeakHtForSplit[p]/PSD_LEOfitPeakHtScatt[p]
				if (CalFactResetBits & currChanBit)
					redimension /n=(nRows) tempCalFactMeas
					tempCalFactMeas= (RefScattChanPeakHtForSplit[p]>=kSP2LEOprepScattCutSlopeFact) ? LEOPSDcalFactMeas[p] : NaN
					MedianPSDcalFact=Percentile_of_ListNaN(tempCalFactMeas, 0.5)		//intermediate step to prevent calculation of percentile for each row LEOPSDcalFactFit seperately
					LEOPSDcalFactFit=MedianPSDcalFact
				endif
				//apply PSD calibration factor to LEO-fit results
				PSD_LEOfitPeakHtAll*=LEOPSDcalFactFit
				PSD_LEOfitPeakHtScatt*=LEOPSDcalFactFit
				//determine optical particle diameter from LEOfitPeakHt --- note here CalCoef is a var, not a wave! [v4111]
				PSD_LEOfitOptDiamAll=SP2_LEOPeakHt2DoptCoatedBC(PSD_LEOfitPeakHtAll, BCcoreDiam[p], YAGpower[p], PSD_CalCoef, MieDataSubFldrPP=Panel_LEOrefractIndexPair, negMode=negMode)
				//apply bad data mask (via ClassificationByMinCut)
				PSD_LEOfitOptDiamAll= ClassificationByMinCut[p]>0 ? PSD_LEOfitOptDiamAll[p] : NaN
			endif
		endfor
	//get statistics of LEO-fit performance
	if (StatsMode)
		SP2_LEOperformanceStats("", pbpfldrfp=pbpfldrfp, PercMode=PercMode)
	endif
	//show verification graphs
	if (GraphMode)
		SP2_LEOgr_VerificationAllChan(PBPfldrFP=pbpfldrfp)
	endif
	//run main LEO post processing
	if (MainPostProcMode)
		SP2_LEOpostProcButt("", pbpfldrfp=pbpfldrfp, PrintInfo=PrintInfo, GraphMode=GraphMode)
	endif	
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end





Function SP2_LEOpostProcButt(ctrlname, [pbpfldrfp, MainSubFldrPP, PrintInfo, GraphMode]) : ButtonControl
	//Calculated BC volume fraction, coating thickness, size distributions, etc. for scattering and split detector channel.
	//note: this function follows the function "SP2_LEOverificationAndSizing".
	//return value: 0; not used
	//martin.gysel@psi.ch;	09/09/2010, 10/09/2010, 11/09/2010, 12/09/2010, 13/09/2010, 14/09/2010, 15/09/2010,
	//						16/09/2010, 17/09/2010, 29/09/2010, 13/10/2010, 23/12/2011, 04/01/2012, 05/01/2012
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string MainSubFldrPP		//partial path to subfolder into which the results are written
							//default: use default subfolder name
							//e.g: ":main"
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(MainSubFldrPP))
		//use string constant from toolkit definitions
		MainSubFldrPP=ksSP2LEOmainSubFldrPP
	endif
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	pbpfldrfp=QuoteLiberalPath(pbpfldrfp)			//copy with liberal paths
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	string LeoMainSubFldrFP=leofldrfp+MainSubFldrPP
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	CreateFoldersOfFullPath(LeoMainSubFldrFP, 0)
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	//print command
	if (PrintInfo)
		string cmd=""
		cmd+="SP2_LEOpostProcButt(\""
		cmd+=ctrlname+"\", "
		cmd+="pbpfldrfp=\""+pbpfldrfp+"\", "
		cmd+="MainSubFldrPP=\""+MainSubFldrPP+"\", "
		cmd+="GraphMode="+num2str(GraphMode)+")"
		print cmd
	endif
	//access further panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LEOlimitBCdiamCB=$ksSP2leoLimitBCdiamCB
	Nvar LEOlimitOptdiamCB=$ksSP2leoLimitOptDiamCB
	Nvar LEOdiamRangeMinSV=$ksSP2diamRangeMinSV
	Nvar LEOnumbSizeBinsSV=$ksSP2leoNumbSizeBinsSV
	Nvar LEOdiamRangeMaxSV=$ksSP2diamRangeMaxSV
	Nvar LEOnBinsBCvolFracHistSV=$ksSP2nBinsBCVolFracHistSV
	Nvar LEOnBinsCoatThicknHistSV=$ksSP2nBinsBCCoatThicknHistSV
	Nvar LEOnBinsDelayHistSV=$ksSP2nBinsDelayHistSV
	Nvar LEOfitMinPeakHtSCHG=$ksSP2SCHGprefix+ksSP2leoMinPeakHeightSV
	Nvar LEOfitMinPeakHtSCLG=$ksSP2SCLGprefix+ksSP2leoMinPeakHeightSV
	Nvar LEOfitMinPeakHtSPHG=$ksSP2SPHGprefix+ksSP2leoMinPeakHeightSV
	Nvar LEOfitMinPeakHtSPLG=$ksSP2SPLGprefix+ksSP2leoMinPeakHeightSV
	if (LEOlimitBCdiamCB && LEOlimitOptdiamCB)
			setdatafolder $savedDF
			message="Forbidden combination of panel settings encountered in procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
	endif
	//copy info strings from trace analysis folder
		//access
		setdatafolder $pbpfldrfp
		Svar PBPpostProcInfoStr=$ksSP2postProcInfoStr
		setdatafolder $LeoTraceFitSubFldrFP
		Svar /Z LEOtraceFitInfoStr=$ksSP2LEOtraceFitInfoStr			
		Svar /Z LEOverificationSizingInfoStr=$ksSP2LEOverificSizingInfoStr			
		//duplicate
		setdatafolder $LeoMainSubFldrFP
		string /g $ksSP2postProcInfoStr=PBPpostProcInfoStr
		if (SVAR_Exists(LEOtraceFitInfoStr))		
			string /g $ksSP2LEOtraceFitInfoStr=LEOtraceFitInfoStr
		endif
		if (SVAR_Exists(LEOverificationSizingInfoStr))
			string /g $ksSP2LEOverificSizingInfoStr=LEOverificationSizingInfoStr
		endif
	//write main post processing info string
	string /g $ksSP2LEOmainPostProcInfoStr=""
	Svar LEOmainPostProcInfoStr=$ksSP2LEOmainPostProcInfoStr			
	LEOmainPostProcInfoStr+=ksSP2LEOnumbSizeBinsKey+"="+num2str(LEOnumbSizeBinsSV)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOlimitBCdiamKey+"="+num2str(LEOlimitBCdiamCB)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOlimitOptDiamKey+"="+num2str(LEOlimitOptdiamCB)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOdiamRangeMinKey+"="+num2str(LEOdiamRangeMinSV)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOdiamRangeMaxKey+"="+num2str(LEOdiamRangeMaxSV)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOminPeakHtSCHGKey+"="+num2str(LEOfitMinPeakHtSCHG)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOminPeakHtSCLGKey+"="+num2str(LEOfitMinPeakHtSCLG)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOminPeakHtSPHGKey+"="+num2str(LEOfitMinPeakHtSPHG)+"\r"
	LEOmainPostProcInfoStr+=ksSP2LEOminPeakHtSPLGKey+"="+num2str(LEOfitMinPeakHtSPLG)+"\r"
	//access raw data waves
	setdatafolder $rawfldrfp
	SP2sampleVolumeWaveCalc(rawfldrfp)
	wave SampleVolume=$ksSP2sampleVolume
	variable TotSampleVolume=SumNaN(SampleVolume)			//in m
	variable nRows=numpnts(SampleVolume)
	//access PBP waves
	setdatafolder $pbpfldrfp
	wave DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B			
	//access waves from LEO trace fit subfolder
	setdatafolder $LeoTraceFitSubFldrFP
	wave BCcoreDiam=$ksSP2LEOBCcoreDiam
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2LEOmainPostProc
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=(nRows) MainMask, TypeMask
	make /o/n=(nRows) LEOfitOptDiamFiltered, LogLEOfitOptDiamFiltered
	make /o/n=(nRows) LEOfitBCcoreDiamFiltered, logLEOfitBCcoreDiamFiltered
	make /o/n=(nRows) DelayTimeScattMax2BroadFiltered
	make /o/n=(LEOnumbSizeBinsSV) OverlapMask
	//loop over LEO-channels, access waves, prepare result waves and analyse results
	string LEOchanList=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nLEOchans=itemsinlist(LEOchanList)
	variable cind, logDelta, typeBits
	string CurrPrefix
	variable logDmin, logDmax	
	for (cind=0; cind<nLEOchans; cind+=1)
		CurrPrefix=stringfromlist(cind, LEOchanList)
		//access panel settings
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar LEOfitMinPeakHt=$CurrPrefix+ksSP2leoMinPeakHeightSV
		//access waves LEO trace fit results
		setdatafolder $LeoTraceFitSubFldrFP
		wave /Z ClassificationByType=$CurrPrefix+ksSP2pbpClassificationByTypeBN
		wave /Z LEOfitPeakHtAll=$CurrPrefix+ksSP2LEOfitPeakHtAllBnam			
		wave /Z LEOfitOptDiamAll=$CurrPrefix+ksSP2LEOoptDiamAllBnam
		variable CurrLEOchanAvailable= waveexists(LEOfitOptDiamAll)
		if (CurrLEOchanAvailable)		
			//prepare new result waves
				setdatafolder $LeoMainSubFldrFP
				//BC volume concentration
				make /o/n=(nRows) $CurrPrefix+ksSP2LEObcVolumeFraction=NaN
				wave BCvolumeFraction=$CurrPrefix+ksSP2LEObcVolumeFraction			
				note BCvolumeFraction, "BC volume fraction of BC containing particles within selected diameter range inferred from LEO-fit analysis;"
				note BCvolumeFraction, "note: values >1 mean that the BCcore mass equivalent diameter is bigger than the optical diameter;"
				make /o/n=(LEOnBinsBCvolFracHistSV) $CurrPrefix+ksSP2LEObcVolFractHist=NaN
				wave BCvolumeFractHist=$CurrPrefix+ksSP2LEObcVolFractHist
				note BCvolumeFractHist, "histogram of BC volume fraction values (from wave "+nameofwave(BCvolumeFraction)+") of BC containing particles within selected diameter range;"
				note BCvolumeFractHist, "note: values >1 mean that the BCcore mass equivalent diameter is bigger than the optical diameter;"
				//coating thickness of BC
				make /o/n=(nRows) $CurrPrefix+ksSP2LEObcCoatingThickness=NaN
				wave BCcoatingThickness=$CurrPrefix+ksSP2LEObcCoatingThickness			
				note BCcoatingThickness, "Coating thickness [nm] of BC particle inferred from LEO-fit analysis of high gain scattering channel;"
				note BCcoatingThickness, "D_overall = D_core + 2 * CoatingThickness;"
				make /o/n=(LEOnBinsCoatThicknHistSV) $CurrPrefix+ksSP2LEObcCoatThicknHist=NaN
				wave BCcoatingThicknHist=$CurrPrefix+ksSP2LEObcCoatThicknHist
				note BCcoatingThicknHist, "histogram of coating thickness values (from wave "+nameofwave(BCcoatingThickness)+") of BC containing particles within selected diameter range;"
				note BCcoatingThicknHist, "D_overall = D_core + 2 * CoatingThickness;"
				//total number concentration of different particle types
				make /t/o/n=7 $CurrPrefix+ksSP2LEOTotalNumbConcTableCol1=""		
				wave /t totalNumbConcTableCol1=$CurrPrefix+ksSP2LEOTotalNumbConcTableCol1
				make /o/n=7 $CurrPrefix+ksSP2LEOTotalNumbConcTableCol2=NaN		
				wave totalNumbConcTableCol2=$CurrPrefix+ksSP2LEOTotalNumbConcTableCol2
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcBC=NaN
				wave TotalNumbConcBC=$CurrPrefix+ksSP2LEOTotalNumbConcBC
				note TotalNumbConcBC, "number concentration [#/cm] of BC particles within selected diameter range with valid incandescence signal (saturated incandescence/LEO signals excluded);"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcBCtiny=NaN
				wave TotalNumbConcBCtiny=$CurrPrefix+ksSP2LEOTotalNumbConcBCtiny
				note TotalNumbConcBCtiny, "number concentration [#/cm] of BC particles within selected diameter range with incandescence signal between minimum cut and selected threshold;"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcBCsatInc=NaN
				wave TotalNumbConcBCsatInc=$CurrPrefix+ksSP2LEOTotalNumbConcBCsatInc
				note TotalNumbConcBCsatInc, "number concentration [#/cm] of BC particles within selected diameter range with saturated incandescence signal (saturated LEO signals excluded);"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcBCsatLEO=NaN
				wave TotalNumbConcBCsatLEO=$CurrPrefix+ksSP2LEOTotalNumbConcBCsatLEO
				note TotalNumbConcBCsatLEO, "number concentration [#/cm] of BC particles within selected diameter range with saturated LEO signal;"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcBCcores=NaN
				wave totalNumbConcBCcores=$CurrPrefix+ksSP2LEOTotalNumbConcBCcores
				note totalNumbConcBCcores, "number concentration [#/cm] of detected BC cores within selected BC core or optical diameter range (saturated incandescence/LEO signals excluded);"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcScatt=NaN
				wave TotalNumbConcScatt=$CurrPrefix+ksSP2LEOTotalNumbConcScatt
				note TotalNumbConcScatt, "number concentration [#/cm] of purely scattering particles within selected diameter range (saturated LEO signals excluded);"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcScattTiny=NaN
				wave TotalNumbConcScattTiny=$CurrPrefix+ksSP2LEOTotalNumbConcScattTiny
				note TotalNumbConcScattTiny, "number concentration [#/cm] of purely scattering particles within selected diameter range with scattering signal between minimum cut and selected threshold;"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcScInvalRef=NaN
				wave TotalNumbConcScattInvalRef=$CurrPrefix+ksSP2LEOTotalNumbConcScInvalRef
				note TotalNumbConcScattInvalRef, "number concentration [#/cm] of purely scattering particles within selected diameter range with invalid reference scattering signal (missing or amplitude below minimum cut);"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcScSatRef=NaN
				wave TotalNumbConcScattSatRef=$CurrPrefix+ksSP2LEOTotalNumbConcScSatRef
				note TotalNumbConcScattSatRef, "number concentration [#/cm] of purely scattering particles within selected diameter range with saturated reference scattering signal;"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcScSatLEO=NaN
				wave TotalNumbConcScattSatLEO=$CurrPrefix+ksSP2LEOTotalNumbConcScSatLEO
				note TotalNumbConcScattSatLEO, "number concentration [#/cm] of purely scattering particles within selected diameter range with saturated LEO signal;"
				make /o/n=(1) $CurrPrefix+ksSP2LEOTotalNumbConcAllValid=NaN
				wave totalNumbConcAllValid=$CurrPrefix+ksSP2LEOTotalNumbConcAllValid
				note totalNumbConcAllValid, "number concentration [#/cm] of all valid particles within selected diameter range (saturated LEO/incandescence signals exluded);"
				//size distributions of different particle types
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptdistrDiamMid=NaN
				wave OptDistrDiamMidpt=$CurrPrefix+ksSP2LEOoptdistrDiamMid
				note OptDistrDiamMidpt, "Midpoint diameter [nm] scale for size distributions;"
				make /o/n=(LEOnumbSizeBinsSV+1)	$CurrPrefix+ksSP2LEOoptDistrDiamBdr=NaN
				wave OptDistrDiamBdr=$CurrPrefix+ksSP2LEOoptDistrDiamBdr
				note OptDistrDiamBdr, "Boundary diameter [nm] scale for size distributions;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptDistrDlogDp=NaN
				wave OptDistrDlogDp=$CurrPrefix+ksSP2LEOoptDistrDlogDp			
				note OptDistrDlogDp, "DlogDp values of size distributions;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrBC=0
				wave OptNumbDistrBC=$CurrPrefix+ksSP2LEOoptNumbDistrBC
				note OptNumbDistrBC, "Number size distribution dN/dlogDp [#/cm] of BC particles within selected diameter range with valid incandescence signal (saturated incandescence/LEO signals excluded);"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrBCtiny=0
				wave OptNumbDistrBCtiny=$CurrPrefix+ksSP2LEOoptNumbDistrBCtiny
				note OptNumbDistrBCtiny, "Number size distribution dN/dlogDp [#/cm] of BC particles within selected diameter range with incandescence signal between minimum cut and selected threshold;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrBCsatInc=0
				wave OptNumbDistrBCsatInc=$CurrPrefix+ksSP2LEOoptNumbDistrBCsatInc
				note OptNumbDistrBCsatInc, "Number size distribution dN/dlogDp [#/cm] of BC particles within selected diameter range with saturated incandescence signal (saturated LEO signals excluded);"	
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrBCsatLEO=0
				wave OptNumbDistrBCsatLEO=$CurrPrefix+ksSP2LEOoptNumbDistrBCsatLEO
				note OptNumbDistrBCsatLEO, "Number size distribution dN/dlogDp [#/cm] of BC particles within selected diameter range with saturated LEO signal;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOnumbDistrBCcores=0
				wave NumbDistrBCcores=$CurrPrefix+ksSP2LEOnumbDistrBCcores
				note NumbDistrBCcores, "Number size distribution dN/dlogDp [#/cm] of detected BC cores within selected BC core or optical diameter range;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrScatt=0
				wave OptNumbDistrScatt=$CurrPrefix+ksSP2LEOoptNumbDistrScatt
				note OptNumbDistrScatt, "Number size distribution dN/dlogDp [#/cm] of purely scattering particles within selected diameter range (saturated LEO signals excluded);"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrScattTiny=0
				wave OptNumbDistrScattTiny=$CurrPrefix+ksSP2LEOoptNumbDistrScattTiny
				note OptNumbDistrScattTiny, "Number size distribution dN/dlogDp [#/cm] of purely scattering particles within selected diameter range with scattering signal between minimum cut and selected threshold;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrScInvalRef=0
				wave OptNumbDistrScattInvalRef=$CurrPrefix+ksSP2LEOoptNumbDistrScInvalRef
				note OptNumbDistrScattInvalRef, "Number size distribution dN/dlogDp [#/cm] of purely scattering particles within selected diameter range with invalid reference scattering signal (missing or amplitude below minimum cut);"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrScattSatRef=0
				wave OptNumbDistrScattSatRef=$CurrPrefix+ksSP2LEOoptNumbDistrScattSatRef
				note OptNumbDistrScattSatRef, "Number size distribution dN/dlogDp [#/cm] of purely scattering particles within selected diameter range with saturated reference scattering signal;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrScattSatLEO=0
				wave OptNumbDistrScattSatLEO=$CurrPrefix+ksSP2LEOoptNumbDistrScattSatLEO
				note OptNumbDistrScattSatLEO, "Number size distribution dN/dlogDp [#/cm] of purely scattering particles within selected diameter range with saturated LEO signal;"
				make /o/n=(LEOnumbSizeBinsSV)	$CurrPrefix+ksSP2LEOoptNumbDistrAllValid=0
				wave OptNumbDistrAllValid=$CurrPrefix+ksSP2LEOoptNumbDistrAllValid
				note OptNumbDistrAllValid, "Number size distribution dN/dlogDp [#/cm] of all valid particles within selected diameter range (saturated LEO/incandescence signals exluded);"
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrBC
				wave OptNumFracDistrBC=$CurrPrefix+ksSP2LEOoptNFDistrBC
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrBCtiny
				wave OptNumFracDistrBCtiny=$CurrPrefix+ksSP2LEOoptNFDistrBCtiny
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrBCsatInc
				wave OptNumFracDistrBCsatInc=$CurrPrefix+ksSP2LEOoptNFDistrBCsatInc
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrBCsatLEO
				wave OptNumFracDistrBCsatLEO=$CurrPrefix+ksSP2LEOoptNFDistrBCsatLEO
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrScatt
				wave OptNumFracDistrScatt=$CurrPrefix+ksSP2LEOoptNFDistrScatt
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrScattTiny
				wave OptNumFracDistrScattTiny=$CurrPrefix+ksSP2LEOoptNFDistrScattTiny
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrScattInvalRef
				wave OptNumFracDistrScattInvalRef=$CurrPrefix+ksSP2LEOoptNFDistrScattInvalRef
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrScattSatRef
				wave OptNumFracDistrScattSatRef=$CurrPrefix+ksSP2LEOoptNFDistrScattSatRef
				make /o/n=(LEOnumbSizeBinsSV) $CurrPrefix+ksSP2LEOoptNFDistrScattSatLEO
				wave OptNumFracDistrScattSatLEO=$CurrPrefix+ksSP2LEOoptNFDistrScattSatLEO
				//histogram of delay times
				make /o/n=(LEOnBinsDelayHistSV) $CurrPrefix+ksSP2LEOdelayTimeHist=NaN
				wave DelayTimeHist=$CurrPrefix+ksSP2LEOdelayTimeHist
				note DelayTimeHist, "histogram of delay times between scattering and incandescence peak (from wave "+getwavesdatafolder(DelayTimeScattMax2Broad,4)+";)"
			//analyse LEO-fit optical diameter data
				//prepare main data filter mask
					MainMask=numtype(LEOfitOptDiamAll[p])==0
					//filter by minimum reconstructed LEO-peak height
					MainMask= LEOfitPeakHtAll[p]>=LEOfitMinPeakHt ? MainMask[p] : NaN
					//filter by BC core diameter
					if (LEOlimitBCdiamCB)
						MainMask= (BCcoreDiam[p]>=LEOdiamRangeMinSV) && (BCcoreDiam[p]<=LEOdiamRangeMaxSV) ? MainMask[p] : NaN
					endif
					//filter by optical diameter
					if (LEOlimitOptdiamCB)
						MainMask= (LEOfitOptDiamAll[p]>=LEOdiamRangeMinSV) && (LEOfitOptDiamAll[p]<=LEOdiamRangeMaxSV) ? MainMask[p] : NaN
					endif	
				//calculate total number concentrations, size distributions and further properties of different particle types
					//set size distribution scale
					logDmin=log(kSP2LEOsizeDistrDmin)
					logDmax=log(kSP2LEOsizeDistrDmax)
					setscale /i x, logDmin, logDmax, OptDistrDiamMidpt						//midpoint diameters
					OptDistrDiamMidpt=10^x
					BinCentresToBoundariesLog(OptDistrDiamMidpt, OptDistrDiamBdr)			//bin boundaries
					OptDistrDlogDp=log(OptDistrDiamBdr[p+1])-log(OptDistrDiamBdr[p])		//calculate deltaLogDp
					logDelta=DimDelta(OptDistrDiamMidpt, 0)
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrAllValid
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrBC
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrBCtiny
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrBCsatInc
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrBCsatLEO
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrScatt
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrScattTiny
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrScattInvalRef
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrScattSatRef
					setscale /P x, logDmin-0.5*logDelta, logDelta, OptNumbDistrScattSatLEO
					setscale /P x, logDmin-0.5*logDelta, logDelta, NumbDistrBCcores
						//note DimStart in above line: x-scaling must be shifted to the left because "Histogram /C/B=2..." shifts x-scale by half a bin width to the right
						
						
					//all valid BC particles (tiny BC particles included; saturated BC excluded; saturated LEO signal excluded)
						//particle type specific mask
						typeBits=1+2
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll			// here LEOfitOptDiam all is the entire particle
						LEOfitBCcoreDiamFiltered=TypeMask*MainMask*ZeroToNaN(BCcoreDiam)	// here BCcoreDiam is D_MEV from the incanescence channel
						DelayTimeScattMax2BroadFiltered=TypeMask*MainMask*DelayTimeScattMax2Broad
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						logLEOfitBCcoreDiamFiltered=log(LEOfitBCcoreDiamFiltered)					
						//total number concentration
						TotalNumbConcBC=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution

						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrBC		//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrBC/=OptDistrDlogDp								//normalise with deltaLogD
						OptNumbDistrBC=OptNumbDistrBC/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
						//specific properties of valid BC particles
							//total number concentration and size distribution of BC cores
							totalNumbConcBCcores=NumberOfNonNaNPtsinWave(LEOfitBCcoreDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
							Histogram/C/B=2 logLEOfitBCcoreDiamFiltered,NumbDistrBCcores			//histogram of log(D_BCcore) values as first step towards dN/dlogDp
							NumbDistrBCcores/=OptDistrDlogDp									//normalise with deltaLogD
							NumbDistrBCcores=NumbDistrBCcores/TotSampleVolume*1e-6			//unit conversion factor: 1/m => 1/cm
							//BC volume fraction
							BCvolumeFraction=(LEOfitBCcoreDiamFiltered/LEOfitOptDiamFiltered)^3
							//coating thickness (COATING_THICKNESS_CALC)
							BCcoatingThickness=0.5*(LEOfitOptDiamFiltered[p]-LEOfitBCcoreDiamFiltered[p])
							//histogram of delay time data
							setscale /i x, kSP2LEOdelayHistDTmin,kSP2LEOdelayHistDTmax, DelayTimeHist
							Histogram/C/B=2 DelayTimeScattMax2BroadFiltered, DelayTimeHist			
							if (kSP2LEOdelayHistNormalize)
								variable DelayNormfact=numpnts(DelayTimeHist)
								DelayNormfact=(DelayNormfact+1)/DelayNormfact		//account for bin boundaries in area calculation
								DelayNormfact*=area(DelayTimeHist)					//account for bin boundaries in area calculation
								DelayTimeHist/=DelayNormfact
							endif
							
							
					//tiny BC particles only
						//particle type specific mask
						typeBits=2
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcBCtiny=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrBCtiny			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrBCtiny/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrBCtiny=OptNumbDistrBCtiny/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//BC particles with saturated BC signal (LEO signal not saturated)
						//particle type specific mask
						typeBits=4
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcBCsatInc=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrBCsatInc			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrBCsatInc/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrBCsatInc=OptNumbDistrBCsatInc/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//BC particles with saturated LEO signal
						//particle type specific mask
						typeBits=8
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcBCsatLEO=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrBCsatLEO			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrBCsatLEO/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrBCsatLEO=OptNumbDistrBCsatLEO/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//all valid purely scattering particles (saturation in LEO range excluded; tiny, saturated or invalid reference scattering amplitude included)
						//particle type specific mask
						typeBits=64+128+256+512
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcScatt=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrScatt		//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrScatt/=OptDistrDlogDp								//normalise with deltaLogD
						OptNumbDistrScatt=OptNumbDistrScatt/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//tiny purely scattering particles
						//particle type specific mask
						typeBits=128
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcScattTiny=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrScattTiny			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrScattTiny/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrScattTiny=OptNumbDistrScattTiny/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//purely scattering particles with invalid reference scattering peak height
						//particle type specific mask
						typeBits=256
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcScattInvalRef=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrScattInvalRef			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrScattInvalRef/=OptDistrDlogDp										//normalise with deltaLogD
						OptNumbDistrScattInvalRef=OptNumbDistrScattInvalRef/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
						
					//purely scattering particles with saturated reference scattering signal
						//particle type specific mask
						typeBits=512
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcScattSatRef=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrScattSatRef			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrScattSatRef/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrScattSatRef=OptNumbDistrScattSatRef/TotSampleVolume*1e-6	//unit conversion factor: 1/m => 1/cm
						
						
					//purely scattering particles with saturated LEO signal
						//particle type specific mask
						typeBits=1024
						TypeMask= ClassificationByType[p]&typeBits ? 1 : NaN
						//filtering data
						LEOfitOptDiamFiltered=TypeMask*MainMask*LEOfitOptDiamAll
						//working with log-scales
						LogLEOfitOptDiamFiltered=log(LEOfitOptDiamFiltered)
						//total number concentration
						TotalNumbConcScattSatLEO=NumberOfNonNaNPtsinWave(LEOfitOptDiamFiltered)/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm			
						//number size distribution
						Histogram/C/B=2 LogLEOfitOptDiamFiltered,OptNumbDistrScattSatLEO			//histogram of logDp values as first step towards dN/dlogDp
						OptNumbDistrScattSatLEO/=OptDistrDlogDp									//normalise with deltaLogD
						OptNumbDistrScattSatLEO=OptNumbDistrScattSatLEO/TotSampleVolume*1e-6		//unit conversion factor: 1/m => 1/cm
						
					//all valid particles (incandescence and LEO signals not saturated)
						totalNumbConcAllValid=TotalNumbConcScatt[0]+TotalNumbConcBC[0]
						OptNumbDistrAllValid=OptNumbDistrScatt+OptNumbDistrBC
						
					//correct first and last bin of size distributions for overlap with diameter range and remove zero tails from size distributions
						//fractional overlap of size distribution bins with selected diameter range
						variable firstind, lastind, firstOL=1, lastOL=1
						OverlapMask=1
						firstind=floor(BinarySearchInterp(OptDistrDiamBdr, LEOdiamRangeMinSV))
						if(firstind>=0)
							firstOL=(log(OptDistrDiamBdr[firstind+1])-log(LEOdiamRangeMinSV))/(log(OptDistrDiamBdr[firstind+1])-log(OptDistrDiamBdr[firstind]))
							firstOL= firstOL<0.5 ? NaN : firstOL
							OverlapMask= p>firstind ? OverlapMask[p] : NaN
							OverlapMask[firstind]=1/firstOL
						endif										
						lastind=ceil(BinarySearchInterp(OptDistrDiamBdr, LEOdiamRangeMaxSV))
						if(lastind>=0)
							lastOL=(log(LEOdiamRangeMaxSV)-log(OptDistrDiamBdr[lastind-1]))/(log(OptDistrDiamBdr[lastind])-log(OptDistrDiamBdr[lastind-1]))
							lastOL= lastOL<0.5 ? NaN : lastOL
							OverlapMask= p<lastind ? OverlapMask[p] : NaN
							OverlapMask[lastind-1]=1/lastOL
						endif						
						//filter by BC core diameter
						if (LEOlimitBCdiamCB)
							NumbDistrBCcores*=OverlapMask
						endif
						//filter by optical diameter
						if (LEOlimitOptdiamCB)
							OptNumbDistrBC*=OverlapMask
							OptNumbDistrBCtiny*=OverlapMask
							OptNumbDistrBCsatInc*=OverlapMask
							OptNumbDistrBCsatLEO*=OverlapMask
							OptNumbDistrScatt*=OverlapMask
							OptNumbDistrScattTiny*=OverlapMask
							OptNumbDistrScattInvalRef*=OverlapMask
							OptNumbDistrScattSatRef*=OverlapMask
							OptNumbDistrScattSatLEO*=OverlapMask
							OptNumbDistrAllValid*=OverlapMask
						endif
					//number fraction size distribution
					OptNumFracDistrBC=OptNumbDistrBC/OptNumbDistrAllValid
					OptNumFracDistrBCtiny=OptNumbDistrBCtiny/OptNumbDistrAllValid
					OptNumFracDistrBCsatInc=OptNumbDistrBCsatInc/OptNumbDistrAllValid
					OptNumFracDistrBCsatLEO=OptNumbDistrBCsatLEO/OptNumbDistrAllValid
					OptNumFracDistrScatt=OptNumbDistrScatt/OptNumbDistrAllValid
					OptNumFracDistrScattTiny=OptNumbDistrScattTiny/OptNumbDistrAllValid
					OptNumFracDistrScattInvalRef=OptNumbDistrScattInvalRef/OptNumbDistrAllValid
					OptNumFracDistrScattSatRef=OptNumbDistrScattSatRef/OptNumbDistrAllValid
					OptNumFracDistrScattSatLEO=OptNumbDistrScattSatLEO/OptNumbDistrAllValid
					//various histograms
						//BC volume fraction
						setscale /i x, kSP2LEOvolFractHistMin,kSP2LEOvolFractHistMax, BCvolumeFractHist
						Histogram/C/B=2 BCvolumeFraction, BCvolumeFractHist
						if (kSP2LEOvolFractHistNormalize)
							variable VFnormfact=numpnts(BCvolumeFractHist)
							VFnormfact=(VFnormfact+1)/VFnormfact		//account for bin boundaries in area calculation
							VFnormfact*=area(BCvolumeFractHist)			//account for bin boundaries in area calculation
							BCvolumeFractHist/=VFnormfact
						endif
						//BC coating thickness
						setscale /i x, kSP2LEOcoatThickHistMin,kSP2LEOcoatThickHistMax, BCcoatingThicknHist
						Histogram/C/B=2 BCcoatingThickness, BCcoatingThicknHist
						if (kSP2LEOcoatThickHistNormalize)
							variable CTnormfact=numpnts(BCcoatingThicknHist)
							CTnormfact=(CTnormfact+1)/CTnormfact		//account for bin boundaries in area calculation
							CTnormfact*=area(BCcoatingThicknHist)		//account for bin boundaries in area calculation
							BCcoatingThicknHist/=CTnormfact
						endif
					//summary table
					totalNumbConcTableCol1[0]="Number conc. of all particles (incl. saturation):"
					totalNumbConcTableCol1[1]="Number conc. of valid particles:"
					totalNumbConcTableCol1[2]="Number conc. of valid BC cores:"
					totalNumbConcTableCol1[3]="Number conc. of valid BC particles:"
					totalNumbConcTableCol1[4]="Number conc. of 'tiny BC' particles:"
					totalNumbConcTableCol1[5]="Number conc. of 'BC particles with saturated LEO signal':"
					totalNumbConcTableCol1[6]="Number conc. of BC particles with 'saturated incandescence':"
					totalNumbConcTableCol1[7]="Number conc. of 'purely scattering' particles:"
					totalNumbConcTableCol1[8]="Number conc. of 'tiny purely scattering' particles:"
					totalNumbConcTableCol1[9]="Number conc. of 'purely scattering with saturated LEO signal':"
					totalNumbConcTableCol1[10]="Number conc. of 'purely scattering without standard optical sizing':"
					totalNumbConcTableCol2[0]=totalNumbConcAllValid[0]+TotalNumbConcBCsatInc[0]+TotalNumbConcBCsatLEO[0]+TotalNumbConcScattSatLEO[0]
					totalNumbConcTableCol2[1]=totalNumbConcAllValid[0]
					totalNumbConcTableCol2[2]=totalNumbConcBCcores[0]
					totalNumbConcTableCol2[3]=TotalNumbConcBC[0]
					totalNumbConcTableCol2[4]=TotalNumbConcBCtiny[0]
					totalNumbConcTableCol2[5]=TotalNumbConcBCsatLEO[0]
					totalNumbConcTableCol2[6]=TotalNumbConcBCsatInc[0]
					totalNumbConcTableCol2[7]=TotalNumbConcScatt[0]
					totalNumbConcTableCol2[8]=TotalNumbConcScattTiny[0]
					totalNumbConcTableCol2[9]=TotalNumbConcScattSatLEO[0]
					totalNumbConcTableCol2[10]=TotalNumbConcScattInvalRef[0]
		endif
	endfor
	//show graphs and tables
	if (GraphMode)
		SP2_LEOgr_BCvolFractHistogram(LeoMainSubFldrFP=LeoMainSubFldrFP)
		SP2_LEOgr_BCcoatThicknHistogram(LeoMainSubFldrFP=LeoMainSubFldrFP)
		SP2_LEOgr_DelayTimeHistogram(LeoMainSubFldrFP=LeoMainSubFldrFP)
		SP2_LEOgr_OptSizeDistrButt(LeoMainSubFldrFP=LeoMainSubFldrFP)
		SP2_LEOgr_OptNumbFracSizeDiBtt(LeoMainSubFldrFP=LeoMainSubFldrFP)
		SP2_LEOtbl_NumbConcByTypeBtt(LeoMainSubFldrFP=LeoMainSubFldrFP)
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end


Function SP2_ConcTimeSeriesExtractor(ctrlname, [pbpfldrfp, IntSec, StartTime, EndTime, Offset, GraphMode]) : ButtonControl
	//This function determines the time series of particle concentration from PBP data
	//return value: 0; not used
	//note: the lower cut-off values for each detector are taken into account by referring to the classification wave.
	//martin.gysel@psi.ch;	05/06/2009, 09/06/2009,11/06/2009, 03/11/2009, 30/01/2010, 29/04/2010, 03/05/2010, 11/05/2010, 24/06/2010,
	//						11/08/2010, 17/09/2010, 13/10/2010;
	//joel.corbin@psih.ch; 2015-06-04 added support for automatic iteration of all PBP folders
	
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable IntSec		//interval [s] of concentration time series
						//default: use panel value
						//use IntSec=0 to extract just one size distribution of all data
						//		=> "StartTime" and "EndTime" are ignored if IntSec=0
						//use IntSec=-1 to extract just one size distribution of all data between "StartTime" and "EndTime"
						//note: IntSec is rounded to the nearest integer value
	variable StartTime		//start time stamp (begin of first interval) for concentration time series
						//default: use time stamp of first data point
	variable EndTime		//end time stamp (end of last interval) for concentration time series
						//default: use time stamp of last data point
	variable Offset		//offset [secs] of interval boundary time values relative to 01.01.1904 00:00:00
						//default: determine offset from "StartTime"
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//set defaults
	if (paramisdefault(IntSec))
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Nvar PanelIntSec=$ksSP2concInterval
		IntSec=PanelIntSec
	endif
	IntSec=round(IntSec)
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
// [v4111 jcc] moved some ParamIsDefault checks before datafolder check to allow looping

	if (paramisdefault(pbpfldrfp))
		pbpfldrfp= SP2_getFolder(startingDF=savedDF, type="PBP", includeAll=1)	// jcc / if the user chooses 'all',, this will return a list of all folders
		if (itemsInList(pbpfldrfp) > 1) // jcc / then loop through the chosen folders
			NVAR autoGraphCB= root:SP2toolkit:panel:autoGraphCB
			if (autoGraphCB && itemsInList(pbpfldrfp) > 3)
				DoAlert 1, "Temporarily disable auto-graphing before extracting time series for "+num2str(itemsInList(pbpfldrfp))+" PBP folders?"
				if (V_flag==1)
					GraphMode=0
				endif
			endif
			
			variable i,n=itemsInList(pbpfldrfp)
			if (n>1)
			for (i=0;i<n;i+=1)
				string aPBP= stringFromList(i,pbpfldrfp)					
				if (paramisdefault(Offset)) // jcc -- is default when clicking the button => Normally this will be TRUE
					SP2_ConcTimeSeriesExtractor(ctrlname, pbpfldrfp=aPBP, GraphMode=GraphMode)
				else
					SP2_ConcTimeSeriesExtractor(ctrlname, pbpfldrfp=aPBP, IntSec=IntSec, StartTime=StartTime, EndTime=EndTime, Offset=Offset, GraphMode=GraphMode) 
				endif
			endfor
			setdatafolder $savedDF
			return 1
			endif
		endif
	endif
	
	//update classification wave	(applies thresholds and main data mask)
	SP2_ClassificationWaveCreator(pbpfldrfp)
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string concfldrfp=ChopLastCharacterOff(pbpfldrfp,":")+ksSP2concTserSubFldrPP

	setdatafolder $pbpfldrfp
	wave Classification=$ksSP2pbpClassification
	wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut				
	variable nTriggers=dimsize(Classification,0)	
	//update sample interval and volume wave and access them	(applies main data mask)
	setdatafolder $rawfldrfp
	SP2sampleVolumeWaveCalc(rawfldrfp)
	wave SampleVolume=$ksSP2sampleVolume
	wave SampleInterval=$ksSP2sampleInterval
	//access data
		//access raw data waves
		setdatafolder $rawfldrfp
		wave TimeDate=$ksSP2TimeDate
		wave TimeElapsedEff=$ksSP2TimeElapsedEff
		//access PBP waves	
		setdatafolder $pbpfldrfp
			//high gain
			wave/Z SCHG_GaussPeakHt=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakHeight			
			variable SCHG_Available= waveexists(SCHG_GaussPeakHt)
			wave/Z BBHG_BCmass=$ksSP2BBHGprefix+ksSP2pbpBCmass
			wave/Z BBHG_BCdiam=$ksSP2BBHGprefix+ksSP2pbpBCdiam
			variable BBHG_Available= waveexists(BBHG_BCmass)
			wave/Z NBHG_BCmass=$ksSP2NBHGprefix+ksSP2pbpBCmass
			wave/Z NBHG_BCdiam=$ksSP2NBHGprefix+ksSP2pbpBCdiam
			variable NBHG_Available= waveexists(NBHG_BCmass)
			wave/Z SPHG_BasicNegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
			variable SPHG_Available= waveexists(SPHG_BasicNegPeakHt)
			//low gain
			wave/Z SCLG_GaussPeakHt=$ksSP2SCLGprefix+ksSP2PBPscattGausspeakHeight			
			variable SCLG_Available= waveexists(SCLG_GaussPeakHt)
			wave/Z BBLG_BCmass=$ksSP2BBLGprefix+ksSP2pbpBCmass
			wave/Z BBLG_BCdiam=$ksSP2BBLGprefix+ksSP2pbpBCdiam
			variable BBLG_Available= waveexists(BBLG_BCmass)
			wave/Z NBLG_BCmass=$ksSP2NBLGprefix+ksSP2pbpBCmass
			wave/Z NBLG_BCdiam=$ksSP2NBLGprefix+ksSP2pbpBCdiam
			variable NBLG_Available= waveexists(NBLG_BCmass)
			wave/Z SPLG_BasicNegPeakHt=$ksSP2SPLGprefix+ksSP2PBPsplitNegPeakHt				
			variable SPLG_Available= waveexists(SPLG_BasicNegPeakHt)
			//combined data
			wave/Z SHSL_GaussPeakHt=$ksSP2SHSLprefix+ksSP2PBPscattGausspeakHeight	
			wave/Z SHSL_OptDiam=$ksSP2SHSLprefix+ksSP2pbpOptDiam
			variable SHSL_Available= waveexists(SHSL_OptDiam)
			wave/Z BHNH_BCmass=$ksSP2BHNHprefix+ksSP2pbpBCmass
			wave/Z BHNH_BCdiam=$ksSP2BHNHprefix+ksSP2pbpBCdiam
			variable BHNH_Available= waveexists(BHNH_BCmass)
			wave/Z BHNL_BCmass=$ksSP2BHNLprefix+ksSP2pbpBCmass
			wave/Z BHNL_BCdiam=$ksSP2BHNLprefix+ksSP2pbpBCdiam
			variable BHNL_Available= waveexists(BHNL_BCmass)
			wave/Z BHBL_BCmass=$ksSP2BHBLprefix+ksSP2pbpBCmass
			wave/Z BHBL_BCdiam=$ksSP2BHBLprefix+ksSP2pbpBCdiam
			variable BHBL_Available= waveexists(BHBL_BCmass)
			wave/Z BLNL_BCmass=$ksSP2BLNLprefix+ksSP2pbpBCmass
			wave/Z BLNL_BCdiam=$ksSP2BLNLprefix+ksSP2pbpBCdiam
			variable BLNL_Available= waveexists(BLNL_BCmass)
	//finish if no data waves are available
	variable AnyData=SCHG_Available+BBHG_Available+NBHG_Available+SPHG_Available
	AnyData+=SCLG_Available+BBLG_Available+NBLG_Available+SPLG_Available
	AnyData+=SHSL_Available+BHNH_Available+BHNL_Available+BHBL_Available+BLNL_Available
	if( !(AnyData) )
		//no analysed data waves available => finish
		setdatafolder $savedDF
		return 0
	endif	
	//prepare wave containing the time stamps
	if (paramisdefault(StartTime))
		StartTime=TimeDate[0]
	endif
	if (paramisdefault(EndTime))
		EndTime=TimeDate[inf] 
// There is just too much bad programming to fix this everywhere. -jcc dec 2016
//		variable idx_lastGoodTime= getIndex(0, TimeDate, tol=inf, rev=1)		// jcc 4112...sometimes ends in NaN, bug in DMT or PSI software?
//		EndTime=TimeDate[idx_lastGoodTime]
	endif
	if (IntSec==0)
		//extract just one concentration value including all measured particles
		IntSec=ceil(TimeDate[inf]-TimeDate[0])
		StartTime=TimeDate[0]
		EndTime=StartTime+1	//make sure that "TimeWaveCreatorVar" below creates just a 1-element wave
	endif
	if (IntSec==-1)
		//extract just one concentration value including all measured particles
		IntSec=ceil(EndTime-StartTime)
	endif
	if (paramisdefault(Offset))
		Offset=mod(StartTime, IntSec)
	endif
	newdatafolder /o/s $concfldrfp
	TimeWaveCreatorVar(StartTime, EndTime, IntSec, Offset, ksSP2timeSeriesTimeBdr, Omode=1)
	wave /d ConcTimeBdr=$ksSP2timeSeriesTimeBdr
	note ConcTimeBdr, "Interval boundary time stamps for concentration time series (histograms etc);"
	setscale d 0,0,"dat", ConcTimeBdr
	variable nConcPts=numpnts(ConcTimeBdr)-1
	make /o/d/n=(nConcPts) $ksSP2timeSeriesTimeCtr
	wave /d ConcTimeCtr=$ksSP2timeSeriesTimeCtr
	note ConcTimeCtr, "Interval centre time stamps for concentration time series (XY plots etc);"
	setscale d 0,0,"dat", ConcTimeCtr
	setscale /P x StartTime + IntSec/2, IntSec,"dat", ConcTimeCtr // jcc v4111 -- not robust but due to circular reasoning of this function and TimeWaveCreatorVar, reliable
	BinBoundariesToCentres(ConcTimeBdr, ConcTimeCtr)
	//prepare concentration waves
	setdatafolder $concfldrfp
	//total triggers
		make /o/n=(nConcPts) $ksSP2tottrigPrefix+ksSP2timeSeriesNumbConcBnam=NaN
		wave TotTrig_NumbConc=$ksSP2tottrigPrefix+ksSP2timeSeriesNumbConcBnam		
		note TotTrig_NumbConc, "number concentration [#/cm] of triggered particles (any type, no cut-off applied);"
		note TotTrig_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
		setscale /P x StartTime + IntSec/2, IntSec,"dat", TotTrig_NumbConc // jcc v4111
	//high gain
		//scattering
		if (SCHG_available)
			make /o/n=(nConcPts) $ksSP2SCHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave SCHG_NumbConc=$ksSP2SCHGprefix+ksSP2timeSeriesNumbConcBnam
			note SCHG_NumbConc, "number concentration [#/cm] of detected particles with high gain scattering peak height above threshold;"
			note SCHG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"		
			setscale /P x StartTime + IntSec/2, IntSec,"dat", SCHG_NumbConc // jcc v4111
		endif
		//broadband
		if (BBHG_available)
			make /o/n=(nConcPts) $ksSP2BBHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BBHG_NumbConc=$ksSP2BBHGprefix+ksSP2timeSeriesNumbConcBnam
			note BBHG_NumbConc, "number concentration [#/cm] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BBHG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2BBHGprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BBHG_MassConc=$ksSP2BBHGprefix+ksSP2timeSeriesMassConcBnam
			note BBHG_MassConc, "mass concentration [g/m] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BBHG_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2BBHGprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BBHG_NumbMeanDp=$ksSP2BBHGprefix+ksSP2ConcTserNumbMeanDpBnam
			note BBHG_NumbMeanDp, "count mean diameter [nm] of number size distribution (high gain broadband channel);"
			note BBHG_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BBHG_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BBHGprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BBHG_MassMeanDp=$ksSP2BBHGprefix+ksSP2ConcTserMassMeanDpBnam
			note BBHG_MassMeanDp, "count mean diameter [nm] of mass size distribution (high gain broadband channel);"
			note BBHG_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBHG_NumbConc // jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBHG_MassConc // jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBHG_NumbMeanDp // jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBHG_MassMeanDp // jcc v4111
		endif
		//narrowband
		if (NBHG_available)
			make /o/n=(nConcPts) $ksSP2NBHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave NBHG_NumbConc=$ksSP2NBHGprefix+ksSP2timeSeriesNumbConcBnam
			note NBHG_NumbConc, "number concentration [#/cm] of detected particles with high gain narrowband incandescence peak height above threshold;"
			note NBHG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2NBHGprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave NBHG_MassConc=$ksSP2NBHGprefix+ksSP2timeSeriesMassConcBnam
			note NBHG_MassConc, "mass concentration [g/m] of detected particles with high gain narrowband incandescence peak height above threshold;"
			note NBHG_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2NBHGprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave NBHG_NumbMeanDp=$ksSP2NBHGprefix+ksSP2ConcTserNumbMeanDpBnam
			note NBHG_NumbMeanDp, "count mean diameter [nm] of number size distribution (high gain narrowband channel);"
			note NBHG_NumbMeanDp, "note: provides only very rough qualitative information;"
			note NBHG_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2NBHGprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave NBHG_MassMeanDp=$ksSP2NBHGprefix+ksSP2ConcTserMassMeanDpBnam
			note NBHG_MassMeanDp, "count mean diameter [nm] of mass size distribution (high gain narrowband channel);"
			note NBHG_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBHG_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBHG_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBHG_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBHG_MassMeanDp 	// jcc v4111
		endif
		//split detector
		if (SPHG_available)
			make /o/n=(nConcPts) $ksSP2SPHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave SPHG_NumbConc=$ksSP2SPHGprefix+ksSP2timeSeriesNumbConcBnam		
			note SPHG_NumbConc, "number concentration [#/cm] of detected particles with high gain split detector peak height above threshold;"
			note SPHG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"		
			setscale /P x StartTime + IntSec/2, IntSec,"dat", SPHG_NumbConc // jcc v4111
		endif
		//total scattering and/or broadband
		if (SCHG_available+BBHG_available)
			make /o/n=(nConcPts) $ksSP2BBHGorSCHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BHorScH_NumbConc=$ksSP2BBHGorSCHGprefix+ksSP2timeSeriesNumbConcBnam		
			note BHorScH_NumbConc, "number concentration [#/cm] of all BC (high gain broadband) and/or high gain scattering particles (cut-off applied for both channels);"
			note BHorScH_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"		
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHorScH_NumbConc 	// jcc v4111
		endif
		//pure scattering without any incandescence
		if ( SCHG_available && (BBHG_available || NBHG_available || BBLG_available || NBLG_available) )		//SCHG + at least one incandescence channel must be available
			make /o/n=(nConcPts) $ksSP2SCHGnotBBHGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave ScHnoInc_NumbConc=$ksSP2SCHGnotBBHGprefix+ksSP2timeSeriesNumbConcBnam		
			note ScHnoInc_NumbConc, "number concentration [#/cm] of all pure scattering (high gain) events without simultaneous incandescence (scattering cut-off applied);"
			note ScHnoInc_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"		
			setscale /P x StartTime + IntSec/2, IntSec,"dat", ScHnoInc_NumbConc 	// jcc v4111
		endif
	//low gain
		//scattering
		if (SCLG_available)
			make /o/n=(nConcPts) $ksSP2SCLGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave SCLG_NumbConc=$ksSP2SCLGprefix+ksSP2timeSeriesNumbConcBnam
			note SCLG_NumbConc, "number concentration [#/cm] of detected particles with low gain scattering peak height above threshold;"
			note SCLG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"		
			setscale /P x StartTime + IntSec/2, IntSec,"dat", SCLG_NumbConc 	// jcc v4111
		endif
		//broadband
		if (BBLG_available)
			make /o/n=(nConcPts) $ksSP2BBLGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BBLG_NumbConc=$ksSP2BBLGprefix+ksSP2timeSeriesNumbConcBnam
			note BBLG_NumbConc, "number concentration [#/cm] of detected particles with low gain broadband incandescence peak height above threshold;"
			note BBLG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2BBLGprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BBLG_MassConc=$ksSP2BBLGprefix+ksSP2timeSeriesMassConcBnam
			note BBLG_MassConc, "mass concentration [g/m] of detected particles with low gain broadband incandescence peak height above threshold;"
			note BBLG_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2BBLGprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BBLG_NumbMeanDp=$ksSP2BBLGprefix+ksSP2ConcTserNumbMeanDpBnam
			note BBLG_NumbMeanDp, "count mean diameter [nm] of number size distribution (low gain broadband channel);"
			note BBLG_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BBLG_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BBLGprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BBLG_MassMeanDp=$ksSP2BBLGprefix+ksSP2ConcTserMassMeanDpBnam
			note BBLG_MassMeanDp, "count mean diameter [nm] of mass size distribution (low gain broadband channel);"
			note BBLG_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBLG_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBLG_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBLG_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BBLG_MassMeanDp 	// jcc v4111
		endif
		//narrowband
		if (NBLG_available)
			make /o/n=(nConcPts) $ksSP2NBLGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave NBLG_NumbConc=$ksSP2NBLGprefix+ksSP2timeSeriesNumbConcBnam
			note NBLG_NumbConc, "number concentration [#/cm] of detected particles with low gain narrowband incandescence peak height above threshold;"
			note NBLG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2NBLGprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave NBLG_MassConc=$ksSP2NBLGprefix+ksSP2timeSeriesMassConcBnam
			note NBLG_MassConc, "mass concentration [g/m] of detected particles with low gain narrowband incandescence peak height above threshold;"
			note NBLG_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			make /o/n=(nConcPts) $ksSP2NBLGprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave NBLG_NumbMeanDp=$ksSP2NBLGprefix+ksSP2ConcTserNumbMeanDpBnam
			note NBLG_NumbMeanDp, "count mean diameter [nm] of number size distribution (low gain narrowband channel);"
			note NBLG_NumbMeanDp, "note: provides only very rough qualitative information;"
			note NBLG_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2NBLGprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave NBLG_MassMeanDp=$ksSP2NBLGprefix+ksSP2ConcTserMassMeanDpBnam
			note NBLG_MassMeanDp, "count mean diameter [nm] of mass size distribution (low gain narrowband channel);"
			note NBLG_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBLG_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBLG_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBLG_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", NBLG_MassMeanDp 	// jcc v4111
		endif
		//split detector
		if (SPLG_available)
			make /o/n=(nConcPts) $ksSP2SPLGprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave SPLG_NumbConc=$ksSP2SPLGprefix+ksSP2timeSeriesNumbConcBnam		
			note SPLG_NumbConc, "number concentration [#/cm] of detected particles with low gain split detector peak height above threshold;"
			note SPLG_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"	
			setscale /P x StartTime + IntSec/2, IntSec,"dat", SPLG_NumbConc 	// jcc v4111	
		endif
	//combined data
		//SHSL
		if (SHSL_available)
			make /o/n=(nConcPts) $ksSP2SHSLprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave SHSL_NumbConc=$ksSP2SHSLprefix+ksSP2timeSeriesNumbConcBnam
			note SHSL_NumbConc, "number concentration [#/cm] of detected particles with high gain scattering peak height above threshold;"
			note SHSL_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and"+ksSP2timeSeriesTimeCtr+";"	
			setscale /P x StartTime + IntSec/2, IntSec,"dat", SHSL_NumbConc 	// jcc v4111	
		endif
		//BHNH
		if (BHNH_available)
			make /o/n=(nConcPts) $ksSP2BHNHprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BHNH_NumbConc=$ksSP2BHNHprefix+ksSP2timeSeriesNumbConcBnam
			note BHNH_NumbConc, "number concentration [#/cm] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHNH_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHNH_NumbConc, "obtained from high gain broadband and high gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BHNHprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BHNH_MassConc=$ksSP2BHNHprefix+ksSP2timeSeriesMassConcBnam
			note BHNH_MassConc, "mass concentration [g/m] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHNH_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHNH_MassConc, "obtained from high gain broadband and high gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BHNHprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BHNH_NumbMeanDp=$ksSP2BHNHprefix+ksSP2ConcTserNumbMeanDpBnam
			note BHNH_NumbMeanDp, "count mean diameter [nm] of number size distribution from combined high gain broadband and high gain narrowband data;"
			note BHNH_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BHNH_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BHNHprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BHNH_MassMeanDp=$ksSP2BHNHprefix+ksSP2ConcTserMassMeanDpBnam
			note BHNH_MassMeanDp, "count mean diameter [nm] of mass size distribution from combined high gain broadband and high gain narrowband data;"
			note BHNH_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNH_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNH_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNH_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNH_MassMeanDp 	// jcc v4111
		endif
		//BHNL
		if (BHNL_available)
			make /o/n=(nConcPts) $ksSP2BHNLprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BHNL_NumbConc=$ksSP2BHNLprefix+ksSP2timeSeriesNumbConcBnam
			note BHNL_NumbConc, "number concentration [#/cm] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHNL_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHNL_NumbConc, "obtained from high gain broadband and low gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BHNLprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BHNL_MassConc=$ksSP2BHNLprefix+ksSP2timeSeriesMassConcBnam
			note BHNL_MassConc, "mass concentration [g/m] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHNL_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHNL_MassConc, "obtained from high gain broadband and low gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BHNLprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BHNL_NumbMeanDp=$ksSP2BHNLprefix+ksSP2ConcTserNumbMeanDpBnam
			note BHNL_NumbMeanDp, "count mean diameter [nm] of number size distribution from combined high gain broadband and low gain narrowband data;"
			note BHNL_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BHNL_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BHNLprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BHNL_MassMeanDp=$ksSP2BHNLprefix+ksSP2ConcTserMassMeanDpBnam
			note BHNL_MassMeanDp, "count mean diameter [nm] of mass size distribution from combined high gain broadband and low gain narrowband data;"
			note BHNL_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNL_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNL_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNL_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHNL_MassMeanDp 	// jcc v4111
		endif
		//BHBL
		if (BHBL_available)
			make /o/n=(nConcPts) $ksSP2BHBLprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BHBL_NumbConc=$ksSP2BHBLprefix+ksSP2timeSeriesNumbConcBnam
			note BHBL_NumbConc, "number concentration [#/cm] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHBL_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHBL_NumbConc, "obtained from high gain broadband and low gain broadband channel data;"
			make /o/n=(nConcPts) $ksSP2BHBLprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BHBL_MassConc=$ksSP2BHBLprefix+ksSP2timeSeriesMassConcBnam
			note BHBL_MassConc, "mass concentration [g/m] of detected particles with high gain broadband incandescence peak height above threshold;"
			note BHBL_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BHBL_MassConc, "obtained from high gain broadband and low gain broadband channel data;"
			make /o/n=(nConcPts) $ksSP2BHBLprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BHBL_NumbMeanDp=$ksSP2BHBLprefix+ksSP2ConcTserNumbMeanDpBnam
			note BHBL_NumbMeanDp, "geometric mean diameter [nm] of number size distribution from combined high gain broadband and low gain broadband data;"
			note BHBL_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BHBL_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BHBLprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BHBL_MassMeanDp=$ksSP2BHBLprefix+ksSP2ConcTserMassMeanDpBnam
			note BHBL_MassMeanDp, "count mean diameter [nm] of mass size distribution from combined high gain broadband and low gain broadband data;"
			note BHBL_MassMeanDp, "note: provides only very rough qualitative information;"
			make /o/n=(nConcPts) $ksSP2BHBLprefix+ksSP2ConcTserAvgMassDpBnam=NaN
			wave BHBL_AvgMassDp=$ksSP2BHBLprefix+ksSP2ConcTserAvgMassDpBnam
			note BHBL_AvgMassDp, "diameter of average mass [nm]. NumbConc*d_avgMass = MassConc. cf. Hinds Eq. 4.18;"
			note BHBL_AvgMassDp, "\rfrom combined high gain broadband and low gain broadband data;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHBL_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHBL_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHBL_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHBL_MassMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BHBL_AvgMassDp 	// jcc v4111
		endif
		//BLNL
		if (BLNL_available)
			make /o/n=(nConcPts) $ksSP2BLNLprefix+ksSP2timeSeriesNumbConcBnam=NaN
			wave BLNL_NumbConc=$ksSP2BLNLprefix+ksSP2timeSeriesNumbConcBnam
			note BLNL_NumbConc, "number concentration [#/cm] of detected particles with low gain broadband incandescence peak height above threshold;"
			note BLNL_NumbConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BLNL_NumbConc, "obtained from low gain broadband and low gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BLNLprefix+ksSP2timeSeriesMassConcBnam=NaN
			wave BLNL_MassConc=$ksSP2BLNLprefix+ksSP2timeSeriesMassConcBnam
			note BLNL_MassConc, "mass concentration [g/m] of detected particles with low gain broadband incandescence peak height above threshold;"
			note BLNL_MassConc, "corresponding time waves: "+ksSP2timeSeriesTimeBdr+"and "+ksSP2timeSeriesTimeCtr+";"
			note BLNL_MassConc, "obtained from low gain broadband and low gain narrowband channel data;"
			make /o/n=(nConcPts) $ksSP2BLNLprefix+ksSP2ConcTserNumbMeanDpBnam=NaN
			wave BLNL_NumbMeanDp=$ksSP2BLNLprefix+ksSP2ConcTserNumbMeanDpBnam
			note BLNL_NumbMeanDp, "count mean diameter [nm] of number size distribution from combined low gain broadband and low gain narrowband data;"
			note BLNL_NumbMeanDp, "note: provides only very rough qualitative information;"
			note BLNL_NumbMeanDp, "v4111: changed to geometric mean diameter for robustness;"
			make /o/n=(nConcPts) $ksSP2BLNLprefix+ksSP2ConcTserMassMeanDpBnam=NaN
			wave BLNL_MassMeanDp=$ksSP2BLNLprefix+ksSP2ConcTserMassMeanDpBnam
			note BLNL_MassMeanDp, "count mean diameter [nm] of mass size distribution from combined low gain broadband and low gain narrowband data;"
			note BLNL_MassMeanDp, "note: provides only very rough qualitative information;"
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BLNL_NumbConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BLNL_MassConc 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BLNL_NumbMeanDp 	// jcc v4111
			setscale /P x StartTime + IntSec/2, IntSec,"dat", BLNL_MassMeanDp 	// jcc v4111
		endif
	//extract concentration time series
		//loop over points of time series
		variable totsampletimeeff, fractsaveloadfact, totsamplevolume
		variable tind, currstart, currend, firstpind, coverage
		variable TotTrigNumb, BBHGorSCHGnumb, SCHGnotBBHGnumb
		variable SCHGnumb, BBHGnumb, NBHGnumb, SPHGnumb
		variable SCLGnumb, BBLGnumb, NBLGnumb, SPLGnumb
		variable SHSLnumb, BHNHnumb, BHNLnumb, BHBLnumb, BLNLnumb
		variable BBHGmass, BBHGdiamSum, BBHGmassXdiamSum
		variable BBLGmass, BBLGdiamSum, BBLGmassXdiamSum
		variable NBHGmass, NBHGdiamSum, NBHGmassXdiamSum
		variable NBLGmass, NBLGdiamSum, NBLGmassXdiamSum
		variable BHNHmass, BHNHdiamSum, BHNHmassXdiamSum
		variable BHNLmass, BHNLdiamSum, BHNLmassXdiamSum
		variable BHBLmass, BHBLdiamSum, BHBLmassXdiamSum, BHBLdSumCubed
		variable BLNLmass, BLNLdiamSum, BLNLmassXdiamSum
		variable pind=0
		for (tind=0; tind<nConcPts; tind+=1)
			currstart=ConcTimeBdr[tind]
			currend=ConcTimeBdr[tind+1]
			TotTrigNumb=0; BBHGorSCHGnumb=0; SCHGnotBBHGnumb=0
			SCHGnumb=0; BBHGnumb=0; NBHGnumb=0; SPHGnumb=0
			SCLGnumb=0; BBLGnumb=0; NBLGnumb=0; SPLGnumb=0
			SHSLnumb=0; BHNHnumb=0; BHNLnumb=0; BHBLnumb=0; BLNLnumb=0
			BBHGmass=0; BBHGdiamSum=0; BBHGmassXdiamSum=0
			BBLGmass=0; BBLGdiamSum=0; BBLGmassXdiamSum=0
			NBHGmass=0; NBHGdiamSum=0; NBHGmassXdiamSum=0
			NBLGmass=0; NBLGdiamSum=0; NBLGmassXdiamSum=0
			BHNHmass=0; BHNHdiamSum=0; BHNHmassXdiamSum=0
			BHNLmass=0; BHNLdiamSum=0; BHNLmassXdiamSum=0
			BHBLmass=0; BHBLdiamSum=0; BHBLmassXdiamSum=0; BHBLdSumCubed=0
			BLNLmass=0; BLNLdiamSum=0; BLNLmassXdiamSum=0
			//count number of particles in current time interval
				//check whether measurement has already started
				if (TimeDate[pind]>=currend)
					//measurement started later => continue
					continue
				endif
				//search first particle within current interval	
				do
					if (TimeDate[pind]>=currstart)
						//=> first particle within interval
						firstpind=pind		//remember index of first particle
						break
					endif
					pind+=1
				while (pind<nTriggers)
				if (pind==nTriggers)
					//end of measurement reached
					break
				endif		
				//count particles within current interval
				do
					//count this particle
					TotTrigNumb+=1
					if (Classification[pind] & kSP2BBHGeventBitVal || Classification[pind] & kSP2SCHGeventBitVal)
						BBHGorSCHGnumb+=1
					endif
					if (Classification[pind] & kSP2SCHGeventBitVal)
						//SCHG above threshold
						SCHGnumb+=1
						SHSLnumb+=1
						if ( (ClassificationByMinCut[pind] & kSP2BBHGeventBitVal)==0 )
							//BBHG below minimum threshold
							SCHGnotBBHGnumb+=1
						endif
					endif
					if (Classification[pind] & kSP2SCLGeventBitVal)
						SCLGnumb+=1
					endif
					if (Classification[pind] & kSP2BBHGeventBitVal)
						BBHGnumb+=1
						BBHGmass+=BBHG_BCmass[pind]
						BBHGdiamSum+=ln(BBHG_BCdiam[pind]) // v4111
						BBHGmassXdiamSum+=BBHG_BCmass[pind]*BBHG_BCdiam[pind]  
						BHNHnumb+=1
						BHNLnumb+=1
						BHBLnumb+=1
						if (BHNH_Available)
							BHNHmass+=BHNH_BCmass[pind]
							BHNHdiamSum+=ln(BHNH_BCdiam[pind])
							BHNHmassXdiamSum+=BHNH_BCmass[pind]*BHNH_BCdiam[pind]
						endif
						if (BHNL_Available)
							BHNLmass+=BHNL_BCmass[pind]
							BHNLdiamSum+=ln(BHNL_BCdiam[pind])
							BHNLmassXdiamSum+=BHNL_BCmass[pind]*BHNL_BCdiam[pind]
						endif
						if (BHBL_Available)
							BHBLmass+=BHBL_BCmass[pind]
							BHBLdiamSum+=ln(BHBL_BCdiam[pind])
							BHBLmassXdiamSum+=BHBL_BCmass[pind]*BHBL_BCdiam[pind]
							BHBLdSumCubed+=BHBL_BCdiam[pind]^3
						endif
					endif
					if (Classification[pind] & kSP2BBLGeventBitVal)
						BBLGnumb+=1
						BBLGmass+=BBLG_BCmass[pind]
						BBLGdiamSum+=ln(BBLG_BCdiam[pind])
						BBLGmassXdiamSum+=BBLG_BCmass[pind]*BBLG_BCdiam[pind]
						BLNLnumb+=1
						if (BLNL_Available)
							BLNLmass+=BLNL_BCmass[pind]
							BLNLdiamSum+=ln(BLNL_BCdiam[pind])
							BLNLmassXdiamSum+=BLNL_BCmass[pind]*BLNL_BCdiam[pind]
						endif
					endif
					if (Classification[pind] & kSP2NBHGeventBitVal)
						NBHGnumb+=1
						NBHGmass+=NBHG_BCmass[pind]
						NBHGdiamSum+=ln(NBHG_BCdiam[pind])
						NBHGmassXdiamSum+=NBHG_BCmass[pind]*NBHG_BCdiam[pind]
					endif
					if (Classification[pind] & kSP2NBLGeventBitVal)
						NBLGnumb+=1
						NBLGmass+=NBLG_BCmass[pind]
						NBLGdiamSum+=ln(NBLG_BCdiam[pind])
						NBLGmassXdiamSum+=NBLG_BCmass[pind]*NBLG_BCdiam[pind]
					endif
					if (Classification[pind] & kSP2SPHGeventBitVal)
						SPHGnumb+=1
					endif
					if (Classification[pind] & kSP2SPLGeventBitVal)
						SPLGnumb+=1
					endif
					pind+=1
				while (TimeDate[pind]<currend && pind<nTriggers)
				
			//fractional coverage of current interval by the measurement
			totsampletimeeff=SumNaNrange(SampleInterval, firstpind, pind-1)
			fractsaveloadfact=(TimeElapsedEff[pind-1]-TimeElapsedEff[firstpind-1])/(TimeDate[pind-1]-TimeDate[firstpind-1])		//mean fraction of total triggered particles eventually loaded into the file
			totsamplevolume=SumNaNrange(SampleVolume, firstpind, pind-1)
			coverage=(totsampletimeeff/fractsaveloadfact)/(currend-currstart)
			//copy concentration values to target waves if fractional coverage is sufficiently high
			if (coverage>kSP2concTserMinCoverage)
				//units:
					//ConcNumbXXXX: [#/cm]
					//ConcMassXXXX: [g/m]
					//numbXXXX; [#]
					//massXXXX; [fg]
					//sample volume [m]
					//sampletime: [s]
				//copy to target waves
				TotTrig_NumbConc[tind]=TotTrigNumb/(totsamplevolume*1e6)
				if (SCHG_available+BBHG_available)
					BHorScH_NumbConc[tind]=BBHGorSCHGnumb/(totsamplevolume*1e6)
				endif
				if (SCHG_available && (BBHG_available || NBHG_available || BBLG_available || NBLG_available))
					ScHnoInc_NumbConc[tind]=SCHGnotBBHGnumb/(totsamplevolume*1e6)
				endif
				if (SCHG_available)
					SCHG_NumbConc[tind]=SCHGnumb/(totsamplevolume*1e6)
				endif
				if (SCLG_available)
					SCLG_NumbConc[tind]=SCLGnumb/(totsamplevolume*1e6)
				endif
				if (BBHG_available)
					BBHG_NumbConc[tind]=BBHGnumb/(totsamplevolume*1e6)
					BBHG_MassConc[tind]=(BBHGmass*1e-9)/totsamplevolume
					BBHG_NumbMeanDp[tind]=exp(BBHGdiamSum/BBHGnumb)
					BBHG_MassMeanDp[tind]=BBHGmassXdiamSum/BBHGmass
				endif
				if (BBLG_available)
					BBLG_NumbConc[tind]=BBLGnumb/(totsamplevolume*1e6)
					BBLG_MassConc[tind]=(BBLGmass*1e-9)/totsamplevolume
					BBLG_NumbMeanDp[tind]=exp(BBLGdiamSum/BBLGnumb)
					BBLG_MassMeanDp[tind]=BBLGmassXdiamSum/BBLGmass
				endif
				if (NBHG_available)
					NBHG_NumbConc[tind]=NBHGnumb/(totsamplevolume*1e6)
					NBHG_MassConc[tind]=(NBHGmass*1e-9)/totsamplevolume
					NBHG_NumbMeanDp[tind]=exp(NBHGdiamSum/NBHGnumb)
					NBHG_MassMeanDp[tind]=NBHGmassXdiamSum/NBHGmass
				endif
				if (NBLG_available)
					NBLG_NumbConc[tind]=NBLGnumb/(totsamplevolume*1e6)
					NBLG_MassConc[tind]=(NBLGmass*1e-9)/totsamplevolume
					NBLG_NumbMeanDp[tind]=exp(NBLGdiamSum/NBLGnumb)
					NBLG_MassMeanDp[tind]=NBLGmassXdiamSum/NBLGmass
				endif
				if (SPHG_available)
					SPHG_NumbConc[tind]=SPHGnumb/(totsamplevolume*1e6)
				endif
				if (SPLG_available)
					SPLG_NumbConc[tind]=SPLGnumb/(totsamplevolume*1e6)
				endif				
				if (SHSL_available)
					SHSL_NumbConc[tind]=SHSLnumb/(totsamplevolume*1e6)
				endif
				if (BHNH_available)
					BHNH_NumbConc[tind]=BHNHnumb/(totsamplevolume*1e6)
					BHNH_MassConc[tind]=(BHNHmass*1e-9)/totsamplevolume
					BHNH_NumbMeanDp[tind]=exp(BHNHdiamSum/BHNHnumb)
					BHNH_MassMeanDp[tind]=BHNHmassXdiamSum/BHNHmass
				endif
				if (BHNL_available)
					BHNL_NumbConc[tind]=BHNLnumb/(totsamplevolume*1e6)
					BHNL_MassConc[tind]=(BHNLmass*1e-9)/totsamplevolume
					BHNL_NumbMeanDp[tind]=exp(BHNLdiamSum/BHNLnumb)
					BHNL_MassMeanDp[tind]=BHNLmassXdiamSum/BHNLmass
				endif
				if (BHBL_available)
					BHBL_NumbConc[tind]=BHBLnumb/(totsamplevolume*1e6)
					BHBL_MassConc[tind]=(BHBLmass*1e-9)/totsamplevolume
					BHBL_NumbMeanDp[tind]=exp(BHBLdiamSum/BHBLnumb)
					BHBL_MassMeanDp[tind]=BHBLmassXdiamSum/BHBLmass
					BHBL_AvgMassDp[tind]=(BHBLdSumCubed/BHBLnumb)^(1/3)
				endif
				if (BLNL_available)
					BLNL_NumbConc[tind]=BLNLnumb/(totsamplevolume*1e6)
					BLNL_MassConc[tind]=(BLNLmass*1e-9)/totsamplevolume
					BLNL_NumbMeanDp[tind]=exp(BLNLdiamSum/BLNLnumb)
					BLNL_MassMeanDp[tind]=BLNLmassXdiamSum/BLNLmass
				endif
			endif
		endfor
	//display results
	if (GraphMode)
		SP2_Conc_Time_Series_graph(concfldrfp=concfldrfp)
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
end



Function SP2_CETAC_NumbConcCalc_Forward(LiqNumbConc, LiqSupplyRate, NebulizingEff, DryerEff, PurgeAirFlowRate)
	//This function calculates the airborne particle number concentration after the CETAC nebulizer from the liquid sample number concentration
	//return value: number concentration of particles [particles/cm^3] in sample flow leaving the CETAC nebulizer
	//martin.gysel@psi.ch; 17/01/2011
	variable LiqNumbConc		//particle number concentration [particles/ml] in liquid sample which is nebulized with the CETAC nebulizer
	variable LiqSupplyRate	//liquid supply flow rate [ml/min] pumped onto the nebulizer's ultrasonic membrane
	variable NebulizingEff		//nebulizing efficiency = fraction of liquid sample that is nebulized = 1-(nebulizer chamber drain flow)/(total liquid sample flow)
	variable DryerEff			//accounts for particle losses in the dryer section (typically unknown); 1=no losses, 0=all particles are lost
	variable PurgeAirFlowRate	//purge air flow rate [l/min] flow rate of air that is blown into the nebulizer chamber
	
	variable ParticleRate=LiqNumbConc*LiqSupplyRate*NebulizingEff*DryerEff			//particles/min    (efficiency already accounted for)
	PurgeAirFlowRate=UnitConverterMG(21, PurgeAirFlowRate)				//convert L/min => cm^3/min
	variable AirbornePartNumbConc=ParticleRate/PurgeAirFlowRate					//particles/cm
	return AirbornePartNumbConc
End


Function SP2_TimeStampCleaner(TimeWave [KeepOrig, OrigSuffix, TimeJump, ErrorLevel, CorrMode])
	//This function cleans (SP2) time stamp waves for 24h jumps erroneously caused by the data acquisition software.
	//return value: 0; not used
	//martin.gysel@psi.ch; 14/02/2011, 05/03/2012
	wave TimeWave	//time wave which is to be cleaned
					//note: this wave will be overwritten if KeepOrig=0
	variable KeepOrig	//0 (default):	orginal time wave will be overwritten
					//1:			a copy of the original time wave will be made; see string "OrigSuffix" for naming convention
	string OrigSuffix	//suffix string that will be added to the copy of the original time wave
					//default: "_Orig"
					//ignored of KeepOrig=0
	variable TimeJump	//magnitude of time jump to be cleaned in seconds
						//default: 86400 (1 day)
	variable ErrorLevel	//time jump will be cleaned if its absolute value is larger than ErrorLevel*TimeJump
						//default: 0.65
	variable CorrMode		//0 (default):	TimeWave is corrected by the value of TimeJump (or a multiple of it) if a time jump is detected
						//1:			time is corrected such that the time values before and after the original jump are exactly equal
					
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	variable nRows=numpnts(TimeWave)
	//set defaults:
	if (paramisdefault(KeepOrig))
		KeepOrig=0
	endif
	if (paramisdefault(OrigSuffix))
		OrigSuffix="_Orig"
	endif
	if (paramisdefault(TimeJump))
		TimeJump=86400
	endif
	if (paramisdefault(ErrorLevel))
		ErrorLevel=0.65
	endif
	if (paramisdefault(CorrMode))
		CorrMode=0
	endif
	//keep a copy of the original time wave if needed
	if (KeepOrig)
		setdatafolder $GetWavesDataFolder(TimeWave, 1)
		duplicate /o TimeWave, $NameOfWave(TimeWave)+OrigSuffix
	endif
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2timeStampCleaner
	string tmpfldrpath=getdatafolder(1)
	//time differences
		//normalized time difference between recorded particles
		setdatafolder $tmpfldrpath
		make /o/d/n=(nRows) TimeDiff=(TimeWave[p]-TimeWave[p-1])/TimeJump
		TimeDiff[0]=0
		//absolute value of normalized time differences
		setdatafolder $tmpfldrpath
		make /o/d/n=(nRows) TimeDiffAbs=Abs(TimeDiff)
	//find time jumps
	FindLevels /EDGE=1 /Q/P TimeDiffAbs, ErrorLevel
	wave W_FindLevels
	W_FindLevels=ceil(W_FindLevels)
	variable nJumps=numpnts(W_FindLevels)
	//correct time wave starting with last time jump
	if (nJumps>0)
		variable jind, CurrTimeDelta, CurrStartIndex
		for (jind=njumps-1;jind>=0;jind-=1)
			CurrStartIndex=W_FindLevels[jind]
			if (CorrMode==0)
				//fixed multiple of TimeJump
				CurrTimeDelta=round(TimeDiff[CurrStartIndex])*TimeJump
			else
				//correct time jump to zero
				CurrTimeDelta=TimeDiff[CurrStartIndex]*TimeJump
			endif
			TimeWave[CurrStartIndex,inf]-=CurrTimeDelta
		endfor
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
End


Function SP2_ScattAtIncNormalize(ctrlname, [pbpfldrfp, BeamShapeFldrFP, PSDchanPrefix, PrintInfo, GraphMode]) : ButtonControl
	//Normalizes the scattering signal at incandescence according to its position in the laser beam and the laser power.
	//return value: 0; not used
	//martin.gysel@psi.ch;	19/05/2011, 06/01/2012, 15/02/2012
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string BeamShapeFldrFP		//full path to folder containing the LEO-fit calibration factors
								//default: browse for folder
	string PSDchanPrefix	//prefix of the PSD channel to be used for the split position
						//default: use panel settings
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//channel definitions
	string chanlist=SP2_ChanListScattOnly()
	variable nChans=itemsinlist(chanlist)
	//set defaults
	if (paramisdefault(BeamShapeFldrFP))
		BeamShapeFldrFP= SP2_getBeamShapeFolder() // jcc addition, autodetect folder
	endif
	BeamShapeFldrFP=ChopLastCharacterOff(BeamShapeFldrFP,":")
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	CreateFoldersOfFullPath(SAIfldrFP, 0)
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	if (paramisdefault(PSDchanPrefix))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Svar Panel_SAIchanPrefixPSD=$ksSP2SAIchanPrefixPSD
		PSDchanPrefix=Panel_SAIchanPrefixPSD
	endif
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	//print command
	if (PrintInfo)
		string cmd=""
		cmd+=currproc+"(\""
		cmd+=ctrlname+"\", "
		cmd+="pbpfldrfp=\""+pbpfldrfp+"\", "
		cmd+="BeamShapeFldrFP=\""+BeamShapeFldrFP+"\", "
		cmd+="PrintInfo="+num2str(PrintInfo)+", "
		cmd+="GraphMode="+num2str(GraphMode)+")"
		print cmd
	endif
	//access and parse trace analysis info string
	setdatafolder $pbpfldrfp
	Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr	
	variable StartDelta=str2num(StringByKey(ksSP2SAIdeltaStartKey, TraceAnalysisInfoStr,":","\r"))
	variable EndDelta=str2num(StringByKey(ksSP2SAIdeltaEndKey, TraceAnalysisInfoStr,":","\r"))
	string IncPrefixForPos=replacestring(" ",StringByKey(ksSP2SAIchanPrefixIncKey, TraceAnalysisInfoStr,":","\r"),"")
	//access raw data
	setdatafolder $rawfldrfp
	wave YAGpower=$ksSP2YAGpower	
	//access PBP data
	setdatafolder $pbpfldrfp
	wave /Z UnfilteredCentreSplitPos=$PSDchanPrefix+ksSP2PBPsplitCentreSplitPos		//note, I am on purpose using the unfiltered split position in order to see how far down we get the split point
	wave /Z Incand_PeakPos=$IncPrefixForPos+ksSP2PBPtracefitPeakPos
	Svar PBPpostProcInfoStr=$ksSP2postProcInfoStr
	variable nRows=dimsize(UnfilteredCentreSplitPos,0)
	if (!waveexists(Incand_PeakPos) || !waveexists(UnfilteredCentreSplitPos))
		//missing data => end procedure
		if (datafolderexists(savedDF))
			setdatafolder $savedDF
		endif
		message="Missing trace analysis data in the procedure "+currproc+"."
		print message; print RTStackInfo; abort message
	endif
	//access beam shape data
	setdatafolder $BeamShapeFldrFP
	wave /Z Split2centreDelta=$ksSP2LEOfitSplit2centreDelta						// n= num PBP points, but contains one value				
	wave /Z scatt_BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
	wave /Z scatt_BeamShapeCentrePos=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos	
	if (!waveexists(Split2centreDelta) || !waveexists(scatt_BeamShapePerc50) || !waveexists(scatt_BeamShapeCentrePos))
		//missing data => end procedure
		if (datafolderexists(savedDF))
			setdatafolder $savedDF
		endif
		message="Missing beam shape data in the procedure "+currproc+"."
		print message; print RTStackInfo; abort message
	endif
	//copy PBP-postprocessing info string to ScattAtInd subfolder
	setdatafolder $SAIfldrFP
	string /g 	$ksSP2postProcInfoStr=PBPpostProcInfoStr
	//write SAI normalization info string
	setdatafolder $SAIfldrFP
	string /g $ksSP2SAInormalizInfoStr=""
	Svar NormalizationInfoStr=$ksSP2SAInormalizInfoStr
	NormalizationInfoStr+=ksSP2SAIchanPrefixPSDKey+"="+PSDchanPrefix+"\r"
	NormalizationInfoStr+=ksSP2SAIchanPrefixIncKey+"="+IncPrefixForPos+"\r"
	NormalizationInfoStr+="BeamShapeDF"+"="+BeamShapeFldrFP+"\r"
	//create result waves
	setdatafolder $SAIfldrFP
	make /o/n=(nRows) $ksSP2SAInormFactPosInLaser
	wave SAI_NormFactPosInLaser=$ksSP2SAInormFactPosInLaser
	note SAI_NormFactPosInLaser, "normalization factor applied to account for relative position in laser beam;"
	//loop over rows and determine normalization factor for position in laser beam
	variable rind, aind, avg, avgstartind, avgendind, currBeamPos, currInc2CentreDelta
	for (rind=0;rind<nRows;rind+=1)
		//find index range to be averaged in reference beam shape
		currBeamPos=UnfilteredCentreSplitPos[rind]+Split2centreDelta[0]
		currInc2CentreDelta=currBeamPos-Incand_PeakPos[rind]
		avgstartind=scatt_BeamShapeCentrePos[0]-(currInc2CentreDelta-StartDelta)
		avgendind=scatt_BeamShapeCentrePos[0]-(currInc2CentreDelta-EndDelta)
		//average reference beam shape
		avg=0
		for (aind=avgstartind;aind<=avgendind;aind+=1)
			avg+=scatt_BeamShapePerc50[aind]
		endfor
		avg/=(avgendind-avgstartind)+1
		//store normalization factor 
		SAI_NormFactPosInLaser[rind]=avg
	endfor
	//loop over scattering channels for normalizing the scattering signal at incandescence
	string CurrScattChanPrefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		//prefix of current scattering channel
		CurrScattChanPrefix=stringfromlist(chanind,chanlist)
		
		//access PBP data for current scattering channel
		setdatafolder $pbpfldrfp
		wave /Z CurrScattSigAtInc=$CurrScattChanPrefix+ksSP2PBPscattSigAtIncand
		if (!waveexists(CurrScattSigAtInc))
			//missing data for current scattering channel => proceed with next channel
			continue
		endif
		
		//create result waves for current scattering channel
		setdatafolder $SAIfldrFP
		make /o/n=(nRows) $CurrScattChanPrefix+ksSP2SAIFitSigNorm /WAVE=Curr_SAI_FitSigNorm
		multithread Curr_SAI_FitSigNorm= nan
		wave Curr_SAI_FitSigNorm=$CurrScattChanPrefix+ksSP2SAIFitSigNorm
		note Curr_SAI_FitSigNorm, "scattering signal amplitude at incandescence normalized by absolute laser power and relative laser power intensity according to the position in the laser beam;"
		
		// SAI_CALC [1/2] 
		//normalize scattering with absolute laser power and relative factor to account for position in the laser beam 
		// scatt_CS = scatt_signal / relative_beam_power / YAGpower
		Curr_SAI_FitSigNorm=CurrScattSigAtInc/SAI_NormFactPosInLaser/YAGpower
		
		
		
		
		//show graphs (channel specific)
		if (GraphMode)
			SP2_SAIgr_ScattAmpVsIncPkHt(pbpfldrfp=pbpfldrfp, ScattPrefix=CurrScattChanPrefix, IncPrefix=IncPrefixForPos)
		endif
	endfor
	//show graphs (channel independent)
	if (GraphMode)
		//no graphs implemented so far
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


Function SP2_ScattAtIncOptSizing(ctrlname, [pbpfldrfp, BeamShapeFldrFP, PrintInfo, GraphMode]) : ButtonControl
	//Optical sizing of BC core from scattering signal amplitude just before incandescence
	//return value: 0; not used
	//martin.gysel@psi.ch;	20/05/2011, 06/01/2012, 15/02/2012
	//joel.c.corbin+sci@gmail.com; 2016-02-25. Some modifications related to SAI calibration, later extracted.
	//
	string ctrlname		//name of button control; not used
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	string BeamShapeFldrFP		//full path to folder containing the LEO-fit calibration factors
								//default: try standard location, otherwise browse for it
	variable PrintInfo		//1 (default):	print loading information to history
						//0:			do not print loading information to history
	variable GraphMode	//1:	show graphs automatically
						//0:	do not show graphs
						//default: use panel setting
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g 	RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//channel definitions
	string chanlist=SP2_ChanListScattOnly()
	variable nChans=itemsinlist(chanlist)
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	pbpfldrfp=ChopLastCharacterOff(pbpfldrfp,":")
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
	if (paramisdefault(BeamShapeFldrFP))
		//try standard location
		BeamShapeFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
		if (!DataFolderExists(BeamShapeFldrFP))
			//not available at standard location => use function 
			BeamShapeFldrFP= SP2_getBeamShapeFolder()
		endif		
	endif
	BeamShapeFldrFP=ChopLastCharacterOff(BeamShapeFldrFP,":") 
	if (paramisdefault(GraphMode))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar AutoGraphCB=$ksSP2autoGraphCB
		GraphMode=AutoGraphCB
	endif
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	//print command
	if (PrintInfo)
		string cmd=""
		cmd+=currproc+"(\""
		cmd+=ctrlname+"\", "
		cmd+="pbpfldrfp=\""+pbpfldrfp+"\", "
		cmd+="BeamShapeFldrFP=\""+BeamShapeFldrFP+"\", "
		cmd+="PrintInfo="+num2str(PrintInfo)+", "
		cmd+="GraphMode="+num2str(GraphMode)+")"
		print cmd
	endif
	//access further panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar Panel_LEOrefractIndexPair=$ksSP2leoRefractIndexPair
	NVAR SAI_calib_flag= $ksSP2useSAIforScattCalib
	//access and parse trace analysis info string
	setdatafolder $pbpfldrfp
	Svar TraceAnalysisInfoStr=$ksSP2traceAnalysisInfoStr	
	string IncPrefixForPos=replacestring(" ",StringByKey(ksSP2SAIchanPrefixIncKey, TraceAnalysisInfoStr,":","\r"),"")
	
	//write SAI optical sizing info string
	newdatafolder /o/s $SAIfldrFP // setdatafolder $SAIfldrFP // v4111 jcc
	string /g $ksSP2SAIOptSizeInfoStr=""
	Svar OpticalSizingInfoStr=$ksSP2SAIOptSizeInfoStr
	OpticalSizingInfoStr+=ksSP2LEOrefractIndexPairKey+"="+Panel_LEOrefractIndexPair+"\r"
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2_SAI
	string tmpfldrpath=getdatafolder(1)
	
	//access MIE data for coated/uncoated BC particles particles
	string MieDataSubFldrPP=Panel_LEOrefractIndexPair	
	setdatafolder $ksSP2PathToMieCoatedBCfldr
	setdatafolder $MieDataSubFldrPP
	wave MieDcore=$ksSP2MIE_Dcore
	wave MieScatCross=$ksSP2MIE_ScatCross
	variable nDcore=numpnts(MieDcore)
	//extract scattering cross section of pure BC from Mie matrix
	setdatafolder $tmpfldrpath
	make /o/n=(nDcore) MieScatCrosBCcores=MieScatCross[p][0]
	//loop over scattering channels and do the optical sizing at incandescence
	string CurrScattChanPrefix
	variable chanind
	variable CurrScattCalCoef, nRows
	variable i, currNormScattAmp, currCoreIndex

	for (chanind=0; chanind<nChans; chanind+=1)
		//prefix of current scattering channel
		CurrScattChanPrefix=stringfromlist(chanind,chanlist)
		//access data from ScattAtInc subfolder
		setdatafolder $SAIfldrFP
		wave /Z Curr_SAI_FitSigNorm=$CurrScattChanPrefix+ksSP2SAIFitSigNorm		// 
		if (!waveexists(Curr_SAI_FitSigNorm))
			//missing data for current scattering channel => proceed with next channel
			continue
		endif
		nRows=dimsize(Curr_SAI_FitSigNorm,0)
		//access calibration coefficient of scattering channel
		setdatafolder $ksSP2PathToToolkitPanelFldr
		Svar CalibFldr=$ksSP2calibFldr
		setdatafolder $ksSP2PathToCalibDataFldr
		setdatafolder $CalibFldr
		wave Panel_CalCoef_scatt=$CurrScattChanPrefix+ksSP2CalCoefBnam
		CurrScattCalCoef=Panel_CalCoef_scatt[0]						

		//prepare result waves
		setdatafolder $SAIfldrFP
		make /o/n=(nRows) $CurrScattChanPrefix+ksSP2SAIFitOptDiam /WAVE=Curr_FitOptDiam
		multithread Curr_FitOptDiam=NaN
		note Curr_FitOptDiam, "optical diameter of BC core derived from scattering signal amplitude at incandescence;"
		note Curr_FitOptDiam, "note: the value -999 is assigned if the scattering signal amplitude is outside the range of available Mie data;"

		//loop over particles and determine optical size of BC core
		for (i=0; i<nRows; i+=1)
			// SAI_CALC [2/2] 
			currNormScattAmp=Curr_SAI_FitSigNorm[i]/CurrScattCalCoef		
			if (numtype(currNormScattAmp)==2)
				//no scattering data available
				Curr_FitOptDiam[i]=NaN
			else
				//scattering data available
				//=>check availability of MIE data
				if ( (currNormScattAmp<MieScatCrosBCcores[0]) || (currNormScattAmp>MieScatCrosBCcores[inf]) )
					//MIE data missing
					Curr_FitOptDiam[i]=-999
				else
					//MIE data available
					//=>search scattering amplitude in Mie data and read corresponding BC core diameter
					currCoreIndex=BinarySearchInterp(MieScatCrosBCcores, currNormScattAmp)
					if (numtype(currCoreIndex)==2)
						SP2_abort("Code error in the function "+currproc+"!")			
					endif
					Curr_FitOptDiam[i]=MieDcore[currCoreIndex]					
				endif
			endif
		endfor
				
		//show graphs (channel specific)
		if (GraphMode)
			SP2_SAIgr_BCdiamScatterPlot(pbpfldrfp=pbpfldrfp, ScattPrefix=CurrScattChanPrefix, IncPrefix=IncPrefixForPos)
		endif
	endfor
	
	
	
	//show graphs (independent of channel)
	if (GraphMode)
		//no graphs implemented so far
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return 0
end

// for controlling SP2_SAIcalibration() from the panel.
Function SP2_CB_toggleSAIcalib(cba) : CheckBoxControl
// joel.c.corbin+sci@gmail.com 2016-09-22

	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			variable checked = cba.checked
			if (checked)
				variable success= SP2_SAIcalibration("")
			endif
			
			break
		case -1: // control being killed
			break
	endswitch
	
	cba.checked= !cba.checked
	return 0
End
// Using scattering at incandescence, infer the scattering channel calibration. 
function SP2_SAIcalibration(ctrlname, [ScattPrefix, IncPrefix, smoothN, maxBC, pbpDF, beamShapeDF, doPrint, doGraphs]) : ButtonControl
// INCOMPLETE/EXPERIMENTAL FEATURE. Please, out of respect, include Joel if you develop this idea further.
// coefficient, assuming that the BC RI is known and BC mass calibration is perfect
// RETURNS: 1//0 if successful//unsuccessful.
//
	//joel.c.corbin+sci@gmail.com; 2016-09-25. New in v4111.
	string ctrlname		// not used
	string pbpDF		// full path to folder containing the PBP data, prompt if missing
	string ScattPrefix	// prefix of scattering channel. Prompts if missing.
	string IncPrefix	// prefix of incandescent channel. Prompts if missing.
	string beamShapeDF	// full path to folder containing the LEO-fit calibration factors, prompt if missing
	variable smoothN 	// Number of points by which to smooth [be intelligent--compare the expected rate of laser power change to the data rate]
	variable maxBC		// Maximum BC size to be used. Default 300. [the issue is deviation from linearity for larger sizes. See Mori, Ohata, Kondo, AST 2016.]
						// The min BC size is taken from the panel's peak LOQ.
						// The min scattering signal is taken from the panel's peak LOQ. 
						// The user can play with these automatic values in the popup window.
	variable doPrint	// BOOLEAN, print final command, default 1
	variable doGraphs	// BOOLEAN, plot graphs, default to panel setting
	
	// SAI_CALIB

	variable mustPrompt
	if (ParamIsDefault(pbpDF))
		pbpDF= SP2_getFolder(type="PBP")
		pbpDF= removeEnding(pbpDF, ":")
	endif
	if (ParamIsDefault(beamShapeDF))
		beamShapeDF= SP2_getBeamShapeFolder()
	endif
	if (ParamIsDefault(doPrint))
		doPrint= 1
	endif
	if (ParamIsDefault(doGraphs))
		doGraphs= SP2_graphsOn()
	endif
	if (!ParamIsDefault(ScattPrefix))
		// since the SAI noise and peak noise are the same, LOQ should be the same
		variable SC_LOQ= get_peak_LOQ(ScattPrefix)
	else
		ScattPrefix= ""
		SC_LOQ=0
		mustPrompt=1
	endif
	if (!ParamIsDefault(IncPrefix))
		// since the SAI noise and peak noise are the same, LOQ should be the same
		variable BB_LOQ= get_peak_LOQ(IncPrefix)
	else
		IncPrefix= ""
		BB_LOQ=0
		mustPrompt=1
	endif
	if (ParamIsDefault(smoothN) || ParamIsDefault(maxBC))
		mustPrompt=1
	endif
	
	if (mustPrompt)
		doPrint=1
		// suggested inputs / lists 
		string ScattPrefixList=SP2_ChanListScattOnly()
		string IncPrefixList=SP2_ChanListIncandOnly() 
		variable ScattMode=	1+WhichListItem(ScattPrefix, ScattPrefixList)
		variable IncMode=	1+WhichListItem(IncPrefix, IncPrefixList)
		maxBC= ifelse(maxBC==0, 300, maxBC)
		smoothN= 1000 // could be calculated from _SP2':ParticleID and :TimeDate, but better have user check graph
		
		// do the prompt
		prompt ScattMode, "Scattering channel for SAI (SCHG recommended):", popup, SP2_ChanListToAbbrevList(ScattPrefixList)
		prompt IncMode, "Incandescence channel for BC mass (BBHG recommended):", popup, SP2_ChanListToAbbrevList(IncPrefixList)
		prompt smoothN, "Do median replacement every N points:"
		prompt maxBC, "Maximum valid BC size to be used [recommended below 300 nm]:"
		prompt SC_LOQ, "Minimum valid scattering (SAI) signal [0 ==> use panel LOQ]:"
		prompt BB_LOQ, "Minimum valid incandescence peak [0 ==> use panel LOQ]:"
		doprompt "Need inputs for SAI scattering calibration...", ScattMode, IncMode, smoothN, maxBC
		if (V_flag)
			SP2_abort("")
		endif
		ScattMode-=1
		IncMode-=1
		ScattPrefix=stringfromlist(ScattMode,ScattPrefixList)
		IncPrefix=stringfromlist(IncMode,IncPrefixList)
		SC_LOQ= SC_LOQ==0 ? get_peak_LOQ(ScattPrefix)	: SC_LOQ
		BB_LOQ= BB_LOQ==0 ? get_peak_LOQ(IncPrefix)		: BB_LOQ
	endif
	
	
	// Check whether or not it makes sense to continue...
	wave /Z BCdiam= $pbpDF+IncPrefix+ksSP2pbpBCdiam	
	wave /Z CurrScattSigAtInc=$pbpDF+ScattPrefix+ksSP2PBPscattSigAtIncand
	if (!WaveExists(BCdiam) || !WaveExists(CurrScattSigAtInc))
		NVAR SAI_calib_flag= $ksSP2PathToToolkitPanelFldr + ksSP2useSAIforScattCalib
		SAI_calib_flag= 0
		// Do not throw an error message -- this function may be called during file loading
		SP2_postErrorMsg("SAI calibration failed and was disabled: did not find the BC diameter wave and/or SAI wave. Ignore this message if you did not intend to cause it.")
		return 0
	endif

// Need the output of this function first:
	SP2_ScattAtIncOptSizing(ctrlname, pbpfldrfp=pbpDF, BeamShapeFldrFP=beamShapeDF, PrintInfo=0, GraphMode=doGraphs)
	
	// used vars/str
	Svar Panel_LEOrefractIndexPair=$ksSP2PathToToolkitPanelFldr + ksSP2leoRefractIndexPair
	string MieDataSubFldrPP= Panel_LEOrefractIndexPair
	// used waves 
	wave /Z BCdiam= $pbpDF+IncPrefix+ksSP2pbpBCdiam	
	wave /Z BCpeak= $pbpDF+IncPrefix+ksSP2PBPtracefitPeakHt
	wave /Z BCsaturated= $pbpDF+ksSP2BBLGprefix+	ksSP2PBPsaturated
	wave /Z SCsaturated= $pbpDF+ScattPrefix+ksSP2PBPsaturated
wave /Z CurrScattSigAtInc=$pbpDF+ScattPrefix+ksSP2PBPscattSigAtIncand

	//access MIE data for coated/uncoated BC particles particles
	wave MieDcore=$ksSP2PathToMieCoatedBCfldr + MieDataSubFldrPP + ksSP2MIE_Dcore
	wave MieScatCross=$ksSP2PathToMieCoatedBCfldr + MieDataSubFldrPP + ksSP2MIE_ScatCross
	variable nDcore=numpnts(MieDcore)
	//extract scattering cross section of pure BC from Mie matrix
	make /free/n=(nDcore) MieScatCrosBCcores=MieScatCross[p][0]
	wave /Z Curr_SAI_FitSigNorm=$SP2_PBPfldrfp2SAIfldrfp(pbpDF) + ScattPRefix+ksSP2SAIFitSigNorm		
	// new waves
	variable i, nRows= numpnts(BCdiam)
	make /o/n=(nRows) $SP2_PBPfldrfp2SAIfldrfp(pbpDF)+ScattPrefix+ksSP2SAIbasedScattCoefRaw /WAVE=rawSAIscattCoef
	make /o/n=(nRows) $SP2_PBPfldrfp2SAIfldrfp(pbpDF)+ScattPrefix+ksSP2SAIbasedScattCoef 	 /WAVE=SAIscattCoef
	multithread rawSAIscattCoef= nan
	FastOp SAIscattCoef= rawSAIscattCoef
	note /k rawSAIscattCoef, "scattering calibration coefficient obtained by assuming a perfect incandescence calibration and the currently-selected BC refractive index "+Panel_LEOrefractIndexPair+";"
	note rawSAIscattCoef, "Saturated values removed;"
	note /k SAIscattCoef, ScattPrefix+ksSP2SAIbasedScattCoefRaw+" after filtering saturated signals and small BC (= SAI below scattering detector's LOQ)"
	
	
	for (i=0; i<nRows; i+=1)
		// based on the following key line from the normalization function:
		//		Curr_SAI_FitSigNorm=CurrScattSigAtInc/SAI_NormFactPosInLaser/YAGpower
		//		scatt_CS_au = scatt_signal / relative_beam_power / YAGpower
		// and 
		//		scatt_CS= scatt_CS_au / scattCalibCoef
		// which imply
		//		scattCalibCoef = scatt_CS_au / scatt_CS
		// so what we do is get scatt_CS from the Mie tables + BC mass,
		// and then define scattCalibCoef.
		if ((BCdiam[i] > MieDcore[0]) && (BCdiam[i] < MieDcore[numpnts(MieDcore)-1]))
			rawSAIscattCoef[i]= BinarySearchInterp(MieDcore, BCdiam[i])			// index of predicted scatt CS in mie wave
			rawSAIscattCoef[i]= MieScatCrosBCcores[rawSAIscattCoef[i]]			// the predicted scatt CS
			rawSAIscattCoef[i]= Curr_SAI_FitSigNorm[i] / rawSAIscattCoef[i]		// defined above		
		endif
	//// CurrScattCalCoef=rawSAIscattCoef[i] // diagonstic--apply immediately
	endfor
	
	// remove invalid points
	multithread rawSAIscattCoef= BCsaturated[p] || SCsaturated[p] ? nan : rawSAIscattCoef[p]	// these results are truly useless
	multithread SAIscattCoef = ((CurrScattSigAtInc[p] < SC_LOQ) || (BCdiam[p] > maxBC) || (BCpeak[p]<BB_LOQ)) ? nan : rawSAIscattCoef[p]	

	// smooth out noise
	variable medianReplaceEvery= min(smoothN, numpnts(SAIscattCoef))
	if (smoothN >= 0) // ==> user can disable with negative value
		Smooth/M=0 medianReplaceEvery, SAIscattCoef
	
		// replace NaNs with last good value. (box smoothing was considered, but is slow)
		variable firstValidIdx= firstNonNaN(SAIscattCoef, indx=1)
		variable lastValid= SAIscattCoef[firstValidIdx]
		variable j, np=numpnts(SAIscattCoef)
		for (j=0; j<np; j+=1)
			if (isnan(SAIscattCoef[j]) || j<firstValidIdx)
				SAIscattCoef[j]= lastValid
			else
				lastValid= SAIscattCoef[j]
			endif
		endfor
		note SAIscattCoef, "NaNs replaced by last-good-value"
	endif
	
	
	if (doPrint)
		printf "SP2_SAIcalibration(\"\", ScattPrefix= \"%s\", ", ScattPrefix
		printf "IncPrefix=\"%s\", smoothN=%g, maxBC=%g, doPrint=0, doGraphs=0)", IncPrefix, smoothN, maxBC
		printf "\r"
	endif
	
	if (doGraphs)
		SP2_SAIgr_SAIcalibration(pbpDF=pbpDF, ScattPrefix=ScattPrefix, IncPrefix=IncPrefix)
	endif
	
	return 1
end


Function SP2_LEOgetSPHGBeamShape(SCprefix, SPprefix, [pbpfldrfp, PosMode, ScattPkHtMin, StatsMode, TraceLenB4Pk])
	//This function determines the median beam shape of purely scattering particles
	//return value: 0; not used
	//note: this function may not be up to date with the latest toolkit version
	//martin.gysel@psi.ch; 20/05/2010, 21/05/2010, 22/05/2010, 23/05/2010, 08/09/2010, 01/12/2010, 14/09/2011
	string pbpfldrfp		//full path to folder containing the PBP data
						//default: browse for folder
	variable PosMode		//1: use information from split detector (standard)
						//0: use centre position from Gaussian fit to scattering trace
						//default: prompt
						//note: split detector (PosMode=1) can only be used if LEO-fit preparation has previously been done.
	variable ScattPkHtMin	//minimum peak height of scattering traces of purely scattering particles to be considered for the median beam shape
							//default: prompt
	variable StatsMode	//0: determine median beam shape only
						//1: determine 10th, 25th, median, 75th and 90th percentiles of beam shape.
						//default: prompt
	variable TraceLenB4Pk	//length of trace [# data points] before peak centre to be considered for median beam shape
	string SCprefix		//prefix of scattering channel to be used:
						//e.g. ksSP2SCHGprefix or ksSP2SCLGprefix
						//note: this cannot be a combined channel
	string SPprefix		//prefix of position sensitive detector (split detector) channel to be used
						//e.g. ksSP2SPHGprefix, ksSP2SPLGprefix or ksSP2PHPLprefix
						//note, this can be a combined channel

	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	variable mustprompt=0
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(startingDF=savedDF, type="PBP") // jcc :: was : BrowseForFolder("Select folder containing the SP2's PBP data:", StartPath=savedDF)
		if (stringmatch(pbpfldrfp,"cancelled"))
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message			
		endif
	endif
	string rawfldrfp=SP2_PBPfldrFP2RawFldrFP(pbpfldrfp)
	string leofldrfp=SP2_PBPfldrFP2LEOfldrFP(pbpfldrfp)
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	CreateFoldersOfFullPath(leofldrfp, 0)
	CreateFoldersOfFullPath(LeoBeamCalibSubFldrFP, 0)
	CreateFoldersOfFullPath(LeoTraceFitSubFldrFP, 0)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	if (paramisdefault(PosMode))
		MustPrompt=1
		PosMode=1
	endif
	if (paramisdefault(StatsMode))
		MustPrompt=1
		StatsMode=0
	endif
	if (paramisdefault(ScattPkHtMin))
		MustPrompt=1
		ScattPkHtMin=kSP2LEOprepScattMinCutBeamShape
	endif
	if (paramisdefault(TraceLenB4Pk))
		MustPrompt=1
		TraceLenB4Pk=kSP2LEOusB4Pk4Shape*SamplingRateRawDataMHz	//convert value of default constant from [us] to [# data points]
	endif
	if (mustprompt)
		PosMode+=1
		StatsMode+=1
		string PosPopList="use Gaussian fit to scattering trace;use split detector"
		string StatsPopList="median only;10th, 25th, median, 75th and 90th percentiles"
		prompt PosMode, "Determining beam position:", popup, PosPopList
		prompt StatsMode, "Beam shape statistics:", popup, StatsPopList
		prompt ScattPkHtMin, "Minimum peak height of scattering traces to be considered:"
		prompt TraceLenB4Pk, "Trace length [# data points] before peak centre to be considered:"
		doprompt "Beam Shape", PosMode, StatsMode, ScattPkHtMin, TraceLenB4Pk
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message				
		endif
		PosMode-=1
		StatsMode-=1
	endif
	//access raw data waves
	setdatafolder $rawfldrfp
	wave Split_TraceMat=$SPprefix+ksSP2rawtracemat
	variable nRows=dimsize(Split_TraceMat,0)
	variable tracelen=dimsize(Split_TraceMat,1)
	//access PBP waves
	setdatafolder $pbpfldrfp
		//scattering channel
		wave Split_Offset=$SPprefix+ksSP2PBPsplitBasicOffset
		wave Scatt_PeakHt=$SCprefix+ksSP2PBPscattGausspeakHeight			
		wave Scatt_PeakPos=$SCprefix+ksSP2PBPscattGausspeakPos				
		wave Split_Saturated=$SPprefix+ksSP2PBPsaturated
		//PSD (split detector) channel
		wave Split_FilteredSplitPos=$SPprefix+ksSP2PBPsplitFilteredSplitPos		
		//various post processing data
		wave ClassificationByMinCut=$ksSP2pbpClassificationByMinCut				
	//access waves in LEO beam and calibration data subfolder
	setdatafolder $LeoBeamCalibSubFldrFP	
	wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta
	wave LEOsplit2incandDelta=$ksSP2LEOsplit2incandDelta			
	//access waves in LEO trace fit subfolder
	setdatafolder $LeoTraceFitSubFldrFP	
	wave LEOfitBeamPos=$ksSP2LEOfitBeamPos		
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2beamShape
	string tmpfldrpath=getdatafolder(1)
	setdatafolder $tmpfldrpath
	make /o/n=0 currtrace
	//get beam centre positions
	setdatafolder $tmpfldrpath
	make /o/n=(nrows) CentrePos=NaN
	if (PosMode==0)
		CentrePos=Scatt_PeakPos[p]
	elseif (PosMode==1)
		CentrePos=Split_FilteredSplitPos[p]+LEOfitSplit2centreDelta[0]
	endif
	//get list of pure scattering particles
	setdatafolder $tmpfldrpath
	make /o/n=(nrows) PureScattList=NaN
	variable rind
	variable IncEvent=kSP2BBHGeventBitVal+kSP2NBHGeventBitVal+kSP2BBLGeventBitVal+kSP2NBLGeventBitVal
	variable nPureScatt=0
	for (rind=0; rind<nRows; rind+=1)
		if (!(ClassificationByMinCut[rind]&IncEvent))
			//pure scattering particle
			if ((Scatt_PeakHt[rind]>ScattPkHtMin) && !Split_Saturated[rind])
				//scattering peak height above selected threshold and not saturated
				PureScattList[nPureScatt]=rind
				nPureScatt+=1
			endif
		endif
	endfor
	redimension /n=(nPureScatt) PureScattList
	//get normalized beam shapes and put them into beam and calibration data subfolder
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=(nPureScatt,tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeData=NaN
	wave BeamShapeData=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeData
	variable psind, currindex, currshift
	for (psind=0; psind<nPureScatt; psind+=1)
		currindex=PureScattList[psind]
		currshift=CentrePos[currindex]-TraceLenB4Pk
		if (numtype(currshift)==2)
			BeamShapeData[psind][]=NaN
			continue
		endif
		redimension /n=(tracelen-currshift) currtrace
		currtrace=NaN
		currtrace=Split_TraceMat[currindex][p+currshift]-Split_Offset[currindex]
		currtrace/=Scatt_PeakHt[currindex]
		BeamShapeData[psind][]=currtrace[q]
	endfor
	//beam centre and mean split position (LEO beam and calibration data subfolder)
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=1 $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeCentrePos=TraceLenB4Pk
	wave BeamShapeCentrePos=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeCentrePos
	make /o/n=1 $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos=TraceLenB4Pk-LEOfitSplit2centreDelta[0]
	wave BeamShapeSplitPos=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos
	make /o/n=1 $ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos=BeamShapeSplitPos+Percentile_of_ListNaN(LEOsplit2incandDelta, kSP2LEOprepIncandDelayEarlyPerc)
	wave BeamShapeIncEarlyPos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos
	make /o/n=1 $ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos=BeamShapeSplitPos+Percentile_of_ListNaN(LEOsplit2incandDelta, kSP2LEOprepIncandDelayLatePerc)
	wave BeamShapeIncLatePos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos
	//statistics of normalized beam shapes (LEO beam and calibration data subfolder)
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=(tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc50=NaN
	wave BeamShapePerc50=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc50
	Percentiles_From_MatrixCols(0.50, BeamShapePerc50, BeamShapeData)
	wavestats /q BeamShapePerc50
	variable normfact=1
	BeamShapePerc50/=normfact		//renormalize maximum peak height to unity
	if (StatsMode)
		//extra statistics only if selected
		setdatafolder $LeoBeamCalibSubFldrFP
		make /o/n=(tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc10=NaN
		wave BeamShapePerc10=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc10
		Percentiles_From_MatrixCols(0.10, BeamShapePerc10, BeamShapeData)
		BeamShapePerc10/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc25=NaN
		wave BeamShapePerc25=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc25
		Percentiles_From_MatrixCols(0.25, BeamShapePerc25, BeamShapeData)
		BeamShapePerc25/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc75=NaN
		wave BeamShapePerc75=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc75
		Percentiles_From_MatrixCols(0.75, BeamShapePerc75, BeamShapeData)
		BeamShapePerc75/=normfact
		make /o/n=(tracelen) $ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc90=NaN
		wave BeamShapePerc90=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapePerc90
		Percentiles_From_MatrixCols(0.90, BeamShapePerc90, BeamShapeData)
		BeamShapePerc90/=normfact
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killwaves /z BeamShapeData
	killdatafolder /z $tmpfldrpath
	return 0
end


// Calculate time-resolved scattering cross-sections, a la Laborde et al 2012 Figure 1.
Function SP2_TimeResolvedSizing([RawFP, BeamFP, SPHG_RelCal, Mode, BeamLOD, SCHG_LOD, noPrint, noGraph, getCentred])
// Martin.Gysel@psi.ch, draft function [toolkit v4110]
// joel.c.corbin+sci@gmail.com, expanded, 2016-01-20 [v4111]
//
// Note: this function has been hardcoded to use SCHG and SPHG.  If you want to
// use SCLG and SPLG, then you must change the last tab of the panel to load the
// data with label "HG".
//
	string RawFP			// full path to SP2 raw data folder
	string BeamFP			// full path to folder containing the beam shape data
	variable SPHG_RelCal	// calibration factor of SPHG channel relative to SCHG channel incl. sign
	variable SCHG_LOD		// minimum valid scattering peak height. Used to filter out bad split points.
	variable BeamLOD		// [default 1e-4] Minimum for a meaningful value of the reference beam, as a fraction.
	variable noGraph		// set to disable slider creation
	variable noPrint		// set to disable printing function inputs
	variable Mode 			// experimental feature:
				// Mode==0 -> returns scattering signal / beam, where beam is 'beam shape'
				// Mode==1 -> returns scattering cross section  (signal/beam/laser power)
				// Mode==2 -> returns optical size, VERY ROUGH
					// this would be valid if no evaporation (looks up signal/beam/laser_power in Mie tables)
					// however, the RI used is the BC core.  So it is only valid with evaporation.
	variable getCentred		// gets centred data (in addition to other data in wave SCHG_CentredTRscaCS). Normally disabled to save time.
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	
	
	// preparation---evaluate inputs and set default values 
	if (ParamIsDefault(mode))
		mode=1
	endif
	if (ParamIsDefault(BeamLOD))
		BeamLOD=1e-3
	endif
	if (ParamIsDefault(SCHG_LOD))
		SCHG_LOD= get_LOD_SCHG() // could be LOQ
	endif
	if (ParamIsDefault(RawFP))
		RawFP= SP2_getFolder(startingDF=savedDF, type="raw")
	endif
	if (ParamIsDefault(BeamFP))
		BeamFP= SP2_getBeamShapeFolder()
	endif
	if (!ParamIsDefault(getCentred) && (getCentred==0))
		print now() + "To use getCentred=0, first set hackFixedShift20180604 to zero in graphprocs. [code to be updated]"
	endif
	if (ParamIsDefault(SPHG_RelCal))
		if (DataFolderExists(BeamFP))
			setdatafolder $BeamFP
			wave /Z relCal= $ksSP2SPHGprefix + ksSP2LEOPSDcalFactFit // == SPHG_CalFactMeasFit in v4111. 
			if (WaveExists(relCal))
				StatsQuantiles /iNaN /Q relCal
				if (!((V_Median==V_Q25) && (V_Median==V_Q75)))
					print "Split calibration factor is uncertain--SPHG_CalFactMeasFit value varies--check function for details: ", GetRTStackInfo(0)
				endif
				SPHG_RelCal= V_Median
			else
				SPHG_RelCal= -1
				print "No SPHG_RelCal provided, and none found in the beam shape folder--using -1!"
			endif
		endif
	endif
	
	
// print final/overall command to history
	if (!noPrint)		
		string cmd=""
		cmd+=GetRTStackInfo(1)+"("
		cmd+="RawFP=\""+RawFP+"\", "
		cmd+="BeamFP=\""+BeamFP+"\", "
		cmd+="Mode="+num2str(Mode)+", "
		cmd+="SPHG_RelCal="+num2str(SPHG_RelCal)+", "
		cmd+="noGraph="+num2str(noGraph)+", "
		cmd+="noPrint=1)" //"+num2str(noPrint)+")"
		print cmd
	endif
	
	
	
// preparation
	// data folders
	string PBPfp=SP2_raw2pbp(RawFP)
	//access raw data
	setdatafolder $RawFP
	wave /Z SCHG_data
	wave /Z SPHG_data
	if (!WaveExists(SCHG_data) || !WaveExists(SPHG_data))
		SP2_abort("Did not find the raw data for SCHG and SPHG in " +RawFP+ ", aborting.", gotoDF=savedDF)
	endif
	variable nRows=dimsize(SCHG_data,0) // == n particles
	variable nCols=dimsize(SCHG_data,1) // == n time points
	//access PBP data
	setdatafolder $PBPfp
	wave SPHG_FilteredSplitPos
	wave SCHG_FitPeakHt
	wave SCHG_FitOffset
	wave SPHG_BasicOffset
	//access beam shape etc.
	setdatafolder $BeamFP
	wave /Z BeamShapeCentrePos //n==1
	wave /Z BeamShapePerc50
	wave /Z BeamShapeSplitPos	//n==1
	if (!WaveExists(BeamShapeCentrePos) || !WaveExists(BeamShapeCentrePos) || !WaveExists(BeamShapeSplitPos))
		SP2_abort("Did not find beam shape waves in " +BeamFP+ "; aborting.", gotoDF=savedDF)
	endif
	
//prepare results wave
	setdatafolder $RawFP
	make /o/n=(nRows,nCols) SCHG_NormScattAmp=NaN
	make /o/n=(nRows,nCols) SPHG_NormScattAmp=NaN
//	make /o/n=(nRows,nCols) SCHG_CentredTRscaCS=NaN // time-resolved scattering cross section with beam centred at nCols/2
	note SCHG_NormScattAmp, "Time-resolved SCHG scattering signal, normalized to "
	note SPHG_NormScattAmp, "Time-resolved SCHG scattering signal, normalized to "
//	note SCHG_CentredTRscaCS, "Time-resolved and centred SCHG scattering signal, normalized to "
	if (mode<=1)
		note SCHG_NormScattAmp, "beam intensity profile"
		note SPHG_NormScattAmp, "beam intensity profile"
//		note SCHG_CentredTRscaCS, "beam intensity profile"
	endif
	if (mode<=2)
		note SCHG_NormScattAmp, " and calibrated laser power"
		note SPHG_NormScattAmp, " and calibrated laser power"
//		note SCHG_CentredTRscaCS, " and calibrated laser power"
		wave /Z YAGpower= $removeEnding(RawFP, ":")+ksSP2YAGpower
		variable CurrScattCalCoef= SP2_get_scattCoef("SCHG")
	endif
	if (mode<=3)
		note SCHG_NormScattAmp, " before conversion to Dopt using BC refractive index"
		note SPHG_NormScattAmp, " before conversion to Dopt using BC refractive index"
//		note SCHG_CentredTRscaCS, " before conversion to Dopt using BC refractive index"
		wave /WAVE D_andScaCS= SP2_get_MieDcore_and_scatCS()
		wave /D MieDcore= D_andScaCS[0]
		wave /D scatCS  = D_andScaCS[1]
	endif
	
// use a 'beam LOD': avoid dividing by zero/negatives with the beam shape wave
	duplicate /free BeamShapePerc50, BeamShapeCleaned							// to avoid dividing by zero
	BeamShapeCleaned= BeamShapePerc50[p]>BeamLOD ? BeamShapePerc50 : nan		// I didn't follow toolkit rules & create a constant here :) jcc
	variable BeamMaxAmp=BeamShapePerc50[BeamShapeCentrePos[0]] 					// theoretically & normally unity
	variable BeamSplitTime=BeamShapeSplitPos[0]
	
																				// todo: use MatrixOp instead for speed
//size dependent optical sizing
	variable rind, cind, currSplitTime, currBaselineSCHG, currBaselineSPHG
	//loop over traces (rows)
	for (rind=0; rind<nRows; rind+=1)
		currSplitTime=SPHG_FilteredSplitPos[rind]
		if (isnan(currSplitTime))
			continue
		elseif (SCHG_FitPeakHt[rind] < SCHG_LOD)
			continue
		endif
		currBaselineSCHG=SCHG_FitOffset[rind]
		currBaselineSPHG=SPHG_BasicOffset[rind]
		//loop over data points of traces (columns)
		for (cind=0; cind<nCols; cind+=1)
			if (getCentred>0)
				// centre all data on the same index to allow statistics later ... use LEOfitBeamPos??
				SCHG_NormScattAmp[rind][cind]= 				(SCHG_data[rind][cind-(BeamSplitTime-currSplitTime)]-currBaselineSCHG) *BeamMaxAmp/BeamShapeCleaned[cind]
				SPHG_NormScattAmp[rind][cind]= 	SPHG_RelCal*(SPHG_data[rind][cind-(BeamSplitTime-currSplitTime)]-currBaselineSPHG) *BeamMaxAmp/BeamShapeCleaned[cind]

			else
				// don't centre to allow direct inspection of raw data
				SCHG_NormScattAmp[rind][cind]=			  (SCHG_data[rind][cind]-currBaselineSCHG)*BeamMaxAmp/BeamShapeCleaned[cind+(BeamSplitTime-currSplitTime)]
				SPHG_NormScattAmp[rind][cind]=SPHG_RelCal*(SPHG_data[rind][cind]-currBaselineSPHG)*BeamMaxAmp/BeamShapeCleaned[cind+(BeamSplitTime-currSplitTime)]				
			endif
			if (Mode>0)
				// from here on the name of the waves are wrong.
				// SCATTERING CROSS SECTION [UNITS ARE WRONG, SEE MARTIN'S COMMENTS AT SP2scattPeakHt2OptDiamNoCore()]
				SCHG_NormScattAmp[rind][cind] *= 1/YAGpower[rind]/CurrScattCalCoef
				SPHG_NormScattAmp[rind][cind] *= 1/YAGpower[cind]/CurrScattCalCoef
				if (Mode==2)
					// OPTICAL DIAMETER
					SCHG_NormScattAmp[rind][cind]= SP2_get_Dopt_bare_BC(CSsca= SCHG_NormScattAmp[rind][cind], MieTable= scatCS, MieDiameters= MieDcore)
					SPHG_NormScattAmp[rind][cind]= SP2_get_Dopt_bare_BC(CSsca= SPHG_NormScattAmp[rind][cind], MieTable= scatCS, MieDiameters= MieDcore)
				endif
			endif

			
	// tests: [20180604]
// Scatt norm to beam shape			
// SCHG_NormScattAmp[rind][cind]= (SCHG_data[rind][cind-(BeamSplitTime-currSplitTime)]-currBaselineSCHG) *BeamMaxAmp/BeamShapeCleaned[cind]
// // Scatt only
// SCHG_NormScattAmp[rind][cind]=	(SCHG_data[rind][cind-(BeamSplitTime-currSplitTime)]-currBaselineSCHG) 
// // BS only
// SCHG_NormScattAmp[rind][cind]= BeamShapeCleaned[cind]
			
		endfor
	endfor
	
	
	// remove invalid data by NaN'ing
	wave validMask= SP2getValidCStMask(pbpDF= PBPfp, beamShapeDF= BeamFP, SCHGcut= SCHG_LOD)
	if (0)
		print "NOT removing invalid data. Multiply SCHG_NormScattAmp by maskValidCSt / maskValidCSt to remove."
	else
		SCHG_NormScattAmp[][] *= validMask[p] / validMask[p]
	endif
//	SCHG_data[p][q]==kSP2MaxSigSCHGdefault ? nan : SCHG_NormScattAmp[p][q]
//	SPHG_NormScattAmp= SPHG_data[p][q]==kSP2MaxSigSPHGdefault ? nan : SPHG_NormScattAmp // not meaningful
	
	
	// generate summary stats waves
	SP2getCStRatio(SCHG_NormScattAmp, PBPfp, BeamFP)
	

	// todo: percentile plots [summarize data matrix]
	
	// finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	//killdatafolder /z $tmpfldrpath
	
	// graph
	if (!noGraph)
		SP2_TimeResSlider(RawFP, BeamFP, "TimeResSlider", Mode) // TODO: add y labels
	endif
	
	return 0
end

// helper function for SP2_TimeResolvedSizing.  SEE ALSO SP2getValidPeakMask()
// OUTPUT: wave maskValidCSt
function /WAVE SP2getValidCStMask([pbpDF, beamShapeDF, mask, SCHGcut])
// Retrieves a mask of completely invalid points for CS(t) data.  
// The code is a little overdone for historical (development) reasons.
// 20181107 jcc
// e.g. 	wave maskBadFromCSt= getValidCStMask(dmat)
string pbpDF, beamShapeDF
//wave CStMatrix	// output of SP2_TimeResolvedSizing(). In v4114 named SCHG_NormScattAmp.
wave mask		// optional starting mask
variable SCHGcut// Lower cutoff for valid SCHG signals
variable p0,p1	// these shuold be removed. See bad coding section below.

	//references
	if (ParamIsDefault(pbpDF))
		pbpDF= SP2_getFolder(type="PBP")
	endif
	if (ParamIsDefault(beamShapeDF))
		beamShapeDF= SP2_getBeamShapeFolder()
	endif
	wave splitPos=		$pbpDF		+ "SPHG_FilteredSplitPos"
	wave SCFitPeakHt=	$pbpDF		+ "SCHG_FitPeakHt"	
	wave SCFitPeakEnd=	$pbpDF		+ "SCHG_FitPeakEnd"
	wave SCFitPeakStart=$pbpDF		+ "SCHG_FitPeakStart"
	wave SCsaturated=	$pbpDF		+ "SCHG_saturated"	
	wave beamShape=		$beamShapeDF+ "BeamShapePerc50"
	
	// prep
	if (ParamIsDefault(SCHGcut))
		SCHGcut= get_peak_LOQ("SCHG")
	endif
	make /d/o/n=(numpnts(splitPos)) $(pbpDF + "maskValidCSt")/wave=maskValidCSt=1
	note /k maskValidCSt, "Valid particle mask from time-resolved scattering cross-section. 1==good, 0==bad. Created by SP2getValidCStMask() on " + now()
	note maskValidCSt, "Filters:" // added to below
	if (waveExists(mask))
		maskValidCSt= isnum(mask[p])
		note maskValidCSt, "Custom filter from wave " + getWaveFullPathStr(mask)
	endif
	
// It was considered to make a coincidence filter apply here and decided not to. 
// However, CSt provides very useful coincidence information. -- jcc 181108
//
//	if (ParamIsDefault(normAtBeamPct))
//		NVAR LEOfitRange	 = $(ksSP2PathToToolkitPanelFldr + ksSP2LEOfitRange) // % of mode to fit
//		normAtBeamPct= LEOfitRange/100
//	else
//		normAtBeamPct/=100
//	endif
//	// p0= getIndex(normAtBeamPct, beamshape, tol=0.01)
//	// p1= getIndex(normAtBeamPct, beamshape, tol=0.01, rev=1)
//	// assert(p0!=p1, errmsg="Sorry, bad coding, need to tweak tol parameter.")
//	p0= 12
//	p1= 69
//	jprint("To do: remove hard coding of beam shape start and stop points [C5BI2]")
//	dmat[p][p1] / dmat[p][p0] < 1e5  ??? some kind of coincidence filter???  Hard to fix the value... 
	
	// do mask
	maskValidCSt*= SCFitPeakHt[p] < SCHGcut 	? 0 : 1
	note maskValidCSt, "Removed points with fit scattering peak height below " + num2str(SCHGcut)
	
	maskValidCSt*= isnan(splitPos[p]) 		? 0 : 1
	note maskValidCSt, "Removed points with missing split position"
	
	maskValidCSt*= (isnan(SCFitPeakStart[p])	||	SCFitPeakStart[p]==0)		? 0 : 1	// invalid fitted peak start
	variable V_maxPkEnd= numpnts(beamshape) - 1 // == # of columns in data matrix
	maskValidCSt*= (isnan(SCFitPeakEnd[p]) 		||	SCFitPeakEnd[p]==V_maxPkEnd)? 0 : 1	// invalid fitted peak end
	note maskValidCSt, "Removed points without valid scattering peak baseline (peak touching edge of saved event data) or failed scattering fit"
	
	maskValidCSt*= SCsaturated[p]				? 0 : 1
	note maskValidCSt, "Removed points with saturated scattering signal"
	
	return maskValidCSt
end


// A function to filter out invalid particles as best as possible.
function /WAVE SP2getValidPeakMask(chan, [pbpDF, beamShapeDF, mask, LOQ])
// This function should be improved to be a cousin of SP2_ClassificationWaveCreator().
//
// Creates a mask of invalid particles in the specified PBP data folder.
// Developed while working on SP2_TimeResolvedSizing(). 
// Other filters should be added here later, and the filter should be applied
// to all particles (events) in future.
// 20181109 jcc
// e.g. 	wave maskBadFromCSt= getValidCStMask(dmat)
string chan 		// SCHG, SCLG, BBHG, [...]
string pbpDF
string beamShapeDF	// ONLY if provided, mask according to valid split positions.
wave mask			// optional starting mask
variable LOQ		// Lower cutoff for valid signals
variable p0,p1		// these shuold be removed. See bad coding section below.

	//references
	if (ParamIsDefault(pbpDF))
		pbpDF= SP2_getFolder(type="PBP")
	endif
	if (ParamIsDefault(beamShapeDF))
//		beamShapeDF= SP2_getBeamShapeFolder()
		variable requireValidSplit= 0
	else 
		wave beamShape=		$beamShapeDF+ "BeamShapePerc50"
		wave splitPos=		$pbpDF	+ chan + "_FilteredSplitPos"
		requireValidSplit= 1
	endif

	chan= grepList(ksSP2allchanPrefixList, chan)[1,4]	  						// result is like "SCHG" for both "SCHG" or ":SCHG_"
	wave fitPeakHt=		$pbpDF	+ chan + "_FitPeakHt"	
	wave fitPeakEnd=	$pbpDF	+ chan + "_FitPeakEnd"
	wave fitPeakStart=	$pbpDF	+ chan + "_FitPeakStart"
	wave saturated=		$pbpDF	+ chan + "_saturated"	
	
	// prep
	if (ParamIsDefault(LOQ))
		LOQ= get_peak_LOQ(chan)
	endif
	make /d/o/n=(numpnts(fitPeakHt)) $(pbpDF + "maskValid" + chan)/wave=maskValid=1
	note /k maskValid, "Valid particle mask according to the peak-detection algorithm for this channel.\r1==good, 0==bad.\rCreated by SP2getValidPeakMask() on " + now()
	note maskValid, "Filters:" // added to below
	if (waveExists(mask))
		maskValid= isnum(mask[p])
		note maskValid, "Custom filter from wave " + getWaveFullPathStr(mask)
	endif
	if (requireValidSplit)
		maskValid*= isnan(splitPos[p]) 		? 0 : 1
		note maskValid, "Removed points with missing split position"
		// using beam shape data, one could also attempt a coincidence filter
		// based on CS(t) from SP2_TimeResolvedSizing()...displ
		variable nPts= numpnts(beamShape)
	else
		wave NumberOfPoints= $removeEnding(SP2_pbp2raw(pbpDF), ":") + ksSP2configSubFldr + ksSP2configNumberOfPoints
		nPts= NumberOfPoints[0]
	endif
	
	// do masking
	maskValid*= fitPeakHt[p] < LOQ 	? 0 : 1
	note maskValid, "Removed points with fit peak height below " + num2str(LOQ)
	
	maskValid*= (isnan(fitPeakStart[p])	||	fitPeakStart[p]==0)		? 0 : 1				// invalid fitted peak start
	maskValid*= (isnan(fitPeakEnd[p]) 	||	fitPeakEnd[p]==nPts-1)	? 0 : 1				// invalid fitted peak end
	note maskValid, "Removed points without valid peak baseline (peak touching edge of saved event data) or failed peak fit"
	
	maskValid*= saturated[p]				? 0 : 1
	note maskValid, "Removed points with saturated signal"

	return maskValid
end

// helper function for SP2_TimeResolvedSizing. Generate ratio of CS(t) at +3% / -3% of beam.
function SP2getCStRatio(CStMatrix, pbpDF, beamShapeDF, [mask, SAImode, normAtBeamPct])
// 3% is not actually hard-coded but assumed that you used this LEO value.
// The function will use the Panel's current LEO value.
// This function assumes that you have run SP2_TimeResolvedSizing() first.
// See input descriptions for more help.
//
// e.g.
// cd PBPDF
// SP2getCStRatio($SP2_pbp2raw("")+"SCHG_NormScattAmp", getdatafolder(1), getdatafolder(1) + "'LEO':'BeamAndCalib':") // norm at -PANEL% and +PANEL%
// SP2getCStRatio($SP2_pbp2raw("")+"SCHG_NormScattAmp", getdatafolder(1), getdatafolder(1) + "'LEO':'BeamAndCalib':", normAtBeamPct=cmplx(-3,20)) // norm at -3% and +20% 
//
// 1801107 jcc
wave CStMatrix	// output of SP2_TimeResolvedSizing(). In v4114 named SCHG_NormScattAmp.
wave mask		// optional mask, note that invalid data should already be masked out of SCHG_NormScattAmp by default
string pbpDF, beamShapeDF
variable SAImode	// If 0 [default], function behaves as described above.
					// If 1, function treats normAtBeamPct to describe the # of points to move backwards from BBHG_FitPeakPos. 
variable /C normAtBeamPct	// Provide this if you don't want to normalize at the panel's values. 
		// provide cmplx(-before,after) as two values or just (before) for identical values.
		// The function will search the beam shape wave for abs(after) starting form the point where abs(before) is found.
		// e.g. cmplx(-3,50) will use the 3% value on the left hand side and 50 value on the right hand side.
	
	if (ParamIsDefault(normAtBeamPct))
		NVAR LEOfitRange	 = $(ksSP2PathToToolkitPanelFldr + ksSP2LEOfitRange) // % of mode to fit
		normAtBeamPct= cmplx(LEOfitRange, -LEOfitRange)
	elseif (imag(normAtBeamPct)==0)
		normAtBeamPct= cmplx(real(normAtBeamPct), -real(normAtBeamPct))
	else
		normAtBeamPct= cmplx(real(normAtBeamPct), imag(normAtBeamPct))
	endif
	normAtBeamPct/=100 // UNIT CONVERSION [% --> fraction]
	
	// prep
	wave beamShape= $beamShapeDF + "BeamShapePerc50"
	variable p0,p1,pmid // == position of first,last,and 100% CS(t) points.  
	p0=floor(getIndex(abs(real(normAtBeamPct)), beamShape, before=1))			//	floor/ceil choice is arbitrary here.
	if (imag(normAtBeamPct)>0)
		pmid=ceil(getIndex(1, beamShape, before=1))
		p1= ceil(getIndex(abs(imag(normAtBeamPct)), beamShape, before=1, start=pmid))
	else
		p1= ceil(getIndex(abs(imag(normAtBeamPct)), beamShape, before=1, start=p0))
	endif
	print "real/imag", p0,p1, normAtBeamPct
	
	make /o/n=(DimSize(CStMatrix,0)) $ensureEnding(pbpDF, ":") + "CStRatio" /WAVE= CStRatio
	
	if (SAImode==0)
		// normal mode
		variable do3pointSmooth=0
		if (do3pointSmooth) // [result: negligible effect]
			CStRatio= (CStMatrix[p][p1-1] + CStMatrix[p][p1] + CStMatrix[p][p1+1]) / (CStMatrix[p][p0-1] + CStMatrix[p][p0] + CStMatrix[p][p0+1])
		else
			variable minVal= 0 // 1e-5
			if (minVal)
				CStRatio= CStMatrix[p][p1] / max(minVal, CStMatrix[p][p0])
			else
				CStRatio= CStMatrix[p][p1] / CStMatrix[p][p0]
			endif
		endif
		note /K CStRatio, "PBP ratio of time-resolved scattering cross section = CSt("+num2str(real(normAtBeamPct)*100)+"%)/CSt("+num2str(imag(normAtBeamPct)*100)+"%)"
		note CStRatio, "AXISLABEL:CSt("+num2str(imag(normAtBeamPct)*100)+"%)/CSt("+num2str(real(normAtBeamPct)*100)+"%)"
	else			
		// count-back-from-incandescence mode [alpha!! may be buggy]
		print "NOT GUARANTEED BUG FREE!"
		
		normAtBeamPct*=100 // UNDO UNIT CONVERSION 
		wave peakPos= $pbpDF + "BBHG_FitPeakPos"
		// Step back from PeakPos by Re() and Im() # steps.
		// But we have to account for the earlier centring of CS(t) here! (last term of CStMatrix column index)
		wave /Z beamSplitPos_wav= $beamShapeDF+ "BeamShapeSplitPos"	//n==1
		variable VbeamSplitPos= beamSplitPos_wav[0]
		wave splitPos= $pbpDF + "SPHG_FilteredSplitPos"
		CStRatio = CStMatrix[p][peakPos[p] - abs(real(normAtBeamPct)) + (VbeamSplitPos-splitPos[p])] 
		CStRatio/= CStMatrix[p][peakPos[p] - abs(imag(normAtBeamPct)) + (VbeamSplitPos-splitPos[p])]
		
		print "real/imag", p0,p1, normAtBeamPct
	endif
	
	if (waveExists(mask))
		CStRatio *= mask/mask
	endif
end

	
// Returns a wave/WAVE of {MieDcore, MieScatCross} for RI selected on LEO panel
function /WAVE SP2_get_MieDcore_and_scatCS()
// joel.c.corbin+sci@gmail.com 2016-02-16 // extracted from the SAI function 

	DFREF sdf= getdatafolderDFR()

	//copied from SAI function
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar Panel_LEOrefractIndexPair=$ksSP2leoRefractIndexPair	

	setdatafolder $ksSP2PathToMieCoatedBCfldr
	string MieDataSubFldrPP=Panel_LEOrefractIndexPair	
	setdatafolder $MieDataSubFldrPP
	wave MieDcore=$ksSP2MIE_Dcore
	wave MieScatCross=$ksSP2MIE_ScatCross	// this is the full matrix [Dcore x coating_thickness]
	make /free /n=(numpnts(MieDcore)) MieScatCross_Core= MieScatCross[p][0]

	make /free /wave output= {MieDcore, MieScatCross_Core}

	cd sdf
	return output
end

// Get the Dopt corresponding to the given scattering cross section, for bare BC
function SP2_get_Dopt_bare_BC([CSsca, MieTable, MieDiameters])
// invalid input? returns nan
// out of range?  returns nan (this breaks prior SP2toolkit convention...)
// joel.c.corbin+sci@gmail.com 2016-02-16 // extracted from the SAI function 
variable CSsca
wave MieTable
wave MieDiameters

variable D_opt
variable idx_core

	//scattering data available
	//=>check availability of MIE data
	if ( (CSsca<MieTable[0]) || (CSsca>MieTable[inf]) )
		//MIE data missing
		D_opt=nan // -999
	else
		//MIE data available
		//=>search scattering amplitude in Mie data and read corresponding BC core diameter
		idx_core=BinarySearchInterp(MieTable, CSsca)
		if (numtype(idx_core)==2) // nan
			D_opt=nan
		else
			D_opt=MieDiameters[idx_core]
		endif
	endif

	return D_opt
end

// returns the SP2 toolkit's current calibration coefficient
function SP2_get_scattCoef(channel4letterStr)
// Joel.Corbin 2016-02-16
string channel4letterStr 	// SCLG or SCHG
	
	string ch= channel4letterStr	
	
	//access calibration coefficient of scattering channel
	SVAR calib_DF= $ksSP2PathToToolkitPanelFldr + ksSP2calibFldr	//	root:SP2toolkit:Panel:CalibFldr
	string calib_DF_full= ksSP2PathToCalibDataFldr + calib_DF		//	  root:SP2toolkit:CalibData:*****
	if (DataFolderExists(calib_DF_full))
		string wavstr= calib_DF_full+":"+ch+"_"+ksSP2CalCoefBnam
		wave /Z Panel_CalCoef_scatt=$wavstr // SC*G_CalCoef
		if (WaveExists(Panel_CalCoef_scatt))
			return Panel_CalCoef_scatt[0]
			// done
		endif
	endif

	// else... failed! check no double :: in the path:
	if (!cmpstr("::", wavstr)==0)
		// one of the inputs ending with a colon is touching the other startin with one
		SP2_postErrorMsg("Bad inputs to "+GetRTStackInfo(1)+". Check constants and inputs.")
	endif
	
	return nan
end

// Get the ScattCoef wave defined from SAI.
function /WAVE SP2_get_SAI_scattCoef_wave(channel4letterStr, SAIdf)
// search these procedures for 'ksSP2SAIbasedScattCoef' or 'SAI_CALIB' for more info. 
//
string SAIdf		// the function will search for a time-resolved scattering cal
					// wave in that folder.
string channel4letterStr 	// SCLG or SCHG
	
	DFREF sdf= GetDataFolderDFR()
	if (!DataFolderExists(SAIdf))
		SP2_abort("SAI DF does not exist!")
	endif
	cd $SAIdf
	string chanPrefix= ":" + channel4letterStr + "_"
	wave /Z SAIcoefs= $chanPrefix+ksSP2SAIbasedScattCoef 
	cd sdf
	
	if (!WaveExists(SAIcoefs))
		SP2_abort("SAI calibration coefficient wave not found!")
	endif
	
	return SAIcoefs
end

// Given a channel name ("SCHG") or prefix (":SCHG_") returns its current LOQ 
function get_peak_LOQ(chanStr)
// The LOQ is defined in the Postprocessing panel under "Include in results (LOQ)"
	string chanStr
	chanStr= grepList(ksSP2allchanPrefixList, chanStr)[1,4]	  					// result is like "SCHG" for both "SCHG" or ":SCHG_"
	string LOQvarName= replaceString("SCHG", ksSP2SCHGMinCut, chanStr)			// works as long as user doesnt make irregular names here. better than listing 8 options.
	NVAR /Z LOQ= $ksSP2PathToToolkitPanelFldr + LOQvarName
	if (NVAR_Exists(LOQ))
		return LOQ
	else
		SP2_abort(GetRTStackInfo(1) + "() input '" + chanStr + "' not recognized or missing toolkit variable.\rTry recreating the panel.")
	endif
end


Function /S SP2_LEO_RetrieveRefChanPrefix(LEOchanPrefix, LeoTraceFitSubFldrFP)
	//This function retrieves the prefix of the reference channel used for the certain LEO-fit channel
	//return string: channel prefix of the reference channel
	//martin.gysel@psi.ch; 13/02/2012
	string LEOchanPrefix	//prefix of LEO-fit channel for which the reference channel prefix is to be retrieved
	string LeoTraceFitSubFldrFP		//full path to folder containing the LEO-trace fit results
		
	//preparations
	string savedDF=getdatafolder(1)
	//access info string
	setdatafolder $LeoTraceFitSubFldrFP
	Svar LEOverificSizingInfoStr=$ksSP2LEOverificSizingInfoStr			
	//get reference channel prefix
	string RefChanPrefix
	strswitch(LEOchanPrefix)
		case ksSP2SCHGprefix:
			RefChanPrefix=ksSP2SCHGprefix
			break
		case ksSP2SCLGprefix:
			RefChanPrefix=ksSP2SCLGprefix
			break
		case ksSP2SPHGprefix:
			RefChanPrefix=StringByKey(ksSP2LEOcalChanPrefixSPHGKey, LEOverificSizingInfoStr,  "=" , "\r")
			break
		case ksSP2SPLGprefix:
			RefChanPrefix=StringByKey(ksSP2LEOcalChanPrefixSPLGKey, LEOverificSizingInfoStr,  "=" , "\r")
			break
		default:
			RefChanPrefix=""			
	endswitch
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return RefChanPrefix
End


Function /S SP2_LEO_GetRefChanPrefix(LEOchanPrefix)
	//This function gets the prefix of the reference channel used for the certain LEO-fit channel from the toolkit panel
	//return string: channel prefix of the reference channel
	//martin.gysel@psi.ch; 13/02/2012
	string LEOchanPrefix	//prefix of LEO-fit channel for which the reference channel prefix is to be determined
		
	//preparations
	string savedDF=getdatafolder(1)
	//get reference channel prefix
	string RefChanPrefix
	strswitch(LEOchanPrefix)
		case ksSP2SCHGprefix:
			RefChanPrefix=ksSP2SCHGprefix		//SCHG channel always verified against itself
			break
		case ksSP2SCLGprefix:
			RefChanPrefix=ksSP2SCLGprefix		//SCLG channel always verified against itself
			break
		case ksSP2SPHGprefix:
			//access panel settings
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Svar Panel_RefChanPrefix=$ksSP2SPHGprefix+ksSP2leoSplitCalChanPrefix
			RefChanPrefix=Panel_RefChanPrefix
			break
		case ksSP2SPLGprefix:
			//access panel settings
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Svar Panel_RefChanPrefix=$ksSP2SPLGprefix+ksSP2leoSplitCalChanPrefix
			RefChanPrefix=Panel_RefChanPrefix
			break
		default:
			RefChanPrefix=""			
	endswitch
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return RefChanPrefix
End


Threadsafe Function /Wave SP2_TA_ScattFitWorker_TS(tracemat, rowindex, FitMode, nPts4PeakHt, nPts4baseline, BaselineFilter, BaselineDelta, GetMaxB4incPos, IncPeakHalfDecay, GetSAI, IncandPos, SAIstartDeltaPts, SAIendDeltaPts, MaxSigVal, SamplingRateRawDataMHz)
	//This function analyses SP2's raw traces from the scattering channels.
	//Note: This function was originally based on the procedure "SP2IncandAvgBaseFit" from DMT's PAPI software.
	//return value: Reference to wave containing the retrieved raw signal properties
	//martin.gysel@psi.ch;	10/11/2008, 11/07/2009, 18/08/2009; 06/10/2010, 26/04/2010, 27/04/2010, 18/05/2010, 26/05/2010, 28/05/2010,
	//						04/11/2010, 12/05/2011, 18/05/2011, 19/05/2011; 15/12/2011; 24/09/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable	FitMode			//fit type for scattering channel data
							//0: baseline + peak height from Gaussian fit
							//1: baseline from pretrigger points, peak height from Gaussian fit
							//2: baseline from pretrigger points, peak height from maximum value
	variable nPts4PeakHt		//number of points to be averaged for peak height of scattering signals
							//note: will be rounded to the next odd number below
							//note: must be provided if FitMode=2, ignored otherwise
	variable nPts4baseline		//number of pretrigger points to be used for determining baseline value
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							//note: must be provided if FitMode=1 or 2, ignored otherwise
	variable BaselineDelta		//full amplitude of baselinenoise; only required if BaselineFilter=1 is selected
							//note: must be provided if BaselineFilter=1 and if FitMode=1 or 2, ignored otherwise
	variable GetMaxB4incPos	//1: get maximum of the scattering signal before the incandescence peak
							//0: skip it
	variable IncPeakHalfDecay	//position of incandescence peak half decay
	variable GetSAI		//1: get scattering signal amplitude just before incandescence peak
							//0: skip it
	variable IncandPos		//position of incandescence signal
							//only required if GetSAI=1
	variable SAIstartDeltaPts	//...
							//only required if GetSAI=1
	variable SAIendDeltaPts		//...
							//only required if GetSAI=1
	variable MaxSigVal		//maximum possible value of raw signal
	variable SamplingRateRawDataMHz		//sampling rate of raw trace data [MHz]
	
								 
	//various FitMode specific preparations
	string FitHoldStr
	Variable V_fitOptions=4	//required when fitting Gaussians
	Variable V_fitError=0		//required when fitting Gaussians
	switch(FitMode)
		case 0:
			make/FREE/o/n=4 W_coef
			FitHoldStr="0000"
			break
		case 1:
			make/FREE/o/n=4 W_coef
			FitHoldStr="1000"
			break
		case 2:			
			nPts4PeakHt-=mod(nPts4PeakHt+1,2)		//make "nPts4PeakHt" odd (coerce to next odd number below)
			break
	endswitch
	//trace analysis
			//dimensions
			variable tracelen=dimsize(tracemat,1)
			//temporary waves
			make/Free/o/n=(tracelen) currtrace
			//wave for fit results
			make/Free/o/n=(16) SignalProps=NaN
				//0:		signal offset (baseline)
				//1:		saturated
				//2:		PeakHt
				//3:		MaxPos
				//4:		MaxPeakHt
				//5:		MaxB4IncPos
				//6:		MaxB4IncPeakHt
				//7:		ScattFitSigAtIncand
				//8:		FitError
				//9:		PeakPos
				//10:	PeakFWHM
				//11:	PeakChiSqr
				//12:	PeakStart
				//13:	PeakEnd
				//14:	PeakHalfRise
				//15:	PeakHalfDecay
			//loop over rows of raw data matrix and fit.
			variable VmaxGlobal, VminGlobal, VmaxlocGlobal, VnpntsGlobal
			variable tind, filtered=0, peakstartind, peakendind
			variable PeakWidthThreshold=kSP2minValidPeakWidthScatt*SamplingRateRawDataMHz
			variable WidthInitGuess=kSP2scattFWHMinitGuess*SamplingRateRawDataMHz/1.66511		//see below for meaning of factor "1.66511"
			variable HalfPeakHt, startind, endind, StartEndLevel
			do	//note: use a loop to provide a simple way to stop the evaluation half way in between ...
				//Put data from current row rowindex into temporary wave.
				currtrace=tracemat[rowindex][p]		
				//get statistics of whole trace
				WaveStats/Q currtrace
				VmaxGlobal=V_max
				VminGlobal=V_min
				VmaxlocGlobal=V_maxloc
				VnpntsGlobal=V_npnts
				//Determine baseline from pretrigger points
				if (FitMode==1 || FitMode==2)
					switch(BaselineFilter)	
						case 0:	
							//average all pretrigger points to get baseline
							WaveStats/Q/R=[0,nPts4baseline-1] currtrace
							SignalProps[0]=V_avg		//baseline
							break				
						case 1:	
							//only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
							WaveStats/Q/R=[0,nPts4baseline-1] currtrace
							variable threshold=V_min+BaselineDelta
							make/Free/o/n=(nPts4baseline) currPretrigTrace= currtrace[p]>threshold? NaN : currtrace[p]
							wavestats /Q currPretrigTrace
							SignalProps[0]=V_avg		//baseline
							break				
					endswitch
				elseif (FitMode==0)
					SignalProps[0]=VminGlobal		//set baseline to minimum reading ...
				endif
				//treat saturated particles
				if (VmaxGlobal>=MaxSigVal)
					SignalProps[1]=1		//saturated
					SignalProps[2]=VmaxGlobal-SignalProps[0]		//peak height
					break
				endif
				//global maximum					
				SignalProps[3]=VmaxlocGlobal		//MaxPos; identical to PeakPos if FitMode=2
				SignalProps[4]=VmaxGlobal-SignalProps[0] 	//MaxPeakHt; identical to PeakHt if FitMode=2 and nPts4PeakHt=1
				//local maximum of the scattering signal before the half-decay of the incandescence signal
				if (GetMaxB4incPos)
					WaveStats/Q /R=(0,IncPeakHalfDecay) currtrace
					SignalProps[5]=V_maxloc		//MaxB4IncPos
					SignalProps[6]=V_max-SignalProps[0]	//MaxB4IncPeakHt
				endif
				//signal amplitude just before incandescence peak position
				if (GetSAI)
					startind=SAIstartDeltaPts+IncandPos
					endind=SAIendDeltaPts+IncandPos
					if ( (numtype(startind)+numtype(endind))==0 )
						//proceed only if peak position is available
						WaveStats/Q /R=(startind,endind) currtrace
						SignalProps[7]=V_avg-SignalProps[0]		//ScattFitSigAtIncand
					endif
				endif
				//Determine peak height and location.
				if (FitMode==0 || FitMode==1)
					//Gaussian fit
					if(VnpntsGlobal>4) //enough valid data points for fitting
						//initial guess for Gaussian fit
						W_coef={SignalProps[0],SignalProps[4],SignalProps[3],WidthInitGuess}				
						//fit Gaussian
						CurveFit/H=FitHoldStr/N/NTHR=0/Q gauss, kwCWave=W_coef, currtrace	
						//copy fit coefficients to corresponding result waves
						SignalProps[8]=V_FitError		//FitError
						SignalProps[0]=W_coef[0]
						SignalProps[2]=W_coef[1]		//PeakHt
						SignalProps[9]=W_coef[2]		//PeakPos
						SignalProps[10]=1.66511*W_coef[3]	//PeakFWHM; Built-in gauss fit returns "width=sqrt(2)*(std. dev.)" and "FWHM=2*sqrt(2*ln(2))*(std. dev.)"
						SignalProps[11]=V_chisq	//PeakChiSqr
						//basic quality check of fit result
							//check peak position
							if (SignalProps[9]<0 || SignalProps[9]>tracelen)
								SignalProps[8]=1		//set fit error
							endif
							//check baseline
							if (SignalProps[0]>MaxSigVal)
								SignalProps[8]=1		//set fit error
							endif
							//check FWHM
							if ( (2*SignalProps[10])>tracelen )
								SignalProps[8]=1		//set fit error
							endif
							//check peak amplitude
							if ( SignalProps[2]<1 || SignalProps[2]>(kSP2scattMaxSatFact*(MaxSigVal-SignalProps[0])) )
								SignalProps[8]=1		//set fit error
							endif
					else
						//not enough valid data points => do not fit
						SignalProps[8]=1		//set fit error
					endif
					if (SignalProps[8]!=0)
						//unreasonable fit result or fit error => whiteout result waves
						SignalProps[0]=NaN
						SignalProps[2]=NaN
						SignalProps[9]=NaN
						SignalProps[10]=NaN
						SignalProps[11]=NaN		
					endif
				elseif(FitMode==2)
					//average of selected number of points around global maximum
					SignalProps[9]=VmaxlocGlobal
					peakstartind=max(0,VmaxlocGlobal-(nPts4PeakHt-1)/2)
					peakendind=min(tracelen-1,VmaxlocGlobal+(nPts4PeakHt-1)/2)
					if (peakstartind<0 || peakendind>=tracelen)
						//invalid range (peak at edge of recored trace) => skip this signal
						filtered=1
					else
						//valid range => proceed
						wavestats /Q/R=(peakstartind,peakendind) currtrace 
						SignalProps[2]=V_avg
						SignalProps[2]-=SignalProps[0]
						HalfPeakHt=0.5*SignalProps[2]
						//filtering: peak ht. > 1 ;  0 < peak pos. < number of data points.
						if (SignalProps[2]<1 || SignalProps[9]<0 || SignalProps[9]+2>tracelen)
							filtered=1
						endif
					endif
					if (filtered)
						//write NaN to results wave 
						SignalProps[2]=NaN
						SignalProps[4]=NaN
						SignalProps[9]=NaN
						SignalProps[3]=NaN
						SignalProps[0]=NaN
						SignalProps[5]=NaN
						SignalProps[6]=NaN
					else		//continue with analysis of futher peak properties 
						StartEndLevel=kSP2scattStartEndDeltaPerc*SignalProps[2]+SignalProps[0]
						//Determine peak start point.
						for (tind=SignalProps[9];tind>0;tind-=1)
							if ((currtrace[tind]) < StartEndLevel)
								SignalProps[12]=tind		//PeakStart
								break
							endif
						endfor
						if (tind==0)		//baseline not found before peak position
							SignalProps[12]=0		//set peak start to 0
						endif
						//Determine peak end point.
						for (tind=SignalProps[9];tind<tracelen;tind+=1)
							if ((currtrace[tind]) < StartEndLevel)
								SignalProps[13]=tind		//PeakEnd
								break
							endif
						endfor
						if (tind==tracelen)		//baseline not found after peak position
							SignalProps[13]=tracelen-1		//set peak end to last data point
						endif
						//filter noisy spikes based on their small width
						if (SignalProps[13]-SignalProps[12]>PeakWidthThreshold)	//proceed only if peak is sufficiently wide
							//Determine half peak rise point.
							for (tind=SignalProps[9];tind>0;tind-=1)
								if ((currtrace[tind]-SignalProps[0]) <= HalfPeakHt)
									SignalProps[14]=tind		//peak half rise
									break
								endif
							endfor
							//Determine half peak decay point.
							for (tind=SignalProps[9];tind<tracelen;tind+=1)
								if ((currtrace[tind]-SignalProps[0]) <= HalfPeakHt)
									SignalProps[15]=tind	//PeakHalfDecay
									break
								endif
							endfor
							//FWHM of peak
							if (SignalProps[14]>=0 && SignalProps[15]<=tracelen)
								SignalProps[10]= SignalProps[15] - SignalProps[14]
							endif
						else
							//peak too narrow => considered to be a noisy spike
							SignalProps[2]=kSP2filteredPeakDummyPkHt
							SignalProps[4]=NaN
							SignalProps[9]=NaN
							SignalProps[3]=NaN
							SignalProps[0]=NaN
							SignalProps[5]=NaN
							SignalProps[6]=NaN
							SignalProps[12]=NaN
							SignalProps[13]=NaN
						endif
					endif
				endif
	while (0)
	//finish procedure
	return SignalProps
End



Threadsafe Function SP2_TA_FitPeakScatt_TS(tracemat, rowindex, nRows, nCols, nPts4PeakHt, PeakWidthThreshold, PeakFWHMmaxThrshld, PeakStart2PeakMaxThrshld, Offset, PeakHt, PeakPos, PeakStart, PeakEnd, PeakHalfRise, PeakHalfDecay, PeakFWHM, MaxPeakHt, MaxPos, MaxB4IncPos, MaxB4IncPeakHt, flag)
	//This function analyzes the peak of a scattering signal trace in the row 'rowindex' in the raw data matrix 'tracemat' and writes the result to the corresponding SP2 data waves
	//return value: 0 if peak properties are successfully determined (also if flag is set), 1 otherwise
	//martin.gysel@psi.ch; 21/09/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable nRows			//number of rows of tracemat
	variable nCols			//number of columns of tracemat
	variable nPts4PeakHt		//number of points for peak height (must be odd)
	variable PeakWidthThreshold	//minimum width of valid peaks
	variable PeakFWHMmaxThrshld	//maximum peak FWHM
	variable PeakStart2PeakMaxThrshld	//maximum difference between peak start and peak maximum
	wave Offset				//baseline (must be provided)
	wave PeakHt				//result wave for the fitted peak height
	wave PeakPos			//result wave for the fitted peak position
	wave PeakStart			//result wave for the fitted peak start position
	wave PeakEnd			//result wave for the fitted peak end position
	wave PeakHalfRise		//result wave for the fitted peak half rise position
	wave PeakHalfDecay		//result wave for the fitted peak half decay position
	wave PeakFWHM			//result wave for the fitted peak FWHM
	wave MaxPeakHt			//see calling function (will be filtered if needed)
	wave MaxPos			//see calling function (will be filtered if needed)
	wave MaxB4IncPos		//see calling function (will be filtered if needed)
	wave MaxB4IncPeakHt	//see calling function (will be filtered if needed)
	variable flag				//0:	function is normally executed
							//1:	function returns directly 0

	//check flag
	if (flag)
		//flag is set => return directly
		return 0
	endif
	//preparations
	variable filtered=0, IsNoisySpike=0, cind
	do	//note: "do-while" loop is used to provide a simple way to break the analysis at several instances in between
		//check nPts4PeakHt
		if (mod(nPts4PeakHt+1,2))
			//nPts4PeakHt is not an odd number
			filtered=1
			break	//leave the do-while-loop			
		endif
		//get peak position
		PeakPos[rowindex]=imag(MaxFromMatrixRowRange_TS(tracemat, rowindex, 0, nCols-1,0))
		//averaging range for peak height
		variable startcol=PeakPos[rowindex]-(nPts4PeakHt-1)/2
		variable endcol=PeakPos[rowindex]+(nPts4PeakHt-1)/2
		//get peak height
		PeakHt[rowindex]=-offset[rowindex]+MeanMatrixRowRangeNaN_TS(tracemat, rowindex, startcol, endcol,0)
		//filter small peak heights
		if (PeakHt[rowindex]<1)
			filtered=1
			break	//leave the do-while-loop
		endif
		variable StartEndLevel=kSP2scattStartEndDeltaPerc*PeakHt[rowindex]+offset[rowindex]
		//determine peak start point
		PeakStart[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, StartEndLevel, PeakPos[rowindex], 0, 0)
		if (numtype(PeakStart[rowindex])==2)
			//baseline not found before peak position
			PeakStart[rowindex]=0		//set peak start to 0
		endif
//		for (cind=PeakPos[rowindex];cind>0;cind-=1)
//			if (tracemat[rowindex][cind] < StartEndLevel)
//				PeakStart[rowindex]=cind
//				break
//			endif
//		endfor
//		if (cind==0)		//baseline not found before peak position
//			PeakStart[rowindex]=0		//set peak start to 0
//		endif
		//determine peak end point
		PeakEnd[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, StartEndLevel, PeakPos[rowindex], nCols-1, 0)
		if (numtype(PeakEnd[rowindex])==2)
			//baseline not found after peak position
			PeakEnd[rowindex]=nCols-1		//set peak end to last data point
		endif
//		for (cind=PeakPos[rowindex];cind<nCols;cind+=1)
//			if (tracemat[rowindex][cind] < StartEndLevel)
//				PeakEnd[rowindex]=cind
//				break
//			endif
//		endfor
//		if (cind==nCols)		//baseline not found after peak position
//			PeakEnd[rowindex]=nCols-1		//set peak end to last data point
//		endif
		//filter noisy spikes based on their small width
		if (!(PeakEnd[rowindex]-PeakStart[rowindex]>PeakWidthThreshold))
			//peak too narrow => considered to be a noisy spike
			filtered=1
			IsNoisySpike=1
			break	//leave the do-while-loop
		endif		
		variable HalfRiseDecayLevel=0.5*PeakHt[rowindex]+offset[rowindex]
		//Determine peak half rise point.
		PeakHalfRise[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, HalfRiseDecayLevel, PeakPos[rowindex], 0, 0)
//		for (cind=PeakPos[rowindex];cind>0;cind-=1)
//			if (tracemat[rowindex][cind] <= HalfRiseDecayLevel)
//				PeakHalfRise[rowindex]=cind
//				break
//			endif
//		endfor
		//Determine peak half decay point.
		PeakHalfDecay[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, HalfRiseDecayLevel, PeakPos[rowindex], nCols-1, 0)
//		for (cind=PeakPos[rowindex];cind<nCols;cind+=1)
//			if (tracemat[rowindex][cind] <= HalfRiseDecayLevel)
//				PeakHalfDecay[rowindex]=cind
//				break
//			endif
//		endfor
		//FWHM of peak
		PeakFWHM[rowindex]= PeakHalfDecay[rowindex] - PeakHalfRise[rowindex]
		//filter leaky particles based on their wide peaks
		if (PeakFWHM[rowindex]>=PeakFWHMmaxThrshld)
			//peak too wide => considered to be a leaky particle spike
			filtered=1
			IsNoisySpike=1
			break	//leave the do-while-loop
		endif		
		if ( (PeakPos[rowindex]-PeakStart[rowindex])>=PeakStart2PeakMaxThrshld)
			//peak too wide => considered to be a leaky particle spike
			filtered=1
			IsNoisySpike=1
			break	//leave the do-while-loop
		endif			
	while (0)
	//filter result waves if needed
	if (filtered==1)
		PeakHt[rowindex]=NaN
		PeakPos[rowindex]=NaN
		PeakStart[rowindex]=NaN
		PeakEnd[rowindex]=NaN
		PeakHalfRise[rowindex]=NaN
		PeakHalfDecay[rowindex]=NaN
		PeakFWHM[rowindex]=NaN
		MaxPeakHt[rowindex]=NaN
		MaxPos[rowindex]=NaN
		offset[rowindex]=NaN
		MaxB4IncPos[rowindex]=NaN
		MaxB4IncPeakHt[rowindex]=NaN
	endif
	if (IsNoisySpike)
		PeakHt[rowindex]=kSP2filteredPeakDummyPkHt
	endif
	//finish procedure
	return filtered
End


Threadsafe Function SP2_TA_FitGaussian_TS(tracemat, rowindex, nRows, nCols, Offset, PeakHtInitGuess,PeakPosInitGuess,WidthInitGuess, FitHoldStr, PeakHt, PeakPos, PeakFWHM, PeakChiSqr, MaxSigVal, flag)
	//This function fits a Gaussian to the row 'rowindex' in the raw data matrix 'tracemat' and writes the result to the corresponding SP2 data waves
	//return value: V_fitError
	//				0: ok (also for saturated traces)
	//				>=1: error
	//martin.gysel@psi.ch; 21/09/2012
	wave tracemat				//matrix containing the SP2 raw data
	variable rowindex				//index of row in the data matrix to be analysed
	variable nRows				//number of rows of tracemat
	variable nCols				//number of columns of tracemat
	wave Offset					//baseline (used for initial guess and fit results)
	variable PeakHtInitGuess		//initial guess for the peak height
	variable PeakPosInitGuess		//initial guess for the peak position
	variable WidthInitGuess		//initial guess for the width of the Gaussian
								//note: built-in gauss fit returns "width=sqrt(2)*(std. dev.)" and "FWHM=2*sqrt(2*ln(2))*(std. dev.)"
	string FitHoldStr				//hold string for fitting, i.e. "0000" or "1000"
	wave PeakHt					//result wave for the fitted peak height
	wave PeakPos				//result wave for the fitted peak position
	wave PeakFWHM				//result wave for the fitted peak FWHM
	wave PeakChiSqr				//result wave for the ChiSqr value of the fit
	variable MaxSigVal			//maximally possible value of the raw signal
	variable flag					//0:	function is normally executed
								//1:	function returns directly 0

	//check flag
	if (flag)
		//flag is set => return directly
		return 0
	endif
	//preparations
	variable V_fitError=0
	variable V_fitOptions=4
	variable NumNonNaN=NumberOfValidPtsInMatrixRow_TS(tracemat, rowindex)
	if (NumNonNaN<=4 || rowindex<0 || rowindex>=nRows)
		//not enough valid data points or bad input data
		//=> do not fit
		V_fitError=1
		return V_fitError		
	endif
	//perfom the fit
		//initial guess
		make /o/FREE FitCoef={Offset[rowindex],PeakHtInitGuess,PeakPosInitGuess,WidthInitGuess}
		//fit the Gaussian
		CurveFit/H=FitHoldStr/N/NTHR=0/Q gauss, kwCWave=FitCoef, tracemat[rowindex][]	
		//copy fit coefficients to corresponding result waves
		Offset[rowindex]=FitCoef[0]
		PeakHt[rowindex]=FitCoef[1]
		PeakPos[rowindex]=FitCoef[2]
		PeakFWHM[rowindex]=1.66511*FitCoef[3]	//Built-in gauss fit returns "width=sqrt(2)*(std. dev.)" and "FWHM=2*sqrt(2*ln(2))*(std. dev.)"
		PeakChiSqr[rowindex]=V_chisq
	//check quality of fit results
	if (V_fitError==0)
		//basic quality check of fit result
		if (PeakPos[rowindex]<0 || PeakPos[rowindex]>=nCols)
			//check peak position
			V_fitError=1 | V_fitError
		elseif (Offset[rowindex]>MaxSigVal)
			//check baseline
			V_fitError=1 | V_fitError
		elseif ( (2*PeakFWHM[rowindex])>nCols)
			//check FWHM
			V_fitError=1 | V_fitError
		elseif ( PeakHt[rowindex]<1 || PeakHt[rowindex]>(kSP2scattMaxSatFact*(MaxSigVal-Offset[rowindex])) )
			//check peak amplitude
			V_fitError=1 | V_fitError
		endif
	endif
	//filter strange fit results
	if (V_fitError!=0)
		//unreasonable fit result or fit error => whiteout result waves
		Offset[rowindex]=NaN
		PeakHt[rowindex]=NaN
		PeakPos[rowindex]=NaN
		PeakFWHM[rowindex]=NaN
		PeakChiSqr[rowindex]=NaN		
	endif
	//finish procedure
	return V_fitError
End



Threadsafe Function SP2_TA_GetBaseline_TS(tracemat, rowindex, nRows, nPts4baseline, BaselineFilter, BaselineDelta)
	//This function determines the baseline for SP2 raw data. The baseline is determined for one row of the raw data matrix.
	//return value: retrieved baseline level
	//martin.gysel@psi.ch; 20/09/2012
	//joel.c.corbin+sci@gmail.com; 2016-03-02 --- add BaselineFilter=2 option
	//
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable nRows			//number of rows of tracemat
	variable nPts4baseline		//number of pretrigger points to be used for determining baseline value
	variable BaselineFilter		//0: all pretrigger points are averaged to get the baseline
							//1: only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
	variable BaselineDelta		//full amplitude of baselinenoise
							//note: only required if BaselineFilter=1 is selected, ignored otherwise

	//Determine baseline from pretrigger points
	switch(BaselineFilter)	
		case 0:	
			//average all pretrigger points to get baseline
			return MeanMatrixRowRangeNaN_TS(tracemat, rowindex, 0, nPts4baseline-1,0)
			break				
			
		case 1:	
			//only those pretrigger points below threshold=minimum+BaselineDelta are averaged to get baseline
			variable MinInPretrigRange=MinFromMatrixRowRange_TS(tracemat, rowindex, 0, nPts4baseline-1,0)
			return MeanMatRowRangeNaNBelowThrsld(tracemat, rowindex, 0, nPts4baseline-1, MinInPretrigRange+BaselineDelta,0)
			break

		case 2:
			// jcc_TODO: program this into the panel. Recommended to use with 10 points fixed pretrigger.
			// another option is to use (V_Q25 - V_min) * 3 or similar as a diagnostic of the baseline
		
			// use the trimmed mean -- less sensitive to user's chosen input (another options is /TM, the trimean= Q25+Q50+Q50+Q75  / 4
			make /free /n=(nPts4baseline) thisBL= tracemat[rowindex][p]
			StatsQuantiles /iNaN /TRIM=25 thisBL
			wave W_StatsQuantiles
			return W_StatsQuantiles[%trimmedmean]
			break
			
	endswitch
End

Function /S SP2_Load_BinaryFile_MT(rawfilefp, rawfldrfp, Omode [, PrintInfo, loadini, loadHK, FractMode, LoadOutOfEvery, MaxDataRate, ChannelBitsLoad])
	//This procedures loads SP2 raw data.
	//The file parser is based on the procedure "LoadSP2BinaryData()" provided by DMT (PAPI software).
	//return string: string list with the following three entries
	//	first entry:	
	//		"2": file has not been loaded because it could not be opened (e.g. does not exist)
	//		"1": file has not been loaded because it is empty
	//		or full path to the target folder into which the raw data have been loaded, if successful
	//	second entry:
	//		"0": configuration file has not been loaded
	//		"1": configuration file with equal file number has been loaded		
	//		"2": most recent configuration file with with lower file number has been loaded
	//	third entry:
	//		"0": housekeeping file has not been loaded
	//		"1":	housekeeping file with equal file number has been loaded
	//	forth entry:
	//		full path to housekeeping data folder (empty string if no housekeeping data have been loaded)
	//martin.gysel@psi.ch; 14/11/2008, 11/06/2009, 12/07/2009, 15/04/2010, 23/04/2010, 26/04/2010, 10/08/2010, 21/10/2010, 22/10/2010, 18/11/2010, 14/09/2011, 25/09/2012
	string rawfilefp	//full path to SP2B data file to be loaded
	string rawfldrfp	//full path to folder into which the raw data are loaded
	variable Omode	//1: overwrite existing data
					//0: prompt if the target folder exists already
	variable PrintInfo	//1 (default):	print loading information to history
					//0: 			to not print loading information to history
	variable loadini	//0:			do not load configuration file
					//2 (default):	load most recent configuration file
	variable loadHK	//0			do not load housekeeping file
					//1 (default):	load most recent housekeeping file if it hasn't yet been loaded
	variable FractMode		//0 (default):	load fraction of particles according to variable "LoadOutOfEvery"
							//1:			restrict fraction of loaded particles such the the maximum data rate "MaxDataRate" is not exceeded
	variable LoadOutOfEvery	//LoadOutOfEvery=5 means that only 1 out of every 5 triggered particles is loaded
							//default: LoadOutOfEvery=1
	variable MaxDataRate		//restricts the number of loaded particles
							//unit: particles / hour
							//i.e: MaxDataRate=5000, means that only every second particle is loaded from a file which contains 50'000 particles measured in 5 hours (data rate of file = 10 k#/h)
							//default: inf
	variable ChannelBitsLoad	//bitwise parameter determining which data channels are to be loaded (if available)
							//bit0=1 true: load high gain scattering channel
							//bit1=2 true: load high gain broadband incandescence channel
							//bit2=4 true: load high gain narrowband incandescence channel
							//bit3=8 true: load high gain split detector channel
							//bit4=16 true: load low gain scattering channel
							//bit5=32 true: load low gain broadband incandescence channel
							//bit6=64 true: load low gain narrowband incandescence channel
							//bit7=128 true: load low gain split detector channel
							//default: use panel settings
					
	//internal variables
	variable LoadResWaves=0	//0: do not load reserved waves; 1: load reserved waves
variable PrintExtraTimes=1
	//end of internal variables

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(loadini))
		loadini=2
	endif
	if (paramisdefault(loadHK))
		loadHK=1
	endif
	if (paramisdefault(FractMode))
		FractMode=0
	endif
	if (FractMode!=0 && FractMode!=1)
		setdatafolder $savedDF
		message="The parameter 'FractMode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	if (paramisdefault(LoadOutOfEvery))
		LoadOutOfEvery=1
	endif
	if (paramisdefault(MaxDataRate))
		MaxDataRate=inf
	endif	
	if (paramisdefault(ChannelBitsLoad))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar loadscatt=$ksSP2loadSCHGchan
		Nvar loadbroad=$ksSP2loadBBHGchan
		Nvar loadnarr=$ksSP2loadNBHGchan
		Nvar loadsplit=$ksSP2loadSPHGchan
		Nvar loadSCLG=$ksSP2loadSCLGchan
		Nvar loadBBLG=$ksSP2loadBBLGchan
		Nvar loadNBLG=$ksSP2loadNBLGchan
		Nvar loadSPLG=$ksSP2loadSPLGchan
		ChannelBitsLoad=loadscatt*kSP2chanbitSCHG
		ChannelBitsLoad+=loadbroad*kSP2chanbitBBHG
		ChannelBitsLoad+=loadnarr*kSP2chanbitNBHG
		ChannelBitsLoad+=loadsplit*kSP2chanbitSPHG
		ChannelBitsLoad+=loadSCLG*kSP2chanbitSCLG
		ChannelBitsLoad+=loadBBLG*kSP2chanbitBBLG
		ChannelBitsLoad+=loadNBLG*kSP2chanbitNBLG
		ChannelBitsLoad+=loadSPLG*kSP2chanbitSPLG
	endif
	//list of channel-names to be loaded
	string DAQchanlist=SP2_ChanListAllDAQ()
	variable MaxNumbChans=itemsinlist(DAQchanlist)
	variable cind
	string ChansToBeLoadedList=""
	for (cind=0; cind<MaxNumbChans; cind+=1)
		if ( (2^cind)&ChannelBitsLoad)
			ChansToBeLoadedList+=stringfromlist(cind,DAQchanlist)+";"
		endif
	endfor
	//check whether the target folder exists already
	if (datafolderexists(rawfldrfp) && Omode==0)
		//there is already data in the target folder
		variable oval
		do
			prompt oval, "The target folder exists already. Do you want to overwrite?", popup, "YES;NO"
			doprompt "Overwrite?", oval
			if (V_flag)
				//user pressed cancel button		
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message; print RTStackInfo; abort message			
			endif
			if (oval==0)
				//user wants to overwrite => continue with loading the file
				break
			else
				//user does not want to overwrite => prompt for alternative target folder
				prompt rawfldrfp, "Enter new target folder for the SP2 raw data:"
				doprompt "Target Folder"
				if (V_flag)
					//user pressed cancel button		
					setdatafolder $savedDF
					message="User cancelled the procedure "+currproc+"!"
					print message; print RTStackInfo; abort message
				endif
				//check the target folder exists already
				if (datafolderexists(rawfldrfp))
					//it does exist => prompt user again
					continue
				else
					//data folder does not exist => continue with loading the file
					break
				endif
			endif
		while (1)
	endif
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 rawfilefp
	if (V_isAliasShortcut)
		rawfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 rawfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			rawfilefp=S_aliasPath
		endif
	endif
	string filename=laststringfromlist(rawfilefp,listsepstr=":")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2fileLoader
	string tmpfldrpath=getdatafolder(1)
	//print info to history
	variable timerRefNum
	if (PrintInfo==1)
		Print "Loading SP2 file: "+rawfilefp+" to folder "+rawfldrfp+"\r"
		timerRefNum=StartMSTimer			
	endif
	//Open selected SP2B binary file
	variable FileRefNum, fileerror=0
	variable inifileloaded
	Open/R/Z FileRefNum as rawfilefp	
	if (V_flag)
		//error occured at opening => finish procedure
		setdatafolder $savedDF
		fileerror=2
		inifileloaded=0
	endif
	//Determine total length of file and check whether it is empty
	FStatus FileRefNum
	variable totalBytes=V_logEOF
	if (totalBytes==0)
		//file is empty => do not load it
		setdatafolder $savedDF
		fileerror=1
		inifileloaded=0
	endif
	if (fileerror==0)		//load and parse configuration file and binary raw data file
		//create folder for SP2 data
		CreateFoldersOfFullPath(rawfldrfp, 0)
		//Load the entire SP2B file into a temporary 1D wave as 16-bit signed integer (I16). This file will later be parsed.
		Make/O/FREE/N=(totalBytes/2)/W BinaryDataW
		variable timerRefNum2 = StartMSTimer
		FBinRead /F=2/B=2 FileRefNum, BinaryDataW	   			//Signed 16 bit (two bytes), Big Endian.
		string elapsed2=num2str(StopMSTimer(timerRefNum2)/1e6)
		if(PrintExtraTimes)
			Printf "File Read (MT) = "+elapsed2+"s\t\t"
		endif
		//Close the file.
		Close FileRefNum
		//Determine number of rows and columns for all records.	
		variable numCols, numChans
		numCols = 2^16*BinaryDataW[0] + BinaryDataW[1]				//trace length
		numChans = 2^16*BinaryDataW[2] + BinaryDataW[3]			//number of recorded traces;
		//Determine number of records in the file.
		variable RawTracePtsPerRec, bytesPerRec, bytesTraceDataPerRecord, bytesAuxDataPerRec, bytesSpareDataPerRecord, lastI32Pos, numSpareCols, numRecords
		RawTracePtsPerRec = numChans*numCols
		bytesTraceDataPerRecord=RawTracePtsPerRec*2				//trace data recorded as I16
		bytesAuxDataPerRec=3*4 + 1*2 + 7*4 + 2*8 						//Account for three extra I32's, one U16, 7 single-precision floats, and 2 double-precision floats.
		lastI32Pos=RawTracePtsPerRec+(bytesAuxDataPerRec/2)-1
		numSpareCols = 2^16*BinaryDataW[lastI32Pos-1] + BinaryDataW[lastI32Pos]		//Determine if spare 1D array is present.
		numSpareCols=max(0,numSpareCols)			//make sure that it is not negative
		bytesSpareDataPerRecord=numSpareCols*4						//spare data stored as single-precision if present
		bytesPerRec=bytesTraceDataPerRecord+bytesAuxDataPerRec+bytesSpareDataPerRecord		//total number of bytes per record			
		numRecords = trunc(totalBytes/bytesPerRec)				//total number of particles recorded in the file
		//determine fraction of particles to be loaded if the option to limit the maximum data rate was chosen
		if (FractMode==1)
			Make/O/FREE/W/N=2 FirstTime, LastTime		//single precision
			variable readindex=(0 * bytesPerRec / 2) + 4 + RawTracePtsPerRec
			FirstTime[0] = BinaryDataW[readindex+2]					//Single-precision time wave.
			FirstTime[1] = BinaryDataW[readindex+1]
			readindex=( (numRecords-1) * bytesPerRec / 2) + 4 + RawTracePtsPerRec
			LastTime[0] = BinaryDataW[readindex+2]					//Single-precision time wave.
			LastTime[1] = BinaryDataW[readindex+1]			
			Redimension /N=(1)/S/E=1 FirstTime, LastTime						//FP32
			variable DataRate=numRecords/(LastTime[0]-FirstTime[0])*3600		//jcc v420 added [0], which was previously implicit, without following logic
			LoadOutOfEvery=round(DataRate/MaxDataRate)
			LoadOutOfEvery=max(1,LoadOutOfEvery)
		endif
		//Create 1-D output waves as I16. They will be redimensioned later to the correct data type.
		setdatafolder $rawfldrfp
		variable totalDataPoints, numLoadRecords
		numLoadRecords=ceil(numRecords/LoadOutOfEvery)			//total number of particles to be loaded
		Make/O/W/N=(numLoadRecords) Flag						//U16				
		Make/O/W/N=(2*numLoadRecords) TimeWave,EventIndex,TimeDiv10000,TimeRemainder		//single precision
		if (LoadResWaves)
			Make/O/W/N=(2*numLoadRecords) Res1,Res5,Res6		//single precision
			Make/O/W/N=(4*numLoadRecords) Res7,Res8			//double precision
		endif
		//create temporary 1-D output wave for spare data array (if present)
		if (numSpareCols!=0)												//If spare 1D array is present...
			Make/O/FREE/W/N=(2*numSpareCols*numLoadRecords) SpareWave	//make wave for that.
		endif
		//further temporary waves
		Make/O/FREE/N=(numLoadRecords) MToutput
		//Transfer data from binary file wave into I16 1-D waves.
			//auxiliary data
			Multithread MToutput=SP2_Load_ParseAuxData_TS(BinaryDataW, p, LoadOutOfEvery*p, bytesPerRec, RawTracePtsPerRec, Flag, TimeWave, EventIndex,TimeDiv10000, TimeRemainder)
			//reserved waves
			if (LoadResWaves)
				Multithread MToutput=SP2_Load_ParseResData_TS(BinaryDataW, p, LoadOutOfEvery*p, bytesPerRec, RawTracePtsPerRec, Res1, Res5, Res6, Res7, Res8)
			endif
			//spare waves
			if (numSpareCols!=0)												//If spare 1D array is present...
				Multithread MToutput=SP2_Load_ParseSpareData_TS(BinaryDataW, p, LoadOutOfEvery*p, bytesPerRec, bytesAuxDataPerRec, RawTracePtsPerRec, numSpareCols, SpareWave)
			endif				
		//Redimension the auxiliary and spare data waves which were treated as I16 but really contain U16, FP32, or FP64 data.
		//Using the /E=1 flag causes Redimension to merely change how the existing bits in the wave
		//are interpreted rather than doing a conversion from the old data type to the new.
			//auxiliary data waves
			Redimension/N=(numLoadRecords)/U/E=1 Flag									//U16
			Redimension /N=(numLoadRecords)/S/E=1 TimeWave							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 EventIndex							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeDiv10000							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeRemainder						//FP32
			if (LoadResWaves)
				Redimension /N=(numLoadRecords)/S/E=1 Res1								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res5								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res6								//FP32
				Redimension /N=(numLoadRecords)/D/E=1 Res7								//FP64
				Redimension /N=(numLoadRecords)/D/E=1 Res8								//FP64	
			endif
			//spare data waves
			if (numSpareCols!=0)
				Redimension /N=(numSpareCols*numLoadRecords)/S/E=1 SpareWave			//FP32
				setdatafolder $rawfldrfp
				//create array for spare data and copy data from temporary spare wave
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					Make/O/S/N=(numLoadRecords,numSpareCols) SpareDataArray=SpareWave[p*numSpareCols+q]
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			endif
		//undo "modulo 86400" operation on TimeWave
		setdatafolder $rawfldrfp
		wave TimeWave=$ksSP2timewave
		variable nPts=dimsize(TimeWave,0)
		variable rind
		for (rind=1; rind<nPts; rind+=1)
			if (TimeWave[rind]<TimeWave[rind-1])
				TimeWave[rind,inf]+=86400
			endif
		endfor		
		//create time stamp wave
		variable dateval=SP2filename2DateVal(filename)
		setdatafolder $rawfldrfp
		make /o/n=(nPts)/d $ksSP2TimeDate
		wave TimeDate=$ksSP2TimeDate
		setscale d 0, 0, "dat", TimeDate
		note TimeDate, "TimeStamp"	
		TimeDate=dateval+TimeWave[p]
		make /o/n=(nPts)/d $ksSP2TimeDate+"_Var"
		wave TimeDate_Var=$ksSP2TimeDate+"_Var"
		setscale d 0, 0, "dat", TimeDate_Var
		note TimeDate_Var, "TimeStamp calculated from TimeDiv10000 and TimeRemainder;"	
		note TimeDate_Var, "It remains to be tested whether this time stamp is better than TimeDate;"	
		Multithread TimeDate_Var=3600+1e4*TimeDiv10000+TimeRemainder
		//load configuration (INI) file
		variable INIindex, AbortINIload=0
		string INIfileNam, INIfileFP
		string INIfldrFP=SP2_RawFldrFP2iniFldrFP(rawfldrfp)		//path to folder for configuration data
		switch (loadINI)
			case 0:
				//do not load configuration file
				inifileloaded=0
				break	//leave case structure
			case 2:
				//access INI-specific temporary waves
				setdatafolder $ksSP2iniLoadTempFldrFP
				Nvar iniFileNameFormat=$ksSP2iniLoadFileNameFormatPP
				Svar INIdataDir=$ksSP2iniLoadDataDir
				wave /t INIfileNames=$ksSP2iniLoadFileNamesPP
				wave /d iniFileTimes=$ksSP2iniLoadFileTimesPP
				variable nINIfiles=numpnts(INIfileNames)
				//time ID of current .sp2b file
				variable SP2BfileIDforINIload
				switch(iniFileNameFormat)	
					case kSP2iniNamesWithDateAndFileNum:	
						SP2BfileIDforINIload=SP2filename2UniqueFileID(filename)
						break				
					case kSP2iniNamesWithDateTimeStr:	
						SP2BfileIDforINIload=TimeDate[0]
						break				
					default:						
						//undefined format of INI file names => skip loading the INI file
						AbortINIload=1					
				endswitch
				if (AbortINIload)
					inifileloaded=0
					break
				endif
				//load most recent configuration file
				INIindex=BinarySearch(iniFileTimes, SP2BfileIDforINIload+kSP2secsTimeDelayOfFileName)	//"kSP2secsTimeDelayOfFileName" is used to account for the possibility that the "file name time stamp" of the INI/HK files is slightly after the time stamp of the first particle in the SP2B file
				switch(INIindex)
					case -1:		
						//no INI file which starts before recording the SP2B file
						inifileloaded=0
						break
					case -3:		
						//no INI file available
						inifileloaded=0
						break
					case -2:				//on purpose no break statement in this case; don't move this case before the other cases!
						//load last file
						INIindex=nINIfiles-1
					default:
						//load INI-file

//						// Martin's way (deprecated, doesn't work when loading subfolders)
						INIfileNam=INIfileNames[INIindex]
//						INIfileFP=INIdataDir+":"+INIfileNam
//						inifileloaded=SP2_LoadConfigFile(INIfileFP, INIfldrFP, 1)
						
						// Joel's way (search for '(this is not a INIpretty way to do it...)' to find the creation of INIfilePaths)
						wave /T INIfilePaths
						inifileloaded=SP2_LoadConfigFile(INIfilePaths[INIindex], INIfldrFP, 1)
				endswitch
				break
			default:
				//do not load
				inifileloaded=0
		endswitch
		//prepare names for raw data matrices
			//get list of logged channels
			variable ChannelBitsSaved
			if (inifileloaded==0)
				//no configuration file loaded
					//assume that all channels were saved
					ChannelBitsSaved=2^ksSP2numberofDAQchans-1
					//create dummy configuration data
					INIfileNam=filename
					SP2_CreateConfigDataWaves(inifldrfp, numCols, numCols, 99999, NaN)
					//alert
					string alertstr="Missing configuration data for file "+rawfldrfp+"!"
					Print alertstr
					SP2_postErrorMsg(alertstr) // not doalert--continue loading [v4111]
			else
				//get information on logged channels from configuration file
				setdatafolder $inifldrfp
				wave Channel0=$ksSP2configChannel0	
				wave Channel1=$ksSP2configChannel1	
				wave Channel2=$ksSP2configChannel2
				wave Channel3=$ksSP2configChannel3
				wave Channel4=$ksSP2configChannel4
				wave Channel5=$ksSP2configChannel5
				wave Channel6=$ksSP2configChannel6
				wave Channel7=$ksSP2configChannel7
				ChannelBitsSaved=0
				ChannelBitsSaved+=Channel0[0]*1
				ChannelBitsSaved+=Channel1[0]*2^1
				ChannelBitsSaved+=Channel2[0]*2^2
				ChannelBitsSaved+=Channel3[0]*2^3
				ChannelBitsSaved+=Channel4[0]*2^4
				ChannelBitsSaved+=Channel5[0]*2^5
				ChannelBitsSaved+=Channel6[0]*2^6
				ChannelBitsSaved+=Channel7[0]*2^7
			endif
			//loop over all possible channels and prepare list of channel names, etc., according to channel configuration
			variable skipped=0, currbit, loadbits=0
			string channame, chandescript, datamatnamlist="", datamatnotelist="", savedbitslist="", savedPrefixList=""
			string ChanPrefixList=SP2chanConfig2chanOrder()
			string ChanDescriptList=SP2_ChanListToDescrLongList(ChanPrefixList)
			for (cind=0; cind<ksSP2numberofDAQchans; cind+=1)
				currbit=2^cind
				if (ChannelBitsSaved&currbit)
					//current channel active => add to list
					channame=stringfromlist(cind,ChanPrefixList)
					chandescript=stringfromlist(cind,ChanDescriptList)
					savedPrefixList+=channame+";"
					savedbitslist+=num2str(currbit)+";"
					datamatnamlist+=channame+ksSP2rawtracemat+";"
					datamatnotelist+="Raw traces recorded from the "+chandescript+" channel;"
					if ( whichlistitem(channame,ChansToBeLoadedList,";",0,0)>=0 )
						//current channel to be loaded
						loadbits+=currbit				
					endif
				endif
			endfor
			
		//Create a matrix for each channel and parse full data matrix into individual channel matrices.
		string currmatnam, currPrefix
		variable chanindex
		variable invert
		for (chanindex=0;chanindex<numChans;chanindex+=1)		//loop over all saved channels
			currbit=str2num(stringfromlist(chanindex,savedbitslist))
			currPrefix=stringfromlist(chanindex,savedPrefixList)
			if (currbit&loadbits)								//load only selected channels
				//create matrix
				currmatnam=stringfromlist(chanindex,datamatnamlist)
				setdatafolder $rawfldrfp
				Make/O/W/N=(numLoadRecords,numCols) $currmatnam		//I16
				Wave RawTraceMat=$currmatnam
				note RawTraceMat, stringfromlist(chanindex,datamatnotelist)
				//check whether raw data have to be inverted
				invert=1	//must be reset in each iteration
				strswitch(currPrefix)
					case ksSP2SPHGprefix:
						//access panel setting
						setdatafolder $ksSP2PathToToolkitPanelFldr	
						Nvar invertSPHG=$ksSP2invertSPHGchan
						if (invertSPHG)
							//invert
							invert=-1
						endif
						break
					case ksSP2SPLGprefix:
						//access panel setting
						setdatafolder $ksSP2PathToToolkitPanelFldr	
						Nvar invertSPLG=$ksSP2invertSPLGchan
						if (invertSPLG)
							//invert
							invert=-1
						endif
						break
					default:
						invert=1
				endswitch
				//parse binary file
				Multithread MToutput=SP2_Load_ParseTrace1Chan_TS(BinaryDataW, p, LoadOutOfEvery*p, numChans, bytesPerRec, RawTracePtsPerRec, chanindex, invert, RawTraceMat)
			endif
		endfor
		
		
		//free up memory space
		killwaves /z BinaryDataW
		//add further waves to "ini"-subfolder
			//OneOfEveryLoaded
			setdatafolder $inifldrfp
			wave OneOfEverySaved=$ksSP2configOneOfEverySaved
			make /o/n=(numpnts(OneOfEverySaved)) $ksSP2configOneOfEveryLoaded=LoadOutOfEvery
			wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = 1 means that every recorded particle was loaded;"
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = n means that only one out of n recorded particles was loaded;"
			//SP2B unique file ID
			make /o/n=1/d $ksSP2configUniqueFileIDsp2b=SP2filename2UniqueFileID(filename)
			wave /d UniqueFileIDsp2b=$ksSP2configUniqueFileIDsp2b
			setscale d 0,0,"dat", UniqueFileIDsp2b
			note UniqueFileIDsp2b, "Unique ID of raw data file ("+ksSP2datafileEnd+");"
			note UniqueFileIDsp2b, "Igor time, where the date represents the file data and the seconds since midnight the file number;"			
		//create wave containing the total elapsed measurment time
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedMeas=TimeWave[p]-TimeWave[0]
		wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
		note TimeElapsedMeas, "Total elapsed measurement time [s]."
		note TimeElapsedMeas, "No correction - for saving or loading only a fraction of the total data - has been applied to this wave."
			//clean TimeElapsedMeas for gaps in the measurement
			variable gind, gap
			for (gind=1; gind<nPts; gind+=1)
				gap=TimeElapsedMeas[gind]-TimeElapsedMeas[gind-1]
				if (gap>ksSP2maxGapSec)
					//interpret long time gap between two readings as a break in the measurement
					TimeElapsedMeas[gind,inf]-=gap
				endif
			endfor
		//create wave containing the "effective" elapsed time
		setdatafolder $inifldrfp
		wave OneOfEverySaved=$ksSP2configOneOfEverySaved
		wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedEff=TimeElapsedMeas/OneOfEverySaved/OneOfEveryLoaded
		wave TimeElapsedEff=$ksSP2TimeElapsedEff
		note TimeElapsedEff, "\"effective\" elapsed measurement time [s], corrected for saving or loading only a fraction of the triggered particles."
		//create wave containing file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2rawuniquefileID=SP2filename2UniqueFileID(filename)
		wave FileID=$ksSP2rawuniquefileID
		setscale d 0, 0, "dat", FileID
		note FileID, "This file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing just file number [jcc v4111 -- mostly useful for plotting]
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2rawuniquefileNum=SP2filename2FileNum(filename)
		wave FileNum=$ksSP2rawuniquefileNum
		note FileNum, "The file number, not including date, used for plotting;"
		//create wave containing corresponding config file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2correspConfigfileID=SP2filename2UniqueFileID(inifilenam)
		wave ConfigFileID=$ksSP2correspConfigfileID
		setscale d 0, 0, "dat", ConfigFileID
		note ConfigFileID, "This is the unique file ID of the corresponding configuration file;"
		note ConfigFileID, "The file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing particle ID
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2particleID=p*LoadOutOfEvery
		wave ParticleID=$ksSP2particleID		
		note ParticleID, "number of particle within the raw data file;"	
		//create main mask wave
		SP2rawDataMainMaskPrep(rawfldrfp, 1)
		//prepare global strings
		setdatafolder $tmpfldrpath
		string /g HKfldrFP		
		Svar HKfldrFP=$ksSP2hkFldrFP
		setdatafolder $rawfldrfp
		string /g HKfldrFP		
		Svar HKfldrFP=$ksSP2hkFldrFP
	else
		//SP2B-file not loaded. Still need the global string ...
		setdatafolder $tmpfldrpath
		string /g HKfldrFP	
		Svar HKfldrFP=$ksSP2hkFldrFP		
	endif
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "Elapsed time: %.2f seconds.\r", elapsed/1e6
	endif
	
	
	//load housekeeping file
	if (fileerror==0)		//only if raw data file was loaded
		variable hkfileloaded, HKindex, AbortHKload=0
		string HKfileNam, HKfileFP
		switch (loadHK)
			case 0:
				//do not load
				hkfileloaded=0
				break
			case 1:	
				//access HK-specific temporary waves
				setdatafolder $ksSP2hkLoadTempFldrFP
				Svar LastHKfileNam=$ksSP2hkLoadLastHKfileNam
				Svar LastHKfldrFP=$ksSP2hkLoadLastHKfldrFP
				Nvar hkFileNameFormat=$ksSP2hkLoadFileNameFormatPP
				Svar HKdataDir=$ksSP2hkLoadDataDir
				wave /t HKfileNames=$ksSP2hkLoadFileNamesPP
				wave /d hkFileTimes=$ksSP2hkLoadFileTimesPP
				variable nHKfiles=numpnts(HKfileNames)
				//time ID of current .sp2b file
				variable SP2BfileIDforHKload
				switch(hkFileNameFormat)	
					case kSP2hkNamesWithDateAndFileNum:	
						SP2BfileIDforHKload=SP2filename2UniqueFileID(filename)
						break				
					case kSP2hkNamesWithDateTimeStr:	
						SP2BfileIDforHKload=TimeDate[0]
						break				
					default:						
						//undefined format of HK file names => skip loading the HK file
						AbortHKload=1					
				endswitch
				if (AbortHKload)
					hkfileloaded=0
					break
				endif
				//load most recent housekeeping file started before recording SP2B file only if it hasn't yet been loaded
				HKindex=BinarySearch(hkFileTimes, SP2BfileIDforHKload+kSP2secsTimeDelayOfFileName)	//"kSP2secsTimeDelayOfFileName" is used to account for the possibility that the "file name time stamp" of the INI/HK files is slightly after the time stamp of the first particle in the SP2B file
				switch(HKindex)
					case -1:		
						//no HK file which starts before recording the SP2B file
						hkfileloaded=0
						break
					case -3:		
						//no HK file available
						hkfileloaded=0
						break
					case -2:				//on purpose no break statement in this case; don't move this case before the other cases!
						//load last file
						HKindex=nHKfiles-1
					default:
						//load HK-file
						HKfileNam=HKfileNames[HKindex]
						HKfldrFP=QuoteLiberalPath(RemoveLastItemFromList(rawfldrfp,ListSepStr=":")+ReplaceString(ksSP2hkFileEnd, HKfileNam, ksSP2hkFldrSuffix))
						if (stringmatch(HKfileNam, LastHKfileNam))
							//HK-file has previously been loaded => use previous HK-folder without reloading
							hkfileloaded=-1
						else
							//HK-file not yet loaded => load it
//							HKfileFP=HKdataDir+":"+HKfileNam
//							hkfileloaded=SP2_LoadHouseKeepingFileFast(HKfileFP, HKfldrFP, 1, PrintInfo)				//		jcc -- Martin's way -- requires one dataDir...
							// jcc v4111 -- new way (not HKpretty, but avoids a big reworking of code... see "INIpretty" labelled lines)
							wave /T HKfilePaths
							hkfileloaded=SP2_LoadHouseKeepingFileFast(HKfilePaths[HKindex], HKfldrFP, 1, PrintInfo)
						endif
				endswitch
				break
			default:
				//do not load
				hkfileloaded=0
		endswitch
	else
		hkfileloaded=0
	endif
	if (hkfileloaded==0)
		//no housekeeping data loaded
		HKfldrFP=" "  //do not remove space because DataFolderExists("") returns true, whereas DataFolderExists(" ") returns false
		LastHKfileNam=""
		LastHKfldrFP=""
	elseif (hkfileloaded==-1)
		//housekeeping file has previously been loaded => use that one as is and remember file name and folder path
		hkfileloaded=0
		LastHKfileNam=HKfileNam
		LastHKfldrFP=HKfldrFP			
	else
		//housekeeping data loaded => remember file name and folder path
		LastHKfileNam=HKfileNam
		LastHKfldrFP=HKfldrFP			
	endif
	//finish procedure
	string retrstr
	if (fileerror==0)
		retrstr=rawfldrfp+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)+";"+HKfldrFP+";"
	else
		retrstr=num2str(fileerror)+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)+";"+HKfldrFP+";"	
	endif
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return retrstr
End


Function /S SP2_BinaryDataLoader(rawfilefp, rawfldrfp, Omode [, PrintInfo, loadini, loadHK, FractMode, LoadOutOfEvery, MaxDataRate, ChannelBitsLoad])
	//This procedures loads SP2 raw data.
	//The file parser is based on the procedure "LoadSP2BinaryData()" provided by DMT (PAPI software).
	//return string: string list with the following three entries
	//	first entry:	
	//		"2": file has not been loaded because it could not be opened (e.g. does not exist)
	//		"1": file has not been loaded because it is empty
	//		or full path to the target folder into which the raw data have been loaded, if successful
	//	second entry:
	//		"0": configuration file has not been loaded
	//		"1": configuration file with equal file number has been loaded		
	//		"2": most recent configuration file with with lower file number has been loaded
	//	third entry:
	//		"0": housekeeping file has not been loaded
	//		"1":	housekeeping file with equal file number has been loaded
	//	forth entry:
	//		full path to housekeeping data folder (empty string if no housekeeping data have been loaded)
	//martin.gysel@psi.ch; 14/11/2008, 11/06/2009, 12/07/2009, 15/04/2010, 23/04/2010, 26/04/2010, 10/08/2010, 21/10/2010, 22/10/2010, 18/11/2010, 14/09/2011
	string rawfilefp	//full path to SP2B data file to be loaded
	string rawfldrfp	//full path to folder into which the raw data are loaded
	variable Omode	//1: overwrite existing data
					//0: prompt if the target folder exists already
	variable PrintInfo	//1 (default):	print loading information to history
					//0: 			to not print loading information to history
	variable loadini	//0:			do not load configuration file
					//2 (default):	load most recent configuration file
	variable loadHK	//0			do not load housekeeping file
					//1 (default):	load most recent housekeeping file if it hasn't yet been loaded
	variable FractMode		//0 (default):	load fraction of particles according to variable "LoadOutOfEvery"
							//1:			restrict fraction of loaded particles such the the maximum data rate "MaxDataRate" is not exceeded
	variable LoadOutOfEvery	//LoadOutOfEvery=5 means that only 1 out of every 5 triggered particles is loaded
							//default: LoadOutOfEvery=1
	variable MaxDataRate		//restricts the number of loaded particles
							//unit: particles / hour
							//i.e: MaxDataRate=5000, means that only every second particle is loaded from a file which contains 50'000 particles measured in 5 hours (data rate of file = 10 k#/h)
							//default: inf
	variable ChannelBitsLoad	//bitwise parameter determining which data channels are to be loaded (if available)
							//bit0=1 true: load high gain scattering channel
							//bit1=2 true: load high gain broadband incandescence channel
							//bit2=4 true: load high gain narrowband incandescence channel
							//bit3=8 true: load high gain split detector channel
							//bit4=16 true: load low gain scattering channel
							//bit5=32 true: load low gain broadband incandescence channel
							//bit6=64 true: load low gain narrowband incandescence channel
							//bit7=128 true: load low gain split detector channel
							//default: use panel settings
					
	//internal variables
	variable LoadResWaves=0	//0: do not load reserved waves; 1: load reserved waves
variable PrintExtraTimes=1
	//end of internal variables

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(PrintInfo))
		PrintInfo=1
	endif
	if (paramisdefault(loadini))
		loadini=2
	endif
	if (paramisdefault(loadHK))
		loadHK=1
	endif
	if (paramisdefault(FractMode))
		FractMode=0
	endif
	if (FractMode!=0 && FractMode!=1)
		setdatafolder $savedDF
		message="The parameter 'FractMode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	if (paramisdefault(LoadOutOfEvery))
		LoadOutOfEvery=1
	endif
	if (paramisdefault(MaxDataRate))
		MaxDataRate=inf
	endif	
	if (paramisdefault(ChannelBitsLoad))
		setdatafolder $ksSP2PathToToolkitPanelFldr	
		Nvar loadscatt=$ksSP2loadSCHGchan
		Nvar loadbroad=$ksSP2loadBBHGchan
		Nvar loadnarr=$ksSP2loadNBHGchan
		Nvar loadsplit=$ksSP2loadSPHGchan
		Nvar loadSCLG=$ksSP2loadSCLGchan
		Nvar loadBBLG=$ksSP2loadBBLGchan
		Nvar loadNBLG=$ksSP2loadNBLGchan
		Nvar loadSPLG=$ksSP2loadSPLGchan
		ChannelBitsLoad=loadscatt*kSP2chanbitSCHG
		ChannelBitsLoad+=loadbroad*kSP2chanbitBBHG
		ChannelBitsLoad+=loadnarr*kSP2chanbitNBHG
		ChannelBitsLoad+=loadsplit*kSP2chanbitSPHG
		ChannelBitsLoad+=loadSCLG*kSP2chanbitSCLG
		ChannelBitsLoad+=loadBBLG*kSP2chanbitBBLG
		ChannelBitsLoad+=loadNBLG*kSP2chanbitNBLG
		ChannelBitsLoad+=loadSPLG*kSP2chanbitSPLG
	endif
	//list of channel-names to be loaded
	string DAQchanlist=SP2_ChanListAllDAQ()
	variable MaxNumbChans=itemsinlist(DAQchanlist)
	variable cind
	string ChansToBeLoadedList=""
	for (cind=0; cind<MaxNumbChans; cind+=1)
		if ( (2^cind)&ChannelBitsLoad)
			ChansToBeLoadedList+=stringfromlist(cind,DAQchanlist)+";"
		endif
	endfor
	//check whether the target folder exists already
	if (datafolderexists(rawfldrfp) && Omode==0)
		//there is already data in the target folder
		variable oval
		do
			prompt oval, "The target folder exists already. Do you want to overwrite?", popup, "YES;NO"
			doprompt "Overwrite?", oval
			if (V_flag)
				//user pressed cancel button		
				setdatafolder $savedDF
				message="User cancelled the procedure "+currproc+"!"
				print message; print RTStackInfo; abort message			
			endif
			if (oval==0)
				//user wants to overwrite => continue with loading the file
				break
			else
				//user does not want to overwrite => prompt for alternative target folder
				prompt rawfldrfp, "Enter new target folder for the SP2 raw data:"
				doprompt "Target Folder"
				if (V_flag)
					//user pressed cancel button		
					setdatafolder $savedDF
					message="User cancelled the procedure "+currproc+"!"
					print message; print RTStackInfo; abort message
				endif
				//check the target folder exists already
				if (datafolderexists(rawfldrfp))
					//it does exist => prompt user again
					continue
				else
					//data folder does not exist => continue with loading the file
					break
				endif
			endif
		while (1)
	endif
	//handle shortcuts to files on windows platform
	GetFileFolderInfo /Q/Z=1 rawfilefp
	if (V_isAliasShortcut)
		rawfilefp=S_aliasPath
	elseif (V_flag)
		//try windows shortcut link
		GetFileFolderInfo /Q/Z=1 rawfilefp+ksShortcutFileExtWindows
		if (V_isAliasShortcut)
			rawfilefp=S_aliasPath
		endif
	endif
	string filename=laststringfromlist(rawfilefp,listsepstr=":")
	//temporary data folder
	newdatafolder /o/s root:Temp
	newdatafolder /o/s SP2fileLoader
	string tmpfldrpath=getdatafolder(1)
	//print info to history
	variable timerRefNum
	if (PrintInfo==1)
		Printf "[%s] Loading SP2 file "+rawfilefp+" to "+rawfldrfp+"\r", now()
		
		timerRefNum=StartMSTimer			
	endif
	//Open selected SP2B binary file
	variable FileRefNum, fileerror=0
	variable inifileloaded
	Open/R/Z FileRefNum as rawfilefp	
	if (V_flag)
		//error occured at opening => finish procedure
		setdatafolder $savedDF
		fileerror=2
		inifileloaded=0
	endif
	//Determine total length of file and check whether it is empty
	FStatus FileRefNum
	variable totalBytes=V_logEOF
	if (totalBytes==0)
		//file is empty => do not load it
		setdatafolder $savedDF
		fileerror=1
		inifileloaded=0
	endif
	if (fileerror==0)		//load and parse configuration file and binary raw data file
		//create folder for SP2 data
		CreateFoldersOfFullPath(rawfldrfp, 0)
		//Load the entire SP2B file into a temporary 1D wave as 16-bit signed integer (I16). This file will later be parsed.
		Make/O/FREE/N=(totalBytes/2)/W tempSP2LoaderWaveI16
variable timerRefNum2 = StartMSTimer
		FBinRead /F=2/B=2 FileRefNum, tempSP2LoaderWaveI16	   			//Signed 16 bit (two bytes), Big Endian.
string elapsed2=num2str(StopMSTimer(timerRefNum2)/1e6)
if(PrintExtraTimes)
	Printf "File Read (no MT) = %.2f\t\t", secs2str(StopMSTimer(timerRefNum2)/1e6)
endif
		//Close the file.
		Close FileRefNum
		//Determine number of rows and columns for all records.	
		variable numCols, numChannels
		numCols = 2^16*tempSP2LoaderWaveI16[0] + tempSP2LoaderWaveI16[1]				//trace length
		numChannels = 2^16*tempSP2LoaderWaveI16[2] + tempSP2LoaderWaveI16[3]			//number of recorded traces;
		//Determine number of records in the file.
		variable RawTracesPointsPerRecord, bytesPerRecord, bytesTraceDataPerRecord, bytesAuxDataPerRecord, bytesSpareDataPerRecord, lastI32Pos, numSpareCols, numRecords
		RawTracesPointsPerRecord = numChannels*numCols
		bytesTraceDataPerRecord=RawTracesPointsPerRecord*2				//trace data recorded as I16
		bytesAuxDataPerRecord=3*4 + 1*2 + 7*4 + 2*8 						//Account for three extra I32's, one U16, 7 single-precision floats, and 2 double-precision floats.
		lastI32Pos=RawTracesPointsPerRecord+(bytesAuxDataPerRecord/2)-1
		numSpareCols = 2^16*tempSP2LoaderWaveI16[lastI32Pos-1] + tempSP2LoaderWaveI16[lastI32Pos]		//Determine if spare 1D array is present.
		numSpareCols=max(0,numSpareCols)			//make sure that it is not negative
		bytesSpareDataPerRecord=numSpareCols*4						//spare data stored as single-precision if present
		bytesPerRecord=bytesTraceDataPerRecord+bytesAuxDataPerRecord+bytesSpareDataPerRecord		//total number of bytes per record			
		numRecords = trunc(totalBytes/bytesPerRecord)				//total number of particles recorded in the file
		//determine fraction of particles to be loaded if the option to limit the maximum data rate was chosen
		if (FractMode==1)
			setdatafolder $tmpfldrpath
			Make/O/W/N=2 FirstTime, LastTime		//single precision
			variable readindex=(0 * bytesPerRecord / 2) + 4 + RawTracesPointsPerRecord
			FirstTime[0] = tempSP2LoaderWaveI16[readindex+2]					//Single-precision time wave.
			FirstTime[1] = tempSP2LoaderWaveI16[readindex+1]
			readindex=( (numRecords-1) * bytesPerRecord / 2) + 4 + RawTracesPointsPerRecord
			LastTime[0] = tempSP2LoaderWaveI16[readindex+2]					//Single-precision time wave.
			LastTime[1] = tempSP2LoaderWaveI16[readindex+1]			
			Redimension /N=(1)/S/E=1 FirstTime, LastTime						//FP32
			variable DataRate=numRecords/(LastTime[0]-FirstTime[0])*3600		// jcc v420 as above
			LoadOutOfEvery=round(DataRate/MaxDataRate)
			LoadOutOfEvery=max(1,LoadOutOfEvery)
		endif
		//Create 1-D output waves as I16. They will be redimensioned later to the correct data type.
		setdatafolder $rawfldrfp
		variable totalDataPoints, numLoadRecords
		numLoadRecords=ceil(numRecords/LoadOutOfEvery)			//total number of particles to be loaded
		Make/O/W/N=(numLoadRecords) Flag						//U16				
		Make/O/W/N=(2*numLoadRecords) TimeWave,EventIndex,TimeDiv10000,TimeRemainder		//single precision
		if (LoadResWaves)
			Make/O/W/N=(2*numLoadRecords) Res1,Res5,Res6		//single precision
			Make/O/W/N=(4*numLoadRecords) Res7,Res8			//double precision
		endif
		//create temporary 1-D output wave for all raw data traces
		Make/O/FREE/W/N=(numLoadRecords*numChannels,numCols) RawTracesWave					//W gives I16 wave.			
		//create temporary 1-D output wave for spare data array (if present)
		if (numSpareCols!=0)												//If spare 1D array is present...
			Make/O/FREE/W/N=(2*numSpareCols*numLoadRecords) SpareWave	//make wave for that.
		endif
		//Transfer data from binary file wave into I16 1-D waves.
		variable CurrLoadIndex, CurrRecordIndex, CurrRawDataStartIndex, CurrWriteRow, CurrAuxDataStartIndex, CurrSpareDataStartIndex
		variable i
		for(CurrLoadIndex=0; CurrLoadIndex<numLoadRecords; CurrLoadIndex+=1)		//loop over records to be loaded
			//index of current particle in the file
			CurrRecordIndex=LoadOutOfEvery*CurrLoadIndex
			//Skip the two I32's before the data.
			CurrRawDataStartIndex = (CurrRecordIndex * bytesPerRecord / 2) + 4		//start index in file-wave of raw traces data in current record						
			//raw traces
				//2D data array of I16
				CurrWriteRow = CurrLoadIndex * numChannels
				//Note: the trace data are ordered as follows:
				//	1st point of 1st channel, 1st pt of 2nd chan, ..., 2nd pt of 1st chan, 2nd pt of 2nd chan, ...
				RawTracesWave[CurrWriteRow,CurrWriteRow+numChannels-1][0,numCols-1] = tempSP2LoaderWaveI16[CurrRawDataStartIndex+p-CurrWriteRow+numChannels*q]
				CurrAuxDataStartIndex=CurrRawDataStartIndex+RawTracesPointsPerRecord					//start index in file-wave of auxiliary data in current record 
			//auxiliary data
				//U16
				CurrWriteRow= CurrLoadIndex
				Flag[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex]							//U16 flag wave.		
				//single precision
				CurrWriteRow= 2*CurrLoadIndex
				TimeWave[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+2]					//Single-precision time wave.
				TimeWave[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+1]
				EventIndex[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+6]					//Single-precision event index wave.
				EventIndex[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+5]
				TimeDiv10000[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+8]				//Single-precision Time/10000 wave.
				TimeDiv10000[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+7]
				TimeRemainder[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+10]			//Single-precision time remainder wave.
				TimeRemainder[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+9]		
				//reserved waves
				if (LoadResWaves)
					//single precision
					CurrWriteRow= 2*CurrLoadIndex
					Res1[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+4]					//Single-precision reserved wave.
					Res1[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+3]
					Res5[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+12]					//Single-precision reserved wave.
					Res5[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+11]		
					Res6[CurrWriteRow] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+14]					//Single-precision reserved wave.
					Res6[CurrWriteRow+1] = tempSP2LoaderWaveI16[CurrAuxDataStartIndex+13]		
					//double precision
					CurrWriteRow= 4*CurrLoadIndex
					Res7[CurrWriteRow]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+18]					//Double-precision reserved wave.
					Res7[CurrWriteRow+1]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+17]
					Res7[CurrWriteRow+2]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+16]
					Res7[CurrWriteRow+3]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+15]	
					Res8[CurrWriteRow]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+22]					//Double-precision reserved wave.
					Res8[CurrWriteRow+1]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+21]
					Res8[CurrWriteRow+2]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+20]
					Res8[CurrWriteRow+3]=tempSP2LoaderWaveI16[CurrAuxDataStartIndex+19]		
				endif
			if (numSpareCols!=0)
				CurrWriteRow = 2*numSpareCols*CurrLoadIndex
				CurrSpareDataStartIndex=CurrAuxDataStartIndex+bytesAuxDataPerRecord/2-4					//start index in file-wave of spare data in current record
				for (i=CurrWriteRow;i<(CurrWriteRow+(2*numSpareCols));i+=1)
					SpareWave[i]=tempSP2LoaderWaveI16[CurrSpareDataStartIndex+i]						//Spare 1D array of single-precision.
				endfor
			endif
		endfor
		//free up memory space
		killwaves /z tempSP2LoaderWaveI16
		//Redimension the auxiliary and spares data waves which were treated as I16 but really contain U16, FP32, or FP64 data.
		//Using the /E=1 flag causes Redimension to merely change how the existing bits in the wave
		//are interpreted rather than doing a conversion from the old data type to the new.
			//auxiliary data waves
			Redimension/N=(numLoadRecords)/U/E=1 Flag									//U16
			Redimension /N=(numLoadRecords)/S/E=1 TimeWave							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 EventIndex							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeDiv10000							//FP32
			Redimension /N=(numLoadRecords)/S/E=1 TimeRemainder						//FP32
			if (LoadResWaves)
				Redimension /N=(numLoadRecords)/S/E=1 Res1								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res5								//FP32
				Redimension /N=(numLoadRecords)/S/E=1 Res6								//FP32
				Redimension /N=(numLoadRecords)/D/E=1 Res7								//FP64
				Redimension /N=(numLoadRecords)/D/E=1 Res8								//FP64	
			endif
			//spare data waves
			if (numSpareCols!=0)
				Redimension /N=(numSpareCols*numLoadRecords)/S/E=1 SpareWave			//FP32
				setdatafolder $rawfldrfp
				//create array for spare data and copy data from temporary spare wave
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					Make/O/S/N=(numLoadRecords,numSpareCols) SpareDataArray=SpareWave[p*numSpareCols+q]
					//!!!!!!!!!!! NOTE: reading the spare data has not been tested, because no such SP2B-files are available !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			endif
		//undo "modulo 86400" operation on TimeWave
		setdatafolder $rawfldrfp
		wave TimeWave=$ksSP2timewave
		variable nPts=dimsize(TimeWave,0)
		variable rind
		for (rind=1; rind<nPts; rind+=1)
			if (TimeWave[rind]<TimeWave[rind-1])
				TimeWave[rind,inf]+=86400
			endif
		endfor		
		//create time stamp wave
		variable dateval=SP2filename2DateVal(filename)
		setdatafolder $rawfldrfp
		make /o/n=(nPts)/d $ksSP2TimeDate
		wave TimeDate=$ksSP2TimeDate
		setscale d 0, 0, "dat", TimeDate
		note TimeDate, "TimeStamp"	
		TimeDate=dateval+TimeWave[p]
		//load configuration (INI) file
		variable INIindex, AbortINIload=0
		string INIfileNam, INIfileFP
		string INIfldrFP=SP2_RawFldrFP2iniFldrFP(rawfldrfp)		//path to folder for configuration data
		switch (loadINI)
			case 0:
				//do not load configuration file
				inifileloaded=0
				break	//leave case structure
			case 2:
				//access INI-specific temporary waves
				setdatafolder $ksSP2iniLoadTempFldrFP
				Nvar iniFileNameFormat=$ksSP2iniLoadFileNameFormatPP
				Svar INIdataDir=$ksSP2iniLoadDataDir
				wave /t INIfileNames=$ksSP2iniLoadFileNamesPP
				wave /d iniFileTimes=$ksSP2iniLoadFileTimesPP
				variable nINIfiles=numpnts(INIfileNames)
				//time ID of current .sp2b file
				variable SP2BfileIDforINIload
				switch(iniFileNameFormat)	
					case kSP2iniNamesWithDateAndFileNum:	
						SP2BfileIDforINIload=SP2filename2UniqueFileID(filename)
						break				
					case kSP2iniNamesWithDateTimeStr:	
						SP2BfileIDforINIload=TimeDate[0]
						break				
					default:						
						//undefined format of INI file names => skip loading the INI file
						AbortINIload=1					
				endswitch
				if (AbortINIload)
					inifileloaded=0
					break
				endif
				//load most recent configuration file
				INIindex=BinarySearch(iniFileTimes, SP2BfileIDforINIload)
				switch(INIindex)
					case -1:		
						//no INI file which starts before recording the SP2B file
						inifileloaded=0
						break
					case -3:		
						//no INI file available
						inifileloaded=0
						break
					case -2:				//on purpose no break statement in this case; don't move this case before the other cases!
						//load last file
						INIindex=nINIfiles-1
					default:
						//load INI-file
						INIfileNam=INIfileNames[INIindex]
						INIfileFP=INIdataDir+":"+INIfileNam
						inifileloaded=SP2_LoadConfigFile(INIfileFP, INIfldrFP, 1)						
				endswitch
				break
			default:
				//do not load
				inifileloaded=0
		endswitch
		//prepare names for raw data matrices
			//get list of logged channels
			variable ChannelBitsSaved
			if (inifileloaded==0)
				//no configuration file loaded
					//assume that all channels were saved
					ChannelBitsSaved=2^ksSP2numberofDAQchans-1
					//create dummy configuration data
					INIfileNam=filename
					SP2_CreateConfigDataWaves(inifldrfp, numCols, numCols, 99999, NaN)
					//alert
					string alertstr="Missing configuration data for file "+rawfldrfp+"!"
					DoAlert 0, alertstr
					Print alertstr
			else
				//get information on logged channels from configuration file
				setdatafolder $inifldrfp
				wave Channel0=$ksSP2configChannel0
				wave Channel1=$ksSP2configChannel1
				wave Channel2=$ksSP2configChannel2
				wave Channel3=$ksSP2configChannel3
				wave Channel4=$ksSP2configChannel4
				wave Channel5=$ksSP2configChannel5
				wave Channel6=$ksSP2configChannel6
				wave Channel7=$ksSP2configChannel7
				ChannelBitsSaved=0
				ChannelBitsSaved+=Channel0[0]*1
				ChannelBitsSaved+=Channel1[0]*2^1
				ChannelBitsSaved+=Channel2[0]*2^2
				ChannelBitsSaved+=Channel3[0]*2^3
				ChannelBitsSaved+=Channel4[0]*2^4
				ChannelBitsSaved+=Channel5[0]*2^5
				ChannelBitsSaved+=Channel6[0]*2^6
				ChannelBitsSaved+=Channel7[0]*2^7
			endif
			//loop over all possible channels and prepare list of channel names, etc., according to channel configuration
			variable skipped=0, currbit, loadbits=0
			string channame, chandescript, datamatnamlist="", datamatnotelist="", savedbitslist="", savedPrefixList=""
			string ChanPrefixList=SP2chanConfig2chanOrder()
			string ChanDescriptList=SP2_ChanListToDescrLongList(ChanPrefixList)
			for (cind=0; cind<ksSP2numberofDAQchans; cind+=1)
				currbit=2^cind
				channame=stringfromlist(cind,ChanPrefixList)
				chandescript=stringfromlist(cind,ChanDescriptList)
				savedPrefixList+=channame+";"
				if (ChannelBitsSaved&currbit)
					//current channel active => add to list
					savedbitslist+=num2str(currbit)+";"
					datamatnamlist+=channame+ksSP2rawtracemat+";"
					datamatnotelist+="Raw traces recorded from the "+chandescript+" channel;"
					if ( whichlistitem(channame,ChansToBeLoadedList,";",0,0)>=0 )
						//current channel to be loaded
						loadbits+=currbit				
					endif
				endif
			endfor
		//Create a matrix for each channel and parse full data matrix into individual channel matrices.
		string currmatnam, currPrefix
		variable chanindex
		for (chanindex=0;chanindex<numChannels;chanindex+=1)		//loop over all saved channels
			currbit=str2num(stringfromlist(chanindex,savedbitslist))
			currPrefix=stringfromlist(chanindex,savedPrefixList)
			if (currbit&loadbits)								//load only selected channels
				currmatnam=stringfromlist(chanindex,datamatnamlist)
				setdatafolder $rawfldrfp
				Make/O/W/N=(numLoadRecords,numCols) $currmatnam		//I16
				Wave RawTraceMat=$currmatnam
				note RawTraceMat, stringfromlist(chanindex,datamatnotelist)
				RawTraceMat=RawTracesWave[chanindex+p*numChannels][q]
				//invert raw signals if needed
				strswitch(currPrefix)
					case ksSP2SPHGprefix:
						//access panel setting
						setdatafolder $ksSP2PathToToolkitPanelFldr	
						Nvar invertSPHG=$ksSP2invertSPHGchan
						if (invertSPHG)
							//invert
							RawTraceMat*=-1
						endif
						break
					case ksSP2SPLGprefix:
						//access panel setting
						setdatafolder $ksSP2PathToToolkitPanelFldr	
						Nvar invertSPLG=$ksSP2invertSPLGchan
						if (invertSPLG)
							//invert
							RawTraceMat*=-1
						endif
						break
				endswitch
			endif
		endfor
		//add further waves to "ini"-subfolder
			//OneOfEveryLoaded
			setdatafolder $inifldrfp
			wave OneOfEverySaved=$ksSP2configOneOfEverySaved
			make /o/n=(numpnts(OneOfEverySaved)) $ksSP2configOneOfEveryLoaded=LoadOutOfEvery
			wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = 1 means that every recorded particle was loaded;"
			note OneOfEveryLoaded, ksSP2configOneOfEveryLoaded+" = n means that only one out of n recorded particles was loaded;"
			//SP2B unique file ID
			make /o/n=1/d $ksSP2configUniqueFileIDsp2b=SP2filename2UniqueFileID(filename)
			wave /d UniqueFileIDsp2b=$ksSP2configUniqueFileIDsp2b
			setscale d 0,0,"dat", UniqueFileIDsp2b
			note UniqueFileIDsp2b, "Unique ID of raw data file ("+ksSP2datafileEnd+");"
			note UniqueFileIDsp2b, "Igor time, where the date represents the file data and the seconds since midnight the file number;"			
		//create wave containing the total elapsed measurment time
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedMeas=TimeWave[p]-TimeWave[0]
		wave TimeElapsedMeas=$ksSP2TimeElapsedMeas
		note TimeElapsedMeas, "Total elapsed measurement time [s]."
		note TimeElapsedMeas, "No correction - for saving or loading only a fraction of the total data - has been applied to this wave."
			//clean TimeElapsedMeas for gaps in the measurement
			variable gind, gap
			for (gind=1; gind<nPts; gind+=1)
				gap=TimeElapsedMeas[gind]-TimeElapsedMeas[gind-1]
				if (gap>ksSP2maxGapSec)
					//interpret long time gap between two readings as a break in the measurement
					TimeElapsedMeas[gind,inf]-=gap
				endif
			endfor
		//create wave containing the "effective" elapsed time
		setdatafolder $inifldrfp
		wave OneOfEverySaved=$ksSP2configOneOfEverySaved
		wave OneOfEveryLoaded=$ksSP2configOneOfEveryLoaded
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2TimeElapsedEff=TimeElapsedMeas/OneOfEverySaved/OneOfEveryLoaded
		wave TimeElapsedEff=$ksSP2TimeElapsedEff
		note TimeElapsedEff, "\"effective\" elapsed measurement time [s], corrected for saving or loading only a fraction of the triggered particles."
		//create wave containing file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2rawuniquefileID=SP2filename2UniqueFileID(filename)
		wave FileID=$ksSP2rawuniquefileID
		setscale d 0, 0, "dat", FileID
		note FileID, "This file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing corresponding config file ID
		setdatafolder $rawfldrfp
		make /d/o/n=(nPts) $ksSP2correspConfigfileID=SP2filename2UniqueFileID(inifilenam)
		wave ConfigFileID=$ksSP2correspConfigfileID
		setscale d 0, 0, "dat", ConfigFileID
		note ConfigFileID, "This is the unique file ID of the corresponding configuration file;"
		note ConfigFileID, "The file ID is an Igor time value, where the date represents the file date and the seconds since midnight the file number;"
		//create wave containing particle ID
		setdatafolder $rawfldrfp
		make /o/n=(nPts) $ksSP2particleID=p*LoadOutOfEvery
		wave ParticleID=$ksSP2particleID		
		note ParticleID, "number of particle within the raw data file;"	
		//create main mask wave
		SP2rawDataMainMaskPrep(rawfldrfp, 1)
		//prepare global strings
		setdatafolder $tmpfldrpath
		string /g HKfldrFP		
		Svar HKfldrFP=$ksSP2hkFldrFP
		setdatafolder $rawfldrfp
		string /g HKfldrFP		
		Svar HKfldrFP=$ksSP2hkFldrFP
	else
		//SP2B-file not loaded. Still need the global string ...
		setdatafolder $tmpfldrpath
		string /g HKfldrFP	
		Svar HKfldrFP=$ksSP2hkFldrFP		
	endif
	//print info to history
	if (PrintInfo==1)
		variable elapsed=StopMSTimer(timerRefNum)						//In microseconds.
		Printf "%s finished at %s after %.2f s.\r", GetRTStackInfo(1), now(), elapsed/1e6 // jcc
	endif

	//load housekeeping file
	if (fileerror==0)		//only if raw data file was loaded
		variable hkfileloaded, HKindex, AbortHKload=0
		string HKfileNam, HKfileFP
		switch (loadHK)
			case 0:
				//do not load
				hkfileloaded=0
				break
			case 1:
				//access HK-specific temporary waves
				setdatafolder $ksSP2hkLoadTempFldrFP
				Svar LastHKfileNam=$ksSP2hkLoadLastHKfileNam
				Svar LastHKfldrFP=$ksSP2hkLoadLastHKfldrFP
				Nvar hkFileNameFormat=$ksSP2hkLoadFileNameFormatPP
				Svar HKdataDir=$ksSP2hkLoadDataDir
				wave /t HKfileNames=$ksSP2hkLoadFileNamesPP
				wave /d hkFileTimes=$ksSP2hkLoadFileTimesPP
				variable nHKfiles=numpnts(HKfileNames)
				//time ID of current .sp2b file
				variable SP2BfileIDforHKload
				switch(hkFileNameFormat)	
					case kSP2hkNamesWithDateAndFileNum:	
						SP2BfileIDforHKload=SP2filename2UniqueFileID(filename)
						break				
					case kSP2hkNamesWithDateTimeStr:	
						SP2BfileIDforHKload=TimeDate[0]
						break				
					default:						
						//undefined format of HK file names => skip loading the HK file
						AbortHKload=1					
				endswitch
				if (AbortHKload)
					hkfileloaded=0
					break
				endif
				//load most recent housekeeping file started before recording SP2B file only if it hasn't yet been loaded
				HKindex=BinarySearch(hkFileTimes, SP2BfileIDforHKload)
				switch(HKindex)
					case -1:
						//no HK file which starts before recording the SP2B file
						hkfileloaded=0
						break
					case -3:		
						//no HK files available (<- hkFileTimes was empty)
						hkfileloaded=0
						break
					case -2:				//on purpose no break statement in this case; don't move this case before the other cases!
						//load last file
						HKindex=nHKfiles-1
					default:
						//load HK-file
						HKfileNam=HKfileNames[HKindex]
						HKfldrFP=QuoteLiberalPath(RemoveLastItemFromList(rawfldrfp,ListSepStr=":")+ReplaceString(ksSP2hkFileEnd, HKfileNam, ksSP2hkFldrSuffix))
						if (stringmatch(HKfileNam, LastHKfileNam))
							//HK-file has previously been loaded => use previous HK-folder without reloading
							hkfileloaded=-1
						else
							//HK-file not yet loaded => load it
							HKfileFP=HKdataDir+":"+HKfileNam
							hkfileloaded=SP2_LoadHouseKeepingFileFast(HKfileFP, HKfldrFP, 1, PrintInfo)							
						endif
				endswitch
				break
			default:
				//do not load
				hkfileloaded=0
		endswitch
	else
		hkfileloaded=0
	endif
	if (hkfileloaded==0)
		//no housekeeping data loaded
		HKfldrFP=" "  //do not remove space because DataFolderExists("") returns true, whereas DataFolderExists(" ") returns false
		LastHKfileNam=""
		LastHKfldrFP=""
	elseif (hkfileloaded==-1)
		//housekeeping file has previously been loaded => use that one as is and remember file name and folder path
		hkfileloaded=0
		LastHKfileNam=HKfileNam
		LastHKfldrFP=HKfldrFP			
	else
		//housekeeping data loaded => remember file name and folder path
		LastHKfileNam=HKfileNam
		LastHKfldrFP=HKfldrFP			
	endif
	//finish procedure
	string retrstr
	if (fileerror==0)
		retrstr=rawfldrfp+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)+";"+HKfldrFP+";"
	else
		retrstr=num2str(fileerror)+";"+num2str(inifileloaded)+";"+num2str(hkfileloaded)+";"+HKfldrFP+";"	
	endif
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	killdatafolder /z $tmpfldrpath
	return retrstr
End


Threadsafe Function SP2_Load_ParseAuxData_TS(BinaryDataW, CurrLoadIndex, CurrRecordIndex, bytesPerRec, RawTracePtsPerRec, Flag, TimeWave, EventIndex,TimeDiv10000, TimeRemainder)
	//This function parses the auxiliary data from SP2 raw data files
	//return value: 0; not used
	//martin.gysel@psi.ch; 25/09/2012
	wave BinaryDataW		//I16 wave containing the complete binary data file
	variable CurrLoadIndex	//row index of the particle in the target waves
	variable CurrRecordIndex	//index of the particle in the file
	variable bytesPerRec		//bytes per data record
	variable RawTracePtsPerRec	//raw trace points per record
	wave Flag, TimeWave, EventIndex,TimeDiv10000, TimeRemainder		//auxiliary waves to be parsed

	//Transfer data from binary file wave into I16 1-D waves.
		//preparations
		variable CurrWriteRow
		variable CurrAuxDataStartIndex=(CurrRecordIndex * bytesPerRec / 2) + 4+RawTracePtsPerRec					//start index of auxiliary data of the current particle in the binary wave 
		//parse auxiliary data
			//U16
			CurrWriteRow= CurrLoadIndex
			Flag[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex]							//U16 flag wave.		
			//single precision
			CurrWriteRow= 2*CurrLoadIndex
			TimeWave[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+2]					//Single-precision time wave.
			TimeWave[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+1]
			EventIndex[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+6]					//Single-precision event index wave.
			EventIndex[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+5]
			TimeDiv10000[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+8]				//Single-precision Time/10000 wave.
			TimeDiv10000[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+7]
			TimeRemainder[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+10]				//Single-precision time remainder wave.
			TimeRemainder[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+9]		
	//finish procedure
	return 0
End


Threadsafe Function SP2_Load_ParseResData_TS(BinaryDataW, CurrLoadIndex, CurrRecordIndex, bytesPerRec, RawTracePtsPerRec, Res1, Res5, Res6, Res7, Res8)
	//This function parses the reserved data from SP2 raw data files
	//return value: 0; not used
	//martin.gysel@psi.ch; 25/09/2012
	wave BinaryDataW		//I16 wave containing the complete binary data file
	variable CurrLoadIndex	//row index of the particle in the target waves
	variable CurrRecordIndex	//index of the particle in the file
	variable bytesPerRec		//bytes per data record
	variable RawTracePtsPerRec	//raw trace points per record
	wave Res1, Res5, Res6, Res7, Res8	//reserved waves to be parsed

	//Transfer data from binary file wave into I16 1-D waves.
		//preparations
		variable CurrWriteRow
		variable CurrAuxDataStartIndex=(CurrRecordIndex * bytesPerRec / 2) + 4+RawTracePtsPerRec					//start index of auxiliary data of the current particle in the binary wave 
		//parse reserved waves
			//single precision
			CurrWriteRow= 2*CurrLoadIndex
			Res1[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+4]					//Single-precision reserved wave.
			Res1[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+3]
			Res5[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+12]					//Single-precision reserved wave.
			Res5[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+11]		
			Res6[CurrWriteRow] = BinaryDataW[CurrAuxDataStartIndex+14]					//Single-precision reserved wave.
			Res6[CurrWriteRow+1] = BinaryDataW[CurrAuxDataStartIndex+13]		
			//double precision
			CurrWriteRow= 4*CurrLoadIndex
			Res7[CurrWriteRow]=BinaryDataW[CurrAuxDataStartIndex+18]					//Double-precision reserved wave.
			Res7[CurrWriteRow+1]=BinaryDataW[CurrAuxDataStartIndex+17]
			Res7[CurrWriteRow+2]=BinaryDataW[CurrAuxDataStartIndex+16]
			Res7[CurrWriteRow+3]=BinaryDataW[CurrAuxDataStartIndex+15]	
			Res8[CurrWriteRow]=BinaryDataW[CurrAuxDataStartIndex+22]					//Double-precision reserved wave.
			Res8[CurrWriteRow+1]=BinaryDataW[CurrAuxDataStartIndex+21]
			Res8[CurrWriteRow+2]=BinaryDataW[CurrAuxDataStartIndex+20]
			Res8[CurrWriteRow+3]=BinaryDataW[CurrAuxDataStartIndex+19]		
	//finish procedure
	return 0
End


Threadsafe Function SP2_Load_ParseSpareData_TS(BinaryDataW, CurrLoadIndex, CurrRecordIndex, bytesPerRec, bytesAuxDataPerRec, RawTracePtsPerRec, numSpareCols, SpareWave)
	//This function parses the spare data from SP2 raw data files
	//return value: 0; not used
	//martin.gysel@psi.ch; 25/09/2012
	wave BinaryDataW		//I16 wave containing the complete binary data file
	variable CurrLoadIndex	//row index of the particle in the target waves
	variable CurrRecordIndex	//index of the particle in the file
	variable bytesPerRec		//bytes per data record
	variable bytesAuxDataPerRec	//bytes of auxiliary data per record
	variable RawTracePtsPerRec	//raw trace points per record
	variable numSpareCols	//number of spare columns
	wave SpareWave			//spare wave to be parsed

	//Transfer data from binary file wave into I16 1-D waves.
		//preparations
		variable CurrWriteRow = 2*numSpareCols*CurrLoadIndex
		variable CurrSpareDataStartIndex=(CurrRecordIndex * bytesPerRec / 2) + 4+RawTracePtsPerRec+bytesAuxDataPerRec/2-4		//start index spare data of the current particle in the binary wave
		variable CurrWriteLastIndex=CurrWriteRow+(2*numSpareCols)-1
		variable i
		//parse spare data
				for (i=CurrWriteRow;i<=CurrWriteLastIndex;i+=1)
					SpareWave[i]=BinaryDataW[CurrSpareDataStartIndex+i]						//Spare 1D array of single-precision.
				endfor
	//finish procedure
	return 0
End


Threadsafe Function SP2_Load_ParseTrace1Chan_TS(BinaryDataW, CurrLoadIndex, CurrRecordIndex, numChans, bytesPerRec, RawTracePtsPerRec, chanindex, invert, RawTraceMat)
	//This function parses the raw traces of 1 channel from SP2 raw data files
	//return value: 0; not used
	//martin.gysel@psi.ch; 25/09/2012
	wave BinaryDataW		//I16 wave containing the complete binary data file
	variable CurrLoadIndex	//row index of the particle in the target waves
	variable CurrRecordIndex	//index of the particle in the file
	variable numChans		//number of channels recorded in the file
//	variable numCols			//trace length
	variable bytesPerRec		//bytes per data record
	variable RawTracePtsPerRec	//raw trace points per record
	variable chanindex		//index of raw data channel in the binary data file
	variable invert				//1:	signal is not inverted
							//-1:	signal is inverted
	wave RawTraceMat		//raw trace matrix to be parsed

	//Transfer data from binary file wave into I16 1-D waves.
		//preparations
		variable CurrRawDataStartIndex = (CurrRecordIndex * bytesPerRec / 2) + 4
		//parse raw trace
			//2D data array of I16
			//Note: the trace data are ordered as follows:
			//	1st point of 1st channel, 1st pt of 2nd chan, ..., 2nd pt of 1st chan, 2nd pt of 2nd chan, ...
			RawTraceMat[CurrLoadIndex][]=min(max(invert*BinaryDataW[CurrRawDataStartIndex+chanindex+numChans*q],kSP2rawSignalMin),kSP2rawSignalMax)		//values coerced to range of I16 wave
//////////////OLD 1-step CODE which causes problems when inverting saturated 16-bit data/////////////////////
//RawTraceMat[CurrLoadIndex][]=invert*BinaryDataW[CurrRawDataStartIndex+chanindex+numChans*q]			//causes problem with inversion of 16-bit data
//////////////OLD 1-step CODE which causes problems when inverting saturated 16-bit data/////////////////////
//////////////OLD 2-step CODE/////////////////////
//RawTracesWave[CurrWriteRow,CurrWriteRow+numChans-1][] = BinaryDataW[CurrRawDataStartIndex+p-CurrWriteRow+numChans*q]
//RawTraceMat=RawTracesWave[chanindex+p*numChans][q]
//////////////OLD 2-step CODE/////////////////////
	//finish procedure
	return 0
End


Threadsafe Function SP2_TA_FitPeakIncand_TS(tracemat, rowindex, nRows, nCols, MatchNarrToBroad, PeakStartBroad, PeakEndBroad, nPts4PeakHt, MaxSigVal, Offset, PeakHt, PeakPos, PeakStart, PeakEnd, PeakHalfRise, PeakHalfDecay, saturated, flag)
	//This function analyzes the peak of an incandescence signal trace in the row 'rowindex' in the raw data matrix 'tracemat' and writes the result to the corresponding SP2 data waves
	//return value: 0 if peak properties are successfully determined (also if flag is set), 1 otherwise
	//martin.gysel@psi.ch; 26/09/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable nRows			//number of rows of tracemat
	variable nCols			//number of columns of tracemat
	variable MatchNarrToBroad		//search position of narrowband peak only near the broadband peak
	variable PeakStartBroad		//peak start position of other incandescence channel
	variable PeakEndBroad		//peak end position of the other incandescence channel
	variable nPts4PeakHt		//number of points for peak height (must be odd)
	variable MaxSigVal		//signal value corresponding to saturation
	wave Offset				//baseline (must be provided)
	wave PeakHt				//result wave for the fitted peak height
	wave PeakPos			//result wave for the fitted peak position
	wave PeakStart			//result wave for the fitted peak start position
	wave PeakEnd			//result wave for the fitted peak end position
	wave PeakHalfRise		//result wave for the fitted peak half rise position
	wave PeakHalfDecay		//result wave for the fitted peak half decay position
	wave saturated			//see calling function (will be filtered if needed)
	variable flag				//0:	function is normally executed
							//1:	function returns directly 0

	//check flag
	if (flag)
		//flag is set => return directly
		return 0
	endif
	//preparations
	variable filtered=0, cind
	variable startcol, endcol, extrasearchrange, SpikeThrshld, nind, SpikeFirstInd, SpikeLastInd, SpikeAvg
	do	//note: "do-while" loop is used to provide a simple way to break the analysis at several instances in between
		//check nPts4PeakHt
		if (mod(nPts4PeakHt+1,2))
			//nPts4PeakHt is not an odd number
			filtered=1
			break	//leave the do-while-loop			
		endif
		//Determine peak position
		if (MatchNarrToBroad==0)
			//use global maximum for the peak
				PeakPos[rowindex]=imag(MaxFromMatrixRowRange_TS(tracemat, rowindex, 0, nCols-1,0))
		elseif (MatchNarrToBroad==1)
			//search the peak near the broadband peak
			if (numtype(PeakStartBroad+PeakEndBroad)==0)
				//only if broadband peak is valid, otherwise the narrowband peak is ignored even if it was present
				extrasearchrange=kSP2matchNBtoBBrangeFact*(PeakEndBroad-PeakStartBroad)
				startcol=round(max(0,PeakStartBroad-extrasearchrange))
				endcol=round(min(nCols-1,PeakEndBroad+extrasearchrange))
				PeakPos[rowindex]=imag(MaxFromMatrixRowRange_TS(tracemat, rowindex, startcol, endcol,0))
			else
				//no valid broadband peak => ignore narrowband peak even if present
				filtered=1
			endif
		endif
		//check detector saturation and determine peak height
		if (filtered==0)	//skip if filtered
			variable MaxVal=tracemat[rowindex][PeakPos[rowindex]]
			if (MaxVal>=MaxSigVal)
				//saturated
				saturated[rowindex]=1
				PeakHt[rowindex]=MaxVal-offset[rowindex]
			else
				//not saturated
					//averaging range for peak height
					startcol=PeakPos[rowindex]-(nPts4PeakHt-1)/2
					endcol=PeakPos[rowindex]+(nPts4PeakHt-1)/2
					//get peak height
					PeakHt[rowindex]=-offset[rowindex]+MeanMatrixRowRangeNaN_TS(tracemat, rowindex, startcol, endcol,0)			
			endif		
		endif		
		//some filtering: peak ht. > 2 ;  0 < peak pos. < number of data points.
		if (filtered==1 || PeakHt[rowindex]<2 || PeakPos[rowindex]<0 || PeakPos[rowindex]+2>nCols)
			filtered=1
			PeakHt[rowindex]=NaN
			PeakPos[rowindex]=NaN
			offset[rowindex]=NaN
			saturated[rowindex]=0
			break	//leave do-while-loop and return to calling function
		endif
		//continue analysis if trace passed the above filtering test	
		variable StartEndLevel=kSP2incStartEndDeltaPerc*PeakHt[rowindex]+offset[rowindex]
		//Determine peak start point.
		PeakStart[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, StartEndLevel, PeakPos[rowindex], 0, 0)
		if (numtype(PeakStart[rowindex])==2)
			//baseline not found before peak position
			PeakStart[rowindex]=0		//set peak start to 0
		endif
		//Determine peak end point.
		PeakEnd[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, StartEndLevel, PeakPos[rowindex], nCols-1, 0)
		if (numtype(PeakEnd[rowindex])==2)
			//baseline not found after peak position
			PeakEnd[rowindex]=nCols-1		//set peak end to last data point
		endif
		//filter noisy spikes based on their small width
		SpikeThrshld=offset[rowindex]+kSP2minNoiseSpikeTestLevelAbs
		SpikeFirstInd=min(nCols-1, PeakPos[rowindex]+1)
		SpikeLastInd=min(nCols-1, PeakPos[rowindex]+kSP2minNoisySpikeTestTailNpts)
		if ( tracemat[rowindex][max(0,PeakPos[rowindex]-1)] < offset[rowindex]+kSP2minNoiseSpikeTestLevelAbs )		//test leading edge of the spike
			for (nind=SpikeFirstInd; nind<=SpikeLastInd; nind+=1)
				//test the trailing edge of the spike
				if ( tracemat[rowindex][nind] < SpikeThrshld )
					filtered=1
					break //leaf the for-endfor loop
				endif
			endfor
		endif		
		if ( filtered==1 )
			//peak too narrow => considered to be a noisy spike
			PeakHt[rowindex]=kSP2filteredPeakDummyPkHt
			PeakPos[rowindex]=NaN
			offset[rowindex]=NaN
			PeakStart[rowindex]=NaN
			PeakEnd[rowindex]=NaN
			saturated[rowindex]=0
			break	//leave do-while-loop and return to calling function	
		endif
//xx
//		SpikeThrshld=PeakHt[rowindex]*kSP2minNoiseSpikeTestLevelPerc/100+offset[rowindex]
//		SpikeFirstInd=min(nCols-1, PeakPos[rowindex]+1)
//		SpikeLastInd=min(nCols-1, PeakPos[rowindex]+kSP2minNoisySpikeTestTailNpts)
//		SpikeAvg=0
//		for (nind=SpikeFirstInd; nind<=SpikeLastInd; nind+=1)
//			SpikeAvg+=tracemat[rowindex][nind]
//		endfor
//		SpikeAvg/=(SpikeLastInd-SpikeFirstInd+1)
//		if ( SpikeAvg<SpikeThrshld)
//			//peak too narrow => considered to be a noisy spike
//			filtered=1
//			PeakHt[rowindex]=kSP2filteredPeakDummyPkHt
//			PeakPos[rowindex]=NaN
//			offset[rowindex]=NaN
//			PeakStart[rowindex]=NaN
//			PeakEnd[rowindex]=NaN
//			saturated[rowindex]=0
//			break	//leave do-while-loop and return to calling function	
//		endif
//xx
//		if (PeakEnd[rowindex]-PeakStart[rowindex]<=PeakWidthThreshold)
//			//peak too narrow => considered to be a noisy spike
//			filtered=1
//			PeakHt[rowindex]=kSP2filteredPeakDummyPkHt
//			PeakPos[rowindex]=NaN
//			offset[rowindex]=NaN
//			PeakStart[rowindex]=NaN
//			PeakEnd[rowindex]=NaN
//			saturated[rowindex]=0
//			break	//leave do-while-loop and return to calling function			
//		endif
		//continue analysis if trace passed the above filtering test	
		variable HalfRiseDecayLevel=0.5*PeakHt[rowindex]+offset[rowindex]
		//Determine half peak rise point.
		PeakHalfRise[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, HalfRiseDecayLevel, PeakPos[rowindex], 0, 0)
		//Determine half peak decay point.
		PeakHalfDecay[rowindex]=FindLevelMatrixRowRangeP_TS(tracemat, rowindex, HalfRiseDecayLevel, PeakPos[rowindex], nCols-1, 0)
	while (0)
	//finish procedure
	return filtered
End

Function /C SP2_LEO_FitWorker_ShapeSlow_TS(tracemat, rowindex, CentrePos, Offset, LEOfitFirstPt, LEOfitLastPt, LEOfitMinNumPts, SatVal, MinOrMaxForSat, LEOlevel, HoldStr, LEOfitSaturated, LEOfitError)
//Threadsafe Function /C SP2_LEO_FitWorker_ShapeSlow_TS(tracemat, rowindex, CentrePos, Offset, LEOfitFirstPt, LEOfitLastPt, LEOfitMinNumPts, SatVal, MinOrMaxForSat, LEOlevel, HoldStr, LEOfitSaturated, LEOfitError)
	//This function performs the LEO-fit using the actual laser beam shape (considered to be time-independent).
	//Here the slow variant is used, where the reference beam shape is fitted to the whole leading edge.
	//return value: complex number with:	real part: fitted baseline (may be kept constant, depending on "HoldStr")
	//									imaginary part: reconstructed scattering peak height.
	//									note: cmplx(NaN,NaN) is returned if the LEO-fit is not successful
	//martin.gysel@psi.ch; 01/10/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable CentrePos		//column index of the beam centre position in the row "rowindex" of the matrix "tracemat"
	variable Offset			//basline level from standard trace analysis
	variable LEOfitFirstPt		//column index of first point in the the row "rowindex" of the matrix "tracemat", which is to be considered in the LEO-fit (skip points outside the range covered by the reference beam shape) 
	variable LEOfitLastPt		//column index of last point in the the row "rowindex" of the matrix "tracemat", which is to be considered in the LEO-fit 
	variable LEOfitMinNumPts	//minimal number of raw trace points required for a valid LEO-fit
	variable SatVal			//raw signal value which indicates saturation of the signal
	variable MinOrMaxForSat	//0: the signals are negative => test for minimum to determine whether a signal is saturated
							//1: the signals are positive => test for maximum to determine whether a signal is saturated
	string HoldStr			//"00": baseline is also fitted
							//"01": baseline is not fitted, instead it is taken from the standard baseline value provided with the variable "Offset"
	wave LEOfitSaturated		//wave for storing the information whether or not a signal is saturated in the leading edge
	wave LEOfitError			//wave into which the "FitError" information is written
	variable LEOlevel			//level (fraction of full amplitude [-]) up to which the LEO-fit is performed


	//preparations
	variable Baseline, FitPkHt
	variable nRawPts=LEOfitLastPt-LEOfitFirstPt+1
	do		//use do-while loop to make it simple to break the fit in between
		//check the input	
		if (numtype(LEOfitLastPt+LEOfitFirstPt)==2)
			//split point not available
			//	=> skip this particle
			LEOfitError[rowindex]=0
			LEOfitSaturated[rowindex]=0
			Baseline=NaN
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		elseif (nRawPts<LEOfitMinNumPts)
			//not enough valid data points within fit range
			//	=> skip this particle
			LEOfitError[rowindex]=0
			LEOfitSaturated[rowindex]=0
			Baseline=NaN
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		endif
		//extract current trace
		make/o/FREE/n=(nRawPts) currtrace=tracemat[rowindex][p+LEOfitFirstPt]
		setscale /P x -(CentrePos-LEOfitFirstPt), 1, currtrace		//wave scaling is set such that beam centre is at x=0
		duplicate /o currtrace, root:temptrace
		//check whether leading edge of trace is saturated
		wavestats /q currtrace
		switch(MinOrMaxForSat)
			case 0:
				if (V_min<=SatVal)
					LEOfitSaturated[rowindex]=1
				endif
				break
			case 1:
				if (V_max>=SatVal)
					LEOfitSaturated[rowindex]=1
				endif
				break
		endswitch
		if(LEOfitSaturated[rowindex]==1)
			//write value corresponding to saturation into fit coefficients
			LEOfitError[rowindex]=0
			Baseline=Offset		//use value from standard trace analysis for baseline
			FitPkHt=(SatVal-Offset)/LEOlevel		//note: using round bracket for RefBeamShape is crucial as I am working with the wave scaling
			break	//leave to loop and finish the procedure
		endif
		//do LEO-fit
			//temporary wave
			make /o/FREE/n=2 LEOcoef
			variable V_fitError=0
			variable V_fitOptions=4
			//initial guess
			LEOcoef[0]=Offset		//use value from standard trace analysis for initial guess
			LEOcoef[1]=(currtrace[LEOfitLastPt]-Offset)/LEOlevel
			//fit
			FuncFit/H=HoldStr/N/NTHR=0/Q SP2_LEO_Fit_Shape_MT_aaoFfkt, kwCWave=LEOcoef, currtrace		//use all at once fit function
			//check fit result
			LEOfitError[rowindex]=V_fitError
			if (V_FitError==0)
				//keep fit results only if there was no fit error
				Baseline=LEOcoef[0]
				FitPkHt=LEOcoef[1]
			else
				Baseline=NaN
				FitPkHt=NaN
			endif
	while (0)
	//finish procedure
	return cmplx(Baseline, FitPkHt)
End



Threadsafe Function /C SP2_LEO_FitWorker_ShapeFast_TS(tracemat, rowindex, Offset, LEOfitLastPt, LEOfitMinNumPts, LEOfitFastNumPts, RefPkHtFast, MinOrMaxForSat, SatVal, LEOlevel, LEOfitError)
	//This function performs the LEO-fit using the actual laser beam shape (considered to be time-independent).
	//Here the fast variant is applied, where only the signal at the threshold level is used to reconstruct the full scattering amplitude.
	//return value: complex number with:	real part: reconstructed scattering peak height.
	//									imaginary part: 0 = no saturation in the leading edge; 1 = saturation in the leading edge
	//martin.gysel@psi.ch; 01/10/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable Offset			//basline level from standard trace analysis
	variable LEOfitLastPt		//column index of last point in the the row "rowindex" of the matrix "tracemat", which is to be considered in the LEO-fit 
	variable LEOfitMinNumPts	//minimal number of raw trace points required for a valid LEO-fit
	variable LEOfitFastNumPts	//number of raw trace points that are averaged to get the signal amplitude at the LEO-fit threshold
	variable RefPkHtFast		//averaged value of the reference beam shape at the LEO-fit threshold
							//note: the calculation of RefPkHtFast in the calling procedure must be consistent with the calculation of "FitPkHt" in this procedure
	variable MinOrMaxForSat	//0: the signals are negative => test for minimum to determine whether a signal is saturated
							//1: the signals are positive => test for maximum to determine whether a signal is saturated
	variable SatVal			//raw signal value which indicates saturation of the signal
	variable LEOlevel			//level (fraction of full amplitude [-]) up to which the LEO-fit is performed
	wave LEOfitError			//wave into which the "FitError" information is written


	//preparations
	variable FitPkHt, saturated
	do		//use do-while loop to make it simple to break the fit in between
		//check the input	
		if (numtype(LEOfitLastPt)==2)
			//split point not available
			//	=> skip this particle
			LEOfitError[rowindex]=0
			saturated=0
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		elseif (LEOfitLastPt+1<max(LEOfitMinNumPts,LEOfitFastNumPts))
			//not enough valid data points within fit range
			//	=> skip this particle
			LEOfitError[rowindex]=0
			saturated=0
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		endif
		//extract current trace
		make/o/FREE/n=(LEOfitFastNumPts) currtrace=tracemat[rowindex][p+LEOfitLastPt+1-LEOfitFastNumPts]
		//check whether leading edge of trace is saturated
		wavestats /q currtrace
		switch(MinOrMaxForSat)
			case 0:
				if (V_min<=SatVal)
					saturated=1
				endif
				break
			case 1:
				if (V_max>=SatVal)
					saturated=1
				endif
				break
		endswitch
		if(saturated==1)
			//write value corresponding to saturation into fit coefficients
			LEOfitError[rowindex]=0
			FitPkHt=(SatVal-Offset)/LEOlevel
			break	//leave to loop and finish the procedure
		endif
		//do LEO-fit
			FitPkHt=(V_avg-Offset)/RefPkHtFast
			//check fit result
			if (numtype(FitPkHt)==2)
				//fit error
				LEOfitError[rowindex]=1
			else
				//no error
				LEOfitError[rowindex]=1
			endif
	while (0)
	//finish procedure
	return cmplx(FitPkHt, saturated)
End


Threadsafe Function /C SP2_LEO_FitWorker_Gaussian_TS()
	//NOTE: This function is not yet implemented; below code is just a copy from the function "SP2_LEO_FitWorker_ShapeSlow_TS".
	return cmplx(NaN,NaN)
	//This function performs the LEO-fit using the actual laser beam shape (considered to be time-independent).
	//Here the slow variant is used, where the reference beam shape is fitted to the whole leading edge.
	//return value: complex number with:	real part: fitted baseline (may be kept constant, depending on "HoldStr")
	//									imaginary part: reconstructed scattering peak height.
	//									note: cmplx(NaN,NaN) is returned if the LEO-fit is not successful
	//martin.gysel@psi.ch; 01/10/2012
	wave tracemat			//matrix containing the SP2 raw data
	variable rowindex			//index of row in the data matrix to be analysed
	variable CentrePos		//column index of the beam centre position in the row "rowindex" of the matrix "tracemat"
	variable Offset			//basline level from standard trace analysis
	variable LEOfitLastPt		//column index of last point in the the row "rowindex" of the matrix "tracemat", which is to be considered in the LEO-fit 
	variable LEOfitMinNumPts	//minimal number of raw trace points required for a valid LEO-fit
	variable SatVal			//raw signal value which indicates saturation of the signal
	variable MinOrMaxForSat	//0: the signals are negative => test for minimum to determine whether a signal is saturated
							//1: the signals are positive => test for maximum to determine whether a signal is saturated
	string HoldStr			//"00": baseline is also fitted
							//"01": baseline is not fitted, instead it is taken from the standard baseline value provided with the variable "Offset"
	wave LEOfitSaturated		//wave for storing the information whether or not a signal is saturated in the leading edge
	wave LEOfitError			//wave into which the "FitError" information is written


	//preparations
	variable Baseline, FitPkHt
	do		//use do-while loop to make it simple to break the fit in between
		//check the input	
		if (numtype(LEOfitLastPt)==2)
			//split point not available
			//	=> skip this particle
			LEOfitError[rowindex]=0
			Baseline=NaN
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		elseif (LEOfitLastPt+1<LEOfitMinNumPts)
			//not enough valid data points within fit range
			//	=> skip this particle
			Baseline=NaN
			FitPkHt=NaN
			break	//leave to loop and finish the procedure
		endif
		//extract current trace
		make/o/FREE/n=(LEOfitLastPt+1) currtrace=tracemat[rowindex][p]
		setscale /P x -CentrePos, 1, currtrace		//wave scaling is set such that beam centre is at x=0
		//check whether leading edge of trace is saturated
		wavestats /q currtrace
		switch(MinOrMaxForSat)
			case 0:
				if (V_min<=SatVal)
					LEOfitSaturated[rowindex]=1
				endif
				break
			case 1:
				if (V_max>=SatVal)
					LEOfitSaturated[rowindex]=1
				endif
				break
		endswitch
		if(LEOfitSaturated[rowindex]==1)
			//write value corresponding to saturation into fit coefficients
			LEOfitError[rowindex]=0
			Baseline=Offset		//use value from standard trace analysis for baseline
			wave RefBeamShape=$ksSP2LEOfitTempBeamShape_MT
			FitPkHt=(SatVal-Offset)/RefBeamShape(LEOfitLastPt)		//note: using round bracket for RefBeamShape is crucial as I am working with the wave scaling
			break	//leave to loop and finish the procedure
		endif
		//do LEO-fit
			//temporary wave
			make /o/FREE/n=2 LEOcoef
			variable V_fitError=0
			variable V_fitOptions=4
			//initial guess
			LEOcoef[0]=Offset		//use value from standard trace analysis for initial guess
			LEOcoef[1]=(currtrace[inf]-Offset)/RefBeamShape(LEOfitLastPt)
			//fit
			FuncFit/H=HoldStr/N/NTHR=0/Q SP2_LEO_Fit_BeamShape_MT_Ffct, kwCWave=LEOcoef, currtrace		//use all at once fit function
			//check fit result
			LEOfitError[rowindex]=V_fitError
			if (V_FitError==0)
				//keep fit results only if there was no fit error
				Baseline=LEOcoef[0]
				FitPkHt=LEOcoef[1]
			else
				Baseline=NaN
				FitPkHt=NaN
			endif
	while (0)
	//finish procedure
	return cmplx(Baseline, FitPkHt)
End

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// INTERNAL  FUNCTIONS WRITTEN BY JCC ////////////////////////////////////////////////
//////////////// (kept separate because my coding style is quite different from Martin's) //////////
//////////////// Compatibility note: I use Notepad++ (v6.8.9) for Igor coding (ask me for source) //
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// functions that do goals //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////


// Inspired by the "delete SP2 data within time range button".
// Deletes SP2 data where an expression like "BCmass < 0.01" or "isnan(Dopt)" is TRUE.
Function SP2_DeleteDataByExpression([expr, pbpDF, preproc_after]) : ButtonControl
// Understand what you are doing with this function! Both time series (concentrations)
// and size distributions may become unrealistic.
// 2016-08-22 joel.c.corbin+sci@gmail.com NOT COMPLETELY TESTED
	string expr
	string pbpDF
	variable preproc_after
	variable flag__expr_is_wave=0
	
	if (ParamIsDefault(pbpDF))
		pbpdf= SP2_getFolder(type="PBP") // NOTE includes trailing :
	endif
	
	if (ParamisDefault(expr))
		prompt expr, "Provide a boolean expression or mask wave"
		doprompt "Filter expression or mask wave", expr
		
		wave /Z W_expr
		if (WaveExists(W_expr))
			flag__expr_is_wave= 1
		endif
		
		// interact with user, if in interactive mode already
		string wng= "This will permanently delete the selected raw and PBP data. "
		wng+= "\rConcentrations and size distributions may become meaningless."
		wng+= "\rContinue?"
		doAlert /T="SP2 Toolkit Warning" 1, wng
		if (V_flag==2)
			print "REMOVE ALL BAD DATA:  SP2_DeleteDataByExpression(expr=\"root:'20141111x006_SP2':Mask_BadDataMain\")"
			print "REMOVE BC FREE PARTICLES:  SP2_DeleteDataByExpression(expr=\"(Classification & kSP2SCHGeventBitVal) & !(Classification & kSP2BBHGeventBitVal)\")"
			SP2_abort("User abort.")
		endif

	endif	
	print pbpdf
	// apply user input
	if (!flag__expr_is_wave)
		make /o /n=(numpnts(FileID)) $pbpDF+"keepMask" /WAVE=keepMask
		execute "keepMask= " + expr
		note /K keepMask, "Created " + now() + " via " +GetRTStackInfo(0)+ " with expression:\r" + expr
	else
		duplicate /o W_expr keepMask
	endif
	
	// do it
	return SP2_DeleteDataByMask(keepMask= keepMask, pbpDF= pbpDF, preproc_after= preproc_after)
End



// Same as SP2_DeleteDataByExpression but takes a mask as input. 
Function SP2_DeleteDataByMask([keepMask, pbpDF, preproc_after])
// 2016-08-22 joel.c.corbin+sci@gmail.com
wave keepMask // where TRUE, data will be KEPT
string pbpDF
variable preproc_after

//	newdatafolder /o root:Temp; DuplicateDataFolder pbpDF, root:Temp:pbpDF_bkup  // backup before deleting
	
	wave FileID= $pbpDF + "FileID"
	variable np=numpnts(FileID), n_deleted
	
	// do removal [requires August 2016 or later version of Gysels_SharedProcs_v2]
	n_deleted= DeleteRunsFromDataFldrFast("", np, keepMask= keepMask, DataFldrPath=SP2_pbp2raw(pbpDF))
	n_deleted= DeleteRunsFromDataFldrFast("", np, keepMask= keepMask, DataFldrPath=pbpDF)
	
	if (preproc_after || ParamIsDefault(preproc_after))
		SP2_PBPpostprocessing(pbpfldrfp=pbpDF, PrintInfo=0)
	endif
	
	return n_deleted
End

/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// CODE SNIPPETS / FUNCTIONS TO AVOID REPETITION //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////

function /S SP2_getFolder([type, startingDF, promptText, includeAll, alwaysPrompt])
// Return a string to a raw SP2 data folder. User will receive a prompt in case of ambiguity.
// Can be internally called by functions with an optional raw data folder parameter,
// or activated from the toolkit.
//
// joel.c.corbin+sci@gmail.com 2015-06-03
// 
// USAGE EXAMPLES
//		PBPfolderChoice= SP2_getFolder(type="PBP", includeAll=1)
//		singleFolder= 	SP2_getFolder(type="PBP")
//		
//	SEE ALSO
//		SP2_getBeamShapeFolder()
//
//	NOTE this function breaks convention by creating its own buttons.
//
string type				// required, one of "raw" or "PBP" or "HK" or "INI" or "ConcTser"
string startingDF 		// optional, defaults to current DF
string promptText		// optional, text for dialog. Defaults to "select <<type>> data folder ..."
variable includeAll		// optional, defaults to FALSE. Allows a list of DFs to be chosen.
variable alwaysPrompt		// optional, defaults to FALSE. Ignores the checkbox setting.

// TODO: return current folde rif current folder is of specified type

if (ParamIsDefault(startingDF))
	startingDF=getdatafolder(1)
endif
if (ParamIsDefault(type))
	abort "Error: SP2_getFolder() needs type to be specified."
endif
if (ParamIsDefault(promptText))
		promptText= "Select SP2 "+type+" folder:"
endif
	
	// function internals
	string chosen		// the ultimately chosen folder
	string cbtext0 = "Use data folder(s): "
	variable useLast=0	// use the last selected folder?
	string cancelText= "cancelled"
	string noDFsFoundText= "[No "+ type +" folders found]"

	// initialize the last-selected checkbox	(reuse existing value here if checked)
	ControlInfo /W=SP2_Toolkit_PSI cb_reuseDF
	if (!V_flag)	// button doesn't exist so make it
		CheckBox cb_reuseDF,win= SP2_Toolkit_PSI, pos={84,108},size={209,14},title=cbtext0+ "[none selected]"
		CheckBox cb_reuseDF,win= SP2_Toolkit_PSI, font="Calibri",value= 0, disable=0, fColor=(0,26112,39168)
		ControlInfo /W= SP2_Toolkit_PSI cb_reuseDF
	elseif (V_value) // button checked
		// we re-use the last selected folders, 
		// but still convert to the selected category
		string lastChosen= getUserData("SP2_Toolkit_PSI", "cb_reuseDF", "DF")
		if (strlen(lastChosen)) // check that something is there... 
			if (!stringmatch(type, "HK") && !stringMatch("HK", lastChosen))
				// HK files don't follow the same format. Going to/from them
				// creates a big mess -- don't reuse last chosen in this case.
			
			// decide on what the new folder type should look like
			string typeTag
			strswitch(type)
				case "raw":
					typeTag = "SP2':"
					break
				case "PBP":
					typeTag = "SP2_PBP':"
					break
				case "HK":
					typeTag = "HK':"
					break
				case "INI":
					typeTag= "SP2':INI:"
					break
				case "ConcTser":
					typeTag= "SP2_PBP':ConcTser:"
					break
				default:
					print GetRTStackInfo(0)
					abort "Internal error: SP2 folder type unrecognized (see history for stack info)"
				// ...could also do ConcTser (PBP subfolder) 
			endswitch
			
			// append tag to each item in list of last chosen DFs
			chosen= ""
			variable i, nChosen= itemsInList(lastChosen)
			for (i=0; i<nChosen; i+=1) // loop through in case a list was chosen
				string thisChosen= stringFromList(i,lastChosen)
				thisChosen= GrepList(thisChosen, "(\d{3})", 0, "_") // remove previous 'type'. This assumes all folders are in the current DF, and that the names are 'standard', ending in 3 digits before type tag!
				thisChosen+= typeTag // add current type
				
				if (!DataFolderExists(thisChosen)) // check folders exist
					CheckBox cb_reuseDF, win= SP2_Toolkit_PSI, value= 0  // disable reuse if something not found
				endif
				
				chosen+= thisChosen+";"
			endfor
			chosen= RemoveEnding(chosen , ";")
			
			ControlInfo /W=SP2_Toolkit_PSI cb_reuseDF
			if (V_value && !alwaysPrompt) // button still checked after QC
//				printf "\t//* Reuse checkbox enabled, reusing last selected data folder after adjusting type to %s... (%s)\r", type, chosen
				return ensureEnding(chosen, ":")
			else 
				// exit if-endif, ask user for input
			endif
			endif
		endif
	endif
	
	// get list of data folders of specified type in root
	setdatafolder root:
	string DFlist = getDataFolderList() // all subfolders, full paths
	strswitch(type)
		case "raw":
			DFlist= grepList(DFlist, "_SP2':$")
			break
		case "PBP":
			DFlist= grepList(DFlist, "_SP2_PBP':$")
			break
		case "HK":
			DFlist= grepList(DFlist, "_HK':$")
			break
		case "INI":
			DFlist= grepList(DFlist, "_SP2':$")
			DFlist= replaceString("_SP2':", DFlist, "_SP2':INI:")
			break
		case "ConcTser":
			DFlist= grepList(DFlist, "_SP2_PBP':$")
			DFlist= replaceString("_SP2_PBP':", DFlist, "_SP2_PBP':ConcTser:")
			break
		default:
			print GetRTStackInfo(0)
			abort "Internal error: SP2_getFolder() type was specified incorrectly"
		// could also do ConcTser (PBP subfolder) 
	endswitch
	setdatafolder $startingDF
	
	// don't waste time if there is only one choice (cost of this shortcut is that user can't request old version)
	variable onlyOneChoice= 0
	if (strlen(DFlist)==0)
		DFlist= noDFsFoundText
	elseif (itemsInList(DFlist)==1 && strlen(DFlist)!=0)
		onlyOneChoice= 1
		chosen= stringFromList(0, DFlist)
	endif
	
	if (!onlyOneChoice || alwaysPrompt)
		// try to be clever and suggest the current folder first
		// TODO!
		
		// add special options to the list
		string doAll= ""
		if (includeAll) // eventually I will switch over to the Igor popup plugin...
			doAll += "[All]"
		endif
		string revertToOld= "[use Data Browser instead]"
		string DFlistOptions = doAll + ";" + DFlist + ";"+ revertToOld
			
		// do choice popup
		Prompt chosen, promptText, popup DFlistOptions
		doprompt "SP2toolkit input", chosen
		if (V_flag==1) // cancel clicked
			chosen= "cancelled"
		endif
		
		if (stringmatch(chosen, doAll))		
			chosen = DFlist
		endif
	
		// If user requested it, revert to Martin's version of this function [only happens if >1 folder exists]:
		if (stringmatch(chosen,revertToOld))
			chosen=BrowseForFolder(promptText, StartPath=startingDF)
		elseif (stringmatch(chosen,noDFsFoundText))
			return ""
		endif
	
		// avoid creating too many graphs
		if (itemsInList(chosen) > 5)
			NVAR /Z AutoGraphCB=$(ksSP2PathToToolkitPanelFldr + ksSP2autoGraphCB)
			if (NVAR_Exists(AutoGraphCB) && AutoGraphCB)
				string graphwarning = "You are about to process %g PBP folders and generate separate graphs for each. Disable graphs first?"
				sprintf graphwarning, graphwarning, itemsInList(chosen)
				DoAlert 1, graphwarning
				if (V_flag==1)
					AutoGraphCB=0
				endif
			endif
		endif
	
		// abort if cancelled
		if (stringmatch(chosen, cancelText) || stringmatch(chosen, noDFsFoundText))		
			SP2_abort("User cancelled")
		endif
	endif
	
	// update the panel checkbox
	string cbtext1= "Preselect DF%s (n=%g): \f02%s"
	nChosen= itemsInList(chosen)
	if (onlyOneChoice)
		cbtext1= "Preselect DF: \f02" +chosen // "the only existing folder" was once here
		CheckBox cb_reuseDF, win= SP2_Toolkit_PSI, value= 1  // might as well check the box...
	elseif (itemsInList(chosen) <= 1)
		cbtext1= "Preselect DF: \f02" + chosen
	elseif (itemsInList(chosen) < 4)
		sprintf cbtext1, cbtext1, "s", nChosen, chosen
	else
		sprintf cbtext1, cbtext1, "s", nChosen, stringFromList(0,chosen) + " [...] " + stringFromList(nChosen-1,chosen)
	endif
	CheckBox cb_reuseDF, win= SP2_Toolkit_PSI, userdata(DF)= chosen, title= cbtext1
	
	// end
	return ensureEnding(chosen, ":")
end

// Allows raw and PBP waves to be referenced as though they are in the same folder.
function /WAVE SP2_getWave(S_wavName)
// Given a wave which might not exist in the current DF, looks in sister raw, pbp, and HK folders for it.
string S_wavName
	
	string thisDF= getdatafolder(1)
	string rawDF= ensureEnding(SP2_pbp2raw(thisDF), ":") // this works even if current DF is raw
	string pbpDF= ensureEnding(SP2_raw2pbp(rawDF),  ":")
	
	wave /Z wav_raw= $rawDF + S_wavName
	wave /Z wav_pbp= $pbpDF + S_wavName
	
	if (WaveExists(wav_raw) && WaveExists(wav_pbp))
		SP2_abort(S_wavName + " exists in both raw and PBP folders! Abort")
	elseif (WaveExists(wav_raw))
		return wav_raw
	elseif (WaveExists(wav_pbp))
		return wav_pbp
	else
		return wav_raw // null reference
	endif
end


// Get files found within a given folder on hard disk
function /s getSP2FileNumListFromPath(folderPath)
// Returns a string of SP2 files in folderPath
// This function may be redundant with some of the existing SP2toolkit code
// joel.c.corbin@gmail.com 20150926
	string folderPath
	variable noSubDirs=1
	variable fullPaths=0
	variable followShortcuts=0
	string sp2files= ListOfAllFilesInDirAndSubDir2(folderPath, SubDirMode=noSubDirs, PathMode=fullPaths, fileExtStr=".sp2b", ShortcutMode=followShortcuts)
	
	variable i,n= itemsInList(sp2files)
	string newlist= ""
	for (i=0; i<n; i+=1)
		string onesp2b= stringFromList(1, stringFromList(i, sp2files), ":")
		string sp2bNum= removeEnding(stringFromList(1, onesp2b, "x"), ".sp2b")
		if (!strlen(sp2bNum)) // exclude background files like '20150613000000bkgnd.sp2b'
			continue
		endif
		newlist+= sp2bNum + ";"
	//	newlist+= onesp2b + ";"
	endfor
	
	return newlist
end

// automatically provide the LEO beam shape folder path, or do popup if >1 found
function /S SP2_getBeamShapeFolder([dontUsePreSelected]) : CheckBoxControl
// Also supports pre-definition of beam shape folder by panel checkbox.
//
// joel.c.corbin@gmail.com 2015-12-10; 2016-03-02
//
variable dontUsePreSelected // if a BS folder is preselected on the panel,
				//	this function will return it unless dontUsePreSelected=1
	
	if (!dontUsePreSelected)
		ControlInfo /W=SP2_toolkit_PSI cb_predefBeamShape; variable checked= V_value
		if (checked)
			return S_UserData // defined in SP2_CB_defineBeamShape()
		endif
	endif
	
	// get all potential folders
	string BeamShapeFldrFP
	string beamShapeDFs= findDF("BeamAndCalib", inDF=root:, sep=";")  // iterates by default
	
	// // TO TEST
	// // remove folders not containing the necessary waves
	// variable i, n=itemsInList(beamShapeDFs)
	// for (i=0; i<n; i+=1)
		// string bDF= stringFromList(i, beamShapeDFs)
		// wave /Z shape= $bDF + ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
// //		wave /Z split2centre= $bDF + ksSP2LEOfitSplit2centreDelta
		// wave /Z centrePos= $bDF + ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos
		// if (!(WaveExists(shape) && WaveExists(centrePos)))
			// beamShapeDFs= removeFromList(bDF, beamShapeDFs)
		// endif 
	// endfor
	
	string userPrompt= "Select folder containing the beam shape data:"
	if (itemsInList(beamShapeDFs) > 1)
		prompt BeamShapeFldrFP, userPrompt, popup, beamShapeDFs
		DoPrompt /HELP="Click Cancel to use the Data Folder selector instead.""LEO data folder for beam shape", BeamShapeFldrFP
		if (V_flag==1) // Cancel clicked -- assume user wants normal data browser (e.g. if they renamed the BeamAndCalib folder)
			BeamShapeFldrFP=BrowseForFolder(userPrompt, AbortMode=1)
		endif
	elseif (itemsInList(beamShapeDFs)==0)
		BeamShapeFldrFP=BrowseForFolder(userPrompt, AbortMode=1)
//		string message="No beam shape folders found--you need to do LEO beam shape characterization"; print message; print getRTStackInfo(0); abort message

	else
//		printf "\t//* Found only one folder named 'BeamAndCalib', automatically using it as beam shape calibration. (To prevent this, rename BeamAndCalib in folder %s.)\r", beamShapeDFs
		BeamShapeFldrFP= stringFromList(0,BeamShapeDFs)
	endif
	return BeamShapeFldrFP
end
Function SP2_CB_defineBeamShape(cba) : CheckBoxControl // for the panel button
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			if (cba.checked)
				string chosen= SP2_getBeamShapeFolder(dontUsePreSelected=1)
				CheckBox cb_predefBeamShape title="Beam shape: \f02" + chosen
				CheckBox cb_predefBeamShape userdata=chosen // store data within checkbox
			else
				CheckBox cb_predefBeamShape title="Pre-define beam shape folder..."
			endif
			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

// automatically provide the LEO fit results folder path, or do popup if >1 found
function /S SP2_getLEOmainFolder()
// joel.c.corbin@gmail.com 2015-12-10
	string LEOmainFldrFP
	string LEOmainDFs= findDF(":'LEO':'Main'", inDF=root:, sep=";")  // iterates by default
	string userPrompt= "Choose LEO main folder to use:"
	if (itemsInList(LEOmainDFs) > 1)
		prompt LEOmainFldrFP, userPrompt, popup, LEOmainDFs
		DoPrompt /HELP="Click Cancel to use the Data Folder selector instead." userPrompt, LEOmainFldrFP
		if (V_flag==1) // Cancel clicked -- assume user wants normal data browser (e.g. if they renamed the BeamAndCalib folder)
			LEOmainFldrFP=BrowseForFolder(userPrompt, AbortMode=1)	// StartPath=savedDF, 
		endif
	elseif (itemsInList(LEOmainDFs)==0)
		string message="No LEO main folders found--have you run LEO trace analysis?"
		print message; print getRTStackInfo(0); abort message

	else
		printf "\t//* Found only one folder named with ':LEO:Main', automatically using it... (To prevent this, rename the folder %s.)\r", LEOmainDFs
		LEOmainFldrFP= stringFromList(0,LEOmainDFs)
	endif
	return LEOmainFldrFP
end

// TODO: combine the LEO functions into one, with argument of type and strswitch of messages
// automatically provide the LEO fit results folder path, or do popup if >1 found
function /S SP2_getLEOfolder()
// joel.c.corbin@gmail.com 2015-12-10
	string LEOmainFldrFP
	string LEOmainDFs= findDF(":'LEO':$", inDF=root:, sep=";")  // iterates by default
	string userPrompt= "Choose LEO folder to use:"
	if (itemsInList(LEOmainDFs) > 1)
		prompt LEOmainFldrFP, userPrompt, popup, LEOmainDFs
		DoPrompt /HELP="Click Cancel to use the Data Folder selector instead." userPrompt, LEOmainFldrFP
		if (V_flag==1) // Cancel clicked -- assume user wants normal data browser (e.g. if they renamed the BeamAndCalib folder)
			LEOmainFldrFP=BrowseForFolder(userPrompt, AbortMode=1)	// StartPath=savedDF, 
		endif
	elseif (itemsInList(LEOmainDFs)==0)
		string message="No LEO folders found--have you run LEO trace analysis?"
		print message; print getRTStackInfo(0); abort message

	else
		printf "\t//* Found only one folder ending with :'LEO':, automatically using it... (To prevent this, rename the folder %s.)\r", LEOmainDFs
		LEOmainFldrFP= stringFromList(0,LEOmainDFs)
	endif
	return LEOmainFldrFP
end


// Converts an SP2 raw folder to a PBP folder.
function /s SP2_raw2pbp(dfString)
// joel.c.corbin+sci@gmail.com 2016, 2018
string dfString
	if (!strlen(dfString))
		dfString= getDataFolder(1)
	endif
	return ensureEnding(SP2_RawFldrFP2PBPfldrFP(dfString), ":")
end
// Converts an SP2 PBP folder to a raw folder.
function /s SP2_pbp2raw(dfString)
// joel.c.corbin+sci@gmail.com 2016, 2018
string dfString
	if (!strlen(dfString))
		dfString= getDataFolder(1)
	endif
	return ensureEnding(SP2_PBPfldrFP2RawFldrFP(dfString), ":")
end


// Returns the channel prefix (SCHG, BBLG, etc.) given constraints by 'mode'
function /s SP2_getChanPrefix(type)
// 'type' specifies "Scatt" or "Incand" or for all: "" or "all"
// return value is one of: SCHG, SCLG, BBHG, BBLG, etc
//
// joel.c.corbin+sci@gmail.com 2016-02-24 (note: older code contains this pattern explicitly
string type
	strswitch (type)
		case "": // note: continues to next case without 'break'
		case "all":
			string ChanList= SP2_ChanListAllEnabledDAQ()
			string typeNameInAlert= " "
			break
		case "Incand":
			ChanList= SP2_ChanListIncandOnly()
			typeNameInAlert= " incandescent "
			break
		case "Scatt":
			ChanList= SP2_ChanListScattOnly()
			typeNameInAlert= " scattering "
			break
	endswitch
	
	// ask user to choose
	variable useLongDescriptions= 0 // could be exposed later --- may be buggy!
	if (useLongDescriptions)
		string ChanDescrList=SP2_ChanListToDescrShortList(ChanList) // long descriptions...screw that
		string ChanDescr=stringfromlist(0,ChanDescrList)
		prompt ChanDescr, "Select"+typeNameInAlert+"channel:",popup, ChanList
		doprompt "ChanDescr", ChanDescr
		if (V_flag)
			SP2_abort("User cancelled procedure.")
		endif
		variable ChanNo=whichlistitem(ChanDescr,ChanDescrList)
		string ChanPrefix=stringfromlist(ChanNo,SP2_ChanListScattOnly())
		return ChanPrefix
	else
		string chosen
		prompt chosen, "Select channel:",popup, ChanList
		doprompt "Channel", chosen
		return chosen
	endif
end


// Returns 0//1 if the 'graphs' checkbox is unchecked//checked.
function SP2_graphsOn([set])
variable set
	NVAR /Z AutoGraphCB=$ksSP2PathToToolkitPanelFldr + ksSP2autoGraphCB
	if (!NVAR_Exists(AutoGraphCB))
		SP2_abort("graph checkbox not found!")
	endif
	
	if (!ParamIsDefault(set))
		AutoGraphCB= set
	endif
	
	if (AutoGraphCB)
		return 1
	endif
	return 0
end

function get_LOD_BBLG()
// joel.c.corbin+sci@gmail.com 2016-08-22
	NVAR LOD_BBLG= root:SP2toolkit:panel:DetectCutBBLG
	return LOD_BBLG
end
function get_LOD_SCHG()
// joel.c.corbin+sci@gmail.com 2016-08-22
	NVAR LOD_SCHG= root:SP2toolkit:panel:DetectCutSCHG
	return LOD_SCHG
end

/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// USER INTERACTION //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////


// This function 'automates' the SP2 toolkit to load multiple days of data.
function SP2_load_multiple_days([folderPath, loadHK, fileStep, deleteEntireRawDFs, deletePBPdata, PBPdeleteExpr, printInfo])
// Because multiple days typically means memory problems, the loaded
// data are preprocessed immediately.  Raw and PBP data are then deleted.
// Logic:
  // -- Asks for a folder containing SP2 day folders (20150922, 20150923, etc)
  // -- For each day folder:
	// -- 'Clicks' Load Raw Data with 'All files in folder' option 
	// -- Generates average time series (tip: use a higher resolution than desired, so you can average these later yourself with gridTo())
	// -- Kills PBP waves  (saving selected waves is on the 'todo list'... see "PBPkeeplist" below)
// Requirements:
  // -- the subfolders in folderpath MUST start with "20150922" or similar,
		// but tags such as "20150922_afterMirrorCleaning" are OK
// joel.c.corbin+sci@gmail.com, 2016-04-20
	
// preliminaries
string folderPath	//	folder in which SP2 subfolders are found (default: dialog popup)
variable fileStep	//	load 1 file in fileStep (default 1). Mainly useful during initial tests...
variable loadHK		//  load HK or not? For huge data sets, you may want to pre-load and remap HK before running this function
variable deleteEntireRawDFs // deletes raw data after each day's load. 
						  // DELETES MORE THAN THE TOOLKIT OPTION! May cripple reanalyses!
						  // You should probably only use the toolkit option.
variable deletePBPdata	// deletes PBP data after each day's load
string PBPdeleteExpr	// A string expression for SP2_DeleteDataByExpression(), run immediately after load. Overrides deletePBPdata
variable printInfo		// verbose or not

DFREF sdf = getDataFolderDFR()
variable noSubDirs=0 // do search for subfolders

if (ParamIsDefault(folderPath))
	// get folder containing days subfolders
	NewPath /o/m="Select a folder contai