// Modifications by Martin Gysel are tagged 'martin.gysel@psi.ch'
// Modifications by Joel C. Corbin (joel.c.corbin+sci@gmail.com) are tagged '// jcc'
#pragma version=20190527 // YYYYMMDD

//*************************************************************************************************************************************************
Function TopOfSP2_toolit_GraphProcs()
	//The only purpose of this function is to be the reference point for opening this procedure window from the menu bar.
	//=> leave this function at the top of the procedure window
End
//*************************************************************************************************************************************************

// MENUs

menu "SP2" // Basic menu for to Martin's SP2toolkit
	"SP2_panel_PSI/1", /Q 	// was /5

	"Show SP2 raw data for Cursor A/SF11", /Q, ShowSP2traceCorresp2CursorA()	// was /F11
	help = {"To view multiple events, use a marquee selection."}

	submenu "Advanced..."
		"Show all SP2 procedures"
		"Hide all procedures"  // in Gysels_sharedProcs
		"Show SP2 procedures - main window", ShowSP2procedures()	// was /7
		"Show SP2 procedures - graph procedures", ShowSP2graphprocedures()	// was /8
		"\\M0Show SP2 procedures - constants/menus", ShowSP2constants()	// was /9
		"Show file loading history", edit root:SP2toolkit:Panel:LoadHistory
		// "Show Access SP2 waves"
		
		"Reset all toolkit data...", SP2_deleteAllFolders()
		help = {"Deletes all unused SP2 folders in root:"}

		"Delete all unused SP2-toolkit waves in file...", SP2_deleteWavesNotInUse() 
		help = {"Any following analysis will need to start from scratch. Reduces the Igor-PXP file size (by 80-90%). Intended for rough/unneeded PXPs."}	
	end

	submenu "jTools for data and graph manipulation" 		// Data analysis tools

		submenu "jGraph........................"		// Graphing tools
			"\\M0I'm feeling lucky (use F6 on a graph for more options)", ifl()
			help= {"Auto-label, colour, space axes, error bars, and autoscale top graph."}
			
		//	"-" // Manipulate graph windows:
			"\\M0:(:Manipulate:"
			
			"Add graph buttons/F6", /Q, do_graph_buttons()
			help = {"See help for buttons."}
			
			submenu "Keyboard shortcuts..."
				"Bring Data Browser to front/3",/Q, CreateBrowser
				help = {"From http://www.igorexchange.com/node/2099"}
				
				"Bring Graph Browser to front/4", /Q, DoWindow/F GraphBrowserPanel 
				help = {""}

				"Add 'root:index:t_series' to Command Line.../5", /Q, ToCommandLine "root:index:t_series"
				help = {"Use while typing for quick access."}

				"Add 'root:diagnostics:' to Command Line.../6", /Q, ToCommandLine "root:diagnostics:"
				help = {"Use while typing for quick access."}

				"Page top graph left/F11", /Q, pageTopGraphLeft()
				help = {""}
				"Page top graph right/F12", /Q, pageTopGraphRight()
				help = {""}

				"Zoom x-axis to experiment index.../F9", /Q, xAxisToExpTimes(3.1415926)
				help = {"Input an index of root:XX:xNum. Requires waves 'xNum' and 'xStart' in that data folder."}

				"Zoom x-axis to experiment number...", /Q, xAxisToExpTimes(2.71828)
				help = {"Input a value in root:XX:xNum. Requires waves 'xNum' and 'xStart' in that data folder."}
			end
				
			"Rename top window.../F5", /Q, renameTopWindow("")	// renameTopWindow(winList("*","","WIN:"), forcePrompt=1)
			help = {"Given a string, makes a legal window name and sets window name and title."}
			
			"Add graph label.../SF5", /Q, addwhitelabel("") // addblacklabel("") // <-- not as good because doesn't print well
			help = {"Adds a high-contrast annotation to the graph. Useful for titling exports."} 

			"Tag top graph with current filename.../CSF5", /Q, addfiletag(username="jcc")
			help = {"Run twice to remove. Shortcut ALT+SHIFT+F5."}
			
			"Tag top graph with DF of 1st trace...", /Q, addDFtag()
			
			"Switch left axis to right", /Q, changeAxis(kill=0)
			help = {"Replots the top graph using the right axis instead of left. Other axes will be left unchanged."}
			
			"Shade experiment regions with nums/SF6", /Q, ShadeExpRegions(root:XX:xStart, root:XX:xStop, xNum=root:XX:xNum, autoFlag=1)
			help = {"Requires waves 'xStart', 'xStop' in 'root:summary'. An optional wave 'xNum' can specify labels. Run again to clear."}
				
			"\\M0Shade experiment regions w/o nums", /Q, ShadeExpRegions(root:XX:xStart, root:XX:xStop, xNum=root:XX:xNum, autoFlag=1, xNumFlag=0)
			help = {"Requires waves 'xStart', 'xStop' in 'root:summary'."}
			
		//	"\\M0Shade experiment regions [outline &&! shading]", /Q, ShadeExpRegions(root:XX:xStart, root:XX:xStop, xNum=root:XX:xNum, autoFlag=1); ModifyGraph hbFill(expShader)=0,lsize(expShader)=2
		//	help = {"Changes to outline instead of shading."}
			
			"-" // Make graphs:
			
			"\\M0:(:Create:"
			
			"Average all graphed data over X axis...",/Q, popup_gridToGraph()
			help= {"A wave called mask must be plotted on the top graph."}
			
			"Set plotted wave called 'mask' to 1 within visible x-axis/F8",/Q, setMaskWhereVisible()
			help= {"A wave called mask must be plotted on the top graph."}
			
			"Make a scatterplot + histogram",/Q, ToCOmmandLine "ScatterAndHist(XData,YData)"
			help = {"Help: See function description (Select from menu, right click function name in history, and use Go To)"}	
			
			
			"-" 
			
			"\\M0:(:Iterate:"
			
			"\\M0Save top graph to home directory (.png)", saveTopGraph()
			help = {"Overwrites pre-existing files without asking."}
			
			"\\M0Save (only) visible graphs to home directory...", saveAllVisibleGraphs()
			help = {"Saves to the home directory (wherever the Igor PXP is saved)."}
			
			"\\M0Zoom in on experiments and save a graph for each one", saveAllExptsGraphs()
			help = {"Saves with overwrite in the home directory."}

			"\\M0Insert a chosen graph as a subgraph to the top window...", /Q, insertAsSubGraph_popup()
			
			"\\M0Hide all visible graphs", graphrepeat("DoWindow /HIDE=1 %s")
			help = {"Re-show hidden graphs using HIDE=0, or 'Misc' -> 'Graph Browser' or 'Windows' -> 'Graphs'"}
			
			"Kill all unnamed graphs and tables.../SF7", /Q, killUnnamedGraphs();killUnnamedTables()
			help = {"Kills all graphs whose name start with 'Graph'. Dialog confirms first."}
		end
		
		submenu "Tools for iterating"
			
			"\\M0:(:Iterate a command:"
			
			"\\M0Repeat(command, list of arguments)...", /Q, ToCommandLine "repeat(cmd, args)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"\\M0WaveRepeat(command to run on all waves in DF)...", /Q, ToCommandLine "waverepeat(\"command\")"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"\\M0GraphRepeat(command to run on all visible graphs)...", /Q, ToCommandLine "graphrepeat(\"command\")"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}		

			"\\M0TraceRepeat(command to run on all traces in selected graph)...", /Q, ToCommandLine "tracerepeat(\"command\")"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}		

			"--("
			"\\M0:(:Iterate in subfolders:"
			"\\M0CombineSubfolderWaves(merges identically-named waves found within daughter folders)...", /Q, ToCommandLine "combineSubfolderWaves(waveNameStr, [WaveContainsTimes=0, numColsInWave, depth, use=RegExForInclusion, skip=RegExForExclusion])"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"\\M0IterateDF(command to repeat within daughter data folders)...", /Q, ToCommandLine "iterateDF(depth,cmd[, use, skip, filterAll])"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
		end
		
		submenu "Tools for XX 'experiments'"
			"\\M0Enter new experiment info by hand", enterNewExperiments()

			"\\M0Set data to nan outside of experiment start/stop times...", /Q, ToCommandLine "nanOutsideExperiments(data, root:index:t_series, root:XX:xStart, root:XX:xStop, overwrite=1)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	

			"\\M0Average over experiment times...", /Q, ToCommandLine "avgExps(data, dataTimes)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	

			"\\M0Create binary experiment mask (0/1/0/1/0)...", /Q, ToCommandLine "MakeExpMask(inf, dTimes)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	

			"\\M0Create incremental experiment mask (0/1/0/2/0/3)...", /Q, ToCommandLine "MakeExpMask(inf, dTimes, count=1)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"\\M0Expand an XX wave to match a given time series", /Q, ToCommandLine "expandExpToData(fillData, dTimes)"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"# 'Experiments' allow specific periods of interest to be averaged and compared.("
			"# See also trace popup menu (right-click on a graph's trace)("
		end
		
		submenu "\\M0Tools for grouping data"
			"\\M0Group-average data according to a category/key/index wave...", /Q, ToCommandLine "groupAverage(waveToAvg, dataKeys[, keyTol])"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
			
			"\\M0Find unique values in a given wave...", /Q, ToCommandLine "getKeys(keys[, tol, wname])"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	
		end
		
		submenu "Tools for fitting"
			"\\M0:(:Helpers for MultiPeakFitting 2.0:"

			"Add MPF2 results to this folder's MPF2 waves", /Q, MPF2Results2Table() // /F6"
			"Get MPF2 results ratios", /Q, MPF2Results2Ratios() // /SF6"
			// "Clear MPF2 results/SF6", clr_MPF2Results2Table()
			
			"\\M0:(:Fitting image waves:"
			
			"fit_matrix_by_row with lognormal...", /Q, ToCommandLine "fit_matrix_by_row(jccLogNormal, {0, 100, 300, ln(2)}, Counts, DiamMidpt,imgy=DiamBdr, imgx=::timeimg, holdStr=\"1000\")"
			"fit_matrix_by_row with biModalLogNormal...", /Q, ToCommandLine "fit_matrix_by_row(BimodalLogNormal, coefs, ug_log_mz36im_ssp23, dsig, mincol=20,imgy=im_dsig, imgx=root:index:imt_series)"
			help = {"coefs = {A1, A2, x01, x02, width1, width2}."}
			// w[0] = A1  		// peak amplitude on y-axis
			// w[1] = A2
			// w[2] = x01 		// x-axis position corresponding to peak y-amplitude
			// w[3] = x02
			// w[4] = Width1	// width of distribution (normally on the order of 0.1)
			// w[5] = Width2
			
			"Graph each row from matrix-by-row fit...", /Q, ToCommandLine " plot_fitted_matrix_overlays(datamatrix, fitmatrix, xaxis,[coefmatrix], [mask])"
			help = {"Use the graph browser to filter and view the result."}
			
			"Clear all graphs from matrix-by-row fit...", /Q, CLOSE_fitted_matrix_overlays()
			"Calculate area of lognormal", /Q, ToCommandLine "LogNormalArea(coefmatrix[][0],coefmatrix[][4],coefmatrix[][2])" // "LogNormalArea(A,width,x0)"
			help = {"LogNormalArea(A,width,x0). Error can be estimated from MPF."}
			
			"Quick and dirty extraction of modes from image...", /Q, ToCommandLine "quickExtractImageColModes(smps_dNdlogDp, Dm)"
			help = {"Creates '$input$_modes'. May want to do e.g. Savitsky-Golay smoothing (4th order, 21 pt often good)."}

			"\\M0:(:Tailing:"
			
			"Replace the autodetected rightmost tail of a distribution with a lognormal fit...", /Q, ToCommandLine "replaceRHStailWithFit(mean_dndlogDp, Dm, smthFactor=0.1)"
			help = {"The basic function for the matrix version. Useful for testing."}
			
			"Replace RHS-tail of image wave with lognormal fits...", /Q, ToCommandLine "replaceRhsTailsWithFits_byRow(dNdlogDp, Dm, smthFactor=0.1, imgy=Dm_IMG, imgx=smpsTime_IMG)"
			help = {"Graphs of each fit can be made using plot_fitted_matrix_overlays()."}
		end

		submenu "Tools for times"
			"\\M0Force a time series onto a specified (lower-res) time grid...", /Q, ToCommandLine "gridTo(wavesStr,timesStr, gridInMins, [t0, t1])"
			help = {"See function help for details."}	
				
			"\\M0Match a time series to a different one (preferably lower-res) (slow)...", /Q, ToCommandLine "matchTimesTo(data, dataTimes, targetTimes, [targetDurations, timesAreStart, ...])"
			help = {"Help: See function description in jTools.ipf (Select from menu, right click function name in history, and use Go To)"}	

			"\\M0Calculate diurnal trends (waves produced in current DF)...", /Q, ToCommandLine "averageAsDiurnal(data, times)"
			help = {"See function help for details."}	
			
			"\\M0Convert a time wave to datetime (w/ overflow at midnight)...", /Q, ToCommandLine "addDayToTimes(timeWave,dayToAdd)"
			help = {"Use date2secs() for dayToAdd. 86400 seconds are added *iff* time goes to 00:00."}	
		end
		
		// "\\M0Paste data from Excel (w/ headers && yyyy-mm-dd HH:MM:SS)", LoadWave/J/D/W/O/E=1/K=0/V={"\t"," $",0,0}/L={0,1,0,0,0}/R={English,2,2,2,2,"Year-Month-DayOfMonth",40} "Clipboard"
		"\\M0Paste copied headers+data from Excel", LoadWave/J/D/W/O/E=1/K=0/V={"\t"," $",0,0}/L={0,1,0,0,0}/R={English,2,2,2,2,"Year-Month-DayOfMonth",40} "Clipboard"
		help = {"Assumes 1st row contains headers. Times must be ISO 8601 format, e.g. `2010-10-25 13:01:59`. If not, change the /R flag or change Excel defaults using intl.cpl [Windows]."}	
			
		submenu "Help"
			"(1. For any function, right click and 'go to X' to see a example usage."
			"(1b. The procedures browser is good for this."
			"(2. Many functions are activated by clicking on a graph trace."
			"(3. Other functions are activated by drawing a marquee on a graph."
		end
		
		"Procedures browser panel", /Q, ProceduresBrowser()
		help = {"You can also use findProcedures() on the command line."}
	end

end



Function ShowAccessSP2waves()
	DisplayProcedure "SP2_accessAllWaves"
End


Function ShowAllSP2procedures()
	DisplayProcedure "TopOfSP2_toolit_Procs"
	DisplayProcedure "TopOfSP2_toolit_GraphProcs"
	DisplayProcedure "TopOfSP2_toolit_Constants"
	DisplayProcedure "TopOfTools_MG"
	DisplayProcedure "topOftheProcs_jGeneral"
	DisplayProcedure "topOftheProcs_jGraph"
End

Function ShowSP2procedures()
	DisplayProcedure "TopOfSP2_toolit_Procs"
End

Function ShowSP2graphprocedures()
	DisplayProcedure "TopOfSP2_toolit_GraphProcs"
End

Function ShowSP2constants()
	DisplayProcedure "TopOfSP2_toolit_Constants"
End


function SP2_panel_PSI()
	//ShowTools
	string savedDF=getdatafolder(1)
		
	//bring panel to front if it does already exist
	dowindow /F $ksSP2toolkitPanelWnam
	if (V_flag)
		//Panel does already exist => nothing else to do.
		return 0	
	endif
	
	//create SP2 toolkit
	PauseUpdate; DelayUpdate
	
	CreateFoldersOfFullPath(ksSP2PathToToolkitPanelFldr, 0)
	CreateFoldersOfFullPath(ksSP2PathToCalibDataFldr,0)
	CreateFoldersOfFullPath(ksSP2PathToMiePureScattFldr,0)
	CreateFoldersOfFullPath(ksSP2PathToMieCoatedBCfldr,0)
	//create global waves and variables for panel
	setdatafolder $ksSP2PathToToolkitPanelFldr
		//multiple tabs
			//still have to collect them from below
			string /g $ksSP2calibFldr
			Svar CalibFldr=$ksSP2calibFldr
			variable /g $ksSP2autoGraphCB=kSP2autoGraphCBdefault
			Nvar AutoGraphCB=$ksSP2autoGraphCB		
		//load tab
		variable /g $ksSP2sampleFlowPanel=kSP2sampleFlowPanelDefault
		Nvar SampleFlowPanel=$ksSP2sampleFlowPanel
		variable /g $ksSP2sampleFlowMode=NaN
		Nvar SampleFlowMode=$ksSP2sampleFlowMode
		variable /g $ksSP2YAGpowerpanel=kSP2YAGpowerPanelDefault
		Nvar YAGpowerPanel=$ksSP2YAGpowerpanel
		variable /g $ksSP2YAGpowerMode=kSP2YAGpowerModeDefault
		Nvar YAGpowerMode=$ksSP2YAGpowerMode
		variable /g $ksSP2YAGpowerModeInv=!kSP2YAGpowerModeDefault
		Nvar YAGpowerModeInv=$ksSP2YAGpowerModeInv
		variable /g $ksSP2LoadType=kSP2LoadTypeDefault
		Nvar LoadType=$ksSP2LoadType
		variable /g $ksSP2LoadFractMode=kSP2LoadFractModeDefault
		Nvar LoadFractMode=$ksSP2LoadFractMode
		variable /g $ksSP2LoadFractModeInv=!kSP2LoadFractModeDefault
		Nvar LoadFractModeInv=$ksSP2LoadFractModeInv
		variable /g $ksSP2LoadMaxDataRate=kSP2LoadMaxDataRateDefault
		Nvar LoadMaxDataRate=$ksSP2LoadMaxDataRate
		variable /g $ksSP2LoadOneOutOf=kSP2LoadOneOutOfDefault
		Nvar LoadOneOutOf=$ksSP2LoadOneOutOf
		variable /g $ksSP2loadConcatMode=kSP2LoadConcatModeDefault
		Nvar LoadConcatMode=$ksSP2loadConcatMode
		variable /g $ksSP2loadHKmode=kSP2LoadHKmodeDefault
		Nvar LoadHKmode=$ksSP2loadHKmode
		variable /g $ksSP2analyseTraces=kSP2analyseTracesDefault
		Nvar analyseTraces=$ksSP2analyseTraces
		variable /g $ksSP2performLEOfit=kSP2performLEOfitDefault
		Nvar performLEOfit=$ksSP2performLEOfit
		variable /g $ksSP2rawdatadelmode
		Nvar rawdatadelmode=$ksSP2rawdatadelmode
		variable /g $ksSP2postProcessing=kSP2postProcessingDefault
		Nvar postprocessing=$ksSP2postProcessing
		variable /g $ksSP2lognormfit=kSP2lognormfitDefault
		Nvar lognormfit=$ksSP2lognormfit	
		variable /g $ksSP2extractConcTimeSer=kSP2extractConcDefault
		Nvar ExtractConcTimeSer=$ksSP2extractConcTimeSer
		variable /g $ksSP2extractSDTimeSer=kSP2ectractSDdefault
		Nvar ExtractSizeDistTimeSer=$ksSP2extractSDTimeSer
		variable /g $ksSP2LoadHKtype=kSP2LoadHKtypeDefault
		Nvar LoadHKtype=$ksSP2LoadHKtype
		variable /g $ksSP2loadHKconcatMode=kSP2LoadHKconcatModeDefault
		Nvar LoadHKconcatMode=$ksSP2loadHKconcatMode
		variable /g $ksSP2loadHKremapMode=kSP2LoadHKremapModeDefault
		Nvar LoadHKremapMode=$ksSP2loadHKremapMode
		variable /g $ksSP2loadHKremapInt=kSP2loadHKremapIntDefault
		Nvar LoadHKremapInt=$ksSP2loadHKremapInt
		//calib tab
		variable /g $ksSP2calibBetaDMA=kSP2calibBetaDefault
		Nvar CalibBetaDMA=$ksSP2calibBetaDMA	
		variable /g $ksSP2calibMatBCdensity=kSP2densityofCalibBCdefault
		Nvar CalibMatBCdensity=$ksSP2calibMatBCdensity
		string /g $ksSP2calibMatBCtype=ksSP2FullereneSootMotekiAST2010
		Svar CalibMatBCtype=$ksSP2calibMatBCtype
		//trace analysis tab
		variable /g $ksSP2fitSCHGchan=kSP2fitSCHGdefault*(1-kSP2disableSCHG)
		Nvar fitscatt=$ksSP2fitSCHGchan
		variable /g $ksSP2fitBBHGchan=kSP2fitBBHGdefault*(1-kSP2disableBBHG)
		Nvar fitbroad=$ksSP2fitBBHGchan
		variable /g $ksSP2fitNBHGchan=kSP2fitNBHGdefault*(1-kSP2disableNBHG)
		Nvar fitnarr=$ksSP2fitNBHGchan
		variable /g $ksSP2fitSPHGchan=kSP2fitSPHGdefault*(1-kSP2disableSPHG)
		Nvar fitsplit=$ksSP2fitSPHGchan
		variable /g $ksSP2fitSCLGchan=kSP2fitSCLGdefault*(1-kSP2disableSCLG)
		Nvar fitscattLG=$ksSP2fitSCLGchan
		variable /g $ksSP2fitBBLGchan=kSP2fitBBLGdefault*(1-kSP2disableBBLG)
		Nvar fitbroadLG=$ksSP2fitBBLGchan
		variable /g $ksSP2fitNBLGchan=kSP2fitNBLGdefault*(1-kSP2disableNBLG)
		Nvar fitnarrLG=$ksSP2fitNBLGchan
		variable /g $ksSP2fitSPLGchan=kSP2fitSPLGdefault*(1-kSP2disableSPLG)
		Nvar fitsplitLG=$ksSP2fitSPLGchan
		variable /g $ksSP2subTabTAval=kSP2subTabTAvalDefault
		Nvar SubTabTAval=$ksSP2subTabTAval	
		variable /g $ksSP2scattfittype
		Nvar scattfittype=$ksSP2scattfittype
		variable /g $ksSP2scattFitnPts4Peak=kSP2scattFitnPts4PeakDef
		Nvar scattFitnPts4Peak=$ksSP2scattFitnPts4Peak
		variable /g $ksSP2incfittype//=kSP2incfittypedefault
		Nvar incfittype=$ksSP2incfittype
		variable /g $ksSP2splitSearchMode
		Nvar splitSearchMode=$ksSP2splitSearchMode
		variable /g $ksSP2splitPosMode
		Nvar splitPosMode=$ksSP2splitPosMode
		variable /g $ksSP2incFitMatchNarr2Broad=kSP2incFitMatchNarr2BroadDef
		Nvar incFitMatchNarr2Broad=$ksSP2incFitMatchNarr2Broad
		variable /g $ksSP2incFitnPts4Peak=kSP2incFitnPts4PeakDef
		Nvar incFitnPts4Peak=$ksSP2incFitnPts4Peak
		variable /g $ksSP2pretriggeravgmode=kSP2pretriggermodedefault
		Nvar PretriggerAvgMode=$ksSP2pretriggeravgmode
		variable /g $ksSP2pretriggeravgmodeInv=!kSP2pretriggermodedefault
		Nvar PretriggerAvgModeInv=$ksSP2pretriggeravgmodeInv
		variable /g $ksSP2pretriggernumb=kSP2pretriggerdefault
		Nvar PretriggerNumb=$ksSP2pretriggernumb
		variable /g $ksSP2baselineFiltermodeSCHG=kSP2baselinefiltermodeSCHGdef
		Nvar BaselineFilterModeSCHG=$ksSP2baselineFiltermodeSCHG
		variable /g $ksSP2baselineFiltermodeBBHG=kSP2baselinefiltermodeBBHGdef
		Nvar BaselineFilterModeBBHG=$ksSP2baselineFiltermodeBBHG
		variable /g $ksSP2baselineFiltermodeNBHG=kSP2baselinefiltermodeNBHGdef
		Nvar BaselineFilterModeNBHG=$ksSP2baselineFiltermodeNBHG
		variable /g $ksSP2baselineFiltermodeSPHG=kSP2baselinefiltermodeSPHGdef
		Nvar BaselineFilterModeSPHG=$ksSP2baselineFiltermodeSPHG
		variable /g $ksSP2baselineFiltermodeSCLG=kSP2baselinefiltermodeSCLGdef
		Nvar BaselineFilterModeSCLG=$ksSP2baselineFiltermodeSCLG
		variable /g $ksSP2baselineFiltermodeBBLG=kSP2baselinefiltermodeBBLGdef
		Nvar BaselineFilterModeBBLG=$ksSP2baselineFiltermodeBBLG
		variable /g $ksSP2baselineFiltermodeNBLG=kSP2baselinefiltermodeNBLGdef
		Nvar BaselineFilterModeNBLG=$ksSP2baselineFiltermodeNBLG
		variable /g $ksSP2baselineFiltermodeSPLG=kSP2baselinefiltermodeSPLGdef
		Nvar BaselineFilterModeSPLG=$ksSP2baselineFiltermodeSPLG
		variable /g $ksSP2baselineNoiseAmpSCHG=kSP2baselinenoiseSCHGdef
		Nvar BaselineNoiseAmpSCHG=$ksSP2baselineNoiseAmpSCHG
		variable /g $ksSP2baselineNoiseAmpBBHG=kSP2baselinenoiseBBHGdef
		Nvar BaselineNoiseAmpBBHG=$ksSP2baselineNoiseAmpBBHG
		variable /g $ksSP2baselineNoiseAmpNBHG=kSP2baselinenoiseNBHGdef
		Nvar BaselineNoiseAmpNBHG=$ksSP2baselineNoiseAmpNBHG
		variable /g $ksSP2baselineNoiseAmpSPHG=kSP2baselinenoiseSPHGdef
		Nvar BaselineNoiseAmpSPHG=$ksSP2baselineNoiseAmpSPHG
		variable /g $ksSP2baselineNoiseAmpSCLG=kSP2baselinenoiseSCLGdef
		Nvar BaselineNoiseAmpSCLG=$ksSP2baselineNoiseAmpSCLG
		variable /g $ksSP2baselineNoiseAmpBBLG=kSP2baselinenoiseBBLGdef
		Nvar BaselineNoiseAmpBBLG=$ksSP2baselineNoiseAmpBBLG
		variable /g $ksSP2baselineNoiseAmpNBLG=kSP2baselinenoiseNBLGdef
		Nvar BaselineNoiseAmpNBLG=$ksSP2baselineNoiseAmpNBLG
		variable /g $ksSP2baselineNoiseAmpSPLG=kSP2baselinenoiseSPLGdef
		Nvar BaselineNoiseAmpSPLG=$ksSP2baselineNoiseAmpSPLG
		variable /g $ksSP2SAIgetIt=kSP2SAIgetItDef
		Nvar SAIgetIt=$ksSP2SAIgetIt
		variable /g $ksSP2SAItimeLagStart=kSP2SAItimeLagStartDef
		Nvar SAItimeLagStart=$ksSP2SAItimeLagStart
		variable /g $ksSP2SAItimeLagEnd=kSP2SAItimeLagEndDef
		Nvar SAItimeLagEnd=$ksSP2SAItimeLagEnd
		string /g $ksSP2SAIchanPrefixInc
		Svar SAIchanPrefixInc=$ksSP2SAIchanPrefixInc
		variable/G $ksSP2useSAIforScattCalib
		NVAR useSAIforScattCalib=$ksSP2useSAIforScattCalib
		variable /g $ksSP2plotErrorBars=kSP2plotErrorBarsDefault
		Nvar plotErrorBars=$ksSP2plotErrorBars

		//post processing tab
		variable /g $ksSP2BCdensity=kSP2densityofBCdefault
		Nvar BCdensity=$ksSP2BCdensity
		variable /g $ksSP2nHistobins=kSP2nHistoBinsdefault
		Nvar nHistoBins=$ksSP2nHistobins
		variable/G $ksSP2treatSaturatedAsNaN=kSP2treatSaturatedAsNaNdefault
		NVAR treatSaturatedAsNaN= $ksSP2treatSaturatedAsNaN
		variable /g $ksSP2SCHGMinCut=kSP2SCHGthrshldCutDefault*(1-kSP2disableSCHG)
		Nvar MinCutSCHG=$ksSP2SCHGMinCut
		variable /g $ksSP2BBHGMinCut=kSP2BBHGthrshldCutDefault*(1-kSP2disableBBHG)
		Nvar MinCutBBHG=$ksSP2BBHGMinCut
		variable /g $ksSP2NBHGMinCut=kSP2NBHGthrshldCutDefault*(1-kSP2disableNBHG)
		Nvar MinCutNBHG=$ksSP2NBHGMinCut
		variable /g $ksSP2SPHGMinCut=kSP2SPHGthrshldCutDefault*(1-kSP2disableSPHG)
		Nvar MinCutSPHG=$ksSP2SPHGMinCut
		variable /g $ksSP2SCLGMinCut=kSP2SCLGthrshldCutDefault*(1-kSP2disableSCLG)
		Nvar MinCutSCLG=$ksSP2SCLGMinCut
		variable /g $ksSP2BBLGMinCut=kSP2BBLGthrshldCutDefault*(1-kSP2disableBBLG)
		Nvar MinCutBBLG=$ksSP2BBLGMinCut
		variable /g $ksSP2NBLGMinCut=kSP2NBLGthrshldCutDefault*(1-kSP2disableNBLG)
		Nvar MinCutNBLG=$ksSP2NBLGMinCut
		variable /g $ksSP2SPLGMinCut=kSP2SPLGthrshldCutDefault*(1-kSP2disableSPLG)
		Nvar MinCutSPLG=$ksSP2SPLGMinCut
		variable /g $ksSP2SCHGdetectCut=kSP2SCHGdetectCutDefault*(1-kSP2disableSCHG)
		Nvar DetectCutSCHG=$ksSP2SCHGdetectCut
		variable /g $ksSP2BBHGdetectCut=kSP2BBHGdetectCutDefault*(1-kSP2disableBBHG)
		Nvar DetectCutBBHG=$ksSP2BBHGdetectCut
		variable /g $ksSP2NBHGdetectCut=kSP2NBHGdetectCutDefault*(1-kSP2disableNBHG)
		Nvar DetectCutNBHG=$ksSP2NBHGdetectCut
		variable /g $ksSP2SPHGdetectCut=kSP2SPHGdetectCutDefault*(1-kSP2disableSPHG)
		Nvar DetectCutSPHG=$ksSP2SPHGdetectCut
		variable /g $ksSP2SCLGdetectCut=kSP2SCLGdetectCutDefault*(1-kSP2disableSCLG)
		Nvar DetectCutSCLG=$ksSP2SCLGdetectCut
		variable /g $ksSP2BBLGdetectCut=kSP2BBLGdetectCutDefault*(1-kSP2disableBBLG)
		Nvar DetectCutBBLG=$ksSP2BBLGdetectCut
		variable /g $ksSP2NBLGdetectCut=kSP2NBLGdetectCutDefault*(1-kSP2disableNBLG)
		Nvar DetectCutNBLG=$ksSP2NBLGdetectCut
		variable /g $ksSP2SPLGdetectCut=kSP2SPLGdetectCutDefault*(1-kSP2disableSPLG)
		Nvar DetectCutSPLG=$ksSP2SPLGdetectCut
		variable /g $ksSP2calcBHNH=kSP2calcBHNHdefault*(1-(kSP2disableBBHG | kSP2disableNBHG))
		Nvar calcBHNH=$ksSP2calcBHNH
		variable /g $ksSP2calcBHNL=kSP2calcBHNLdefault*(1-(kSP2disableBBHG | kSP2disableNBLG))
		Nvar calcBHNL=$ksSP2calcBHNL
		variable /g $ksSP2calcBHBL=kSP2calcBHBLdefault*(1-(kSP2disableBBHG | kSP2disableBBLG))
		Nvar calcBHBL=$ksSP2calcBHBL
		variable /g $ksSP2calcBLNL=kSP2calcBLNLdefault*(1-(kSP2disableBBLG | kSP2disableNBLG))
		Nvar calcBLNL=$ksSP2calcBLNL
		variable /g $ksSP2calcSHSL=kSP2calcSHSLdefault*(1-(kSP2disableSCHG | kSP2disableSCLG))
		Nvar calcSHSL=$ksSP2calcSHSL
		variable /g $ksSP2calcPHPL=kSP2calcPHPLdefault*(1-(kSP2disableSPHG | kSP2disableSPLG))
		Nvar calcPHPL=$ksSP2calcPHPL
		string /g $ksSP2scattRefractIndex
		Svar ScattRefractIndex=$ksSP2scattRefractIndex
		variable /g $ksSP2LogNormFitDmeasMin=kSP2LNfitDmeasMinDefault
		Nvar LogNormFitDmeasMin=$ksSP2LogNormFitDmeasMin
		variable /g $ksSP2LogNormFitDmeasMax=kSP2LNfitDmeasMaxDefault
		Nvar LogNormFitDmeasMax=$ksSP2LogNormFitDmeasMax
		variable /g $ksSP2LogNormFitDfitMin=kSP2LNfitDfitMinDefault
		Nvar LogNormFitDfitMin=$ksSP2LogNormFitDfitMin
		variable /g $ksSP2LogNormFitDfitMax=kSP2LNfitDfitMaxDefault
		Nvar LogNormFitDfitMax=$ksSP2LogNormFitDfitMax
		variable /g $ksSP2LogNormFitnPts=kSP2LNfitNfitPtsDefault
		Nvar LogNormFitnPts=$ksSP2LogNormFitnPts
		variable /g $ksSP2concInterval=kSP2ConcIntervalDefault
		Nvar ConcInterval=$ksSP2concInterval
		variable /g $ksSP2SDinterval=kSP2SDtserIntervalDefault
		Nvar SDinterval=$ksSP2SDinterval
		variable /g $ksSP2SDnbins=kSP2SDtserNumbBinsDefault
		Nvar SDnbins=$ksSP2SDnbins
		//LEO tab
		variable /g $ksSP2LEOfitRange=kSP2LEOfitRangeDefault
		Nvar LEOfitRange=$ksSP2LEOfitRange
		variable /g $ksSP2LEOfitminNumPts=kSP2LEOfitMinNptsDefault
		Nvar LEOfitMinNumPnts=$ksSP2LEOfitMinNumPts
		variable /g $ksSP2LEOfitFastFit=kSP2LEOfitFastFitDefault
		Nvar LEOfitFastFit=$ksSP2LEOfitFastFit
		variable /g $ksSP2LEOfitFastNumPts=kSP2LEOfitFastNumPtsDef
		Nvar LEOfitFastNumPts=$ksSP2LEOfitFastNumPts
		variable /g $ksSP2leoFitSkipGaussCB=kSP2LEOfitSkipGaussDefault
		Nvar LEOfitSkipGaussCB=$ksSP2leoFitSkipGaussCB
		variable /g $ksSP2leoFitSkipBeamShapeCB=kSP2LEOfitSkipBeamShapeDefault
		Nvar LEOfitSkipBeamShapeCB=$ksSP2leoFitSkipBeamShapeCB
		variable /g $ksSP2leoFitPostProcModeCB=kSP2LEOfitPostProcModeDefault
		Nvar LEOfitPostProcModeCB=$ksSP2leoFitPostProcModeCB	
		variable/G $ksSP2LEOnegCoatingAsNoise=kSP2LEOnegCoatAsNoiseDefault
		NVAR LEOnegCoatingAsNoise=$ksSP2LEOnegCoatingAsNoise
		variable /g $ksSP2leoFitSCHGcb=kSP2LEOfitSCHGdefault
		Nvar LEOfitSCHGcb=$ksSP2leoFitSCHGcb
		variable /g $ksSP2leoFitSCLGcb=kSP2LEOfitSCLGdefault
		Nvar LEOfitSCLGcb=$ksSP2leoFitSCLGcb
		variable /g $ksSP2leoFitSPHGcb=kSP2LEOfitSPHGdefault
		Nvar LEOfitSPHGcb=$ksSP2leoFitSPHGcb
		variable /g $ksSP2leoFitSPLGcb=kSP2LEOfitSPLGdefault
		Nvar LEOfitSPLGcb=$ksSP2leoFitSPLGcb
		string /g $ksSP2leoSplitChanPrefix
		Svar LEOsplitChanPrefix=$ksSP2leoSplitChanPrefix
		variable /g $ksSP2SCHGprefix+ksSP2leoFitSlopeFudgeResetCB=kSP2LEOfitSlopeResetSCHGDef
		Nvar LEOfitSlopeResetSCHGCB=$ksSP2SCHGprefix+ksSP2leoFitSlopeFudgeResetCB
		variable /g $ksSP2SCLGprefix+ksSP2leoFitSlopeFudgeResetCB=kSP2LEOfitSlopeResetSCLGDef
		Nvar LEOfitSlopeResetSCLGCB=$ksSP2SCLGprefix+ksSP2leoFitSlopeFudgeResetCB
		variable /g $ksSP2SPHGprefix+ksSP2leoFitSplitCalResetCB=kSP2LEOfitCalFactResetSPHGDef
		Nvar LEOfitCalFactResetSPHGCB=$ksSP2SPHGprefix+ksSP2leoFitSplitCalResetCB
		variable /g $ksSP2SPLGprefix+ksSP2leoFitSplitCalResetCB=kSP2LEOfitCalFactResetSPLGDef
		Nvar LEOfitCalFactResetSPLGCB=$ksSP2SPLGprefix+ksSP2leoFitSplitCalResetCB
		string /g $ksSP2SPHGprefix+ksSP2leoSplitCalChanPrefix
		Svar LEOsplitCalChanPrefixSPHG=$ksSP2SPHGprefix+ksSP2leoSplitCalChanPrefix
		string /g $ksSP2SPLGprefix+ksSP2leoSplitCalChanPrefix
		Svar LEOsplitCalChanPrefixSPLG=$ksSP2SPLGprefix+ksSP2leoSplitCalChanPrefix
		string /g $ksSP2leoIncandPrefix
		Svar LEOincandPrefix=$ksSP2leoIncandPrefix
		string /g $ksSP2leoRefractIndexPair
		Svar LEOrefractIndexPair=$ksSP2leoRefractIndexPair
		variable /g $ksSP2leoFitStatsRunCB=kSP2LEOfitStatsRunDef
		Nvar LEOfitStatsRunCB=$ksSP2leoFitStatsRunCB
		variable /g $ksSP2leoFitStatsMedianCB=kSP2LEOfitStatsMedianDef
		Nvar LEOfitStatsMedianCB=$ksSP2leoFitStatsMedianCB
		variable /g $ksSP2SCHGprefix+ksSP2leoMinPeakHeightSV=kSP2LEOminPkHtSCHGdef
		Nvar SCHG_MinPeakHtSV=$ksSP2SCHGprefix+ksSP2leoMinPeakHeightSV
		variable /g $ksSP2SCLGprefix+ksSP2leoMinPeakHeightSV=kSP2LEOminPkHtSCLGdef
		Nvar SCLG_MinPeakHtSV=$ksSP2SCLGprefix+ksSP2leoMinPeakHeightSV
		variable /g $ksSP2SPHGprefix+ksSP2leoMinPeakHeightSV=kSP2LEOminPkHtSPHGdef
		Nvar SPHG_MinPeakHtSV=$ksSP2SPHGprefix+ksSP2leoMinPeakHeightSV
		variable /g $ksSP2SPLGprefix+ksSP2leoMinPeakHeightSV=kSP2LEOminPkHtSPLGdef
		Nvar SPLG_MinPeakHtSV=$ksSP2SPLGprefix+ksSP2leoMinPeakHeightSV
		variable /g $ksSP2leoLimitBCdiamCB=kSP2LEOlimitBCdiamDefault
		Nvar LEOlimitBCdiamCB=$ksSP2leoLimitBCdiamCB
		variable /g $ksSP2leoLimitOptDiamCB=kSP2LEOlimitOptDiamDefault
		Nvar LEOlimitOptdiamCB=$ksSP2leoLimitOptDiamCB
		variable /g $ksSP2diamRangeMinSV=kSP2LEOdiamRangeMindefault
		Nvar LEOdiamRangeMinSV=$ksSP2diamRangeMinSV
		variable /g $ksSP2diamRangeMaxSV=kSP2LEOdiamRangeMaxdefault
		Nvar LEOdiamRangeMaxSV=$ksSP2diamRangeMaxSV
		variable /g $ksSP2leoNumbSizeBinsSV=kSP2LEOnumbSizeBinsDefault
		Nvar LEOnumbSizeBinsSV=$ksSP2leoNumbSizeBinsSV
		variable /g $ksSP2nBinsBCVolFracHistSV=kSP2LEOnBinsBCVFhistDef
		Nvar LEOnBinsBCvolFracHistSV=$ksSP2nBinsBCVolFracHistSV
		variable /g $ksSP2nBinsBCCoatThicknHistSV=kSP2LEOnBinsBCCThistDef
		Nvar LEOnBinsCoatThicknHistSV=$ksSP2nBinsBCCoatThicknHistSV
		variable /g $ksSP2nBinsDelayHistSV=kSP2LEOnBinsDelayHistDef
		Nvar LEOnBinsDelayHistSV=$ksSP2nBinsDelayHistSV
		string /g $ksSP2SAIchanPrefixPSD
		Svar SAIchanPrefixPSD=$ksSP2SAIchanPrefixPSD	
		//graphs tables tab
			//none?
		//ice core tab
		variable /g $ksSP2CETACsampleflow=kSP2CETACsampleflowDefault
		Nvar CETACsampleflow=$ksSP2CETACsampleflow
		variable /g $ksSP2CETACdrainflow=kSP2CETACdrainflowDefault
		Nvar CETACdrainflow=$ksSP2CETACdrainflow
		variable /g $ksSP2CETACpurgeairflow=kSP2CETACpurgeairflowDefault
		Nvar CETACpurgeairflow=$ksSP2CETACpurgeairflow
		//config tab
		string /g $ksSP2chan0config=stringfromlist(kSP2chan0configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_0=$ksSP2chan0config	
		string /g $ksSP2chan1config=stringfromlist(kSP2chan1configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_1=$ksSP2chan1config
		string /g $ksSP2chan2config=stringfromlist(kSP2chan2configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_2=$ksSP2chan2config
		string /g $ksSP2chan3config=stringfromlist(kSP2chan3configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_3=$ksSP2chan3config
		string /g $ksSP2chan4config=stringfromlist(kSP2chan4configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_4=$ksSP2chan4config
		string /g $ksSP2chan5config=stringfromlist(kSP2chan5configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_5=$ksSP2chan5config
		string /g $ksSP2chan6config=stringfromlist(kSP2chan6configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_6=$ksSP2chan6config
		string /g $ksSP2chan7config=stringfromlist(kSP2chan7configdefault,SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()))
		Svar ChanConfig_7=$ksSP2chan7config
		variable /g $ksSP2loadSCHGchan=kSP2loadSCHGdefault*(1-kSP2disableSCHG)
		Nvar loadscatt=$ksSP2loadSCHGchan
		variable /g $ksSP2loadBBHGchan=kSP2loadBBHGdefault*(1-kSP2disableBBHG)
		Nvar loadbroad=$ksSP2loadBBHGchan
		variable /g $ksSP2loadNBHGchan=kSP2loadNBHGdefault*(1-kSP2disableNBHG)
		Nvar loadnarr=$ksSP2loadNBHGchan
		variable /g $ksSP2loadSPHGchan=kSP2loadSPHGdefault*(1-kSP2disableSPHG)
		Nvar loadsplit=$ksSP2loadSPHGchan
		variable /g $ksSP2loadSCLGchan=kSP2loadSCLGdefault*(1-kSP2disableSCLG)
		Nvar loadSCLG=$ksSP2loadSCLGchan
		variable /g $ksSP2loadBBLGchan=kSP2loadBBLGdefault*(1-kSP2disableBBLG)
		Nvar loadBBLG=$ksSP2loadBBLGchan
		variable /g $ksSP2loadNBLGchan=kSP2loadNBLGdefault*(1-kSP2disableNBLG)
		Nvar loadNBLG=$ksSP2loadNBLGchan
		variable /g $ksSP2loadSPLGchan=kSP2loadSPLGdefault*(1-kSP2disableSPLG)
		Nvar loadSPLG=$ksSP2loadSPLGchan
		variable /g $ksSP2invertSPHGchan=kSP2invertSPHGdefault
		Nvar invertSPHG=$ksSP2invertSPHGchan
		variable /g $ksSP2invertSPLGchan=kSP2invertSPLGdefault
		Nvar invertSPLG=$ksSP2invertSPLGchan
		variable /g $ksSP2maxSigSCHG=kSP2MaxSigSCHGdefault
		Nvar MaxSigSCHG=$ksSP2maxSigSCHG
		variable /g $ksSP2maxSigBBHG=kSP2MaxSigBBHGdefault
		Nvar MaxSigBBHG=$ksSP2maxSigBBHG
		variable /g $ksSP2maxSigNBHG=kSP2MaxSigNBHGdefault
		Nvar MaxSigNBHG=$ksSP2maxSigNBHG
		variable /g $ksSP2maxSigSPHG=kSP2MaxSigSPHGdefault
		Nvar MaxSigSPHG=$ksSP2maxSigSPHG
		variable /g $ksSP2maxSigSCLG=kSP2MaxSigSCLGdefault
		Nvar MaxSigSCLG=$ksSP2maxSigSCLG
		variable /g $ksSP2maxSigBBLG=kSP2MaxSigBBLGdefault
		Nvar MaxSigBBLG=$ksSP2maxSigBBLG
		variable /g $ksSP2maxSigNBLG=kSP2MaxSigNBLGdefault
		Nvar MaxSigNBLG=$ksSP2maxSigNBLG
		variable /g $ksSP2maxSigSPLG=kSP2MaxSigSPLGdefault
		Nvar MaxSigSPLG=$ksSP2maxSigSPLG
		variable /g $ksSP2samplingRateRawDataMHz=ksSP2samplingRateRawDataMHzDef
		Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz		
		
		
	//create panel
	NewPanel /K=3 /W=(393,56,1226,748) as ksSP2toolkitPanelWnam // jcc-- hide instead of kill to avoid problems
	dowindow /c SP2_Toolkit_PSI
	//draw info text and add logos
	SetDrawLayer UserBack
	DrawRect 16,8,811,102
	DrawPICT 22,17,0.6,0.6,PSI_Logo_narrow_pc_jpg
	DrawPICT 659,16,0.65,0.65,LAC_logo_colour_highRes_png
	DrawText 346,52,"martin.gysel@psi.ch"
	DrawText 327,69,"http://www.psi.ch/lac/martin-gysel"
	SetDrawEnv fsize= 16,fstyle= 1,textrgb= (0,26112,39168) // (65280,0,0)
	DrawText 328,35,"PSI SP2 toolkit "+ksSP2toolkitversionstring

	//create controls
		//take care with ListWave=..., value=... and variable=... when updating
		//ListBoxes, CheckBoxes, SetVariables, or PopupMenus

	//background
		Button CreditsButt,pos={330,77},size={160,20},proc=SP2_credits_panel,title="Credits"
		Button CreditsButt,font="Arial",fSize=11,fColor=(62000,62000,62000)
	//Main TAB-CONTROL
		TabControl SP2panelPSIMainTabs,pos={13,126},size={800,555},bodyWidth=300,proc=SP2panelPSIMainTabProc,fSize=11,font="Arial"
		TabControl SP2panelPSIMainTabs,tabLabel(0)="Load Data"
		TabControl SP2panelPSIMainTabs,tabLabel(1)="Calibration"
		TabControl SP2panelPSIMainTabs,tabLabel(2)="Trace Analysis"
		TabControl SP2panelPSIMainTabs,tabLabel(3)="Post Processing"
		TabControl SP2panelPSIMainTabs,tabLabel(4)="LEO-FIT"
		TabControl SP2panelPSIMainTabs,tabLabel(5)="Graphs/Tables"
		TabControl SP2panelPSIMainTabs,tabLabel(6)="Ice Cores"
		TabControl SP2panelPSIMainTabs,tabLabel(7)="Configuration"
		TabControl SP2panelPSIMainTabs, value= 0
	//load tab
		TitleBox NoteChannelConfig,pos={38,198},size={133,34},frame=5,fColor=(65280,0,0),title=" set channel configuration \r on \"Config\"-tab first!",font="Arial",fSize=11
		TitleBox SampleFlowFrom,pos={29,284},size={25,14},title="from:",font="Arial",fSize=11,frame=0
		PopupMenu LoadTypeMenu,pos={192,173},size={144,23},proc=SP2panelPSILoadTypeProc,title="load type:"
		PopupMenu LoadTypeMenu,mode=kSP2LoadTypeDefault,value=ksSP2LoadTypeList,fSize=11,font="Arial"
		PopupMenu LoadHKtypeMenu,pos={30,465},size={132,21},proc=SP2panelPSILoadHKTypeProc,title="load type:"
		PopupMenu LoadHKtypeMenu,mode=kSP2LoadHKtypeDefault,value=ksSP2LoadHKtypeList,font="Arial",fSize=11
		Button loadrawdata,pos={30,172},size={150,20},proc=SP2_LoadRawData,title="load raw data",fSize=11,font="Arial"
		Button WriteSampleFlowWaveBtt,pos={27,259},size={150,20},proc=SP2sampleFlowGetDataBtt,title="write sample flow wave",font="Arial",fSize=11
		Button WriteYAGpowerWaveBtt,pos={27,339},size={150,20},proc=SP2_YAGpowerGetHKdata,title="write YAG power wave",font="Arial",fSize=11
		Button LoadHKfiles,pos={26,439},size={180,20},proc=SP2_LoadHKfiles,title="load housekeeping files",font="Arial",fSize=11
		Button LoadOneHKfile,pos={346,434},size={180,20},proc=SP2_LoadHouseKeepingFileButt,title="load one housekeeping file",font="Arial",fSize=11
		Button ConcatenateHFfldrs,pos={346,458},size={180,20},proc=SP2_ConcatenateHKfldrs,title="concatenate housekeeping folders",font="Arial",fSize=11
		Button HKdataRemapButt,pos={346,482},size={180,20},proc=SP2_HKfileRemapper,title="remap housekeeping data",font="Arial",fSize=11
		Button DeleteSP2DataByIndex,pos={33,549},size={200,20},proc=SP2_DeleteDataIndexRange,title="delete range of SP2 data by row index",font="Arial",fSize=11
		Button DeleteSP2DataByTime,pos={33,575},size={200,20},proc=SP2_DeleteDataTimeRange,title="delete range of SP2 data by time",font="Arial",fSize=11
		Button DeleteSP2DataByExpression,pos={33,601},size={200,20},proc=SP2_DeleteDataByExpression,title="delete subset of SP2 data",font="Arial",fSize=11
		Button ConcatenateSP2rawfldrs,pos={257,575},size={200,20},proc=SP2_ConcatenateDataFldrs,title="concatenate SP2 raw data folders",font="Arial",fSize=11
		GroupBox LoadRawData_GB,pos={21,151},size={513,260},title="load SP2 raw data",font="Arial",fSize=11
		GroupBox LoadHDdata_GB,pos={21,415},size={513,105},title="load SP2 housekeeping data",font="Arial",fSize=11
		GroupBox DeleteSP2rawData_GB,pos={20,526},size={224,104},title="delete SP2 data",font="Arial",fSize=11
		CheckBox SampleFlowFromHK,pos={59,284},size={32,14},proc=SP2_SampleFlowModeCBproc,title="HK",font="Arial",fSize=11
		CheckBox SampleFlowFromHK
		CheckBox SampleFlowFromINI,pos={98,284},size={29,14},proc=SP2_SampleFlowModeCBproc,title="INI",font="Arial",fSize=11
		CheckBox SampleFlowFromINI
		CheckBox SampleFlowFromConst,pos={134,284},size={48,14},proc=SP2_SampleFlowModeCBproc,title="const.",font="Arial",fSize=11
		CheckBox SampleFlowFromConst
		CheckBox YAGpowerConst,pos={33,364},size={48,14},title="const.",font="Arial",fSize=11
		CheckBox YAGpowerConst,variable=YAGpowerMode, proc=SP2_YAGpowerModeCBproc
		CheckBox YAGpowerFromHK,pos={98,364},size={57,14},title="from HK",font="Arial",fSize=11
		CheckBox YAGpowerFromHK,variable=YAGpowerModeInv, proc=SP2_YAGpowerModeCBproc
		CheckBox LoadFractModeInvCB,pos={192,201},size={134,15},title="load one of every n particles:",fSize=11,font="Arial"
		CheckBox LoadFractModeInvCB,variable=LoadFractModeInv,proc=SP2_LoadFractCBproc
		CheckBox LoadFractModeCB,pos={192,221},size={134,15},title="limit maximum data rate:",fSize=11,font="Arial"
		CheckBox LoadFractModeCB,variable=LoadFractMode,proc=SP2_LoadFractCBproc
		CheckBox ConcatMode,pos={192,241},size={134,15},title="concatenate raw files",fSize=11,font="Arial"
		CheckBox ConcatMode,variable=LoadConcatMode
		CheckBox hkloadmode,pos={192,261},size={158,15},title="load housekeeping file(s)",fSize=11,font="Arial"
		CheckBox hkloadmode,variable=LoadHKmode
		CheckBox AnalyseTracesMode,pos={192,281},size={90,14},title="analyse traces",font="Arial",fSize=11
		CheckBox AnalyseTracesMode,variable=analyseTraces
		CheckBox LEOfitModeLoadTab,pos={296,281},size={51,14},title="LEO-fit",font="Arial",fSize=11
		CheckBox LEOfitModeLoadTab,variable=performLEOfit
		CheckBox rawdatadelCB1,pos={192,301},size={111,15},title="delete raw data after analysing",fSize=11,font="Arial"
		CheckBox rawdatadelCB1,variable=rawdatadelmode, proc=SP2_CBP_rawDataDelChk // v4111 added proc
		CheckBox PostProcessingMode,pos={192,321},size={180,14},title="post processing of trace analysis",font="Arial",fSize=11
		CheckBox PostProcessingMode,variable=postprocessing
		CheckBox LEOrunPostProcLoadTab,pos={382,321},size={144,14},title="post processing of LEO fit",font="Arial",fSize=11
		CheckBox LEOrunPostProcLoadTab,variable=LEOfitPostProcModeCB
		CheckBox LogNormFitModeLtab,pos={192,341},size={160,14},title="fit lognormal size distributions",font="Arial",fSize=11
		CheckBox LogNormFitModeLtab,variable=lognormfit
		CheckBox ExtractConcModeLtab,pos={192,361},size={176,14},title="extract concentration time series",font="Arial",fSize=11
		CheckBox ExtractConcModeLtab,variable=ExtractConcTimeSer
		CheckBox ExtractSDModeLtab,pos={192,381},size={185,14},title="extract size distribution time series",font="Arial",fSize=11
		CheckBox ExtractSDModeLtab,variable=ExtractSizeDistTimeSer
		CheckBox HKConcatMode,pos={30,494},size={118,14},title="concatenate HK files"
		CheckBox HKConcatMode,variable=LoadHKconcatMode,font="Arial",fSize=11
		CheckBox HKremapMode,pos={205,470},size={88,14},title="remap when loading"
		CheckBox HKremapMode,variable=LoadHKremapMode,font="Arial",fSize=11
		SetVariable LoadOneOutOfSetVar,pos={414,199},size={89,18},bodyWidth=70,title="n =",font="Arial",fSize=11
		SetVariable LoadOneOutOfSetVar,format="%d",limits={1,inf,1},value=LoadOneOutOf
		SetVariable MaxDataRateSetVar,pos={333,219},size={170,18},bodyWidth=70,title="max. rate [#/h] =",font="Arial",fSize=11
		SetVariable MaxDataRateSetVar,format="%.2f",limits={1,inf,1},value=LoadMaxDataRate
		SetVariable SampleFlowSV,pos={34,303},size={130,18},bodyWidth=60,title="flow [cm\\S3\\M/min]",font="Arial",fSize=11
		SetVariable SampleFlowSV,format="%0.1f",limits={-inf,inf,0.01},value=SampleFlowPanel
		SetVariable YAGpowerSV,pos={34,383},size={130,18},bodyWidth=50,title="YAG power [V]",font="Arial",fSize=11
		SetVariable YAGpowerSV,format="%0.2f",limits={-inf,inf,0.01},value=YAGpowerPanel
		SetVariable LoadHKfilesRemapInt,pos={169,491},size={157,18},bodyWidth=70,title="remap interval [s]"
		SetVariable LoadHKfilesRemapInt,format="%d",limits={1,inf,1},value=LoadHKremapInt,font="Arial",fSize=11
	//calibration tab
		PopupMenu CalibFldrCalibTab,pos={41,173},size={316,22},bodyWidth=230,title="select calibration",proc=SP2_SelectCalibFldrPMproc,fSize=11,font="Arial"
		PopupMenu CalibFldrCalibTab,value=SP2_CalibListUpdate()
		PopupMenu BCcalibMatPM,pos={56,336},size={236,21},bodyWidth=193,proc=SP2_SelectCalibMatBCPMproc,title="BC type",font="Arial",fSize=11
		PopupMenu BCcalibMatPM,value=ksSP2calibMatList
		PopupMenu ScattSizingRefractIndexCalTab,pos={55,507},size={212,21},proc=SP2_SelectScattRefractPMproc,title="refractive index:",font="Arial",fSize=11
		PopupMenu ScattSizingRefractIndexCalTab,value=SP2_MiePureScattDataFldrList()
		Button CalibAnalyseMonoIncand,pos={54,309},size={190,20},proc=SP2_CalibAnalyzerIncandMono,title="analyse monodisperse calibration",font="Arial",fSize=11
		Button CalibMonoIncandFitSpline,pos={55,391},size={190,20},proc=SP2calib_FitCalCurve,title="fit calibration curve (spline)",font="Arial",fSize=11
		Button CalibAnalyseMonoScatt,pos={54,455},size={190,20},proc=SP2_CalibAnalyzerScatt,title="analyse monodisperse calibration",font="Arial",fSize=11
		Button CalibAnalyseMonoScattPostProc,pos={54,481},size={190,20},proc=SP2_CalibAnalyzerScattpostproc,title="calibration post processing",font="Arial",fSize=11
		Button CreateCalibCoeffWavs,pos={56,562},size={190,20},proc=SP2_Calib_DummyCalibCoeffButt,title="create waves for calib. coef.",font="Arial",fSize=11
		Button CalcCalibCurveWavs,pos={56,590},size={190,20},proc=SP2_Calib_AddCalibCurveWavesBtt,title="calculate calib. curves from coef.",font="Arial",fSize=11
		Button DMPSloadRawData,pos={325,285},size={190,20},proc=SP2_DMPSdataLoaderButt,title="load DMPS raw data",font="Arial",fSize=11
		Button DMPSdummyMatrices,pos={325,310},size={190,20},proc=SP2_calib_DMPSdataDummyWavsButt,title="create empty matrices for DMPS data",font="Arial",fSize=11
		Button DMPSextractTimeSeries,pos={325,335},size={190,20},proc=SP2_calib_DMPSdataPrepButt,title="extra time series from DMPS matrices",font="Arial",fSize=11
		Button CPCDMAloadRawData,pos={325,389},size={190,20},proc=LoadRawDataCPCDMAOneFile,title="load CPC-DMA-logger data file",font="Arial",fSize=11
		Button CreateEmptyCPCDMAdataWaves,pos={325,414},size={190,20},title="create empty CPC/DMA data waves",font="Arial",fSize=11
		Button CPCDMAextractTimeSeries,pos={325,439},size={190,20},proc=SP2_calib_CPCDMAdataPrepButt,title="extra time series from CPC/DMA data",font="Arial",fSize=11
		Button BCemptyInfoWavsButt,pos={325,493},size={200,20},proc=SP2_CalibBCinfoWavesPrepButt,title="create empty BC calib info waves",font="Arial",fSize=11
		Button ScattEmptyInfoWavsButt,pos={325,550},size={200,20},proc=SP2_CalibScattInfoWavesPrepButt,title="create empty scattering calib info waves",font="Arial",fSize=11
		Button ScattGetStartEndTimes,pos={325,575},size={200,20},proc=SP2_CalibScattGetTimesButt,title="get start and end times from SP2 data",font="Arial",fSize=11
		GroupBox CalibConstCalibTabGB,pos={26,152},size={350,52},title="calibration constants",font="Arial",fSize=11
		GroupBox AnalyseCalibration,pos={36,265},size={271,360},title="analyse calibration",font="Arial",fSize=11
		GroupBox CalibIncandChannelsGB,pos={46,289},size={252,130},title="incandescence channels",font="Arial",fSize=11
		GroupBox CalibScattChannelsGB,pos={47,433},size={252,104},title="scattering channel",font="Arial",fSize=11
		GroupBox CalibAllChannelsGB,pos={47,544},size={252,75},title="all channels",font="Arial",fSize=11
		GroupBox DMPSdataPrep,pos={316,265},size={220,100},title="DMPS data preparation",font="Arial",fSize=11
		GroupBox CPCDMAloggerGB,pos={316,369},size={220,100},title="CPC-DMA-logger",font="Arial",fSize=11
		GroupBox IncandCalibDataPrepGB,pos={316,474},size={220,50},title="BC calibration info preparation",font="Arial",fSize=11
		GroupBox ScattCalibDataPrepGB,pos={316,530},size={220,75},title="scattering calibration info preparation",font="Arial",fSize=11
		SetVariable BetaDMA,pos={33,216},size={100,18},title="beta DMA",font="Arial",fSize=11,format="%.2f"
		SetVariable BetaDMA,limits={0,inf,0.1},value=CalibBetaDMA
		SetVariable BCdensityCalibMat,pos={55,367},size={170,18},title="mobility density [kg m\S-3\M]",font="Arial",fSize=11,format="%d"
		SetVariable BCdensityCalibMat,limits={0,inf,1},value=CalibMatBCdensity
	//trace analysis tab
		TabControl SP2panelSubTabTA,pos={39,390},size={483,274},proc=SP2panelPSISubTabTAProc,font="Arial",fSize=11
		TabControl SP2panelSubTabTA,tabLabel(0)="scattering"
		TabControl SP2panelSubTabTA,tabLabel(1)="incandescence"
		TabControl SP2panelSubTabTA,tabLabel(2)="split detector"
		TabControl SP2panelSubTabTA,tabLabel(3)="scattering at incandescence (SAI)"
		PopupMenu CalibFldrAnalyseTab,pos={35,177},size={306,22},bodyWidth=220,title="select calibration",proc=SP2_SelectCalibFldrPMproc,fSize=11,font="Arial"
		PopupMenu CalibFldrAnalyseTab,value=SP2_CalibListUpdate()
		PopupMenu scattfittype,pos={47,420},size={338,22},proc=SP2panelscattfittypeProc,title="fit type for scatt. data"
		PopupMenu scattfittype,mode=kSP2scattfittypedefault,value=ksSP2scattfittypelist,fSize=11,font="Arial"
		PopupMenu incfittype,pos={47,420},size={343,22},proc=SP2panelincfittypeProc,title="fit type for incand. data"
		PopupMenu incfittype,mode=kSP2incfittypedefault,value=ksSP2incfittypelist,fSize=11,font="Arial"
		PopupMenu splitsearchmodeMenu,pos={44,417},size={406,24},proc=SP2panel_splitSearchModeProc,title="split search mode",font="Arial",fSize=11
		PopupMenu splitsearchmodeMenu,mode=2,popvalue="search global min, then local max behind the min",value= ksSP2splitFitTypeList
		PopupMenu splitposmodeMenu,pos={44,450},size={425,24},proc=SP2panel_splitPosModeProc,title="split position mode",font="Arial",fSize=11
		PopupMenu splitposmodeMenu,mode=2,popvalue="search for global min, then backwards for local max",value=ksSP2splitPosTypeList
		PopupMenu SAIincandPrefixPM,pos={72,507},size={315,21},bodyWidth=110,proc=SP2_SAIselectIncPrefixPMproc,title="Channel for incandescence peak position:",font="Arial",fSize=11
		PopupMenu SAIincandPrefixPM,value=SP2_ChanListIncandOnly()
		Button AnalyseTracesButt,pos={34,264},size={200,20},proc=SP2_AnalyseRawTracesBtt,title="analyse traces",font="Arial",fSize=11
		GroupBox CalibConstAndBCpropTAtabGB,pos={24,155},size={350,80},title="calibration constants and BC properties",font="Arial",fSize=11
		GroupBox TraceAnalysisGB,pos={24,243},size={505,430},title="trace analysis",font="Arial",fSize=11
		GroupBox ScattAtIncGB,pos={54,453},size={382,85},title="averaging window around incand. peak pos: \"<0 = before\"; \">0 = after\"",font="Arial",fSize=11
		GroupBox PretriggerGB,pos={48,584},size={375,70},title="# of pretrigger points for baseline (all channels if applicable)",font="Arial",fSize=11
		CheckBox rawdatadelCBTAtab,pos={43,293},size={169,14},title="delete raw data after analysing",fSize=11,font="Arial"
		CheckBox rawdatadelCBTAtab,variable=rawdatadelmode
		CheckBox PostProcessingModeTAtab,pos={43,312},size={180,14},title="post processing of trace analysis",font="Arial",fSize=11
		CheckBox PostProcessingModeTAtab,variable=postprocessing
		CheckBox LogNormFitModeTAtab,pos={44,331},size={160,14},title="fit lognormal size distributions",font="Arial",fSize=11
		CheckBox LogNormFitModeTAtab,variable=lognormfit
		CheckBox ExtractConcModeTAtab,pos={44,350},size={176,14},title="extract concentration time series",font="Arial",fSize=11
		CheckBox ExtractConcModeTAtab,variable=ExtractConcTimeSer
		CheckBox ExtractSDModeTAtab,pos={44,369},size={185,14},title="extract size distribution time series",font="Arial",fSize=11
		CheckBox ExtractSDModeTAtab,variable=ExtractSizeDistTimeSer
		CheckBox fitscattCB,pos={377,286},size={102,14},title=" ",fSize=11,font="Arial"
		CheckBox fitscattCB,variable=fitscatt
		CheckBox fitbroadCB,pos={377,306},size={106,14},title=" ",fSize=11,font="Arial"
		CheckBox fitbroadCB,variable=fitbroad
		CheckBox fitnarrCB,pos={377,326},size={114,14},title=" ",fSize=11,font="Arial"
		CheckBox fitnarrCB,variable=fitnarr
		CheckBox fitsplitCB,pos={377,346},size={116,14},title=" ",fSize=11,font="Arial"
		CheckBox fitsplitCB,variable=fitsplit
		CheckBox fitSCLGCB,pos={423,286},size={116,14},title=" ",fSize=11,font="Arial"
		CheckBox fitSCLGCB,variable=fitscattLG
		CheckBox fitBBLGCB,pos={423,306},size={116,14},title=" ",fSize=11,font="Arial"
		CheckBox fitBBLGCB,variable=fitbroadLG
		CheckBox fitNBLGCB,pos={423,326},size={116,14},title=" ",fSize=11,font="Arial"
		CheckBox fitNBLGCB,variable=fitnarrLG
		CheckBox fitSPLGCB,pos={423,346},size={116,14},title=" ",fSize=11,font="Arial"
		CheckBox fitSPLGCB,variable=fitsplitLG
		CheckBox LEOfitModeTAtab,pos={262,366},size={51,14},title="LEO-fit",font="Arial",fSize=11
		CheckBox LEOfitModeTAtab,variable=performLEOfit
		CheckBox LEOrunPostProcTAtab,pos={330,366},size={144,14},title="post processing of LEO fit",font="Arial",fSize=11
		CheckBox LEOrunPostProcTAtab,variable=LEOfitPostProcModeCB
		CheckBox MatchNarrToBroad,pos={45,451},size={113,14},title="match narr to broad",fSize=11,font="Arial"
		CheckBox MatchNarrToBroad,variable=incFitMatchNarr2Broad
		CheckBox BaselineFilterSCHGCB,pos={165,479},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterSCHGCB,variable=BaselineFilterModeSCHG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterSCLGCB,pos={165,500},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterSCLGCB,variable=BaselineFilterModeSCLG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterBBHGCB,pos={165,495},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterBBHGCB,variable=BaselineFilterModeBBHG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterNBHGCB,pos={165,516},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterNBHGCB,variable=BaselineFilterModeNBHG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterBBLGCB,pos={165,537},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterBBLGCB,variable=BaselineFilterModeBBLG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterNBLGCB,pos={165,558},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterNBLGCB,variable=BaselineFilterModeNBLG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterSPHGCB,pos={165,495},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterSPHGCB,variable=BaselineFilterModeSPHG,proc=SP2_BaselineFilterCBproc
		CheckBox BaselineFilterSPLGCB,pos={165,516},size={116,14},title="filter baseline",fSize=11,font="Arial"
		CheckBox BaselineFilterSPLGCB,variable=BaselineFilterModeSPLG,proc=SP2_BaselineFilterCBproc
		CheckBox ScattAtIndGetItCB,pos={56,423},size={41,14},proc=SP2_CheckboxEnabDisabControls,title="get it",font="Arial",fSize=11
		CheckBox ScattAtIndGetItCB,variable=SAIgetIt
		CheckBox PretriggerMode,pos={57,609},size={218,14},proc=SP2_PretriggerAvgCBproc,title="get # pretrigger pts from configuration file",fSize=11,font="Arial"
		CheckBox PretriggerMode,variable=PretriggerAvgMode
		CheckBox PretriggerModeInv,pos={57,629},size={132,14},proc=SP2_PretriggerAvgCBproc,title="fixed # of pretrigger pts",fSize=11,font="Arial"
		CheckBox PretriggerModeInv,variable=PretriggerAvgModeInv
		SetVariable BCdensityAnalysisTab,pos={35,209},size={270,18},title="density of BC particles for diam. calc. [kg m\S-3\M]",format="%d",font="Arial",fSize=11
		SetVariable BCdensityAnalysisTab,limits={0,inf,1},value=BCdensity
		SetVariable Npts4scattPeak,pos={180,448},size={235,18},title="# points to be averaged for peak height:",format="%d",font="Arial",fSize=11
		SetVariable Npts4scattPeak,limits={1,inf,2},value=scattFitnPts4Peak
		SetVariable Npts4incPeak,pos={180,448},size={235,18},title="# points to be averaged for peak height:",format="%d",font="Arial",fSize=11
		SetVariable Npts4incPeak,limits={1,inf,2},value=incFitnPts4Peak
		SetVariable NoiseAmpSCHG,pos={265,477},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpSCHG,limits={0,inf,1},value=BaselineNoiseAmpSCHG
		SetVariable NoiseAmpSCLG,pos={265,498},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpSCLG,limits={0,inf,1},value=BaselineNoiseAmpSCLG
		SetVariable NoiseAmpBBHG,pos={265,493},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpBBHG,limits={0,inf,1},value=BaselineNoiseAmpBBHG
		SetVariable NoiseAmpNBHG,pos={265,514},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpNBHG,limits={0,inf,1},value=BaselineNoiseAmpNBHG
		SetVariable NoiseAmpBBLG,pos={265,535},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpBBLG,limits={0,inf,1},value=BaselineNoiseAmpBBLG
		SetVariable NoiseAmpNBLG,pos={265,556},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpNBLG,limits={0,inf,1},value=BaselineNoiseAmpNBLG
		SetVariable NoiseAmpSPHG,pos={265,493},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpSPHG,limits={0,inf,1},value=BaselineNoiseAmpSPHG
		SetVariable NoiseAmpSPLG,pos={265,514},size={205,18},title="full amplitude of baseline noise:",format="%d",font="Arial",fSize=11
		SetVariable NoiseAmpSPLG,limits={0,inf,1},value=BaselineNoiseAmpSPLG
		SetVariable ScattAtIncStartSV,pos={70,479},size={120,18},title="delta start [s]:",font="Arial",fSize=11,format="%.1f"
		SetVariable ScattAtIncStartSV,limits={-inf,inf,1/SamplingRateRawDataMHz},value=SAItimeLagStart
		SetVariable ScattAtIncEndSV,pos={206,479},size={115,18},title="delta end [s]:",font="Arial",fSize=11,format="%.1f"
		SetVariable ScattAtIncEndSV,limits={-inf,inf,1/SamplingRateRawDataMHz},value=SAItimeLagEnd
		SetVariable numbofpretrigger,pos={222,626},size={190,18},title="# pretrigger pts for baseline: ",format="%d",fSize=11,font="Arial"
		SetVariable numbofpretrigger,limits={0,inf,1},value=PretriggerNumb
		TitleBox FitScattTB,pos={262,286},size={45,13},title="fit scattering:",frame=0,font="Arial",fSize=11
		TitleBox FitBroadTB,pos={262,306},size={45,13},title="fit broadband:",frame=0,font="Arial",fSize=11
		TitleBox FitNarrTB,pos={262,326},size={45,13},title="fit narrowband:",frame=0,font="Arial",fSize=11
		TitleBox FitSplitTB,pos={262,346},size={45,13},title="fit split detector:",frame=0,font="Arial",fSize=11
		TitleBox HighGainTB,pos={358,266},size={45,13},title="high gain",frame=0,font="Arial",fSize=11
		TitleBox LowGainTB,pos={412,266},size={45,13},title="low gain",frame=0,font="Arial",fSize=11
		TitleBox SCHGbaselineFilterTB,pos={47,479},size={45,13},title="scattering high gain:",frame=0,font="Arial",fSize=11
		TitleBox SCLGbaselineFilterTB,pos={47,500},size={45,13},title="scattering low gain:",frame=0,font="Arial",fSize=11
		TitleBox BBHGbaselineFilterTB,pos={47,495},size={45,13},title="broadband high gain:",frame=0,font="Arial",fSize=11
		TitleBox NBHGbaselineFilterTB,pos={47,516},size={45,13},title="narrowband high gain:",frame=0,font="Arial",fSize=11
		TitleBox BBLGbaselineFilterTB,pos={47,537},size={45,13},title="broadband low gain:",frame=0,font="Arial",fSize=11
		TitleBox NBLGbaselineFilterTB,pos={47,558},size={45,13},title="narrowband low gain:",frame=0,font="Arial",fSize=11
		TitleBox SPHGbaselineFilterTB,pos={47,495},size={45,13},title="split detector high gain:",frame=0,font="Arial",fSize=11
		TitleBox SPLGbaselineFilterTB,pos={47,516},size={45,13},title="split detector low gain:",frame=0,font="Arial",fSize=11
				//TitleBox ScattAtIncExplainTB,pos={57,548},size={207,13},title="averaging window before incand. peak [us]:",frame=0,font="Arial",fSize=11
	//post processing tab
		PopupMenu CalibFldrPostProcTab,pos={46,195},size={275,21},bodyWidth=215,proc=SP2_SelectCalibFldrPMproc,title="select calib."
		PopupMenu CalibFldrPostProcTab,font="Arial",fSize=11
		PopupMenu CalibFldrPostProcTab,value=SP2_CalibListUpdate()
		PopupMenu ScattSizingRefractIndex,pos={279,222},size={227,28},bodyWidth=140,proc=SP2_SelectScattRefractPMproc,title="optical sizing of\rpurely scattering:"
		PopupMenu ScattSizingRefractIndex,font="Arial",fSize=11
		PopupMenu ScattSizingRefractIndex,value=SP2_MiePureScattDataFldrList()
		Button PostProcessingButt,pos={34,264},size={200,20},proc=SP2_PBPpostprocBtt,title="post processing"
		Button PostProcessingButt,font="Arial",fSize=11
		Button LogNormFitButt,pos={541,174},size={196,20},proc=SP2_LogNormFitButt,title="fit lognormal size distribution",font="Arial",fSize=11
		Button ExtractConcTserBtt,pos={540,456},size={215,20},proc=SP2_ConcTimeSeriesExtractor,title="extract concentration time series",font="Arial",fSize=11
		Button ExtractSizeDistrTserBtt,pos={540,558},size={215,20},proc=SP2_SizeDistTimeSeriesExtractor,title="extract size distribution time series",font="Arial",fSize=11
		Button FitLogNorm2SDtimeSerBtt,pos={540,584},size={215,20},proc=SP2_LogNormFitSDtimeSeries,title="fit lognormal to size distributions",font="Arial",fSize=11
		Button AddBandRatioStats,pos={25,650},size={190,20},proc=SP2_PBPbandratioStats,title="add bandratio statistics",font="Arial",fSize=11
		Button AddDelayTimeStats,pos={280,625},size={190,20},proc=SP2_PBPscatt2broadDelayNumbFr,title="add delay time number fractions",font="Arial",fSize=11
		Button AddDelayTimeHisto,pos={280,650},size={190,20},proc=SP2_PBPscatt2broadDelayHisto,title="add delay time histogram",font="Arial",fSize=11
		GroupBox PostProcessingGB,pos={25,152},size={500,465},title="post processing of trace analysis"
		GroupBox PostProcessingGB,font="Arial",fSize=11
		GroupBox CalibConstAndBCpropPostProcGB,pos={32,173},size={485,84},title="calibration constants and material properties"
		GroupBox CalibConstAndBCpropPostProcGB,font="Arial",fSize=11
		GroupBox ThresholdsGB,pos={40,291},size={430,165},title="peak height thresholds for data analysis and particle type classification",font="Arial",fSize=11
		GroupBox IncludeInResultsGB,pos={141,311},size={174,135},title="include in results (peak LOQs)",font="Arial",fSize=11
		GroupBox TrueSignalsGB,pos={318,311},size={145,135},title="true signals (peak LODs)",font="Arial",fSize=11
		GroupBox CombineChannelsGB,pos={41,461},size={132,143},title="combining channels",font="Arial",fSize=11
		GroupBox LogNormFitGB,pos={534,152},size={212,253},title="lognormal fit",font="Arial",fSize=11
		GroupBox LogNormFitRangeGB,pos={540,203},size={200,80},title="D-range of measurement to be fitted",font="Arial",fSize=11
		GroupBox LogNormIntRangeGB,pos={540,290},size={200,105},title="D-range of fitted lognormal",font="Arial",fSize=11
		GroupBox ExtractConcTimeSeriesGB,pos={533,411},size={271,73},title="extract concentration time series",font="Arial",fSize=11
		GroupBox ExtractSDTimeSeriesGB,pos={533,491},size={267,120},title="extract size distribution time series",font="Arial",fSize=11
		CheckBox AutoGraphCBPPtab,pos={541,635},size={52,14},title="graphs",font="Arial",fSize=11,variable=AutoGraphCB
		CheckBox AutoGraphCB,pos={17,108},size={61,14},title="Graphs ",font="Arial",fSize=11,fStyle=1,fColor=(0,26112,39168), variable= AutoGraphCB // always-on
		CheckBox CalcBHNH_CB,pos={49,483},size={116,14},title="BHNH=BBHG+NBHG",font="Arial",fSize=11
		CheckBox CalcBHNH_CB,variable=calcBHNH
		CheckBox CalcBHNL_CB,pos={49,503},size={114,14},title="BHNL=BBHG+NBLG",font="Arial",fSize=11
		CheckBox CalcBHNL_CB,variable=calcBHNL
		CheckBox CalcBHBL_CB,pos={49,523},size={114,14},title="BHBL=BBHG+BBLG",font="Arial",fSize=11
		CheckBox CalcBHBL_CB,variable=calcBHBL
		CheckBox CalcBLNL_CB,pos={49,543},size={112,14},title="BLNL=BBLG+NBLG",font="Arial",fSize=11
		CheckBox CalcBLNL_CB,variable=calcBLNL
		CheckBox CalcSHSL_CB,pos={49,563},size={112,14},title="SHSL=SCHG+SCLG",font="Arial",fSize=11
		CheckBox CalcSHSL_CB,variable=calcSHSL
		CheckBox CalcPHPL_CB,pos={49,583},size={112,14},title="PHPL=SPHG+SPLG",font="Arial",fSize=11
		CheckBox CalcPHPL_CB,variable=calcPHPL
		CheckBox LogNormFitModePPtab,pos={184,474},size={160,14},title="fit lognormal size distributions",font="Arial",fSize=11
		CheckBox LogNormFitModePPtab,variable=lognormfit
		CheckBox ExtractConcModePPtab,pos={185,493},size={176,14},title="extract concentration time series",font="Arial",fSize=11
		CheckBox ExtractConcModePPtab,variable=ExtractConcTimeSer
		CheckBox ExtractSDModePPtab,pos={185,513},size={185,14},title="extract size distribution time series",font="Arial",fSize=11
		CheckBox ExtractSDModePPtab,variable=ExtractSizeDistTimeSer
		CheckBox LEOrunPostProcPPtab,pos={185,534},size={138,14},title="run LEO post processing",font="Arial",fSize=11
		CheckBox LEOrunPostProcPPtab,variable=LEOfitPostProcModeCB
		SetVariable BCdensityPostProcTab,pos={44,227},size={220,18},bodyWidth=45,title="density of BC for diam. calc. [kg m\S-3\M]"
		SetVariable BCdensityPostProcTab,font="Arial",fSize=11,format="%d"
		SetVariable BCdensityPostProcTab,limits={0,inf,1},value=BCdensity
		SetVariable MinPeakHtSCHG,pos={159,348},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtSCHG,fSize=11,format="%d"
		SetVariable MinPeakHtSCHG,limits={0,inf,1},value=MinCutSCHG
		SetVariable MinPeakHtSCHG valueColor=(0,15872,65280) // jcc
		SetVariable MinPeakHtBBHG,pos={159,372},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtBBHG,fSize=11,format="%d"
		SetVariable MinPeakHtBBHG,limits={0,inf,1},value=MinCutBBHG
		SetVariable MinPeakHtNBHG,pos={159,396},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtNBHG,fSize=11,format="%d"
		SetVariable MinPeakHtNBHG,limits={0,inf,1},value=MinCutNBHG
		SetVariable MinPeakHtSPHG,pos={159,420},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtSPHG,fSize=11,format="%d"
		SetVariable MinPeakHtSPHG,limits={0,inf,1},value=MinCutSPHG
		SetVariable MinPeakHtSCLG,pos={219,348},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtSCLG,fSize=11,format="%d"
		SetVariable MinPeakHtSCLG,limits={0,inf,1},value=MinCutSCLG
		SetVariable MinPeakHtBBLG,pos={219,372},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtBBLG,fSize=11,format="%d"
		SetVariable MinPeakHtBBLG,limits={0,inf,1},value=MinCutBBLG
		SetVariable MinPeakHtNBLG,pos={219,396},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtNBLG,fSize=11,format="%d"
		SetVariable MinPeakHtNBLG,limits={0,inf,1},value=MinCutNBLG
		SetVariable MinPeakHtSPLG,pos={219,420},size={45,18},title=" ",font="Arial"
		SetVariable MinPeakHtSPLG,fSize=11,format="%d"
		SetVariable MinPeakHtSPLG,limits={0,inf,1},value=MinCutSPLG
		SetVariable DetectCutSCHG_SV,pos={334,348},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutSCHG_SV,fSize=11,format="%d"
		SetVariable DetectCutSCHG_SV,limits={0,inf,1},value=DetectCutSCHG
		SetVariable DetectCutBBHG_SV,pos={334,372},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutBBHG_SV,fSize=11,format="%d"
		SetVariable DetectCutBBHG_SV valueColor=(52224,0,0) // jcc
		SetVariable DetectCutBBHG_SV,limits={0,inf,1},value=DetectCutBBHG
		SetVariable DetectCutNBHG_SV,pos={334,396},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutNBHG_SV,fSize=11,format="%d"
		SetVariable DetectCutNBHG_SV,limits={0,inf,1},value=DetectCutNBHG
		SetVariable DetectCutSPHG_SV,pos={334,420},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutSPHG_SV,fSize=11,format="%d"
		SetVariable DetectCutSPHG_SV,limits={0,inf,1},value=DetectCutSPHG
		SetVariable DetectCutSCLG_SV,pos={392,348},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutSCLG_SV,fSize=11,format="%d"
		SetVariable DetectCutSCLG_SV,limits={0,inf,1},value=DetectCutSCLG
		SetVariable DetectCutBBLG_SV,pos={392,372},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutBBLG_SV,fSize=11,format="%d"
		SetVariable DetectCutBBLG_SV,limits={0,inf,1},value=DetectCutBBLG
		SetVariable DetectCutNBLG_SV,pos={392,396},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutNBLG_SV,fSize=11,format="%d"
		SetVariable DetectCutNBLG_SV,limits={0,inf,1},value=DetectCutNBLG
		SetVariable DetectCutSPLG_SV,pos={392,420},size={45,18},title=" ",font="Arial"
		SetVariable DetectCutSPLG_SV,fSize=11,format="%d"
		SetVariable DetectCutSPLG_SV,limits={0,inf,1},value=DetectCutSPLG
		SetVariable NumbOfHistoBins,pos={267,266},size={96,18},bodyWidth=40,title="# size bins"
		SetVariable NumbOfHistoBins,font="Arial",fSize=11,format="%d"
		SetVariable NumbOfHistoBins,limits={0,inf,1},value=nHistoBins 
		SetVariable LNfitDmeasMin,pos={552,225},size={175,18},title="minimum diameter [nm]"
		SetVariable LNfitDmeasMin,font="Arial",fSize=11,format="%d"
		SetVariable LNfitDmeasMin,limits={0,inf,1},value=LogNormFitDmeasMin
		SetVariable LNfitDmeasMax,pos={552,254},size={175,18},title="maximum diameter [nm]"
		SetVariable LNfitDmeasMax,font="Arial",fSize=11,format="%d"
		SetVariable LNfitDmeasMax,limits={0,inf,1},value=LogNormFitDmeasMax
		SetVariable LNfitDfitMin,pos={553,312},size={175,18},title="minimum diameter [nm]"
		SetVariable LNfitDfitMin,font="Arial",fSize=11,format="%d"
		SetVariable LNfitDfitMin,limits={0,inf,1},value=LogNormFitDfitMin
		SetVariable LNfitDfitMax,pos={553,340},size={175,18},title="maximum diameter [nm]"
		SetVariable LNfitDfitMax,font="Arial",fSize=11,format="%d"
		SetVariable LNfitDfitMax,limits={0,inf,1},value=LogNormFitDfitMax
		SetVariable LNfitNpts,pos={553,366},size={175,18},title="number of points"
		SetVariable LNfitNpts,font="Arial",fSize=11,format="%d"
		SetVariable LNfitNpts,limits={0,inf,1},value=LogNormFitnPts
		SetVariable ConcIntervalSV,pos={543,432},size={250,18},title="interval of time series [s]  (0=all data)"
		SetVariable ConcIntervalSV,font="Arial",fSize=11,format="%d"
		SetVariable ConcIntervalSV,limits={0,inf,1},value=ConcInterval
		SetVariable SDIntervalSV,pos={543,509},size={240,18},title="interval of SD time series [s] (0=all data)"
		SetVariable SDIntervalSV,font="Arial",fSize=11,format="%d"
		SetVariable SDIntervalSV,limits={0,inf,1},value=SDinterval
		SetVariable SDNumbOftimeSeriesSizeBins,pos={543,534},size={180,18},title="# bins for size distribution"
		SetVariable SDNumbOftimeSeriesSizeBins,font="Arial",fSize=11,format="%d"
		SetVariable SDNumbOftimeSeriesSizeBins,limits={0,inf,1},value=SDnbins
		TitleBox PPtab_scatt_TB,pos={61,351},size={76,14},title="scattering (SC):",font="Arial",fSize=11,frame=0
		TitleBox PPtab_broad_TB,pos={58,376},size={80,14},title="broadband (BB):",font="Arial",fSize=11,frame=0
		TitleBox PPtab_narr_TB,pos={49,399},size={88,14},title="narrowband (NB):",font="Arial",fSize=11,frame=0
		TitleBox PPtab_split_TB,pos={47,419},size={89,14},title="split detector (SP):",font="Arial",fSize=11,frame=0
		TitleBox HighGainPPtabTB,pos={160,329},size={15,14},title="HG",font="Arial",fSize=11,frame=0
		TitleBox LowGainPPtabTB,pos={215,329},size={14,14},title="LG",font="Arial",fSize=11,frame=0
		TitleBox HighGainPPtabTB1,pos={337,330},size={15,14},title="HG",font="Arial",fSize=11,frame=0
		TitleBox LowGainPPtabTB1,pos={395,330},size={14,14},title="LG",font="Arial",fSize=11,frame=0
		
		
	//LEO tab
		CheckBox cb_predefBeamShape,pos={248,208},size={191,14},proc=SP2_CB_defineBeamShape,title="Pre-define a beam shape folder..." // new v4111
		CheckBox cb_predefBeamShape,font="Calibri",fColor=(0,26112,39168),value= 0 // note: this checkbox doesn't use a global variable, see SP2_CB_defineBeamShape()
		Button LEOfitPreparation,pos={38,179},size={190,20},proc=SP2_LEOfitPreparation,title="get beam and PSD properties",font="Arial",fSize=11
		Button LEOtraceAnalysis,pos={38,263},size={190,20},proc=SP2_LEOfitTraceAnalysisButt,title="LEO trace analysis",font="Arial",fSize=11
		Button LEOverificationSizingButt,pos={32,393},size={190,20},proc=SP2_LEOverificationAndSizing,title="verification and optical sizing",font="Arial",fSize=11
		Button LEOperformStatsButt,pos={31,518},size={190,20},proc=SP2_LEOperformanceStats,title="statistics of LEO-fit performance",font="Arial",fSize=11
		Button LEOpostProcButt,pos={32,570},size={190,20},proc=SP2_LEOpostProcButt,title="Re-run LEO post processing",font="Arial",fSize=11
		Button ScattAtIncLEOtabNormalizeButt,pos={603,398},size={190,20},proc=SP2_ScattAtIncNormalize,title="normalize signal amplitude",font="Arial",fSize=11
		Button ScattAtIncLEOtabSizingButt,pos={603,477},size={190,20},proc=SP2_ScattAtIncOptSizing,title="optical sizing of core",font="Arial",fSize=11
		GroupBox LEOfitPrepGB,pos={23,154},size={562,80},title="get laser beam and split detector properties required for LEO fit",font="Arial",fSize=11
		GroupBox LEOtraceAnalysisGB,pos={23,240},size={562,125},title="trace analysis",font="Arial",fSize=11
		GroupBox LEOverificationGF,pos={23,369},size={562,175},title="verification and optical sizing",font="Arial",fSize=11
		GroupBox LEOpostProcGB,pos={23,547},size={650,125},title="post processing",font="Arial",fSize=11
		GroupBox ScattAtIncLEOtabGB,pos={590,369},size={215,159},title="Optical sizing of BC core (SAI)",font="Arial",fSize=11
		SetVariable LEOfitRangeSV,pos={40,290},size={185,18},title="fit range: % of max amplitude",format="%.2f",font="Arial",fSize=11
		SetVariable LEOfitRangeSV,limits={0,100,0.1},value=LEOfitRange
		SetVariable LEOfitMinNumPntsSV,pos={40,315},size={185,18},title="min. number of points for fit",font="Arial",fSize=11,format="%d"
		SetVariable LEOfitMinNumPntsSV,limits={0,100,1},value=LEOfitMinNumPnts		
		SetVariable LEOfitFastNumPtsSV,pos={243,314},size={125,18},title="# points for fast fit",font="Arial",fSize=11,format="%d"
		SetVariable LEOfitFastNumPtsSV,limits={1,99,1},value=LEOfitFastNumPts
		SetVariable LEOminPkHtSCHG_SV,pos={489,624},size={85,18},title="SCHG:",font="Arial",fSize=11,format="%d"
		SetVariable LEOminPkHtSCHG_SV,limits={0,inf,1},variable=SCHG_MinPeakHtSV
		SetVariable LEOminPkHtSCLG_SV,pos={582,624},size={85,18},title="SCLG:",font="Arial",fSize=11,format="%d"
		SetVariable LEOminPkHtSCLG_SV,limits={0,inf,1},variable=SCLG_MinPeakHtSV
		SetVariable LEOminPkHtSPHG_SV,pos={490,645},size={85,18},title="SPHG:",font="Arial",fSize=11,format="%d"
		SetVariable LEOminPkHtSPHG_SV,limits={0,inf,1},variable=SPHG_MinPeakHtSV
		SetVariable LEOminPkHtSPLG_SV,pos={582,645},size={85,18},title="SPLG:",font="Arial",fSize=11,format="%d"
		SetVariable LEOminPkHtSPLG_SV,limits={0,inf,1},variable=SPLG_MinPeakHtSV
		SetVariable LEOdiamMinSV,pos={414,573},size={150,18},title="min. diameter [nm]",font="Arial",fSize=11,format="%.0f"
		SetVariable LEOdiamMinSV,limits={0,10000,1},variable=LEOdiamRangeMinSV
		SetVariable LEOdiamMaxSV,pos={414,598},size={150,18},title="max. diameter [nm]",font="Arial",fSize=11,format="%.0f"
		SetVariable LEOdiamMaxSV,limits={0,10000,1},variable=LEOdiamRangeMaxSV
		SetVariable LEOnumbOfSizeBins,pos={36,605},size={150,18},title="# bins size distribution",font="Arial",fSize=11,format="%d"
		SetVariable LEOnumbOfSizeBins,limits={0,inf,1},variable=LEOnumbSizeBinsSV
		SetVariable LEOnumbOfVolFractHistBins,pos={219,623},size={150,18},title="# bins vol. fract. hist.",font="Arial",fSize=11,format="%d"
		SetVariable LEOnumbOfVolFractHistBins,limits={0,inf,1},variable=LEOnBinsBCvolFracHistSV
		SetVariable LEOnumbOfCoatThicknHistBins,pos={209,648},size={160,18},title="# bins coat. thickn. hist.",font="Arial",fSize=11,format="%d"
		SetVariable LEOnumbOfCoatThicknHistBins,limits={0,inf,1},variable=LEOnBinsCoatThicknHistSV
		SetVariable LEOnumbOfDelayHistBins,pos={36,633},size={150,18},title="# bins delay histogram",font="Arial",fSize=11,format="%d"
		SetVariable LEOnumbOfDelayHistBins,limits={0,inf,1},variable=LEOnBinsDelayHistSV
//		CheckBox AutoGraphCBLEOtab,pos={612,169},size={52,14},title="graphs",font="Arial",fSize=11
//		CheckBox AutoGraphCBLEOtab,variable=AutoGraphCB
		CheckBox LEOfitSkipGaussCB,pos={248,182},size={144,14},title="get Gaussian parameters",font="Arial",fSize=11
		CheckBox LEOfitSkipGaussCB,variable=LEOfitSkipGaussCB
		CheckBox LEOfitSkipBeamShapeCB,pos={422,182},size={99,14},title="get beam shape",font="Arial",fSize=11
		CheckBox LEOfitSkipBeamShapeCB,variable=LEOfitSkipBeamShapeCB
		CheckBox LEOfitFastFitCB,pos={240,293},size={93,14},title="use fast LEO fit",font="Arial",fSize=11
		CheckBox LEOfitFastFitCB,variable=LEOfitFastFit, proc=SP2_LEOfitFastFitCBproc
		CheckBox LEOfitSCHGdataCB,pos={392,259},size={92,14},title="fit SCHG data",font="Arial",fSize=11
		CheckBox LEOfitSCHGdataCB,variable=LEOfitSCHGcb
		CheckBox LEOfitSCLGdataCB,pos={492,259},size={92,14},title="fit SCLG data",font="Arial",fSize=11
		CheckBox LEOfitSCLGdataCB,variable=LEOfitSCLGcb
		CheckBox LEOfitSPHGdataCB,pos={392,281},size={91,14},title="fit SPHG data",font="Arial",fSize=11
		CheckBox LEOfitSPHGdataCB,variable=LEOfitSPHGcb
		CheckBox LEOfitSPLGdataCB,pos={492,281},size={91,14},title="fit SPLG data",font="Arial",fSize=11
		CheckBox LEOfitSPLGdataCB,variable=LEOfitSPLGcb
		CheckBox rawdatadelCBLEOtab,pos={392,300},size={169,14},title="delete raw data after analysing",font="Arial",fSize=11
		CheckBox rawdatadelCBLEOtab,variable=rawdatadelmode
		CheckBox LEOrunPostProcCB,pos={392,318},size={138,14},title="run LEO post processing",font="Arial",fSize=11
		CheckBox LEOrunPostProcCB,variable=LEOfitPostProcModeCB
		CheckBox LEOnegCoatingTreatmentCB,pos={418,522},size={143,14},title="Treat coatings<0 as noise",font="Arial",fSize=11
		CheckBox LEOnegCoatingTreatmentCB,variable= LEOnegCoatingAsNoise
		CheckBox LEOfitSlopeResetSCHGCB,pos={392,392},size={47,14},title="SCHG",font="Arial",fSize=11
		CheckBox LEOfitSlopeResetSCHGCB,variable=LEOfitSlopeResetSCHGCB
		CheckBox LEOfitSlopeResetSCLGCB,pos={451,392},size={46,14},title="SCLG",font="Arial",fSize=11
		CheckBox LEOfitSlopeResetSCLGCB,variable=LEOfitSlopeResetSCLGCB
		CheckBox LEOfitCalFactResetSPHGCB,pos={392,414},size={46,14},title="SPHG",font="Arial",fSize=11
		CheckBox LEOfitCalFactResetSPHGCB,variable=LEOfitCalFactResetSPHGCB
		CheckBox LEOfitCalFactResetSPLGCB,pos={451,414},size={45,14},title="SPLG",font="Arial",fSize=11
		CheckBox LEOfitCalFactResetSPLGCB,variable=LEOfitCalFactResetSPLGCB
		CheckBox LEOfitVerificationStatsRun,pos={237,522},size={80,14},title="run statistics",font="Arial",fSize=11
		CheckBox LEOfitVerificationStatsRun,variable=LEOfitStatsRunCB
		CheckBox LEOfitVerificationStatsMedian,pos={334,522},size={75,14},title="median only",font="Arial",fSize=11
		CheckBox LEOfitVerificationStatsMedian,variable=LEOfitStatsMedianCB
		CheckBox LEOlimitBCcoreDiamCB,pos={270,575},size={121,14},title="limit BC core diameter",font="Arial",fSize=11
		CheckBox LEOlimitBCcoreDiamCB, variable=LEOlimitBCdiamCB, proc=SP2_LEOdiamLimitModeCBproc
		CheckBox LEOlimitOptDiamCB,pos={270,600},size={113,14},title="limit optical diameter",font="Arial",fSize=11
		CheckBox LEOlimitOptDiamCB, variable=LEOlimitOptdiamCB, proc=SP2_LEOdiamLimitModeCBproc
		PopupMenu LEOsplitPosChanPrefixPM,pos={39,337},size={226,21},bodyWidth=80,proc=SP2_SelectLEOsplitPosPrefixPM,title="PSD channel for split position:",font="Arial",fSize=11
		PopupMenu LEOsplitPosChanPrefixPM,value=SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()
		PopupMenu LEOscattPrefixForSPHGcalibPM,pos={298,437},size={131,21},bodyWidth=80,proc=SP2_PanelLEOcalibRefScattChanPM,title="for SPHG:",font="Arial",fSize=11
		PopupMenu LEOscattPrefixForSPHGcalibPM,value=SP2_ChanListScattOnly()
		PopupMenu LEOscattPrefixForSPLGcalibPM,pos={441,437},size={131,21},bodyWidth=80,proc=SP2_PanelLEOcalibRefScattChanPM,title="for SPLG:",font="Arial",fSize=11
		PopupMenu LEOscattPrefixForSPLGcalibPM,value=SP2_ChanListScattOnly()
		PopupMenu LEOincandPrefixPM,pos={31,465},size={432,21},bodyWidth=250,proc=SP2_SelectLEOincandPrefixPMproc,title="Incandescence channel for BC core:",font="Arial",fSize=11
		PopupMenu LEOincandPrefixPM,value=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
		PopupMenu LEOsizingRefractIndexPair,pos={95,492},size={368,21},bodyWidth=250,proc=SP2_SelectLEORefractpairPMproc,title="Mie data for coated BC:",font="Arial",fSize=11
		PopupMenu LEOsizingRefractIndexPair,value=SP2_MieCoatedBCdataFldrList()
		PopupMenu SAIchanPrefixPSDpm,pos={605,427},size={154,21},bodyWidth=80,proc=SP2_SAIselectPSDchanPrefixPM,title="split pos. from:",font="Arial",fSize=11
		PopupMenu SAIchanPrefixPSDpm,value=SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()
		TitleBox ResetSlopeFactTB,pos={262,392},size={120,14},title="reset slope fudge factor:",font="Arial",fSize=11,frame=0
		TitleBox ResetPSDcalFactTB,pos={246,413},size={135,14},title="reset PSD calibration factor:",font="Arial",fSize=11,frame=0,font="Arial",fSize=11
		Button editCalFacts,pos={272,411},size={112,18},proc=SP2_btn_PSDcalFact,title="PSD calibration factor:",font="Arial",fSize=11,fColor=(63744,63744,63744)

		TitleBox SelectPSDcalibRefChanTB,pos={33,440},size={252,14},title="Scattering channel to be used for calibration of PSDs:",font="Arial",fSize=11,frame=0
		TitleBox MinPeakHeightScattTB,pos={401,626},size={80,14},title="min. peak height:",font="Arial",fSize=11,frame=0
		TitleBox MinPeakHeightSplitTB,pos={401,647},size={80,14},title="min. peak height:",font="Arial",fSize=11,frame=0
	//graph tab
		PopupMenu graphtypePMraw,pos={200,174},size={363,23},title="raw data graphs:"
		PopupMenu graphtypePMraw, mode=kSP2rawgraphtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistrawdata(),fSize=11,font="Arial"
		PopupMenu graphtypePMcalib,pos={200,204},size={363,23},title="calibration data graphs:"
		PopupMenu graphtypePMcalib, mode=kSP2calibgraphtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistcalibdata(),fSize=11,font="Arial"
		PopupMenu graphtypePManalysed,pos={200,234},size={363,23},title="analysed data graphs:"
		PopupMenu graphtypePManalysed, mode=kSP2analysedgraphtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistanalyseddata(),fSize=11,font="Arial"
		PopupMenu graphtypePMtser,pos={200,264},size={363,23},title="time series graphs:"
		PopupMenu graphtypePMtser, mode=kSP2tsergraphtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistTserData(),fSize=11,font="Arial"
		PopupMenu graphtypePMleo,pos={200,294},size={363,23},title="LEO-fit graphs:"
		PopupMenu graphtypePMleo, mode=kSP2leographtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistLEOdata(),fSize=11,font="Arial"
		PopupMenu graphtypePMsai,pos={200,324},size={363,23},title="SAI graphs:"
		PopupMenu graphtypePMsai, mode=kSP2saiGraphTypeDefault,bodyWidth=250,value=SP2_graphtypePMlistSAIdata(),fSize=11,font="Arial"
		PopupMenu graphtypePMicecore,pos={200,354},size={363,23},title="ice core data graphs:"
		PopupMenu graphtypePMicecore, mode=kSP2icecoregraphtypeDefault,bodyWidth=250,value=SP2_graphtypePMlistIcecoreData(),fSize=11,font="Arial"
		PopupMenu tabletypePM,pos={260,438},size={272,23},title="table type"
		PopupMenu tabletypePM, mode=kSP2tabletypeDefault,bodyWidth=250,value=SP2_tabletypelistcreator(),fSize=11,font="Arial"
		Button GraphButtraw,pos={30,175},size={150,20},proc=SP2_graphbutt,title="create raw data graph",fSize=11,font="Arial"
		Button GraphButtcalib,pos={30,205},size={150,20},proc=SP2_graphbutt,title="create calibration data graph",fSize=11,font="Arial"
		Button GraphButtanalysed,pos={30,235},size={150,20},proc=SP2_graphbutt,title="create analysed data graph",fSize=11,font="Arial"
		Button GraphButttser,pos={30,265},size={150,20},proc=SP2_graphbutt,title="create time series graph",fSize=11,font="Arial"
		Button GraphButtleo,pos={30,295},size={150,20},proc=SP2_graphbutt,title="create LEO-fit graph",fSize=11,font="Arial"
		Button GraphButtSAI,pos={30,325},size={150,20},proc=SP2_graphbutt,title="create SAI graph",fSize=11,font="Arial"
		Button GraphButticecore,pos={30,355},size={150,20},proc=SP2_graphbutt,title="create ice core data graph",fSize=11,font="Arial"
		Button TableButt,pos={30,439},size={120,20},proc=SP2_tablebutt,title="create table",font="Arial",fSize=11
	//ice core tab
		PopupMenu CalibFldrIceCoreTab,pos={65,305},size={386,22},bodyWidth=300,title="select calibration",proc=SP2_SelectCalibFldrPMproc,fSize=11,font="Arial"
		PopupMenu CalibFldrIceCoreTab,value=SP2_CalibListUpdate()
		Button CETACcalcLiqSampleConc,pos={46,272},proc=SP2_CETAC_calc_LiquidConcBtt,size={180,20},title="calculate liquid sample conc."
		Button BatchLoadPreparation,pos={271,183},proc=SP2batchLoadWavesPrepButt,size={230,20},title="prepare sample info waves",font="Arial",fSize=11
		Button BatchLoadData,pos={271,211},proc=SP2batchLoadBtt,size={230,20},title="load SP2 data and extract results",font="Arial",fSize=11
		Button BatchExtractSummary,pos={271,239},proc=SP2batchLoadExtractSummaryBtt,size={230,20},title="extract results (from previously loaded data)",font="Arial",fSize=11
		GroupBox CETACsettings,pos={34,163},size={210,104},title="CETAC settings",fSize=11,font="Arial"
		GroupBox BatchLoad,pos={258,163},size={272,104},title="batch loading and analysis",font="Arial",fSize=11
		SetVariable CetacSampleFlow,pos={45,185},size={180,18},title="liq. sample flow [ml/min]",font="Arial",fSize=11
		SetVariable CetacSampleFlow,limits={0,inf,0.01},value=CETACsampleflow
		SetVariable CetacDrainFlow,pos={45,209},size={180,18},title="liq. drain flow [ml/min]",font="Arial",fSize=11
		SetVariable CetacDrainFlow,limits={0,inf,0.01},value=CETACdrainflow
		SetVariable CetacPurgeAirFlow,pos={45,232},size={180,18},title="purge air flow [l/min]",font="Arial",fSize=11
		SetVariable CetacPurgeAirFlow,limits={0,inf,0.01},value=CETACpurgeairflow
	//config tab
		PopupMenu ChanConfig_0,pos={40,180},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 0:"
		PopupMenu ChanConfig_0,mode=kSP2chan0configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_1,pos={40,205},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 1:"
		PopupMenu ChanConfig_1,mode=kSP2chan1configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_2,pos={40,230},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 2:"
		PopupMenu ChanConfig_2,mode=kSP2chan2configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_3,pos={40,255},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 3:"
		PopupMenu ChanConfig_3,mode=kSP2chan3configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_4,pos={40,280},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 4:"
		PopupMenu ChanConfig_4,mode=kSP2chan4configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_5,pos={40,305},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 5:"
		PopupMenu ChanConfig_5,mode=kSP2chan5configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_6,pos={40,330},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 6:"
		PopupMenu ChanConfig_6,mode=kSP2chan6configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		PopupMenu ChanConfig_7,pos={40,355},size={275,21},bodyWidth=220,proc=SP2panelPSIChanConfigProc,title="channel 7:"
		PopupMenu ChanConfig_7,mode=kSP2chan7configdefault+1,value=SP2_ChanListToDescrLongList(SP2_ChanListAllEnabledDAQ()),fSize=11,font="Arial"
		GroupBox ChannelHardwareConfig,pos={28,157},size={297,227},title="channel configuration (hardware wiring):"
		GroupBox ChannelLoadConfig,pos={28,395},size={232,188},title="data channels to be loaded:"
		GroupBox DetectorDAQsaturationGB,pos={269,395},size={191,220},title="detector / DAQ-board saturation:"
		CheckBox loadscattCB,pos={39,415},size={102,14},title="scattering high gain",fSize=11,font="Arial"
		CheckBox loadscattCB,variable=loadscatt
		CheckBox loadbroadCB,pos={39,435},size={106,14},title="broadband incandescence high gain",fSize=11,font="Arial"
		CheckBox loadbroadCB,variable=loadbroad
		CheckBox loadnarrCB,pos={39,455},size={114,14},title="narrowband incandescence high gain",fSize=11,font="Arial"
		CheckBox loadnarrCB,variable=loadnarr
		CheckBox loadsplitCB,pos={39,475},size={116,14},title="split detector high gain",fSize=11,font="Arial"
		CheckBox loadsplitCB,variable=loadsplit
		CheckBox loadSCLGCB,pos={39,495},size={102,14},title="scattering low gain",fSize=11,font="Arial"
		CheckBox loadSCLGCB,variable=loadSCLG
		CheckBox loadBBLGCB,pos={39,515},size={102,14},title="broadband incandescence low gain",fSize=11,font="Arial"
		CheckBox loadBBLGCB,variable=loadBBLG
		CheckBox loadNBLGCB,pos={39,535},size={102,14},title="narrowband incandescence low gain",fSize=11,font="Arial"
		CheckBox loadNBLGCB,variable=loadNBLG
		CheckBox loadSPLGCB,pos={39,555},size={102,14},title="split detector low gain",fSize=11,font="Arial"
		CheckBox loadSPLGCB,variable=loadSPLG
		CheckBox invertSPHGCB,pos={190,475},size={30,14},title="invert",fSize=11,font="Arial"
		CheckBox invertSPHGCB,variable=invertSPHG
		CheckBox invertSPLGCB,pos={190,555},size={30,14},title="invert",fSize=11,font="Arial"
		CheckBox invertSPLGCB,variable=invertSPLG
		SetVariable SaturationSCHG,pos={290,415},size={158,18},bodyWidth=60,title="scattering high gain",font="Arial",fSize=11
		SetVariable SaturationSCHG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigSCHG
		SetVariable SaturationBBHG,pos={286,440},size={162,18},bodyWidth=60,title="broadband high gain",font="Arial",fSize=11
		SetVariable SaturationBBHG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigBBHG
		SetVariable SaturationNBHG,pos={278,465},size={170,18},bodyWidth=60,title="narrowband high gain",font="Arial",fSize=11
		SetVariable SaturationNBHG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigNBHG
		SetVariable SaturationSPHG,pos={320,490},size={129,18},bodyWidth=60,title="split high gain",font="Arial",fSize=11
		SetVariable SaturationSPHG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigSPHG
		SetVariable SaturationSCLG,pos={293,515},size={156,18},bodyWidth=60,title="scattering low gain",font="Arial",fSize=11
		SetVariable SaturationSCLG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigSCLG
		SetVariable SaturationBBLG,pos={289,540},size={160,18},bodyWidth=60,title="broadband low gain",font="Arial",fSize=11
		SetVariable SaturationBBLG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigBBLG
		SetVariable SaturationNBLG,pos={282,565},size={168,18},bodyWidth=60,title="narrowband low gain",font="Arial",fSize=11
		SetVariable SaturationNBLG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigNBLG
		SetVariable SaturationSPLG,pos={323,590},size={127,18},bodyWidth=60,title="split low gain",font="Arial",fSize=11
		SetVariable SaturationSPLG,format="%d",limits={kSP2rawSignalMin,kSP2rawSignalMax,1},value=MaxSigSPLG
		GroupBox MiscOptionsGB,pos={508,396},size={232,188},title="misc."
		CheckBox ExcludeSatFromDistCB,pos={519,422},size={208,14},title="Exclude saturated peaks from size dist."
		CheckBox ExcludeSatFromDistCB,font="Arial",fSize=11,variable= treatSaturatedAsNaN
		CheckBox UseErrorBarsCB,pos={519,443},size={128,14},title="Add error bars to plots"
		CheckBox UseErrorBarsCB,font="Arial",fSize=11,variable= plotErrorBars
		CheckBox UseSAIforScattCoeffCB,pos={519,462},size={202,14},title="Use SAI for scatt. calib. [experimental]"
		CheckBox UseSAIforScattCoeffCB,font="Arial",fSize=11, proc=SP2_CB_toggleSAIcalib,variable= useSAIforScattCalib

		
	//set popmenu defaults
	SP2_SelectCalibFldrPMproc("",NaN,stringfromlist(kSP2calibNumDefault,SP2_CalibListUpdate()))	
	SP2panelscattfittypeProc("",kSP2scattfittypedefault,"")
	SP2panelincfittypeProc("",kSP2incfittypedefault,"")
	SP2panel_splitSearchModeProc("",kSP2splitsearchmodedefault,"")
	SP2panel_splitPosModeProc("",kSP2splitposmodedefault,"")
	SP2_SAIselectIncPrefixPMproc("",NaN,stringfromlist(kSP2SAIchanPrefixIncNumDef,SP2_ChanListIncandOnly()))
	SP2_SelectScattRefractPMproc("",NaN,stringfromlist(kSP2MiepureScattNumDefault,SP2_MiePureScattDataFldrList()))
	SP2_SelectLEOsplitPosPrefixPM("",NaN,stringfromlist(kSP2psdPrefixForLEOnumDefault,SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()))
	SP2_PanelLEOcalibRefScattChanPM("LEOscattPrefixForSPHGcalibPM",NaN,stringfromlist(kSP2scattPrefixForSPHGcalNumDef,SP2_ChanListScattOnly()))
	SP2_PanelLEOcalibRefScattChanPM("LEOscattPrefixForSPLGcalibPM",NaN,stringfromlist(kSP2scattPrefixForSPLGcalNumDef,SP2_ChanListScattOnly()))
	SP2_SelectLEOincandPrefixPMproc("",NaN,stringfromlist(kSP2incPrefixForLEOnumDefault,SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()))
	SP2_SelectLEORefractpairPMproc("",NaN,stringfromlist(kSP2MieCoatedBCnumDefault,SP2_MieCoatedBCdataFldrList()))
	SP2_SAIselectPSDchanPrefixPM("",NaN,stringfromlist(kSP2SAIpsdPrefixNumDef,SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()))
	//set cross-linked checkboxes
	SP2_LEOdiamLimitModeCBproc("LEOlimitBCcoreDiamCB",kSP2LEOlimitBCdiamDefault)
	SP2_LEOdiamLimitModeCBproc("LEOlimitOptDiamCB",kSP2LEOlimitOptDiamDefault)
	//set checkboxes without associated variables
	SP2_SampleFlowModeCBproc(ksSP2sampleFlowModeDefault,1)
	//set to first tab
	SP2panelPSIMainTabProc("",0)
	
	
	// ADD_HELP_BUTTONS jcc v4111
	Button SP2helpbtn_panelThresholds,pos={52,310},size={19,20},proc=btnp_SP2help,title="?"
	Button SP2helpbtn_panelThresholds,font="Garamond",fColor=(65534,65534,65534)
	Button SP2helpbtn_panelTA,pos={499,262},size={19,20},proc=btnp_SP2help,title="?"
	Button SP2helpbtn_panelTA,font="Garamond",fColor=(65534,65534,65534)
	Button SP2helpbtn_LEOgen,pos={780,154},size={19,20},proc=btnp_SP2help,title="?"
	Button SP2helpbtn_LEOgen,font="Garamond",fColor=(65534,65534,65534)
	Button SP2helpbtn_SAI,pos={772,368},size={19,20},proc=btnp_SP2help,title="?"
	Button SP2helpbtn_SAI,font="Garamond",fColor=(65534,65534,65534)


	// jcc -- closing the SP2 window can cause user inputs to be lost [v4111]
	SetWindow kwTopWin,hook(killer)=SP2_panel_dontclose


	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2_panel_dontclose(s)
// closing the SP2 window can cause user inputs to be lost.
// this function warns the user, and saves the user inputs in case of close.
// 2016-02-05 joel.c.corbin@gmail.com
	STRUCT WMWinHookStruct &s
	Variable statusCode= 0
	strswitch( s.eventName )
		case "killVote":
			// currently this message sometimes pops up twice because of DoWindow/R/K below
			string msg= "Closing and reopening the panel will reset all variables. "
			msg+= "Really close?\r'No' -> cancel operation [recommended]."
			msg+= "\r'Yes' -> recreation macro will be saved."
			msg+= "\r(Note: this message may appear twice.)"
			DoAlert /T="SP2 toolkit warning" 1, msg
			if (V_flag==2)
				statusCode=2 // prevent panel from being killed.
			else
				execute/P "DoWindow/R/K " + s.winName
				doalert 0, "User inputs to the panel have been saved in the recreation macro in Procedures."
			endif
			break
	endswitch
	
	return statusCode
End
Function /S SP2_graphtypelistcreator()
	//martin.gysel@psi.ch
	//return string: list of graph types
	
	//create graph type list
	string graphtypelist=""
//	graphtypelist+=ksSP2graph0
//	graphtypelist+=ksSP2graph1
//	graphtypelist+=ksSP2graph2
//	graphtypelist+=ksSP2graph3
//	graphtypelist+=ksSP2graph4
//	graphtypelist+=ksSP2graph5
//	graphtypelist+=ksSP2graph6
//	graphtypelist+=ksSP2graph7
//	graphtypelist+=ksSP2graph8
//	graphtypelist+=ksSP2graph9
//	graphtypelist+=ksSP2graph10
//	graphtypelist+=ksSP2graph11
//	graphtypelist+=ksSP2graph12
//	graphtypelist+=ksSP2graph13
//	graphtypelist+=ksSP2graph14
//	graphtypelist+=ksSP2graph15
//	graphtypelist+=ksSP2graph16
//	graphtypelist+=ksSP2graph17
//	graphtypelist+=ksSP2graph18
//	graphtypelist+=ksSP2graph19
//	graphtypelist+=ksSP2graph20
//	graphtypelist+=ksSP2graph21
//	graphtypelist+=ksSP2graph22
//	graphtypelist+=ksSP2graph23
//	graphtypelist+=ksSP2graph24
//	graphtypelist+=ksSP2graph25
//	graphtypelist+=ksSP2graph26
//	graphtypelist+=ksSP2graph27
	//finish procedure
	return graphtypelist
end

Function /S SP2_tabletypelistcreator()
	//return string: list of table types
	//martin.gysel@psi.ch
	
	//create table type list
	string tabletypelist=""
	tabletypelist+=ksSP2table0
	tabletypelist+=ksSP2table4
	tabletypelist+=ksSP2table1
	tabletypelist+=ksSP2table2
	tabletypelist+=ksSP2table3
	tabletypelist+=ksSP2table5
	tabletypelist+=ksSP2table6
	tabletypelist+=ksSP2table7
	tabletypelist+=ksSP2table8
	tabletypelist+=ksSP2table9
	//finish procedure
	return tabletypelist
end


Function SP2panelPSILoadTypeProc(ctrlName,popNum,popStr) : PopupMenuControl
	//martin.gysel@psi.ch; 08/10/2008;
	String ctrlName		//not used
	Variable popNum		//must be provided correctly!
	String popStr			//not used

	//preparations
	string savedDF=getdatafolder(1)
	//access global variable
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LoadType=$ksSP2LoadType
	//write new value to global variable
	LoadType=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


//Function SP2panelPSItabletypeProc(ctrlName,popNum,popStr) : PopupMenuControl
//	//martin.gysel@psi.ch; 19/11/2009;
//	String ctrlName		//not used
//	Variable popNum		//not used
//	String popStr			//must be provided correctly!
//
//	//preparations
//	string savedDF=getdatafolder(1)
//	//access global variable
//	setdatafolder $ksSP2PathToToolkitPanelFldr
//	Svar tabletype=$ksSP2tabletype
//	//write new value to global variable
//	tabletype=popStr+";"
//	//finish procedure
//	setdatafolder $savedDF
//	return 0
//End



		// Function SP2panelPSIMainTabProc_newUnf(ctrlName,tabNum) 
		// // UNFINISHED 

		// // martin.gysel@psi.ch
		// // joel.c.corbin+sci@gmail.com 2016-02-03	..note, it would be better to systematically name and then use ControlNameList("") to hide/show

		// End


Function SP2panelPSIMainTabProc(ctrlName,tabNum) : TabControl
	String ctrlName
	Variable tabNum

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access global variables/strings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar YAGpowerModeInv=$ksSP2YAGpowerModeInv
	Nvar SampleFlowMode=$ksSP2sampleFlowMode
	Svar CalibMatBCtype=$ksSP2calibMatBCtype
	Nvar SubTabTAval=$ksSP2subTabTAval	
	Nvar LEOfitFastFit=$ksSP2LEOfitFastFit
	Nvar LEOlimitBCdiamCB=$ksSP2leoLimitBCdiamCB
	Nvar  LEOlimitOptdiamCB=$ksSP2leoLimitOptDiamCB
	//set tab
	TabControl SP2panelPSIMainTabs value=tabNum

	
	// this is a more-compact way of hiding/showing buttons, but only includes
	// buttons added since v4110: 
		variable tabNumLoad= 0
		variable tabNumCalib= 1
		variable tabNumTA= 2
		variable tabNumPostProc= 3
		variable tabNumLEO= 4
		variable tabNumGr= 5
		variable tabNumIce= 6
		variable tabNumConfig= 7
	CheckBox cb_predefBeamShape,	disable=(tabNum!=tabNumLEO)
	GroupBox MiscOptionsGB, 		disable=(tabNum!=tabNumConfig)
	CheckBox ExcludeSatFromDistCB,	disable=(tabNum!=tabNumConfig)
	CheckBox UseSAIforScattCoeffCB, disable=(tabNum!=tabNumConfig)
	CheckBox UseErrorBarsCB, 		disable=(tabNum!=tabNumConfig)
	// HELP_BUTTON_TABS
	Button SP2helpbtn_panelThresholds,	disable=(tabNum!=tabNumPostProc)
	Button SP2helpbtn_panelTA, 			disable=(tabNum!=tabNumTA)
	Button SP2helpbtn_LEOgen,			disable=(tabNum!=tabNumLEO)
	Button SP2helpbtn_SAI,				disable=(tabNum!=tabNumLEO)
	Button SP2helpbtn_SAI,				disable=(tabNum!=tabNumLEO)

	//first tab (load)
	if (tabNum==0)
		//enable controls on load tab
		PopupMenu LoadTypeMenu, disable=0
		Button loadrawdata, disable=0
		TitleBox NoteChannelConfig, disable=0
		Button WriteSampleFlowWaveBtt, disable=0
		TitleBox SampleFlowFrom, disable=0
		CheckBox SampleFlowFromHK, disable=0
		CheckBox SampleFlowFromINI, disable=0
		CheckBox SampleFlowFromConst, disable=0
		SetVariable SampleFlowSV, disable=2*(SampleFlowMode!=2)
		Button WriteYAGpowerWaveBtt, disable=0
		CheckBox YAGpowerConst, disable=0
		CheckBox YAGpowerFromHK, disable=0 // was off in v4110 [==2]
		SetVariable YAGpowerSV, disable=YAGpowerModeInv
		Button LoadOneHKfile, disable=0
		Button ConcatenateHFfldrs, disable=0
		Button HKdataRemapButt, disable=0
		CheckBox LoadFractModeInvCB, disable=0
		CheckBox LoadFractModeCB, disable=0
		CheckBox ConcatMode, disable=0
		CheckBox hkloadmode, disable=0
		CheckBox AnalyseTracesMode, disable=0
		CheckBox LEOfitModeLoadTab, disable=0
		CheckBox rawdatadelCB1, disable=0
		CheckBox PostProcessingMode, disable=0
		CheckBox LEOrunPostProcLoadTab, disable=0
		CheckBox LogNormFitModeLtab, disable=0
		CheckBox ExtractConcModeLtab, disable=0
		CheckBox ExtractSDModeLtab, disable=0
		SetVariable LoadOneOutOfSetVar, disable=0
		SetVariable MaxDataRateSetVar, disable=0
		Button DeleteSP2DataByIndex, disable=0
		Button DeleteSP2DataByTime, disable=0
		Button DeleteSP2DataByExpression, disable=0
		GroupBox LoadRawData_GB, disable=0
		GroupBox LoadHDdata_GB, disable=0
		GroupBox DeleteSP2rawData_GB, disable=0
		Button LoadHKfiles, disable=0
		PopupMenu LoadHKtypeMenu, disable=0
		CheckBox HKConcatMode, disable=0
		CheckBox HKremapMode, disable=0
		SetVariable LoadHKfilesRemapInt, disable=0
		Button ConcatenateSP2rawfldrs, disable=0
	else
		//hide controls on load tab
		PopupMenu LoadTypeMenu, disable=1
		Button loadrawdata, disable=1
		TitleBox NoteChannelConfig, disable=1
		Button WriteSampleFlowWaveBtt, disable=1
		TitleBox SampleFlowFrom, disable=1
		CheckBox SampleFlowFromHK, disable=1
		CheckBox SampleFlowFromINI, disable=1
		CheckBox SampleFlowFromConst, disable=1
		SetVariable SampleFlowSV, disable=1
		Button WriteYAGpowerWaveBtt, disable=1
		CheckBox YAGpowerConst, disable=1
		CheckBox YAGpowerFromHK, disable=1
		SetVariable YAGpowerSV, disable=1
		Button LoadOneHKfile, disable=1
		Button ConcatenateHFfldrs, disable=1
		Button HKdataRemapButt, disable=1
		CheckBox LoadFractModeInvCB, disable=1
		CheckBox LoadFractModeCB, disable=1
		CheckBox ConcatMode, disable=1
		CheckBox hkloadmode, disable=1
		CheckBox AnalyseTracesMode, disable=1
		CheckBox LEOfitModeLoadTab, disable=1
		CheckBox rawdatadelCB1, disable=1
		CheckBox PostProcessingMode, disable=1
		CheckBox LEOrunPostProcLoadTab, disable=1
		CheckBox LogNormFitModeLtab, disable=1
		CheckBox ExtractConcModeLtab, disable=1
		CheckBox ExtractSDModeLtab, disable=1
		SetVariable LoadOneOutOfSetVar, disable=1
		SetVariable MaxDataRateSetVar, disable=1
		Button DeleteSP2DataByIndex, disable=1
		Button DeleteSP2DataByTime, disable=1
		Button DeleteSP2DataByExpression, disable=1
		GroupBox LoadRawData_GB, disable=1
		GroupBox LoadHDdata_GB, disable=1
		GroupBox DeleteSP2rawData_GB, disable=1
		Button LoadHKfiles, disable=1
		PopupMenu LoadHKtypeMenu, disable=1
		CheckBox HKConcatMode, disable=1
		CheckBox HKremapMode, disable=1
		SetVariable LoadHKfilesRemapInt, disable=1
		Button ConcatenateSP2rawfldrs, disable=1
	endif
	//second tab (calib)
	if (tabNum==1)
		//enable controls on calib tab
		PopupMenu CalibFldrCalibTab, disable=0
		PopupMenu ScattSizingRefractIndexCalTab, disable=0
		SetVariable BetaDMA, disable=0
		Button CalibAnalyseMonoIncand, disable=0
		Button CalibMonoIncandFitSpline, disable=0
		Button CalibAnalyseMonoScatt, disable=0
		Button CalibAnalyseMonoScattPostProc, disable=0
		Button CreateCalibCoeffWavs, disable=0
		Button CalcCalibCurveWavs, disable=0
		GroupBox CalibConstCalibTabGB, disable=0
		GroupBox AnalyseCalibration, disable=0
		GroupBox CalibIncandChannelsGB, disable=0
		GroupBox CalibScattChannelsGB, disable=0
		GroupBox CalibAllChannelsGB, disable=0
		GroupBox DMPSdataPrep, disable=0
		Button DMPSloadRawData, disable=0
		Button DMPSdummyMatrices, disable=0
		Button DMPSextractTimeSeries, disable=0
		GroupBox CPCDMAloggerGB, disable=0
		Button CPCDMAloadRawData, disable=0
		Button CreateEmptyCPCDMAdataWaves, disable=2
		Button CPCDMAextractTimeSeries, disable=0
		GroupBox IncandCalibDataPrepGB, disable=0
		Button BCemptyInfoWavsButt, disable=0
		GroupBox ScattCalibDataPrepGB, disable=0
		Button ScattEmptyInfoWavsButt, disable=0
		Button ScattgetStartEndTimes, disable=2
		PopupMenu BCcalibMatPM, disable=0
		SP2_SelectCalibMatBCPMproc("",NaN,CalibMatBCtype)		// shows or hides SetVariable BCdensityCalibMat depending on selected calibration material
	else
		//hide controls on calib tab
		PopupMenu CalibFldrCalibTab, disable=1
		PopupMenu ScattSizingRefractIndexCalTab, disable=1
		SetVariable BetaDMA, disable=1
		Button CalibAnalyseMonoIncand, disable=1
		Button CalibMonoIncandFitSpline, disable=1
		Button CalibAnalyseMonoScatt, disable=1
		Button CalibAnalyseMonoScattPostProc, disable=1
		Button CreateCalibCoeffWavs, disable=1
		Button CalcCalibCurveWavs, disable=1
		GroupBox CalibConstCalibTabGB, disable=1
		GroupBox AnalyseCalibration, disable=1
		GroupBox CalibIncandChannelsGB, disable=1
		GroupBox CalibScattChannelsGB, disable=1
		GroupBox CalibAllChannelsGB, disable=1
		GroupBox DMPSdataPrep, disable=1
		Button DMPSloadRawData, disable=1
		Button DMPSdummyMatrices, disable=1
		Button DMPSextractTimeSeries, disable=1
		GroupBox CPCDMAloggerGB, disable=1
		Button CPCDMAloadRawData, disable=1
		Button CreateEmptyCPCDMAdataWaves, disable=1
		Button CPCDMAextractTimeSeries, disable=1
		GroupBox IncandCalibDataPrepGB, disable=1
		Button BCemptyInfoWavsButt, disable=1
		GroupBox ScattCalibDataPrepGB, disable=1
		Button ScattEmptyInfoWavsButt, disable=1
		Button ScattgetStartEndTimes, disable=1
		SetVariable BCdensityCalibMat, disable=1
		PopupMenu BCcalibMatPM, disable=1
	endif
	//third tab (trace analysis)
	if (tabNum==2)
		//enable controls on trace analysis tab
		GroupBox CalibConstAndBCpropTAtabGB, disable=1
		SetVariable BCdensityAnalysisTab, disable=1
		PopupMenu CalibFldrAnalyseTab, disable=1
		GroupBox TraceAnalysisGB, disable=0
//		GroupBox FittingScattGB, disable=0
//		GroupBox FittingIncandGB, disable=0
		Button AnalyseTracesButt, disable=0
		TitleBox FitScattTB, disable=0
		TitleBox FitBroadTB, disable=0
		TitleBox FitNarrTB, disable=0
		TitleBox FitSplitTB, disable=0
		TitleBox HighGainTB, disable=0
		TitleBox LowGainTB, disable=0
		CheckBox fitscattCB, disable=2*kSP2disableSCHG
		CheckBox fitbroadCB, disable=2*kSP2disableBBHG
		CheckBox fitnarrCB, disable=2*kSP2disableNBHG
		CheckBox fitsplitCB, disable=2*kSP2disableSPHG
		CheckBox fitSCLGCB, disable=2*kSP2disableSCLG
		CheckBox fitBBLGCB, disable=2*kSP2disableBBLG
		CheckBox fitNBLGCB, disable=2*kSP2disableNBLG
		CheckBox fitSPLGCB, disable=2*kSP2disableSPLG
		CheckBox LEOfitModeTAtab, disable=0
		CheckBox LEOrunPostProcTAtab, disable=0
		CheckBox rawdatadelCBTAtab, disable=0
		CheckBox PostProcessingModeTAtab, disable=0
		CheckBox LogNormFitModeTAtab, disable=0
		CheckBox ExtractConcModeTAtab, disable=0
		CheckBox ExtractSDModeTAtab, disable=0
		TabControl SP2panelSubTabTA, disable=0
		SP2panelPSISubTabTAProc("",SubTabTAval)		//bring selected tab to front
	else
		//hide controls on on trace analysis tab
		GroupBox CalibConstAndBCpropTAtabGB, disable=1
		SetVariable BCdensityAnalysisTab, disable=1
		PopupMenu CalibFldrAnalyseTab, disable=1
		GroupBox TraceAnalysisGB, disable=1
//		GroupBox FittingScattGB, disable=1
//		GroupBox FittingIncandGB, disable=1
		Button AnalyseTracesButt, disable=1
		TitleBox FitScattTB, disable=1
		TitleBox FitBroadTB, disable=1
		TitleBox FitNarrTB, disable=1
		TitleBox FitSplitTB, disable=1
		TitleBox HighGainTB, disable=1
		TitleBox LowGainTB, disable=1
		CheckBox fitscattCB, disable=1
		CheckBox fitbroadCB, disable=1
		CheckBox fitnarrCB, disable=1
		CheckBox fitsplitCB, disable=1
		CheckBox fitSCLGCB, disable=1
		CheckBox fitBBLGCB, disable=1
		CheckBox fitNBLGCB, disable=1
		CheckBox fitSPLGCB, disable=1
		CheckBox LEOfitModeTAtab, disable=1
		CheckBox LEOrunPostProcTAtab, disable=1
		CheckBox rawdatadelCBTAtab, disable=1
		CheckBox PostProcessingModeTAtab, disable=1
		CheckBox ExtractConcModeTAtab, disable=1
		CheckBox ExtractSDModeTAtab, disable=1
		CheckBox LogNormFitModeTAtab, disable=1
		TabControl SP2panelSubTabTA, disable=1
		variable remember=SubTabTAval
		SP2panelPSISubTabTAProc("",-1)	//hide all controls on sub-tab
		SubTabTAval=remember
	endif
	//forth tab (post processing)
	if (tabNum==3)
		//enable controls on post processing tab
		GroupBox CalibConstAndBCpropPostProcGB, disable=0
		GroupBox PostProcessingGB, disable=0
		Button PostProcessingButt, disable=0
		SetVariable BCdensityPostProcTab, disable=0
		SetVariable NumbOfHistoBins, disable=0
		TitleBox HighGainPPtabTB, disable=0
		TitleBox LowGainPPtabTB, disable=0
		SetVariable MinPeakHtSCHG, disable=2*kSP2disableSCHG
		SetVariable MinPeakHtBBHG, disable=2*kSP2disableBBHG
		SetVariable MinPeakHtNBHG, disable=2*kSP2disableNBHG
		SetVariable MinPeakHtSPHG, disable=2*kSP2disableSPHG
		SetVariable MinPeakHtSCLG, disable=2*kSP2disableSCLG
		SetVariable MinPeakHtBBLG, disable=2*kSP2disableBBLG
		SetVariable MinPeakHtNBLG, disable=2*kSP2disableNBLG
		SetVariable MinPeakHtSPLG, disable=2*kSP2disableSPLG
		SetVariable DetectCutSCHG_SV, disable=2*kSP2disableSCHG
		SetVariable DetectCutBBHG_SV, disable=2*kSP2disableBBHG
		SetVariable DetectCutNBHG_SV, disable=2*kSP2disableNBHG
		SetVariable DetectCutSPHG_SV, disable=2*kSP2disableSPHG
		SetVariable DetectCutSCLG_SV, disable=2*kSP2disableSCLG
		SetVariable DetectCutBBLG_SV, disable=2*kSP2disableBBLG
		SetVariable DetectCutNBLG_SV, disable=2*kSP2disableNBLG
		SetVariable DetectCutSPLG_SV, disable=2*kSP2disableSPLG
		CheckBox CalcBHNH_CB, disable=2*(kSP2disableBBHG | kSP2disableNBHG)
		CheckBox CalcBHNL_CB, disable=2*(kSP2disableBBHG | kSP2disableNBLG)
		CheckBox CalcBHBL_CB, disable=2*(kSP2disableBBHG | kSP2disableBBLG)
		CheckBox CalcBLNL_CB, disable=2*(kSP2disableBBLG | kSP2disableNBLG)
		CheckBox CalcSHSL_CB, disable=2*(kSP2disableSCHG | kSP2disableSCLG)
		CheckBox CalcPHPL_CB, disable=2*(kSP2disableSPHG | kSP2disableSPLG)
		PopupMenu ScattSizingRefractIndex, disable=0
		CheckBox LogNormFitModePPtab, disable=0
		CheckBox ExtractConcModePPtab, disable=0
		CheckBox ExtractSDModePPtab, disable=0
		CheckBox LEOrunPostProcPPtab, disable=0
		PopupMenu CalibFldrPostProcTab, disable=0
		GroupBox LogNormFitGB, disable=0
		GroupBox LogNormFitRangeGB, disable=0
		GroupBox LogNormIntRangeGB, disable=0
		Button LogNormFitButt, disable=0
		SetVariable LNfitDmeasMin, disable=0
		SetVariable LNfitDmeasMin, disable=0
		SetVariable LNfitDmeasMax, disable=0
		SetVariable LNfitDmeasMax, disable=0
		SetVariable LNfitDfitMin, disable=0
		SetVariable LNfitDfitMin, disable=0
		SetVariable LNfitDfitMax, disable=0
		SetVariable LNfitDfitMax, disable=0
		SetVariable LNfitNpts, disable=0
		GroupBox ExtractConcTimeSeriesGB, disable=0
		SetVariable ConcIntervalSV, disable=0
		Button ExtractConcTserBtt, disable=0
		GroupBox ExtractSDTimeSeriesGB, disable=0
		SetVariable SDIntervalSV, disable=0
		SetVariable SDNumbOftimeSeriesSizeBins, disable=0
		Button ExtractSizeDistrTserBtt, disable=0
		Button FitLogNorm2SDtimeSerBtt, disable=0
		Button AddBandRatioStats, disable=0
		Button AddDelayTimeStats, disable=0
		Button AddDelayTimeHisto, disable=0
		CheckBox AutoGraphCBPPtab, disable=0
		TitleBox HighGainPPtabTB1, disable=0
		TitleBox LowGainPPtabTB1, disable=0
		TitleBox PPtab_scatt_TB, disable=0
		TitleBox PPtab_broad_TB, disable=0
		TitleBox PPtab_narr_TB, disable=0
		TitleBox PPtab_split_TB, disable=0
		GroupBox IncludeInResultsGB, disable=0
		GroupBox TrueSignalsGB, disable=0
		GroupBox CombineChannelsGB, disable=0
		GroupBox ThresholdsGB, disable=0
	else
		//hide controls on post processing tab
		GroupBox CalibConstAndBCpropPostProcGB, disable=1
		GroupBox PostProcessingGB, disable=1
		Button PostProcessingButt, disable=1
		SetVariable BCdensityPostProcTab, disable=1
		SetVariable NumbOfHistoBins, disable=1
		TitleBox HighGainPPtabTB, disable=1
		TitleBox LowGainPPtabTB, disable=1
		SetVariable MinPeakHtSCHG, disable=1
		SetVariable MinPeakHtBBHG, disable=1
		SetVariable MinPeakHtNBHG, disable=1
		SetVariable MinPeakHtSPHG, disable=1
		SetVariable MinPeakHtSCLG, disable=1
		SetVariable MinPeakHtBBLG, disable=1
		SetVariable MinPeakHtNBLG, disable=1
		SetVariable MinPeakHtSPLG, disable=1
		SetVariable DetectCutSCHG_SV, disable=1
		SetVariable DetectCutBBHG_SV, disable=1
		SetVariable DetectCutNBHG_SV, disable=1
		SetVariable DetectCutSPHG_SV, disable=1
		SetVariable DetectCutSCLG_SV, disable=1
		SetVariable DetectCutBBLG_SV, disable=1
		SetVariable DetectCutNBLG_SV, disable=1
		SetVariable DetectCutSPLG_SV, disable=1
		CheckBox CalcBHNH_CB, disable=1
		CheckBox CalcBHNL_CB, disable=1
		CheckBox CalcBHBL_CB, disable=1
		CheckBox CalcBLNL_CB, disable=1
		CheckBox CalcSHSL_CB, disable=1
		CheckBox CalcPHPL_CB, disable=1
		PopupMenu ScattSizingRefractIndex, disable=1
		CheckBox LogNormFitModePPtab, disable=1
		CheckBox ExtractConcModePPtab, disable=1
		CheckBox ExtractSDModePPtab, disable=1
		CheckBox LEOrunPostProcPPtab, disable=1
		PopupMenu CalibFldrPostProcTab, disable=1
		GroupBox LogNormFitGB, disable=1
		GroupBox LogNormFitRangeGB, disable=1
		GroupBox LogNormIntRangeGB, disable=1
		Button LogNormFitButt, disable=1
		SetVariable LNfitDmeasMin, disable=1
		SetVariable LNfitDmeasMin, disable=1
		SetVariable LNfitDmeasMax, disable=1
		SetVariable LNfitDmeasMax, disable=1
		SetVariable LNfitDfitMin, disable=1
		SetVariable LNfitDfitMin, disable=1
		SetVariable LNfitDfitMax, disable=1
		SetVariable LNfitDfitMax, disable=1
		SetVariable LNfitNpts, disable=1
		GroupBox ExtractConcTimeSeriesGB, disable=1
		SetVariable ConcIntervalSV, disable=1
		Button ExtractConcTserBtt, disable=1
		GroupBox ExtractSDTimeSeriesGB, disable=1
		SetVariable SDIntervalSV, disable=1
		SetVariable SDNumbOftimeSeriesSizeBins, disable=1
		Button ExtractSizeDistrTserBtt, disable=1
		Button FitLogNorm2SDtimeSerBtt, disable=1
		Button AddBandRatioStats, disable=1
		Button AddDelayTimeStats, disable=1
		Button AddDelayTimeHisto, disable=1
		CheckBox AutoGraphCBPPtab, disable=1
		TitleBox HighGainPPtabTB1, disable=1
		TitleBox LowGainPPtabTB1, disable=1
		TitleBox PPtab_scatt_TB, disable=1
		TitleBox PPtab_broad_TB, disable=1
		TitleBox PPtab_narr_TB, disable=1
		TitleBox PPtab_split_TB, disable=1
		GroupBox IncludeInResultsGB, disable=1
		GroupBox TrueSignalsGB, disable=1
		GroupBox CombineChannelsGB, disable=1
		GroupBox ThresholdsGB, disable=1
	endif
	//fifth tab (LEO)
	if (tabNum==4)
		//enable controls on LEO
		GroupBox LEOfitPrepGB, disable=0
		GroupBox LEOtraceAnalysisGB, disable=0
		GroupBox LEOverificationGF, disable=0
		GroupBox LEOpostProcGB, disable=0
		GroupBox ScattAtIncLEOtabGB, disable=0
		Button LEOfitPreparation, disable=0
		Button LEOtraceAnalysis, disable=0
		Button LEOverificationSizingButt, disable=0
		Button LEOpostProcButt, disable=0
		Button LEOperformStatsButt, disable=0
		Button ScattAtIncLEOtabNormalizeButt, disable=0
		Button ScattAtIncLEOtabSizingButt, disable=0
		SetVariable LEOfitRangeSV, disable=0
		SetVariable LEOfitMinNumPntsSV, disable=2*LEOfitFastFit
		SetVariable LEOfitFastNumPtsSV, disable=2*!LEOfitFastFit
		SetVariable LEOminPkHtSCHG_SV, disable=0
		SetVariable LEOminPkHtSCLG_SV, disable=0
		SetVariable LEOminPkHtSPHG_SV, disable=0
		SetVariable LEOminPkHtSPLG_SV, disable=0
		SetVariable LEOdiamMinSV, disable=2*( (LEOlimitBCdiamCB+LEOlimitOptdiamCB)==0 )
		SetVariable LEOdiamMaxSV, disable=2*( (LEOlimitBCdiamCB+LEOlimitOptdiamCB)==0 )
		SetVariable LEOnumbOfSizeBins, disable=0
		SetVariable LEOnumbOfVolFractHistBins, disable=0
		SetVariable LEOnumbOfCoatThicknHistBins, disable=0
		SetVariable LEOnumbOfDelayHistBins, disable=0
//		CheckBox AutoGraphCBLEOtab, disable=0
		CheckBox LEOfitSkipGaussCB, disable=0
		CheckBox LEOfitSkipBeamShapeCB, disable=0
		CheckBox LEOfitFastFitCB, disable=0
		CheckBox LEOrunPostProcCB, disable=0
		CheckBox LEOfitSCHGdataCB, disable=0
		CheckBox LEOfitSCLGdataCB, disable=0
		CheckBox LEOfitSPHGdataCB, disable=0	
		CheckBox LEOfitSPLGdataCB, disable=0
		CheckBox LEOfitSlopeResetSCHGCB, disable=0
		CheckBox LEOnegCoatingTreatmentCB, disable=0
		CheckBox LEOfitSlopeResetSCLGCB, disable=0
		CheckBox LEOfitCalFactResetSPHGCB, disable=0
		CheckBox LEOfitCalFactResetSPLGCB, disable=0
		CheckBox LEOfitVerificationStatsRun, disable=0
		CheckBox LEOfitVerificationStatsMedian, disable=0
		CheckBox rawdatadelCBLEOtab, disable=0
		CheckBox LEOlimitBCcoreDiamCB, disable=0
		CheckBox LEOlimitOptDiamCB, disable=0
		PopupMenu LEOsplitPosChanPrefixPM, disable=0
		PopupMenu LEOscattPrefixForSPHGcalibPM, disable=0
		PopupMenu LEOscattPrefixForSPLGcalibPM, disable=0
		PopupMenu LEOsizingRefractIndexPair, disable=0
		PopupMenu LEOincandPrefixPM, disable=0
		PopupMenu SAIchanPrefixPSDpm, disable=0
		TitleBox ResetSlopeFactTB, disable=0
		TitleBox ResetPSDcalFactTB, disable=0
		Button editCalFacts, disable=0
		TitleBox SelectPSDcalibRefChanTB, disable=0
		TitleBox MinPeakHeightScattTB, disable=0
		TitleBox MinPeakHeightSplitTB, disable=0
	else
		//hide controls on LEO
		GroupBox LEOfitPrepGB, disable=1
		GroupBox LEOtraceAnalysisGB, disable=1
		GroupBox LEOverificationGF, disable=1
		GroupBox LEOpostProcGB, disable=1
		GroupBox ScattAtIncLEOtabGB, disable=1
		Button LEOfitPreparation, disable=1
		Button LEOtraceAnalysis, disable=1
		Button LEOverificationSizingButt, disable=1
		Button LEOpostProcButt, disable=1
		Button LEOperformStatsButt, disable=1
		Button ScattAtIncLEOtabNormalizeButt, disable=1
		Button ScattAtIncLEOtabSizingButt, disable=1
		SetVariable LEOfitRangeSV, disable=1
		SetVariable LEOfitFastNumPtsSV, disable=1
		SetVariable LEOfitMinNumPntsSV, disable=1
		SetVariable LEOminPkHtSCHG_SV, disable=1
		SetVariable LEOminPkHtSCLG_SV, disable=1
		SetVariable LEOminPkHtSPHG_SV, disable=1
		SetVariable LEOminPkHtSPLG_SV, disable=1
		SetVariable LEOdiamMinSV, disable=1
		SetVariable LEOdiamMaxSV, disable=1
		SetVariable LEOnumbOfSizeBins, disable=1
		SetVariable LEOnumbOfVolFractHistBins, disable=1
		SetVariable LEOnumbOfCoatThicknHistBins, disable=1
		SetVariable LEOnumbOfDelayHistBins, disable=1
//		CheckBox AutoGraphCBLEOtab, disable=1
		CheckBox LEOfitSkipGaussCB, disable=1
		CheckBox LEOfitSkipBeamShapeCB, disable=1
		CheckBox LEOfitFastFitCB, disable=1		
		CheckBox LEOrunPostProcCB, disable=1
		CheckBox LEOfitSCHGdataCB, disable=1
		CheckBox LEOfitSCLGdataCB, disable=1
		CheckBox LEOfitSPHGdataCB, disable=1	
		CheckBox LEOfitSPLGdataCB, disable=1
		CheckBox LEOfitSlopeResetSCHGCB, disable=1
		CheckBox LEOnegCoatingTreatmentCB, disable=1
		CheckBox LEOfitSlopeResetSCLGCB, disable=1
		CheckBox LEOfitCalFactResetSPHGCB, disable=1
		CheckBox LEOfitCalFactResetSPLGCB, disable=1
		CheckBox LEOfitVerificationStatsRun, disable=1
		CheckBox LEOfitVerificationStatsMedian, disable=1
		CheckBox rawdatadelCBLEOtab, disable=1
		CheckBox LEOlimitBCcoreDiamCB, disable=1
		CheckBox LEOlimitOptDiamCB, disable=1
		PopupMenu LEOsplitPosChanPrefixPM, disable=1
		PopupMenu LEOscattPrefixForSPHGcalibPM, disable=1
		PopupMenu LEOscattPrefixForSPLGcalibPM, disable=1
		PopupMenu LEOsizingRefractIndexPair, disable=1
		PopupMenu LEOincandPrefixPM, disable=1
		PopupMenu SAIchanPrefixPSDpm, disable=1
		TitleBox ResetSlopeFactTB, disable=1
		TitleBox ResetPSDcalFactTB, disable=1
		Button editCalFacts, disable=1
		TitleBox SelectPSDcalibRefChanTB, disable=1
		TitleBox MinPeakHeightScattTB, disable=1
		TitleBox MinPeakHeightSplitTB, disable=1
	endif
	//sixth tab (graphs/tables)
	if (tabNum==5)
		//enable controls on graphs/tables tab
		PopupMenu graphtypePMraw, disable=0
		PopupMenu graphtypePManalysed, disable=0
		PopupMenu graphtypePMcalib, disable=0
		PopupMenu graphtypePMtser, disable=0
		PopupMenu graphtypePMleo, disable=0
		PopupMenu graphtypePMsai, disable=0
		PopupMenu graphtypePMicecore, disable=0
		Button GraphButtraw, disable=0
		Button GraphButtcalib, disable=0
		Button GraphButtanalysed, disable=0
		Button GraphButttser, disable=0
		Button GraphButtleo, disable=0
		Button GraphButtSAI, disable=0
		Button GraphButticecore, disable=0
		PopupMenu tabletypePM, disable=0
		Button tableButt, disable=0	
	else
		//hide controls on graphs/tables tab
		PopupMenu graphtypePMraw, disable=1
		PopupMenu graphtypePManalysed, disable=1
		PopupMenu graphtypePMcalib, disable=1
		PopupMenu graphtypePMtser, disable=1
		PopupMenu graphtypePMleo, disable=1
		PopupMenu graphtypePMsai, disable=1
		PopupMenu graphtypePMicecore, disable=1
		Button GraphButtraw, disable=1
		Button GraphButtcalib, disable=1
		Button GraphButtanalysed, disable=1
		Button GraphButttser, disable=1
		Button GraphButtleo, disable=1
		Button GraphButtSAI, disable=1
		Button GraphButticecore, disable=1
		PopupMenu tabletypePM, disable=1
		Button tableButt, disable=1
	endif
	//seventh tab (ice core)
	if (tabNum==6)
		//enable controls on ice core tab
		Button CETACcalcLiqSampleConc, disable=0
		SetVariable CetacSampleFlow, disable=0
		SetVariable CetacDrainFlow, disable=0
		SetVariable CetacPurgeAirFlow, disable=0
		GroupBox CETACsettings, disable=0
		GroupBox BatchLoad, disable=0
		Button BatchLoadPreparation, disable=0
		Button BatchLoadData, disable=0
		Button BatchExtractSummary, disable=0
		PopupMenu CalibFldrIceCoreTab, disable=0
	else
		//hide controls on ice core tab
		Button CETACcalcLiqSampleConc, disable=1
		SetVariable CetacSampleFlow, disable=1
		SetVariable CetacDrainFlow, disable=1
		SetVariable CetacPurgeAirFlow, disable=1
		GroupBox CETACsettings, disable=1
		GroupBox BatchLoad, disable=1
		Button BatchLoadPreparation, disable=1
		Button BatchLoadData, disable=1
		Button BatchExtractSummary, disable=1
		PopupMenu CalibFldrIceCoreTab, disable=1
	endif
	//eight tab (config)
	if (tabNum==7)
		//enable controls on config tab
		GroupBox ChannelHardwareConfig, disable=0
		PopupMenu ChanConfig_0, disable=0+2*(ksSP2numberofDAQchans<=0)
		PopupMenu ChanConfig_1, disable=0+2*(ksSP2numberofDAQchans<=1)
		PopupMenu ChanConfig_2, disable=0+2*(ksSP2numberofDAQchans<=2)
		PopupMenu ChanConfig_3, disable=0+2*(ksSP2numberofDAQchans<=3)
		PopupMenu ChanConfig_4, disable=0+2*(ksSP2numberofDAQchans<=4)
		PopupMenu ChanConfig_5, disable=0+2*(ksSP2numberofDAQchans<=5)
		PopupMenu ChanConfig_6, disable=0+2*(ksSP2numberofDAQchans<=6)
		PopupMenu ChanConfig_7, disable=0+2*(ksSP2numberofDAQchans<=7)
		GroupBox ChannelLoadConfig, disable=0
		CheckBox loadscattCB, disable=2*kSP2disableSCHG
		CheckBox loadbroadCB, disable=2*kSP2disableBBHG
		CheckBox loadnarrCB, disable=2*kSP2disableNBHG
		CheckBox loadsplitCB, disable=2*kSP2disableSPHG
		CheckBox loadSCLGCB, disable=2*kSP2disableSCLG
		CheckBox loadBBLGCB, disable=2*kSP2disableBBLG
		CheckBox loadNBLGCB, disable=2*kSP2disableNBLG
		CheckBox loadSPLGCB, disable=2*kSP2disableSPLG
		CheckBox invertSPHGCB, disable=2*kSP2disableSPHG
		CheckBox invertSPLGCB, disable=2*kSP2disableSPLG
		GroupBox DetectorDAQsaturationGB, disable=0
		SetVariable SaturationSCHG, disable=2*kSP2disableSCHG
		SetVariable SaturationBBHG, disable=2*kSP2disableBBHG
		SetVariable SaturationNBHG, disable=2*kSP2disableNBHG
		SetVariable SaturationSPHG, disable=2*kSP2disableSPHG
		SetVariable SaturationSCLG, disable=2*kSP2disableSCLG
		SetVariable SaturationBBLG, disable=2*kSP2disableBBLG
		SetVariable SaturationNBLG, disable=2*kSP2disableNBLG
		SetVariable SaturationSPLG, disable=2*kSP2disableSPLG
	else
		//hide controls on config tab
		GroupBox ChannelHardwareConfig, disable=1
		PopupMenu ChanConfig_0, disable=1
		PopupMenu ChanConfig_1, disable=1
		PopupMenu ChanConfig_2, disable=1
		PopupMenu ChanConfig_3, disable=1
		PopupMenu ChanConfig_4, disable=1
		PopupMenu ChanConfig_5, disable=1
		PopupMenu ChanConfig_6, disable=1
		PopupMenu ChanConfig_7, disable=1
		GroupBox ChannelLoadConfig, disable=1
		CheckBox loadscattCB, disable=1
		CheckBox loadbroadCB, disable=1
		CheckBox loadnarrCB, disable=1
		CheckBox loadsplitCB, disable=1
		CheckBox loadSCLGCB, disable=1
		CheckBox loadBBLGCB, disable=1
		CheckBox loadNBLGCB, disable=1
		CheckBox loadSPLGCB, disable=1
		CheckBox invertSPHGCB, disable=1
		CheckBox invertSPLGCB, disable=1
		GroupBox DetectorDAQsaturationGB, disable=1
		SetVariable SaturationSCHG, disable=1
		SetVariable SaturationBBHG, disable=1
		SetVariable SaturationNBHG, disable=1
		SetVariable SaturationSPHG, disable=1
		SetVariable SaturationSCLG, disable=1
		SetVariable SaturationBBLG, disable=1
		SetVariable SaturationNBLG, disable=1
		SetVariable SaturationSPLG, disable=1
	else
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Window SP2_Housekeeping_graph() : Graph
// ?
// joel.c.corbin+sci@gmail.com; 2016-05-07 updated
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder root:test:
	Display /W=(222.75,45.5,903,704)/L=leftConc ScatterConc_1percc,IncandConc_1percc vs TimeStamp as "SP2_Housekeeping_graph"
	AppendToGraph/L=leftDuty DutyCycle_perc vs TimeStamp
	AppendToGraph/L=leftflow PurgeFlowRead_sccm,PurgeFlowSet_sccm,SampleFlowLFE,SampleFlowRead_vccm vs TimeStamp
	AppendToGraph/L=leftflow SampleFlowSet_vccm,SheathFlowRead_sccm,SheathFlowSet_sccm vs TimeStamp
	AppendToGraph/L=leftTC ChamberTemp_C,DiodeTemp_C,YAGCrystalTemp_C,YAGHeatSinkT_C vs TimeStamp
	AppendToGraph/L=leftpower DiodePower_V,YAGPower_V vs TimeStamp
	AppendToGraph/L=leftHV Chan0HV_V,Chan1HV_V,Chan2HV_V,Chan3HV_V vs TimeStamp
	AppendToGraph/L=leftpress ChamberPressure_mBar vs TimeStamp
	AppendToGraph/L=leftcurr DiodeCurrent_A vs TimeStamp
	SetDataFolder fldrSav0
	ModifyGraph margin(left)=85
	ModifyGraph rgb(ScatterConc_1percc)=(0,0,65280),rgb(PurgeFlowRead_sccm)=(65280,43520,0)
	ModifyGraph rgb(PurgeFlowSet_sccm)=(39168,0,0),rgb(SampleFlowLFE)=(0,43520,65280)
	ModifyGraph rgb(SampleFlowRead_vccm)=(0,0,65280),rgb(SampleFlowSet_vccm)=(0,0,0)
	ModifyGraph rgb(SheathFlowRead_sccm)=(0,52224,0),rgb(SheathFlowSet_sccm)=(0,26112,13056)
	ModifyGraph rgb(ChamberTemp_C)=(0,52224,0),rgb(DiodeTemp_C)=(0,0,65280),rgb(YAGHeatSinkT_C)=(65280,43520,0)
	ModifyGraph rgb(DiodePower_V)=(0,0,65280),rgb(Chan1HV_V)=(65280,43520,0),rgb(Chan2HV_V)=(0,52224,0)
	ModifyGraph rgb(Chan3HV_V)=(0,0,65280)
	ModifyGraph grid=1
	ModifyGraph log(leftflow)=1
	ModifyGraph mirror=2
	ModifyGraph fSize=11
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph lblPos(leftConc)=65,lblPos(leftDuty)=65,lblPos(leftflow)=65,lblPos(leftTC)=65
	ModifyGraph lblPos(leftpower)=65,lblPos(leftHV)=65,lblPos(leftpress)=65,lblPos(leftcurr)=65
	ModifyGraph freePos(leftConc)=0
	ModifyGraph freePos(leftDuty)=0
	ModifyGraph freePos(leftflow)=0
	ModifyGraph freePos(leftTC)=0
	ModifyGraph freePos(leftpower)=0
	ModifyGraph freePos(leftHV)=0
	ModifyGraph freePos(leftpress)=0
	ModifyGraph freePos(leftcurr)=0
	ModifyGraph axisEnab(leftConc)={0.9,1}
	ModifyGraph axisEnab(leftDuty)={0.63,0.73}
	ModifyGraph axisEnab(leftflow)={0.77,0.87}
	ModifyGraph axisEnab(leftTC)={0.37,0.47}
	ModifyGraph axisEnab(leftpower)={0.5,0.6}
	ModifyGraph axisEnab(leftHV)={0.11,0.21}
	ModifyGraph axisEnab(leftpress)={0.24,0.34}
	ModifyGraph axisEnab(leftcurr)={0,0.09}
	ModifyGraph dateInfo(bottom)={0,0,0}
	Label leftConc "Conc. [#/cm?]"
	Label bottom "Time"
	Label leftDuty "Duty cycle [%]"
	Label leftflow "Flow rate [lpm]"
	Label leftTC "Temp. [?C]"
	Label leftpower "Power [V]"
	Label leftHV "Amp. HV [V]"
	Label leftpress "Press. [mbar]"
	Label leftcurr "Current [A]"
	SetAxis/A/N=1 leftConc
	SetAxis/N=1 leftDuty 90,100
	SetAxis/A/N=1 leftflow
	SetAxis/A/N=1 leftTC
	SetAxis/A/N=1 leftpower
	SetAxis/A/N=1 leftHV
	SetAxis/A/N=1 leftpress
	SetAxis/A/N=1 leftcurr
	Textbox/C/N=text0/J/A=MC/X=-33.90/Y=46.35 "\\Z11\\s(ScatterConc_1percc) scattering particles\r\\s(IncandConc_1percc) incandescent particles"
	Textbox/C/N=text1/J/A=MC/X=-38.11/Y=17.54 "\\Z11\\s(DutyCycle_perc) duty cycle"
	Textbox/C/N=text2/J/A=MC/X=-32.72/Y=32.78 "\\Z11\\s(PurgeFlowRead_sccm) PurgeFlowRead_sccm\r\\s(PurgeFlowSet_sccm) PurgeFlowSet_sccm"
	AppendText "\\s(SampleFlowLFE) SampleFlowLFE\r\\s(SampleFlowRead_vccm) SampleFlowRead_vccm\r\\s(SampleFlowSet_vccm) SampleFlowSet_vccm"
	AppendText "\\s(SheathFlowRead_sccm) SheathFlowRead_sccm\r\\s(SheathFlowSet_sccm) SheathFlowSet_sccm"
	Textbox/C/N=text3/J/A=MC/X=-38.24/Y=-7.81 "\\Z11Temperatures:\r\\s(ChamberTemp_C) chamber\r\\s(DiodeTemp_C) diode\r\\s(YAGCrystalTemp_C) YAG crystal"
	AppendText "\\s(YAGHeatSinkT_C) YAG heat sink"
	Textbox/C/N=text4/J/A=MC/X=-40.60/Y=5.12 "\\Z11\\s(DiodePower_V) diode\r\\s(YAGPower_V) YAG"
	Textbox/C/N=text5/J/A=MC/X=-37.32/Y=-33.55 "\\Z11\\s(Chan0HV_V) channel 0\r\\s(Chan1HV_V) channel 1\r\\s(Chan2HV_V) channel 2\r\\s(Chan3HV_V) channel 3"
	Textbox/C/N=text6/J/A=MC/X=-35.35/Y=-21.77 "\\Z11\\s(ChamberPressure_mBar) chamber pressure"
	Textbox/C/N=text7/J/A=MC/X=-36.01/Y=-45.20 "\\Z11\\s(DiodeCurrent_A) diode current"
EndMacro


Function SP2_tablebutt(ctrlname) : ButtonControl
	//This function creates an SP2 table according to the selection on the SP2 panel.
	//return value 0; not used
	//martin.gysel@psi.ch; 19/11/2009, 07/05/2010, 08/05/2010, 29/09/2010
	string ctrlname	//name of button control; used!
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//get type of table to be created
	strswitch (ctrlname)
		case "TableButt":
			ControlInfo /W=$ksSP2toolkitPanelWnam tabletypePM
			break
		default:		
			setdatafolder $savedDF
			message="Undefined control name in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch	
	string tabletype=S_value+";"
	//create table
	strswitch (tabletype) // v4111 removed savedDF below
		case ksSP2table0:
			SP2table_IceCoreSummary(SummaryFldrFP=savedDF)
			break
		case ksSP2table1:
			SP2table_CalibIncandFitPkHt(CalibSummaryFldrFP=savedDF)
			break
		case ksSP2table2:
			SP2table_CalibCoef() 
			break
		case ksSP2table3:
			SP2_LEOtbl_NumbConcByTypeBtt() 
			break
		case ksSP2table4:
			SP2table_CalibInfoMonodispBC(CalibInfoFldrFP=savedDF)
			break
		default:		
			setdatafolder $savedDF
			message="Selected table type not implemented in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch	
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2_PretriggerAvgCBproc(ctrlName,checked) : CheckBoxControl
	//This function updates the global variables corresponding to the check boxes
	//"PretriggerMode" and "PretriggerModeInv" on the SP2 toolkit panel,
	//and shows/hides the setvariable for the number of pretrigger points.
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/11/2008
	String ctrlName		//name of button control
						//either "PretriggerMode" or "PretriggerModeInv"
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)
	string message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar PretriggerAvgMode=$ksSP2pretriggeravgmode
	Nvar PretriggerAvgModeInv=$ksSP2pretriggeravgmodeInv
	//write selection to global variables
	strswitch (ctrlName)
		case "PretriggerMode":
			PretriggerAvgMode=checked
			break
		case "PretriggerModeInv":
			PretriggerAvgMode=!checked
			break
		default:			
			message="Checkbox-procedure "+currproc+" is only defined for controls with the name 'PretriggerMode' or 'PretriggerModeInv'!"
			print message;print RTStackInfo;abort message	
			break
	endswitch
	PretriggerAvgModeInv=!PretriggerAvgMode
	//show/hide control
	SetVariable numbofpretrigger, disable=2*PretriggerAvgMode
	//finish procedure
	setdatafolder $savedDF
	return 0			
End

Function /S SP2_CalibListUpdate()
	//This procedure updates the list of folders (potentially) containing calibration data
	//return string: list of partial path to calibration folders
	//martin.gysel@psi.ch; 12/11/2008
//	String ctrlName	//name of button control; not used
	
	//get list of calibration folders
	string CalibFldrList=ListOfAllFolders(ksSP2PathToCalibDataFldr, PathMode=0)
	//sort list
	CalibFldrList=SortList(CalibFldrList)
	//remove trailing ":"
	CalibFldrList=replacestring(":;",CalibFldrList,";")
	//finish procedure
	return CalibFldrList
End

Function SP2_SelectCalibFldrPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the calibration folder to be used for the analysis according to the panel selection.
	//return value: 0; not used
	//martin.gysel@psi.ch, 12/11/2008
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar CalibFldr=$ksSP2calibFldr
	//update selected calibration folder
	CalibFldr=popStr
	//determine popNum
	string CalibFldrList=SP2_CalibListUpdate()
	popNum=1+WhichListItem(popStr, CalibFldrList)
	//update all popmenus on the panel
	PopupMenu CalibFldrCalibTab,mode=popNum
	PopupMenu CalibFldrAnalyseTab,mode=popNum
	PopupMenu CalibFldrPostProcTab,mode=popNum
	PopupMenu CalibFldrIceCoreTab,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_SelectCalibMatBCPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the BC calibration material to be used for analysing BC data.
	//return value: 0; not used
	//martin.gysel@psi.ch; 18/09/2009
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar CalibMatBCtype=$ksSP2calibMatBCtype
	//update PopMenuControl
	popNum=1+WhichListItem(popStr, ksSP2calibMatList)
	if (popNum==0)
		setdatafolder $savedDF
		message="Calibration material '"+popStr+"' not defined in the function "+currproc+"!"
		print message; print RTStackInfo; abort message
	endif
	PopupMenu BCcalibMatPM,mode=popNum
	//write selection to global variable
	CalibMatBCtype=popStr
	//show/hide setvariable for mobility density
	strswitch (popStr)
		case ksSP2calibMatConstMobDens:
			//show
			SetVariable BCdensityCalibMat, disable=0
			break
		default:			
			//disable
			SetVariable BCdensityCalibMat, disable=2
			break
	endswitch
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2panelscattfittypeProc(ctrlName,popNum,popStr) : PopupMenuControl
	//martin.gysel@psi.ch; 26/11/2009;
	String ctrlName		//not used
	Variable popNum		//must be provided correctly!
	String popStr			//not used

	//preparations
	string savedDF=getdatafolder(1)
	//access global variable
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar scattfittype=$ksSP2scattfittype
	//write new value to global variable
	scattfittype=popnum-1
	// show or hide control
	SetVariable Npts4scattPeak, disable=2*(scattfittype!=2)
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2panelincfittypeProc(ctrlName,popNum,popStr) : PopupMenuControl
	//martin.gysel@psi.ch; 11/11/2008;
	String ctrlName		//not used
	Variable popNum		//must be provided correctly!
	String popStr			//not used

	//preparations
	string savedDF=getdatafolder(1)
	//access global variable
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar incfittype=$ksSP2incfittype
	//write new value to global variable
	incfittype=popnum-1
	// show or hide control
	CheckBox MatchNarrToBroad, disable=2*incfittype
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2panel_splitSearchModeProc(ctrlName,popNum,popStr) : PopupMenuControl
	// joel.c.corbin+sci@gmail.com; 2016-08-25.  
	String ctrlName, popStr		// not used
	Variable popNum		// set by popup menu

	NVAR splitsearchmode=$ksSP2PathToToolkitPanelFldr + ksSP2splitSearchMode
	splitsearchmode= popNum-1
	
	return 0
End

Function SP2panel_splitPosModeProc(ctrlName,popNum,popStr) : PopupMenuControl
	// joel.c.corbin+sci@gmail.com; 2016-08-25.  
	String ctrlName, popStr		// not used
	Variable popNum		// set by popup menu

	NVAR splitposmode=$ksSP2PathToToolkitPanelFldr + ksSP2splitPosMode
	splitposmode= popNum-1
	
	return 0
End




Function SP2graph_IncandCalibResults([CalibFldrFP, ChanDescr])
	//This function creates a graph showing the incandescence calibration results
	//martin.gysel@psi.ch; 10/10/2008, 02/11/2008, 04/05/2010, 12/05/2010;
	string CalibFldrFP	//full path to the data folder containing the calibration results
					//default: current data folder
	string ChanDescr	//ChanDescr description
					//must be "all incandescence channels" or an element out of the list returned by the function SP2_ChanListIncandOnly
					//default: prompt				
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(CalibFldrFP))
		CalibFldrFP=savedDF
	endif
	CalibFldrFP=ChopLastCharacterOff(CalibFldrFP,":")
	string DescrList="all channels;"+SP2_ChanListToDescrShortList(SP2_ChanListIncandOnly())
	if (paramisdefault(ChanDescr))
		ChanDescr=stringfromlist(0,DescrList)
		prompt ChanDescr, "Select incandescence channel:",popup, DescrList
		doprompt "ChanDescr", ChanDescr
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure!"
			print message; print RTStackInfo; abort message
		endif
	endif
	variable ChanNo=whichlistitem(ChanDescr,DescrList)
	if (ChanNo==-1)
		setdatafolder $savedDF
		message="Undefined value of the parameter 'ChanDescr' handed over to the function "+currproc+"!"
		print message; print RTStackInfo; abort message	
	elseif (ChanNo==0)
		//graph to be shown for all channels => loop over all channels
		variable nChans=itemsinlist(DescrList)-1
		variable cind
		for (cind=1; cind<nChans+1; cind+=1)
			SP2graph_IncandCalibResults(CalibFldrFP=CalibFldrFP, ChanDescr=stringfromlist(cind,DescrList))	//recursive!!!
		endfor
		//finish procedure
		setdatafolder $savedDF
		return 0	
	else
		//remove the "all channels" entry
		ChanNo-=1	
		DescrList=RemoveListItem(0, DescrList)
	endif
	string ChanList=SP2_ChanListIncandOnly()
	string ChanPrefix=stringfromlist(ChanNo,ChanList)
	string ChanAbbrev=ChopLastCharacterOff(SP2_ChanListToAbbrevList(ChanPrefix),";")
	string OtherChanDescript
	variable pos1, pos2, pos3, pos4
	strswitch (ChanPrefix)
		case ksSP2BBHGprefix:
			OtherChanDescript=stringfromlist(whichlistitem(ksSP2NBHGprefix,ChanList),DescrList)
			pos1=433.5
			pos2=38.75
			pos3=947.25
			pos4=370.25
			setdatafolder $CalibFldrFP
			wave FromOtherChan_FitPkHt_1e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix1e
			wave FromOtherChan_FitPkHt_2e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix2e
			wave FromOtherChan_FitPkHt_3e=$ksSP2calibBBHGfromNBHGfitPkHt+ksSP2suffix3e
			break
		case ksSP2NBHGprefix:
			OtherChanDescript=stringfromlist(whichlistitem(ksSP2BBHGprefix,ChanList),DescrList)
			pos1=432.75
			pos2=378.5
			pos3=946.5
			pos4=710
			setdatafolder $CalibFldrFP
			wave FromOtherChan_FitPkHt_1e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix1e
			wave FromOtherChan_FitPkHt_2e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix2e
			wave FromOtherChan_FitPkHt_3e=$ksSP2calibNBHGfromBBHGfitPkHt+ksSP2suffix3e
			break
		case ksSP2BBLGprefix:
			OtherChanDescript=stringfromlist(whichlistitem(ksSP2NBLGprefix,ChanList),DescrList)
			pos1=3.75
			pos2=40.25
			pos3=517.5
			pos4=371.75
			setdatafolder $CalibFldrFP
			wave FromOtherChan_FitPkHt_1e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix1e
			wave FromOtherChan_FitPkHt_2e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix2e
			wave FromOtherChan_FitPkHt_3e=$ksSP2calibBBLGfromNBLGfitPkHt+ksSP2suffix3e
			break
		case ksSP2NBLGprefix:
			OtherChanDescript=stringfromlist(whichlistitem(ksSP2BBLGprefix,ChanList),DescrList)
			pos1=3.75
			pos2=379.25
			pos3=517.5
			pos4=710.75
			setdatafolder $CalibFldrFP
			wave FromOtherChan_FitPkHt_1e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix1e
			wave FromOtherChan_FitPkHt_2e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix2e
			wave FromOtherChan_FitPkHt_3e=$ksSP2calibNBLGfromBBLGfitPkHt+ksSP2suffix3e
			break
		default:
			setdatafolder $savedDF
			message="Undefined value of the string 'ChanPrefix' in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch
	//access waves
	setdatafolder $CalibFldrFP
	wave /Z MassList_1e=$ksSP2calibMassList+ksSP2suffix1e
	wave /Z FitPkHt_1e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
	wave /Z MassList_2e=$ksSP2calibMassList+ksSP2suffix2e
	wave /Z FitPkHt_2e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix2e
	wave /Z MassList_3e=$ksSP2calibMassList+ksSP2suffix3e
	wave /Z FitPkHt_3e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix3e
	wave /Z SplineCalCurve=$ChanPrefix+ksSP2calibSplineCalCurve
	//do not proceed if waves are not available
	if ( !waveexists(MassList_1e) || !waveexists(FitPkHt_1e) )
		setdatafolder $savedDF
		return 0
	endif
	//create graph
		//preparations
		string ModeList="", ColourList="", MarkerList="", MsizeList="", TraceNam
		string Legendstr=ChanDescr+":"
		//append traces
		Display /W=(pos1, pos2, pos3, pos4) as ChanAbbrev+"_CalCurveMeas"
		if ( waveexists(SplineCalCurve) )
			AppendToGraph SplineCalCurve
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") fitted spline"
			ModeList+="0;"
			ColourList+="3;"
			MarkerList+="0;"
			MsizeList+="0;"
		endif
		if ( waveexists(MassList_1e) && waveexists(FitPkHt_1e) )
			AppendToGraph MassList_1e vs FitPkHt_1e
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") single charge"
			ModeList+="3;"
			ColourList+="0;"
			MarkerList+="19;"
			MsizeList+="3;"
			
			// v4111 -- residuals too.  Not yet generalized to this function
			wave /Z resids= $ChanPrefix + "_MassList_1e_FitResid" // v4111a -- eventually shuold go into SP2 Constants ipf
			if (waveExists(resids))
				AppendToGraph /L=Res_Left resids vs FitPkHt_1e 
				// as for CurveFit dialog:
				Label Res_Left "Fit residuals [fg]"
				ModifyGraph axisEnab(left)={0,0.75},axisEnab(Res_Left)={0.8,1}
				ModifyGraph freePos(Res_Left)={0,bottom}, lblPosMode(Res_Left)=1, lblMargin(Res_Left)=10
				// same as data:
					ModeList+="3;"
					ColourList+="0;"
					MarkerList+="19;"
					MsizeList+="3;"
			endif			
		endif
		if ( waveexists(MassList_2e) && waveexists(FitPkHt_2e) )
			AppendToGraph MassList_2e vs FitPkHt_2e
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") double charge"
			ModeList+="3;"
			ColourList+="1;"
			MarkerList+="11;"
			MsizeList+="4;"
		endif
		if ( waveexists(MassList_3e) && waveexists(FitPkHt_3e) )
			AppendToGraph MassList_3e vs FitPkHt_3e
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") triple charge"
			ModeList+="3;"
			ColourList+="2;"
			MarkerList+="40;"
			MsizeList+="5;"
		endif
		Legendstr+="\r\rinferred from "+OtherChanDescript+":"
		if ( waveexists(MassList_1e) && waveexists(FromOtherChan_FitPkHt_1e) )
			AppendToGraph MassList_1e vs FromOtherChan_FitPkHt_1e
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") single charge"
			ModeList+="3;"
			ColourList+="0;"
			MarkerList+="1;"
			MsizeList+="3;"
		endif
		if ( waveexists(MassList_2e) && waveexists(FromOtherChan_FitPkHt_2e) )
			AppendToGraph MassList_2e vs FromOtherChan_FitPkHt_2e
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") double charge"
			ModeList+="3;"
			ColourList+="1;"
			MarkerList+="1;"
			MsizeList+="3;"
		endif
		if ( waveexists(MassList_3e) && waveexists(FromOtherChan_FitPkHt_3e) )
			AppendToGraph MassList_3e vs FromOtherChan_FitPkHt_3e		
			TraceNam=laststringfromlist(TraceNameList("",";",1))
			LegendStr+="\r\\s("+TraceNam+") triple charge"
			ModeList+="3;"
			ColourList+="2;"
			MarkerList+="1;"
			MsizeList+="3;"
		endif
		
		
		//general formatting
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Particle mass [fg]"
		Label bottom "Incendescence peak height [d.u.]"
		SetAxis/A=2/E=1
		//traces specific formatting
		ModifyGraph lsize=2
		ModifyGraphColouriseList(ColourList, 0)
		ModifyGraphModeList(modelist)
		ModifyGraphMarkerList(markerlist)
		ModifyGraphMsizeList(MsizeList)
		//legend
		Legend/C/N=text0/J/X=59.93/Y=2.72 LegendStr
	//finish procedure
	setdatafolder $savedDF
	return 0
End




Function SP2_CalibBCAnalyzerSlider([ChanDescr, GraphIDstr, CalibSummaryFP, Omode])
	//This function creates a slider graph needed for the analysis of calibration data.
	//martin.gysel@psi.ch; 28/01/2009; 26/08/2009; 05/10/2009; 05/05/2010
	string ChanDescr			//ChanDescr description
							//must be an element out of the list ksSP2incandShortDescriptList
							//default: prompt				
	string GraphIDstr			//ID string used for name of slider graph
							//default: channel prefix+"CalibSlider"
	string CalibSummaryFP	//folder containing the calibration summary
							//default: current datafolder
	variable Omode			//0 (default):	prompt if graph/folder with given GraphIDstr does already exist
							//1:			overwrite existing graph

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values
	string DescrList=SP2_ChanListToDescrShortList(SP2_ChanListIncandOnly())
	if (paramisdefault(ChanDescr))
		ChanDescr=stringfromlist(0,DescrList)
		prompt ChanDescr, "Select incandescence channel:",popup, DescrList
		doprompt "ChanDescr", ChanDescr
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure!"
			print message; print RTStackInfo; abort message
		endif
	endif
	variable ChanNo=whichlistitem(ChanDescr,DescrList)
	if (ChanNo==-1)
		setdatafolder $savedDF
		message="Undefined value of the parameter 'ChanDescr' handed over to the function "+currproc+"!"
		print message; print RTStackInfo; abort message	
	endif
	string ChanPrefix=stringfromlist(ChanNo,SP2_ChanListIncandOnly())
	if (paramisdefault(GraphIDstr))
		GraphIDstr=ChanPrefix+"CalibrationSlider"
	endif
	if (paramisdefault(CalibSummaryFP))
		CalibSummaryFP=savedDF
	endif
	if (paramisdefault(Omode))
		Omode=0
	elseif (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	setdatafolder $CalibSummaryFP
	Svar CalibInfoFldrFP=$ksSP2calibDMACPCfldrFP
	//show table corresponding to graph
	SP2table_CalibIncandFitPkHt(CalibSummaryFldrFP=CalibSummaryFP, ChanBit=SP2chanPrefix2chanProperty(ChanPrefix, 0))
	//prepare slider	
	string YMatL=ChanPrefix+ksSP2calibHistoMat+";"+ChanPrefix+ksSP2calibHistoMatFitted
	CalibInfoFldrFP=ChopLastCharacterOff(CalibInfoFldrFP,":")
	string TimeRunPath=CalibInfoFldrFP+ksSP2_monodi_TimeCentreList
	string TimeRunType="time"
	
	//create slider graph
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=CalibSummaryFP, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	//graph window size
	strswitch (ChanPrefix)
		case ksSP2BBHGprefix:
			MoveWindow 21,387.5,528,712.25
			break
		case ksSP2NBHGprefix:
			MoveWindow 19.5,45.5,526.5,370.25
			break
		case ksSP2BBLGprefix:
			MoveWindow 435,386.75,942,711.5
			break
		case ksSP2NBLGprefix:
			MoveWindow 429,46.25,936,371
			break
		default:
			setdatafolder $savedDF
			message="Undefined value of the string 'ChanPrefix' in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch
	
	//format graph
	ModifyGraph lstyle=0
	ModifyGraph lsize(Ywave0)=2
	ModifyGraph lsize(Ywave1)=1
	ModifyGraph rgb(Ywave1)=(0,0,52224)
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Frequency [-]"
	Label bottom "Logarithm of "+ChanDescr+" peak height"
	Legend/C/N=text0/J/A=MC/X=22.13/Y=29.51 "\\s(Ywave0) histogram\r\\s(Ywave1) fit"
	TextBox/C/N=text1/A=MC/X=-35.07/Y=38.93 ChanDescr+" channel"
	//control bar
	ControlBar 80
	Button $"GetPeak1e"+GraphIDstr,pos={9,53},size={150,20},proc=SP2_CalibGraphGetPeakButt,title="get 1e peak from cursor A",font=arial,fSize=11	
	Button $"GetPeak2e"+GraphIDstr,pos={169,53},size={150,20},proc=SP2_CalibGraphGetPeakButt,title="get 2e peak from cursor B",font=arial,fSize=11	
	Button $"GetPeak3e"+GraphIDstr,pos={329,53},size={150,20},proc=SP2_CalibGraphGetPeakButt,title="get 3e peak from cursor C",font=arial,fSize=11	
	ShowInfo	
	//show info
	//optional slider proc
	setdatafolder $MSSfldrpath
	Svar OptionalCurrPtCmd
	OptionalCurrPtCmd="SP2_CalibBCGraphOptProc(\""+MSSfldrpath+"\")"
	execute "SP2_CalibBCGraphOptProc(\""+MSSfldrpath+"\")"		//invoke it for the first time
	//finish procedure
	setdatafolder $savedDF
	return 0
end


function SP2_CalibGraphGetPeakButt(ctrlname) : ButtonControl
	//martin.gysel@psi.ch; 23/09/2009, 05/05/2010
	string ctrlname
	string savedDF=getdatafolder(1)
	//get path for folder containing slider graph data
	Variable SuffixIndex
	SuffixIndex=strsearch(ctrlName, "_", inf  , 1)
	String GraphIDstr=ctrlName[SuffixIndex, inf]
	String GraphFolderPath=ksPathToMatSupSliderParentFldr+GraphIDstr[1,inf]
	//access slider graph data
	setdatafolder $GraphFolderPath
	Svar RefPathStr
	Svar YMatList
	Nvar CurrPoint
	//prefix of data channel
	string chanprefix=stringfromlist(0,stringfromlist(0,YMatList),"_")+"_"
	//number of charges
	string chargesuffix, CursorName
	if (stringmatch(ctrlname, "*1e*"))
		chargesuffix=ksSP2suffix1e
		CursorName="A"
	elseif (stringmatch(ctrlname, "*2e*"))
		chargesuffix=ksSP2suffix2e
		CursorName="B"
	elseif (stringmatch(ctrlname, "*3e*"))
		chargesuffix=ksSP2suffix3e
		CursorName="C"
	else
		//inconsistent code
		return 0
	endif
	//access data in calibration summary folder corresponding to this slider graph
	setdatafolder $RefPathStr
	wave FitPkHt=$chanprefix+ksSP2calibFitPkHt+chargesuffix
	//get peak height from cursor position and write it to peak height wave
	FitPkHt[CurrPoint]=10^xcsr($CursorName)
	//finish procedure
	setdatafolder savedDF
	return 0
end


function SP2_CalibBCGraphOptProc(GraphFolderFPath)
	//This function is a template for an optional procedure associated with a "matrix super slider" graph
	//martin.gysel@psi.ch; 24/09/2009, 05/05/2010;
	string GraphFolderFPath	//full path to slider graph folder
	string DataWaveFPath		//full path to DataWave of which the value corresponding to the current data entry is to be displayed
	
	string savedDF=getdatafolder(1)
	//access data in matrix slider folder
	setdatafolder $GraphFolderFPath
	Svar RefPathStr
	Svar YMatList
	Nvar CurrPoint
	//prefix of data channel
	string chanprefix=stringfromlist(0,stringfromlist(0,YMatList),"_")+"_"
	//access source data of this slider graph
	setdatafolder $RefPathStr
	wave FitPkHt_1e=$chanprefix+ksSP2calibFitPkHt+ksSP2suffix1e
	wave FitPkHt_2e=$chanprefix+ksSP2calibFitPkHt+ksSP2suffix2e
	wave FitPkHt_3e=$chanprefix+ksSP2calibFitPkHt+ksSP2suffix3e
	//place cursors according to previously set "FitPkHt"
		variable Xval, PtIndex
		//1e
		Xval=NanToValue(log(FitPkHt_1e[currPoint]),1)
		Cursor /A=1 A  Ywave0  Xval
		//2e
		Xval=NanToValue(log(FitPkHt_2e[currPoint]),2)
		Cursor /A=1 B  Ywave0  Xval
		//3e
		Xval=NanToValue(log(FitPkHt_3e[currPoint]),3)
		Cursor /A=1 C  Ywave0  Xval
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2graph_BandRatioCalibResults([CalibFldrFP]) : Graph
	//This function creates a graph showing the bandratio calibration results
	//martin.gysel@psi.ch; 03/02/2009; 06/05/2010
	string CalibFldrFP	//full path to the data folder containing the calibration results
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibFldrFP))
		CalibFldrFP=savedDF
	endif
	CalibFldrFP=ChopLastCharacterOff(CalibFldrFP,":")
	//various strings
	string tracelist, nam0, nam1, nam2
	//high gain
		//access waves
		setdatafolder $CalibFldrFP
		wave BandRatHG_1e=$ksSP2calibBandRatHG+ksSP2suffix1e
		wave BBHG_FitPkHt_1e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
		wave BandRatHG_2e=$ksSP2calibBandRatHG+ksSP2suffix2e
		wave BBHG_FitPkHt_2e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
		wave BandRatHG_3e=$ksSP2calibBandRatHG+ksSP2suffix3e
		wave BBHG_FitPkHt_3e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
		//create graph
		if (waveexists(BandRatHG_1e) && waveexists(BBHG_FitPkHt_1e))
			setdatafolder $CalibFldrFP
			Display /W=(36,48.5,538.5,365) BandRatHG_1e vs BBHG_FitPkHt_1e as "Bandratio_calib_graph_highgain"
			AppendToGraph BandRatHG_2e vs BBHG_FitPkHt_2e
			AppendToGraph BandRatHG_3e vs BBHG_FitPkHt_3e
			//get trace names
			tracelist=TraceNameList("",";",1)
			nam0=stringfromlist(0, tracelist)
			nam1=stringfromlist(1, tracelist)
			nam2=stringfromlist(2, tracelist)
			//format graph
			ModifyGraph mode=3
			ModifyGraph marker($nam0)=19,marker($nam1)=17,marker($nam2)=16
			ModifyGraph rgb($nam0)=(65280,0,0),rgb($nam1)=(0,0,65280),rgb($nam2)=(0,52224,0)
			ModifyGraph grid=1
			ModifyGraph log(bottom)=1
			ModifyGraph mirror=2
			ModifyGraph nticks=10
			ModifyGraph standoff=0
			ModifyGraph gridRGB=(0,0,0)
			Label left "High gain bandratio (broadband : narrowband)  [-]"
			Label bottom "High gain broadband incandescence peak height [d.u.]"
			SetAxis/N=1 left 0,*
			SetAxis bottom 10,kSP2signalAmpMax
			Legend/C/N=text0/J/X=5.04/Y=35.75 "high gain bandratio:\r\\s("+nam0+") single charge\r\\s("+nam1+") double charge\r\\s("+nam2+") triple charge"
		endif
	//low gain
		//access waves
		setdatafolder $CalibFldrFP
		wave BandRatLG_1e=$ksSP2calibBandRatLG+ksSP2suffix1e
		wave BBLG_FitPkHt_1e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
		wave BandRatLG_2e=$ksSP2calibBandRatLG+ksSP2suffix2e
		wave BBLG_FitPkHt_2e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix2e
		wave BandRatLG_3e=$ksSP2calibBandRatLG+ksSP2suffix3e
		wave BBLG_FitPkHt_3e=$ksSP2BBLGprefix+ksSP2calibFitPkHt+ksSP2suffix3e
		//create graph
		if (waveexists(BandRatLG_1e) && waveexists(BBLG_FitPkHt_1e))
			setdatafolder $CalibFldrFP
			Display /W=(36.75,386.75,539.25,703.25) BandRatLG_1e vs BBLG_FitPkHt_1e as "Bandratio_calib_graph_lowgain"
			AppendToGraph BandRatLG_2e vs BBLG_FitPkHt_2e
			AppendToGraph BandRatLG_3e vs BBLG_FitPkHt_3e
			//get trace names
			tracelist=TraceNameList("",";",1)
			nam0=stringfromlist(0, tracelist)
			nam1=stringfromlist(1, tracelist)
			nam2=stringfromlist(2, tracelist)
			//format graph
			ModifyGraph mode=3
			ModifyGraph marker($nam0)=19,marker($nam1)=17,marker($nam2)=16
			ModifyGraph rgb($nam0)=(65280,0,0),rgb($nam1)=(0,0,65280),rgb($nam2)=(0,52224,0)
			ModifyGraph grid=1
			ModifyGraph log(bottom)=1
			ModifyGraph mirror=2
			ModifyGraph nticks=10
			ModifyGraph standoff=0
			ModifyGraph gridRGB=(0,0,0)
			Label left "Low gain bandratio (broadband : narrowband)  [-]"
			Label bottom "Low gain broadband incandescence peak height [d.u.]"
			SetAxis/N=1 left 0,*
			SetAxis bottom 10,kSP2signalAmpMax
			Legend/C/N=text0/J/X=5.04/Y=35.75 "low gain bandratio:\r\\s("+nam0+") single charge\r\\s("+nam1+") double charge\r\\s("+nam2+") triple charge"
		endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2graph_CountEffCalibResults([CalibFldrFP]) : Graph
	//This function creates a graph showing the counting efficiency calibration results
	//martin.gysel@psi.ch; 03/02/2009, 01/06/2010, 08/03/2012;
	string CalibFldrFP	//full path to the data folder containing the calibration results
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibFldrFP))
		CalibFldrFP=savedDF
	endif
	CalibFldrFP=ChopLastCharacterOff(CalibFldrFP,":")
	//access waves
	setdatafolder $CalibFldrFP
	wave BBHG_CountEff=$ksSP2BBHGprefix+ksSP2calibCountEff
	wave NBHG_CountEff=$ksSP2NBHGprefix+ksSP2calibCountEff
	wave MassList_1e=$ksSP2calibMassList+ksSP2suffix1e
	wave BBHG_FitPkHt_1e=$ksSP2BBHGprefix+ksSP2calibFitPkHt+ksSP2suffix1e
	string BBHG_CountEffNam=nameofwave(BBHG_CountEff)
	string NBHG_CountEffNam=nameofwave(NBHG_CountEff)
	string BBHG_FitPkHt_1eNam=nameofwave(BBHG_FitPkHt_1e)
	//preparations:
	string LegendStr
	//display counting efficiency against BC mass
		setdatafolder $CalibFldrFP
		LegendStr="Counting efficiency SP2/CPC:"
		Display /W=(336.75,116,785.25,372.5) as "Calib_CountingEff_vs_BCmass"
		if(waveexists(BBHG_CountEff))
			AppendToGraph BBHG_CountEff vs MassList_1e
			ModifyGraph marker($BBHG_CountEffNam)=8
			LegendStr+="\r\\s("+BBHG_CountEffNam+") broadband"
		endif
		if(waveexists(NBHG_CountEff))
			AppendToGraph NBHG_CountEff vs MassList_1e
			ModifyGraph rgb($NBHG_CountEffNam)=(0,0,65280)
			LegendStr+="\r\\s("+NBHG_CountEffNam+") narrowband"
		endif
		//format graph
		ModifyGraph mode=3
		ModifyGraph msize=4
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Counting efficiency SP2/CPC [-]"
		Label bottom "Particle mass (single charge) [fg]"
		SetAxis/A=2/E=1 left
		SetAxis/A/N=1 bottom
		Legend/C/N=text0/J/X=6.48/Y=9.26 LegendStr
	//display counting efficiency against BC mass
		setdatafolder $CalibFldrFP
		LegendStr="Counting efficiency SP2/CPC:"
		Display /W=(337.5,390.5,786,647) as "Calib_CountingEff_vs_BroadPkHt"
		if(waveexists(BBHG_CountEff))
			AppendToGraph BBHG_CountEff vs BBHG_FitPkHt_1e
			ModifyGraph marker($BBHG_CountEffNam)=8
			Legendstr+="\r\\s("+BBHG_CountEffNam+") broadband"
		endif
		if(waveexists(NBHG_CountEff))
			AppendToGraph NBHG_CountEff vs BBHG_FitPkHt_1e
			ModifyGraph rgb($NBHG_CountEffNam)=(0,0,65280)
			Legendstr+="\r\\s("+NBHG_CountEffNam+") narrowband"
		endif
		//format graph
		ModifyGraph mode=3
		ModifyGraph msize=4
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Counting efficiency SP2/CPC [-]"
		Label bottom "Broadband peak height (single charge) [d.u.]"
		SetAxis/A=2/E=1 left
		SetAxis/A/N=1 bottom
		Legend/C/N=text0/J/X=3.85/Y=30.00 LegendStr
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2graph_NumbSizeDistrBC([pbpfldrfp])
	//This function creates a graph showing the measured and fitted BC number size distribution.
	//martin.gysel@psi.ch; 18/02/2009, 06/11/2009; 04/05/2010, 07/01/2011
	string pbpfldrfp	//full path to the data folder containing the pbp data
					//default: current data folder
					
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	NVAR errorBarsFlag= $ksSP2PathToToolkitPanelFldr + ksSP2plotErrorBars


	//prepare graph
	Display /W=(141,92.75,627,374.75) as "BC number size distribution incl. fit"
	//channel definitions etc.
	string chanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind, DataAvailable
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10BC number size distribution:\r"
	//loop over all channels, append traces and prepare trace formatting lists
	DataAvailable=0
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $pbpfldrfp
		wave /z Meas_Diam=$currprefix+ksSP2pbpBCdistrDiamMid
		wave /z Meas_NumbDistr=$currprefix+ksSP2pbpBCnumbdistr
		wave /z Meas_NumbDistr_Err=$currprefix+ksSP2pbpBCnumbdistr+ksSP2errSuffix
		wave /z Fit_Diam=$currprefix+ksSP2pbpLogNormFitDiamMidpt
		wave /z Fit_NumbDistr=$currprefix+ksSP2pbpLogNormFitNumbDistr
		//append traces to graph
		if (waveexists(Meas_Diam) && waveexists(Meas_NumbDistr) )
			DataAvailable=1
			AppendToGraph Meas_NumbDistr vs Meas_Diam
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			if (waveExists(Meas_NumbDistr_Err) && errorBarsFlag)
				ErrorBars /T=0.5/L=0.5 $tracename, Y wave=(Meas_NumbDistr_Err, Meas_NumbDistr_Err)
			endif
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+" (measurement)\r"
		endif
		if (waveexists(Fit_Diam) && waveexists(Fit_NumbDistr) )
			DataAvailable=1
			AppendToGraph Fit_NumbDistr vs Fit_Diam
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="0;"
			LsizeList+="2;"
			LegendStr+="\\s("+tracename+") "+currDescr+" (lognormal fit)\r"
		endif
	endfor
	//format graph
		if (DataAvailable)
			//general
			ModifyGraph grid=1
			ModifyGraph log(bottom)=1
			ModifyGraph mirror=2
			ModifyGraph nticks=10
			ModifyGraph standoff=0
			ModifyGraph gridRGB=(0,0,0)
			Label left "Number size distribution of BC cores\rdN/dlogD\BMEV\M [1/cm\S3\M]"
			Label bottom "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
			SetAxis/A/N=1 left
			SetAxis/A/N=1 bottom
			//trace specific
			ModifyGraph marker=11
			ModifyGraphColouriseList(ColourList, 5)
			ModifyGraphModeList(ModeList)
			ModifyGraphLstyleList(LstyleList)
			ModifyGraphLsizeList(LsizeList)
			//Legends and text boxes
			LegendStr=ChopEndingOff(LegendStr,"\r")
			Legend/C/N=LegendNumb/J/A=MC/X=-23.69/Y=28.20 LegendStr
			TextBox/C/N=text1/A=MC/X=31.46/Y=42.62 pbpfldrfp
		else
//			dowindow /K kwTopWin
			textbox/N=SP2toolkitFailNote "Nothing to graph:\rData not found in folder " + getDataFolder(1)	// jcc -- don't silently fail, tell the user why!
		endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2graph_NumbSizeDistrScatt([pbpfldrfp])
	//This function creates a graph showing the measured number size distribution of scattering particles.
	//martin.gysel@psi.ch; 26/11/2010, 07/01/2011
	string pbpfldrfp	//full path to the data folder containing the pbp data
					//default: current data folder
					
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	
	// jcc :: warn user if they forgot to update the YAG power
	wave YAGpower=$(SP2_PBPfldrFP2RawFldrFP(pbpfldrfp) + ksSP2YAGpower)
	WaveStats /Q YAGpower
	variable YAGpanelIsDefault
	if (V_avg==kSP2YAGpowerPanelDefault)
		YAGpanelIsDefault=1
	endif

	//prepare graph
	Display /W=(57,287,543,569) as "Number size distribution of scattering particles"
	//channel definitions etc.
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListCombScattOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind, DataAvailable
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10Number size distribution of purely scattering particles:\r"
	//loop over all channels, append traces and prepare trace formatting lists
	DataAvailable=0
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $pbpfldrfp
		wave /Z Meas_Diam=$currprefix+ksSP2pbpOptdistrDiamMid
		wave /Z Meas_NumbDistr=$currprefix+ksSP2pbpOptNumbDistr
		//append traces to graph
		if (waveexists(Meas_Diam) && waveexists(Meas_NumbDistr) )
			DataAvailable=1
			AppendToGraph Meas_NumbDistr vs Meas_Diam
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+"\r"
		endif
	endfor
	//format graph
		if (DataAvailable)
			//general
			ModifyGraph grid=1
			ModifyGraph log(bottom)=1
			ModifyGraph mirror=2
			ModifyGraph nticks=10
			ModifyGraph standoff=0
			ModifyGraph gridRGB=(0,0,0)
			Label left "Number size distribution of purely scattering particles\rdN/dlogD\Bopt\M [1/cm\\S3\\M]"
			Label bottom "Optical particle diameter, D\Bopt\M [nm]"
			SetAxis/A/N=1 left
			SetAxis/A/N=1 bottom
			//trace specific
			ModifyGraph marker=11
			ModifyGraphColouriseList(ColourList, 5)
			ModifyGraphModeList(ModeList)
			ModifyGraphLstyleList(LstyleList)
			ModifyGraphLsizeList(LsizeList)
			//Legends and text boxes
			LegendStr=ChopEndingOff(LegendStr,"\r")
			Legend/C/N=LegendNumb/J/A=MC/X=-17.69/Y=35.10 LegendStr
			TextBox/C/N=text1/A=MC/X=31.46/Y=42.62 pbpfldrfp
			
			if (YAGpanelIsDefault) 
				string yagmsg= " \"YAG power\" on the toolkit's Load tab needs updating \\sa+05\\sb+05"
				TextBox/C/N=yagprob/F=0/B=(39168,0,0)/G=(65280,16384,16384)/A=RB yagmsg
			endif
		else
//			dowindow /K kwTopWin
			textbox/N=SP2toolkitFailNote "Nothing to graph:\rData not found in folder " + getDataFolder(1)	// jcc -- don't silently fail, tell the user why!
		endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2graph_MassSizeDistrBC([pbpfldrfp])
	//This function creates a graph showing the measured and fitted BC mass size distribution.
	//martin.gysel@psi.ch; 18/02/2009, 06/11/2009; 04/05/2010, 07/01/2011
	string pbpfldrfp	//full path to the data folder containing the pbp data
					//default: current data folder
					
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	NVAR errorBarsFlag= $ksSP2PathToToolkitPanelFldr + ksSP2plotErrorBars

	//prepare graph
	Display /W=(139.5,395.75,625.5,677.75) as "BC mass size distribution incl. fit"
	//channel definitions etc.
	string chanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind, DataAvailable
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10BC mass size distribution:\r"
	//loop over all channels, append traces and prepare trace formatting lists
	DataAvailable=0
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $pbpfldrfp
		wave /z Meas_Diam=$currprefix+ksSP2pbpBCdistrDiamMid
		wave /z Meas_MassDistr=$currprefix+ksSP2pbpBCmassdistr
		wave /z Meas_MassDistr_Err=$currprefix+ksSP2pbpBCmassdistr+ksSP2errSuffix
		wave /z Fit_Diam=$currprefix+ksSP2pbpLogNormFitDiamMidpt
		wave /z Fit_MassDistr=$currprefix+ksSP2pbpLogNormFitMassDistr
		//append traces to graph
		if (waveexists(Meas_Diam) && waveexists(Meas_MassDistr) )
			DataAvailable=1
			AppendToGraph Meas_MassDistr vs Meas_Diam
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			if (waveExists(Meas_MassDistr_Err) && errorBarsFlag)
				ErrorBars /T=0.5/L=0.5 $tracename, Y wave=(Meas_MassDistr_Err, Meas_MassDistr_Err)
			endif
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+" (measurement)\r"
		endif
		if (waveexists(Fit_Diam) && waveexists(Fit_MassDistr) )
			DataAvailable=1
			AppendToGraph Fit_MassDistr vs Fit_Diam
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="0;"
			LsizeList+="2;"
			LegendStr+="\\s("+tracename+") "+currDescr+" (lognormal fit)\r"
		endif
	endfor
	//format graph
		if(DataAvailable)
			//general
			ModifyGraph grid=1
			ModifyGraph log(bottom)=1
			ModifyGraph mirror=2
			ModifyGraph nticks=10
			ModifyGraph standoff=0
			ModifyGraph gridRGB=(0,0,0)
			Label left "Mass size distribution of BC cores\rdM/dlogD\BMEV\M [g m\S-3\M]"
			Label bottom "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
			SetAxis/A/N=1 left
			SetAxis/A/N=1 bottom
			//trace specific
			ModifyGraph marker=11
			ModifyGraphColouriseList(ColourList, 5)
			ModifyGraphModeList(ModeList)
			ModifyGraphLstyleList(LstyleList)
			ModifyGraphLsizeList(LsizeList)
			//Legends and text boxes
			LegendStr=ChopEndingOff(LegendStr,"\r")
			Legend/C/N=LegendNumb/J/A=MC/X=-23.69/Y=28.20 LegendStr
			TextBox/C/N=text1/A=MC/X=31.46/Y=42.62 pbpfldrfp
		else
//			dowindow /K kwTopWin
			// jcc -- don't silently fail, tell the user why!
			textbox "Nothing to graph:\rData not found in folder " + getDataFolder(1)
		endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End






Function SP2_LEOgr_FWHMandSplitPt([LeoBeamCalibSubFldrFP])
	//This function displays a graph showing a time series of the beam FWHM and the split time as derived from all pure scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/06/2009, 17/05/2010, 23/02/2011
	string LeoBeamCalibSubFldrFP	//full path to folder containing the beam FWHM and split point data
		//	string LEOfldrfp	//full path to folder containing the LEO-fit data
		//					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LeoBeamCalibSubFldrFP))
		LeoBeamCalibSubFldrFP=SP2_getBeamShapeFolder() 
	endif
	LeoBeamCalibSubFldrFP=choplastcharacteroff(LeoBeamCalibSubFldrFP, ":")
	LeoBeamCalibSubFldrFP=replacestring("'BeamAndCalib'",LeoBeamCalibSubFldrFP,"BeamAndCalib")
	string LEOfldrfp=replacestring(ksSP2LEObeamDataSubFldrPP,LeoBeamCalibSubFldrFP,"")
	string RawFldrFP=SP2_PBPfldrFP2RawFldrFP(SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp))
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//raw data
		setdatafolder $RawFldrFP
		wave TimeDate=$ksSP2TimeDate
		//LEO-fit data
			//beam and calibration data subfolder
			setdatafolder $LeoBeamCalibSubFldrFP
			wave LEObeamFWHM=$ksSP2LEObeamFWHMpureScatt	
			string wnam0=nameofwave(LEObeamFWHM)
			wave LEOfitBeamFWHM=$ksSP2LEOfitBeamFWHM		
			string wnam1=nameofwave(LEOfitBeamFWHM)
			wave LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt			
			string wnam2=nameofwave(LEOsplit2centreDelta)
			wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
			string wnam3=nameofwave(LEOfitSplit2centreDelta)
	//create graph
	Display /W=(81,62,708.75,604.25) as "LEO_BeamFWHM_and_SplitTime_graph"
	AppendToGraph/L=leftFWHM LEObeamFWHM vs TimeDate
	AppendToGraph/L=leftFWHM LEOfitBeamFWHM vs TimeDate
	AppendToGraph/L=leftTimeDiff LEOsplit2centreDelta vs TimeDate
	AppendToGraph/L=leftTimeDiff LEOfitSplit2centreDelta vs TimeDate
	//format graph
	ModifyGraph margin(left)=71
	ModifyGraph mode($wnam0)=2,mode($wnam2)=2
	ModifyGraph marker($wnam0)=19
	ModifyGraph lSize=2
	ModifyGraph rgb($wnam1)=(0,0,0),rgb($wnam2)=(0,0,65280),rgb($wnam3)=(0,0,0)
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph fSize=12
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph lblPos(leftFWHM)=60,lblPos(leftTimeDiff)=60
	ModifyGraph freePos(leftFWHM)=0
	ModifyGraph freePos(leftTimeDiff)=0
	ModifyGraph axisEnab(leftFWHM)={0.52,1}
	ModifyGraph axisEnab(leftTimeDiff)={0,0.48}
	ModifyGraph dateInfo(bottom)={0,0,-1},dateFormat(bottom)={Default,1,2,2,2,"DayOfMonth/Month/Year",6}
	Label leftFWHM "Laser beam FWHM ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "Date  [DD/MM/YY hh:mm:ss]"
	Label leftTimeDiff "Split point to beam centre delay ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	SetAxis/A/N=1 leftFWHM
	SetAxis/A/N=1 bottom
	Legend/C/N=text0/J/A=MC/X=-33.48/Y=22.79 "\\Z12\rBeam FWHM:\r\\s("+wnam0+") all pure scattering particles\r\\s("+wnam1+") values used for LEO-fit"
	Legend/C/N=text1/J/A=MC/X=-32.20/Y=-16.05 "\\Z12\rSplit point to beam centre delay:\r\\s("+wnam2+") all pure scattering particles"
	AppendText "\\s("+wnam3+") values used for LEO-fit"
	TextBox/C/N=text2/A=MC/X=27.94/Y=46.71 LeoBeamCalibSubFldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2_LEOgr_SplitDeltaVsSCHGpkht([LEOfldrfp])
	//This function displays a graph showing the split to centre delay of all pure scattering particles versus the scattering peak height
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/06/2009, 17/05/2010
	string LEOfldrfp	//full path to folder containing the LEO-fit data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LEOfldrfp))
		LEOfldrfp=SP2_getLEOfolder()
	endif
	LEOfldrfp=removeEnding(leofldrfp,":")
	//data folders
	string LeoBeamCalibSubFldrFP=LEOfldrfp+ksSP2LEObeamDataSubFldrPP
	string PBPfldrfp=SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//LEO beam and calibration data subfolder
		setdatafolder $LeoBeamCalibSubFldrFP
		wave LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt
		string wnam0=nameofwave(LEOsplit2centreDelta)		
		wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
		string wnam1=nameofwave(LEOfitSplit2centreDelta)		
		//PBP folder
		setdatafolder $PBPfldrfp
		wave SCHG_GaussPeakHt=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakHeight			
		wave SPHG_NegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
	//create graph
	Display /W=(378,155.75,885,458) as "LEO_splitDelta_vs_SCHGpeakHt"
	AppendToGraph LEOsplit2centreDelta vs SCHG_GaussPeakHt
	AppendToGraph LEOfitSplit2centreDelta vs SCHG_GaussPeakHt
	//format graph
	ModifyGraph mode($wnam0)=2
	ModifyGraph lSize=2
	ModifyGraph rgb($wnam1)=(0,0,0)
	ModifyGraph zColor($wnam0)={SPHG_NegPeakHt,-500,0,Rainbow}
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Split to centre time difference ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "Scattering channel peak height [d.u.]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	Cursor/P A $wnam0 15362
	ColorScale/C/N=text0/A=RT/X=1.90/Y=20.90 trace=$wnam0
	AppendText "Neg. Split Peak Ht"
	Legend/C/N=text1/J/X=0.34/Y=1.79 "Time difference between split point and beam centre:\r\\s("+wnam0+") all pure scattering particles"
	AppendText "\\s("+wnam1+") values used for LEO-fits"
	TextBox/C/N=text2/A=MC/X=-1.70/Y=-39.40 LEOfldrfp
	//finish procedure
	setdatafolder $savedDF
	return 0
End

	
Function SP2_LEOgr_SplitVsSCHGbeamPos([LEOfldrfp])
	//This function displays a graph showing the beam position derived from the split detector against the beam position obtained from pure scattering particles.
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/06/2009, 17/05/2010
	string LEOfldrfp	//full path to folder containing the LEO-fit data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LEOfldrfp))
		LEOfldrfp=SP2_getLEOfolder()
	endif
	//data folders
	LEOfldrfp=choplastcharacteroff(LEOfldrfp, ":")
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	string PBPfldrFP=SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//LEO trace fit subfolder
		setdatafolder $LeoTraceFitSubFldrFP
		wave LEOfitBeamPos=$ksSP2LEOfitBeamPos		
		string wnam0=nameofwave(LEOfitBeamPos)
		//LEO beam and calibration data subfolder
		setdatafolder $LeoBeamCalibSubFldrFP
		wave LEObeamPos=$ksSP2LEObeamPosPureScatt			
		string wnam1=nameofwave(LEObeamPos)
		//PBP data
		setdatafolder $PBPfldrFP
		wave SCHG_GaussPeakHt=$ksSP2SCHGprefix+ksSP2PBPscattGausspeakHeight			
		string wnam2=nameofwave(SCHG_GaussPeakHt)
	//create graph
	Display /W=(338.25,172.25,732.75,430.25) as "LEO_SplitBeamPos_v_ScattBeamPos"
	AppendToGraph LEOfitBeamPos vs LEObeamPos
	//format graph
	ModifyGraph mode=2
	ModifyGraph lSize=2
	ModifyGraph zColor($wnam0)={$wnam2,*,*,Rainbow}
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Beam position derived from split detector ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "Beam position derived from pure scattering particles ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	ColorScale/C/N=text0/A=RT/X=29.53/Y=2.90 trace=$wnam0
	AppendText "scattering peak height"
	TextBox/C/N=text2/A=MC/X=-23.27/Y=44.44 LEOfldrfp
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 0,0,300,300
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_VerificationAllChan([PBPfldrFP])
	//This function calls the graph functions showing LEO-fit verification scatter plots for all available channels
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/06/2009, 17/05/2010, 26/05/2010, 12/09/2010, 20/12/2011, 23/12/2011, 13/02/2012
	string PBPfldrFP		//full path to folder containing the PBP data
						//default: current data folder


	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	if (paramisdefault(PBPfldrFP))
		PBPfldrFP=SP2_getFolder(type="PBP")
	endif
	//data folders
	PBPfldrFP=ChopLastCharacterOff(PBPfldrFP,":")
	string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(PBPfldrFP)
	string LeoTraceFitSubFldrFP=leofldrfp+ksSP2LEOtraceFitSubFldrPP
	//channel list
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nChans=itemsinlist(chanlist)
	//loop over all channels
	string CurrLEOprefix, CurrRefPrefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		CurrLEOprefix=stringfromlist(chanind, chanlist)
		//get calibration reference channel
		CurrRefPrefix=SP2_LEO_RetrieveRefChanPrefix(CurrLEOprefix, LeoTraceFitSubFldrFP)
		//create LEO verification graph
		SP2_LEOgr_Verification1Chan(CurrLEOprefix, CurrRefPrefix, PBPfldrFP=PBPfldrFP)
	endfor
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End

Function SP2_LEOgr_Verification1Chan(LEOchanPrefix, RefChanPrefix, [PBPfldrFP])
	//This function displays a graph showing LEO-fit scattering peak heights versus the scattering peak heights of pure scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/06/2009, 17/05/2010, 26/05/2010, 12/09/2010, 20/12/2011, 21/12/2011, 05/01/2012
	string LEOchanPrefix		//prefix of LEO-fit channel which is to be verified
						//e.g: ksSP2SCHGprefix, ":SCHG_", ksSP2SPHGprefix, or ":SPHG_"
	string RefChanPrefix	//prefix of reference channel against which the verification is to be done
						//e.g.: ksSP2SCHGprefix or ":SCHG_"
	string PBPfldrFP		//full path to folder containing the PBP data
						//default: browse for folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(pbpfldrfp))
		PBPfldrFP=SP2_getFolder(type="PBP")
	endif
	//data folders
	PBPfldrFP=ChopLastCharacterOff(PBPfldrFP,":")
	string LEOfldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
	string LeoTraceFitSubFldrFP=LEOfldrfp+ksSP2LEOtraceFitSubFldrPP
	string LeoBeamCalibSubFldrFP=LEOfldrfp+ksSP2LEObeamDataSubFldrPP
	//various:
	string Chan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(LEOchanPrefix),"")
	string RefChan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(RefChanPrefix),"")
	variable IsSplitChannel=stringmatch(SP2_ChanListSplitOnly(), "*"+LEOchanPrefix+";*" )
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//PBP data
		setdatafolder $PBPfldrFP
		wave RefChan_GaussPeakHt=$RefChanPrefix+ksSP2PBPscattGausspeakHeight			
		string wnam0=nameofwave(RefChan_GaussPeakHt)
		wave RefChan_GaussPeakFWHM=$RefChanPrefix+ksSP2PBPscattGausspeakFWHM		
		string wnam1=nameofwave(RefChan_GaussPeakFWHM)
		//LEO-fit data (trace fit subfolder)
		setdatafolder $LeoTraceFitSubFldrFP
		wave /Z LEOfitPeakHtScatt=$LEOchanPrefix+ksSP2LEOfitPeakHtScattBnam			
		string wnam2=nameofwave(LEOfitPeakHtScatt)
		wave /Z PerfomStatsPerc10=$LEOchanPrefix+ksSP2LEOperfomStatsPerc10
		wave /Z PerfomStatsPerc10_Xctr=$LEOchanPrefix+ksSP2LEOperfomStatsPerc10+"_Xctr"
		wave /Z PerfomStatsPerc25=$LEOchanPrefix+ksSP2LEOperfomStatsPerc25
		wave /Z PerfomStatsPerc25_Xctr=$LEOchanPrefix+ksSP2LEOperfomStatsPerc25+"_Xctr"
		wave /Z PerfomStatsPerc50=$LEOchanPrefix+ksSP2LEOperfomStatsPerc50
		wave /Z PerfomStatsPerc50_Xctr=$LEOchanPrefix+ksSP2LEOperfomStatsPerc50+"_Xctr"
		wave /Z PerfomStatsPerc75=$LEOchanPrefix+ksSP2LEOperfomStatsPerc75
		wave /Z PerfomStatsPerc75_Xctr=$LEOchanPrefix+ksSP2LEOperfomStatsPerc75+"_Xctr"
		wave /Z PerfomStatsPerc90=$LEOchanPrefix+ksSP2LEOperfomStatsPerc90
		wave /Z PerfomStatsPerc90_Xctr=$LEOchanPrefix+ksSP2LEOperfomStatsPerc90+"_Xctr"
	//preparations
	string LegendStr="Channel used for LEO-fit: "+Chan_Abbrev
	variable ColScaleMin=0, ColScaleMax=100
	//graph
	if (waveexists(LEOfitPeakHtScatt))
		//prepare graph window		
		Display /W=(310.5,236.75,884.25,668) as "LEO_verification_"+Chan_Abbrev+"_vs_"+RefChan_Abbrev
		//some default formatting
		ModifyGraph mode=0
		ModifyGraph lStyle=0
		ModifyGraph lSize=1
		//Append traces
		AppendToGraph  LEOfitPeakHtScatt vs RefChan_GaussPeakHt
		LegendStr+="\r\\s("+wnam2+") scattering peak height"
		ModifyGraph mode($wnam2)=2
		ModifyGraph lSize($wnam2)=2
		ModifyGraph zColor($wnam2)={RefChan_GaussPeakFWHM,ColScaleMin,ColScaleMax,Rainbow}
		ColorScale/C/N=colscale0/A=RT/X=2.97/Y=18.59 trace=$wnam2, fsize=10
		AppendText "Color scale: FWHM of scattering peak [*"+num2str(1/SamplingRateRawDataMHz)+" s]"
		if (waveexists(PerfomStatsPerc10))
			string wnamPerc10=nameofwave(PerfomStatsPerc10)
			AppendToGraph PerfomStatsPerc10 vs PerfomStatsPerc10_Xctr
			LegendStr+="\r\\s("+wnamPerc10+") 10th percentile"
			ModifyGraph lStyle($wnamPerc10)=3
			ModifyGraph rgb($wnamPerc10)=(0,0,0)
		endif
		if (waveexists(PerfomStatsPerc25))
			string wnamPerc25=nameofwave(PerfomStatsPerc25)
			AppendToGraph PerfomStatsPerc25 vs PerfomStatsPerc25_Xctr
			LegendStr+="\r\\s("+wnamPerc25+") 25th percentile"
			ModifyGraph rgb($wnamPerc25)=(0,0,0)
		endif
		if (waveexists(PerfomStatsPerc50))
			string wnamPerc50=nameofwave(PerfomStatsPerc50)
			AppendToGraph PerfomStatsPerc50 vs PerfomStatsPerc50_Xctr
			LegendStr+="\r\\s("+wnamPerc50+") median"
			ModifyGraph lSize($wnamPerc50)=2
			ModifyGraph rgb($wnamPerc50)=(0,0,0)
		endif
		if (waveexists(PerfomStatsPerc75))
			string wnamPerc75=nameofwave(PerfomStatsPerc75)
			AppendToGraph PerfomStatsPerc75 vs PerfomStatsPerc75_Xctr
			LegendStr+="\r\\s("+wnamPerc75+") 75th percentile"
			ModifyGraph rgb($wnamPerc75)=(0,0,0)
		endif
		if (waveexists(PerfomStatsPerc90))
			string wnamPerc90=nameofwave(PerfomStatsPerc90)
			AppendToGraph PerfomStatsPerc90 vs PerfomStatsPerc90_Xctr
			LegendStr+="\r\\s("+wnamPerc90+") 90th percentile"
			ModifyGraph lStyle($wnamPerc90)=3
			ModifyGraph rgb($wnamPerc90)=(0,0,0)
		endif
		LegendStr+="\r\rChannel used for verification: "+RefChan_Abbrev
		//more formatting
		ModifyGraph grid=1
		ModifyGraph log=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(43520,43520,43520) // (0,0,0)
		Label left "LEO-fit scattering peak height (from "+Chan_Abbrev+") [d.u.]"
		Label bottom "Scattering peak height (from "+RefChan_Abbrev+") [d.u.]"
		SetAxis/N=1 left 1,*
		SetAxis/N=1 bottom 1,CeilToNDigits(kSP2signalAmpMax, -ceil(log(kSP2signalAmpMax)))
		TextBox/C/N=DataPathBox/A=LB/X=2.51/Y=3.02 LEOfldrfp
		Legend/C/N=LegendBox/J/A=LT/X=2.51/Y=1.61 LegendStr
		if (IsSplitChannel)
			MoveWindow 130.5,80.75,704.25,512
			TextBox/C/N=CalFactBox/A=LT/X=45.53/Y=1.81 Chan_Abbrev+" calib. factor: \\{meannan("+LeoBeamCalibSubFldrFP+LEOchanPrefix+ksSP2LEOPSDcalFactFit+")}"
		else
			TextBox/C/N=CalFactBox/A=LT/X=45.53/Y=1.81 Chan_Abbrev+" slope fudge factor: \\{meannan("+LeoBeamCalibSubFldrFP+LEOchanPrefix+ksSP2LEOscattSlopeFudgeFacFit+")}"		
		endif
		SetDrawLayer UserFront
		SetDrawEnv xcoord= bottom,ycoord= left,linethick= 2,linefgc= (0,0,65280)
		DrawLine 1,1,kSP2signalAmpMax,kSP2signalAmpMax
		//move graph according to LEO-channel
		strswitch (LEOchanPrefix)
			case ksSP2SCHGprefix:
				MoveWindow 6.75,44.75,580.5,476
				break
			case ksSP2SPHGprefix:
				MoveWindow 244.5,44.75,818.25,476
				break
			case ksSP2SCLGprefix:
				MoveWindow 9,145.25,582.75,576.5
				break
			case ksSP2SPLGprefix:
				MoveWindow 246,146,819.75,577.25
				break
		endswitch
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SD_LogNormFitMassSlider([SDtserfldrfp])
	//This function creates a slider graph showing the extracted mass size distributions including the lognormal fits.
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/06/2009, 05/11/2009, 03/05/2010
	string SDtserfldrfp		//full path to folder containing the size distribution time series data
						//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(SDtserfldrfp))
		SDtserfldrfp=SP2_getFolder(type="ConcTser")
	endif
	//access time wave
	setdatafolder $SDtserfldrfp
	wave TimeCtr=$ksSP2timeSeriesTimeCtr
	string TimeRunPath=getwavesdatafolder(TimeCtr,4)		
	//various variables and strings
	variable chanind
	string chanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix
	string YMatL="", XMatL="", Legendstr="", ColourList="", ModeList="", LstyleList="", LsizeList=""
	variable nIncChans=itemsinlist(chanlist)
	//loop over incandescence channels and prepare trace lists etc. for the graph
	setdatafolder $SDtserfldrfp
	variable count=-1
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		wave /Z SD_BCdiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
		wave /Z SD_BCmassDistr=$currprefix+ksSP2pbpSDtserMassDistr
		if (waveexists(SD_BCdiamMidpt) && waveexists(SD_BCmassDistr))
			count+=1
			XMatL+=getwavesdatafolder(SD_BCdiamMidpt,4)+";"
			YMatL+=getwavesdatafolder(SD_BCmassDistr,4)+";"
			Legendstr+=stringfromlist(chanind, DescrList)+":\r"
			Legendstr+="   \\s(Ywave"+num2str(count)+") measurement\r"
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LsizeList+="1;"
			LstyleList+="0;"
		endif
		wave /Z SD_LognormDiamMidpt=$currprefix+ksSP2pbpSDtserLognormDiamMidpt
		wave /Z SD_LognormMassDistr=$currprefix+ksSP2pbpSDtserLognormMassDistr
		if (waveexists(SD_LognormDiamMidpt) && waveexists(SD_LognormMassDistr))
			count+=1
			XMatL+=getwavesdatafolder(SD_LognormDiamMidpt,4)+";"
			YMatL+=getwavesdatafolder(SD_LognormMassDistr,4)+";"
			Legendstr+="   \\s(Ywave"+num2str(count)+") lognormal fit\r"
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LsizeList+="2;"
			LstyleList+="0;"
		endif
	endfor	
	//proceed only if data are available
	if (count<0)
		setdatafolder $savedDF
		return 0	
	endif
	//define graph
	string GraphIDstr="MassSizeDistrBCSlider"
	string RefPath=SDtserfldrfp
	string TimeRunType="time"
	variable Omode=1
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=RefPath, XMatL=XMatL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	//graph window size
	MoveWindow 69.75,357.5,539.25,627.5
	//format graph
		//general
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Mass size distribution of BC cores\rdM/dlogD\BMEV\M [g m\S-3\M]"
		Label bottom "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
		//legend and text boxes
		Legendstr=ChopEndingOff(Legendstr,"\r")
		Legend/C/N=text0/J/A=MC/X=-29.21/Y=4.58 Legendstr
		TextBox/C/N=text1/A=MC/X=5.52/Y=42.50 SDtserfldrfp
		//trace specific
		ModifyGraph msize=3
		ModifyGraph Marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLsizeList(LsizeList)
		ModifyGraphLstyleList(LstyleList)
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SD_LogNormFitNumbSlider([SDtserfldrfp])
	//This function creates a slider graph showing the extracted number size distributions including the lognormal fits.
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/06/2009, 05/11/2009, 03/05/2010
	string SDtserfldrfp		//full path to folder containing the size distribution time series data
						//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(SDtserfldrfp))
		SDtserfldrfp=SP2_getFolder(type="ConcTser")
	endif
	//access time wave
	setdatafolder $SDtserfldrfp
	wave TimeCtr=$ksSP2timeSeriesTimeCtr
	string TimeRunPath=getwavesdatafolder(TimeCtr,4)		
	//various variables and strings
	variable chanind
	string chanlist=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix
	string YMatL="", XMatL="", Legendstr="", ColourList="", ModeList="", LstyleList="", LsizeList=""
	variable nIncChans=itemsinlist(chanlist)
	//loop over incandescence channels and prepare trace lists etc. for the graph
	setdatafolder $SDtserfldrfp
	variable count=-1
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		wave /Z SD_BCdiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
		wave /Z SD_BCnumbDistr=$currprefix+ksSP2pbpSDtserNumbDistr
		if (waveexists(SD_BCdiamMidpt) && waveexists(SD_BCnumbDistr))
			count+=1
			XMatL+=getwavesdatafolder(SD_BCdiamMidpt,4)+";"
			YMatL+=getwavesdatafolder(SD_BCnumbDistr,4)+";"
			Legendstr+=stringfromlist(chanind, DescrList)+":\r"
			Legendstr+="   \\s(Ywave"+num2str(count)+") measurement\r"
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LsizeList+="1;"
			LstyleList+="0;"
		endif
		wave /Z SD_LognormDiamMidpt=$currprefix+ksSP2pbpSDtserLognormDiamMidpt
		wave /Z SD_LognormNumbDistr=$currprefix+ksSP2pbpSDtserLognormNumbDistr
		if (waveexists(SD_LognormDiamMidpt) && waveexists(SD_LognormNumbDistr))
			count+=1
			XMatL+=getwavesdatafolder(SD_LognormDiamMidpt,4)+";"
			YMatL+=getwavesdatafolder(SD_LognormNumbDistr,4)+";"
			Legendstr+="   \\s(Ywave"+num2str(count)+") lognormal fit\r"
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LsizeList+="2;"
			LstyleList+="0;"
		endif
	endfor	
	//proceed only if data are available
	if (count<0)
		setdatafolder $savedDF
		return 0	
	endif
	//define graph
	string GraphIDstr="NumbSizeDistrBCSlider"
	string RefPath=SDtserfldrfp
	string TimeRunType="time"
	variable Omode=1
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=RefPath, XMatL=XMatL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	//graph window size
	MoveWindow 69.75,65,539.25,335
	//format graph
		//general
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Number size distribution of BC cores\rdN/dlogD\BMEV\M [#/cm?]"
		Label bottom "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
		//legend and text boxes
		Legendstr=ChopEndingOff(Legendstr,"\r")
		Legend/C/N=text0/J/A=MC/X=-29.21/Y=4.58 Legendstr
		TextBox/C/N=text1/A=MC/X=5.52/Y=42.50 SDtserfldrfp
		//trace specific
		ModifyGraph msize=3
		ModifyGraph Marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLsizeList(LsizeList)
		ModifyGraphLstyleList(LstyleList)
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SD_NumbSizeDistScattSlider([SDtserfldrfp])
	//This function creates a slider graph showing the extracted number size distributions of scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/11/2010
	string SDtserfldrfp		//full path to folder containing the size distribution time series data
						//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(SDtserfldrfp))
		SDtserfldrfp=SP2_getFolder(type="ConcTser")
	endif
	//access time wave
	setdatafolder $SDtserfldrfp
	wave TimeCtr=$ksSP2timeSeriesTimeCtr
	string TimeRunPath=getwavesdatafolder(TimeCtr,4)		
	//various variables and strings
	variable chanind
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListCombScattOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix
	string YMatL="", XMatL="", ColourList="", ModeList="", LstyleList="", LsizeList=""
	string Legendstr="Number size distribution of purely scattering particles:"
	variable nIncChans=itemsinlist(chanlist)
	//loop over channels and prepare trace lists etc. for the graph
	setdatafolder $SDtserfldrfp
	variable count=-1
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		wave /Z SD_DistrDiamMidpt=$currprefix+ksSP2pbpSDtserDiamMidpt
		wave /Z SD_NumbDistr=$currprefix+ksSP2pbpSDtserNumbDistr
		if (waveexists(SD_DistrDiamMidpt) && waveexists(SD_NumbDistr))
			count+=1
			XMatL+=getwavesdatafolder(SD_DistrDiamMidpt,4)+";"
			YMatL+=getwavesdatafolder(SD_NumbDistr,4)+";"
			Legendstr+="\r\\s(Ywave"+num2str(count)+") "+stringfromlist(chanind, DescrList)
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LsizeList+="1;"
			LstyleList+="0;"
		endif
	endfor	
	//proceed only if data are available
	if (count<0)
		setdatafolder $savedDF
		return 0	
	endif
	//define graph
	string GraphIDstr="NumbSizeDistrScattSl"
	string RefPath=SDtserfldrfp
	string TimeRunType="time"
	variable Omode=1
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=RefPath, XMatL=XMatL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	//graph window size
	MoveWindow 81,197.75,550.5,467.75
	//format graph
		//general
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Number size distribution of purely scattering particles, dN/dlogD\Bopt\M [#/cm\\S3\\M]"
		Label bottom "Optical particle diameter, D\Bopt\M [nm]"
		//legend and text boxes
		Legend/C/N=text0/J/A=MC/X=-18.32/Y=33.33 Legendstr
		TextBox/C/N=text1/A=MC/X=-23.85/Y=-3.33 SDtserfldrfp
		//trace specific
		ModifyGraph msize=3
		ModifyGraph Marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLsizeList(LsizeList)
		ModifyGraphLstyleList(LstyleList)
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SD_Mass_Table()
	wave SD_BCmassConcBroad,SD_LognormMassConcBroad,SD_LognormMassGmeanDpBroad
	Edit/W=(54,293.75,658.5,486.5) SD_BCmassConcBroad,SD_LognormMassConcBroad,SD_LognormMassGmeanDpBroad as "SD_Mass_Table"
	AppendToTable SD_BCnumbBroad
	ModifyTable format(Point)=1,width(SD_BCmassConcBroad)=116,width(SD_LognormMassConcBroad)=140
	ModifyTable width(SD_LognormMassGmeanDpBroad)=161,width(SD_BCnumbBroad)=94
End

Function SD_numb_Table()
	wave SD_BCnumbConcBroad,SD_LognormnumbConcBroad,SD_LognormnumbGmeanDpBroad
	Edit/W=(54,293.75,658.5,486.5) SD_BCnumbConcBroad,SD_LognormnumbConcBroad,SD_LognormnumbGmeanDpBroad as "SD_numb_Table"
	AppendToTable SD_BCnumbBroad
	ModifyTable format(Point)=1,width(SD_BCnumbConcBroad)=116,width(SD_LognormnumbConcBroad)=140
	ModifyTable width(SD_LognormnumbGmeanDpBroad)=161,width(SD_BCnumbBroad)=94
End


Function SP2_LoadFractCBproc(ctrlName,checked) : CheckBoxControl
	//This function updates the global variables corresponding to the check boxes
	//"Load one out of every n particles" and "maximum data rate" on the SP2 toolkit panel.
	//return value: 0; not used
	//martin.gysel@psi.ch; 12/07/2009
	String ctrlName		//name of button control; not used
						//either "LoadFractModeCB" or "LoadFractModeInvCB"
	Variable checked		//1: if checked
						//0: otherwise

	//preparations
	string savedDF=getdatafolder(1)
	string currproc, message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LoadFractMode=$ksSP2LoadFractMode
	Nvar LoadFractModeInv=$ksSP2LoadFractModeInv
	//write selection to global variables
	strswitch (ctrlName)
		case "LoadFractModeCB":
			LoadFractMode=checked
			break
		case "LoadFractModeInvCB":
			LoadFractMode=!checked
			break
		default:			
			setdatafolder $savedDF
			string /g RTStackInfo
			RTStackInfo=GetRTStackInfo(0)	//write stackinfo into global variable in current data folder
			currproc=laststringfromlist(RTStackInfo)
			message="Checkbox-procedure "+currproc+" is only defined for controls with the name 'LoadFractModeCB' or 'LoadFractModeInvCB'!"
			print message; print RTStackInfo; abort message	
			break
	endswitch
	LoadFractModeInv=!LoadFractMode
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2_Graph_HK_vs_time([hkfldrfp])
	//This function displays a graph showing the Housekeeping parameters against the time.
	//return value: 0; not used
	//marie.laborde@psi.ch; 07/08/2009, 09/09/2010
	string hkfldrfp		//full path to folder containing the housekeeping data
					//default: current data folder
		
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(hkfldrfp))
		hkfldrfp=SP2_getFolder(type="HK")
	endif
	//get HK-file-format version
	setdatafolder $hkfldrfp
	Nvar /Z HKfileFormat_Nvar=$ksSP2hkFileFormatNum
	variable HKfileFormatNum
	if (NVAR_Exists(HKfileFormat_Nvar))
		HKfileFormatNum=HKfileFormat_Nvar
	else
		//assume version 3.x
		HKfileFormatNum=3
	endif
	//file format specific wave names
	string DiodeTempNam, SampleFlowLFEpp, SheathFlowSetNam, YAGheatSinkTNam
	switch(HKfileFormatNum)	
		case 3:	
			DiodeTempNam="DiodeTemp_C"
			SampleFlowLFEpp=ksSP2hkSampleFlowLFEv3
			SheathFlowSetNam="SheathFlowSet_vccm"
			YAGheatSinkTNam="YAGHeatSinkT_C"
			break				
		case 4:
			DiodeTempNam="PumpDiodeTemp_C"
			SampleFlowLFEpp=ksSP2hkSampleFlowLFEv4
			SheathFlowSetNam="SheathFlowSet_sccm_VolSP"
			YAGheatSinkTNam="YAGHeatSinkTemp_C"
			break				
		default:							
			setdatafolder $savedDF
			message="Code error in the procedure"+currproc+"!"
			print message; print RTStackInfo; abort message
	endswitch
	//access waves
	setdatafolder $hkfldrfp
	wave /Z SampleFlowSet_vccm
	wave /Z YAGPower_V
	wave /Z IncandConc_1percc
	wave /Z ScatterConc_1percc
	wave /Z DutyCycle_perc
	wave /Z SampleFlowLFE=$SampleFlowLFEpp
	wave /Z PurgeFlowSet_vccm
	wave /Z PurgeFlowRead_vccm
	wave /Z SheathFlowRead_vccm
	wave /Z SheathFlowSet_vccm=$SheathFlowSetNam
	wave /Z ChamberTemp_C
	wave /Z DiodeTemp_C=$DiodeTempNam
	wave /Z YAGCrystalTemp_C
	wave /Z YAGHeatSinkT_C=$YAGheatSinkTNam
	wave /Z Chan0HV_V
	wave /Z Chan1HV_V
	wave /Z Chan2HV_V
	wave /Z Chan3HV_V
	wave /Z ChamberPressure_mBar
	//prepare legend strings
	string LegendConc=""
	string LegendDuty=""
	string LegendFlowSample=""
	string LegendFlowSHEX=""
	string LegendTC=""
	string LegendPower=""
	string LegendHV=""
	string LegendPress=""
	//create graph
	Display /W=(222.75,45.5,903,704) as "SP2_Housekeeping_graph"
	if (waveexists(ScatterConc_1percc))
		AppendToGraph/L=leftConc ScatterConc_1percc vs TimeStamp
		ModifyGraph rgb(ScatterConc_1percc)=(0,0,65280)
		LegendConc+="\r\\s(ScatterConc_1percc) scattering particles"
	endif
	if (waveexists(IncandConc_1percc))
		AppendToGraph/L=leftConc IncandConc_1percc vs TimeStamp
		LegendConc+="\r\\s(IncandConc_1percc) incandescent particles"
	endif
	if (waveexists(DutyCycle_perc))
		AppendToGraph/L=leftDuty DutyCycle_perc vs TimeStamp
		LegendDuty+="\r\\s(DutyCycle_perc) duty cycle"
		Legend/C/N=text1/J/A=MC/X=-35.26/Y=32.44 "\\Z11\\s(DutyCycle_perc) duty cycle"
	endif
	if (waveexists(SampleFlowLFE))
		string SampleFlowLFEnam=nameofwave(SampleFlowLFE)
		AppendToGraph/L=leftflowSample SampleFlowLFE vs TimeStamp
		ModifyGraph rgb($SampleFlowLFEnam)=(32768,32768,65280)
		LegendFlowSample+="\r\\s("+SampleFlowLFEnam+") Sample flow LFE"
	endif
	if (waveexists(SampleFlowSet_vccm))
		AppendToGraph/L=leftflowSample SampleFlowSet_vccm vs TimeStamp
		ModifyGraph rgb(SampleFlowSet_vccm)=(0,0,0)
		LegendFlowSample+="\r\\s(SampleFlowSet_vccm) Sample flow set"
	endif
	if (waveexists(PurgeFlowRead_vccm))
		AppendToGraph/L=leftflowSHEX PurgeFlowRead_vccm vs TimeStamp
		ModifyGraph lSize(PurgeFlowRead_vccm)=1.5
		ModifyGraph rgb(PurgeFlowRead_vccm)=(65280,43520,0)
		LegendFlowSHEX+="\r\\s(PurgeFlowRead_vccm) Purge flow read"
	endif
	if (waveexists(PurgeFlowSet_vccm))
		AppendToGraph/L=leftflowSHEX PurgeFlowSet_vccm vs TimeStamp
		ModifyGraph rgb(PurgeFlowSet_vccm)=(39168,0,0)
		LegendFlowSHEX+="\r\\s(PurgeFlowSet_vccm) Purge flow set"
	endif
	if (waveexists(SheathFlowRead_vccm))
		AppendToGraph/L=leftflowSHEX SheathFlowRead_vccm vs TimeStamp
		ModifyGraph lSize(SheathFlowRead_vccm)=1.5
		ModifyGraph rgb(SheathFlowRead_vccm)=(0,65280,0)
		LegendFlowSHEX+="\r\\s(SheathFlowRead_vccm) Sheath flow read"
	endif
	if (waveexists(SheathFlowSet_vccm))
		AppendToGraph/L=leftflowSHEX SheathFlowSet_vccm vs TimeStamp
		ModifyGraph rgb($SheathFlowSetNam)=(0,26112,13056)
		LegendFlowSHEX+="\r\\s("+SheathFlowSetNam+") Sheath flow set"
	endif
	if (waveexists(ChamberTemp_C))
		AppendToGraph/L=leftTC ChamberTemp_C vs TimeStamp
		ModifyGraph rgb(ChamberTemp_C)=(0,52224,0)
		LegendTC+="\r\\s(ChamberTemp_C) chamber"
	endif
	if (waveexists(DiodeTemp_C))
		AppendToGraph/L=leftTC DiodeTemp_C vs TimeStamp
		ModifyGraph rgb($DiodeTempNam)=(0,0,65280)
		LegendTC+="\r\\s("+DiodeTempNam+") diode"
	endif
	if (waveexists(YAGCrystalTemp_C))
		AppendToGraph/L=leftTC YAGCrystalTemp_C vs TimeStamp
		LegendTC+="\r\\s(YAGCrystalTemp_C) YAG crystal"
	endif
	if (waveexists(YAGHeatSinkT_C))
		AppendToGraph/L=leftTC YAGHeatSinkT_C vs TimeStamp
		ModifyGraph rgb($YAGheatSinkTNam)=(65280,43520,0)
		LegendTC+="\r\\s("+YAGheatSinkTNam+") YAG heat sink"
	endif
	if (waveexists(YAGPower_V))
		AppendToGraph/L=leftpower YAGPower_V vs TimeStamp
		LegendPower+="\r\\s(YAGPower_V) YAG power"
	endif
	if (waveexists(Chan0HV_V))
		AppendToGraph/L=leftHV Chan0HV_V vs TimeStamp
		LegendHV+="\r\\s(Chan0HV_V) channel 0"
	endif
	if (waveexists(Chan1HV_V))
		AppendToGraph/L=leftHV Chan1HV_V vs TimeStamp
		ModifyGraph rgb(Chan1HV_V)=(65280,43520,0)
		LegendHV+="\r\\s(Chan1HV_V) channel 1"
	endif
	if (waveexists(Chan2HV_V))
		AppendToGraph/L=leftHV Chan2HV_V vs TimeStamp
		ModifyGraph rgb(Chan2HV_V)=(0,52224,0)
		LegendHV+="\r\\s(Chan2HV_V) channel 2"
	endif
	if (waveexists(Chan3HV_V))
		AppendToGraph/L=leftHV Chan3HV_V vs TimeStamp
		ModifyGraph rgb(Chan3HV_V)=(0,0,65280)
		LegendHV+="\r\\s(Chan3HV_V) channel 3"
	endif
	if (waveexists(ChamberPressure_mBar))
		AppendToGraph/L=leftpress ChamberPressure_mBar vs TimeStamp
		LegendPress+="\r\\s(ChamberPressure_mBar) chamber pressure"
	endif
	//general graph formatting
	ModifyGraph margin(left)=85
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph fSize=11
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label bottom "Time"
	ModifyGraph dateInfo(bottom)={0,0,0}
	//axis specific
	if (strlen(LegendConc)>0)
		TextBox/C/N=text0/J/A=MC/X=-30.53/Y=44.49 "\\Z11Number concentration:"+LegendConc
		Label leftConc "Conc. [#/cm?]"
		SetAxis/A/N=1 leftConc
		ModifyGraph lblPos(leftConc)=65
		ModifyGraph freePos(leftConc)=0
		ModifyGraph axisEnab(leftConc)={0.89,1}	
	endif
	if (strlen(LegendDuty)>0)
		TextBox/C/N=text1/J/A=MC/X=-35.26/Y=32.44 "\\Z11"+LegendDuty		
		Label leftDuty "Duty cycle [%]"
		SetAxis/A/N=1 leftDuty
		ModifyGraph lblPos(leftDuty)=65
		ModifyGraph freePos(leftDuty)=0
		ModifyGraph axisEnab(leftDuty)={0.77,0.875}
	endif
	if (strlen(LegendFlowSample)>0)
		TextBox/C/N=text2/J/A=MC/X=-32.89/Y=21.03 "\\Z11Sample flow rate:"+LegendFlowSample
		Label leftflowSample "Flow [lpm]"
		SetAxis/A/N=1 leftflowSample
		ModifyGraph lblPos(leftflowSample)=65
		ModifyGraph freePos(leftflowSample)=0
		ModifyGraph axisEnab(leftflowSample)={0.64,0.75}
	endif
	if (strlen(LegendFlowSHEX)>0)
		Label leftflowSHEX "Flow [lpm]"
		SetAxis/A/N=1 leftflowSHEX
		ModifyGraph lblPos(leftflowSHEX)=65
		ModifyGraph freePos(leftflowSHEX)=0
		ModifyGraph axisEnab(leftflowSHEX)={0.52,0.625}
		TextBox/C/N=text7/J/A=MC/X=-34.08/Y=7.05 "\\Z11Sheath/Purge flow rates:"+LegendFlowSHEX
	endif
	if (strlen(LegendTC)>0)
		Label leftTC "Temp. [?C]"
		SetAxis/A/N=1 leftTC
		ModifyGraph lblPos(leftTC)=65
		ModifyGraph freePos(leftTC)=0
		ModifyGraph axisEnab(leftTC)={0.39,0.5}
		TextBox/C/N=text3/J/A=MC/X=-35.13/Y=-6.15 "\\Z11Temperatures:"+LegendTC
	endif
	if (strlen(LegendPower)>0)
		Label leftpower "Power [V]"
		SetAxis/A/N=1 leftpower
		ModifyGraph lblPos(leftpower)=65
		ModifyGraph freePos(leftpower)=0
		ModifyGraph axisEnab(leftpower)={0.27,0.375}
		TextBox/C/N=text4/J/A=MC/X=-35.39/Y=-18.21 "\\Z11"+LegendPower
	endif
	if (strlen(LegendHV)>0)
		Label leftHV "Amp. HV [V]"
		SetAxis/A/N=1 leftHV
		ModifyGraph lblPos(leftHV)=65
		ModifyGraph freePos(leftHV)=0
		ModifyGraph axisEnab(leftHV)={0.14,0.25}
		TextBox/C/N=text5/J/A=MC/X=-35.26/Y=-30.77 "\\Z11 HV at PMT/APD"+LegendHV
	endif
	if (strlen(LegendPress)>0)
		Label leftpress "Press. [mbar]"
		SetAxis/A/N=1 leftpress
		ModifyGraph lblPos(leftpress)=65
		ModifyGraph freePos(leftpress)=0
		ModifyGraph axisEnab(leftpress)={0,0.1}
		TextBox/C/N=text6/J/A=MC/X=-32.24/Y=-45.38 "\\Z11"+LegendPress
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End


function SP2_credits_panel(ctrlname) : ButtonControl
	//This function shows the credits panel for PSI's SP2 toolkit panel
	//return value: 0, not used
	//martin.gysel@psi.ch; 15/08/2009
	string ctrlname	//name of button control; not used
	
	//bring panel to front if it does already exist
	dowindow /F SP2_Toolkit_PSI_Credits
	if (V_flag)
		//Panel does already exist => finish procedure.
		return 0	
	endif
	//create panel otherwise
	NewPanel /K=1/W=(258,337,607,604) as "SP2_Toolkit_PSI_Credits"
	dowindow /c SP2_Toolkit_PSI_Credits
	SetDrawLayer UserBack
	DrawRect 6,5,342,262
	DrawPICT 207,8,0.594595,0.555556,LAC_logo_colour_highRes_png
	DrawPICT 10,9,0.494318,0.469231,PSI_Logo_narrow_pc_jpg
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,108,"Leading scientist: Martin Gysel"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,125,"Contributing scientists: Joel C. Corbin, Marie Laborde"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,142,"Financial support: Swiss National Science Foundation"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,159,"Contact: martin.gysel@psi.ch; +41 56 310 4168"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,176,"Web: http://www.psi.ch/lac/martin-gysel"
	SetDrawEnv fstyle= 1;SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,200,"Acknowledgment:"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,217,"Mobility density data: Nobuhiro Moteki and Yutaka Kondo"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,234,"Mie calculations: Shuka Schwarz and Paul Zieger"
	SetDrawEnv fname= "Arial";SetDrawEnv fsize= 12;DrawText 19,251,"Binary data file loader: DMT's software engineers"
	//finish procedure
	return 0
end


Function SP2graph_ScattCalibFact([CalibSummaryFP])
	//this function creates a graph showing the calibration factor of the scattering channel
	//obtained by a PSL or salt calibration for all investigated dry sizes.
	//return value: 0; not used
	//martin.gysel@psi.ch; 28/08/2009
	string CalibSummaryFP	//full path to folder containing the calibration summary of the scattering channel
							//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibSummaryFP))
		CalibSummaryFP=savedDF
	endif
	//access waves
	setdatafolder $CalibSummaryFP
	wave Scatt_CalibFactList
	wave DiamList_1e
	wave LaserPowerList
	
	//create graph
	Display /W=(249,112.25,643.5,413.75) Scatt_CalibFactList vs DiamList_1e as "Scattering_Calibration_Factor"
	//format graph
	ModifyGraph mode=3
	ModifyGraph marker=19
	ModifyGraph useMrkStrokeRGB=1	
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph notation(left)=1
	// colour by laser power
	ModifyGraph margin(right)=85
	ModifyGraph zColor(Scatt_CalibFactList)={LaserPowerList,*,*,Rainbow,0} 
	ColorScale/C/N=text1_1/X=103.21/Y=1.19 trace=Scatt_CalibFactList;DelayUpdate
	ColorScale/C/N=text1_1 "Laser power [V]"
	Label left "Calibration factor for scattering channel [-]"
	Label bottom "Diameter [nm]"
	SetAxis/A/E=0 left
	SetAxis/A/N=1 bottom
	TextBox/C/N=fldrTx/A=RT/X=1/Y=1 CalibSummaryFP
	
	// create another graph vs laser power -- jcc v4111
	Display /W=(487.2,121.4,891.6,513.8) Scatt_CalibFactList vs LaserPowerList
	ModifyGraph margin(top)=76 // ,gFont="Segoe UI",gfSize=12
	ModifyGraph mode=3
	ModifyGraph marker=19
	ModifyGraph lSize=2
	ModifyGraph rgb=(1792,14080,63488)
	ModifyGraph gaps=0
	ModifyGraph useMrkStrokeRGB=1
	ModifyGraph zColor(Scatt_CalibFactList)={TimeCentreList,*,*,Rainbow,1}
	ModifyGraph grid=1
	ModifyGraph zero=3
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph lowTrip=0.001
	ModifyGraph lblMargin=3
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph btLen=5
	ModifyGraph notation(left)=1
	Label left "Calibration factor for scattering channel" // [-]" v4111 -- actually there are units...
	Label bottom "Laser power [V]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	ColorScale/C/N=text0/F=0/B=1/A=MT/X=-2.53/Y=-32.59 trace=Scatt_CalibFactList
	ColorScale/C/N=text0 vert=0, side=2
	AppendText " "
	TextBox/C/N=fldrTx/A=LT/X=1/Y=1 CalibSummaryFP
	
	
	//finish procedure
	setdatafolder $savedDF
	return 0
End


function SP2_CalibScattGraphOptProc(GraphFolderFPath)
// Put the cursor on the point of the current selecction
	//martin.gysel@psi.ch; 05/10/2009, 05/05/2010;
	string GraphFolderFPath	//full path to slider graph folder
	string DataWaveFPath	//full path to DataWave of which the value corresponding to the current data entry is to be displayed
	
	string savedDF=getdatafolder(1)
	//access data in matrix slider folder
	setdatafolder $GraphFolderFPath
	Svar RefPathStr
	Svar YMatList
	Nvar CurrPoint
	//prefix of data channel
	string chanprefix=stringfromlist(0,stringfromlist(0,YMatList),"_")+"_"
	//access source data of this slider graph
	setdatafolder $RefPathStr
	wave FitPkHt_1e=$chanprefix+ksSP2calibFitPkHt+ksSP2suffix1e
	//place cursor according to previously set "FitPkHt"
		variable Xval, PtIndex
		//1e
		Xval=NanToValue(log(FitPkHt_1e[currPoint]),1)
		Cursor /A=1 A  Ywave0  Xval
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2_CalibScattAnalyzerSlider([chanPrefix, GraphIDstr, CalibSummaryFP, Omode])
	//This function creates a slider graph needed for the analysis of PSL calibration data.
	//martin.gysel@psi.ch; 05/10/2009, 05/05/2010;
	//joel.c.corbin+sci@gmail.com; 2016-02-24
	string chanPrefix		// Channel prefix like ":SCHG_" or ":SCLG_" (function will convert "SCHG" or "SCLG" to these) 
							//must be an element out of this list ksSP2scattShortDescriptList
							//default: prompt				
	string GraphIDstr			//ID string used for name of slider graph
							//default: channel prefix+"CalibSlider"
	string CalibSummaryFP	//folder containing the calibration summary
							//default: current datafolder
	variable Omode			//0 (default):	prompt if graph/folder with given GraphIDstr does already exist
							//1:			overwrite existing graph

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values

	//set default values
	if (ParamIsDefault(chanPrefix))
		chanPrefix= SP2_getChanPrefix("Scatt")
	elseif (!strlen(chanPrefix)==(4+2))
		if (grepString(chanPrefix, "[A-Z]{4}"))  // was given as 4 consecutive capital letters
			chanPrefix= ":" + chanPrefix + "_"
		endif
	endif
	if (paramisdefault(GraphIDstr))
		GraphIDstr=ChanPrefix+"CalibrationSlider"
	endif
	if (paramisdefault(CalibSummaryFP))
		CalibSummaryFP=savedDF
	endif
	if (paramisdefault(Omode))
		Omode=0
	elseif (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	//access global variables
	setdatafolder $CalibSummaryFP
	Svar CalibInfoFldrFP=$ksSP2calibInfoFldrFP
	//prepare slider	
	string YMatL=ChanPrefix+ksSP2calibHistoMat+";"+ChanPrefix+ksSP2calibHistoMatFitted
	CalibInfoFldrFP=ChopLastCharacterOff(CalibInfoFldrFP,":")
	string TimeRunPath=CalibInfoFldrFP+ksSP2_monodi_TimeCentreList
	string TimeRunType="time"	
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=CalibSummaryFP, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	//graph window size
	strswitch (ChanPrefix)
		case ksSP2SCHGprefix:
			MoveWindow 126.75,230.75,633.75,555.5
			//MoveWindow 204.75,194.75,711.75,519.5
			break
		case ksSP2SCLGprefix:
			MoveWindow 51,95.75,558,420.5
			break
		default:
			setdatafolder $savedDF
			message="Undefined value of the string 'ChanPrefix' in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch
	//format graph
	ModifyGraph lSize(Ywave1)=2
	ModifyGraph lStyle(Ywave1)=2
	ModifyGraph rgb(Ywave1)=(0,0,52224)
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Frequency [-]"
	Label bottom "Logarithm of scattering peak height"
	Legend/C/N=text0/J/A=LT/X=1/Y=10 "\\s(Ywave0) histogram\r\\s(Ywave1) fit"
	TextBox/C/N=text1/A=LT/X=1/Y=1	ChanPrefix+" channel"
	
	//control bar
	ControlBar 80
	Button $"GetPeak1e"+GraphIDstr,pos={9,53},size={150,20},proc=SP2_CalibGraphGetPeakButt,title="get 1e peak from cursor A",font=arial,fSize=11
	ShowInfo
	Button CalibAnalyseMonoScattPostProc,pos={410,54},size={190,20},proc=SP2_CalibAnalyzerScattpostproc,title="finished? redo calib. post processing" // jcc v4111 .... to let user know nextstep
	Button CalibAnalyseMonoScattPostProc,font="Arial",fSize=11
		
	//stick a table on to the window showing the current results [jcc v4111]
		string Ch4lett= ChanPrefix[1,4] // ":SCHG_" -> "SCHG"
		//access calibration summary waves
		setdatafolder $CalibSummaryFP
		// wave Scatt_GaussModeMat=$ChanPrefix+ksSP2calibGaussModeMat
		wave Scatt_FitPkHt_1e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
		wave LaserPowerList=$ksSP2_monodi_LaserPowerList
		wave DiamList_1e=$ksSP2calibDiamList+ksSP2suffix1e
		// wave Scatt_ConcList=$ChanPrefix+ksSP2calibConcList
		// wave ConcListCPC=$ksSP2_monodi_ConcList
	NewPanel /K=1 /EXT=0 /HOST=$Ch4lett+"CalibrationSlide" /N=$Ch4lett+"_Cal_Results" /W=(0, 0, 0.5, 0.54)
	Edit /HOST=# /K=1 /W=(0,0,1,1) Scatt_FitPkHt_1e, LaserPowerList, DiamList_1e
	modifytable size=14

	//optional slider proc: Move cursor to current peak height
	setdatafolder $MSSfldrpath
	Svar OptionalCurrPtCmd 
	OptionalCurrPtCmd="SP2_CalibScattGraphOptProc(\""+MSSfldrpath+"\")"
	execute "SP2_CalibScattGraphOptProc(\""+MSSfldrpath+"\")"		//invoke it for the first time
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2_CalibrationAnalyzerSlider([ChanDescr, GraphIDstr, CalibSummaryFP, Omode])
	//This function creates a slider graph needed for the analysis of calibration data.
	//martin.gysel@psi.ch; 28/01/2009; 26/08/2009; 05/10/2009; 05/05/2010
	string ChanDescr			//ChanDescr description
							//must be an element out of the list ksSP2incandShortDescriptList+ksSP2scattShortDescriptList
							//default: prompt				
	string GraphIDstr			//ID string used for name of slider graph
							//default: ChanDescr prefix+"CalibSlider"
	string CalibSummaryFP	//folder containing the calibration summary
							//default: current datafolder
	variable Omode			//0 (default):	prompt if graph/folder with given GraphIDstr does already exist
							//1:			overwrite existing graph

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values
	string DescrList=SP2_ChanListToDescrShortList(SP2_ChanListIncandOnly()+SP2_ChanListScattOnly())
	if (paramisdefault(ChanDescr))
		ChanDescr=stringfromlist(0,DescrList)
		prompt ChanDescr, "Select channel:",popup, DescrList
		doprompt "ChanDescr", ChanDescr
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure!"
			print message; print RTStackInfo; abort message
		endif
	endif
	variable ChanNo=whichlistitem(ChanDescr,DescrList)
	if (ChanNo==-1)
		setdatafolder $savedDF
		message="Undefined value of the parameter 'ChanDescr' handed over to the function "+currproc+"!"
		print message; print RTStackInfo; abort message	
	endif
	string ChanPrefix=stringfromlist(ChanNo,SP2_ChanListIncandOnly()+SP2_ChanListScattOnly())
	if (paramisdefault(Omode))
		Omode=0
	endif
	if (paramisdefault(CalibSummaryFP))
		CalibSummaryFP=savedDF
	endif
	//call channel specific slider graph function
	strswitch (ChanPrefix)
		case ksSP2BBHGprefix:
		case ksSP2BBLGprefix:
		case ksSP2NBHGprefix:
		case ksSP2NBLGprefix:
			SP2_CalibBCAnalyzerSlider(ChanDescr=ChanDescr, CalibSummaryFP=CalibSummaryFP, Omode=Omode)
			break
		case ksSP2SCHGprefix:
		case ksSP2SCLGprefix:
			SP2_CalibScattAnalyzerSlider(chanPrefix=chanPrefix, CalibSummaryFP=CalibSummaryFP, Omode=Omode)
			break
		default:
			setdatafolder $savedDF
			message="Undefined value of the string 'ChanPrefix' in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch
	//finish procedure
	setdatafolder $savedDF
	return 0
end

Function SP2graph_BCmass_NarrVsBroad([pbpfldrfp])
	//This function displays a scatter plot of narrowband versus broadband BC mass of single particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 03/11/2009, 06/05/2010
	string pbpfldrfp	//full path to the data folder containing the pbp data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif
	//various strings
	string Legendstr="BC mass derived from:", Wnam, ColourList=""
	//access waves
	SetDataFolder $pbpfldrfp
	wave /Z BBHG_BCmass=$ksSP2BBHGprefix+ksSP2pbpBCmass
	wave /Z NBHG_BCmass=$ksSP2NBHGprefix+ksSP2pbpBCmass
	wave /Z BBLG_BCmass=$ksSP2BBLGprefix+ksSP2pbpBCmass
	wave /Z NBLG_BCmass=$ksSP2NBLGprefix+ksSP2pbpBCmass
	if (waveexists(BBHG_BCmass) && (waveexists(NBHG_BCmass) || waveexists(BBLG_BCmass) || waveexists(NBLG_BCmass)))
		//get max ordinate value
		variable MaxBBHGMass=MaxFromWaveNaN(BBHG_BCmass, mode=1)	
		//create graph
		Display /W=(210.75,191.75,615.75,567.5) as "BCmass_ScatterPlot_vsBBHG"
		//append high gain narrowband
			if (waveexists(NBHG_BCmass))
				Appendtograph NBHG_BCmass vs BBHG_BCmass
				Wnam=Nameofwave(NBHG_BCmass)
				ColourList+="4;"
				ModifyGraph marker($Wnam)=8
				Legendstr+="\r\\s("+Wnam+") high gain narrowband channel"
			endif
		//append low gain broadband
			if (waveexists(BBLG_BCmass))
				Appendtograph BBLG_BCmass vs BBHG_BCmass
				Wnam=Nameofwave(BBLG_BCmass)
				ColourList+="3;"
				ModifyGraph marker($Wnam)=0
				Legendstr+="\r\\s("+Wnam+") low gain broadband channel"
			endif
		//append high gain narrowband
			if (waveexists(NBLG_BCmass))
				Appendtograph NBLG_BCmass vs BBHG_BCmass
				Wnam=Nameofwave(NBLG_BCmass)
				ColourList+="5;"
				ModifyGraph marker($Wnam)=1
				Legendstr+="\r\\s("+Wnam+") low gain narrowband channel"
			endif
		//format graph
		ModifyGraph mode=3
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "BC mass derived from second channel (see legend) [fg]"
		Label bottom "BC mass derived from high gain broadband channel [fg]"
		SetAxis/A/N=1 left
		SetAxis/A/N=1 bottom
		TextBox/C/N=text0/A=MC/X=-20.38/Y=28.61 pbpfldrfp
		TextBox/C/N=text1/A=MC/X=-20.85/Y=43.26 Legendstr+"\r\\W509 1:1 line"
		SetDrawLayer UserFront
		SetDrawEnv xcoord= bottom,ycoord= left
		DrawLine 0,0,MaxBBHGMass,MaxBBHGMass
		//coulorize
		ModifyGraphColouriseList(ColourList, 5)		
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2_CalibBCSizeDistSlider([GraphIDstr, CalibSummaryFP, Omode])
	//This function creates a BC size distributon slider graph for monodisperse calibration data.
	//martin.gysel@psi.ch; 12/11/2009, 05/05/2010
	string GraphIDstr			//ID string used for name of slider graph
							//default: "CalibSizeDistrSlid"
	string CalibSummaryFP	//folder containing the calibration summary
							//default: current datafolder
	variable Omode			//0 (default):	prompt if graph/folder with given GraphIDstr does already exist
							//1:			overwrite existing graph

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set default values
	if (paramisdefault(GraphIDstr))
		GraphIDstr="CalibSizeDistrSlid"
	endif
	if (paramisdefault(CalibSummaryFP))
		CalibSummaryFP=savedDF
	endif
	if (paramisdefault(Omode))
		Omode=0
	elseif (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	setdatafolder $CalibSummaryFP
	Svar CalibInfoFldrFP=$ksSP2calibDMACPCfldrFP
	CalibInfoFldrFP=ChopLastCharacterOff(CalibInfoFldrFP,":")
	//channel definitions etc.
	string chanlist=SP2_ChanListIncandOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind, count=0
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList="", MarkerList="",  YMatL="", XMatL="", YaxisSideL=""
	string LegendStr="\\Z10dN/dlogDp:\r"
	//loop over all channels and prepare graph definitions
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $CalibSummaryFP
		wave /Z dNdlogDpMat=$currprefix+ksSP2calibdNdlogDpMat
		//append graph definitions
		if (waveexists(dNdlogDpMat))
			tracename="Ywave"+num2str(count)
			count+=1
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			MarkerList+="19;"
			LstyleList+="0;"
			LsizeList+="3;"
			LegendStr+="\\s("+tracename+") "+currDescr+"\r"
			YMatL+=currprefix+ksSP2calibdNdlogDpMat+";"
			XMatL+=ksSP2calibDiamMidptScale+";"
			YaxisSideL+="L;"
		endif
	endfor
	//Add DMA size distributions
	YMatL+=ksSP2calibHelpDiamYwav+";"+ksSP2calibHelpDiamYwav+";"+ksSP2calibHelpDiamYwav+";"
	XMatL+=ksSP2calibHelpDiamMat+ksSP2suffix1e+";"+ksSP2calibHelpDiamMat+ksSP2suffix2e+";"+ksSP2calibHelpDiamMat+ksSP2suffix3e+";"
	YaxisSideL+="R;R;R;"
	ColourList+="0;0;0;"
	ModeList+="0;0;0;"
	MarkerList+="0;0;0;"
	LstyleList+="0;3;1;"
	LsizeList+="1.5;1.5;1.5;"
	LegendStr+="\\s(Ywave"+num2str(count)+") DMA single charge\r"
	LegendStr+="\\s(Ywave"+num2str(count+1)+") DMA double charge\r"
	LegendStr+="\\s(Ywave"+num2str(count+2)+") DMA tripple charge\r"
	//time wave
	string TimeRunPath=CalibInfoFldrFP+ksSP2_monodi_TimeCentreList
	string TimeRunType="time"	
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, XMatL=XMatL, RefPath=CalibSummaryFP, YaxisSideL=YaxisSideL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]	
	//graph window size
	MoveWindow 162,212,669,536.75
	//general formatting graph
	ModifyGraph grid(left)=1,grid(bottom)=1
	ModifyGraph log(bottom)=1
	ModifyGraph mirror(bottom)=1
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph tickEnab(right)={-9999,-9998}
	Label left "Number size distribution\rdN/dlogD\Bp\M [a.u.]"
	Label bottom "Particle diameter, D\Bp\M [nm]"
	//trace specific formatting
	ModifyGraphColouriseList(ColourList, 5)
	ModifyGraphModeList(ModeList)
	ModifyGraphMarkerList(MarkerList)
	ModifyGraphLstyleList(LstyleList)
	ModifyGraphLsizeList(LsizeList)
	//legends and text boxes
	Legend/C/N=text0/J/X=69.12/Y=15.51 LegendStr
	TextBox/C/N=text1/X=65.81/Y=4.11 CalibSummaryFP
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2table_IceCoreSummary([SummaryFldrFP])
	//This function creates a table showing the ice core analysis results taken from the summary folder
	//martin.gysel@psi.ch; 19/11/2009; 23/11/2009; 07/05/2010
	string SummaryFldrFP	//full path to the data folder containing the summary of the ice core analysis results
							//default: current data folder
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(SummaryFldrFP))
		SummaryFldrFP=savedDF
	endif
	SummaryFldrFP=ChopLastCharacterOff(SummaryFldrFP,":")
	//access general waves
	if (!DataFolderExists(SummaryFldrFP))
		SP2_abort("Ice core data folder not found. Looked in: " + SummaryFldrFP)
	endif
	setdatafolder $SummaryFldrFP
	wave /t SampleID
	wave TimeDateAvg
	//prepare table
	Edit/W=(12,47,911.25,378.5) SampleID,TimeDateAvg as "IceCoreSummary_Table"
	//channel definitions etc.
	string chanlist=SP2_ChanListIceCoreSummary()
	string currprefix
	variable chanind
	variable nChans=itemsinlist(chanlist)
	//loop over all channels and append waves
	for (chanind=0; chanind<nChans; chanind+=1)
		//channel prefix
		currprefix=stringfromlist(chanind, chanlist)
		//acess waves
		setdatafolder $SummaryFldrFP
		wave /Z LiquidSampleMassConc=$currprefix+ksSP2pbpLiquidSampleMassConc
		wave /Z LiqSampMassConcBlwCut=$currprefix+ksSP2pbpLiqSampMassConcBelowCut
		if (waveexists(LiquidSampleMassConc))
			AppendToTable LiquidSampleMassConc
		endif
		if (waveexists(LiqSampMassConcBlwCut))
			AppendToTable LiqSampMassConcBlwCut
		endif
	endfor
	//format table
	ModifyTable format(Point)=1
	ModifyTable format(TimeDateAvg)=8
	ModifyTable autosize={0, 0, 8, 0, 0}
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2graph_IceCoreSummary([SummaryFldrFP])
	//This function creates a graph showing the ice core analysis results taken from the summary folder
	//martin.gysel@psi.ch; 19/11/2009; 23/11/2009; 07/05/2010
	string SummaryFldrFP	//full path to the data folder containing the summary of the ice core analysis results
							//default: current data folder
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(SummaryFldrFP))
		SummaryFldrFP=savedDF
	endif
	SummaryFldrFP=ChopLastCharacterOff(SummaryFldrFP,":")
	if (!DataFolderExists(SummaryFldrFP))
		SP2_abort("Ice core data folder not found. Looked in: " + SummaryFldrFP)
	endif	
	//access abscissa wave
	setdatafolder $SummaryFldrFP
	wave /t SampleID
	//prepare graph
	Display /W=(91.5,170.75,900.75,517.25) as "IceCoreSummaryGraph"
	//channel definitions etc.
	string chanlist=SP2_ChanListIceCoreSummary()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, currColour, TraceNam, currLegendLine
	variable chanind
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", toModeList="", hbFillList=""
	string LegendStr="\\Z10BC mass concentration [?g/l]:"
	//loop over all channels, append traces and prepare trace formatting lists
	for (chanind=0; chanind<nChans; chanind+=1)
		//channel specific
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		currColour=stringfromlist(chanind, ChanColourList)
		//access waves
		setdatafolder $SummaryFldrFP
		wave /Z LiquidSampleMassConc=$currprefix+ksSP2pbpLiquidSampleMassConc
		wave /Z LiqSampMassConcBlwCut=$currprefix+ksSP2pbpLiqSampMassConcBelowCut
		if (waveexists(LiquidSampleMassConc))
			if (waveexists(LiqSampMassConcBlwCut))
				//append "below cut estimate" trace
				AppendToGraph LiqSampMassConcBlwCut vs SampleID
				TraceNam=NameOfWave(LiqSampMassConcBlwCut)
				//graph formatting lists
				ModeList+="5;"
				ColourList+=currColour+";"
				toModeList+="3;"	
				hbFillList+="4;"
				currLegendLine=" (\\s("+TraceNam+") below cut estimate)"
			endif		
			//append liquid conc. trace
			AppendToGraph LiquidSampleMassConc vs SampleID
			TraceNam=NameOfWave(LiquidSampleMassConc)
			//graph formatting lists
			ModeList+="5;"
			ColourList+=currColour+";"
			toModeList+="0;"	
			hbFillList+="2;"
			currLegendLine="\r\\s("+TraceNam+") "+currDescr+currLegendLine
			LegendStr+=currLegendLine
		endif
		
	endfor
	//format graph
		//general formatting
		ModifyGraph mirror=2
		ModifyGraph standoff=0
		Label left "BC mass concentration [?g/l]"
		Label bottom "Sample ID"
		SetAxis/A/E=1 left
		//legend and text boxes
		Legend/C/N=text0/J/A=MC/X=-32.21/Y=35.44 LegendStr
		TextBox/C/N=text1/A=MC/X=4.50/Y=45.06 SummaryFldrFP
		//trace specific formatting
		ModifyGraphModeList(ModeList)
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphtoModeList(toModeList)
		ModifyGraphhbFillList(hbFillList)
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2graph_BandratioVsBroadpkht([DataFldrFP])
	//This function creates a graph showing the bandratio vs the broadband peak height
	//return value: 0; not used
	//martin.gysel@psi.ch; 27/11/2009, 06/05/2010
	string DataFldrFP		//full path to the data folder containing the bandratio statistics data
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(DataFldrFP))
		DataFldrFP=SP2_getFolder(type="PBP")
	endif
	DataFldrFP=ChopLastCharacterOff(DataFldrFP,":")
	//various
	string mediansuffix="50"
	string legendstr, tracelist, nam0, Wnam
	//bandratio of peak heights
		//high gain
			//access waves
			setdatafolder $DataFldrFP
			wave /Z BandratioPerc50PkHt=$ksSP2pbpBandratHGPercBnam+mediansuffix	
			wave /Z BandratioPerc50PkHt_Xctr=$ksSP2pbpBandratHGPercBnam+mediansuffix+ksSP2pbpBandratioXctrSuffix
			wave /Z BandratioPerc50PkArea=$ksSP2pbpBandratHGAvgPercBnam+mediansuffix	
			wave /Z BandratioPerc50PkArea_Xctr=$ksSP2pbpBandratHGAvgPercBnam+mediansuffix+ksSP2pbpBandratioXctrSuffix
			legendstr="median of high gain bandratio:"		
			//create graph
			if ( (waveexists(BandratioPerc50PkHt) && waveexists(BandratioPerc50PkHt_Xctr)) || (waveexists(BandratioPerc50PkArea) && waveexists(BandratioPerc50PkArea_Xctr)) )
				Display /W=(25,40,455,355) as "bandratio_stats_HighGain"
					//bandratio from peak heights
					if ( waveexists(BandratioPerc50PkHt) && waveexists(BandratioPerc50PkHt_Xctr) )
						Wnam=NameOfWave(BandratioPerc50PkHt)
						Appendtograph BandratioPerc50PkHt vs BandratioPerc50PkHt_Xctr
						legendstr+="\r\\s("+Wnam+") from peak heights"
						//format graph
						ModifyGraph mode($Wnam)=4
						ModifyGraph marker($Wnam)=19
						ModifyGraph useMrkStrokeRGB($Wnam)=1
						ModifyGraph rgb($Wnam)=(65280,0,0)
					endif
					//bandratio from peak areas
					if ( waveexists(BandratioPerc50PkArea) && waveexists(BandratioPerc50PkArea_Xctr) )
						Wnam=NameOfWave(BandratioPerc50PkArea)
						Appendtograph BandratioPerc50PkArea vs BandratioPerc50PkArea_Xctr
						legendstr+="\r\\s("+Wnam+") from peak areas"
						//format graph
						ModifyGraph mode($Wnam)=4
						ModifyGraph marker($Wnam)=16
						ModifyGraph useMrkStrokeRGB($Wnam)=1
						ModifyGraph rgb($Wnam)=(0,0,65280)
					endif
				//general formatting
				ModifyGraph grid=1
				ModifyGraph log(bottom)=1
				ModifyGraph mirror=2
				ModifyGraph nticks=10
				ModifyGraph standoff=0
				ModifyGraph gridRGB=(0,0,0)
				Label left "High gain bandratio (broadband : narrowband) [-]"
				Label bottom "High gain broadband incandescence peak height [d.u.]"
				SetAxis/A/N=1 left
				SetAxis/N=1 bottom 30,10000
				Legend/C/N=text0/J/X=17.39/Y=43.83 legendstr
				TextBox/C/N=text1/X=56.52/Y=3.40 DataFldrFP
			else
				SP2_postErrorMsg("No band ratio data found. Did you load both broadband and narrowband data?")
			endif
		//low gain
			//access waves
			setdatafolder $DataFldrFP
			wave /Z BandratioPerc50PkHt=$ksSP2pbpBandratLGPercBnam+mediansuffix	
			wave /Z BandratioPerc50PkHt_Xctr=$ksSP2pbpBandratLGPercBnam+mediansuffix+ksSP2pbpBandratioXctrSuffix
			wave /Z BandratioPerc50PkArea=$ksSP2pbpBandratLGAvgPercBnam+mediansuffix	
			wave /Z BandratioPerc50PkArea_Xctr=$ksSP2pbpBandratLGAvgPercBnam+mediansuffix+ksSP2pbpBandratioXctrSuffix
			legendstr="median of low gain bandratio:"		
			//create graph
			if ( (waveexists(BandratioPerc50PkHt) && waveexists(BandratioPerc50PkHt_Xctr)) || (waveexists(BandratioPerc50PkArea) && waveexists(BandratioPerc50PkArea_Xctr)) )
				Display /W=(470,40,900,355) as "bandratio_stats_lowgain"
					//bandratio from peak heights
					if ( waveexists(BandratioPerc50PkHt) && waveexists(BandratioPerc50PkHt_Xctr) )
						Wnam=NameOfWave(BandratioPerc50PkHt)
						Appendtograph BandratioPerc50PkHt vs BandratioPerc50PkHt_Xctr
						legendstr+="\r\\s("+Wnam+") from peak heights"
						//format graph
						ModifyGraph mode($Wnam)=4
						ModifyGraph marker($Wnam)=19
						ModifyGraph useMrkStrokeRGB($Wnam)=1
						ModifyGraph rgb($Wnam)=(65280,0,0)
					endif
					//bandratio from peak areas
					if ( waveexists(BandratioPerc50PkArea) && waveexists(BandratioPerc50PkArea_Xctr) )
						Wnam=NameOfWave(BandratioPerc50PkArea)
						Appendtograph BandratioPerc50PkArea vs BandratioPerc50PkArea_Xctr
						legendstr+="\r\\s("+Wnam+") from peak areas"
						//format graph
						ModifyGraph mode($Wnam)=4
						ModifyGraph marker($Wnam)=16
						ModifyGraph useMrkStrokeRGB($Wnam)=1
						ModifyGraph rgb($Wnam)=(0,0,65280)
					endif
				//general formatting
				ModifyGraph grid=1
				ModifyGraph log(bottom)=1
				ModifyGraph mirror=2
				ModifyGraph nticks=10
				ModifyGraph standoff=0
				ModifyGraph gridRGB=(0,0,0)
				Label left "Low gain bandratio (broadband : narrowband) [-]"
				Label bottom "Low gain broadband incandescence peak height [d.u.]"
				SetAxis/A/N=1 left
				SetAxis/N=1 bottom 30,10000
				Legend/C/N=text0/J/X=17.39/Y=43.83 legendstr
				TextBox/C/N=text1/X=56.52/Y=3.40 DataFldrFP
			endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2graph_NumbFractCoatVsBroadPH([DataFldrFP])
	//This function creates a graph showing the number fraction of thinly coated particles vs the broadband peak height
	//return value: 0; not used
	//martin.gysel@psi.ch; 27/11/2009
	//joel.c.corbin+sci@gmail.com; 2016-09-20
	string DataFldrFP		//full path to the data folder containing the delay time statistics data
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(DataFldrFP))
		DataFldrFP=SP2_getFolder(startingDF=savedDF, type="PBP")
	endif
	DataFldrFP=ChopLastCharacterOff(DataFldrFP,":")
	//access waves
	setdatafolder $DataFldrFP
	wave /Z DelayNumbFractThin=$ksSP2PBPdelayNumbFractThin
	wave /Z DelayNumbFractThick=$ksSP2PBPdelayNumbFractThick
	wave /Z DelayNumbFractSat=$ksSP2PBPdelayNumbFractSat
	wave /Z DelayNumbFract_Xctr=$ksSP2PBPdelayNumbFractXctr
	if (!WaveExists(DelayNumbFractThin) || !WaveExists(DelayNumbFractThick) || !WaveExists(DelayNumbFractSat) || !WaveExists(DelayNumbFract_Xctr))
		// do calculations for these waves and start over [v4111]
		setdatafolder $savedDF
		SP2_PBPscatt2broadDelayNumbFr("")
		return SP2graph_NumbFractCoatVsBroadPH(DataFldrFP=DataFldrFP)
	endif
	
	//create graph
	Display /W=(90,300.5,553.5,601.25) DelayNumbFractThin vs DelayNumbFract_Xctr as "NumberFractionOfCoated"
	AppendToGraph DelayNumbFractThick,DelayNumbFractSat vs DelayNumbFract_Xctr
	//format graph
	ModifyGraph mode=4
	ModifyGraph marker(DelayNumbFractThin)=19,marker(DelayNumbFractThick)=19,marker(DelayNumbFractSat)=12
	ModifyGraph rgb(DelayNumbFractThin)=(0,0,65280),rgb(DelayNumbFractThick)=(0,52224,0)
	ModifyGraph useMrkStrokeRGB(DelayNumbFractThin)=1,useMrkStrokeRGB(DelayNumbFractThick)=1
	ModifyGraph grid=1
	ModifyGraph log(bottom)=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Number fraction of particles [-]"
	Label bottom "Broadband incandescence peak height [d.u.]"
	SetAxis/N=1 left 0,1
	SetAxis/A/N=1 bottom
	SP2_addDataFolderTag()
	Legend/C/N=text2/J/X=22.48/Y=37.58 "Number fraction of particles with:\r\\s(DelayNumbFractThin) thin-to-moderate coating\r\\s(DelayNumbFractThick) thick coating"
	AppendText "\\s(DelayNumbFractSat) saturated scattering detector"
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2graph_DelaytimeVsBroadPH([PBPfldrFP])
	//This function creates a graph showing the time delay between scattering and broadband peaks vs the broadband peak height
	//return value: 0; not used
	//martin.gysel@psi.ch; 27/11/2009
	string PBPfldrFP		//full path to the data folder containing the PBP data
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(PBPfldrFP))
		PBPfldrFP=SP2_getFolder(type="PBP")
	endif
	PBPfldrFP=ChopLastCharacterOff(PBPfldrFP,":")
	//access waves
	setdatafolder $PBPfldrFP
	wave DelayTimeScattMax2Broad=$ksSP2PBPdelaytimeMaxS2B			
	wave broad_FitPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
	//create graph
	Display /W=(89.25,204.5,544.5,506) as "DelayTime_vs_broadbandPH"
	Appendtograph DelayTimeScattMax2Broad vs broad_FitPeakHt
	//format graph
	ModifyGraph mode=3
	ModifyGraph marker=8
	ModifyGraph msize=1.5
	ModifyGraph grid=1
	ModifyGraph log(bottom)=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Time difference scattering to broadband peak [s]"
	Label bottom "Broadband incandescence peak height [-]"
	SetAxis/A=2/N=1 left
	Legend/C/N=text0/J/X=5.46/Y=2.99 "\\s(DelayTimeScattMax2Broad) time difference between scattering and broadband peak"
	TextBox/C/N=text1/X=24.65/Y=76.20 PBPfldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2graph_DelaytimeHistogram([PBPfldrFP])
	//This function creates a graph showing a histogram of the time delay between scattering and broadband peak
	//return value: 0; not used
	//martin.gysel@psi.ch; 30/11/2009
	//joel.c.corbin+sci@gmail.com; 2016-09-20 better interaction
	string PBPfldrFP		//full path to the data folder containing the PBP data
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(PBPfldrFP))
		PBPfldrFP=SP2_getFolder(type="PBP")
	endif
	PBPfldrFP=ChopLastCharacterOff(PBPfldrFP,":")
	//access waves
	setdatafolder $PBPfldrFP
	wave /z DelayHistogram=$ksSP2PBPdelayHistogram
	wave /z DelayHistoXctr=$ksSP2PBPdelayHistoXctr
	//if data exist, create graph
	if (waveexists(DelayHistogram) && waveexists(DelayHistoXctr))
		Display /W=(192,322.25,586.5,530.75) as "Delay_Time_Histogram"
		appendtograph DelayHistogram vs DelayHistoXbdr
	else
		// ...otherwise calculate the required waves [user input requested]
		setdatafolder $savedDF
		SP2_PBPscatt2broadDelayHisto("")
		return SP2graph_DelaytimeHistogram(PBPfldrFP=PBPfldrFP)
	endif
	
	//format graph
	ModifyGraph mode=6
	ModifyGraph lSize=3
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Relative frequency [-]"
	Label bottom "Time delay between scattering and broadband peak [s]"
	SetAxis/A/N=1
	Legend/C/N=text0/J/X=1.65/Y=2.38 "\\s(DelayHistogram) histogram of delay times"
	TextBox/C/N=text1/X=36.88/Y=37.14 PBPfldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_YAGpowerModeCBproc(ctrlName,checked) : CheckBoxControl
	//This function updates the global variables corresponding to the check boxes
	//"YAGpowerMode" and "YAGpowerModeInv" on the SP2 toolkit panel.
	//return value: 0; not used
	//martin.gysel@psi.ch; 18/12/2009
	String ctrlName		//name of checkbox control
						//either "YAGpowerConst" or "YAGpowerFromHK"
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar YAGpowerMode=$ksSP2YAGpowerMode
	Nvar YAGpowerModeInv=$ksSP2YAGpowerModeInv
	//write selection to global variables
	strswitch (ctrlName)
		case "YAGpowerConst":
			YAGpowerMode=checked
			break
		case "YAGpowerFromHK":
			YAGpowerMode=!checked
			if (checked)
				SP2_postErrorMsg("WARNING: If the internal SP2 temperature varied during measurement, using HK YAG power is invalid! Correct it manually.")
			endif
			break
		default:
			message="Checkbox-procedure "+currproc+" is only defined for controls with the name 'YAGpowerConst' or 'YAGpowerFromHK'!"
			SP2_abort(message, gotoDF=savedDF)
			break
	endswitch
	YAGpowerModeInv=!YAGpowerMode
	//show/hide control
	SetVariable YAGpowerSV, disable=2*YAGpowerModeInv
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2_BaselineFilterCBproc(ctrlName,checked) : CheckBoxControl
	//This function shows/hides the setvariable for the amplitude of the baseline noise of an SP2 DAQ-channel
	//return value: 0; not used
	//martin.gysel@psi.ch; 07/01/2010, 18/05/2010
	String ctrlName		//name of button control
						//implemented options: see strswitch below
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//ctrlname specific
	string ModePP
	string SetVarNam
	strswitch (ctrlName)
		case "BaselineFilterSCHGCB":
			ModePP=ksSP2baselineFiltermodeSCHG
			SetVarNam="NoiseAmpSCHG"
			break
		case "BaselineFilterBBHGCB":
			ModePP=ksSP2baselineFiltermodeBBHG
			SetVarNam="NoiseAmpBBHG"
			break
		case "BaselineFilterNBHGCB":
			ModePP=ksSP2baselineFiltermodeNBHG
			SetVarNam="NoiseAmpNBHG"
			break
		case "BaselineFilterSPHGCB":
			ModePP=ksSP2baselineFiltermodeSPHG
			SetVarNam="NoiseAmpSPHG"
			break
		case "BaselineFilterSCLGCB":
			ModePP=ksSP2baselineFiltermodeSCLG
			SetVarNam="NoiseAmpSCLG"
			break
		case "BaselineFilterBBLGCB":
			ModePP=ksSP2baselineFiltermodeBBLG
			SetVarNam="NoiseAmpBBLG"
			break
		case "BaselineFilterNBLGCB":
			ModePP=ksSP2baselineFiltermodeNBLG
			SetVarNam="NoiseAmpNBLG"
			break
		case "BaselineFilterSPLGCB":
			ModePP=ksSP2baselineFiltermodeSPLG
			SetVarNam="NoiseAmpSPLG"
			break
		default:			
			message="Checkbox-procedure "+currproc+" is only defined for controls with specific names!"
			print message;print RTStackInfo;abort message	
			break
	endswitch
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar BaselineFilterMode=$ModePP
	//show/hide control
	SetVariable $SetVarNam, disable=2*(!BaselineFilterMode)
	//finish procedure
	setdatafolder $savedDF
	return 0			
End

Function SP2panelPSISubTabTAProc(ctrlName,tabNum) : TabControl
	//note: call this function with "tabNum=-1" (or any other negative value) to hide all controls on the tab control
	String ctrlName
	Variable tabNum
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access global variables/strings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SubTabTAval=$ksSP2subTabTAval	
	Svar CalibMatBCtype=$ksSP2calibMatBCtype
	Nvar BaselineFilterModeSCHG=$ksSP2baselineFiltermodeSCHG
	Nvar BaselineFilterModeSCLG=$ksSP2baselineFiltermodeSCLG
	Nvar BaselineFilterModeBBHG=$ksSP2baselineFiltermodeBBHG
	Nvar BaselineFilterModeNBHG=$ksSP2baselineFiltermodeNBHG
	Nvar BaselineFilterModeBBLG=$ksSP2baselineFiltermodeBBLG
	Nvar BaselineFilterModeNBLG=$ksSP2baselineFiltermodeNBLG
	Nvar BaselineFilterModeSPHG=$ksSP2baselineFiltermodeSPHG
	Nvar BaselineFilterModeSPLG=$ksSP2baselineFiltermodeSPLG
	Nvar SAIgetIt=$ksSP2SAIgetIt
	Nvar PretriggerAvgMode=$ksSP2pretriggeravgmode
	Nvar incfittype=$ksSP2incfittype
	Nvar scattfittype=$ksSP2scattfittype
	Nvar /Z splitSearchMode=$ksSP2splitSearchMode 
	if (!NVAR_Exists(splitSearchMode)) // this is a hack for v4110->v4111a5 upgrades to work... eventually remove it. jcc
		variable/G $ksSP2splitSearchMode=kSP2splitsearchmodedefault; NVAR splitSearchMode
	endif
	//set tab and write value to global variable
	TabControl SP2panelSubTabTA value=tabNum	
	SubTabTAval=tabNum
	//To be shown on tabs 0-2:
	if (tabNum<=2 && tabNum>=0)
		GroupBox PretriggerGB, disable=0
		CheckBox PretriggerMode, disable=0
		CheckBox PretriggerModeInv, disable=0
		SetVariable numbofpretrigger, disable=2*PretriggerAvgMode
	else
		GroupBox PretriggerGB, disable=1
		CheckBox PretriggerMode, disable=1
		CheckBox PretriggerModeInv, disable=1
		SetVariable numbofpretrigger, disable=1
	endif	
	if (tabNum==0)
		//enable controls
		PopupMenu scattfittype, disable=0
		TitleBox SCHGbaselineFilterTB, disable=0
		CheckBox BaselineFilterSCHGCB, disable=0
		SetVariable Npts4scattPeak, disable=2*(scattfittype!=2)
		SetVariable NoiseAmpSCHG, disable=2*!BaselineFilterModeSCHG
		TitleBox SCLGbaselineFilterTB, disable=0
		CheckBox BaselineFilterSCLGCB, disable=0
		SetVariable NoiseAmpSCLG, disable=2*!BaselineFilterModeSCLG
	else
		//hide controls
		PopupMenu scattfittype, disable=1
		TitleBox SCHGbaselineFilterTB, disable=1
		CheckBox BaselineFilterSCHGCB, disable=1
		SetVariable Npts4scattPeak, disable=1
		SetVariable NoiseAmpSCHG, disable=1
		TitleBox SCLGbaselineFilterTB, disable=1
		CheckBox BaselineFilterSCLGCB, disable=1
		SetVariable NoiseAmpSCLG, disable=1
	endif
	//second tab (incandescence)
	if (tabNum==1)
		//enable controls
		PopupMenu incfittype, disable=0
		CheckBox MatchNarrToBroad, disable=2*incfittype
		SetVariable Npts4incPeak, disable=0
		TitleBox BBHGbaselineFilterTB, disable=0
		TitleBox NBHGbaselineFilterTB, disable=0
		TitleBox BBLGbaselineFilterTB, disable=0
		TitleBox NBLGbaselineFilterTB, disable=0
		CheckBox BaselineFilterBBHGCB, disable=0
		CheckBox BaselineFilterNBHGCB, disable=0
		CheckBox BaselineFilterBBLGCB, disable=0
		CheckBox BaselineFilterNBLGCB, disable=0
		SetVariable NoiseAmpBBHG, disable=2*!BaselineFilterModeBBHG
		SetVariable NoiseAmpNBHG, disable=2*!BaselineFilterModeNBHG
		SetVariable NoiseAmpBBLG, disable=2*!BaselineFilterModeBBLG
		SetVariable NoiseAmpNBLG, disable=2*!BaselineFilterModeNBLG
		GroupBox PretriggerGB, disable=0
		CheckBox PretriggerMode, disable=0
		CheckBox PretriggerModeInv, disable=0
	else
		//hide controls
		PopupMenu incfittype, disable=1
		PopupMenu splitsearchmodeMenu, disable=1
		PopupMenu splitposmodeMenu, disable=1
		CheckBox MatchNarrToBroad, disable=1
		SetVariable Npts4incPeak, disable=1
		TitleBox BBHGbaselineFilterTB, disable=1
		TitleBox NBHGbaselineFilterTB, disable=1
		TitleBox BBLGbaselineFilterTB, disable=1
		TitleBox NBLGbaselineFilterTB, disable=1
		CheckBox BaselineFilterBBHGCB, disable=1
		CheckBox BaselineFilterNBHGCB, disable=1
		CheckBox BaselineFilterBBLGCB, disable=1
		CheckBox BaselineFilterNBLGCB, disable=1
		SetVariable NoiseAmpBBHG, disable=1
		SetVariable NoiseAmpNBHG, disable=1
		SetVariable NoiseAmpBBLG, disable=1
		SetVariable NoiseAmpNBLG, disable=1
	endif
	//third tab (split detector)
	if (tabNum==2)
		//enable controls
		PopupMenu splitsearchmodeMenu, disable=0
		PopupMenu splitposmodeMenu, disable=0
		TitleBox SPHGbaselineFilterTB, disable=0
		CheckBox BaselineFilterSPHGCB, disable=0
		SetVariable NoiseAmpSPHG, disable=2*!BaselineFilterModeSPHG
		TitleBox SPLGbaselineFilterTB, disable=0
		CheckBox BaselineFilterSPLGCB, disable=0
		SetVariable NoiseAmpSPLG, disable=2*!BaselineFilterModeSPLG
	else
		//hide controls
		PopupMenu splitsearchmodeMenu, disable=1
		PopupMenu splitposmodeMenu, disable=1
		TitleBox SPHGbaselineFilterTB, disable=1
		CheckBox BaselineFilterSPHGCB, disable=1
		SetVariable NoiseAmpSPHG, disable=1
		TitleBox SPLGbaselineFilterTB, disable=1
		CheckBox BaselineFilterSPLGCB, disable=1
		SetVariable NoiseAmpSPLG, disable=1
	endif
	//fourth tab (scattering at incandescence)
	if (tabNum==3)
		//enable controls
		GroupBox ScattAtIncGB, disable=0
		CheckBox ScattAtIndGetItCB, disable=0
		SetVariable ScattAtIncStartSV, disable=2*!SAIgetIt
		SetVariable ScattAtIncEndSV, disable=2*!SAIgetIt
		PopupMenu SAIincandPrefixPM, disable=2*!SAIgetIt
	else
		//hide controls
		GroupBox ScattAtIncGB, disable=1
		CheckBox ScattAtIndGetItCB, disable=1
		SetVariable ScattAtIncStartSV, disable=1
		SetVariable ScattAtIncEndSV, disable=1
		PopupMenu SAIincandPrefixPM, disable=1
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
End


Function SP2panelPSILoadHKTypeProc(ctrlName,popNum,popStr) : PopupMenuControl
	//martin.gysel@psi.ch; 15/04/2010;
	String ctrlName		//not used
	Variable popNum		//must be provided correctly!
	String popStr			//not used

	//preparations
	string savedDF=getdatafolder(1)
	//access global variable
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LoadHKtype=$ksSP2LoadHKtype
	//write new value to global variable
	LoadHKtype=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function CoincidenceGraph()
	String fldrSav0= GetDataFolder(1)
	wave EventIndex
	make /o/n=(numpnts(EventIndex)) EventIndexDiff=max(-1,EventIndex[p]-EventIndex[p-1])
	Display /W=(387.75,237.5,782.25,622.25) EventIndexDiff as "CoincidenceGraph"
	SetDataFolder fldrSav0
	ModifyGraph mode=2
	ModifyGraph lSize=2
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	SetAxis/N=1 left -744.827586206897,3020.68965517241
	SetAxis/N=1 bottom 1000,2000
	ShowInfo
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 0,300,10000,300
End


function LEOfitLastPtVsBroadPkPosGraph()
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder fldrSav0
	Display /W=(113.25,199.25,623.25,542.75) LEOfitLastPt vs BBHG_FitPeakPos as "LEOfitLastPtVsBroadPkPosGraph"
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	SetDataFolder fldrSav0
	ModifyGraph mode=2
	ModifyGraph lSize=2
	ModifyGraph zColor(LEOfitLastPt)={broad_FitPeakHt,20,500,Rainbow}
	ModifyGraph zColorMin(LEOfitLastPt)=NaN
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Last point of LEO-fit ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "Centre of incandescence peak ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	SetAxis/N=1 left 75.7544757033248,225.524296675192
	SetAxis/N=1 bottom 116.062176165803,210.362694300518
	Cursor/P A LEOfitLastPt 20700
	ShowInfo
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 0,0,300,300
End


Function SP2panelPSIChanConfigProc(ctrlName,popNum,popStr) : PopupMenuControl
	//martin.gysel@psi.ch; 23/04/2010;
	String ctrlName		//used to select the correct channel!
	Variable popNum		//not used
	String popStr			//must be provided correctly!

	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variable
	setdatafolder $ksSP2PathToToolkitPanelFldr
	strswitch(ctrlname)
		case "ChanConfig_0":		
			Svar ChanConfig=$ksSP2chan0config
			break
		case "ChanConfig_1":		
			Svar ChanConfig=$ksSP2chan1config	
			break
		case "ChanConfig_2":		
			Svar ChanConfig=$ksSP2chan2config	
			break
		case "ChanConfig_3":		
			Svar ChanConfig=$ksSP2chan3config	
			break
		case "ChanConfig_4":		
			Svar ChanConfig=$ksSP2chan4config	
			break
		case "ChanConfig_5":		
			Svar ChanConfig=$ksSP2chan5config	
			break
		case "ChanConfig_6":		
			Svar ChanConfig=$ksSP2chan6config	
			break
		case "ChanConfig_7":		
			Svar ChanConfig=$ksSP2chan7config	
			break
		default:
			setdatafolder $savedDF
			message="Undefined 'ctrlname' in procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
	endswitch
	//write new value to global variable
	ChanConfig=popStr
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2_Conc_Time_Series_graph([concfldrfp])
	//this function creates a graph showing the time series of particle number concentrations and BC mass concentration
	//return value: 0; not used
	//martin.gysel@psi.ch; 09/06/2009, 07/01/2011
	//joel.c.corbin+sci@gmail.com; 2016-05-04, change to a date format that doesn't require explanation, add AvgMassDp
	string concfldrfp	//full path to folder containing the PBP data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(concfldrfp))
		concfldrfp=SP2_getFolder(type="ConcTser")
	endif
	//access time stamps
	setdatafolder $concfldrfp
	wave /Z /d TimeCtr=$ksSP2timeSeriesTimeCtr
	//prepare graph
	Display /W=(48.75,65.75,643.5,568.25) as "SP2_Conc_Time_Series"
	//channel definitions etc.
	string chanlist=SP2_ChanListAllDAQ()+SP2_ChanListCombIncandOnly()+SP2_ChanListCombScattOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind
	variable numbavailable=0, massavailable=0, diamavailable=0
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", HideTraceList=""
	string LegendStr1="\\Z10Number concentration:\r"
	string LegendStr2="\\Z10BC mass concentration:\r"
	string LegendStr3="\\Z10Count mean diameter:\r"
	//append special traces
		//totally triggered particles
		setdatafolder $concfldrfp
		wave /Z NumbConc=$ksSP2tottrigPrefix+ksSP2timeSeriesNumbConcBnam
		if (waveexists(NumbConc))
			numbavailable=1
			AppendToGraph/L=leftNumb NumbConc vs TimeCtr
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			HideTraceList+="0;"
			ColourList+="12;"
			ModeList+="0;"
			LstyleList+="11;"
			LegendStr1+="\\s("+tracename+") totally triggered particles\r"
		endif
		//total BC containing or scattering particles particles
		setdatafolder $concfldrfp
		wave /Z NumbConc=$ksSP2BBHGorSCHGprefix+ksSP2timeSeriesNumbConcBnam
		if (waveexists(NumbConc))
			numbavailable=1
			AppendToGraph/L=leftNumb NumbConc vs TimeCtr
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			HideTraceList+="0;"
			ColourList+="13;"
			ModeList+="0;"
			LstyleList+="11;"
			LegendStr1+="\\s("+tracename+") total BC containing or scattering (high gain)\r"
		endif
		//total pure scattering particles
		setdatafolder $concfldrfp
		wave /Z NumbConc=$ksSP2SCHGnotBBHGprefix+ksSP2timeSeriesNumbConcBnam
		if (waveexists(NumbConc))
			numbavailable=1
			AppendToGraph/L=leftNumb NumbConc vs TimeCtr
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			HideTraceList+="0;"
			ColourList+="14;"
			ModeList+="0;"
			LstyleList+="11;"
			LegendStr1+="\\s("+tracename+") purely scattering (high gain)\r"
		endif
	//loop over all channels, append traces and prepare trace formatting lists
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $concfldrfp
		wave /Z NumbConc=$currprefix+ksSP2timeSeriesNumbConcBnam
		wave /Z MassConc=$currprefix+ksSP2timeSeriesMassConcBnam
		wave /Z NumbMeanDpBroad=$currprefix+ksSP2ConcTserNumbMeanDpBnam
		wave /Z MassMeanDpBroad=$currprefix+ksSP2ConcTserMassMeanDpBnam			
		wave /Z avgMassDp=$currprefix+ksSP2ConcTserAvgMassDpBnam			
		//append traces to graph
		if (waveexists(NumbConc))
			numbavailable=1
			AppendToGraph/L=leftNumb NumbConc vs TimeCtr
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			HideTraceList+="0;"
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="0;"
			LegendStr1+="\\s("+tracename+") "+currDescr+"\r"
		endif
		if (waveexists(MassConc))
			massavailable=1
			AppendToGraph/L=leftMass MassConc vs TimeCtr
			HideTraceList+="0;"
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="0;"
			LegendStr2+="\\s("+tracename+") "+currDescr+"\r"
		endif
		if (waveexists(NumbMeanDpBroad))
			diamavailable=1
			AppendToGraph/L=LeftDiam NumbMeanDpBroad vs TimeCtr
			HideTraceList+="0;"
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="0;"
			LegendStr3+="\\s("+tracename+") "+currDescr+" (by number)\r"
		endif
		if (waveexists(MassMeanDpBroad))
			diamavailable=1
			AppendToGraph/L=LeftDiam MassMeanDpBroad vs TimeCtr
			HideTraceList+="0;"
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="11;"
			LegendStr3+="\\s("+tracename+") "+currDescr+" (by mass)\r"
		endif
		if (waveexists(avgMassDp))
			diamavailable=1
			AppendToGraph/L=LeftDiam avgMassDp vs TimeCtr
			HideTraceList+="1;" // hidden--- too much info
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="0;"
			LstyleList+="12;"
			LegendStr3+="\\s("+tracename+") "+currDescr+"(Dp_AvgMass)\r"
		endif
	endfor
	//format graph
		if (numbavailable+massavailable+diamavailable)
			//general
			ModifyGraph margin(left)=71
			ModifyGraph grid=1
//			ModifyGraph dateInfo(bottom)={0,0,-1},dateFormat(bottom)={Default,1,2,2,2,"DayOfMonth/Month/Year",6}
//			Label bottom "Date and Time [DD/MM/YY hh:mm:ss]"
			ModifyGraph dateInfo(bottom)={0,0,-1},dateFormat(bottom)={Default,2,2,2,2,"Year-Month-DayOfMonth",-1} // v4111-- ISO time
			Label bottom ""
			ModifyGraph mirror(bottom)=2
			ModifyGraph nticks(bottom)=10
			ModifyGraph standoff(bottom)=0
			ModifyGraph gridRGB=(0,0,0)
			SetAxis/A/N=1 bottom
			TextBox/C/N=text0/A=LT/X=0.91/Y=65.59 concfldrfp
			//number conc. specific
			if (numbavailable)
				ModifyGraph lblPos(leftNumb)=60
				ModifyGraph freePos(leftNumb)=0
				ModifyGraph axisEnab(leftNumb)={0.7,1}
				Label leftNumb "Number conc. [#/cm?]"
				ModifyGraph mirror(leftNumb)=2
				ModifyGraph nticks(leftNumb)=10
				ModifyGraph standoff(leftNumb)=0
				SetAxis/A=2/N=1/E=1 leftNumb
				LegendStr1=ChopEndingOff(LegendStr1,"\r")
				Legend/C/N=LegendNumb/J/A=MC/X=26.75/Y=35.24 LegendStr1
			endif
			//mass conc. specific
			if (massavailable)
				ModifyGraph lblPos(LeftMass)=60
				ModifyGraph freePos(LeftMass)=0
				ModifyGraph axisEnab(LeftMass)={0.35,0.65}
				Label LeftMass "Mass conc. [g m\S-3\M]"
				ModifyGraph nticks(LeftMass)=10
				SetAxis/A=2/N=1/E=1 LeftMass
				LegendStr2=ChopEndingOff(LegendStr2,"\r")
				Legend/C/N=LegendMass/J/A=MC/X=29.18/Y=6.44 LegendStr2
			endif
			//diameter specific
			if (diamavailable)
				ModifyGraph lblPos(LeftDiam)=60
				ModifyGraph freePos(LeftDiam)=0
				ModifyGraph axisEnab(LeftDiam)={0,0.3}
				Label LeftDiam "Count mean Dp [nm]"
				ModifyGraph mirror(LeftDiam)=2
				ModifyGraph standoff(LeftDiam)=0
				SetAxis/A=2/N=1 LeftDiam
				LegendStr3=ChopEndingOff(LegendStr3,"\r")
				Legend/C/N=LegendDiam/J/A=MC/X=24.16/Y=-34.17 LegendStr3		
			endif
			//trace specific
			ModifyGraph Lstyle=0
			ModifyGraph Lsize=2
			ModifyGraphColouriseList(ColourList, 5)
			ModifyGraphModeList(ModeList)
			// TODO HERE: if (numpnts<2) then (lines+markers) 
			ModifyGraphHideTraceList(HideTraceList)
			ModifyGraphLstyleList(LstyleList)
			ModifyGraph mode=4,marker=19,msize=2 // jcc v4115 -- bad way to do this, but avoids a "blank graph" that confuses the user. 
		else
//			dowindow /K kwTopWin
			textbox/N=SP2toolkitFailNote "Nothing to graph:\rData not found in folder " + getDataFolder(1)	// jcc -- don't silently fail, tell the user why!
		endif
	//finish procedure
	setdatafolder $savedDF
	return 0
End



Function SP2graph_RawTracePlusFitSlider([rawfldrfp, GraphIDstr, Omode])
	//This function creates a slider graph to look at the 4 raw traces of individual data points.
	//martin.gysel@psi.ch; 10/10/2008, 05/05/2010
	//joel.c.corbin+sci@gmail.com; 2015-06-03 --- added detector-type selection
	string rawfldrfp	//full path to the data folder containing the raw data
					//default: current data folder
	string GraphIDstr	//used for graph title and for folder containing variables
					//note: a default name is used if GraphIDstr is not provided
					//note: GraphIDstr must be short and may not contain spaces or underscores
	variable Omode	//0:			prompt if graph/folder with given GraphIDstr does already exist
					//1 (default):	overwrite existing graph
					
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(rawfldrfp))
		rawfldrfp=SP2_getFolder(startingDF=savedDF, type="raw")
	endif
	rawfldrfp=ChopLastCharacterOff(rawfldrfp,":")
	string pbpfldrfp=SP2_RawFldrFP2PBPfldrFP(rawfldrfp)
	if (paramisdefault(Omode))
		Omode=1
	elseif (Omode!=0 && Omode!=1)
		setdatafolder $savedDF
		message="The optional parameter 'Omode' handed over to the function "+currproc+" must be 0 or 1!"
		print message; print RTStackInfo; abort message
	endif
	if (paramisdefault(GraphIDstr))
		GraphIDstr="RawTraceSlider"
	endif
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//various variables and strings
	variable chanind, count=-1
	string chanlist=SP2_ChanListAllDAQ()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string ChanAxisNamList=SP2_ChanListToAbbrevList(chanlist)
	string currprefix, currdescr, currcolour, curraxisnam, currtracenam
	string YMatL="", XMatL="", ColourList="", ModeList="", MarkerList=""
	string MsizeList="", LstyleList="", LsizeList="", YaxisNamList=""
	string YAxisLabelList="", YtraceNamL=""
	string RawTraceTag="_data", FitTraceTag="_fit"	// v4111: used to give & track meaningful trace names
	string Legendstr=rawfldrfp+"\r"
	variable nIncChans=itemsinlist(chanlist)
	//loop over all channels and prepare trace lists etc. for the slider graph
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currdescr=stringfromlist(chanind, DescrList)
		currcolour=stringfromlist(chanind, ChanColourList)
		curraxisnam=stringfromlist(chanind, ChanAxisNamList)
		//raw trace matrix
		setdatafolder $rawfldrfp
		wave /Z RawTraceMat=$currprefix+ksSP2rawtracemat
		if (waveexists(RawTraceMat))
			currtracenam=stringfromlist(chanind, ChanAxisNamList) + RawTraceTag
			count+=1
			setdatafolder $rawfldrfp
			YMatL+=GetWavesDataFolder(RawTraceMat, 4)+";"		
			XMatL+="calculated;"
			ColourList+=currcolour+";"
			ModeList+="0;"
			MarkerList+="19;"
			MsizeList+="4;"
			LstyleList+="0;"
			LsizeList+="2;"
			YtraceNamL+= currtracenam+";"
			YaxisNamList+=curraxisnam+";"
			YAxisLabelList+=currdescr+" [d.u.];"
			Legendstr+="\\s("+currtracenam+")"+currdescr+" (raw trace)\r" // jcc
		endif
		//trace analysis matrix
		if (datafolderexists(pbpfldrfp))
			setdatafolder $pbpfldrfp
			wave /Z FitMatY=$currprefix+ksSP2FitMatY
			wave /Z FitMatX=$currprefix+ksSP2FitMatX
			if ( waveexists(FitMatY) && waveexists( FitMatX) )
				currtracenam=stringfromlist(chanind, ChanAxisNamList) + FitTraceTag
				count+=1
				setdatafolder $rawfldrfp
				YMatL+=GetWavesDataFolder(FitMatY, 4)+";"		
				XMatL+=GetWavesDataFolder(FitMatX, 4)+";"		
				ColourList+=currcolour+";"
				ModeList+="4;"
				MarkerList+="19;"
				MsizeList+="4;"
				LstyleList+="0;"
				LsizeList+="1;"
				YaxisNamList+=curraxisnam+";"
				YtraceNamL+= currtracenam+";"
				YAxisLabelList+=currdescr+" [d.u.];"
				Legendstr+="\\s("+currtracenam+")"+currdescr+" (trace analysis)\r" // jcc change from :: "\\s(Ywave"+num2str(count)+")"+currdescr+" (trace analysis)\r"
			endif
		endif
	endfor	

	if (count < 1) // no raw data was found [v4111]
		display; textbox /c/n=nodatafound/a=mc "No raw data found in "+rawfldrfp
		// actually this should never happen, because fitmat waves should exist
	endif
	
	//further graph definitions	
	string RefPath=rawfldrfp
	string TimeRunType="none"
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=RefPath, XMatL=XMatL, YaxisNamL=YaxisNamList, YwaveNamL=YtraceNamL, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	
	//graph window size
	MoveWindow 42.75,124.25,739.5,532.25
	//general graph formatting
	ModifyGraph margin(left)=290
	ModifyGraph mirror=2
	ModifyGraph standoff=0
	Label bottom "Time ["+num2str(1/SamplingRateRawDataMHz)+" s]" // " ?s]" // jcc
	SetAxis/A/N=1 bottom
	ModifyGraph fstyle(bottom)=1
	
	//legends and text boxes
		LegendStr=ChopEndingOff(LegendStr,"\r")
//		Legend/C/N=text0/J/A=MC/X=15.57/Y=25.42 LegendStr //disabled v4111... legend for each member

		// an easier to read legend: [jcc 4111]
		string shortLeg= "\Z10\\{\"%s\", "+MSSfldrpath+":RefPathStr}\\M\r"
		if (1) 
			shortLeg+= "\[1 \Z20\M raw traces\[1\Z09 \Z20\M\X1\W519 trace analysis"
			TextBox/C/N=abbrevLeg/J/X=1.00/Y=1.00 shortLeg
		else // use symbol of first plotted wave [disabled]
			string firstRawTN= grepList(YtraceNamL, RawTraceTag) // stringFromList(0, YtraceNamL)
			string firstFitTN= grepList(YtraceNamL, FitTraceTag) // stringFromList(1, YtraceNamL)
			print firstRawTN, firstFitTN
			firstRawTN= ifElseStr(itemsInList(firstRawTN)==0, "[N/A]", "\\s(" + stringFromList(0, firstRawTN) +")")
			firstFitTN= ifElseStr(itemsInList(firstFitTN)==0, "[N/A]", "\\s(" + stringFromList(0, firstFitTN) +")")
			shortLeg+= firstRawTN+" raw traces" 
			shortLeg+= firstFitTN+" trace analyses"
			Legend/C/N=text0_1/J/X=1.00/Y=1.00 shortLeg
		endif
		
	//trace specific formatting
	ModifyGraphColouriseList(ColourList, 5, VaxisMode=1)
	ModifyGraphModeList(ModeList)
	ModifyGraphMarkerList(MarkerList)
	ModifyGraphMsizeList(MsizeList)
	ModifyGraphLsizeList(LsizeList)
	ModifyGraphLstyleList(LstyleList)
	
	//axis formatting
	string LeftAxisList=AxisListWithType(4)
	variable nLeftAxis=itemsinlist(LeftAxisList)
	variable aind
	for (aind=0; aind<nLeftAxis; aind+=1)
		CurrAxisNam=stringfromlist(aind,LeftAxisList)
		//axis position
		ModifyGraph freePos($CurrAxisNam)=75*aind
		//axis label
		ModifyGraph lblPos($CurrAxisNam)=60
		Label $CurrAxisNam stringfromlist(WhichListItem(CurrAxisNam, YaxisNamList),YAxisLabelList)
		ModifyGraph fstyle($CurrAxisNam)=1
		//scaling
		SetAxis/N=1 $CurrAxisNam kSP2rawSignalMin,kSP2rawSignalMax
	endfor
	
	// interactive buttons (v4111)
	ControlBar 58
//	Button btn_reset,pos={639,2},size={31,52},proc=SP2_btnp_rawSliderViewOpts,title="re-\rset"
//	Button btn_reset,fColor=(64768,64768,64768)
	Button btn_reset,pos={633,2},size={38,52},proc=SP2_btnp_rawSliderViewOpts,title="RE-\rSET"
	Button btn_reset,fStyle=1,fColor=(256,256,256),valueColor=(65535,65535,65535)
	Button btn_hideLG,pos={758,2},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide LG"
	Button btn_hideLG,fColor=(58112,61952,65280)
	Button btn_hideHG,pos={758,29},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide HG"
	Button btn_hideHG,fColor=(43520,43520,43520)
	Button btn_hideIncnd,pos={674,2},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide Incnd."
	Button btn_hideIncnd,fColor=(65280,54528,48896)
	Button btn_hideScatt,pos={674,29},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide scatt."
	Button btn_hideScatt,fColor=(65535,65535,65535)
	Button btn_hideNB,pos={844,2},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide NB"
	Button btn_hideNB,fColor=(65280,59904,48896)
	Button btn_hideSP,pos={844,29},size={80,25},proc=SP2_btnp_rawSliderViewOpts,title="Hide SP"
	Button btn_hideSP,fColor=(54528,60928,51712)

	
	// automated procedures (v4111)
	// used to be optional code, now interactive:  set cursor to the last point of the LEO-fit
	CheckBox chkbx_LEOcsrA,title="csr A -> LEO fit pt"
	CheckBox chkbx_LEOcsrA,pos={939,34},size={117,16},value= 0
	CheckBox chkbx_LEOcsrA,proc=chk_LEOonRawSlider, userdata=MSSfldrpath // userdata to be retrieved by procedure
	CheckBox chkbx_LEOcsrA,userdata=  "root:MatSupSlid:RawTraceSlider",value= 0

	// show current trace fit results ---- note that chkb_SP2_showRawTraceFitTab() adds a command to OptionalCurrPtCmd
	CheckBox chk_showPBP,pos={250.00,27.00},size={95.00,15.00},proc=chkb_SP2_showRawTraceFitTab,title="Show PBP info "
	CheckBox chk_showPBP,userdata=  "root:MatSupSlid:RawTraceSlider",value= 0
	
		//assigning optional procedure
			string leofldrfp=SP2_PBPfldrfp2LEOfldrfp(pbpfldrfp)
			string DataWaveFpath=leofldrfp+ksSP2LEOtraceFitSubFldrPP+ksSP2LEOfitLastPt
			// jcc :: detect the trace name of the appropriate scattering detector
			wave /Z dataWave= $DataWaveFpath
			wave /Z SCHG_ClassificationByType= $(leofldrfp+ksSP2LEOtraceFitSubFldrPP+":SCHG_"+ksSP2pbpClassificationByTypeBN)
			string scTraceName= ""
			if (WaveExists(SCHG_ClassificationByType))
				scTraceName= removeEnding(grepList(YtraceNamL, "SCHG_data"),";") // for now we always assume SCHG is desired... 
				if (!strlen(scTraceName))
					scTraceName= removeEnding(grepList(YtraceNamL, "SCLG_data"),";") // try low gain
				endif
			endif
			string SCtraces= grepList(TraceNameList(GraphIDstr, ";", 1), "SC(.{1})G")	// gets (SCLG_data, SCLG_fit, SCHG_data, SCHG_fit) normally
			if (strlen(SCtraces) && grepString(SCtraces, scTraceName) && WaveExists(dataWave)) // trace is on graph & LEO wave exists:
				setdatafolder MSSfldrpath
				string/G OptionalCurrPtCmd_LEO= "MatSupSlidOptProcSetCursor(\""+MSSfldrpath+"\", \""+DataWaveFpath+"\", \""+scTraceName+"\"); "
				SVAR /Z OptionalCurrPtCmd
				if (!SVAR_Exists(OptionalCurrPtCmd))
					string/G OptionalCurrPtCmd
				endif
				OptionalCurrPtCmd= OptionalCurrPtCmd_LEO // overwrite the 'none' dfeault
				ShowInfo
			else
				// no LEO data -- hide button
				CheckBox chkbx_LEOcsrA, value= 0, disable=1
			endif

				
	//finish procedure
	setdatafolder $savedDF
	return 0
end
function SP2_btnp_rawSliderViewOpts(ba) : ButtonControl
// sub-function for SP2graph_RawTracePlusFitSlider()
// joel.c.corbin@gmail.com 2016-02-11
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // clicked
			strswitch(ba.ctrlName)	
				case "btn_reset":
					ModifyGraph hideTrace=0
					rep("SetAxis /W=RawTraceSlider %s kSP2rawSignalMin, kSP2rawSignalMax",  getSmartSortedAxisList(type="left", win="RawTraceSlider"))
					break

				case "btn_hideHG":
					// exclude split detector with [^SP]:
					rep("execute ifelsestr(grepString(\"%s\", \"[^SP]HG\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break

				case "btn_hideLG":
					// hide all LG, excluding split detector LG with [^SP]:
					rep("execute ifelsestr(grepString(\"%s\", \"[^SP]LG\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break

				case "btn_hideNB":
					rep("execute ifelsestr(grepString(\"%s\", \"NB\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break

				case "btn_hideSP":
					rep("execute ifelsestr(grepString(\"%s\", \"SP\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break
					
				case "btn_hideIncnd":
					// hide all incandescent detectors:
					rep("execute ifelsestr(grepString(\"%s\", \"(BB|NB)\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break
				case "btn_hideScatt":
					// hide all scattering detectors:
					rep("execute ifelsestr(grepString(\"%s\", \"SC\"), \"ModifyGraph hideTrace(%s)=1\", \"\")", TraceNameList("", ";", 1) )
					break

			endswitch
	
			break
			
		case -1: 
			break
			
	endswitch

	return 0
End


Function chkb_SP2_showRawTraceFitTab(cba) : CheckBoxControl	// Function btnp_SP2_showRawTraceFitTab(ba) : ButtonControl
// sub-function for SP2graph_RawTracePlusFitSlider()
// joel.c.corbin@gmail.com 2016-02-11
	STRUCT WMCheckboxAction &cba // STRUCT WMButtonAction &ba

	switch( cba.eventCode )
		case 2: // mouse up
		
			// go to slider DF
			DFREF sdf= getDataFolderDFR()
			string MSSfldrpath= cba.userData
			setdatafolder MSSfldrpath
			
			// get PBP folder and current point
			SVAR RefPathStr // raw DF
			SVAR OptionalCurrPtCmd
			NVAR CurrPoint
			
			string optCmd= ";SP2_particle_table(pt=" +MSSfldrpath+":CurrPoint"
			optCmd += ",pbpdf= SP2_RawFldrFP2PBPfldrFP(\""+RefPathStr+"\")+\":\");"
			optCmd += ";DoWindow/F RawTraceSlider;"
			
			if (!cba.checked) // unchecked--remove update cmd and finish
				OptionalCurrPtCmd = replaceString(optCmd, OptionalCurrPtCmd, "")
				break
			endif
			
			// do table
			SP2_particle_table(pt=CurrPoint, pbpdf= SP2_RawFldrFP2PBPfldrFP(RefPathStr)+":")
			
			// make sure  table updates
			if (stringmatch("none", OptionalCurrPtCmd))
				OptionalCurrPtCmd= "" // dont know why martin put that by default... 
			else
				// a command already exists -- leave it there
			endif 
			OptionalCurrPtCmd += optCmd
			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

Function chk_LEOonRawSlider(cba) : CheckBoxControl
// sub-function for SP2graph_RawTracePlusFitSlider()
// joel.c.corbin@gmail.com 2016-02-11
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable checked = cba.checked			
			string MSSfldrpath= cba.userData
			if (!GrepString(MSSfldrpath, "MatSup"))
				// then probably something is wrong... but no error
			endif
			
			if (!DataFolderExists(MSSfldrpath))
				return 0 // silent fail
			endif
			
			// if unchecked, disable command
			setdatafolder $MSSfldrpath
			NVAR CurrPoint
			SVAR OptionalCurrPtCmd
			SVAR OptionalCurrPtCmd_LEO // ends in ;"
			if (checked)
				// add command to superslider's string:
				OptionalCurrPtCmd=OptionalCurrPtCmd_LEO + OptionalCurrPtCmd
				MatSupSlidCurrPtSetVarProc("CPSetVar_RawTraceSlider",CurrPoint,"","") // refresh slider
			else
				// remove command from superslider's string:
				OptionalCurrPtCmd= replaceString(OptionalCurrPtCmd_LEO, OptionalCurrPtCmd, "")
				Cursor/K A	// was just unchecked so assume last cursor invalid
			endif

			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

Function /S SP2_graphtypePMlistrawdata()
	//martin.gysel@psi.ch
	//return string: list of raw data rawgraph types
	
	//create rawgraph type list
	string rawgraphtypelist=""
	rawgraphtypelist+=ksSP2graph0
	rawgraphtypelist+=ksSP2graph1
	//finish procedure
	return rawgraphtypelist
end

Function /S SP2_graphtypePMlistanalyseddata()
	//martin.gysel@psi.ch
	//return string: list of analysed data graph types
	
	//create analysedgraph type list
	string analysedgraphtypelist=""
	analysedgraphtypelist+=ksSP2graph2
	analysedgraphtypelist+=ksSP2graph3
	analysedgraphtypelist+=ksSP2graph33
	analysedgraphtypelist+=ksSP2graph4
	analysedgraphtypelist+=ksSP2graph5
	analysedgraphtypelist+=ksSP2graph6
	analysedgraphtypelist+=ksSP2graph7
	analysedgraphtypelist+=ksSP2graph8
	//finish procedure
	return analysedgraphtypelist
end


Function /S SP2_graphtypePMlistcalibdata()
	//martin.gysel@psi.ch
	//return string: list of calibration data graph types
	
	//create calibgraph type list
	string calibgraphtypelist=""
	calibgraphtypelist+=ksSP2graph9
	calibgraphtypelist+=ksSP2graph10
	calibgraphtypelist+=ksSP2graph11
	calibgraphtypelist+=ksSP2graph12
	calibgraphtypelist+=ksSP2graph13
	calibgraphtypelist+=ksSP2graph14
	calibgraphtypelist+=ksSP2graph38
	//finish procedure
	return calibgraphtypelist
end

Function /S SP2_graphtypePMlistTserData()
	//martin.gysel@psi.ch
	//return string: list of time series data graph types
	
	//create tsergraph type list
	string tsergraphtypelist=""
	tsergraphtypelist+=ksSP2graph18
	tsergraphtypelist+=ksSP2graph34
	tsergraphtypelist+=ksSP2graph19
	tsergraphtypelist+=ksSP2graph20
	//finish procedure
	return tsergraphtypelist
end

Function /S SP2_graphtypePMlistLEOdata()
	//martin.gysel@psi.ch
	//return string: list of leo data graph types
	
	//create leograph type list
	string leographtypelist=""
	leographtypelist+=ksSP2graph24
	leographtypelist+=ksSP2graph17
	leographtypelist+=ksSP2graph27
	leographtypelist+=ksSP2graph23
	leographtypelist+=ksSP2graph25
	leographtypelist+=ksSP2graph26
	leographtypelist+=ksSP2graph21
	leographtypelist+=ksSP2graph22
	leographtypelist+=ksSP2graph28
	leographtypelist+=ksSP2graph29
	leographtypelist+=ksSP2graph30
	leographtypelist+=ksSP2graph31
	leographtypelist+=ksSP2graph32
	//finish procedure
	return leographtypelist
end

// returns a list of SAI-related graph types
Function /S SP2_graphtypePMlistSAIdata()
	//martin.gysel@psi.ch 
	//joel.c.corbin+sci@gmail.com; 2016-09-22
	
	//create leograph type list
	string SAIgraphtypelist=""
	SAIgraphtypelist+=ksSP2graph35 // SAI diameter validation
	SAIgraphtypelist+=ksSP2graph36 // SAI peak amplitudes validation
	SAIgraphtypelist+=ksSP2graph37 // time-resolved scattering
	SAIgraphtypelist+=ksSP2graph39 // SAI calibration of scattering
	
	//finish procedure
	return SAIgraphtypelist
end

Function /S SP2_graphtypePMlistIcecoreData()
	//martin.gysel@psi.ch
	//return string: list of icecore data graph types
	
	//create icecoregraph type list
	string icecoregraphtypelist=""
	icecoregraphtypelist+=ksSP2graph15
	icecoregraphtypelist+=ksSP2graph16
	//finish procedure
	return icecoregraphtypelist
end


Function SP2_graphbutt(ctrlname) : ButtonControl
	//This function creates an SP2 graph according to the selection on the SP2 panel.
	//return value 0; not used
	//martin.gysel@psi.ch; 05/05/2010
	//jcc 2015-06-03
	string ctrlname	//name of button control; used to get the graph type from the corresponding Popmenu control
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message

	//get type of graph to be created
	strswitch (ctrlname)
		case "GraphButtraw":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMraw
			break
		case "GraphButtAnalysed":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePManalysed
			break
		case "GraphButtcalib":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMcalib
			break
		case "GraphButtTser":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMtser
			break
		case "GraphButtIcecore":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMicecore
			break
		case "GraphButtLEO":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMleo
			break
		case "GraphButtSAI":
			ControlInfo /W=$ksSP2toolkitPanelWnam graphtypePMsai
			break
		default:		
			setdatafolder $savedDF
			message="Selected graph type not implemented in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch	
	
	// check that it worked
	if (isnull(S_value))
		SP2_abort("Failed to retrieve panel setting.\r(Did you rename the panel window?)")
	endif
	
	//create graph
	string graphtype=S_value+";" // set by button	
	strswitch (graphtype)
		case ksSP2graph0:
			SP2_Graph_HK_vs_time()
			break
		case ksSP2graph1:
			SP2graph_RawTracePlusFitSlider(Omode=1) 
			break
		case ksSP2graph2:
			SP2graph_NumbSizeDistrBC() 
			break
		case ksSP2graph3:
			SP2graph_MassSizeDistrBC() 
			break
		case ksSP2graph4:
			SP2graph_BandratioVsBroadpkht()
			break
		case ksSP2graph5:
			SP2graph_BCmass_NarrVsBroad() 
			break
		case ksSP2graph6:
			SP2graph_NumbFractCoatVsBroadPH()
			break
		case ksSP2graph7:
			SP2graph_DelaytimeHistogram() 
			break
		case ksSP2graph8:
			SP2graph_DelaytimeVsBroadPH()
			break
		case ksSP2graph9:
			SP2graph_IncandCalibResults(CalibFldrFP=savedDF)
			break
		case ksSP2graph10:
			SP2graph_BandRatioCalibResults(CalibFldrFP=savedDF)
			break
		case ksSP2graph11:
			SP2graph_CountEffCalibResults(CalibFldrFP=savedDF)
			break
		case ksSP2graph12:
			SP2_CalibrationAnalyzerSlider(CalibSummaryFP=savedDF, Omode=0)
			break
		case ksSP2graph13:
			SP2_CalibBCSizeDistSlider(CalibSummaryFP=savedDF, Omode=1)
			break
		case ksSP2graph14:
			SP2graph_ScattCalibFact(CalibSummaryFP=savedDF)
			break
		case ksSP2graph15:
			SP2graph_IceCoreSummary(SummaryFldrFP=savedDF)
			break
		case ksSP2graph16:
			SP2graph_IceCoreSummarySlider(SummaryFldrFP=savedDF)
			break
		case ksSP2graph17:
			SP2_LEOgr_FWHMandSplitPt()
			break
		case ksSP2graph18:
			SP2_Conc_Time_Series_graph()
			break
		case ksSP2graph19:
			SD_LogNormFitNumbSlider()
			break
		case ksSP2graph20:
			SD_LogNormFitMassSlider()
			break
		case ksSP2graph21: 
			SP2_LEOgr_SplitDeltaVsSCHGpkht()
			break
		case ksSP2graph22:
			SP2_LEOgr_VerificationAllChan() 
			break
		case ksSP2graph23:
			SP2_LEOgr_SplitVsSCHGbeamPos()
			break
		case ksSP2graph24:
			SP2_LEOgr_BeamShapeStats() 
			break
		case ksSP2graph25:
			SP2_LEOgr_IncandDelayVsBBHGpkHt() 
			break
		case ksSP2graph26:
			SP2_LEOgr_IncandDelayVsSplitNeg()
			break
		case ksSP2graph27:
			SP2_LEOgr_Split2CentrePosVsTime()
			break
		case ksSP2graph28:
			SP2_LEOgr_OptSizeDistrButt()
			break
		case ksSP2graph29:
			SP2_LEOgr_OptNumbFracSizeDiBtt()
			break
		case ksSP2graph30:
			SP2_LEOgr_BCvolFractHistogram()
			break
		case ksSP2graph31:
			SP2_LEOgr_BCcoatThicknHistogram()
			break
		case ksSP2graph32:
			SP2_LEOgr_DelayTimeHistogram()
			break
		case ksSP2graph33:
			SP2graph_NumbSizeDistrScatt() 
			break
		case ksSP2graph34:
			SD_NumbSizeDistScattSlider()
			break
		case ksSP2graph35:
			SP2_SAIgr_BCdiamScatterPlot()
			break
		case ksSP2graph36:
			SP2_SAIgr_ScattAmpVsIncPkHt() 
			break
		case ksSP2graph37:
			SP2_TimeResolvedSizing() 
			break
		case ksSP2graph38:
			plotParticleBeamAlignment()
			break
		case ksSP2graph39:
			SP2_SAIgr_SAIcalibration()
			break
		case ksSP2graph40:
			break
		case ksSP2graph41:
			break
		default:		
			setdatafolder $savedDF
			message="Selected graph type not implemented in the function "+currproc+"!"
			print message;print RTStackInfo;abort message
			break
	endswitch	
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2graph_IceCoreSummarySlider([SummaryFldrFP, Omode])
	//This function creates a slider graph for the ice data analysis.
	//return value: 0, not used
	//martin.gysel@psi.ch; 23/11/2009
	string SummaryFldrFP	//full path to the data folder containing the summary of the ice core analysis results
							//default: current data folder
	variable Omode	//0 (default):	prompt if graph/folder with given GraphIDstr does already exist
					//1:			overwrite existing graph

	//preparations
	string savedDF=getdatafolder(1)	
	//set defaults
	if (paramisdefault(SummaryFldrFP))
		SummaryFldrFP=savedDF
	endif
	SummaryFldrFP=ChopLastCharacterOff(SummaryFldrFP,":")	
	if (!DataFolderExists(SummaryFldrFP))
		SP2_abort("Ice core data folder not found. Looked in: " + SummaryFldrFP)
	endif	//access general waves
	setdatafolder $SummaryFldrFP
	wave Conc_TimeCtr=$ksSP2icbatchConcTserTimeCtr
	wave SampleID
	//various variables and strings
	variable chanind, count=-1
	string chanlist=SP2_ChanListIceCoreSummary()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currcolour, currDescr
	string YMatL="", XMatL="", TextBoxStr="", ColourList="", ModeList="", MarkerList="", LsizeList="", YaxisNamL="", XaxisNamL=""
	string LegendTop="\Z10Time series of BC mass concentration:"
	string LegendBottom="\Z10BC mass size distribution:"
	string ConcTextBox="\Z10sample ID:\t\t\t \\{"+getwavesdatafolder(sampleID,2)+"[MSSfldrpath:CurrPoint]}"
	variable nIncChans=itemsinlist(chanlist)
	//loop over incandescence channels and prepare trace lists etc. for the graph
	for (chanind=0; chanind<nIncChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currcolour=stringfromlist(chanind, ChanColourList)
		currDescr=stringfromlist(chanind, DescrList)
		setdatafolder $SummaryFldrFP
		wave MassConcTser=$currprefix+ksSP2timeSeriesMassConcBnam
		wave BCmassDistr=$currprefix+ksSP2pbpBCmassdistr
		wave BCdistrDiamMid=$currprefix+ksSP2pbpBCdistrDiamMid
		wave LogNormFitMassDistr=$currprefix+ksSP2pbpLogNormFitMassDistr
		wave LogNormFitDiamMidpt=$currprefix+ksSP2pbpLogNormFitDiamMidpt
		wave LiquidSampleMassConc=$currprefix+ksSP2pbpLiquidSampleMassConc
		wave LiqSampMassConcBelowCut=$currprefix+ksSP2pbpLiqSampMassConcBelowCut
		if (waveexists(LiquidSampleMassConc))
			ConcTextBox+="\r"+currDescr+" [?g/l]:\t\\{RoundToNDigits("+getwavesdatafolder(LiquidSampleMassConc,2)+"[MSSfldrpath:CurrPoint],4)}"
		endif
		if (waveexists(LiqSampMassConcBelowCut))
			ConcTextBox+=" (+\\{RoundToNDigits("+getwavesdatafolder(LiqSampMassConcBelowCut,2)+"[MSSfldrpath:CurrPoint],4)})"		
		endif
		if (waveexists(MassConcTser))
			count+=1
			XMatL+=getwavesdatafolder(Conc_TimeCtr,4)+";"
			YMatL+=getwavesdatafolder(MassConcTser,4)+";"
			LegendTop+="\r\\s(ywave"+num2str(count)+")"+currDescr
			ColourList+=currcolour+";"
			ModeList+="4;"
			LsizeList+="1;"
			MarkerList+="8;"
			YaxisNamL+="LeftConc;"
			XaxisNamL+="bottomTime;"
		endif
		if (waveexists(BCmassDistr) && waveexists(BCdistrDiamMid))
			count+=1
			XMatL+=getwavesdatafolder(BCdistrDiamMid,4)+";"
			YMatL+=getwavesdatafolder(BCmassDistr,4)+";"
			LegendBottom+="\r"+currDescr+":\\s(ywave"+num2str(count)+")measurement"
			ColourList+=currcolour+";"
			ModeList+="4;"
			LsizeList+="1;"
			MarkerList+="8;"
			YaxisNamL+="LeftDistr;"
			XaxisNamL+="bottomDiam;"
			if (waveexists(LogNormFitMassDistr) && waveexists(LogNormFitDiamMidpt))
				count+=1
				XMatL+=getwavesdatafolder(LogNormFitDiamMidpt,4)+";"
				YMatL+=getwavesdatafolder(LogNormFitMassDistr,4)+";"
				LegendBottom+="\\s(ywave"+num2str(count)+")lognormal fit"
				ColourList+=currcolour+";"
				ModeList+="0;"
				LsizeList+="2;"
				MarkerList+="0;"			
				YaxisNamL+="LeftDistr;"
				XaxisNamL+="bottomDiam;"
			endif		
		endif
	endfor
	//further graph definitions
	string GraphIDstr="IceCoreMainSlider"
	string TimeRunPath=":TimeDateAvg"
	string TimeRunType="time"
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, RefPath=SummaryFldrFP, YaxisNamL=YaxisNamL, XMatL=XMatL, XaxisNamL=XaxisNamL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	
//	//access time waves and set units
	setdatafolder $MSSfldrpath
//	wave xwave0
	setscale d 0,0,"dat", xwave0
	//reorder traces
//	ReorderTraces Ywave0,{Ywave2,Ywave5,Ywave8}
	
	//format graph
		//graph window size
		MoveWindow 170.25,59.75,690,674.75
		//general formatting
		ModifyGraph fsize=12
		ModifyGraph log(bottomDiam)=1
		ModifyGraph mirror=2
		ModifyGraph standoff=0
		ModifyGraph lblPos(LeftConc)=70,lblPos(bottomTime)=50,lblPos(LeftDistr)=70,lblPos(bottomDiam)=50
		ModifyGraph freePos(LeftConc)=0
		ModifyGraph freePos(bottomTime)={0,LeftConc}
		ModifyGraph freePos(LeftDistr)=0
		ModifyGraph freePos(bottomDiam)=0
		ModifyGraph axisEnab(LeftConc)={0.65,1}
		ModifyGraph axisEnab(LeftDistr)={0,0.35}
		ModifyGraph dateInfo(bottomTime)={0,0,-1},dateFormat(bottomTime)={Default,1,2,2,2,"DayOfMonth/Month/Year",6}
		ModifyGraph dateInfo(bottomTime)={1,0,-1},dateFormat(bottomTime)={Default,1,2,2,2,"DayOfMonth/Month/Year",6}
		Label LeftConc "BC mass conc. [g m\S-3\M]"
		Label bottomTime "Time [DD/MM/YY hh:mm:ss]"
		Label LeftDistr "Mass size distribution of BC cores\rdM/dlogD\BMEV\M [ug m\S-3\M]"
		Label bottomDiam "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
		SetAxis/A=2/N=1/E=1 LeftConc
		SetAxis/A=2/N=1/E=1 LeftDistr
		//legends and text boxes
		Legend/C/N=text0/J/A=MC/X=-4.08/Y=37.95 LegendTop
		Legend/C/N=text1/J/A=MC/X=-14.53/Y=-23.44 LegendBottom
		TextBox/C/N=text2/A=MC/X=-36.82/Y=-3.71 "\Z10"+SummaryFldrFP
		ConcTextBox=ReplaceString("MSSfldrpath", ConcTextBox, MSSfldrpath)
		TextBox/C/N=text3/A=MC/X=18.41/Y=-4.75 ConcTextBox
		//draw lines
		SetDrawLayer UserFront
		DrawLine 0,0.65,1,0.65
		//trace specific formatting
		ModifyGraph mSize=3
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphMarkerList(MarkerList)
		ModifyGraphLsizeList(LsizeList)
	//finish procedure
	setdatafolder $savedDF
	return 0
end


Function SP2table_CalibIncandFitPkHt([CalibSummaryFldrFP, ChanBit])
	//This function creates a table showing the fitted peak heights of an incandescence calibration
	//martin.gysel@psi.ch; 19/11/2009; 23/11/2009; 07/05/2010
	string CalibSummaryFldrFP	//full path to the data folder containing the calibration summary
								//default: current data folder
	variable	ChanBit				//2:		BBHG
								//4:		NBHG
								//32:	BBLG
								//64:	NBLG
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibSummaryFldrFP))
		CalibSummaryFldrFP=savedDF
	endif
	CalibSummaryFldrFP=ChopLastCharacterOff(CalibSummaryFldrFP,":")
	string ChanPrefix
	if (paramisdefault(ChanBit))
		string PrefixList=SP2_ChanListIncandOnly()
		string DescriptList=SP2_ChanListToDescrShortList((PrefixList))
		string ChanDescript
		variable PopVal
		prompt PopVal, "Select incandescence channel:", popup, DescriptList
		doprompt "Incandescence channel", PopVal
			if (V_flag)
			abort "User cancelled procedure!"
		endif
		ChanPrefix=stringfromlist(PopVal-1,PrefixList)
	else
		ChanPrefix=SP2chanBit2chanPrefix(ChanBit)
	endif
	//access waves
	setdatafolder $CalibSummaryFldrFP
	wave FitPkHt_1e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix1e
	wave FitPkHt_2e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix2e
	wave FitPkHt_3e=$ChanPrefix+ksSP2calibFitPkHt+ksSP2suffix3e
	wave GaussModeMat=$ChanPrefix+ksSP2calibGaussModeMat
	//create table
	Edit/W=(5.25,41.75,855.75,695.75) as ChanPrefix[1,inf]+"CalibFitPkHt_table"
	Appendtotable FitPkHt_1e
	Appendtotable FitPkHt_2e
	Appendtotable FitPkHt_3e
	Appendtotable GaussModeMat
	//format table
	ModifyTable autosize={0, 0, 8, 0, 0}
	//finish procedure
	setdatafolder $savedDF
	return 0
End

Function SP2table_CalibCoef([calibcoeffldrfp])
	//This function creates a graph showing the calibration coefficients.
	//return value: 0; not used
	//martin.gysel@psi.ch; 08/05/2010
	// joel.c.corbin+sci@gmail.com; 2015-09-10
	string calibcoeffldrfp	//full path to the data folder containing the calibration coefficients
						//default: current data folder
					
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(calibcoeffldrfp))
		// jcc -- use selected calibration folder
		SVAR calibFldr= $(ksSP2PathToToolkitPanelFldr + ksSP2calibFldr)
		calibcoeffldrfp= ksSP2PathToCalibDataFldr + calibFldr
		print "Created calibration coefficients table for the currently selected folder ("+calibcoeffldrfp+")"
		string fldrName= calibFldr
	else
		fldrName= calibcoeffldrfp
	endif


	//prepare table
	edit /W=(141,92.75,816,374.75) as "Calib_Coef_table ('" + fldrName +"')"
	//channel definitions etc.
	string chanlist=SP2_ChanListAllDAQ()
	string currprefix
	variable chanind
	variable nChans=itemsinlist(chanlist)
	//loop over all DAQ-channels and append waves to table
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		//access wave
		setdatafolder $calibcoeffldrfp
		wave CalibCoef=$currprefix+ksSP2CalCoefBnam
		//append wave to table
		if (waveexists(CalibCoef))
			AppendToTable CalibCoef
		endif
	endfor
	//append bandratio calibration coefficients
	setdatafolder $calibcoeffldrfp
	wave BandRatioHGcoef=$ksSP2CalBandRatioHGcoef
	if (waveexists(BandRatioHGcoef))
		AppendToTable BandRatioHGcoef
	endif	
	wave BandRatioLGcoef=$ksSP2CalBandRatioLGcoef	
	if (waveexists(BandRatioLGcoef))
		AppendToTable BandRatioLGcoef
	endif
	//format table
	ModifyTable autosize={0, 0, 16, 0, 0}
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_BeamShapeStats([LeoBeamCalibSubFldrFP])
	//This function displays a graph showing the beam shape statistics for the pure scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 22/05/2010, 23/05/2010, 23/02/2011
	string LeoBeamCalibSubFldrFP	//full path to folder containing the beam shape statistics
			//	string LEOfldrfp	//full path to folder containing the LEO-fit data
			//					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LeoBeamCalibSubFldrFP))
		LeoBeamCalibSubFldrFP=SP2_getBeamShapeFolder()
	endif
			//	if (paramisdefault(LEOfldrfp))
			//		LEOfldrfp=savedDF
			//	endif
	//data folders
			//	LEOfldrfp=ChopLastCharacterOff(LEOfldrfp,":")
			//	string LeoBeamCalibSubFldrFP=LEOfldrfp+ksSP2LEObeamDataSubFldrPP
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves from LEO beam and calibration data subfolder
	setdatafolder $LeoBeamCalibSubFldrFP
	wave/Z scatt_BeamShapePerc10=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc10
	wave/Z scatt_BeamShapePerc25=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc25
	wave/Z scatt_BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
	wave/Z scatt_BeamShapePerc75=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc75
	wave/Z scatt_BeamShapePerc90=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc90
	wave/Z scatt_BeamShapeCentrePos=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapeCentrePos
	wave/Z split_BeamShapeSplitPos=$ksSP2beamShapeSplitPrefix+ksSP2LEObeamShapeSplitPos
	wave/Z BBHG_BeamShapeIncEarlyPos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncEarlyPos
	wave/Z BBHG_BeamShapeIncLatePos=$ksSP2BBHGprefix+ksSP2LEObeamShapeIncLatePos
	//make help wave for position lines
	setdatafolder $LeoBeamCalibSubFldrFP
	make /o/n=1 BeamShapePosHelpWav=1	
	//prepare graph
	Display /W=(474.75,68,1044,414.5) as "LEOgraph_BeamShapeStats"
	string ColourList="", LsizeList="", LstyleList="", ModeList=""
	string LegendStr="Beam shape statistics for pure scattering particles:"
	//append traces
	if (waveexists(scatt_BeamShapePerc10))
		AppendToGraph scatt_BeamShapePerc10
		LsizeList+="2;"
		LstyleList+="11;"
		ColourList+="6;"
		ModeList+="0;"
		LegendStr+="\r\\s("+NameOfWave(scatt_BeamShapePerc10)+") 10th/90th percentile"
	endif
	if (waveexists(scatt_BeamShapePerc90))
		AppendToGraph scatt_BeamShapePerc90
		LsizeList+="2;"
		LstyleList+="11;"
		ColourList+="6;"
		ModeList+="0;"
	endif
	if (waveexists(scatt_BeamShapePerc25))
		AppendToGraph scatt_BeamShapePerc25
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="6;"
		ModeList+="0;"
		LegendStr+="\r\\s("+NameOfWave(scatt_BeamShapePerc25)+") 25th/75th percentile"
	endif
	if (waveexists(scatt_BeamShapePerc75))
		AppendToGraph scatt_BeamShapePerc75
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="6;"
		ModeList+="0;"
	endif
	if (waveexists(scatt_BeamShapePerc50))
		AppendToGraph scatt_BeamShapePerc50
		LsizeList+="3;"
		LstyleList+="0;"
		ColourList+="2;"
		ModeList+="0;"
		LegendStr+="\r\\s("+NameOfWave(scatt_BeamShapePerc50)+") median"
	endif
	AppendToGraph /r BeamShapePosHelpWav vs scatt_BeamShapeCentrePos
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="0;"
		ModeList+="1;"
		LegendStr+="\r\\s("+NameOfWave(BeamShapePosHelpWav)+") beam centre"
	AppendToGraph /r BeamShapePosHelpWav vs split_BeamShapeSplitPos
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="4;"
		ModeList+="1;"
		LegendStr+="\r\\s("+NameOfWave(BeamShapePosHelpWav)+"#1) mean split point\r\sa-05     \B(normally left of mode, else split issue (e.g. data need to be inverted)\M"
	AppendToGraph /r BeamShapePosHelpWav vs BBHG_BeamShapeIncEarlyPos
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="1;"
		ModeList+="1;"
		LegendStr+="\r\\s("+NameOfWave(BeamShapePosHelpWav)+"#2) earliest and latest centre of incandescence"
	AppendToGraph /r BeamShapePosHelpWav vs BBHG_BeamShapeIncLatePos
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="1;"
		ModeList+="1;"
		//LegendStr+="\r\\s("+NameOfWave(BeamShapePosHelpWav)+"#3) latest start of incandescence"
	//general formatting
	SetAxis right 0,1
	ModifyGraph mirror(bottom)=2
	ModifyGraph grid=1
	ModifyGraph nticks=10
	ModifyGraph nticks(right)=0
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Scattering amplitude [a.u.]"
	Label bottom "Time ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	SetAxis/A/E=1 right
	//trace specific formatting
	ModifyGraphColouriseList(ColourList, 5)
	ModifyGraphLsizeList(LsizeList)
	ModifyGraphLstyleList(LstyleList)
	ModifyGraphModeList(ModeList)
	//legends and text boxes
	TextBox/C/N=text1 /X=64 /Y=2 LeoBeamCalibSubFldrFP
	Legend/C/N=text0/J/X= -6/Y=1 LegendStr
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function ShowSP2traceCorresp2CursorA([csrA, SliderGr])
	//This function reads the point index of cursor A on the top graph and displays the SP2's raw traces of this data point
	//martin.gysel@psi.ch; 25/05/2010, 
	//joel.c.corbin+sci@gmail.com; 11/3/2015, add marquee feature, 8/11/2018 add support for other panels like timeResSizing
	variable csrA // use to force a specific cursor location
	string SliderGr// Slider graph to use. Defaults to raw trace slider.
	
	//internal settings
	variable defaultMode= 0
	if (ParamIsDefault(SliderGr))
		SliderGr="RawTraceSlider"
		defaultMode= 1
	endif
	
	//end of internal settings				
	//preparations
	string savedDF=getdatafolder(1)
	//get cursor position:
	if (ParamIsDefault(csrA))	
		//look for a marquee first, since only cursors are permanent [v4111]
		GetMarquee
		if (V_flag)
			return SP2_marqueeToTrace()
		endif
	
		if (strlen(CsrInfo(A)))
			variable CursorVal=pcsr(A)
		else
//			ShowInfo // makes problems when no graphs
			SP2_abort("No Marquee nor Cursor A not found on graph " +winList("*","","WIN:"))
		endif
	else
		CursorVal= csrA
	endif
	
	//bring slider graph to front
	dowindow /F $SliderGr
	if (V_flag==0) // no window found, click the "make graph" button:
		if (defaultMode==0)
			SP2_abort("No slider graph with that name was found.")
		endif
		SP2graph_RawTracePlusFitSlider(Omode=1)
	endif
	
	//display current trace
	MatSupSlidCurrPtSetVarProc("CPSetVar_"+SliderGr,CursorVal,"","")
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_IncandDelayVsSplitNeg([LEOfldrfp])
	//This function displays a graph showing the delay of the incandescence peak relative to the split point versus ...
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/05/2010
	string LEOfldrfp	//full path to folder containing the LEO-fit data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LEOfldrfp))
		LEOfldrfp=SP2_getLEOfolder()
	endif
	LEOfldrfp= removeEnding(LEOfldrfp, ":")
	//data folders
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP	
	string PBPfldrfp=SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//PBP folder
		setdatafolder $PBPfldrfp
		wave BBHG_FitPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
		string BBHG_FitPeakHtNam=nameofwave(BBHG_FitPeakHt)
		wave SPHG_NegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
		string SPHG_NegPeakHtNam=nameofwave(SPHG_NegPeakHt)
		//LEO beam and calibration data subfolder
		setdatafolder $LeoBeamCalibSubFldrFP
		wave Split2incandDelta=$ksSP2LEOsplit2incandDelta	
		string Split2incandDeltaNam=nameofwave(Split2incandDelta)
		wave FitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
		string FitSplit2centreDeltaNam=nameofwave(FitSplit2centreDelta)
	//create graph
	Display /W=(104.25,104.75,694.5,506.75) as "IncandDelay_vs_SPHGnegPkHt"
	AppendToGraph Split2incandDelta vs SPHG_NegPeakHt
	AppendToGraph FitSplit2centreDelta vs SPHG_NegPeakHt
	//format graph
	ModifyGraph mode($Split2incandDeltaNam)=2
	ModifyGraph lSize=2
	ModifyGraph rgb($FitSplit2centreDeltaNam)=(0,0,0)
	ModifyGraph zColor($Split2incandDeltaNam)={BBHG_FitPeakHt,*,*,Rainbow}
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	Label left "Centre of incandescence peak - split point ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "Negative peak height of high gain split detector [d.u.]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	ColorScale/C/N=text0/A=MC/X=-35.81/Y=5.24 trace=Split2incandDelta
	AppendText "High gain broadband peak height [d.u.]"
	Legend/C/N=text1/J/A=MC/X=10.47/Y=43.23 "\\s("+Split2incandDeltaNam+") time lag from split point to centre of incandescence peak"
	AppendText "\\s("+FitSplit2centreDeltaNam+") beam centre according to split detector"
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_IncandDelayVsBBHGpkHt([LEOfldrfp])
	//This function displays a graph showing the delay of the incandescence peak relative to the split point versus ...
	//return value: 0; not used
	//martin.gysel@psi.ch; 26/05/2010
	string LEOfldrfp	//full path to folder containing the LEO-fit data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LEOfldrfp))
		LEOfldrfp= SP2_getLEOfolder()
	endif
	LEOfldrfp= removeEnding(LEOfldrfp,":")
	//data folders
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP	
	string PBPfldrfp=SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp)
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//PBP folder
		setdatafolder $PBPfldrfp
		wave BBHG_FitPeakHt=$ksSP2BBHGprefix+ksSP2PBPtracefitPeakHt
		string BBHG_FitPeakHtNam=nameofwave(BBHG_FitPeakHt)
		wave SPHG_NegPeakHt=$ksSP2SPHGprefix+ksSP2PBPsplitNegPeakHt				
		string SPHG_NegPeakHtNam=nameofwave(SPHG_NegPeakHt)
		//LEO beam and calibration data subfolder
		setdatafolder $LeoBeamCalibSubFldrFP
		wave Split2incandDelta=$ksSP2LEOsplit2incandDelta	
		string Split2incandDeltaNam=nameofwave(Split2incandDelta)
		wave FitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
		string FitSplit2centreDeltaNam=nameofwave(FitSplit2centreDelta)
	//create graph
	Display /W=(350.25,265.25,926.25,638) as "IncandDelay_vs_BBHGpkHt"
	AppendToGraph Split2incandDelta vs BBHG_FitPeakHt
	AppendToGraph FitSplit2centreDelta vs BBHG_FitPeakHt
	//format graph
	ModifyGraph mode($Split2incandDeltaNam)=2
	ModifyGraph lSize=2
	ModifyGraph rgb($FitSplit2centreDeltaNam)=(0,0,0)
	ModifyGraph zColor($Split2incandDeltaNam)={SPHG_NegPeakHt,*,*,Rainbow,1}
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph log(bottom)=1
	Label left "Centre of incandescence peak - split point ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	Label bottom "High gain broadband peak height [d.u.]"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	ColorScale/C/N=text0/A=MC/X=39.38/Y=-0.72 trace=Split2incandDelta
	AppendText "Negative peak height of high gain split detector [d.u.]"
	Legend/C/N=text1/J/A=MC/X=-10.00/Y=42.00 "\\s("+Split2incandDeltaNam+") time lag from split point to centre of incandescence peak"
	AppendText "\\s("+FitSplit2centreDeltaNam+") beam centre according to split detector"
	TextBox/C/N=text2/X=56.94/Y=19.85 PBPfldrfp
	//finish procedure
	setdatafolder $savedDF
	return 0
End



Function /S SP2_MiePureScattDataFldrList()
	//return string: list of names of folders containing Mie data for purely scattering particles
	//martin.gysel@psi.ch; 02/06/2010

	//get list of Mie data subfolders
	string MieDataFldrList=ListOfAllFolders(ksSP2PathToMiePureScattFldr, PathMode=0)
	//sort list
	MieDataFldrList=SortList(MieDataFldrList)
	//remove trailing ":"
	MieDataFldrList=replacestring(":;",MieDataFldrList,";")
	//finish procedure
	return MieDataFldrList
End


Function /S SP2_MieCoatedBCdataFldrList()
	//return string: list of names of folders containing Mie data for coated BC particles
	//martin.gysel@psi.ch; 02/06/2010

	//get list of Mie data subfolders
	string MieDataFldrList=ListOfAllFolders(ksSP2PathToMieCoatedBCfldr, PathMode=0)
	//sort list
	MieDataFldrList=SortList(MieDataFldrList)
	//remove trailing ":"
	MieDataFldrList=replacestring(":;",MieDataFldrList,";")
	//finish procedure
	return MieDataFldrList
End



Function SP2_SelectLEORefractpairPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the refractive index pair to be used for the sizing of coated BC particles (LEO-fit results).
	//return value: 0; not used
	//martin.gysel@psi.ch, 02/06/2010
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar LEOrefractIndexPair=$ksSP2leoRefractIndexPair
	//update selected Mie data folder
	LEOrefractIndexPair=popStr
	//determine popNum
	string RefractList=SP2_MieCoatedBCdataFldrList()
	popNum=1+WhichListItem(popStr, RefractList)
	//update all popmenus on the panel
	PopupMenu LEOsizingRefractIndexPair,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_SampleFlowModeCBproc(ctrlName,checked) : CheckBoxControl
	//This function updates the global variables corresponding to the check boxes
	//"SampleFlowMode" and "SampleFlowModeInv" on the SP2 toolkit panel.
	//return value: 0; not used
	//martin.gysel@psi.ch; 09/08/2010
	String ctrlName		//name of checkbox control
						//either "SampleFlowFromINI" or "SampleFlowFromHK"
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SampleFlowMode=$ksSP2sampleFlowMode
	//write selection to global variables
	strswitch (ctrlName)
		case "SampleFlowFromHK":
			if (checked)
				SampleFlowMode=0
			else
				SampleFlowMode=1
			endif
			break
		case "SampleFlowFromINI":
			if (checked)
				SampleFlowMode=1
			else
				SampleFlowMode=2
			endif
			break
		case "SampleFlowFromConst":
			if (checked)
				SampleFlowMode=2
			else
				SampleFlowMode=0
			endif
			break
		default:			
			setdatafolder $savedDF
			message="Checkbox-procedure "+currproc+" is only defined for controls with the name 'SampleFlowFromINI' , 'SampleFlowFromConst' or 'SampleFlowFromHK'!"
			print message; print RTStackInfo; abort message
			break
	endswitch
	//update panel controls
	CheckBox SampleFlowFromHK, value=SampleFlowMode==0
	CheckBox SampleFlowFromINI, value=SampleFlowMode==1
	CheckBox SampleFlowFromConst, value=SampleFlowMode==2
	SetVariable SampleFlowSV, disable=2*(SampleFlowMode!=2)		//show/hide SetVariable for sample flow rate
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2_SelectLEOincandPrefixPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the incandescence channels to be used for determining the BC core diameter required for the sizing of coated BC particles (LEO-fit results).
	//return value: 0; not used
	//martin.gysel@psi.ch, 12/08/2010
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar LEOincandPrefix=$ksSP2leoIncandPrefix
	//update selected incandescence channel prefix
	LEOincandPrefix=popStr
	//determine popNum
	string IncChanList=SP2_ChanListIncandOnly()+SP2_ChanListCombIncandOnly()
	popNum=1+WhichListItem(popStr, IncChanList)
	//update all popmenus on the panel
	PopupMenu LEOincandPrefixPM,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_SelectLEOsplitPosPrefixPM(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the split detector channel to be used for determining the split point position required for the LEO-fit trace analysis.
	//return value: 0; not used
	//martin.gysel@psi.ch, 13/01/2011
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar LEOsplitChanPrefix=$ksSP2leoSplitChanPrefix
	//update selected split detector channel prefix
	LEOsplitChanPrefix=popStr
	//determine popNum
	string popList=SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()
	popNum=1+WhichListItem(popStr, popList)
	//update all popmenus on the panel
	PopupMenu LEOsplitPosChanPrefixPM,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_Split2CentrePosVsTime([LEOfldrfp])
	//This function displays a graph showing a time series of the  the split time as derived from all pure scattering particles
	//return value: 0; not used
	//martin.gysel@psi.ch; 13/08/2010
	string LEOfldrfp	//full path to folder containing the LEO-fit data
					//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LEOfldrfp))
		LEOfldrfp=SP2_getLEOfolder()
	endif
	LEOfldrfp=removeEnding(leofldrfp,":")
	//data folders
	string LeoBeamCalibSubFldrFP=leofldrfp+ksSP2LEObeamDataSubFldrPP
	string RawFldrFP=SP2_PBPfldrFP2RawFldrFP(SP2_LEOfldrfp2PBPfldrfp(LEOfldrfp))
	//access panel settings
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SamplingRateRawDataMHz=$ksSP2samplingRateRawDataMHz
	//access waves
		//raw data
		setdatafolder $RawFldrFP
		wave TimeDate=$ksSP2TimeDate
		//LEO beam and calibration data subfolder
		setdatafolder $LeoBeamCalibSubFldrFP
		wave LEOsplit2centreDelta=$ksSP2LEOsplit2centreDeltaScatt			
		string wnam2=nameofwave(LEOsplit2centreDelta)
		wave LEOfitSplit2centreDelta=$ksSP2LEOfitSplit2centreDelta	
		string wnam3=nameofwave(LEOfitSplit2centreDelta)
	//create graph
	Display /W=(98.25,149.75,726,574.25) as "LEO_BeamFWHM_and_SplitTime_graph"
	AppendToGraph/L=leftTimeDiff LEOsplit2centreDelta vs TimeDate
	AppendToGraph/L=leftTimeDiff LEOfitSplit2centreDelta vs TimeDate
	//format graph
	ModifyGraph margin(left)=71
	ModifyGraph mode($wnam2)=2
	ModifyGraph lSize=2
	ModifyGraph rgb($wnam2)=(0,0,65280),rgb($wnam3)=(0,0,0)
	ModifyGraph grid=1
	ModifyGraph mirror=2
	ModifyGraph nticks=10
	ModifyGraph fSize=12
	ModifyGraph standoff=0
	ModifyGraph gridRGB=(0,0,0)
	ModifyGraph lblPos(leftTimeDiff)=60
	ModifyGraph freePos(leftTimeDiff)=0
//	ModifyGraph axisEnab(leftTimeDiff)={0,0.48}
	ModifyGraph dateInfo(bottom)={0,0,-1},dateFormat(bottom)={Default,1,2,2,2,"DayOfMonth/Month/Year",6}
	Label bottom "Date  [DD/MM/YY hh:mm:ss]"
	Label leftTimeDiff "Split point to beam centre delay ["+num2str(1/SamplingRateRawDataMHz)+" ?s]"
	SetAxis/A/N=1 bottom
	Legend/C/N=text1/J/A=MC/X=-32.20/Y=-16.05 "\\Z12\rSplit point to beam centre delay:\r\\s("+wnam2+") all pure scattering particles"
	AppendText "\\s("+wnam3+") values used for LEO-fit"
	TextBox/C/N=text2/A=MC/X=27.94/Y=46.71 LEOfldrfp
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOdiamLimitModeCBproc(ctrlName,checked) : CheckBoxControl
	//This function updates the global variables corresponding to the check boxes
	//"LEOlimitBCcoreDiamCB" and "LEOlimitOptDiamCB" on the SP2 toolkit panel.
	//return value: 0; not used
	//martin.gysel@psi.ch; 10/09/2010
	String ctrlName		//name of checkbox control
						//either "LEOlimitBCcoreDiamCB" or "LEOlimitOptDiamCB"
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LEOlimitBCdiamCB=$ksSP2leoLimitBCdiamCB
	Nvar  LEOlimitOptdiamCB=$ksSP2leoLimitOptDiamCB
	//write selection to global variables
	strswitch (ctrlName)
		case "LEOlimitBCcoreDiamCB":
			LEOlimitBCdiamCB=checked
			if (checked)
				//only one CB can be checked
				LEOlimitOptdiamCB=0
			endif
			break
		case "LEOlimitOptDiamCB":
			LEOlimitOptdiamCB=checked
			if (checked)
				//only one CB can be checked
				LEOlimitBCdiamCB=0
			endif
			break
		default:			
			setdatafolder $savedDF
			message="Undefinded ctrlName in procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
	endswitch
	//show/hide controls
	dowindow /F $ksSP2toolkitPanelWnam
	if ( !LEOlimitBCdiamCB && !LEOlimitOptdiamCB)
		SetVariable LEOdiamMinSV, disable=2
		SetVariable LEOdiamMaxSV, disable=2  		
	else
		SetVariable LEOdiamMinSV, disable=0
		SetVariable LEOdiamMaxSV, disable=0
	endif
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2_LEOgr_BCvolFractHistogram([LeoMainSubFldrFP])
	//This function displays a histogram of BC volume fractions obtained from the LEO-fit analysis
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//prepare graph
	Display /W=(486,44.75,858.75,259.25) as "BC volume fraction histogram"
	//various preparations
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10BC volume fraction from LEO-fit to:\r"
	//loop over all channels, append traces and prepare trace formatting lists
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $LeoMainSubFldrFP
		wave /Z BCvolumeFractHist=$currprefix+ksSP2LEObcVolFractHist
		//append traces to graph
		if (waveexists(BCvolumeFractHist))
			AppendToGraph BCvolumeFractHist
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+" channel\r"
		endif
	endfor
	//format graph 
		//general
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Frequency of occurence [-]"
		Label bottom "Volume fraction of BC [-]"
		//trace specific
		ModifyGraph marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLstyleList(LstyleList)
		ModifyGraphLsizeList(LsizeList)
		//Legends and text boxes
		LegendStr=ChopEndingOff(LegendStr,"\r")
		Legend/C/N=LegendNumb/J/A=MC/X=15.19/Y=31.16 LegendStr
		TextBox/C/N=text1/A=MC/X=11.65/Y=8.84 LeoMainSubFldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End



Function SP2_LEOgr_BCcoatThicknHistogram([LeoMainSubFldrFP])
	//This function displays a histogram of BC coating thickness obtained from the LEO-fit analysis
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//prepare graph
	Display /W=(486,281.75,858.75,496.25) as "BC coating thickness histogram"
	//various preparations
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10BC coating thickness from LEO-fit to:\r"
	//loop over all channels, append traces and prepare trace formatting lists
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $LeoMainSubFldrFP
		wave /Z BCcoatingThicknHist=$currprefix+ksSP2LEObcCoatThicknHist
		//append traces to graph
		if (waveexists(BCcoatingThicknHist))
			AppendToGraph BCcoatingThicknHist
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+" channel\r"
		endif
	endfor
	//format graph 
		//general
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		ModifyGraph zero(bottom)=2
		Label left "Frequency of occurence [-]"
		string btmL= "BC coating thickness [nm] for "
		NVAR limitBCcb= $ksSP2PathToToolkitPanelFldr+ksSP2leoLimitBCdiamCB
		if (1 || limitBCcb)
			btmL += "\{\"%g\", ifelse("+ksSP2PathToToolkitPanelFldr+ksSP2leoLimitBCdiamCB+", "+ksSP2PathToToolkitPanelFldr+ksSP2diamRangeMinSV+", 0)} < \f02d\f00\Bvol,rBC\M "
			btmL += "< \{\"%g nm\", ifelse("+ksSP2PathToToolkitPanelFldr+ksSP2leoLimitBCdiamCB+", "+ksSP2PathToToolkitPanelFldr+ksSP2diamRangeMaxSV+", 1000)}\r"
		else // not used, in case user doesnt recreate graph
			btmL += "all BC particles"
		endif
		Label bottom btmL
		//trace specific
		ModifyGraph marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLstyleList(LstyleList)
		ModifyGraphLsizeList(LsizeList)
		//Legends and text boxes
		LegendStr+= "\\JR\\sa+07\\Z08\[0 RI = \\{\"%s\", "+ ksSP2PathToToolkitPanelFldr + ksSP2leoRefractIndexPair +"}\r"
		LegendStr=ChopEndingOff(LegendStr,"\r")
		Legend/C/N=LegendNumb/J/A=MC/X=20/Y=20 LegendStr
		SP2_addDataFolderTag()
	//finish procedure
	setdatafolder $savedDF
	return 0
End



Function SP2_LEOgr_DelayTimeHistogram([LeoMainSubFldrFP])
	//This function displays a histogram of delay times for those particles within the diameter range chosen for the LEO-fit
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//prepare graph
	Display /W=(486,518,858.75,732.5) as "delay time histogram"
	//various preparations
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	string DescrList=SP2_ChanListToDescrShortList(chanlist)
	string ChanColourList=SP2_ChanListToColourList(chanlist)
	string currprefix, currDescr, tracename
	variable chanind
	variable nChans=itemsinlist(chanlist)
	string ColourList="", ModeList="", LstyleList="", LsizeList=""
	string LegendStr="\\Z10Delay times (LEO-fit D-range only):\r"
	//loop over all channels, append traces and prepare trace formatting lists
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		currDescr=stringfromlist(chanind, DescrList)
		//access waves
		setdatafolder $LeoMainSubFldrFP
		wave /Z DelayTimeHist=$currprefix+ksSP2LEOdelayTimeHist
		//append traces to graph
		if (waveexists(DelayTimeHist))
			AppendToGraph DelayTimeHist
			tracename=laststringfromlist(TraceNameList("", ";", 1))
			ColourList+=stringfromlist(chanind, ChanColourList)+";"
			ModeList+="4;"
			LstyleList+="0;"
			LsizeList+="1;"
			LegendStr+="\\s("+tracename+") "+currDescr+" channel\r"
		endif
	endfor
	//format graph 
		//general
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "Frequency of occurence [-]"
		Label bottom "Time difference scattering to incandescence peak [s]"
		//trace specific
		ModifyGraph marker=11
		ModifyGraphColouriseList(ColourList, 5)
		ModifyGraphModeList(ModeList)
		ModifyGraphLstyleList(LstyleList)
		ModifyGraphLsizeList(LsizeList)
		//Legends and text boxes
		LegendStr=ChopEndingOff(LegendStr,"\r")
		Legend/C/N=LegendNumb/J/A=MC/X=15.19/Y=31.16 LegendStr
		TextBox/C/N=text1/A=MC/X=11.65/Y=8.84 LeoMainSubFldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_OptSizeDistr(LeoMainSubFldrFP, LEOchanPrefix)
	//This function displays the optical size distributions of different particle types from LEO-fit analysis
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/09/2010, 16/09/2010, 26/11/2010, 05/01/2012
	//joel.c.corbin+sci@gmail.com; 2016-02-01 (user friendliness adjustments)
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
	string LEOchanPrefix		//prefix of LEO-fit channel for which graph is to be shown
							//i.e. ":SCHG_" or ":SPHG_"
	//preparations
	string savedDF=getdatafolder(1)
	//various preparations
	string leofldrfp=ParseFilePath(1, LeoMainSubFldrFP, ":", 1, 0)
	string pbpfldrfp=SP2_LEOfldrfp2PBPfldrfp(leofldrfp)
	string ChanDescr=LastStringFromList(LEOchanPrefix)
	string tracename
	variable chanind
	string ColourList="", ModeList="", LstyleList="", LsizeList="", hbFillList="", MarkerList="", MsizeList=""
	//access data
		//LEO-main subfolder
		setdatafolder $LeoMainSubFldrFP
		wave /Z OptDistrDiamMidpt=$LEOchanPrefix+ksSP2LEOoptdistrDiamMid
		wave /Z OptNumbDistrBC=$LEOchanPrefix+ksSP2LEOoptNumbDistrBC
		wave /Z OptNumbDistrBCtiny=$LEOchanPrefix+ksSP2LEOoptNumbDistrBCtiny
		wave /Z OptNumbDistrBCsatInc=$LEOchanPrefix+ksSP2LEOoptNumbDistrBCsatInc
		wave /Z OptNumbDistrBCsatLEO=$LEOchanPrefix+ksSP2LEOoptNumbDistrBCsatLEO
		wave /Z OptNumbDistrScatt=$LEOchanPrefix+ksSP2LEOoptNumbDistrScatt
		wave /Z OptNumbDistrScattTiny=$LEOchanPrefix+ksSP2LEOoptNumbDistrScattTiny	
		wave /Z OptNumbDistrScattInvalRef=$LEOchanPrefix+ksSP2LEOoptNumbDistrScInvalRef
		wave /Z OptNumbDistrScattSatRef=$LEOchanPrefix+ksSP2LEOoptNumbDistrScattSatRef
		wave /Z OptNumbDistrScattSatLEO=$LEOchanPrefix+ksSP2LEOoptNumbDistrScattSatLEO
		wave /Z OptNumbDistrAllValid=$LEOchanPrefix+ksSP2LEOoptNumbDistrAllValid
		wave /Z NumbDistrBCcores=$LEOchanPrefix+ksSP2LEOnumbDistrBCcores					
		Svar /Z LEOverificationSizingInfoStr=$ksSP2LEOverificSizingInfoStr			
		//proceed only if LEO-fit data are available for this channel
		if (!waveexists(OptNumbDistrScatt) && !waveexists(OptNumbDistrBC))
			//missing waves => do nothing
			setdatafolder $savedDF
			return 0
		endif	
		//PBP folder
		string IncandPrefix=StringByKey(ksSP2LEOfitIncandPrefixKey, LEOverificationSizingInfoStr, "=", "\r")		//prefix of BC-channel used for LEO-fit analysis
		IncandPrefix=ReplaceString(" ", IncandPrefix, "")
		setdatafolder $pbpfldrfp
		wave PBPBCDistrDiamMidpt=$IncandPrefix+ksSP2pbpBCdistrDiamMid
		wave PBPBCnumbdistr=$IncandPrefix+ksSP2pbpBCnumbdistr
		wave PBPOptDistrDiamMidptSCHG=$ksSP2SCHGprefix+ ksSP2pbpOptdistrDiamMid
		wave PBPOptNumbDistrSCHG=$ksSP2SCHGprefix+ksSP2pbpOptNumbDistr
		wave PBPOptDistrDiamMidptSCLG=$ksSP2SCLGprefix+ ksSP2pbpOptdistrDiamMid
		wave PBPOptNumbDistrSCLG=$ksSP2SCLGprefix+ksSP2pbpOptNumbDistr
		wave PBPOptDistrDiamMidptSHSL=$ksSP2SHSLprefix+ ksSP2pbpOptdistrDiamMid
		wave PBPOptNumbDistrSHSL=$ksSP2SHSLprefix+ksSP2pbpOptNumbDistr
	//prepare legend strings
	string PrefForLeg=LEOchanPrefix[1,inf]		// prefix of channel used for LEO fit
	string Pref4letter=LEOchanPrefix[1,4]		// 4 letter abbreviation of LEO fit chanel (e.g. SPHG)
	string PrefPBPincand=IncandPrefix[1,inf]	
	string CurrRefPrefix=SP2_LEO_RetrieveRefChanPrefix(LEOchanPrefix, leofldrfp + "'TraceFit'")[1,4] // jcc : // 4 letter abbreviation of LEO fit reference (e.g. SCHG)
//	string LegendOptDistr="Optical size distribution from LEO-fit to "+Pref4letter+" channel:" // jcc changed
	string LegendOptDistr="\\f02dN\\f00/\\f02d\\f00log\f02D\f00\\Bopt,LEO\\M from LEO fits to "+Pref4letter+":"
	string LegendCoreDistr="\r\r\\f02dN\\f00\\BBC\\M/\\f02d\\f00log\f02D\f00\\BMEV(BC)\\M, BC-core size distributions:" // min./max. size from panel applied
	string LegendPBPscatt="\r\rBC-free particle optical size dist from peak heights:"
	string LegendLEOdiagStr= "\\f02dN\\f00/\\f02d\\f00log\f02D\f00\\Bopt,LEO\\M diagnostics--all desired to be zero:"
	//prepare graph
	strswitch (LEOchanPrefix)
		case ksSP2SCHGprefix:
			Display /W=(17.25,68.75,655.5,416.75) as "LEO size distr from SCHG"
			break
		case ksSP2SPHGprefix:
			Display /W=(291,70.25,929.25,418.25) as "LEO size distr from SPHG"
			break
		case ksSP2SCLGprefix:
			Display /W=(17.25,187.25,655.5,535.25) as "LEO size distr from SCLG"
			break
		case ksSP2SPLGprefix:
			Display /W=(296.25,176,934.5,524) as "LEO size distr from SPLG"
			break
	endswitch
	//append traces to graph
	if (waveexists(OptNumbDistrAllValid))
		AppendToGraph OptNumbDistrAllValid vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendOptDistr+="\r\\s("+tracename+") All particles \Z08(BC-containing + BC-free)\M" // jcc change, was: all valid scattering+BC)"
		ModeList+="7;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="1;"
		LstyleList+="0;"
		ColourList+="0;"
		hbFillList+="2;"
	endif
	if (waveexists(OptNumbDistrScatt))
		AppendToGraph OptNumbDistrScatt vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendOptDistr+="\r\\s("+tracename+") BC-free particles \Z08(LOQ not applied)\M" // jcc :: was :: purely scattering particles (all valid)"
		ModeList+="7;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="1;"
		LstyleList+="0;"
		ColourList+="7;"
		hbFillList+="2;"
	endif
	if (waveexists(OptNumbDistrBC))
		AppendToGraph OptNumbDistrBC vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendOptDistr+="\r\\s("+tracename+") BC-containing particles \Z08(applied LOD, not LOQ)\M" // jcc was :: BC particles (all valid)"
		ModeList+="7;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="14;" // "12;" // jcc
		hbFillList+="2;"
	endif
	if (waveexists(OptNumbDistrScatt)) // jcc -- this is a repeat, which ensures Scatt visible even if BC# > scatt#
		AppendToGraph OptNumbDistrScatt vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendOptDistr+=""
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="7;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrBCtiny))
		AppendToGraph OptNumbDistrBCtiny vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") Tiny BC particles \Z08(signal below LOQ)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="15;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrBCsatInc))
		AppendToGraph OptNumbDistrBCsatInc vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") Huge BC particles \Z08(signal saturated, invalid)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="13;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrBCsatLEO))
		AppendToGraph OptNumbDistrBCsatLEO vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") Huge-coating BC particles \Z08(LEO signal saturated, invalid)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="3;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrScattTiny))
		AppendToGraph OptNumbDistrScattTiny vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") Tiny BC-free particles \Z08(LOD < signal < LOQ)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="10;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrScattInvalRef))
		AppendToGraph OptNumbDistrScattInvalRef vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") No-ref BC-free particles \Z08(good LEO fit but "+CurrRefPrefix+" peak below LOD)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="1;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrScattSatRef))
		AppendToGraph OptNumbDistrScattSatRef vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") Sat-ref BC-free particles \Z08(good LEO fit but saturated "+CurrRefPrefix+" peak)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="2;"
		hbFillList+="0;"
	endif
	if (waveexists(OptNumbDistrScattSatLEO))
		AppendToGraph OptNumbDistrScattSatLEO vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendLEOdiagStr+="\r\\s("+tracename+") LEO-saturated BC-free particles \Z08(invalid LEO fit)\M"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="2;"
		ColourList+="5;"
		hbFillList+="0;"
	endif
	if (waveexists(PBPBCnumbdistr)) 
		AppendToGraph PBPBCnumbdistr vs PBPBCDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendCoreDistr+="\r\\s("+tracename+") All particles" // jcc (alternate: BC cores, from incandescent channel")
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="12;"
		hbFillList+="0;"
	endif
	if (waveexists(PBPOptNumbDistrSCHG))
		AppendToGraph PBPOptNumbDistrSCHG vs PBPOptDistrDiamMidptSCHG
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendPBPscatt+="\r\\s("+tracename+") SCHG \\f02dN\\f00\BBC-free\M/\\f02d\\f00log\f02D\f00\\Bopt,SCHG\\M" // jcc :: was: scattering high gain channel"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="8;"
		hbFillList+="0;"		
	endif
	if (waveexists(PBPOptNumbDistrSCLG))
		AppendToGraph PBPOptNumbDistrSCLG vs PBPOptDistrDiamMidptSCLG
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendPBPscatt+="\r\\s("+tracename+") SCLG \\f02dN\\f00\BBC-free\M/\\f02d\\f00log\f02D\f00\\Bopt,SCLG\\M" // jcc :: was : scattering low gain channel"
		ModeList+="0;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="6;"
		hbFillList+="0;"		
	endif
	if (waveexists(PBPOptNumbDistrSHSL))
		AppendToGraph PBPOptNumbDistrSHSL vs PBPOptDistrDiamMidptSHSL
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendPBPscatt+="\r\\s("+tracename+") SHSL \\f02dN\\f00\BBC-free\M/\\f02d\\f00log\f02D\f00\\Bopt,SHSL\\M" // jcc  :: alternate: "SHSL" was: combined SHSL = SCHG + SCLG"
		ModeList+="3;"
		MarkerList+="0;"
		MsizeList+="0;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="9;"
		hbFillList+="0;"		
	endif
	if (waveexists(NumbDistrBCcores))
		AppendToGraph NumbDistrBCcores vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		LegendCoreDistr+="\r\\s("+tracename+") Successful LEO fits" // jcc (alternate: BC cores, from scattering signal")
		ModeList+="4;"
		MarkerList+="19;"
		MsizeList+="3;"
		LsizeList+="2;"
		LstyleList+="0;"
		ColourList+="12;"
		hbFillList+="0;"
		ModifyGraph useMrkStrokeRGB($tracename)=1
		ModifyGraph mrkStrokeRGB($tracename)=(65535,65535,65535)
	endif
	//format graph 
		//general
		Label left "Number size distribution\rdN/dlogD [#/cm\S3\M]"
		Label bottom "Optical diameter (D\\Bopt\\M)\ror\rBC mass equivalent diameter (D\\BMEV\\M) [nm]"
		SetAxis/A/N=1 left
		SetAxis/A/N=1 bottom
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		//trace specific
		ModifyGraph marker=11
		ModifyGraphColouriseList(ColourList, 6)
		ModifyGraphModeList(ModeList)
		ModifyGraphMarkerList(MarkerList)
		ModifyGraphMsizeList(MsizeList)
		ModifyGraphLstyleList(LstyleList)
		ModifyGraphLsizeList(LsizeList)
		ModifyGraphhbFillList(hbFillList)
		//Legends and text boxes
		Legend/C/N=LegendBox/J/X=-10/Y=-1 LegendOptDistr+LegendCoreDistr+LegendPBPscatt // /A=LT
		Legend/C/N=LegendDiags/J/X=-10/Y=-1 LegendLEOdiagStr // jcc change // /A=LB
		TextBox/C/N=FolderPathBox/X=0/Y=0 LeoMainSubFldrFP // /A=RT
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOgr_OptSizeDistrButt([LeoMainSubFldrFP])
	//This function displays the optical size distributions of different particle types from LEO-fit analysis (all available channels)
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//define LEO-fit channels
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nChans=itemsinlist(chanlist)
	//loop over all channels and display the graphs
	string currprefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		SP2_LEOgr_OptSizeDistr(LeoMainSubFldrFP, currprefix)
	endfor
	//finish procedure
	return 0
End


Function SP2_LEOgr_OptNumbFractSizeDistr(LeoMainSubFldrFP, LEOchanPrefix)
	//This function displays the number fraction of particle types vs optical size from LEO-fit analysis
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/09/2010, 16/09/2010, 05/01/2012, 06/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
	string LEOchanPrefix		//prefix of LEO-fit channel for which graph is to be shown
							//i.e. ":SCHG_" or ":SPHG_"
	//preparations
	string savedDF=getdatafolder(1)
	//various preparations
	string leofldrfp=ParseFilePath(1, LeoMainSubFldrFP, ":", 1, 0)
	string pbpfldrfp=SP2_LEOfldrfp2PBPfldrfp(leofldrfp)
	string ChanDescr=LastStringFromList(LEOchanPrefix)
	string tracename
	variable chanind
	string ColourList="", ModeList="", LstyleList="", LsizeList="", hbFillList="", MarkerList="", MsizeList="", toModeList=""
//	string PrefForLeg=LEOchanPrefix[1,inf]
	string Pref4letter=LEOchanPrefix[1,4]
	string LegendStr="Number fractions obtained from LEO-fit to "+Pref4letter+" channel:"
	//access data
	setdatafolder $LeoMainSubFldrFP
	wave /Z OptDistrDiamMidpt=$LEOchanPrefix+ksSP2LEOoptdistrDiamMid
	wave /Z OptNumFracDistrBC=$LEOchanPrefix+ksSP2LEOoptNFDistrBC
	wave /Z OptNumFracDistrBCtiny=$LEOchanPrefix+ksSP2LEOoptNFDistrBCtiny
	wave /Z OptNumFracDistrBCsatInc=$LEOchanPrefix+ksSP2LEOoptNFDistrBCsatInc
	wave /Z OptNumFracDistrBCsatLEO=$LEOchanPrefix+ksSP2LEOoptNFDistrBCsatLEO
	wave /Z OptNumFracDistrScatt=$LEOchanPrefix+ksSP2LEOoptNFDistrScatt
	wave /Z OptNumFracDistrScattTiny=$LEOchanPrefix+ksSP2LEOoptNFDistrScattTiny
	wave /Z OptNumFracDistrScattInvalRef=$LEOchanPrefix+ksSP2LEOoptNFDistrScattInvalRef
	wave /Z OptNumFracDistrScattSatRef=$LEOchanPrefix+ksSP2LEOoptNFDistrScattSatRef
	wave /Z OptNumFracDistrScattSatLEO=$LEOchanPrefix+ksSP2LEOoptNFDistrScattSatLEO
	if (!waveexists(OptDistrDiamMidpt))
		//missing waves => do nothing
		setdatafolder $savedDF
		return 0
	endif	
	//prepare graph
	strswitch (LEOchanPrefix)
		case ksSP2SCHGprefix:
			Display /W=(9.75,246.5,786.75,455) as "LEO number fractions vs size from SCHG"
			break
		case ksSP2SPHGprefix:
			Display /W=(174.75,248,951.75,456.5) as "LEO number fractions vs size from SPHG"
			break
		case ksSP2SCLGprefix:
			Display /W=(11.25,329.75,788.25,538.25) as "LEO number fractions vs size from SCLG"
			break
		case ksSP2SPLGprefix:
			Display /W=(173.25,330.5,950.25,539) as "LEO number fractions vs size from SPLG"
			break
	endswitch
	//append traces to graph
	if (waveexists(OptNumFracDistrScatt))
		AppendToGraph OptNumFracDistrScatt vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="7;"
		hbFillList+="2;"
		ModeList+="7;"
		LstyleList+="0;"
		toModeList+="2;"
		LegendStr+="\r\\s("+tracename+") purely scattering particles (all valid)"
	endif
	if (waveexists(OptNumFracDistrBC))
		AppendToGraph OptNumFracDistrBC vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="12;"
		hbFillList+="2;"
		ModeList+="7;"
		LstyleList+="0;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") BC-containing particles (all valid)"
	endif
	if (waveexists(OptNumFracDistrBCtiny))
		AppendToGraph OptNumFracDistrBCtiny vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="15;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") BC particles with BC mass below threshold (valid)"
	endif
	if (waveexists(OptNumFracDistrBCsatInc))
		AppendToGraph OptNumFracDistrBCsatInc vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="13;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") BC particles with saturated BC signal (invalid)"
	endif
	if (waveexists(OptNumFracDistrBCsatLEO))
		AppendToGraph OptNumFracDistrBCsatLEO vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="3;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") BC particles with saturated LEO-signal (invalid)"
	endif
	if (waveexists(OptNumFracDistrScattTiny))
		AppendToGraph OptNumFracDistrScattTiny vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="10;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") purely scattering particles with tiny ref. scatt. signal (valid)"
	endif
	if (waveexists(OptNumFracDistrScattInvalRef))
		AppendToGraph OptNumFracDistrScattInvalRef vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="1;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") purely scattering particles with invalid ref. scatt. signal (valid)"
	endif
	if (waveexists(OptNumFracDistrScattSatRef))
		AppendToGraph OptNumFracDistrScattSatRef vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="2;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") purely scattering particles with saturated ref. scatt. signal (valid)"
		// ModifyGraph offset($tracename)={0,1}, muloffset($tracename)={0,-1} // jcc disabled--confusing!
	endif
	if (waveexists(OptNumFracDistrScattSatLEO))
		AppendToGraph OptNumFracDistrScattSatLEO vs OptDistrDiamMidpt
		tracename=laststringfromlist(TraceNameList("", ";", 1))
		ColourList+="5;"
		hbFillList+="0;"
		ModeList+="0;"
		LstyleList+="2;"
		toModeList+="0;"
		LegendStr+="\r\\s("+tracename+") purely scattering particles with saturated LEO-signal (invalid)"
	endif
	//format graph 
		//general
		ModifyGraph lSize=2
		ModifyGraph grid=1
		ModifyGraph log(bottom)=1
		ModifyGraph mirror=2
		ModifyGraph nticks=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		ModifyGraph lowTrip(left)=0.001
		Label left "Number fraction [-]"
		Label bottom "Optical diameter (D\\Bopt\\M) [nm]"
		SetAxis/A/E=1 left
		SetAxis/A/N=1 bottom
		//trace specific
		ModifyGraphColouriseList(ColourList, 6)
		ModifyGraphhbFillList(hbFillList)
		ModifyGraphModeList(ModeList)
		ModifyGraphLstyleList(LstyleList)
		ModifyGraphToModeList(toModeList)
		//Legends and text boxes
		Legend/C/N=LegendBox/J/A=LT/X=-1/Y=-1 LegendStr
		TextBox/C/N=TextBox/A=LB/X=-1/Y=0 LeoMainSubFldrFP
	//finish procedure
	setdatafolder $savedDF
	return 0
End

		 
Function SP2_LEOgr_OptNumbFracSizeDiBtt([LeoMainSubFldrFP])
	//This function displays the number fraction of particle types vs optical size from LEO-fit analysis for all available channels
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//define LEO-fit channels
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nChans=itemsinlist(chanlist)
	//loop over all channels and display the graphs
	string currprefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		SP2_LEOgr_OptNumbFractSizeDistr(LeoMainSubFldrFP, currprefix)
	endfor
	//finish procedure
	return 0
End




Function SP2_LEOtbl_NumbConcByType(LeoMainSubFldrFP, LEOchanPrefix)
	//This function the number concentration of different particles types as obtained from LEO-fit analysis for one channel
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/09/2010, 05/01/2012
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
	string LEOchanPrefix		//prefix of LEO-fit channel for which graph is to be shown
							//i.e. ":SCHG_" or ":SPHG_"
	//preparations
	string savedDF=getdatafolder(1)
	//access data
	setdatafolder $LeoMainSubFldrFP
	wave /Z TotalNumbConcTableCol1=$LEOchanPrefix+ksSP2LEOTotalNumbConcTableCol1
	wave /Z TotalNumbConcTableCol2=$LEOchanPrefix+ksSP2LEOTotalNumbConcTableCol2
	//check whether data are available
	if (!waveexists(TotalNumbConcTableCol1) || !waveexists(TotalNumbConcTableCol2))
		//missing waves => do nothing
		setdatafolder $savedDF
		return 0
	endif	
	//prepare table
	strswitch (LEOchanPrefix)
		case ksSP2SCHGprefix:
			edit /W=(19.5,179,600,372.5) as "LEO number concentrations from SCHG"
			break
		case ksSP2SPHGprefix:
			edit /W=(231.75,180.5,812.25,374) as "LEO number concentrations from SPHG"
			break
		case ksSP2SCLGprefix:
			edit /W=(14.25,296,594.75,489.5) as "LEO number concentrations from SCLG"
			break
		case ksSP2SPLGprefix:
			edit /W=(231.75,296.75,812.25,490.25) as "LEO number concentrations from SPLG"
			break
	endswitch
	//append waves to table
	appendtotable totalNumbConcTableCol1,totalNumbConcTableCol2
	//format table 
	ModifyTable format(Point)=1,width(totalNumbConcTableCol1)=320,width(totalNumbConcTableCol2)=157
	//finish procedure
	setdatafolder $savedDF
	return 0
End
		
		
Function SP2_LEOtbl_NumbConcByTypeBtt([LeoMainSubFldrFP])
	//This function the number concentration of different particles types as obtained from LEO-fit analysis for all available channels
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/09/2010
	string LeoMainSubFldrFP	//full path to folder containing the LEO-fit data (":Main" subfolder)
							//default: current data folder
	
	//set defaults
	if (paramisdefault(LeoMainSubFldrFP))
		LeoMainSubFldrFP=SP2_getLEOmainFolder()
	endif
	//define LEO-fit channels
	string chanlist=SP2_ChanListScattOnly()+SP2_ChanListSplitOnly()
	variable nChans=itemsinlist(chanlist)
	//loop over all channels and display the graphs
	string currprefix
	variable chanind
	for (chanind=0; chanind<nChans; chanind+=1)
		currprefix=stringfromlist(chanind, chanlist)
		SP2_LEOtbl_NumbConcByType(LeoMainSubFldrFP, currprefix)
	endfor
	//finish procedure
	return 0
End


Function SP2table_CalibInfoMonodispBC([CalibInfoFldrFP])
	//This function creates a table showing the list of settings applied during a series of monodisperse calibration measurements
	//martin.gysel@psi.ch; 29/09/2010
	string CalibInfoFldrFP	//full path to the data folder containing the calibration info
						//default: current data folder

	//preparations
	string savedDF=getdatafolder(1)
	//set defaults
	if (paramisdefault(CalibInfoFldrFP))
		CalibInfoFldrFP=savedDF
	endif
	CalibInfoFldrFP=ChopLastCharacterOff(CalibInfoFldrFP,":")
	//access waves
	setdatafolder $CalibInfoFldrFP
	wave /Z /t SampleID=$ksSP2_SampleID
	wave /Z /d TimeStartList=$ksSP2_monodi_TimeStartList
	wave /Z /d TimeCentreList=$ksSP2_monodi_TimeCentreList
	wave /Z /d TimeEndList=$ksSP2_monodi_TimeEndList
	wave /Z /t FileDateFirst=$ksSP2_FileDateFirst
	wave /Z /t FileNumFirst=$ksSP2_FileNumFirst
	wave /Z /t FileDateLast=$ksSP2_FileDateLast
	wave /Z /t FileNumLast=$ksSP2_FileNumLast
	wave /Z DiamList=$ksSP2_monodi_DiamList
	wave /Z ConcList=$ksSP2_monodi_ConcList
	wave /Z TClist=$ksSP2_monodi_TClist
	wave /Z PressList=$ksSP2_monodi_PressList	
	wave /Z MassList=$ksSP2_monodi_MassList  
	//create table
	Edit/W=(5.25,41.75,946.5,234.5) as "CalibInfo_Table"
	AppendToTable SampleID,TimeStartList,TimeCentreList,TimeEndList, FileDateFirst,FileNumFirst,FileDateLast,FileNumLast,ConcList
		//DMA only
		if (waveexists(DiamList))
			AppendToTable DiamList
			ModifyTable width(DiamList)=62
		endif
		if (waveexists(TClist))
			AppendToTable TClist
			ModifyTable width(TClist)=37
		endif
		if (waveexists(PressList))
			AppendToTable PressList
			ModifyTable width(PressList)=53
		endif
		//APM only
		if (waveexists(MassList))
			AppendToTable MassList
			ModifyTable width(MassList)=62
		endif
	//further table formatting
	ModifyTable format(Point)=1,format(TimeStartList)=8,width(TimeStartList)=101,format(TimeEndList)=8
	ModifyTable width(TimeEndList)=101,format(TimeCentreList)=8,width(TimeCentreList)=101
	ModifyTable width(FileDateFirst)=69,width(FileNumFirst)=68,width(FileDateLast)=69
	ModifyTable width(FileNumLast)=67,width(ConcList)=53
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_LEOfitFastFitCBproc(ctrlName,checked) : CheckBoxControl
	//This function shows/hides the setvariable for the number of points to be averaged for the fast LEO-fit
	//return value: 0; not used
	//martin.gysel@psi.ch; 16/05/2011
	String ctrlName		//name of button control
						//not used
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar LEOfitFastFit=$ksSP2LEOfitFastFit
	//show/hide control
	SetVariable LEOfitFastNumPtsSV, disable=2*(!LEOfitFastFit)
	SetVariable LEOfitMinNumPntsSV, disable=2*LEOfitFastFit
	//finish procedure
	setdatafolder $savedDF
	return 0			
End



Function SP2_PanelLEOcalibRefScattChanPM(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the reference scattering channel to be used for calibrating the split detector.
	//return value: 0; not used
	//martin.gysel@psi.ch, 23/12/2011
	String ctrlName		//name of button control; used to decide for which PSD channel the calibration reference channel is set to be set
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//proceed depending on control name:
	string popList=SP2_ChanListScattOnly()
	strswitch(ctrlName)
		case "LEOscattPrefixForSPHGcalibPM":
			//access panel globals
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Svar LEOsplitCalChanPrefix=$ksSP2SPHGprefix+ksSP2leoSplitCalChanPrefix
			//update selected split detector channel prefix
			LEOsplitCalChanPrefix=popStr
			//determine popNum
			popNum=1+WhichListItem(popStr, popList)
			//update all popmenus on the panel
			PopupMenu LEOscattPrefixForSPHGcalibPM,mode=popNum
			break				
		case "LEOscattPrefixForSPLGcalibPM":
			//access panel globals
			setdatafolder $ksSP2PathToToolkitPanelFldr
			Svar LEOsplitCalChanPrefix=$ksSP2SPLGprefix+ksSP2leoSplitCalChanPrefix
			//update selected split detector channel prefix
			LEOsplitCalChanPrefix=popStr
			//determine popNum
			popNum=1+WhichListItem(popStr, popList)
			//update all popmenus on the panel
			PopupMenu LEOscattPrefixForSPLGcalibPM,mode=popNum
			break				
		default:					
			setdatafolder $savedDF
			string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
			string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
			string message="Undefined value of the control name 'ctrlName' handed over to the function "+currproc+"!"	
			print message; print RTStackInfo; abort message
	endswitch
	//finish procedure
	setdatafolder $savedDF
	return 0
End


// Allows single-particle inspection of time-resolved sizing data.
Function SP2_TimeResSlider(RefPath, BeamShapeDF, GraphIDstr, Mode)
// Martin.Gysel@psi.ch, 20??-??-??
// joel.c.corbin+sci@gmail.com, 2016-02-14
// 
// todo: allow low gain to be used (an easy way would be to replace all "**HG_")
//
	string RefPath	//full path to SP2 raw data folder
	string GraphIDstr	//ID string for graph slider
	string BeamShapeDF // full path to beam shape data folder--if provided
	variable mode // 0==only beam shape correction, 1==sca cross section, 2==Dopt
	
	string pbpDF= removeEnding(SP2_raw2pbp(RefPath), ":")+":"
	string YMatL="", XMatL="", YaxisSideL="", YaxisNamL="", YwaveNamL=""
	
	// raw data traces
	YMatL+="SCHG_data;SPHG_data;BBHG_data;"
	XMatL+="calculated;calculated;calculated;"
	YaxisSideL+="L;R;L;"
	YaxisNamL+="SCHG;SPHG;BBHG;"
	YwaveNamL+=YMatL

	// products/fits from toolkit
	YMatL+=pbpDF+"SCHG_FitMatY;" + pbpDF+"SPHG_FitMatY;" +pbpDF+"BBHG_FitMatY;"
	XMatL+=pbpDF+"SCHG_FitMatX;" + pbpDF+"SPHG_FitMatX;" +pbpDF+"BBHG_FitMatX;"
	YaxisSideL+="L;L;R;"
	YaxisNamL+="SCHG;SPHG;BBHG;"
	YwaveNamL+="SCHG_fit;SPHG_fit;BBHG_fit;"

	// time-resolved calculations
	YMatL+="SCHG_NormScattAmp;SPHG_NormScattAmp;"
	XMatL+="calculated;calculated;"
	YaxisSideL+="L;L;"
	YaxisNamL+="NormAmp;NormAmp;"
	YwaveNamL+="SCHG_NormAmp;SPHG_NormAmp;"
	
	//optional strings
	string YErrPL=""
	string YErrML=""
	string XaxisSideL=""
	string XaxisNamL=""
	string XErrPL=""
	string XErrML=""
	string RunOffsetL=""
	string TimeRunPath="TimeDate"
	string TimeRunType="time"
	variable Omode=1
	
	
	string savedDF=getdatafolder(1)
	
	//create slider graph	
	GraphIDstr=MatrixSuperSlider(GraphIDstr, YMatL, XMatL=XMatL, RefPath=RefPath, YaxisSideL=YaxisSideL, YaxisNamL=YaxisNamL, YwaveNamL=YwaveNamL, TimeRunPath=TimeRunPath, TimeRunType=TimeRunType, Omode=Omode)
	//full path to slider folder
	string MSSfldrpath="root:"+ksMatSupSlidFldrNam+":"+GraphIDstr[1,inf]
	
	
	//format graph
	if (0) // former manual settings
		ModifyGraph marker=19
		ModifyGraph lSize[0]=2,lSize[1]=2,lSize[2]=2,lSize[3]=4,lSize[4]=4
		ModifyGraph rgb[0]=(0,0,0),rgb[1]=(0,39168,0),rgb[2]=(0,15872,65280)
		ModifyGraph rgb[3]=(43520,43520,43520),rgb[4]=(0,65280,0)
		ModifyGraph msize=5
		ModifyGraph useMrkStrokeRGB=1
		ModifyGraph mirror=2
		ModifyGraph nticks(bottom)=10
		ModifyGraph standoff(bottom)=0
		ModifyGraph gridRGB=(0,0,0)
		ModifyGraph zero(SCHG)=1,zero(SPHG)=1,zero(NormAmp)=1
		ModifyGraph lblPos(SCHG)=60,lblPos(SPHG)=60,lblPos(BBHG)=60,lblPos(NormAmp)=60
		ModifyGraph grid(bottom)=1,grid(SCHG)=1,grid(SPHG)=1,grid(NormAmp)=1
		ModifyGraph freePos(SCHG)=0
		ModifyGraph freePos(SPHG)=0
		ModifyGraph freePos(BBHG)=0  
		ModifyGraph freePos(NormAmp)=0
		ModifyGraph axisEnab(SCHG)={0.35,0.65}
		ModifyGraph axisEnab(SPHG)={0.7,1}
		ModifyGraph axisEnab(BBHG)={0.7,1}
		ModifyGraph axisEnab(NormAmp)={0,0.3}
		SetAxis/A/E=2 SPHG
		SetAxis/A/E=2 BBHG
		SetAxis/E=3 NormAmp 0,*
		ShowInfo
	else // saved from graph
		ModifyGraph mode(SCHG_fit)=3,mode(SPHG_fit)=3,mode(BBHG_fit)=3
		ModifyGraph marker=19
		ModifyGraph lSize(SCHG_data)=2,lSize(SPHG_data)=2,lSize(BBHG_data)=2,lSize(SCHG_fit)=4
		ModifyGraph lSize(SPHG_fit)=4,lSize(SCHG_NormAmp)=3,lSize(SPHG_NormAmp)=3
		ModifyGraph rgb(SCHG_data)=(0,0,0),rgb(SPHG_data)=(0,39168,0),rgb(BBHG_data)=(0,15872,65280)
		ModifyGraph rgb(SCHG_fit)=(0,0,0),rgb(SPHG_fit)=(0,39168,0),rgb(BBHG_fit)=(0,15872,65280)
		ModifyGraph rgb(SCHG_NormAmp)=(0,43520,65280),rgb(SPHG_NormAmp)=(0,65280,0)
		ModifyGraph msize=5
		ModifyGraph useMrkStrokeRGB=1
		ModifyGraph mrkStrokeRGB(SCHG_fit)=(65535,65535,65535),mrkStrokeRGB(SPHG_fit)=(65535,65535,65535)
		ModifyGraph mrkStrokeRGB(BBHG_fit)=(65535,65535,65535)
		ModifyGraph grid(bottom)=1,grid(SCHG)=1,grid(SPHG)=1,grid(NormAmp)=1
		ModifyGraph zero(SCHG)=1,zero(SPHG)=1,zero(NormAmp)=1
		ModifyGraph mirror=2, btLen=3
		ModifyGraph nticks(bottom)=10
		ModifyGraph standoff(bottom)=0
		ModifyGraph gridRGB=(0,0,0)
		ModifyGraph lblPos(SCHG)=60,lblPos(SPHG)=60,lblPos(BBHG)=60,lblPos(NormAmp)=60
		ModifyGraph freePos(SCHG)=0
		ModifyGraph freePos(SPHG)=0
		ModifyGraph freePos(BBHG)=0
		ModifyGraph freePos(NormAmp)=0
		ModifyGraph axisEnab(SCHG)={0.35,0.65}
		ModifyGraph axisEnab(SPHG)={0.7,1}
		ModifyGraph axisEnab(BBHG)={0.7,1}
		ModifyGraph axisEnab(NormAmp)={0,0.3}
		Label bottom "Time [0.4 s]"
		SetAxis/A/E=2 SPHG
		SetAxis/A/E=2 BBHG
		SetAxis/E=3 NormAmp 0,*
		ShowInfo
	endif
	// custom overrides
	MoveWindow 92.25,160.25,839.25,668.75	//graph window size
	autoColourAxes()
	
	Nvar SamplingRateRawDataMHz=$removeEnding(ksSP2PathToToolkitPanelFldr,":")+ksSP2samplingRateRawDataMHz
	Label bottom "Time ["+num2str(1/SamplingRateRawDataMHz)+" s]"

	string modeName
	switch (mode)
		case 0:
			modeName= "beam profile"
			break
		case 1:
			modeName= "scattering cross section"
			break
		case 2:
			modeName= "BC-equivalent optical diameter\r(refractive index from LEO panel)"
	endswitch
	
	textbox /c/n=txtdf/J/A=RT/X=1/Y=1 RefPath
	TextBox/C/N=text0_1/A=MC/X=-35.42/Y=7.09 "\\s(SCHG_data) SCHG\r\\s(BeamShape) Beam shape\r\\Z09(centred using split and baseline,";DelayUpdate
	AppendText "scaled using LEO fit results)"
	textbox/C/N=text2_1/J/A=LT/X=1.00/Y=1.00 "\\s(SPHG_data) SPHG\r\\s(BBHG_data) BBHG"
	textbox/C/N=text0/J/A=MC/X=30.88/Y=-28.65 "scattering normalized to\r" + modeName + "\r\\s(SCHG_NormAmp) SCHG\t\\s(SPHG_NormAmp) SPHG"
	//	textbox/C/N=text0/J/A=MC/X=-35.18/Y=9.16 "\\s(SCHG_data) scattering amplitude"
	
	
	// fancy beam shape stuff
	if (strlen(BeamShapeDF))
		if (!DataFolderExists(BeamShapeDF))
			BeamShapeDF= SP2_getBeamShapeFolder() 
		endif
		DFREF sdf= getDataFolderDFR()
		cd BeamShapeDF
		wave /Z BeamShapePerc50=$ksSP2beamShapeScattPrefix+ksSP2LEObeamShapePerc50
		cd sdf
		if (waveExists(BeamShapePerc50))
			// apppend it to graph
			AppendToGraph /R=BeamShape BeamShapePerc50 /TN=BeamShape
			ModifyGraph /Z axisEnab(BeamShape)={0.35,0.65},freePos(BeamShape)=0
			// AppendToGraph /L=SCHG BeamShapePerc50 /TN=BeamShape	
			ModifyGraph /Z lstyle(BeamShape)=12,lsize(BeamShape)=2,rgb(BeamShape)=(65280,0,52224)
			
			// highlight the beam split pos
			wave /Z beam_split=$replaceString(ksSP2LEObeamShapePerc50, getWaveFullPathStr(BeamShapePerc50), ksSP2LEObeamShapeSplitPos)
			ModifyGraph mode(BeamShape)=4, marker(BeamShape)=43, msize(BeamShape)=0.5 // invisible markers except at split point
			ModifyGraph msize(BeamShape[beam_split[0]])=4, mrkThick(BeamShape[beam_split[0]])=1
			
									// // highlight the LEO fit position --- to do
									// NVAR LEOpct= root:SP2toolkit:panel:LEOfitRange // highest% to include in LEO fit, a la toolkit
						// //			NVAR LEOnum= root:SP2toolkit:panel:LEOfitFastNumPts // shuold in principle highlight this too
									// variable /G p_lastLEO= BinarySearchInterp(HalfBeam, LEOpct/100) + xOffset // this makes most sense to me, very slightly different to Martin's (real valued p)
									// ModifyGraph msize(BeamShape[beam_split[0]])=4, mrkThick(BeamShape[beam_split[0]])=1

			
			SVAR OptionalCurrPtCmd = $MSSfldrpath + ":OptionalCurrPtCmd" // created by MatrixSuperSlider()
			OptionalCurrPtCmd= "SP2_MatSupSlid_scaleBeamByLEO(\""+MSSfldrpath+"\");" // scaling of beam shape to current LEO fit
			SP2_MatSupSlid_scaleBeamByLEO(MSSfldrpath)
		else
			print "// No LEO beam shape detected by function " + GetRTStackInfo(1)
		endif
	endif

	
	//finish procedure
	setdatafolder $savedDF
	return 0
end

// Allows multiple-particle inspection of SP2_TimeResSlider results.
// Run after SP2_TimeResolvedSizing().  OUTPUT== A graph.
function stackTimeResolvedSizing([RawFP, BeamFP, everyNth, mask, SCHGcut, normalize])
// This function is fairly advanced and is intended for custom analysis only.
// It was applied in Corbin and Gysel 2019 "SP2 of tar" paper and related functions are available from jcc by reuqest.
// Requires getCentred=1 to be used with SP2_TimeResolvedSizing()!
//
//  SP2_TimeResolvedSizing(RawFP="root:'20141110x016_SP2':", BeamFP="root:'20141110x016_SP2_PBP':'LEO':'BeamAndCalib':", Mode=1, noGraph=1, noPrint=1, getCentred=1)
//	--> output is a graph based on the pre-existing matrix 'SCHG_NormScattAmp' (name is hard-coded)
// joel.c.corbin+sci@gmail.com, 2018-06-05, 2019-05-27
//
	variable everyNth	// plots every Nth trace only
	string RawFP		// full path to SP2 raw data folder
	string BeamFP		// full path to folder containing the beam shape data
	wave mask			// a wave with np= # of particles. Only particles where isNum(mask[i])==TRUE are plotted.
	variable SCHGcut	// lower cutoff for fitted SCHG peak signal
	variable normalize  // Normalize peaks according to the LEO settings of the toolkit. Set to 0 or 1. "2" is a hidden feature (see code).
	
	// sanitize inputs
	string savedDF=getdatafolder(1)				//remember current data folder
	if (ParamIsDefault(RawFP))
		RawFP= SP2_getFolder(startingDF=savedDF, type="raw")
	endif
	if (ParamIsDefault(BeamFP))
		BeamFP= SP2_getBeamShapeFolder()
	endif
	if (ParamIsDefault(everyNth))
		everyNth= 1
	endif
	if (ParamIsDefault(SCHGcut))
		SCHGcut= get_peak_LOQ("SCHG")
	endif
	RawFP= removeEnding(RawFP,":") + ":"
	BeamFP= removeEnding(BeamFP,":") + ":"
	string PBPfp= removeEnding(SP2_RawFldrFP2PBPfldrFP(RawFP),":") + ":"
	
	// set references
	wave beamShape=		$BeamFP+ "BeamShapePerc50"
	setdatafolder $RawFP
	wave dmat= SCHG_NormScattAmp // should be in the raw folder
	variable np= dimSize(dmat, 0)
	variable nq= dimSize(dmat, 1)
	// references for filtering
	variable V_maxPkEnd= wavemax(SCFitPeakEnd)
	
	// set up filter mask in advance
	wave validMask= SP2getValidCStMask(pbpDF= PBPfp, beamShapeDF= BeamFP, SCHGcut= SCHGcut) // --> maskValidCSt
	if (waveExists(mask))
		// apply filtering mask if provided
		validMask *= mask/mask
	endif
	variable i
	Display
	
	if (wavesum(validMask) > 1e3)
		print "// Disabling advanced graphics in this plot as too many curves will be plotted. To undo, run SetWindow kwTopWin, graphicsTech=0"
		SetWindow kwTopWin, graphicsTech=2; // Disable qt graphics because of all the curves. cf. DisplayHelpTopic "Graphs and High-Resolution Displays"
	endif
	DelayUpdate
	for (i=0; i<np; i+=everyNth)
		if (isNaN(validMask[i]) || validMask[i]==0)
			continue
		endif
																				// if (!isnum(mask[i]))
																					// continue
																				// elseif (SCFitPeakHt[i] < SCHGcut)
																					// continue
																				// elseif (isnan(splitPos[i]))
																					// continue
																				// elseif (isnan(SCFitPeakStart[i]) || SCFitPeakStart[i]==0)
																					// continue
																				// elseif (isnan(SCFitPeakEnd[i]) || SCFitPeakEnd[i]==V_maxPkEnd)
																					// continue
																				// endif
		
		string nxTN= "ScaCS_" + num2istr(i)
		appendtograph dmat[i][] /TN=$nxTN
		
		// one option for normalization:
		variable normFac
		variable normAtPeak=0 // --> NOT USED
		if (normAtPeak)
			MatrixOp /free tmpw= (row(dmat,i))^t
			Smooth 10, tmpw
			normFac= 1 / tmpw[40]
			modifygraph muloffset($nxTN)= {0, normFac}
			// this option seemed a bit? noisy. Perhaps 50% of signal [ie tmpw at p=40]
			// already corresponded to some evaporation.
		endif
		// another option, more intimately tied to the actual toolkit LEO. 
		if (ParamIsDefault(normalize))
			variable normLikeLEO= 0
		else 
			normLikeLEO= normalize
		endif
		switch (normLikeLEO)
			case 1: // norm EXACTLY like LEO
							// see 'extract current trace' line of SP2_LEO_FitWorker_ShapeFast_TS. Key code [lots of other code there too]:
							// 		make/o/FREE/n=(LEOfitFastNumPts) currtrace=tracemat[rowindex][p+LEOfitLastPt+1-LEOfitFastNumPts]
				NVAR LEOfitFastNumPts= $(ksSP2PathToToolkitPanelFldr + ksSP2LEOfitFastNumPts)	
				NVAR LEOfitRange	 = $(ksSP2PathToToolkitPanelFldr + ksSP2LEOfitRange)		// % of mode to fit
				variable p1= getIndex(LEOfitRange/100, beamshape, before=1) +1
				variable p0= p1 - LEOfitFastNumPts 
				
				MatrixOp /free tmpw= (row(dmat,i))^t
				normFac= 1 / wavemean(tmpw, R0= p0, R1= p1)
				modifygraph muloffset($nxTN)= {0, normFac}
				
				break
			case 2: // norm KIND OF like LEO
				p1= getIndex(25/100, beamshape, before=1) +1  // from 20%
				p0= p1 - 5	// back 5 points 
				MatrixOp /free tmpw= (row(dmat,i))^t
				normFac= 1 / wavemean(tmpw, R0= p0, R1= p1)
				modifygraph muloffset($nxTN)= {0, normFac}
				
				break
		endswitch
	endfor
	appendtograph /r /c = (0,0,0) beamshape
	
	// plot tweaks
	Nvar SamplingRateRawDataMHz=$ksSP2PathToToolkitPanelFldr+ksSP2samplingRateRawDataMHz
	Label bottom "Time ["+num2str(1/SamplingRateRawDataMHz)+" s]"
	setAllAlpha(alpha=0.2); ModifyGraph lsize(BeamShapePerc50)=5
//	ModifyGraph log(left)=1;	SetAxis left 0.001, 2	
	ModifyGraph log=0;			SetAxis left 0, 2.5
	
	SP2_addDataFolderTag()
end


// scales a trace called BeamShape on the top graph according to ***a*** LEO fit
function SP2_MatSupSlid_scaleBeamByLEO(superSliderPath)
// to SCHG and corresponding baseline.
// ***If no valid LEO data are found, a custom LEO fit is performed!!!***
// Returns 0==no changes made,
//		1==toolkit LEO value used,
//		2==custom LEO fit used.
string superSliderPath
DFREF sdf= getDataFolderDFR()
cd superSliderPath 

	NVAR /Z CurrPoint
	if (!NVAR_Exists(CurrPoint))
		SP2_abort("no variable 'CurrPoint' found in provided data folder")
	endif
	
	NVAR /Z V_dontRetryScaleLEO
	if (NVAR_Exists(V_dontRetryScaleLEO) && V_dontRetryScaleLEO)
		return -10
	endif

	// find the beam shape trace
	string traces= TraceNameList("", ";", 2^0 + 2^1) // include hidden-- + 2^2) // get all visible traces on top graph
	string beamTrace= removeEnding(grepList(traces, "BeamShape"), ";")
	string SCHG_NormAmp= removeEnding(grepList(traces, "SC.*NormAmp"), ";")
	string SPHG_NormAmp= removeEnding(grepList(traces, "SP.*NormAmp"), ";")
	wave /Z beam= TraceNameToWaveRef("", removeEnding(beamTrace, ";"))
	if (!strlen(beamTrace) || !WaveExists(beam))
		SP2_postErrorMsg("failed to find beam wave -- not scaling time resolved scattering")
		SP2_postErrorMsg("You will need to delete the DF of slider '"+superSliderPath+"'")
		SP2_postErrorMsg("to use this feature in future.")
		variable /G V_dontRetryScaleLEO= 1
		cd sdf
		return 0
	endif
	
	// get PBP folder of slider
	SVAR /Z RefPathStr; SVAR /Z RefPath
	if (strlen(RefPathStr))
		string/G rawDF= RefPathStr
	elseif (strlen(RefPathStr))
		rawDF= RefPath
	endif
	string pbpDF= removeEnding(SP2_raw2pbp(rawDF), ":")+":"
	string beamDF= removeEnding(GetWavesDataFolder(beam, 1), ":")+":"
	
	// get centring info
				// LOGIC---define split as zero:
				// BeamMode-ThisMode===0 when centred, so -->  BeamSplit-ThisSplit===0
				//	actually, BeamSplit + BeamArbOffset - ThisSplit - ThisArbOffset===0,
				// so to centre beam on ThisArbOffset, do -->
				// centred= (BeamArbOffset-ThisArbOffset)= (thisSplit - BeamSplit)
	wave data_split= $pbpDF + "SPHG_CentreSplitPos"
	wave beam_split= $beamDF + "BeamShapeSplitPos"
	variable /G xOffset= data_split[CurrPoint] - beam_split[0]
	
	
	// baseline
	wave offset= $pbpDF + "SCHG_FitOffset"
	variable /G yOffset= offset[CurrPoint]

	// scaling
	wave /Z LEO_fits= $pbpDF + "LEO:TraceFit:SCHG_FitPeakHtAll"
	variable /G yScalar= WaveExists(LEO_fits) ? LEO_fits[CurrPoint] : nan
	
	variable /G LEO_existed=1
	if (isnan(yScalar)) // no LEO data--do custom fit
		LEO_existed=0
	// (note: this code is to be copied to toolkit in future--it is better cause ratio should be before averaging)
		
		NVAR LEOpct= root:SP2toolkit:panel:LEOfitRange 
		NVAR LEOnum= root:SP2toolkit:panel:LEOfitFastNumPts
		variable /G LEOfitpt
//		LEOfitpt= BinarySearchInterp(HalfBeam, LEOpct/100) + xOffset			// this makes most sense to me, very slightly different to Martin's (real valued p)
//		LEOfitpt= isnan(p_lastLEO) ? 0 : p_lastLEO

		// get 3% of beam shape
		FindLevel /P/Q beam, LEOpct/100 			// this is toolkit way (toolkit stops search at beam mode with /R, i cant be arsed)
		if (!V_rising)
			SP2_postErrorMsg("Function error--down slope of beam shape used for LEO fit ::: " + GetRTStackInfo(0))
		endif
		LEOfitpt= V_LevelX
		
		// get the reference to the data to fit
		string scTrace= removeEnding(grepList(traces, "SC(.{1})G_data"), ";")
		wave /Z scdata= TraceNameToWaveRef("", scTrace)
		
		
		// do fit
		make /o/d/n=(LEOnum) LEOslice= scdata(floor(LEOfitpt - LEOnum/2) + p)
		make /o/d/n=(LEOnum) BeamSlice= beam(floor(LEOfitpt - LEOnum/2) - xOffset + p)
		LEOslice = (LEOslice[p]-yOffset) / BeamSlice[p] // pointwise ratio before averaging
		yScalar = waveMean(LEOslice)
		
		// show cursor
		Cursor A, $scTrace, LEOfitpt
	endif
	
	// do it
	variable hackFixedShift20180604=1
	if (hackFixedShift20180604==0) // Shift beam shape to overlap with data [v4112]
		ModifyGraph offset($beamTrace)={xOffset,yOffset}
		ModifyGraph muloffset($beamTrace)={0, yScalar}
	else
		// Shift data to overlap with beam at fixed position [v4113] -- this reflects changes in the actual calcaulations
		ModifyGraph offset={-xOffset,-yOffset}
		ModifyGraph offset($beamTrace)={0,0}
		if (strlen(SCHG_NormAmp) && itemsinList(SCHG_NormAmp)==1)
			ModifyGraph offset($SCHG_NormAmp)={0,0}
		else 
			print "Error 23423efds"
		endif
		if (strlen(SPHG_NormAmp) && itemsinList(SPHG_NormAmp)==1)
			ModifyGraph offset($SPHG_NormAmp)={0,0}
		endif
		// here the muloffset is omitted as the beamShape has its own axis right now.
	endif
	
	// cancel it! if failed...
	ModifyGraph /Z hideTrace($beamTrace)= (yScalar < 0)  ||  isnan(data_split[CurrPoint])

	// wrap up
	cd sdf
end

Function SP2_CheckboxEnabDisabControls(ctrlName,checked) : CheckBoxControl
	//This function enables/disables controls if the checkbox is checked/unchecked
	//return value: 0; not used
	//martin.gysel@psi.ch; 19/05/2011, 13/02/2012
	//note: this function can also be used to set the certain checkboxes.
	String ctrlName		//name of checkbox control; implemented options are:
						//"ScattAtIndGetItCB"
	Variable checked		//1: if checked
						//0: otherwise
	
	//preparations
	string savedDF=getdatafolder(1)
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//access global variables
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Nvar SAIgetIt=$ksSP2SAIgetIt
	//write selection to global variables
	strswitch (ctrlName)
		case "ScattAtIndGetItCB":
			//write value to checkbox
			SAIgetIt=checked
			//show/hide controls
			dowindow /F $ksSP2toolkitPanelWnam
			if (checked)
				SetVariable ScattAtIncStartSV, disable=0
				SetVariable ScattAtIncEndSV, disable=0
				PopupMenu SAIincandPrefixPM, disable=0
			else
				SetVariable ScattAtIncStartSV, disable=2
				SetVariable ScattAtIncEndSV, disable=2			
				PopupMenu SAIincandPrefixPM, disable=2
			endif
			break
		default:			
			setdatafolder $savedDF
			message="Undefinded ctrlName in procedure "+currproc+"!"
			print message; print RTStackInfo; abort message
	endswitch
	//finish procedure
	setdatafolder $savedDF
	return 0			
End


Function SP2_SAIselectIncPrefixPMproc(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the incandescence channel to be used for the incandescence peak position
	//for deteriming the scattering amplitude at incandescence during the trace analysis
	//return value: 0; not used
	//martin.gysel@psi.ch, 15/02/2012
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar SAIchanPrefixInc=$ksSP2SAIchanPrefixInc
	//update selected incandescence channel prefix
	SAIchanPrefixInc=popStr
	//determine popNum
	string IncChanList=SP2_ChanListIncandOnly()
	popNum=1+WhichListItem(popStr, IncChanList)
	//update all popmenus on the panel
	PopupMenu SAIincandPrefixPM,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_SAIselectPSDchanPrefixPM(ctrlName,popNum,popStr) : PopupMenuControl
	//This function sets the split detector channel to be used for determining the split point position
	//required for the "scattering at incandescence" analysis
	//return value: 0; not used
	//martin.gysel@psi.ch, 15/02/2012
	String ctrlName		//name of button control; not used
	Variable popNum		//number of selected item; not used (will be determined internally)
	String popStr			//selected item string => will be written to corresponding global string
	
	//preparations
	string savedDF=getdatafolder(1)
	//access panel globals
	setdatafolder $ksSP2PathToToolkitPanelFldr
	Svar SAIchanPrefixPSD=$ksSP2SAIchanPrefixPSD
	//update selected split detector channel prefix
	SAIchanPrefixPSD=popStr
	//determine popNum
	string popList=SP2_ChanListSplitOnly()+SP2_ChanListCombPSDonly()
	popNum=1+WhichListItem(popStr, popList)
	//update all popmenus on the panel
	PopupMenu SAIchanPrefixPSDpm,mode=popNum
	//finish procedure
	setdatafolder $savedDF
	return 0
End


Function SP2_SAIgr_BCdiamScatterPlot([pbpfldrfp, ScattPrefix, IncPrefix])
	//This function displays a scatter plot of optical diameter vs mass equiv. diameter of the BC core
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/02/2012
	string pbpfldrfp	//full path to folder containing the PBP data
					//default: current data folder
	string ScattPrefix	//prefix of scattering channel
					//default: prompt
	string IncPrefix	//prefix of incandescence channel
					//default: prompt
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif

	variable mustprompt=0
	if (paramisdefault(ScattPrefix))
		mustprompt=1
		ScattPrefix=ksSP2SCHGprefix
	endif
	if (paramisdefault(IncPrefix))
		mustprompt=1
		IncPrefix=ksSP2SPHGprefix
	endif
	if (mustprompt)
		string ScattPrefixList=SP2_ChanListScattOnly()
		string ScattAbbrevList=SP2_ChanListToAbbrevList(ScattPrefixList)
		variable ScattMode=1+WhichListItem(ScattPrefix, ScattPrefixList)
		string IncPrefixList=SP2_ChanListIncandOnly()
		string IncAbbrevList=SP2_ChanListToAbbrevList(IncPrefixList)
		variable IncMode=1+WhichListItem(IncPrefix, IncPrefixList)
		prompt ScattMode, "select scattering channel:", popup, ScattAbbrevList
		prompt IncMode, "select incandescence channel:", popup, IncAbbrevList
		doprompt "Select Channels", ScattMode, IncMode
		if (V_flag)
			setdatafolder $savedDF;	SP2_abort("")
		endif
		ScattMode-=1
		IncMode-=1
		ScattPrefix=stringfromlist(ScattMode,ScattPrefixList)
		IncPrefix=stringfromlist(IncMode,IncPrefixList)
	endif
	//data folders
	string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
	if (!DataFolderExists(SAIfldrFP ))		
		setdatafolder $savedDF
		SP2_abort("No SAI data folder found -- you need to run LEO first. cancelled procedure"+currproc+"!")
	endif
	//access waves
		//PBP folder
		setdatafolder $PBPfldrFP
		wave Incand_BCdiam=$IncPrefix+ksSP2pbpBCdiam			
		string Wnam_DiamMassEq=nameofwave(Incand_BCdiam)
		//SAI folder
		setdatafolder $SAIfldrFP
		wave Scatt_FitOptDiam=$ScattPrefix+ksSP2SAIFitOptDiam	
		string Wnam_DiamOpt=nameofwave(Scatt_FitOptDiam)

	//further preparations
	string ScattChan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(ScattPrefix),"")
	string IncChan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(IncPrefix),"")
	//graph
	if (waveexists(Incand_BCdiam) && waveexists(Scatt_FitOptDiam))
		//prepare graph window		
		Display /W=(73.5,104.75,540,467) as "BCdiam_OptVsMassEq_"+ScattChan_Abbrev+"vs"+IncChan_Abbrev
		//Append traces
		AppendToGraph  Scatt_FitOptDiam vs Incand_BCdiam
		//format graph
		ModifyGraph mode=2
		ModifyGraph marker=19
		ModifyGraph lSize=2
		ModifyGraph rgb=(0,0,0)
		ModifyGraph msize=5
		ModifyGraph useMrkStrokeRGB=1
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks(left)=20,nticks(bottom)=10
		ModifyGraph fSize=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "\\Zr133\rOptical diameter of BC core, D\\Bopt\\M\\Zr133 [nm]\r(determined from scattering signal)"
		Label bottom "\\Zr133Mass equivalent diameter of BC core, D\\BMEV\\M\\Zr133 [nm]\r(determined from incandescence signal)"
		SetAxis/N=1 left 0,*
		SetAxis/A/N=1/E=1 bottom
		Legend/C/N=text0/J/A=LB/X=29.90/Y=85.54 "\\s("+Wnam_DiamOpt+") D\\Bopt,BC,"+ScattChan_Abbrev+"\M vs D\BMEV,BC,"+IncChan_Abbrev+"\M"
		SP2_addDataFolderTag(DF=SAIfldrFP)
		SetDrawLayer UserFront
		SetDrawEnv xcoord= bottom,ycoord= left,linefgc= (65280,0,0)
		DrawLine 1,1,1000,1000
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end

Function SP2_SAIgr_ScattAmpVsIncPkHt([pbpfldrfp, ScattPrefix, IncPrefix])
	//This function displays a scatter plot of normalized scattering amplitude vs incandescence peak height of the BC core
	//return value: 0; not used
	//martin.gysel@psi.ch; 15/02/2012
	string pbpfldrfp	//full path to folder containing the PBP data
					//default: current data folder
	string ScattPrefix	//prefix of scattering channel
					//default: prompt
	string IncPrefix	//prefix of incandescence channel
					//default: prompt
	
	//preparations
	string savedDF=getdatafolder(1)				//remember current data folder
	string /g RTStackInfo=GetRTStackInfo(0)		//write stackinfo into global variable in current data folder
	string currproc=laststringfromlist(RTStackInfo)	//name of current procedure
	string message								//reserve string for abort message
	//set defaults
	if (paramisdefault(pbpfldrfp))
		pbpfldrfp=SP2_getFolder(type="PBP")
	endif

	variable mustprompt=0
	if (paramisdefault(ScattPrefix))
		mustprompt=1
		ScattPrefix=ksSP2SCHGprefix
	endif
	if (paramisdefault(IncPrefix))
		mustprompt=1
		IncPrefix=ksSP2SPHGprefix
	endif
	if (mustprompt)
		string ScattPrefixList=SP2_ChanListScattOnly()
		string ScattAbbrevList=SP2_ChanListToAbbrevList(ScattPrefixList)
		variable ScattMode=1+WhichListItem(ScattPrefix, ScattPrefixList)
		string IncPrefixList=SP2_ChanListIncandOnly()
		string IncAbbrevList=SP2_ChanListToAbbrevList(IncPrefixList)
		variable IncMode=1+WhichListItem(IncPrefix, IncPrefixList)
		prompt ScattMode, "select scattering channel:", popup, ScattAbbrevList
		prompt IncMode, "select incandescence channel:", popup, IncAbbrevList
		doprompt "Select Channels", ScattMode, IncMode
		if (V_flag)
			setdatafolder $savedDF
			message="User cancelled procedure"+currproc+"!"
			print message; print RTStackInfo; abort message		
		endif
		ScattMode-=1
		IncMode-=1
		ScattPrefix=stringfromlist(ScattMode,ScattPrefixList)
		IncPrefix=stringfromlist(IncMode,IncPrefixList)
	endif
	//data folders
	string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpfldrfp)
	//access waves
		//PBP folder
		setdatafolder $PBPfldrFP
		wave Incand_PeakHt=$IncPrefix+ksSP2PBPtracefitPeakHt
		string Wnam_IncPkHt=nameofwave(Incand_PeakHt)
		//SAI folder
		if (!DataFolderExists(SAIfldrFP))
			SP2_abort("SAI data folder "+SAIfldrFP+" not found.\rYou may need to run LEO analysis.")
		endif
		setdatafolder $SAIfldrFP
		wave SAI_ScattFitSigNorm=$ScattPrefix+ksSP2SAIFitSigNorm
		string Wnam_SAIscattSig=nameofwave(SAI_ScattFitSigNorm)
	//further preparations
	string ScattChan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(ScattPrefix),"")
	string IncChan_Abbrev=replacestring(";",SP2_ChanListToAbbrevList(IncPrefix),"")
	//graph
	if (waveexists(Incand_PeakHt) && waveexists(SAI_ScattFitSigNorm))
		//prepare graph window		
		Display /W=(152.25,176.75,618.75,543.5) as "BCcore_ScattVsIncand_"+ScattChan_Abbrev+"vs"+IncChan_Abbrev
		//Append traces
		AppendToGraph  SAI_ScattFitSigNorm vs Incand_PeakHt
		//format graph
		ModifyGraph mode=2
		ModifyGraph marker=19
		ModifyGraph lSize=2
		ModifyGraph msize=5
		ModifyGraph useMrkStrokeRGB=1
		ModifyGraph grid=1
		ModifyGraph mirror=2
		ModifyGraph nticks=20
		ModifyGraph fSize=10
		ModifyGraph standoff=0
		ModifyGraph gridRGB=(0,0,0)
		Label left "\\Zr133\rNormalized scattering amplitude of BC core [a.u.]\r(from "+ScattChan_Abbrev+" channel)"
		Label bottom "\\Zr133\rIncandescence peak height [a.u.]\r(from "+IncChan_Abbrev+" channel)"
		SetAxis/A=2/N=1 left 0,*
		SetAxis/N=1 bottom 0,*
		TextBox/C/N=text0/A=LB/X=1.07/Y=48.22 SAIfldrFP
		Legend/C/N=text1/J/A=LT/X=0.64/Y=0.76 "BC core:\r\\s("+Wnam_SAIscattSig+") scattering amplitude vs incandescence peak height"
		TextBox/C/N=text2/T={135,219}/A=LT/X=1.28/Y=21.32 "scattering channel:\t"+ScattChan_Abbrev+"\rincandescence channel:\t"+IncChan_Abbrev
	endif
	//finish procedure
	if (datafolderexists(savedDF))
		setdatafolder $savedDF
	endif
	return 0
end


// Plot to evaluate the performance of using SAI to calibrate the scattering channel
function SP2_SAIgr_SAIcalibration([pbpDF, ScattPrefix, IncPrefix])
	// joel.c.corbin+sci@gmail.com 2016-09-21
	string pbpDF // full path to folder containing the PBP data. Prompt if missing.
	string ScattPrefix	//prefix of scattering    channel. Prompts if missing.
	string IncPrefix	//prefix of incandescence channel. Prompts if missing.
	
	
	// internals
	DFREF savedDF= GetDataFolderDFR()
	variable mustPrompt
	if (paramisdefault(pbpDF))
		pbpDF=SP2_getFolder(type="PBP")
	endif
	if (paramisdefault(ScattPrefix))
		mustprompt=1
		ScattPrefix=ksSP2SCHGprefix
	endif
	if (paramisdefault(IncPrefix))
		mustprompt=1
		IncPrefix=ksSP2SPHGprefix
	endif
	
	if (mustprompt)
		string ScattPrefixList=SP2_ChanListScattOnly()
		string ScattAbbrevList=SP2_ChanListToAbbrevList(ScattPrefixList)
		variable ScattMode=1+WhichListItem(ScattPrefix, ScattPrefixList)
		string IncPrefixList=SP2_ChanListIncandOnly()
		string IncAbbrevList=SP2_ChanListToAbbrevList(IncPrefixList)
		variable IncMode=1+WhichListItem(IncPrefix, IncPrefixList)
		prompt ScattMode, "Select scattering channel (y axis):", popup, ScattAbbrevList
		prompt IncMode, "Select incandescence channel (x axis):", popup, IncAbbrevList
		doprompt "Select Channels", ScattMode, IncMode
		if (V_flag)
			setdatafolder savedDF;	SP2_abort("")
		endif
		ScattMode-=1
		IncMode-=1
		ScattPrefix=stringfromlist(ScattMode,ScattPrefixList)
		IncPrefix=stringfromlist(IncMode,IncPrefixList)
	endif
	
	//data folders
	string SAIfldrFP=SP2_PBPfldrfp2SAIfldrfp(pbpDF)
	if (!DataFolderExists(SAIfldrFP))		
		setdatafolder savedDF
		SP2_abort("No SAI data folder found -- you need to run LEO first.")
	endif

	// FIRST PLOT
	setdatafolder $pbpDF
	wave /Z SAIscattCoef_raw= :LEO:ScattAtInc:SCHG_SAIscattCoef_raw 
	wave /Z SAIscattCoef	 = :LEO:ScattAtInc:SCHG_SAIscattCoef
	wave /Z BCdiam=$IncPrefix+ksSP2pbpBCdiam
	wave times= $ SP2_pbp2raw(pbpDF) + ksSP2TimeDate
	if (!WaveExists(SAIscattCoef_raw) || !WaveExists(SAIscattCoef) || !WaveExists(SAIscattCoef_raw))
		return SP2_SAIcalibration("", pbpDF=pbpDF, ScattPrefix=ScattPrefix, IncPrefix=IncPrefix)
	endif
	
	
	// TIME SERIES
	display 
	AppendToGraph SAIscattCoef_raw, SAIscattCoef vs times
	SetAxis left 0, SP2_get_scattCoef("SCHG")*2.5
	hline(SP2_get_scattCoef("SCHG"), tag="HG cal")
	ModifyGraph mode[0]=3, mode[1]=4, marker[1]=8
	ModifyGraph rgb[0]=(43520,43520,43520), rgb[1]=(0,15872,65280)
	label left "Calibration coefficient"
	Label bottom " "
	legend

	// SUBPLOT CODE
	newpanel /HOST=$getTopWindowName() /EXT=0 /W=(0, 0, 0.7, 0.44)
	display /HOST=# /W=(0,0,1,1);	ModifyGraph gfSize=18
	
	// VS SIZE
	AppendToGraph SAIscattCoef_raw, SAIscattCoef vs BCdiam
	SetAxis left 0, SP2_get_scattCoef("SCHG")*2.5
	SetAxis /A/N=0 bottom
	ModifyGraph mode=3, log(bottom)=1, marker[1]=8
	ModifyGraph rgb[0]=(43520,43520,43520), rgb[1]=(0,15872,65280)
	label left "Calibration coefficient"
	Label bottom "Mass equivalent diameter of BC cores, D\BMEV\M [nm]"
	SP2_addDataFolderTag()
	hline(SP2_get_scattCoef("SCHG"), tag="Current")
end

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////// FUNCTIONS WRITTEN BY JCC //////////////////////////////////////////////////////////
//////////////// (kept separate when my coding style was quite different from Martin's, SAI excluded)
//////////////// Compatibility note: I use Notepad++ (v6.8.9) for Igor coding (ask me for source) //
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////


Menu "GraphMarquee", dynamic
	"\\M0Scan thru raw SP2 traces for these points", /Q, SP2_marqueeToTrace()
//	print "rep(\"ShowSP2traceCorresp2CursorA(CsrA=%s);	doupdate; sleep /S 1/30\",  wave2list(root:Packages:jTools:MarqueePs))"
	help = {"To change the scan speed, change the raw data slider option."}
	
End


function SP2_marqueeToTrace()
// Allows the user to select a group of particles (marquee) from a graph, 
// and view their raw traces as a movie.
//
// joel.c.corbin@gmail.com, 2016-02-10
//
//	// the one-liner version without 'stop' feature, useful for other sliders...:
//	rep("ShowSP2traceCorresp2CursorA(CsrA=%s);	doupdate; sleep /S 1/" + num2str(speed),  wave2list(root:Packages:jTools:MarqueePs));
// 
// cd root:MatSupSlid:TimeResSlider:; 
// rep("CurrPoint= %s; MatSupSlidCurrPtSetVarProc(\"CPSetVar_TimeResSlider\", CurrPoint, num2istr(CurrPoint), \"CurrPoint\");	doupdate; sleep /S 1/" + num2str(speed),  wave2list(root:Packages:jTools:MarqueePs));
	variable interact_after_n_sec= 7
	
	doWithinMarquee(doWhat="getPlist", quiet=1) 
	wave pList= root:Packages:jTools:MarqueePs
	variable np=numpnts(pList)
	
	if (np==0)
		printf "\t//* SP2: no particles selected. (Check validity of selection)"
		return 0
	elseif (np > 1e2)
		printf "\t//* SP2: %g particles selected. Movie will pause if it takes >%g seconds, continuing...\r", np, interact_after_n_sec
	endif
	
	NVAR /Z Speed= root:MatSupSlid:RawTraceSlider:Speed
	if (!NVAR_Exists(Speed) || Speed==1)
		variable FPS=30
	else
		FPS=Speed
	endif
	
	// do 1st one for sake of win name
	rep("ShowSP2traceCorresp2CursorA(CsrA=%s)", num2str(pList[0]))
	string topWinAtStart= winList("*","","WIN:")
	
	variable i
	do
		rep("ShowSP2traceCorresp2CursorA(CsrA=%s)", num2str(pList[i]))
		
		doupdate;	sleep /S 1/FPS
		string currTopWin= winList("*","","WIN:")
		
		if (!stringmatch(topWinAtStart, currTopWin)) 
			// user clicked off -- so stop.  Doesn't work for help windows.
			break
			
		elseif (i>1e3)
			printf "\t//* SP2 marquee: 1000 particles already shown -- stopping scan"
			break
		endif
		
		if (i>0 && mod(1/FPS*i, interact_after_n_sec)==0) // "every 10 seconds:"
			doAlert 1, num2str(interact_after_n_sec) +" seconds of data have been shown. Keep going?" 
			if (V_flag==2) // no
				break
			endif
		endif
		
		i+=1
	while (i<np)
end



function SP2_CBP_rawDataDelChk(cba) : CheckBoxControl
// joel.c.corbin+sci@gmail.com 2016-04-22
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			// (un)check the box 
			
			NVAR rawdatadelmode= root:SP2toolkit:Panel:rawdatadelmode // better would be $ksSP2PathToToolkitPanelFldr + ksSP2rawdatadelmode
			rawdatadelmode = cba.checked
			
			// ask if to delete existing data
			if (rawdatadelmode)
				// cf SP2_DeleteRawTraces()
				
				// [1,5] removes the preceding colon
				string SCHGtraceName=ksSP2SCHGprefix[1,5]+ksSP2rawtracemat
				string BBHGtraceName=ksSP2BBHGprefix[1,5]+ksSP2rawtracemat
				string NBHGtraceName=ksSP2NBHGprefix[1,5]+ksSP2rawtracemat
				string SPHGtraceName=ksSP2SPHGprefix[1,5]+ksSP2rawtracemat
				string SCLGtraceName=ksSP2SCLGprefix[1,5]+ksSP2rawtracemat
				string BBLGtraceName=ksSP2BBLGprefix[1,5]+ksSP2rawtracemat
				string NBLGtraceName=ksSP2NBLGprefix[1,5]+ksSP2rawtracemat
				string SPLGtraceName=ksSP2SPLGprefix[1,5]+ksSP2rawtracemat
				string rawNameList=""
				rawNameList+= SCHGtraceName + ";"
				rawNameList+= BBHGtraceName + ";"
				rawNameList+= NBHGtraceName + ";"
				rawNameList+= SPHGtraceName + ";"
				rawNameList+= SCLGtraceName + ";"
				rawNameList+= BBLGtraceName + ";"
				rawNameList+= NBLGtraceName + ";"
				rawNameList+= SPLGtraceName // + ";"
				variable i, nRaw= 8, rawFound= 0
				for (i=0; i<nRaw; i+=1)
					rawFound= rawFound || strlen(findWaves(stringFromList(i,rawNameList)))
				endfor
	
				if (rawFound)
					DoAlert 1, "Delete existing raw data as well?"
					if (V_flag==1) // yes
						iterSP2raw("killwaves /Z " + replaceString(";", rawNameList, ","))
					elseif (V_flag==2) // no
						print "\t\t//* Existing raw data was not deleted."
					endif
				endif
			
			endif
			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
end


// Add a label to the top graph including ALL data folders from which waves are shown
function SP2_addDataFolderTag([DF])
// Joel.Corbin 2016-09.  Eventually replace everywhere (e.g. DataPathBox above)
string DF

	// auto-get DF if not provided
	if (ParamIsDefault(DF) || !strlen(DF))
		// get list of traces on graph
		string traceNames= TraceNameList("", ";", 1)
		if (!strlen(traceNames))
			TextBox/K/N=tagSP2DF // update graph 
			return 0
		endif
		
		// convert trace list into list of data folders
		variable i, nl= itemsInList(traceNames)
		string thisOne
		DF=""
		for (i=0; i<nl; i+=1)
			// get DF of a trace
			thisOne= stringFromList(i, traceNames)
			thisOne= GetWavesDataFolder(TraceNameToWaveRef("", thisOne), 1)
			
			// simplify labels.  Could have used ksSP2LEOtraceFitSubFldrPP etc here, but too complicated.
			thisOne= removeEnding(thisOne, "ConcTser:")
			thisOne= removeEnding(thisOne, "LEO:BeamAndCalib:")
			thisOne= removeEnding(thisOne, "LEO:TraceFit:")
			thisOne= removeEnding(thisOne, "LEO:Main:")
			
			DF+= thisOne + ";"
		endfor
		
		// iff all traces are from one data folder, label the graph
		// TODO: use the highest shared subfolder that's not root: 
		DF= removeEnding( uniqueList(DF) , ";")
		if (itemsInList(DF)>1)
			DF= replaceString(";", DF, "\r")
			if (itemsInlist(DF)>3)
				// probably too much 
				return -1
			endif
		endif
	endif
	
	TextBox/C/N=tagSP2DF/S=3/A=RT/X=-1/Y=-1 "\\Z09\\F'Calibri'\r"+ DF
end

Function SP2_btn_PSDcalFact(ignoredStr) : ButtonControl
	string ignoredStr
	edit; rep("append %s", findWaves("(FudgeFact)|(CalFact)", inDF=$SP2_getBeamShapeFolder(), sep=";"))
End




// Simple function to analyze the data for particle beam alignments.
// SEE COMMENTS AT END FOR CODE TO INCORPORATE INTO PANEL
function plotParticleBeamAlignment()
// Load data without concatenating folders before running this function.
// (Loading only SCLG is also a good idea.)
//
// joel.c.corbin+sci@gmail.com; 2015-07-20
// 		todo: do histogram self, so that postproc in the toolkit isn't necessary...would be much faster
	
	printf "\t//* Plotting SCLG peak heights for each PBP folder in root: ..."
	
// hist graph (use make traces different after)
	cd root:; display; 
	iterSP2PBP("append SCLG_PeakHtDistr /TN=$(cleanUpName(stringFromList(1,getdatafolder(0), \"x\")[0,4],0))")
	normtraces()
	autocolourtraces()
	legend /A=LT
	
// skew graph
	cd root:; make /o/n=0 xNums, xSkew
	cd root:;	iterSP2PBP("WaveStats/R=(2, numpnts(SCHG_FitPeakHt)-1)/Q SCHG_FitPeakHt") // 6 from graph of best peaks
	cd root:;	iterSP2PBP("appendWave(::xNums, {str2num(stringFromList(0, stringFromList(1, getdatafolder(0), \"x\"), \"_\"))})")
	cd root:;	iterSP2PBP("appendWave(::xSkew, {V_skew})")
	display xSkew vs xNums
		
// would smoothing the hist make this more robust? There's often one spike in the skew distribution...
	
// kurtosis 
	// cd root:;	iterSP2PBP(1,"WaveStats/R=(10)/Q SCHG_FitPeakHt; print getDataFolder(0),	V_skew, V_kurt")	
	
	
	
	
// panel incorporation
			// Button DetectorBlockAlignButt,pos={323,628},size={200,20},proc=SP2_DetectorBlockAlignButt,title="plot SCLG histograms"
			// Button DetectorBlockAlignButt,font="Arial",fSize=11
			// GroupBox DetectorBlockAlignGB,pos={318,608},size={214,46},title="detector block alignment"
			// GroupBox DetectorBlockAlignGB,font="Arial",fSize=11

		// Function SP2_DetectorBlockAlignButt(ba) : ButtonControl
			// STRUCT WMButtonAction &ba

			// switch( ba.eventCode )
				// case 2: // mouse up
					// // click code here
					// plotParticleBeamAlignment()
					// autocolourtraces()
					// break
				// case -1: // control being killed
					// break
			// endswitch

			// return 0
		// End
end




Macro SP2_raw_peak_heights_gr() : Graph
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder $SP2_getFolder(type="PBP")
	Display /W=(169.2,75.2,603,415.4) BBHG_FitPeakHt vs SCHG_FitPeakHt as "SP2_raw_peak_heights_gr"
	AppendToGraph BBLG_FitPeakHt vs SCLG_FitPeakHt
	SetDataFolder fldrSav0
	ModifyGraph gFont="Segoe UI",gfSize=12
	ModifyGraph mode=3
	ModifyGraph marker(BBLG_FitPeakHt)=8
	ModifyGraph lSize=2
	ModifyGraph rgb(BBHG_FitPeakHt)=(1792,14080,63488),rgb(BBLG_FitPeakHt)=(62464,0,0)
	ModifyGraph mrkThick(BBHG_FitPeakHt)=1
	ModifyGraph gaps=0
	ModifyGraph log=1
	ModifyGraph zero=3
	ModifyGraph mirror=2
	ModifyGraph lowTrip=0.001
	ModifyGraph lblMargin=3
	ModifyGraph standoff=0
	ModifyGraph btLen=5
	ModifyGraph grid=1,gridRGB=(56576,56576,56576);
	Label left "BBLG or \\c";
	Label bottom "SCLG or \\c";
	Cursor/P A BBHG_FitPeakHt 155
	ShowInfo
	SetAxis/A/N=1 bottom
	SetAxis/A/N=1 left
	Legend/C/N=text0/J "\\s(BBHG_FitPeakHt) High gain\r\\s(BBLG_FitPeakHt) low gain"
EndMacro

Macro SP2_raw_split_check_Gr() : Graph
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder $SP2_getFolder(type="PBP")
	Display /W=(136.8,95,648.6,458.6) SPHG_NegPeakHt vs SPHG_PosPeakHt 
	ModifyGraph zColor(SPHG_NegPeakHt)={BBHG_FitPeakHt,*,*,BlueBlackRed}
	ModifyGraph margin(right)=118,gFont="Segoe UI",gfSize=12
	ModifyGraph mode=3
	ModifyGraph lSize=2
	ModifyGraph rgb=(1792,14080,63488)
	ModifyGraph mrkThick=1
	ModifyGraph gaps=0
	ModifyGraph logZColor=1
	ModifyGraph zero=3
	ModifyGraph mirror=2
	ModifyGraph lowTrip=0.001
	ModifyGraph lblMargin=3
	ModifyGraph standoff=0
	ModifyGraph btLen=5
	Label left "\\c"
	Label bottom "\\c"
	Cursor/P A SPHG_NegPeakHt 19331
	ShowInfo
	SetDataFolder fldrSav0
	ColorScale/C/N=text1/X=103.27/Y=-2.01 trace=SPHG_NegPeakHt
	AppendText "BBHG Peak Ht"
	TextBox/C/N=text0/X=-10.00/Y=-5.00 "\\Z08\rNo trend? invert SP and reload"
EndMacro

Macro SP2_raw_peak_heights_gr_SC() : Graph
	PauseUpdate; Silent 1		// building window...
	String fldrSav0= GetDataFolder(1)
	SetDataFolder $SP2_getFolder(type="PBP")
	Display /W=(116.4,141.2,482.4,407.6) SCLG_FitPeakHt vs SPHG_PosPeakHt as "SP2_raw_peak_heights_gr_SC"
	AppendToGraph SCHG_FitPeakHt vs SPHG_PosPeakHt
	SetDataFolder fldrSav0
	ModifyGraph gFont="Segoe UI",gfSize=12
	ModifyGraph mode=2
	ModifyGraph marker(SCHG_FitPeakHt)=8
	ModifyGraph lSize=0.5
	ModifyGraph rgb(SCLG_FitPeakHt)=(16384,28160,65280)
	ModifyGraph msize=1
	ModifyGraph gaps=0
	ModifyGraph grid=2
	ModifyGraph log=1
	ModifyGraph minor=1
	ModifyGraph sep=10
	ModifyGraph gridRGB=(56576,56576,56576)
	ModifyGraph btLen=5
	ModifyGraph stLen=3
	Label left "\\c"
	Label bottom "\\c"
	SetAxis/A/N=1 left
	SetAxis/A/N=1 bottom
	ShowInfo
EndMacro

