;$Id: pcomp_highk_early.pro,v 1.1 2019/06/22 14:58:46 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!x.margin=[4.7,0.5]
!y.margin=[3.2,2.6]
!x.title='!8t!6 [code units]'
!y.title='!13E!6!dM!n/!13E!6!dK!n'
;
dir='/D/Print/Aspen19/Evan/'
file='Helix64'
ext='.sav'
;
te=250.
k1=2.*!pi
xr=[0,te]
yr=[1e-4,12.3]
tt=grange(0.,te,500)
ts=-60. & Esat=8.0 & eta32=4.0e-3/k1^2
plot_io,tt,Esat*(1.-exp(-eta32*k1^2*(tt-ts))),xr=xr,yr=yr,xst=9,li=1
print,'eta(32)=',eta32
;
kf=18.8
k1=2.*!pi
urms0=0.28
etat0=urms0/(3.*kf)
eta48=6.6e-5
print,'3*etat0/eta(32)=',3*etat0/eta32
print,'3*etat0/eta(48)=',3*etat0/eta48
;!x.title='!8t !7g!6!d48!n !8k!6!s!d1!n!r!u2!n'
;axis,xax=1,xr=xr*eta48*k1^2
;
kf=18.8
urms0=0.27
!x.title='!8t u!6!drms!n !8k!6!df!n'
axis,xax=1,xr=xr*urms0*kf
;
te=3550.
tt=grange(0.,te,500)
ts=-60. & Esat=9.5 & eta=2.6e-3/k1^2
;oplot,tt,Esat*(1.-exp(-eta*k1^2*(tt-ts))),li=0
print,'eta(48)=',eta
;
file='Helix32highk'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(32)=',sqrt(2.*mean(EK))
;
;file='Helix64'
;restore,dir+file+ext
;oplot,t,4.*!pi*EM/mean(EK),col=55
;print,'urms0(64)=',sqrt(2.*mean(EK))
;help,t
;
loadct,6
file='Helix48highk'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(48)=',sqrt(2.*mean(EK))
help,t
loadct,5
;
print,'$mv idl.ps ../fig/pcomp_highk.ps'
;
END
