;$Id: pcomp_early.pro,v 1.5 2019/07/07 04:24:06 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!x.margin=[7.2,0.5]
!y.margin=[3.2,2.4]
!x.title='!8t!6 [code units]'
!y.title='!13E!6!dM!n/!13E!6!dK!n'
siz=1.4
;
dir='/D/Print/Aspen19/Evan/'
file='Helix64'
ext='.sav'
;
xr=[0,270]
yr=[5e-3,5.3]
;
te=3550.
tt=grange(0.,te,500)
ts=120. & Esat=4.8 & eta=4.0e-3
plot_io,tt,Esat*(1.-exp(-eta*(tt-ts))),xr=xr,yr=yr,/nodata,xst=9
;
kf=18.8
urms0=0.27
!x.title='!8t u!6!drms!n !8k!6!df!n'
axis,xax=1,xr=xr*urms0*kf
;
file='Helix32'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122,thick=4
xyouts,230.,2.0,siz=siz,'!632!u3!n',col=122
;
file='Helix64'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=55
xyouts,240.,.5,siz=siz,'!664!u3!n',col=55
help,t
;
loadct,6
file='Helix48'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122,thick=5
xyouts,235.,1.0,siz=siz,'!648!u3!n',col=122
help,t
loadct,5
;
;xx=[4.,12.] & oplot,xx,2e-3*exp(.35*xx)
;
print,'$mv idl.ps ../fig/pcomp_early.ps'
;
END
