;$Id: pcomp64_highk_eta5.pro,v 1.6 2019/07/06 09:27:42 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=22,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!p.multi=[0,1,2]
!x.margin=[6.2,0.5]
!y.margin=[3.2,2.6]
!x.title='!8t!6 [code units]'
!y.title='!13E!6!dM!n/!13E!6!dK!n'
siz=1.7
;
dir='/D/Print/Aspen19/Evan/'
ext='.sav'
;
;-----------------------------------------------------------------------------
file='Helix64_eta5E-'
;
te=850.
k1=2.*!pi
xr=[0,te]
tt=grange(0.,te,500)
ts=5. & Esat=11.7 & eta5=3.4e-5
plot,tt,1.+Esat*(1.-exp(-2*eta5*k1^2*(tt-ts))),xr=xr,yr=[0,12.4],xst=9
print,'eta(5,new)=',eta5
;
kfk1=2.5
k1=2.*!pi
kf=kfk1*k1
urms0=0.25
etat0=urms0/(3.*kf)
print,'3*etat0/eta5=',3*etat0/eta5
!x.title='!8t !7g!6!ueff!n!8k!6!s!d1!n!r!u2!n'
axis,xax=1,xr=xr*eta5*k1^2
;
run='3'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(32)=',sqrt(2.*mean(EK))
;xyouts,650.,0.04,'!7g!6=5!9X!610!u-3!n',siz=siz,col=122
;
run='4'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=55
print,'urms0(64)=',sqrt(2.*mean(EK))
;xyouts,155.,0.40,'!7g!6=5!9X!610!u-4!n',siz=.9*siz,col=55
help,t
;
loadct,6
run='5'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(64)=',sqrt(2.*mean(EK))
xyouts,290.,1.08,'!7g!6=5!9X!610!u-5!n',siz=siz,col=122
help,t
loadct,5
;
run='6'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=155
print,'urms0(6)=',sqrt(2.*mean(EK))
xyouts,300.,6.4,'!7g!6=5!9X!610!u-6!n',siz=1.2*siz,col=155
help,t
;
xyouts,30.,11.0,siz=siz,'!6(a)'
;-----------------------------------------------------------------------------
file='Helix64_highk_eta5E-'
;
te=850.
k1=2.*!pi
xr=[0,te]
tt=grange(0.,te,500)
ts=10. & Esat=4.7 & eta5=0.6e-2/k1^2
plot,tt,1.+Esat*(1.-exp(-2*eta5*k1^2*(tt-ts))),xr=xr,yr=[0,12.0],xst=9,li=0
print,'eta(5,new)=',eta5
;
kfk1=4.5
k1=2.*!pi
kf=kfk1*k1
urms0=0.21
etat0=urms0/(3.*kf)
print,'3*etat0/eta5=',3*etat0/eta5
;
;  second fit
;
urms0=0.25
etat0=urms0/(3.*kf)
tt=grange(0.,te,500)
ts=5. & Esat=12.1 & eta6=6.4e-5
print,'3*etat0/eta6=',3*etat0/eta6
oplot,tt,1.+Esat*(1.-exp(-eta*k1^2*(tt-ts))),li=0
!x.title='!8t !7g!6!ueff!n!8k!6!s!d1!n!r!u2!n'
axis,xax=1,xr=xr*eta6*k1^2
print,'eta(6)=',eta6
;
run='3'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(32)=',sqrt(2.*mean(EK))
xyouts,400.,0.8,'!7g!6=5!9X!610!u-3!n',siz=siz,col=122
;
run='4'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=55
print,'urms0(64)=',sqrt(2.*mean(EK))
xyouts,300.,3.3,'!7g!6=5!9X!610!u-4!n',siz=siz,col=55
help,t
;
loadct,6
run='5'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(64)=',sqrt(2.*mean(EK))
help,t
xyouts,230.,4.7,'!7g!6=5!9X!610!u-5!n',siz=.8*siz,col=122
loadct,5
;
run='6'
print,dir+file+run+ext
restore,dir+file+run+ext
oplot,t,4.*!pi*EM/mean(EK),col=155
print,'urms0(6)=',sqrt(2.*mean(EK))
help,t
xyouts,235.,8.7,'!7g!6=5!9X!610!u-6!n',siz=siz,col=155
xyouts,30.,10.8,siz=siz,'!6(b)'
;
print,'$mv idl.ps ../fig/pcomp64_highk_eta5.ps'
END
