;$Id: pcomp.pro,v 1.8 2019/07/06 06:11:07 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=12,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
!p.charsize=1.7
!x.margin=[4.7,0.5]
!y.margin=[3.2,2.6]
!x.title='!8t!6 [code units]'
!y.title='!13E!6!dM!n/!13E!6!dK!n'
;
dir='/D/Print/Aspen19/Evan/'
file='Helix64'
ext='.sav'
;
te=3550.
k1=2.*!pi
xr=[0,te]
tt=grange(0.,te,500)
ts=170. & Esat=3.8 & eta32=5.0e-5
plot,tt,1.+Esat*(1.-exp(-2*eta32*k1^2*(tt-ts))),xr=xr,yr=[0,5.3],xst=9,li=1
print,'eta(32,new)=',eta32
;
k1=2.*!pi
kf=2.5*k1
urms0=0.28
etat0=urms0/(3.*kf)
eta48=6.6e-5
print,'3*etat0/eta(32)=',3*etat0/eta32
print,'3*etat0/eta(48)=',3*etat0/eta48
!x.title='!8t !7g!6!d48!n !8k!6!s!d1!n!r!u2!n'
axis,xax=1,xr=xr*eta48*k1^2
;
te=3550.
tt=grange(0.,te,500)
;ts=170. & Esat=3.15 & eta=2.6e-3/k1^2
ts=170. & Esat=3.15 & eta=6.6e-5
oplot,tt,1.+Esat*(1.-exp(-eta*k1^2*(tt-ts))),li=0
print,'eta(48)=',eta
;
file='Helix32'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(32)=',sqrt(2.*mean(EK))
xyouts,330.,4.0,siz=siz,'!632!u3!n',col=122
;
file='Helix64'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=55
print,'urms0(64)=',sqrt(2.*mean(EK))
xyouts,1000.,0.9,siz=siz,'!664!u3!n',col=55
help,t
;
loadct,6
file='Helix48'
restore,dir+file+ext
oplot,t,4.*!pi*EM/mean(EK),col=122
print,'urms0(48)=',sqrt(2.*mean(EK))
xyouts,740.,3.0,siz=siz,'!648!u3!n',col=122
help,t
loadct,5
;
print,'$mv idl.ps ../fig/pcomp.ps'
;
END
