!!****if* source/Simulation/SimulationMain/StirTurb/Simulation_initBlock
!!
!! NAME
!!
!!  Simulation_initBlock
!!
!! SYNOPSIS
!!
!!  Simulation_initBlock(integer, intent(IN)  :: blockid)
!!
!! DESCRIPTION
!!
!!  Initializes data (density, pressure, velocity, etc.) for
!!  a specified block.  This version sets up the Stirring-Turbulance
!!  problem.
!!
!!
!! ARGUMENTS
!!
!!   blockid : ID of block in current processor
!!
!!
!!
!!
!!***


subroutine Simulation_initBlock(blockId)

  use Simulation_data, ONLY: sim_rhoAmbient, sim_cAmbient, sim_gamma, sim_beta
  use Grid_interface, ONLY : Grid_getBlkIndexLimits, &
    Grid_getCellCoords, Grid_putPointData, Grid_putRowData
 
  implicit none 
#include "constants.h"
#include "Flash.h"
#include "Eos.h"

  integer, intent(IN) :: blockId
  real, dimension(NSPECIES) :: massFrac
  real, pointer, dimension(:,:,:,:) :: facexData, faceyData, facezData

#ifdef FIXEDBLOCKSIZE
  real, dimension(GRID_IHI_GC) :: xCoord
  real, dimension(GRID_JHI_GC) :: yCoord
  real, dimension(GRID_KHI_GC) :: zCoord
  real, dimension(GRID_IHI_GC) :: rho, pressure, energy, e, temperature
  real, dimension(GRID_IHI_GC) :: mpressure, magx, magy, magz, divb
  real, dimension(GRID_IHI_GC) :: vx, vy, vz, gamE, gamC,scalar
  real, dimension(GRID_IHI_GC) :: accx, accy, accz
#else
  real,allocatable,dimension(:) :: xCoord,yCoord,zCoord
  real, dimension(:),allocatable :: rho, pressure, energy, e, temperature
  real, dimension(:),allocatable :: mpressure, magx, magy, magz, divb
  real, dimension(:),allocatable :: vx, vy, vz, gamE, gamC,scalar
  real, dimension(:),allocatable :: accx, accy, accz
#endif
  real :: yy, zz, p_ambient, mmm
  integer,dimension(2,MDIM) :: blkLimits,blkLimitsGC
  integer :: sizeX,sizeY,sizeZ,sizeIntX
  integer,dimension(MDIM) :: startingPos
  

  integer :: i, j, k, n,pass_scalar,istat
  logical :: gcell = .true.

  print *,'top of the routine'
  call Grid_getBlkIndexLimits(blockId,blkLimits,blkLimitsGC)
  sizeX = blkLimitsGC(HIGH,IAXIS)-blkLimitsGC(LOW,IAXIS)+1
  sizeIntX = blkLimits(HIGH,IAXIS)-blkLimits(LOW,IAXIS)+1
  sizeY = blkLimitsGC(HIGH,JAXIS)-blkLimitsGC(LOW,JAXIS)+1
  sizeZ = blkLimitsGC(HIGH,KAXIS)-blkLimitsGC(LOW,KAXIS)+1

  print *,'about to initialize facedata'
#if NFACE_VARS > 0
  print *,'initialize facedata X',blockID
  call Grid_getBlkPtr(blockId,facexData,FACEX)
  print *,'initialize facedata y',blockID
  call Grid_getBlkPtr(blockId,faceyData,FACEY)
  print *,'initialize facedata z',blockID
  call Grid_getBlkPtr(blockId,facezData,FACEZ)
#endif


#ifndef FIXEDBLOCKSIZE
  allocate(xCoord(sizeX),stat=istat)
  allocate(yCoord(sizeY),stat=istat)
  allocate(zCoord(sizeZ),stat=istat)
  allocate(rho(sizeIntX),stat=istat)
  allocate(pressure(sizeIntX),stat=istat)
  allocate(mpressure(sizeIntX),stat=istat)
  allocate(magx(sizeIntX),stat=istat)
  allocate(magy(sizeIntX),stat=istat)
  allocate(magz(sizeIntX),stat=istat)
  allocate(divb(sizeIntX),stat=istat)
  allocate(energy(sizeIntX),stat=istat)
  allocate(e(sizeIntX),stat=istat)
  allocate(temperature(sizeIntX),stat=istat)
  allocate(vx(sizeIntX),stat=istat)
  allocate(vy(sizeIntX),stat=istat)
  allocate(vz(sizeIntX),stat=istat)
  allocate(gamE(sizeIntX),stat=istat)
  allocate(gamC(sizeIntX),stat=istat)
  allocate(scalar(sizeIntX),stat=istat)
  allocate(accx(sizeIntX),stat=istat)
  allocate(accy(sizeIntX),stat=istat)
  allocate(accz(sizeIntX),stat=istat)
#endif
  print *,'Getting the coordinate info'
  ! get the coordinate information for the current block from the database
  xCoord = 0.0
  yCoord = 0.0
  zCoord = 0.0


#if NSPECIES > 0
     massFrac = 0.0
     massFrac(1) = 1.0
#endif

  if (NDIM == 3) call Grid_getCellCoords&
                      (KAXIS, blockId, CENTER, gcell, zCoord, sizeZ)
  if (NDIM >= 2) call Grid_getCellCoords&
                      (JAXIS, blockId, CENTER, gcell, yCoord, sizeY)
  call Grid_getCellCoords(IAXIS, blockId, CENTER, gcell, xCoord, sizeX)

  p_ambient      = sim_rhoAmbient * sim_cAmbient**2 / sim_gamma
  mmm = p_ambient/sim_beta/8./3.141595
  mmm = sqrt(mmm)
  print *,'mmm',mmm 
  pass_scalar = NPROP_VARS+NSPECIES+1
  do k = blkLimits(LOW,KAXIS), blkLimits(HIGH,KAXIS)
     zz = zCoord(k)

     do j = blkLimits(LOW, JAXIS), blkLimits(HIGH, JAXIS)
        yy = yCoord(j)
        rho        (:) = sim_rhoAmbient
        pressure   (:) = p_ambient
        mpressure  (:) = p_ambient/sim_beta
        magx       (:) = 0. 
        magy       (:) = 0. 
        magz       (:) = mmm
        divb       (:) = 0. 
        energy     (:) = p_ambient / ( (sim_gamma - 1.)  * rho)
!        temperature(:) = sim_eosArr(EOS_TEMP)
        gamC       (:) = sim_gamma
        gamE           = sim_gamma
        vx         (:) = 0.
        vy         (:) = 0.
        vz         (:) = 0.

        accx       (:) = 0.
        accy       (:) = 0.
        accz       (:) = 0.
        scalar     (:) = zz
        do i = blkLimits(LOW,IAXIS), blkLimits(HIGH, IAXIS)

           startingPos(IAXIS) = i
           startingPos(JAXIS) = j
           startingPos(KAXIS) = k

           do n=1,NSPECIES
              call Grid_putPointData(blockId, CENTER, SPECIES_BEGIN+n-1, EXTERIOR, startingPos, massFrac(n))

           enddo  ! end loop over species
        enddo ! end loop over i
        startingPos(IAXIS)=blkLimits(LOW,IAXIS)
        e = energy + 0.5*(vx*vx + vy*vy + vz*vz)
        

        !this routine initializes a row at a time...

        call Grid_putRowData(blockId, CENTER, ACCX_VAR, EXTERIOR, IAXIS, startingPos, accx, sizeIntX)
        call Grid_putRowData(blockId, CENTER, ACCY_VAR, EXTERIOR, IAXIS, startingPos, accy, sizeIntX)
        call Grid_putRowData(blockId, CENTER, ACCZ_VAR, EXTERIOR, IAXIS, startingPos, accz, sizeIntX)

        call Grid_putRowData(blockId, CENTER, DENS_VAR, EXTERIOR, IAXIS, startingPos, rho, sizeIntX)
#ifdef EINT_VAR
        call Grid_putRowData(blockId, CENTER, EINT_VAR, EXTERIOR, IAXIS, startingPos, energy, sizeIntX)
#endif
        call Grid_putRowData(blockId, CENTER, ENER_VAR, EXTERIOR, IAXIS, startingPos, e, sizeIntX)
        call Grid_putRowData(blockId, CENTER, PRES_VAR, EXTERIOR, IAXIS, startingPos, pressure, sizeIntX)
        call Grid_putRowData(blockId, CENTER, TEMP_VAR, EXTERIOR, IAXIS, startingPos, temperature, sizeIntX)
        call Grid_putRowData(blockId, CENTER, GAME_VAR, EXTERIOR, IAXIS, startingPos, gamE, sizeIntX)
        call Grid_putRowData(blockId, CENTER, GAMC_VAR, EXTERIOR, IAXIS, startingPos, gamC, sizeIntX)
        call Grid_putRowData(blockId, CENTER, VELX_VAR, EXTERIOR, IAXIS, startingPos, vx, sizeIntX)
        call Grid_putRowData(blockId, CENTER, VELY_VAR, EXTERIOR, IAXIS, startingPos, vy, sizeIntX)
        call Grid_putRowData(blockId, CENTER, VELZ_VAR, EXTERIOR, IAXIS, startingPos, vz, sizeIntX)
        call Grid_putRowData(blockId, CENTER, MAGP_VAR, EXTERIOR, IAXIS, startingPos, mpressure, sizeIntX)
        call Grid_putRowData(blockId, CENTER, MAGX_VAR, EXTERIOR, IAXIS, startingPos, magx, sizeIntX)
        call Grid_putRowData(blockId, CENTER, MAGY_VAR, EXTERIOR, IAXIS, startingPos, magy, sizeIntX)
        call Grid_putRowData(blockId, CENTER, MAGZ_VAR, EXTERIOR, IAXIS, startingPos, magz, sizeIntX)
        call Grid_putRowData(blockId, CENTER, DIVB_VAR, EXTERIOR, IAXIS, startingPos, divb, sizeIntX)

        !call Grid_putRowData(blockId, CENTER, pass_scalar, EXTERIOR, IAXIS, startingPos, scalar, sizeIntX)
#if NFACE_VARS > 0
      do i=blkLimitsGC(LOW,IAXIS),blkLimitsGC(HIGH,IAXIS)
        facexData(MAG_FACE_VAR,i,j,k)= 0.
        faceyData(MAG_FACE_VAR,i,j,k)= 0.
        facezData(MAG_FACE_VAR,i,j,k)= sqrt(p_ambient/sim_beta/8./3.141595)
      enddo
#endif


     enddo ! end loop over j
  enddo ! end loop over k

  print *,'ENDED LOOP OVER k'
#if NFACE_VARS > 0
   do k=blkLimitsGC(LOW,KAXIS),blkLimitsGC(HIGH,KAXIS)
      i=blkLimitsGC(HIGH,IAXIS)+1
      do j=blkLimitsGC(LOW,JAXIS),blkLimitsGC(HIGH,JAXIS)
         facexData(MAG_FACE_VAR,i,j,k)= 0
      enddo
      j=blkLimitsGC(HIGH,JAXIS)+1
      do i=blkLimitsGC(LOW,IAXIS),blkLimitsGC(HIGH,IAXIS)
         faceyData(MAG_FACE_VAR,i,j,k)=0.
      enddo
   enddo
   k=blkLimitsGC(HIGH,KAXIS)+1
   do j=blkLimitsGC(LOW,JAXIS),blkLimitsGC(HIGH,JAXIS)
      do i=blkLimitsGC(LOW,IAXIS),blkLimitsGC(HIGH,IAXIS)
        facezData(MAG_FACE_VAR,i,j,k)= sqrt(p_ambient/sim_beta/8./3.141595)
      enddo
   enddo
#endif
  print *,'release pointers'
#ifndef FIXEDBLOCKSIZE
  deallocate(xCoord)
  deallocate(yCoord)
  deallocate(zCoord)
  deallocate(rho)
  deallocate(pressure)
  deallocate(mpressure)
  deallocate(magx)
  deallocate(magy)
  deallocate(magz)
  deallocate(divb)
  deallocate(energy)
  deallocate(e)
  deallocate(temperature)
  deallocate(vx)
  deallocate(vy)
  deallocate(vz)
  deallocate(gamE)
  deallocate(gamC)
  deallocate(scalar)
  deallocate(accx)
  deallocate(accy)
  deallocate(accz)
#endif
#if NFACE_VARS > 0
  call Grid_releaseBlkPtr(blockID,facexData,FACEX)
  call Grid_releaseBlkPtr(blockID,faceyData,FACEY)
  call Grid_releaseBlkPtr(blockID,facezData,FACEZ)
#endif
end subroutine Simulation_initBlock
