### Contributing

Contributions are more than welcome. Please begin by reading our [code of conduct](CONDUCT.md). There are several ways to contribute:

- Examples: More examples are always helpful. If you use `rnassqs` to query data from 'Quick Stats' and would like to contribute your query, consider submitting a pull request adding your query as a file in [inst/examples/](https://github.com/ropensci/rnassqs/tree/master/inst/examples).
- File an issue: If there is functionality you'd like to see added or something that is confusing, consider [creating an issue](https://github.com/ropensci/rnassqs/issues/new). The best issue contains an example of the problem or feature. Consider the excellent package [reprex](https://github.com/tidyverse/reprex) in creating a reproducible example.
- Contributing documentation: Clarifying and expanding the documentation is always appreciated, especially if you find an area that is lacking and would like to improve it. `rnassqs` uses roxygen2, which means the documentation is at the top of each function definition. Please submit any improvements as a pull request.
- Contributing code: if you see something that needs improving and you'd like to make the changes, contributed code is very welcome. Begin by filing a new issue to discuss the proposed change, and then submit a pull request to address the issue. `rnassqs` follows the style outlined in Hadley Wickham's [R Packages](http://r-pkgs.had.co.nz/style.html). Following this style makes the pull request and review go more smoothly.
