#' @title Ending Binary Gender Application
#'
#' @description This package contains a simple set of functions designed to
#'  highlight the inaccuracy and violence of assigning genders to others.
#'  The premise is as follows: [1] the assignment of gender to another
#'  in the absence of personal confirmation is an act of violence that 
#'  perpetuates hierarchical systems of oppression and can be personally
#'  traumatizing; [2] the assumption of the correctness of gender
#'  assigned at birth reinforces archaic medical views and state-sanctioned
#'  violence; [3] gender is a construct that varies over space, time, culture, 
#'  and ethnicity, and assuming that data from one context apply to another
#'  reinforces gendered imperialist violence and perpetuates cultural 
#'  stereotypes; [4] of specific relevance is the fact that gender is not
#'  a binary, and use of data that assume a gender binary reinforces that
#'  norm, which does violence to individuals who are non-binary and erases 
#'  cultures that embrace a diversity of genders; [5] gender cannot be 
#'  accurately inferred from names, presentations, pronouns or other such
#'  factors, and assuming it can and that the consequences of any failure
#'  are trivial speaks to the devaluation of transgender, non-binary,
#'  and gender-non-conforming life...and this is not absolved by using large
#'  data sets and fancy statistics; and [6] if it is important for some
#'  reason to know what someone's gender is, the only way to accurately and
#'  definitively obtain that information is from that person.
#' 
#' @name gendrendr
#'
#' @docType package
#'
#' @keywords package
#'
NULL