;$Id: pxyaver_bxby.pro,v 1.9 2019/07/16 13:28:37 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=10,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
iplot=3 ;(TTT flow)
iplot=1 ;(Willis flow)
iplot=2 ;(NNT flow)
;
!p.charsize=1.2
!x.margin=[6.0,.2]
!y.margin=[3.1,.2]
!x.title='!8t!6'
!y.title='!6'
siz=1.8
bar='!20!s!A$!n!r!6'
bar2='!20!s!u$!n!r!6'
;
lwrite_bxbym=0 ;(to use saved file)
lwrite_bxbym=1 ;(to recompute savefile)
if lwrite_bxbym then begin
  pc_read_xyaver,obj=xya
  t=xya.t & nt=n_elements(t)
  z=xya.z & nz=n_elements(z)
  bxmrms=total(xya.bxmz^2,1)/nz
  bymrms=total(xya.bymz^2,1)/nz
  bxpt=reform(xya.bxmz[0,*])
  bypt=reform(xya.bymz[0,*])
  print,'.c ;(to overwrite)'
  stop
  save,file='bxbym.sav',t,bxmrms,bymrms,bxpt,bypt
endif else begin
  restore,'bxbym.sav'
endelse
;
if iplot eq 1 then begin
  xr=[0,41]
  yr=[5e-11,2e-6]
endif
if iplot eq 2 then begin
  xr=[0,410]
  yr=[5e-16,2e-6]
  yr=[1e-7,2e-6]
endif
if iplot eq 3 then begin
  xr=[0,210]
  yr=[5e-10,2e-5]
endif
;
thick2=5
plot_io,t,t,xr=xr,yr=yr,/nodata
oplot,t,bxpt,col=122
oplot,t,-bxpt,col=122,li=2
oplot,t,+bypt,col=55
oplot,t,-bypt,col=55,li=2
;
if iplot eq 1 then begin
  xx=[25.0,35.5] & oplot,xx,1.4e-7*exp(0.052*xx),col=122
  xx=[22.0,32.5] & oplot,xx,4.0e-6*exp(-.26*xx),col=55
  xyouts,30.,1.8e-7,'!6e!u0.052!8t!6!n',siz=siz,col=122
  xyouts,30.,2.0e-9,'!6e!u-0.26!8t!6!n',siz=siz,col=55
  xyouts,13.4,5.0e-8,bar+'!8B!dy!n!6',siz=.9*siz,col=55
  xyouts,20.4,1.3e-7,bar+'!8B!dx!n!6',siz=.9*siz,col=122
  x1=24.795
  x2=35.545
  x0=-1.5*(x2-x1)
  y0=1e-9
  yr1=y0*(1.+.25*[-1,1])
  yr2=y0*(1.+.25*[-1,1])
  oplot,x0+[1,1]*x1,yr1,thick=thick2
  oplot,x0+[1,1]*x2,yr2,thick=thick2
  oplot,x0+[x1,x2],y0*[1,1],thick=thick2
  print,2*!pi/(x2-x1)
  xyouts,10.5,y0/2.8,'!62!7p!6/0.58',siz=.7*siz;,col=55
  print,'$mv idl.ps ~/tex/mhd/long_chen/fig/pxyaver_bxby.ps'
endif
if iplot eq 2 then begin
  print,'$mv idl.ps ~/tex/mhd/long_chen/fig/pxyaver_bxby_NNT32a.ps'
endif
if iplot eq 3 then begin
  print,'$mv idl.ps ~/tex/mhd/long_chen/fig/pxyaver_bxby_TTT48a.ps'
endif
;
END
