@parameters
default,iread,0
;
;  compute mean flow
;
if iread eq 0 then begin
  urms=sqrt(mean(dot2(var.uu)))
  brms=sqrt(mean(dot2(var.bb)))
  ;
  ;  should not normalize
  ;
  uu=var.uu ;/urms
  bb=var.bb ;/brms
  ;
  um=smooth_boxcar(uu,nx/2,ny/2)
  bm=smooth_boxcar(bb,nx/2,ny/2)
  iread=1
endif
;
zz=2*!pi*findgen(nz)/nz
!p.multi=[0,2,1]
plot,zz,um[nx/4,ny/4,*,0],/nodata,yr=[-.28,.4]
oplot,zz,um[nx/4,ny/4,*,0],col=122
oplot,zz,um[nx/4,ny/4,*,1],col=55 & loadct,6
oplot,zz,um[nx/4,ny/4,*,2],col=122 & loadct,5
;
plot,zz,bm[nx/4,ny/4,*,0],/nodata,yr=[-.16,.55]
oplot,zz,bm[nx/4,ny/4,*,0],col=122
oplot,zz,bm[nx/4,ny/4,*,1],col=55 & loadct,6
oplot,zz,bm[nx/4,ny/4,*,2],col=122 & loadct,5
;
END
