;$Id: pts_xyaver_bxby.pro,v 1.16 2019/10/20 13:33:18 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=6,yoffset=3
  !p.charthick=2 & !p.thick=2 & !x.thick=2 & !y.thick=2
end
;
;  to be used for Willis flow, axel/kinematic/chen_long/T32a
;
lwrite_bxbym=0 ;(to use saved file)
lwrite_bxbym=1 ;(to recompute savefile)
;
iplot=21  ;(NNT17a)
iplot=22  ;(NNT32b)
iplot=2 & dir='NNT32a_rep'
iplot=1
iplot=2 & dir='NNT32a_rot' & iz=8
iplot=3 & dir='TTT48a_rep'
;
cwd,run
if run eq dir then print,'OK' else stop
;
!p.charsize=1.0
!p.multi=[0,2,1]
!x.margin=[6.0,.2]
!y.margin=[3.1,.2]
!x.title='!8t!6'
!y.title='!6'
bar='!20!s!A$!n!r!6'
bar2='!20!s!u$!n!r!6'
siz=1.4
;
pc_read_ts,o=ts
if iplot eq 1 then begin
  xr=[0,41]
  xr2=[0,41]
  yr=[5e-10,2e-5]
  yr2=[5e-10,2e-5]
endif
if iplot eq 2 then begin
  xr=[0,296]
  xr2=[0,296]
  yr=[5e-10,2e-6]
  yr2=[5e-12,2e-5]
endif
if iplot eq 21 then begin
  xr=[0,390]
  yr=[5e-8,2e-5]
endif
if iplot eq 22 then begin
  xr=[0,790]
  yr=[5e-7,2e-2]
endif
if iplot eq 3 then begin
  xr=[0,384]
  xr2=[0,384]
  yr=[5e-9,2e-1]
  yr2=[8e-8,2.3e-6]
endif
;
thick2=5
t=ts.t
plot_io,t,t,xr=xr,yr=yr,/nodata
oplot,t,+ts.bxpt,col=122
oplot,t,-ts.bxpt,col=122,li=2
oplot,t,+ts.bypt,col=55
oplot,t,-ts.bypt,col=55,li=2
loadct,6
oplot,t,+ts.bzpt,col=122
oplot,t,-ts.bzpt,col=122,li=2
loadct,5
;
if iplot eq 1 then begin
  loadct,6
  xx=[26.0,38.5] & oplot,xx,4.2e-7*exp(0.05*xx),col=122
  xyouts,13.4,5.0e-7,'!8B!dz!n!6',siz=.9*siz,col=122
  xyouts,30.,5.5e-7,'!6e!u0.050!8t!6!n',siz=siz,col=122
  loadct,5
  xx=[25.0,35.5] & oplot,xx,1.4e-8*exp(0.05*xx),col=122
  xyouts,30.,1.8e-8,'!6e!u0.050!8t!6!n',siz=siz,col=122
  xyouts,20.4,1.3e-7,'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,10.4,3.3e-6,'!8B!dy!n!6',siz=.9*siz,col=55
endif
;
if iplot eq 2 then begin
  ; coords rotated: x -> z, y -> x, z -> y
  loadct,6
  ;xyouts,100.4,5.0e-7,'!8B!dz!n!6',siz=.9*siz,col=122
  xyouts,170.4,4.0e-7,'!8B!dy!n!6',siz=.9*siz,col=122
  loadct,5
  ;xyouts,31.4,4.4e-8,'!8B!dy!n!6',siz=.9*siz,col=55
  xyouts,90.4,1.2e-8,'!8B!dx!n!6',siz=.9*siz,col=55
  ;xyouts,110.4,1.2e-9,'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,102.,2.2e-9,'!8B!dz!n!6',siz=.9*siz,col=122
  xx=[180.,270.] & oplot,xx,1.3e-9*exp(.014*xx)
  xyouts,220,1.5e-8,siz=.9*siz,'!9A!6e!u0.014!8t!6!n'
endif
;
if iplot eq 21 then begin
  loadct,6
  xyouts,33.4,3.0e-7,'!8B!dz!n!6',siz=.9*siz,col=122
  loadct,5
  xyouts,31.4,2.8e-7,'!8B!dy!n!6',siz=.9*siz,col=55
  xyouts,50.4,1.2e-7,'!8B!dx!n!6',siz=.9*siz,col=122
endif
;
if iplot eq 3 then begin
  loadct,6
  xyouts,15.4,6.0e-6,'!8B!dz!n!6',siz=.9*siz,col=122
  loadct,5
  xyouts,100.8,7.3e-5,'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,150.4,7.3e-6,'!8B!dy!n!6',siz=.9*siz,col=55
  xx=[230.,340.] & oplot,xx,5e-8*exp(.034*xx)
  xyouts,260.,8.8e-5,'!9A!6e!u0.034!8t!6!n',siz=siz
endif
;
default,iz,0
if lwrite_bxbym then begin
  pc_read_xyaver,obj=xya
  t=xya.t & nt=n_elements(t)
  z=xya.z & nz=n_elements(z)
  bxmrms=sqrt(total(xya.bxmz^2,1)/nz)
  bymrms=sqrt(total(xya.bymz^2,1)/nz)
  bxpt=reform(xya.bxmz[iz,*])
  bypt=reform(xya.bymz[iz,*])
  print,'.c ;(to overwrite)'
  stop
  save,file='bxbym.sav',t,bxmrms,bymrms,bxpt,bypt
endif else begin
  restore,'bxbym.sav'
endelse
;
if iplot eq 1 then begin
  yr=[5e-11,2e-6]
endif
if iplot eq 2 then begin
  ;yr=[5e-16,2e-6]
  ;xx=[170.,280.] & oplot,xx,1e-9*exp(0.014*xx)
  ;xx=[170.,280.] & oplot,xx,1e-9*exp(-.024*xx)
endif
;
if iplot eq 3 then begin
  ;yr=[5e-10,2e-5]
endif
;
thick2=5
plot_io,t,t,xr=xr2,yr=yr2,/nodata
oplot,t,bxpt,col=122
oplot,t,-bxpt,col=122,li=2
oplot,t,+bypt,col=55
oplot,t,-bypt,col=55,li=2
;
if iplot eq 1 then begin
  xx=[25.0,35.5] & oplot,xx,1.4e-7*exp(0.05*xx),col=122
  xx=[22.0,32.5] & oplot,xx,4.0e-6*exp(-.26*xx),col=55
  xyouts,30.,1.8e-7,'!6e!u0.050!8t!6!n',siz=siz,col=122
  xyouts,30.,2.0e-9,'!6e!u-0.26!8t!6!n',siz=siz,col=55
  xyouts,13.4,5.0e-8,bar+'!8B!dy!n!6',siz=.9*siz,col=55
  xyouts,20.4,1.3e-7,bar+'!8B!dx!n!6',siz=.9*siz,col=122
  x1=24.795
  x2=35.545
  x0=-1.5*(x2-x1)
  y0=1e-9
  yr1=y0*(1.+.25*[-1,1])
  yr2=y0*(1.+.25*[-1,1])
  oplot,x0+[1,1]*x1,yr1,thick=thick2
  oplot,x0+[1,1]*x2,yr2,thick=thick2
  oplot,x0+[x1,x2],y0*[1,1],thick=thick2
  print,2*!pi/(x2-x1)
  xyouts,10.5,y0/2.8,'!62!7p!6/0.58',siz=.7*siz;,col=55
endif
if iplot eq 2 then begin
  ; coords rotated: x -> z, y -> x, z -> y
  ;xyouts,86.,1.2e-11,bar+'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,70.,1.2e-9,bar+'!8B!dz!n!6',siz=.9*siz,col=122
  ;xyouts,790.,1.2e-9,bar+'!8B!dy!n!6',siz=.9*siz,col=55
  xyouts,90.,1.7e-6,bar+'!8B!dx!n!6',siz=.9*siz,col=55
  xx=[120.,280.] & oplot,xx,9e-8*exp(0.014*xx)
  xx=[100.,240.] & oplot,xx,1.4e-6*exp(-.048*xx)
  xyouts,200,3e-7,siz=.9*siz,'!9A!6e!u0.014!8t!6!n'
  xyouts,200,2e-10,siz=.9*siz,'!9A!6e!u-0.048!8t!6!n'
endif
if iplot eq 21 then begin
  xyouts,17.4,5.9e-7,bar+'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,33.4,7.0e-8,bar+'!8B!dy!n!6',siz=.9*siz,col=55
endif
if iplot eq 3 then begin
  xx=[102.0,355.] & oplot,xx,1.1e-7*exp(+.0058*xx),col=55
  xx=[102.0,355.] & oplot,xx,4.2e-7*exp(+.0038*xx),col=122
  xyouts,230.,3.0e-7,'!9A!6e!u0.058!8t!6!n',siz=siz,col=55
  xyouts,110.,4.8e-7,'!9A!6e!u0.038!8t!6!n',siz=siz,col=122
  xyouts,50.4,7.9e-7,bar+'!8B!dx!n!6',siz=.9*siz,col=122
  xyouts,53.4,1.1e-7,bar+'!8B!dy!n!6',siz=.9*siz,col=55
endif
;
print,'$mv idl.ps ~/tex/mhd/long_chen/fig/pts_xyaver_bxby_'+run+'.ps'
END
