#!/usr/bin/env bash

## "PPHPC MIComp Datasets" by Nuno Fachada are licensed under the 
## Creative Commons Attribution 4.0 International License. To view a 
## copy of this license, visit http://creativecommons.org/licenses/by/4.0/ 
## or send a letter to Creative Commons, PO Box 1866, Mountain View, 
## CA 94042, USA.

# ################################################ #
# Script used to create the PPHPC MIComp Datasets  #
# Java implementation, EX variant, no misalignment #
# ################################################ #

# Location of the Java PPHPC implementation
PPDIR="${HOME}/workspace/pphpc/java"

# Location of output files
OUTDIR="./j_ex_ok"

# Location of simulation configuration files
CFGDIR="${HOME}/workspace/pphpc/configs"

# Java command to run PPHPC
PPCMD="java -Xms2048m -Xmx4096m -cp ${PPDIR}/bin:${PPDIR}/lib/* org.laseeb.pphpc.PredPrey"

# Number of threads to use
THREADS=8

# Create output directory if it doesn't yet exist
mkdir -p ${OUTDIR}

# Start runs
for RUN in {31..60}
do
    # Determine seed for this run
    SEED=`echo ${RUN} | md5sum | cut -f 1 -d ' '`
    SEED=`echo ${SEED} | awk '{print toupper($0)}'`
    SEED=`echo "ibase=16; ${SEED}" | bc`

    # Cycle through model sizes
    for SIZE in 100 200 400 800
    do

        # Cycle through parameter sets
        for VERS in 1 2
        do

            # Equal with reproducibility parallelization strategy (EX)
            OUTFILE="${OUTDIR}/stats${SIZE}v${VERS}pEXt${THREADS}r${RUN}.txt"
            if [ ! -f ${OUTFILE} ]; then

                # Print info about current run
                echo "Run: ${RUN}, Param.Set: ${VERS}, Size: ${SIZE}, SEED: ${SEED}"

                # Perform run
                ${PPCMD} -p ${CFGDIR}/config${SIZE}v${VERS}.txt -s ${OUTFILE} -r ${SEED} -n ${THREADS} -ps EX

            fi

        done
    done
done
