% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{vintegrate}
\alias{vintegrate}
\alias{vintegrate.vp}
\alias{vintegrate.vplist}
\alias{vintegrate.vpts}
\title{Vertically integrate profiles}
\usage{
vintegrate(x, alt.min, alt.max, alpha = NA)

\method{vintegrate}{vp}(x, alt.min = 0, alt.max = Inf, alpha = NA)

\method{vintegrate}{vplist}(x, alt.min = 0, alt.max = Inf, alpha = NA)

\method{vintegrate}{vpts}(x, alt.min = 0, alt.max = Inf, alpha = NA)
}
\arguments{
\item{x}{a \code{vp}, \code{vplist} or \code{vpts} object}

\item{alt.min}{minimum altitude in m}

\item{alt.max}{maximum altitude in m}

\item{alpha}{migratory direction in clockwise degrees from north}
}
\value{
an object of class \code{vivp}, a data frame with vertically integrated profile quantities
}
\description{
Performs a vertical integration of density, reflectivity and migration traffic rate.
}
\details{
The function generates a specially classed data frame with the following quantities
\describe{
   \item{\code{datetime}}{POSIXct date of each profile in UTC}
   \item{\code{vid}}{Vertically Integrated Density in individuals/km^2. \code{vid} is a surface density,
         whereas \code{dens} in \code{vp} objects is a volume density.}
   \item{\code{vir}}{Vertically Integrated Reflectivity in cm^2/km^2}
   \item{\code{mtr}}{Migration Traffic Rate in individuals/km/h}
   \item{\code{rtr}}{Reflectivity Traffic Rate in cm^2/km/h}
}
Vertically integrated density and reflectivity are related according to \eqn{vid=vir/rcs(x)}, with \link[bioRad]{rcs}
the assumed radar cross section per individual. Similarly, migration traffic rate and reflectivity
traffic rate are related according to \eqn{mtr=rtr/rcs(x)}

See \link[bioRad]{mtr} for further information on the definition of migration traffic rate.
}
\section{Methods (by class)}{
\itemize{
\item \code{vp}: Vertically integrate a vertical profile

\item \code{vplist}: Vertically integrate a list of vertical profiles

\item \code{vpts}: Vertically integrate a time series of vertical profiles
}}

\examples{
### MTR for a single vertical profile ###
vintegrate(VP)

### MTRs for a list of vertical profiles ###
vintegrate(c(VP,VP))

### MTRs for a time series of vertical profiles ###
# load example data:
data(VPTS)
VPTS
# print migration traffic rates:
vivp=vintegrate(VPTS)
# plot migration traffic rates for the full air column:
plot(VPTS)
#' plot migration traffic rates for altitudes > 1 km above sea level
plot(vintegrate(VPTS,alt.min=1000))
}
