% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{summary.scan}
\alias{summary.scan}
\alias{is.scan}
\alias{dim.scan}
\title{Class 'scan': polar scan}
\usage{
\method{summary}{scan}(object, ...)

is.scan(x)

\method{dim}{scan}(x)
}
\arguments{
\item{object}{object of class 'scan'}

\item{...}{additional arguments affecting the summary produced.}

\item{x}{object of class 'scan'}
}
\value{
for \code{is.scan}: \code{TRUE} if its argument is of class "\code{scan}"

for \code{dim.scan}: dimensions of the scan
}
\description{
Class 'scan': polar scan
}
\details{
A polar scan object of class 'scan' is a list containing:
\describe{
 \item{\code{params}}{a list with scan parameters}
 \item{\code{attributes}}{list with the scans's \code{\\what}, \code{\\where} and \code{\\how} attributes}
 \item{\code{geo}}{geographic data, a list with:
    \describe{
     \item{\code{lat}}{latitude of the radar [decimal degrees]}
     \item{\code{lon}}{longitude of the radar [decimal degrees]}
     \item{\code{height}}{height of the radar antenna [metres above sea level]}
     \item{\code{elangle}}{radar beam elevation [degrees]}
     \item{\code{rscale}}{range bin size [m]}
     \item{\code{ascale}}{azimuth bin size [deg]}
    }
    The \code{geo} element of a 'scan' object is a copy of the \code{geo} element of its parent polar volume of class 'pvol'.
  }
}
}
\examples{
# load example scan object
data(SCAN)
# print the scan parameters contained in the scan:
SCAN$params
# extract the first scan parameter:
param=SCAN$params[1]
is.scan("this is not a polar scan but a string")  #> FALSE
}
