% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_vp.R
\name{retrieve_vp_paths}
\alias{retrieve_vp_paths}
\title{Collect a list of vp file names}
\usage{
retrieve_vp_paths(path, start_date, end_date, country = NULL, radar = NULL)
}
\arguments{
\item{path}{main path to look into recusively}

\item{start_date}{ISO format date as start of the vp file query}

\item{end_date}{ISO format date as end of the vp file query}

\item{country}{char vector with two letter country shortcuts}

\item{radar}{char vector with three letter radar sindicators. This can be
defined independently from the countries named.}
}
\value{
char list of filenames that comply to the given radar/country and
date range query
}
\description{
Collect a list of vp file names within a directory that comply to the given
country, radar and date range combination
}
\examples{
my_path <- "~/my/directory/"
retrieve_vp_paths(my_path, "2016-10-01", "2017-01-31", c("be"))
}
