% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{readvp.table}
\alias{readvp.table}
\title{Read vertical profiles from vol2bird stdout}
\usage{
readvp.table(file, radar, wavelength = "C")
}
\arguments{
\item{file}{A text file containing the standard output (stdout) generated by vol2bird}

\item{radar}{string containing a radar identifier}

\item{wavelength}{radar wavelength in cm, or one of 'C' or 'S' for C-band and S-band radar, respectively}
}
\value{
an object inhereting from class "\code{vpts}", see \link[bioRad]{vpts} for details
}
\description{
Read vertical profiles from vol2bird stdout
}
\examples{
# locate example file:
VPtable <- system.file("extdata", "VPtable.txt", package="bioRad")
# load time series:
ts=readvp.table(VPtable,radar="KBGM", wavelength='S')
ts
}
