% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{read.pvol}
\alias{read.pvol}
\title{Read a polar volume (pvol) from file}
\usage{
read.pvol(filename, param = c("DBZH", "VRADH", "RHOHV", "ZDR", "PHIDP",
  "CELL"), sort = T, lat, lon, height, elangle.min = 0, elangle.max = 90,
  verbose = T, mount = dirname(filename))
}
\arguments{
\item{filename}{A string containing the path to a vertical profile generated by \link[bioRad]{vol2bird}}

\item{param}{atomic vector of character strings, containing the names of scan parameters to read. To read all scan parameters use 'all'.}

\item{sort}{logical. When \code{TRUE} sort scans ascending by elevation}

\item{lat}{latitude in decimal degrees of the radar position. If not specified, value stored in file is used. If specified, value stored in file is overwritten.}

\item{lon}{longitude in decimal degrees of the radar position. If not specified, value stored in file is used. If specified, value stored in file is overwritten.}

\item{height}{height of the centre of the antenna in meters above sea level. If not specified, value stored in file is used. If specified, value stored in file is overwritten.}

\item{elangle.min}{Minimum scan elevation to read in degrees}

\item{elangle.max}{Maximum scan elevation to read in degrees}

\item{verbose}{logical. Whether to print messages to console}

\item{mount}{character string with the mount point (a directory path) for the Docker container}
}
\value{
an object of class \link[=summary.pvol]{pvol}, which is a list containing polar scans, i.e. objects of class \code{scan}
}
\description{
Read a polar volume (pvol) from file
}
\details{
Scan parameters are named according to the OPERA data information model (ODIM), see
Table 16 in the \href{http://www.eumetnet.eu/sites/default/files/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}.
Commonly available parameters are:
\describe{
 \item{"\code{DBZH}", "\code{DBZ}"}{(Logged) reflectivity factor [dBZ]}
 \item{"\code{VRADH}", "\code{VRAD}"}{Radial velocity [m/s]. Radial velocities towards
  the radar are negative, while radial velocities away from the radar are positive}
 \item{"\code{RHOHV}"}{Correlation coefficient [unitless]. Correlation between vertically polarized and horizontally polarized reflectivity factor}
 \item{"\code{PHIDP}"}{Differential phase [degrees]}
 \item{"\code{ZDR}"}{(Logged) differential reflectivity [dB]}
}
}
\examples{
# locate example volume file:
pvol <- system.file("extdata", "volume.h5", package="bioRad")
# print the local path of the volume file:
pvol
# load the file:
vol=read.pvol(pvol)
# print summary info for the loaded polar volume:
vol
# print summary info for the scans in the polar volume:
vol$scans
# copy the first scan to a new object 'scan'
scan=vol$scans[[1]]
# print summary info for the new object:
scan
}
