% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{ppi}
\alias{ppi}
\alias{[.ppi}
\alias{ppi.param}
\alias{ppi.scan}
\title{Make a plan position indicator (ppi)}
\usage{
ppi(x, cellsize = 500, range.max = 50000, project = F, latlim = NULL,
  lonlim = NULL)

\method{[}{ppi}(x, i)

\method{ppi}{param}(x, cellsize = 500, range.max = 50000, project = F,
  latlim = NULL, lonlim = NULL)

\method{ppi}{scan}(x, cellsize = 500, range.max = 50000, project = F,
  latlim = NULL, lonlim = NULL)
}
\arguments{
\item{x}{an object of class 'param' or 'scan'}

\item{cellsize}{cartesian grid size in m}

\item{range.max}{maximum range in m}

\item{project}{whether to vertically project onto earth's surface}

\item{latlim}{the range of latitudes to include}

\item{lonlim}{the range of longitudes to include}

\item{i}{indices specifying elements to extract}

\item{...}{arguments passed to methods}
}
\value{
an object of class '\link[=summary.ppi]{ppi}'.
}
\description{
Make a plan position indicator (ppi)
}
\details{
The returned PPI is in Azimuthal Equidistant Projection.
}
\section{Methods (by class)}{
\itemize{
\item \code{param}: ppi for a single scan parameter

\item \code{scan}: multiple ppi's for all scan parameters in a scan
}}

\examples{
# load a polar scan example object
data(SCAN)
SCAN
# make PPIs for all scan parameters in the scan:
ppi=ppi(SCAN)
# print summary info for the ppi:
ppi
# copy the first scan parameter of the first scan in the volume to a new object 'param':
param=SCAN$params[[1]]
# make a ppi for the new 'param' object:
ppi=ppi(param)
# print summary info for this ppi:
ppi
}
