% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.plot.R
\name{plot.vp}
\alias{plot.vp}
\title{Plot a vertical profile}
\usage{
\method{plot}{vp}(x, quantity = "dens",
  xlab = expression("volume density [#/km"^3 * "]"), ylab = "height [km]",
  line.col = "red", line.lwd = 1, ...)
}
\arguments{
\item{x}{a vp class object}

\item{quantity}{character string with the quantity to plot.
See \link[=summary.vp]{vp} for list of available quantities.
Aerial density related: '\code{dens}','\code{eta}','\code{dbz}','\code{DBZH}' for density, reflectivity, reflectivity factor and total reflectivity factor, respectively.
Ground speed related: '\code{ff}','\code{dd}', for ground speed and direction, respectively.}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{line.col}{Color of the plotted curve}

\item{line.lwd}{Line width of the plotted curve}

\item{...}{Additional arguments to be passed to the low level \link[graphics]{plot} plotting function}
}
\description{
Plot a vertical profile
}
\examples{
data(VP)
plot(VP)
plot(VP,line.col='blue')
}
