% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.plot.R
\name{plot.vivp}
\alias{plot.vivp}
\title{Plot vertically integrated profiles}
\usage{
\method{plot}{vivp}(x, quantity = "mtr", xlab = "time",
  ylab = "migration traffic rate [#/km/h]", main = "MTR",
  nightshade = TRUE, elev = -0.268, lat = NULL, lon = NULL,
  ylim = NULL, ...)
}
\arguments{
\item{x}{a class object inheriting from class \code{vivp}, typically a call to \link[bioRad]{vintegrate}.}

\item{quantity}{character string with the quantity to plot, one of '\code{vid}','\code{vir}','\code{mtr}' for vertically integrated density, reflectivity, reflectivity factor and migration traffic rate, respectively.}

\item{xlab}{a title for the x-axis}

\item{ylab}{a title for the y-axis}

\item{main}{a title for the plot}

\item{nightshade}{logical. whether to plot night time shading}

\item{elev}{numeric. sun elevation to use for day/night transition, see \link[bioRad]{suntime}}

\item{lat}{(optional) latitude in decimal degrees. Overrides the lat attribute of \code{x}}

\item{lon}{(optional) longitude in decimal degrees. Overrides the lon attribute of \code{x}}

\item{ylim}{y-axis plot range, numeric atomic vector of length 2}

\item{...}{Additional arguments to be passed to the low level \link[graphics]{plot} plotting function}
}
\description{
Plot an object of class \code{vivp}.
}
\details{
Profile can be visualised in three related quantities, as specified by argument \code{quantity}:
\describe{
 \item{"\code{vid}"}{Vertically Integrated Density, i.e. the aerial surface density of individuals. This quantity is dependent on the assumed radar cross section per individual (RCS)}
 \item{"\code{vir}"}{Vertically Integrated Reflectivity. This quantity is independent of the value of individual's radar cross section}
 \item{"\code{mtr}"}{Migration Traffic Rate. This quantity is dependent on the assumed radar cross section (RCS)}
 \item{"\code{rtr}"}{Reflectivity Traffic Rate. This quantity is independent on the assumed radar cross section (RCS)}
}
}
\examples{
# vertically integrate a vpts object:
vi.vpts=vintegrate(VPTS)
# plot the migration traffic rates
plot(vi.vpts)
# plot the vertically integrated densities, without night shading:
plot(vi.vpts,quantity="vid",nightshade=FALSE)
}
