% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{night}
\alias{night}
\title{Calculate whether it is night at a geographic location and time}
\usage{
night(lon, lat, date, elev = -0.268)
}
\arguments{
\item{lon}{longitude in decimal degrees}

\item{lat}{latitude in decimal degrees}

\item{date}{date inhereting from class "\code{POSIXt}" or a string interpretable by \link[base]{as.Date}}

\item{elev}{sun elevation in degrees}
}
\value{
TRUE when night, FALSE when day
}
\description{
Calculate whether it is night at a geographic location and time
}
\details{
The angular diameter of the sun is about 0.536 degrees, therefore the moment
of sunrise/sunset corresponds to half that elevation at -0.268 degrees.

day evaluates to true when the sun has a higher elevation than parameter elev, otherwise to false

Approximate astronomical formula are used, therefore the day/night transition may
be off by a few minutes
}
\examples{
# it's day in the Netherlands at UTC noon on January first:
night(5,53,"2016-01-01 12:00")

}
