% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{mt}
\alias{mt}
\title{Migration traffic}
\usage{
mt(x, alt.min = 0, alt.max = Inf, alpha = NA)
}
\arguments{
\item{x}{an object inhereting from class '\code{vpts}'}

\item{alt.min}{minimum altitude in m}

\item{alt.max}{maximum altitude in m}

\item{alpha}{(optional) migratory direction of interest in clockwise degrees from north, otherwise \code{NA}}
}
\value{
a numeric value equal to migration traffic in number of individuals / km
}
\description{
Total migration traffic, which is calculated by time-integration
of migration traffic rates. Migration traffic gives the number of individuals
that have passed per km perpendicular to the migratory direction at the
position of the radar for the full period of the time series
within the specified altitude band.
}
\examples{
# get example time series object
data(VPTS)
VPTS
# total migration traffic in full altitude band
mt(VPTS)
# total migration traffic in 0-1000 meter band
mt(VPTS,alt.min=0,alt.max=1000)
}
