% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{map}
\alias{map}
\alias{map.ppi}
\title{Map a plan position indicator (ppi)}
\usage{
map(x, ...)

\method{map}{ppi}(x, map, param, alpha = 0.7, xlim, ylim, zlim = c(-20, 20),
  ratio, radar.size = 3, radar.color = "red", ...)
}
\arguments{
\item{x}{an object of class 'ppi'}

\item{...}{arguments passed to low level \link[ggmap]{ggmap} function}

\item{map}{the basemap to use, result of a call to \link{basemap}}

\item{param}{the scan parameter to plot}

\item{alpha}{transparency of the data, value between 0 and 1}

\item{xlim}{range of x values to plot}

\item{ylim}{range of y values to plot}

\item{zlim}{the range of values to plot}

\item{ratio}{aspect ratio between x and y scale, by default \eqn{1/cos(latitude radar * pi/180)}}

\item{radar.size}{size of the symbol indicating the radar position}

\item{radar.color}{colour of the symbol indicating the radar position}
}
\value{
a ggmap object (a classed raster object with a bounding box attribute)
}
\description{
Plot a ppi on a Google Maps, OpenStreetMap, Stamen Maps or Naver Map base layer map using \link[ggmap]{ggmap}
}
\section{Methods (by class)}{
\itemize{
\item \code{ppi}: plot a 'ppi' object on a map
}}

\examples{
# load an example scan:
data(SCAN)
# make ppi's for all scan parameters in the scan
ppi=ppi(SCAN)
# grab a basemap that matches the extent of the ppi:
basemap=basemap(ppi)
# map the radial velocity scan parameter onto the basemap:
map(ppi,map=basemap,param="VRADH")
# extend the plotting range of velocities, from -50 to 50 m/s:
map(ppi,map=basemap,param="VRADH",zlim=c(-50,50))
# give the data less transparency:
map(ppi,map=basemap,alpha=0.9)
# change the appearance of the symbol indicating the radar location:
map(ppi,map=basemap,radar.size=5,radar.color="green")
# crop the map:
map(ppi,map=basemap,xlim=c(12.4,13.2),ylim=c(56,56.5))
}
