% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{fetch}
\alias{fetch}
\alias{fetch.vp}
\alias{fetch.vplist}
\alias{fetch.vpts}
\title{fetch a profile quantity}
\usage{
fetch(x, quantity)

\method{fetch}{vp}(x, quantity = "dens")

\method{fetch}{vplist}(x, quantity = "dens")

\method{fetch}{vpts}(x, quantity = "dens")
}
\arguments{
\item{x}{a vp,vplist or vpts object}

\item{quantity}{a profile quantity, one of
\code{"HGHT"},\code{"u"},\code{"v"},\code{"w"},\code{"ff"},
\code{"dd"},\code{"sd_vvp"},\code{"gap"},\code{"dbz"},\code{"eta"},
\code{"dens"},\code{"DBZH"},\code{"n"},\code{"n_all"},\code{"n_dbz"},\code{"n_dbz_all"}.}
}
\value{
class \code{vp}: a named vector for the requested quantity

class \code{vplist}: a list of a named vectors for the requested quantity

class \code{vpts}: a (height x time) matrix of the requested quantity
}
\description{
fetch a profile quantity
}
\details{
This function grabs any of the data quantities stored in \link[=summary.vp]{vp},
\link[=summary.vplist]{vplist} or \link[=summary.vpts]{vpts} objects.

See the documentation of the vertical profile \link[=summary.vp]{vp} class
for a description of each of these quantities.
}
