% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{elangle}
\alias{elangle}
\alias{elangle.scan}
\alias{elangle.pvol}
\title{Elevation angle of scan(s)}
\usage{
elangle(x)

\method{elangle}{scan}(x)

\method{elangle}{pvol}(x)
}
\arguments{
\item{x}{a \code{pvol} or \code{scan} object}
}
\value{
elevation in degrees
}
\description{
Gives the elevation angle of a scan, or the elevation angles within a polar volume
}
\section{Methods (by class)}{
\itemize{
\item \code{scan}: elevation angle of a scan

\item \code{pvol}: elevation angles of all scans in a polar volume
}}

\examples{
# load a polar volume
pvol <- system.file("extdata", "volume.h5", package="bioRad")
vol=read.pvol(pvol)
# elevations for the scans in the volume
elangle(vol)
# extract the first scan:
scan=vol$scans[[1]]
# elevation angle of the scan:
elangle(scan)
}
