% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_vp.R
\name{download_vp}
\alias{download_vp}
\title{Download a set of vp bird profiles from ENRAM repository}
\usage{
download_vp(start_date, end_date, country, radar, localpath = ".")
}
\arguments{
\item{start_date}{ISO fomat date indicating the first date to download files from}

\item{end_date}{ISO fomat date indicating the last date to download files from}

\item{country}{char vector with two letter country shortcuts}

\item{radar}{char vector with three letter radar sindicators. Make sure the
radars selected are in accordance to the country selection}

\item{localpath}{char defining the location to store the downloaded zip
folders and unzip into the default folder structure}
}
\description{
Download a set of vp bird profiles from the ENRAM repository.
These are stored within monthly available
zip folders. This function downloads and unzips them at a user defined location.
Check \href{http://enram.github.io/data-repository/}{http://enram.github.io/data-repository/} for an overview
of available data.
}
\examples{
my_path <- "~/my/directory/"
\dontrun{download_vp("2016-10-01", "2016-11-30", c("be"), c("jab", "wid"), localpath = my_path)}
}
