% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.R
\name{cmt}
\alias{cmt}
\title{Cumulative migration traffic}
\usage{
cmt(x, alt.min = 0, alt.max = Inf, alpha = NA)
}
\arguments{
\item{x}{an object inhereting from class '\code{vpts}'}

\item{alt.min}{minimum altitude in m}

\item{alt.max}{maximum altitude in m}

\item{alpha}{(optional) migratory direction of interest in clockwise degrees from north, otherwise \code{NA}}
}
\value{
a numeric value equal to migration traffic in number of individuals / km
}
\description{
Cumulative migration traffic is calculated as the cumulative sum
of the migration traffic within each time step of a time series.
Cumulative migration traffic gives the number of individuals
that have passed per km perpendicular to the migratory direction at the
position of the radar as a function oftime from the start of time series
within the specified altitude band.
}
\examples{
# get the VPTS example dataset:
data(VPTS)
# print cumulative migration traffic to console:
cmt(VPTS)
# plot cumulative migration traffic:
plot(cmt(VPTS),type='l',xlab="time",ylab="CMT [birds/km]")
}
