% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioRad.ppi.R
\name{basemap}
\alias{basemap}
\title{Grab a basemap for a ppi}
\usage{
basemap(x, verbose = TRUE, zoom, ...)
}
\arguments{
\item{x}{an object of class 'ppi'}

\item{verbose}{logical. whether to print information to console}

\item{zoom}{zoom level (optional), see \link[ggmap]{get_map}. An integer from 3 (continent) to 21 (building).
By default the zoom level matching the ppi extent is selected automatically.}

\item{...}{arguments to pass to \link[ggmap]{get_map} function}
}
\description{
downloads a Google Maps, OpenStreetMap, Stamen Maps or Naver Map base layer map using \link[ggmap]{get_map}
}
\examples{
# load an example scan:
data(SCAN)
# print summary info for the scan:
SCAN
# make ppi for the scan
ppi=ppi(SCAN)
# grab a basemap that matches the extent of the ppi:
basemap=basemap(ppi)
# map the reflectivity quantity of the ppi onto the basemap:
map(ppi,map=basemap,param="DBZH")
# download a different type of basemap, e.g. satellite imagery:
# see get_map() in ggmap library for full documentation of options
basemap=basemap(ppi,maptype="satellite")
# map the radial velocities onto the satellite imagery:
map(ppi,map=basemap,param="VRADH")
}
