% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{setNodeShapeMapping}
\alias{setNodeShapeMapping}
\title{Set Node Shape Mapping}
\usage{
setNodeShapeMapping(table.column, table.column.values, shapes,
  default.shape = NULL, style.name = "default", network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{table.column}{Name of Cytoscape table column to map values from}

\item{table.column.values}{List of values from Cytoscape table to be used in mapping}

\item{shapes}{List of shapes to map to table.column.values. See \link{getNodeShapes}}

\item{default.shape}{Shape to set as default. See \link{getNodeShapes}}

\item{style.name}{Name of style; default is "default" style}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Map table column values to shapes to set the node shape.
}
\examples{
\donttest{
setNodeShapeMapping('type',c('protein','dna'),c('ELLIPSE','RECTANGLE'))
}
}
