% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleBypasses.R
\name{setNodeHeightBypass}
\alias{setNodeHeightBypass}
\title{Set Node Height Bypass}
\usage{
setNodeHeightBypass(node.names, new.heights, network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{node.names}{List of node names}

\item{new.heights}{List of height values, or single value}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Override the height for particular nodes.
}
\details{
This method permanently overrides any default values or mappings 
defined for this visual property of the node or nodes specified. This method
ultimately calls the generic function, \link{setNodePropertyBypass}, which 
can be used to set any visual property. To restore defaults and mappings, use
 \link{clearNodePropertyBypass}, see examples.
}
\examples{
\donttest{
setNodeHeightBypass('Node 1', 35)
setNodeHeightBypass(c('Node 1','Node 2'), 35)
clearNodePropertyBypass(c('Node 1','Node 2'), 'NODE_HEIGHT')
}
}
\seealso{
{
\link{setNodePropertyBypass},
\link{clearNodePropertyBypass}
}
}
