% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{setNodeFontFaceMapping}
\alias{setNodeFontFaceMapping}
\title{Set Node Font Face Mapping}
\usage{
setNodeFontFaceMapping(table.column, table.column.values, fonts,
  mapping.type = "d", default.font = NULL, style.name = "default",
  network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{table.column}{Name of Cytoscape table column to map values from}

\item{table.column.values}{List of values from Cytoscape table to be used in 
mapping}

\item{fonts}{List of string specifications of font face, style and size, e.g., 
c("SansSerif,plain,12", "Dialog,plain,10")}

\item{mapping.type}{(char) discrete or passthrough (d,p); 
default is discrete}

\item{default.font}{String specification of font face, style and size, e.g., 
"SansSerif,plain,12" or "Dialog,plain,10"}

\item{style.name}{Name of style; default is "default" style}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets font face for node labels.
}
\examples{
\donttest{
setNodeFontFaceMapping("myfonts", c("normal","small"),
c("SansSerif,plain,12", "Dialog,plain,10"))
}
}
