% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{setNodeComboOpacityMapping}
\alias{setNodeComboOpacityMapping}
\title{Set Node Combo Opacity Mapping}
\usage{
setNodeComboOpacityMapping(table.column, table.column.values = NULL,
  opacities = NULL, mapping.type = "c", default.opacity = NULL,
  style.name = "default", network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{table.column}{Name of Cytoscape table column to map values from}

\item{table.column.values}{List of values from Cytoscape table to be used in 
mapping}

\item{opacities}{(integer) values between 0 and 255; 0 is invisible}

\item{mapping.type}{(char) continuous, discrete or passthrough (c,d,p); 
default is continuous}

\item{default.opacity}{Opacity value to set as default for all unmapped 
values}

\item{style.name}{Name of style; default is "default" style}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets opacity for node fill, border and label all together.
}
\examples{
\donttest{
setNodeComboOpacityMapping('score', c(-5,5), c(50,255))
}
}
