% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{setNodeBorderWidthMapping}
\alias{setNodeBorderWidthMapping}
\title{Set Node Border Width Mapping}
\usage{
setNodeBorderWidthMapping(table.column, table.column.values = NULL,
  widths = NULL, mapping.type = "c", default.width = NULL,
  style.name = "default", network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{table.column}{Name of Cytoscape table column to map values from}

\item{table.column.values}{List of values from Cytoscape table to be used in mapping}

\item{widths}{List of width values to map to table.column.values}

\item{mapping.type}{(char) continuous, discrete or passthrough (c,d,p); default is continuous}

\item{default.width}{Width value to set as default for all unmapped values}

\item{style.name}{Name of style; default is "default" style}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Map table column values to widths to set the node border width.
}
\examples{
\donttest{
setNodeBorderWidthMapping('score', c(0,30), c(1,5))
}
}
