% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{setLayoutProperties}
\alias{setLayoutProperties}
\title{Set Layout Properties}
\usage{
setLayoutProperties(layout.name, properties.list,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{layout.name}{(\code{character}) Name of the layout}

\item{properties.list}{(\code{list}) List of one or more \code{property=value} pairs}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets the specified properties for the specified layout. Unmentioned properties are left unchanged.
}
\details{
Run \link{getLayoutNames} to list available layouts. Run \link{getLayoutPropertyNames} to list properties per layout.
}
\examples{
\donttest{
setLayoutProperties('force-directed', list(defaultSpringLength=50, defaultSpringCoefficient=6E-04))
# Successfully updated the property 'defaultSpringLength'.
# Successfully updated the property 'defaultSpringCoefficient'.
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
