% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{setEdgeLineStyleMapping}
\alias{setEdgeLineStyleMapping}
\title{Set Edge Line Style Mapping}
\usage{
setEdgeLineStyleMapping(table.column, table.column.values, line.styles,
  default.line.style = "SOLID", style.name = "default",
  network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{table.column}{Name of Cytoscape table column to map values from}

\item{table.column.values}{List of values from Cytoscape table to be used in mapping}

\item{line.styles}{List of line styles. See \link{getLineStyles}.}

\item{default.line.style}{Style to set as default. See \link{getLineStyles}.}

\item{style.name}{Name of style; default is "default" style}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Map table column values to styles to set the edge style.
}
\examples{
\donttest{
setEdgeLineStyleMapping('type',c('pp','pd'),c('SOLID','LONG_DASH'))
}
}
