% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSelection.R
\name{selectFirstNeighbors}
\alias{selectFirstNeighbors}
\title{Select first neighbor nodes}
\usage{
selectFirstNeighbors(direction = "any", network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{direction}{direction of connections to neighbors to follow, e.g., 
incoming, outgoing, undirected, or any (default)}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
list of suids of selected nodes, including original selection
}
\description{
Select nodes directly connected to currently selected nodes. Can
specify connection directionality using the direction param.
}
\examples{
\donttest{
selectFirstNeighbors()
selectFirstNeighors('outgoing')
selectFirstNeighors('incoming')
}
}
