% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{layoutNetwork}
\alias{layoutNetwork}
\title{Apply a layout to a network}
\usage{
layoutNetwork(layout.name = NULL, network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{layout.name}{(\code{character}) Name of the layout (with optional parameters). 
If not specified, then the preferred layout set in the Cytoscape UI is applied.}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Apply a layout to a network
}
\details{
Run \link{getLayoutNames} to list available layouts.
}
\examples{
\donttest{
layoutNetwork()
layoutNetwork('force-directed')
layoutNetwork('force-directed defaultSpringCoefficient=.00006 defaultSpringLength=80')
}
}
