% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tables.R
\name{getTableValue}
\alias{getTableValue}
\title{Get table cell value}
\usage{
getTableValue(table, row.name, column, namespace = "default",
  network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{table}{name of table, e.g., node, edge, network}

\item{row.name}{Node, edge or network name, i.e., the value in the "name"
column}

\item{column}{name of column to retrieve values from}

\item{namespace}{namespace of table; default is "default"}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{data.frame} of column values
}
\description{
Retrieve the value from a specific row and column from node, 
edge or network tables.
}
\examples{
\donttest{
getTableValue('node','node 1', 'score')
}
}
