% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{getLayoutPropertyType}
\alias{getLayoutPropertyType}
\title{Get Layout Property Type}
\usage{
getLayoutPropertyType(layout.name, property.name,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{layout.name}{(\code{character}) Name of the layout}

\item{property.name}{(\code{character}) Name of the property}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{character} string specifying the type
}
\description{
Returns the type of one of the tunable properties (property.name) for the specified layout.
}
\details{
Run \link{getLayoutNames} to list available layouts. Run \link{getLayoutPropertyNames} to list properties per layout.
}
\examples{
\donttest{
getLayoutPropertyType('force-directed','defaultSpringLength')
# "double"
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
