% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{getFirstNeighbors}
\alias{getFirstNeighbors}
\title{Get list of nodes neighboring provided list}
\usage{
getFirstNeighbors(node.names = NULL, as.nested.list = FALSE,
  network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{node.names}{A \code{list} of node names from the \code{name} column 
of the \code{node table}. Default is currently selected nodes.}

\item{as.nested.list}{\code{logical} Whether to return lists of neighbors per query node}

\item{network}{(optional) Name or SUID of the network. Default is the "current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A list of unique node names, optionally nested per query node name.
}
\description{
Returns a non-redundan list of first
neighbors of the supplied list of nodes or current node selection.
}
\examples{
\donttest{
getFirstNeighbors()
}
}
\seealso{
selectNodes
selectFirstNeighbors
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
