% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filters.R
\name{createDegreeFilter}
\alias{createDegreeFilter}
\title{Create Degree Filter}
\usage{
createDegreeFilter(filter.name, criterion, predicate = "BETWEEN",
  edgeType = "ANY", hide = FALSE, network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{filter.name}{Name for filter.}

\item{criterion}{A two-element vector of numbers, example: c(1,5).}

\item{predicate}{BETWEEN (default) or IS_NOT_BETWEEN}

\item{edgeType}{(optional) Type of edges to consider in degree count: 
ANY (default), UNDIRECTED, INCOMING, OUTGOING, DIRECTED}

\item{hide}{Whether to hide filtered out nodes and edges. Default is FALSE.
Ignored if all nodes or edges are filtered out. This is an alternative to 
filtering for node and edge selection.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
List of selected nodes and edges.
}
\description{
Creates a filter to control node selection base on in/out degree.
}
\examples{
\donttest{
createDegreeFilter('myFilter', c(2,5))
}
}
