% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{addCyNodes}
\alias{addCyNodes}
\title{Add CyNodes}
\usage{
addCyNodes(node.names, skip.duplicate.names = TRUE, network = NULL,
  base.url = .defaultBaseUrl)
}
\arguments{
\item{node.names}{A \code{list} of node names}

\item{skip.duplicate.names}{Skip adding a node if a node with the same name is already in
the network. If \code{FALSE} then a duplicate node (with a unique SUID) will be added. Default
is \code{TRUE}.}

\item{network}{(optional) Name or SUID of the network. Default is the "current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{list} of \code{named lists} of name and SUID for each node added.
}
\description{
Add one or more nodes to a Cytoscape network.
}
\examples{
\donttest{
addCyNodes()
}
}
