# Help files for Virtual ChIP-seq scripts


## Creating matrix for training or prediction
```
usage: virchip-make-input-data.py [-h] [--rna-cell CELL]
                                  [--blacklist_path BLACKLIST]
                                  --chromsize-path CHROMLEN --dnase-path DNASE
                                  [--bin_size BP] [--array-id JOBARRAY]
                                  [--merge-chips]
                                  tf out-path chipexp-dir rna-path ref-dir

Generate a table of Cistrome and ENCODE ChIP-seq data, sequence motif scores,
genomic conservation, expression score, and chromatin accessibility data for
the transcription factor of interest.

positional arguments:
  tf                    Name of transcription factor
  out-path              Output file
  chipexp-dir           Directory with tables named as as
                        <TF>_<chrom>_TfGeneExpCorrelation.tsv.gz which store
                        correlation of gene expression and ChIP-seq binding at
                        each genomic bin.Execute virchip-download.sh and
                        specify data/chipExpDir
  rna-path              Matrix of gene expression values with first column as
                        gene symbols and other columns as cell types
  ref-dir               Directory with <chrom>_<tf>_ChIPseqdata.tsv.gz files,
                        which contain publicly available ChIP-seq
                        data,<chrom>_FIMO_JASPAR_<MotifName>_<MotifID>.tsv.gz
                        files which contain sequence motif scores, and
                        <chrom>_PhastCons.tsv.gz files which contain genomic
                        conservation scores. Execute virchip-download.sh and
                        specify data/RefTables

optional arguments:
  -h, --help            show this help message and exit
  --rna-cell CELL       Column name in rna_path matrix corresponding to cell
                        of interest. If not specified, assumes --dnase_path is
                        a directory with dnase files where rna_cell is
                        <cell>_.. and out_path is directory for writing output
                        file named as <cell>_<tf>_<accession>_virtual_chip_com
                        plete_table.tsv.gz. It will use --array_id to select
                        cell types using files in --dnase_path
  --blacklist_path BLACKLIST
                        Blacklist regions. Must be binned into same length as
                        --bin_size
  --bin_size BP         Genomic bin size
  --array-id JOBARRAY   If --rna_cell is not specified, it will use the
                        specified environmental variable to select one of the
                        files in --dnase_path
  --merge-chips         The table will contain one column for each cell type
                        with ChIP-seq of transcription factor (from --ref-
                        dir).Specify --merge-chips to replace these columns
                        with one column named 'PreviousBinding' which is the
                        row sum of all publicly available ChIP-seq data.

required named arguments:
  --chromsize-path CHROMLEN
                        File with chromosome sizes in 2-column format
  --dnase-path DNASE    Chromatin accessibility narrow peak file

Citation: Karimzadeh M. and, Hoffman MM. 2017. Virtual ChIP-seq: predicting
transcription factor binding by learning from the transcriptome. In prep.
```


## Prediction
```
usage: virchip-predict.py [-h] model-dir table-path out-path tf

Predict TF binding using a trained model stored in joblib format.The joblib
object must be a dictionary with feature names stored with key name 'Features'
and the scikit-learn modelstored with key name 'Model'

positional arguments:
  model-dir   Directory with <TF>.joblib.pickle files. Each file contains a
              dictionary which can be loaded using joblib, and has a
              'Features' key which contains list of features used for training
              the classifier, and 'Model' which is a scikit-learn classifier
              object
  table-path  Path to table generated by virchip-make-input-data
  out-path    Output file with posterior probability
  tf          Name of TF

optional arguments:
  -h, --help  show this help message and exit

Citation: Karimzadeh M. and, Hoffman MM. 2017. Virtual ChIP-seq: predicting
transcription factor binding by learning from the transcriptome. In prep.
```



## Training
```
usage: virchip-train.py [-h] --train-dirs [TRAINING [TRAINING ...]]
                        --train-cells [CELLS [CELLS ...]] [--NJOBS NJOBS]
                        [--test-frac FRACTION]
                        [--exclude-vars [EXCLUDE [EXCLUDE ...]]]
                        [--merge-chips]
                        [--hidden-layers [NLAYERS [NLAYERS ...]]]
                        [--hidden-units [NUNITS [NUNITS ...]]]
                        [--activation-functions [ACTIVATION [ACTIVATION ...]]]
                        [--regularization [L2 [L2 ...]]]
                        tf out-dir

Train the Virtual ChIP-seq model on randomly selected regions from severalcell
types. Saves the trained model and feature names in a dictionary using joblib.
--train_dirs files can be generated with virchip-make-input-data and must have
one column named as <Cell>.<TF>. Columns corresponding to other ChIP-seq
experiments must also follow <Cell>.<TF> format. Columns corresponding to
sequence motif scores must follow JASPAR.<TfName>_<MotifID> format. Other
expected columns are: ExpScore, NarrowPeakSignal, and Conservation.

positional arguments:
  tf                    Name of TF
  out-dir               Directory for writing output files

optional arguments:
  -h, --help            show this help message and exit
  --NJOBS NJOBS         Number of parallel SMP processes
  --test-frac FRACTION  The fraction of dataset to be used for validation.
  --exclude-vars [EXCLUDE [EXCLUDE ...]]
                        Specify variables to exclude. Choices are exact name
                        of the columns in --train-dirs files, or the word
                        'motif' (accepts multiple space separated arguments).
                        By specifying the word 'chip', no ChIP-seq data of
                        other cell lines will be used.
  --merge-chips         If specified, will merge ChIP-seq data of other cell
                        types into one column. Assumes these columns are in
                        <cell>.<tf> format.

required named arguments:
  --train-dirs [TRAINING [TRAINING ...]]
                        Path to folders with file names as
                        <chrom>_<tf>_<cell>_... which can be made using
                        virchip-make-input-data. Make sure each folder
                        excludes ChIP-seq data of the training cell type. For
                        example, if the first folder corresponds to K562, you
                        shouldn't use any ChIP-seq data of K562 in calculating
                        expression score.
  --train-cells [CELLS [CELLS ...]]
                        Name of training cell types (expects same order as
                        --train_dirs)

Multi-layer perceptron architecture options:
  --hidden-layers [NLAYERS [NLAYERS ...]]
                        Space separated number of hidden layers for grid
                        search
  --hidden-units [NUNITS [NUNITS ...]]
                        Space separated number of hidden units for grid search
  --activation-functions [ACTIVATION [ACTIVATION ...]]
                        Space separated name of activation functions for grid
                        search. Must be supported by sickitlearn MLP
  --regularization [L2 [L2 ...]]
                        Space separated floats for regularization of MLP used
                        for grid search

Citation: Karimzadeh M. and, Hoffman MM. 2017. Virtual ChIP-seq: predicting
transcription factor binding by learning from the transcriptome. In prep.
```
