# Here we show one example for using each of the scripts

wget https://www.pmgenomics.ca/hoffmanlab/proj/virchip/data/virchip-startup-data.tar.gz
tar -xvf virchip-startup-data.tar.gz

## Using virchip-make-input-data.py
TF=NRF1
CHROM=chr21
CELL=K562
OUTPATH=data/$TF\_$CHROM\_CompleteTable.tsv.gz
CHIPEXPDIR=data/ChipExpMats/$TF
RNAPATH=data/$CELL\_RNA.tsv.gz
REFDIR=data/RefDir
CHROMLEN=data/hg38_chrsize.tsv
BLACKLIST=data/hg38_EncodeBlackListedRegions_200bpBins.bed.gz
DNASE=data/K562_dnase.tsv.gz

python virchip-make-input-data.py\
    $TF $OUTPATH $CHIPEXPDIR $RNAPATH $REFDIR\
    --rna-cell $CELL --blacklist_path $BLACKLIST\
    --bin_size 200 --merge-chips --chromsize-path $CHROMLEN\
    --dnase-path $DNASE


## Using virchip-predict.py
TF=NRF1
CHROM=chr21
CELL=K562
MODELDIR=data/trainedModels
TABLEPATH=data/$TF\_$CHROM\_CompleteTable.tsv.gz
OUTPATH=data/PredictionsIn_$CELL\_$CHROM\.tsv.gz
python virchip-predict.py $MODELDIR $TABLEPATH $OUTPATH $TF


## Using virchip-train.py
TF=NRF1
OUTDIR=data
TRAINDIRS=(data/trainDirs/GM12878 data/trainDirs/K562)
TRAINCELLS=(GM12878 K562)
python virchip-train.py $TF $OUTDIR --NJOBS 1 --test-frac 0.01 --merge-chips --train-dirs ${TRAINDIRS[0]} --train-cells ${TRAINCELLS[0]} --hidden-layers 5 20 --hidden-units 10 --activation-functions logistic --regularization 0.001 0.01
