# Welcome to pycoQC documentation

![summary](pictures/pycoQC_long.svg)

**PycoQC computes metrics and generates interactive QC plots for Oxford Nanopore technologies sequencing data**

PycoQC relies on the *sequencing_summary.txt* file generated by Albacore and Guppy, but if needed it can also generates a summary file from basecalled fast5 files. The package supports 1D and 1D2 runs generated with Minion, Gridion and Promethion devices and basecalled with Albacore 1.2.1+ or Guppy 2.1.3+. PycoQC is written in pure Python3. **Python 2 is not supported**.


## Gallery

![summary](pictures/summary.gif)

![reads_len_1D_example](pictures/reads_len_1D.gif)]

![reads_len_1D_example](pictures/reads_qual_1D.gif)]

![reads_qual_len_2D_example](pictures/reads_qual_len_2D.gif)

![channels_activity](pictures/channels_activity.gif)

![output_over_time](pictures/output_over_time.gif)

![qual_over_time](pictures/qual_over_time.gif)

![len_over_time](pictures/len_over_time.gif)

![align_len](pictures/align_len_1D.gif)

![align_score](pictures/align_score_1D.gif)

![align_score_len_2D](pictures/align_score_len_2D.gif)

![alignment_coverage](pictures/alignment_coverage.gif)

![alignment_rate](pictures/alignment_rate.gif)

![alignment_summary](pictures/alignment_summary.gif)


## Example HTML reports

* [Albacore_all_RNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore_all_RNA.html)

* [Guppy-2.1.3_basecall-1D_RNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Guppy-2.1.3_basecall-1D_RNA.html)

* [Guppy-2.3_basecall-1D_alignment-DNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Guppy-2.3_basecall-1D_alignment-DNA.html)

* [Albacore-1.2.1_basecall-1D-DNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore-1.2.1_basecall-1D-DNA.html)

* [Guppy-2.1.3_basecall-1D_DNA_barcode](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Guppy-2.1.3_basecall-1D_DNA_barcode.html)

* [Albacore-1.7.0_basecall-1D-DNA_API](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore-1.7.0_basecall-1D-DNA_API.html)

* [Albacore-2.1.10_basecall-1D-DNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore-2.1.10_basecall-1D-DNA.html)

* [Albacore-1.7.0_basecall-1D-DNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore-1.7.0_basecall-1D-DNA.html)


## Example JSON reports

* [Guppy-2.3_basecall-1D_alignment-DNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Guppy-2.3_basecall-1D_alignment-DNA.json)

* [Guppy-2.1.3_basecall-1D_RNA](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Guppy-2.1.3_basecall-1D_RNA.json)

* [Albacore-1.7.0_basecall-1D-DNA_API](https://a-slide.github.io/pycoQC/demo/results/pycoQC/Albacore-1.7.0_basecall-1D-DNA_API.json)
