# Contributing to pycoQC

First of all, thanks for considering contributing to `pycoQC`! 👍 It's people like you that make it rewarding for us to work on `pycoQC`.

`pycoQC` is an open source project, maintained by publicly funded academic researchers.

[repo]: https://github.com/a-slide/pycoQC
[issues]: https://github.com/a-slide/pycoQC/issues
[new_issue]: https://github.com/a-slide/pycoQC/issues/new
[citation]: https://zenodo.org/record/2540931
[email]: aleg@ebi.ac.uk
[code_of_conduct]: https://github.com/a-slide/pycoQC/blob/master/CODE_OF_CONDUCT.md
[demo_notebook]: https://a-slide.github.io/pycoQC/pycoQC_usage.html

## Code of conduct

Please note that this project is released with a [Contributor Code of Conduct][code_of_conduct]. By participating in this project you agree to abide by its terms.

## How you can contribute

There are several ways you can contribute to this project. If you want to know more about why and how to contribute to open source projects like this one, see this [Open Source Guide](https://opensource.guide/how-to-contribute/).

### Share the love ❤️

Think `pycoQC` is useful? Let others discover it, by telling them in person, via Twitter or a blog post.

Using `pycoQC` for a paper you are writing? Please cite it.

### Ask a question ⁉️

Using `pycoQC` and got stuck? Browse the [documentation][https://a-slide.github.io/pycoQC/] to see if you can find a solution.

Still stuck? Post your question as an [issue on GitHub][new_issue] or you can chat with the developers using our [gitter chat room](https://gitter.im/pycoQC/community?utm_source=share-link&utm_medium=link&utm_campaign=share-link)

While we cannot offer user support, we'll try to do our best to address it, as questions often lead to better documentation or the discovery of bugs.

Want to ask a question in private? Contact the package maintainer by [email][email].

### Propose an idea 💡

Have an idea for a new `pycoQC` feature? Take a look at the [issue list][issues] to see if it isn't included or suggested yet. If not, suggest your idea as an [issue on GitHub][new_issue]. While we can't promise to implement your idea, it helps to:

* Explain in detail how it would work.
* Keep the scope as narrow as possible.

See below if you want to contribute code for your idea as well.

### Report a bug 🐛

Using `pycoQC` and discovered a bug? That's annoying! Don't let others have the same experience and report it as an [issue on GitHub][new_issue] so we can fix it. A good bug report makes it easier for us to do so, so please include:

* Your operating system name and version (e.g. Mac OS 10.13.6).
* Any details about your local setup that might be helpful in troubleshooting.
* Detailed steps to reproduce the bug.

### Improve the documentation 📖

Noticed a typo on the website? Think a function could use a better example? Good documentation makes all the difference, so your help to improve it is very welcome!

1. Fork [this repo][repo] and clone it to your computer. To learn more about this process, see [this guide](https://guides.github.com/activities/forking/).
2. Edit the README.md file and submit a pull request. We will review your changes and include the fix in the next release.

### Contribute code 📝

Care to fix bugs or implement new functionality for `pycoQC`? Awesome! 👏 Have a look at the [issue list][issues] and leave a comment on the things you want to work on. See also the development guidelines below.

## Development guidelines

We try to follow the [GitHub flow](https://guides.github.com/introduction/flow/) for development and the [PEP 8](https://www.python.org/dev/peps/pep-0008/) style Guide for Python Code.

1. Fork [this repo][repo] and clone it to your computer. To learn more about this process, see [this guide](https://guides.github.com/activities/forking/).

2. If you have forked and cloned the project before and it has been a while since you worked on it, [pull changes from the original repo](https://help.github.com/articles/merging-an-upstream-repository-into-your-fork/) to your clone by using `git pull upstream master`.

3. Make your changes and test the modified code.

4. Commit and push your changes.

5. Submit a [pull request](https://guides.github.com/activities/forking/#making-a-pull-request).



---

This file was adapted from a template created by [peterdesmet](https://gist.github.com/peterdesmet/e90a1b0dc17af6c12daf6e8b2f044e7c).
