#!/bin/sh

# Use repo2docker to build the image from the workspace
docker run  \
  -v /var/run/docker.sock:/var/run/docker.sock \
  -v `pwd`/data/workspace:/WholeTale/workspace \
  --privileged=true \
  -e DOCKER_HOST=unix:///var/run/docker.sock \
  wholetale/repo2docker:latest \
  jupyter-repo2docker \
    --target-repo-dir=/WholeTale/workspace \
    --template=base.tpl \
    --buildpack-name=PythonBuildPack \
    --user-id=1000 --user-name=jovyan \
    --no-clean --no-run --debug \
    --image-name wholetale/tale_5cb4ffead9323600016c4d4c \
    /WholeTale/workspace

docker run --rm \
    -v `pwd`:/bag \
    -ti jfloff/alpine-python:2.7-slim \
      -p bdbag -- bdbag --resolve-fetch all /bag

echo "========================================================================"
echo " Open your browser and go to: http://localhost:8888/?token=wholetale "
echo "========================================================================"

# Run the built image
docker run -p 8888:8888 \
  -v `pwd`/data/data:/WholeTale/data \
  -v `pwd`/data/workspace:/WholeTale/workspace \
  wholetale/tale_5cb4ffead9323600016c4d4c jupyter notebook --no-browser --port 8888 --ip=0.0.0.0 --NotebookApp.token=wholetale --NotebookApp.base_url=/ --NotebookApp.port_retries=0

