#!/bin/bash
#

export SCRIPT_DIR=$(pwd)/src
DATA_DIR=$(pwd)/data

mkdir -p data

cd import

while read tag ; do
	git checkout -f $tag
	DATA_FILE=$DATA_DIR/$(echo $tag | sed 's|/|_|g').txt
	find . -name \*.c -type f -print0 |
	parallel -n 1 --gnu -d '\0' $SCRIPT_DIR/file-analyze.sh >$DATA_FILE
done <$SCRIPT_DIR/tag-list
